<?php

/*
 * Copyright (C) xgcms.com
 */

// 调试模式: 1 打开，0 关闭
define('DEBUG', class_exists('SaeKV') ? 2 : 0);
include './function.php';

// 站点根目录
define('POST_PATH', xn_realpath(substr(__FILE__, 0, -9).'../'));

// 框架的物理路径
$conf = include POST_PATH.'conf/conf.php';
if(empty($conf)) {
	message('<h3>读取配置文件失败，请检查配置文件是否存在并且有可读权限：'.POST_PATH.'conf/conf.php'.'</h3>');
}

// PHP 版本判断
if(version_compare(PHP_VERSION, '5.0.0') == -1) {
	message('<h3>非常抱歉，您的PHP版本太低 ('.PHP_VERSION.')，达不到最低安装要求 (5.0.0)</h3>');
}

if(!DEBUG && is_file($conf['upload_path'].'install.lock')) {
	message('已经安装过，如果需要重新安装，请删除 upload/install.lock 文件。');
}

define('FRAMEWORK_PATH', POST_PATH.'core/xiunophp/');
define('FRAMEWORK_TMP_PATH', $conf['tmp_path']);
define('FRAMEWORK_LOG_PATH', $conf['log_path']);
include FRAMEWORK_PATH.'core.php';
core::init($conf);
include POST_PATH.'core/model/member.class.php';
include POST_PATH.'core/model/forum.class.php';
include POST_PATH.'core/model/topic.class.php';
include POST_PATH.'core/model/post.class.php';
include POST_PATH.'core/model/kv.class.php';
include POST_PATH.'core/model/runtime.class.php';

//make_tmp($conf);exit;

IN_SAE && $conf['upload_path'] = 'saestor://upload/';

$step = isset($_GET['step']) ? $_GET['step'] : '';

if(empty($step) || $step == 'checklicense') {
	include './step_1.php';
	exit;
} elseif($step == '2') {
	$env = $write = array();
	get_env($env, $write);
	if(IN_SAE) {
		$saestorage = new SaeStorage();
		$n = $saestorage->getDomainCapacity('upload');
		$saewrite['upload_path'] = $n !== NULL && $saestorage->errno() != -7;
		
		$kv = new SaeKV();
		$saewrite['tmp_path'] = 1;
	}
	include './step_3.php';
	exit;
} elseif($step == '4') {
	
/*	define('FRAMEWORK_PATH', POST_PATH.'core/xiunophp/');
	define('FRAMEWORK_TMP_PATH', $conf['tmp_path']);
	define('FRAMEWORK_LOG_PATH', $conf['log_path']);
	include FRAMEWORK_PATH.'core.php';
	core::init();
	core::ob_start();*/
	


	// 检测 mysql_connnect, mongodb, pdo 扩展情况
	$mysql_support = function_exists('mysql_connect');
	$mongodb_support = extension_loaded('Mongo');
	$pdo_support = extension_loaded('PDO');
	
	$type = core::gpc('type', 'G');
	empty($type) && $type = 'mysql';
	
	if(core::gpc('FORM_HASH', 'P')) {
		$host = core::gpc('host', 'P');
		$user = core::gpc('user', 'P');
		$pass = core::gpc('pass', 'P');
		$name = core::gpc('name', 'P');
		$tablepre = core::gpc('tablepre', 'P');
		$adminuser = core::gpc('adminuser', 'P');
		$adminpass = core::gpc('adminpass', 'P');
		$adminpass2 = core::gpc('adminpass2', 'P');
		$error = '';
		if($type == 'mysql') {
			$link = @mysql_connect($host, $user, $pass, TRUE);
			if(!$link) {
				$error = 'MySQL 账号密码可能有误：<span class="small">'.mysql_error().'</span>';
			} else {
				$r = mysql_select_db($name);
				if(mysql_errno() == 1049) {
					mysql_query("CREATE DATABASE $name");
					$r = mysql_select_db($name);
				}
				if(!$r) {
					$error = 'MySQL 账户权限可能受限：<span class="small">'.mysql_error().mysql_errno().'</span>';
				} else {
					$conf['db']['mysql'] = array(
						// 主 MySQL Server
						'master' => array (
								'host' => $host,
								'user' => $user,
								'password' => $pass,
								'name' => $name,
								'charset' => 'utf8',
								'tablepre' => $tablepre,
								'engine'=>'MyISAM',
						),
						// 从 MySQL Server
						'slaves' => array (
						)
					);
					$db = new db_mysql($conf['db']['mysql']);
					
					$s = file_get_contents(POST_PATH.'install/post.sql');
					
					$s = str_replace("\r\n", "\n", $s);
					$s = preg_replace('#\n\#[^\n]*?\n#is', "\n", $s);	// 去掉注释行
					$sqlarr = explode(";\n", $s);
					
					foreach($sqlarr as $sql) {
						if(trim($sql)) {
							$sql = str_replace('xg_', $tablepre, $sql);
							try {
								$db->query($sql);
							} catch (Exception $e) {
								$error = $e->getMessage();
								break;
							}
						}
					}
					
					$db->truncate('framework_count');
					$db->truncate('framework_maxid');
					
				}
			}
		}
		
		if(!$error) {
			
			// 预设 count maxid
			$db->count('group', 16);
			$db->maxid('group-groupid', 15);
			$db->count('member', 2);
			$db->maxid('member-uid', 10);	// 内置10个账户，方便扩展
			$db->count('forum', 3);
			$db->maxid('forum-fid', 3);
			$db->count('category', 6);
			$db->maxid('category-id', 6);
			$db->truncate('kv');
			$db->truncate('runtime');
			
			// db 写入配置文件
			$configfile = POST_PATH.'conf/conf.php';
			$replacearr = array('user'=>$user, 'host'=>$host, 'password'=>$pass, 'name'=>$name, 'tablepre'=>$tablepre);
			$s = file_get_contents($configfile);
			if($type == 'mysql') {
				$s = str_line_replace($s, 18, 30, $replacearr);
			} elseif($type == 'pdo') {
				$s = str_line_replace($s, 31, 43, $replacearr);
			} elseif($type == 'mongodb') {
				$s = str_line_replace($s, 44, 54, $replacearr);
			}
			$typearr = array('type'=>$type);
			$s = str_line_replace($s, 17, 18, $typearr);
			
			$url = misc::get_url_path();
			$public_key = md5(rand(1, 10000000).$_SERVER['ip']);
			//$s = file_get_contents($configfile);
			$appurl = substr($url, 0, -8); // 带 /
			
			$plugin_path = "POST_PATH.'plugin/',";
			$plugin_url = "{$appurl}plugin/";
			$conf['plugin_path'] = POST_PATH.'plugin/';
			$tmp_path = "POST_PATH.'runtime/tmp/',";
			$conf['tmp_path'] = POST_PATH.'runtime/tmp/';
			if(!IN_SAE) {
				$upload_path = "POST_PATH.'upload/',";
				$upload_url = "{$appurl}upload/";
				$conf['upload_path'] = POST_PATH.'upload/';
			} else {
				$saestorage = new saestorage();
				$upload_path = "'saestor://upload/',";
				$upload_url = $saestorage->geturl('upload', '');
				$conf['upload_path'] = 'saestor://upload/';
			}
			
			$s = preg_replace('#\'app_url\'\s*=\>\s*\'?.*?\'?,#is', "'app_url' => '$appurl',", $s);
			$s = preg_replace('#\'static_url\'\s*=\>\s*\'?.*?\'?,#is', "'static_url' => '$appurl',", $s);

			$s = preg_replace('#\'upload_url\'\s*=\>\s*\'?.*?\'?,#is', "'upload_url' => '$upload_url',", $s);
			$s = preg_replace('#\'upload_path\'\s*=\>\s*\'?.*?\'?,#is', "'upload_path' => ".$upload_path, $s);
			$s = preg_replace('#\'plugin_path\'\s*=\>\s*\'?.*?\'?,#is', "'plugin_path' => ".$plugin_path, $s);
			$s = preg_replace('#\'plugin_url\'\s*=\>\s*\'?.*?\'?,#is', "'plugin_url' => '$plugin_url',", $s);
			$s = preg_replace('#\'tmp_path\'\s*=\>\s*\'?.*?\'?,#is', "'tmp_path' => $tmp_path", $s);
			
			$s = preg_replace('#\'click_server\'\s*=\>\s*\'?.*?\'?,#is', "'click_server' => '{$appurl}service/clickd/',", $s);
			$s = preg_replace('#\'auth_key\'\s*=\>\s*\'?.*?\'?,#is', "'auth_key' => '$public_key',", $s);
			$s = preg_replace('#\'urlrewrite\'\s*=\>\s*\'?.*?\'?,#is', "'urlrewrite' => ".(IN_SAE ? 1 : 0).",", $s);
			$s = preg_replace('#\'installed\'\s*=\>\s*\'?.*?\'?,#is', "'installed' => 1,", $s);
			
			//file_put_contents($configfile, $s);
			// 修改密码
			$muser = new member($conf);
			$admin = $db->get("member-uid-1");
			$admin['username'] = $adminuser;
			$admin['securekey'] = rand(100000, 999999);
			$admin['password'] = $muser->md5_md5($adminpass, $admin['securekey']);
			$db->set("member-uid-1", $admin);
			
			$u = $db->get("member-uid-2");
			$u['groupid'] = 11;
			$u['securekey'] = $admin['securekey'];
			$u['password'] = $admin['password'];
			$db->set("member-uid-2", $u);

			// 初始化 upload 目录
			if(!IN_SAE) {
				!is_dir($conf['upload_path'].'forum') && mkdir($conf['upload_path'].'forum', 0777);
				!is_dir($conf['upload_path'].'avatar') && mkdir($conf['upload_path'].'avatar', 0777);
				!is_dir($conf['upload_path'].'friendlink') && mkdir($conf['upload_path'].'friendlink', 0777);
				!is_dir($conf['upload_path'].'attach') && mkdir($conf['upload_path'].'attach', 0777);
				!is_dir($conf['upload_path'].'plugin') && mkdir($conf['upload_path'].'plugin', 0777);
			}
			
			// 清理
			!IN_SAE && clear_tmp('', $conf['tmp_path']);
			
			// 生成全局配置\
			$kv = new kv($conf);
			$kvconf = array(
				'app_name' => '星光贴吧',		// 站点名称
				'timeoffset' => '+8',
				'forum_index_pagesize' => 20,		// 列表页的 pagesie，可以修改，建议不要超出100。
				'cookie_keeptime' => 86400,
				'site_pv' => 100000,			// PV越高CACHE更新的越慢，该值会影响系统的负载能力
				'site_runlevel' => 0,			// 0:所有人均可访问; 1: 仅会员访问; 2:仅版主可访问; 3: 仅管理员
				'threadlist_hotviews' => 200,		// 热门主题的阀值，浏览数
				'seo_title' => '星光贴吧',		// 论坛首页的 title，如果不设置则为论坛名称
				'seo_keywords' => '星光贴吧',		// 论坛首页的 keyword
				'seo_description' => '星光贴吧',	// 论坛首页的 description
				'search_type' => 'title',		// title|baidu|google|bing|sphinx
				'china_icp' => '',			// icp 备案号，也只有在这神奇的国度有吧。
				'app_copyright' => '© 2008-2010 XGCMS.COM',
				'footer_js' => '<script type="text/javascript">
var _bdhmProtocol = (("https:" == document.location.protocol) ? " https://" : " http://");
document.write(unescape("%3Cscript src=\'" + _bdhmProtocol + "hm.baidu.com/h.js%3F1e5d1416f7288c413e2866d160572e1d\' type=\'text/javascript\'%3E%3C/script%3E"));
</script>',			// 页脚额外的代码，放用于统计JS之类代码。
				'iptable_on' => 0,			// IP 规则，白名单，黑名单
				'badword_on' => 0,			// 关键词过滤
				'online_hold_time' => 1800,		// 在线时间，30分钟
				'post_update_expiry'=>86400,
				'reg_on'=>1,
				'pagesize'=>30,
				'url_forum'=>'forum-index-fid-[fid].htm|forum-index-fid-[fid]-page-[page].htm',
				'url_topic'=>'topic-index-fid-[fid]-tid-[tid].htm|topic-index-fid-[fid]-tid-[tid]-page-[page].htm'
			);
			$kv->set('conf', $kvconf);
			
			// 生成局部配置
			$kvconf = array(
				'credits_policy_thread' => 2,		// 发主题增加的积分
				'credits_policy_post' => 0,		
				'golds_policy_thread' => 1,		// 发主题增加的金币 golds（积分不能消费，金币可以消费，充值）
				'golds_policy_post' => 1,		
				'post_update_expiry' => 86400 * 7,		// 帖子多长时间后不能修改，默认为86400，一天，0不限制
				'sphinx_host' => '',			// 主机
				'sphinx_port' => '',			// 端口
				'sphinx_datasrc' => '',			// 数据源
				'sphinx_deltasrc' => '',		// 增量索引数据源，优先搜索这个
				'reg_on' => 1,				// 是否开启注册
				'reg_email_on' => 0,			// 是否开启Email激活
				'reg_init_golds' => 10,			// 注册初始化金币
				'resetpw_on' => 0,			// 是否开启密码找回
				'credits_policy_digest_1' => 10,		
				'credits_policy_digest_2' => 20,		
				'credits_policy_digest_3' => 30,		
				'golds_policy_digest_1' => 10,		
				'golds_policy_digest_2' => 20,		
				'golds_policy_digest_3' => 30,		
			);
			$kv->set('conf_ext', $kvconf);
			
			$runtime = new runtime($conf);
			$runtime->truncate();
			
			if(!misc::is_writable($configfile)) {
				include './step_sae.php';
				if(IN_SAE) {
					echo '<h3>SAE 环境下安装需要手工编辑 conf/conf.php，复制以下代码，粘帖到 conf/conf.php：</h3>';
					echo '<div><textarea style="width: 700px; height: 400px">'.$s.'</textarea></div>';
					echo '<div>【注意】 需要使用UTF-8编辑器，请不要使用WINDOWS 记事本！</div>';
					
					echo '<div><input type="submit" value=" 下一步" name="formsubmit" onclick="window.location=\'index.php?step=saedown\'" /></div>';
					exit;
				} else {
					echo '<h3>当前的配置文件不可写，需要手工编辑 conf/conf.php，复制以下代码，粘帖到 conf/conf.php：</h3>';
					echo '<div><textarea style="width: 700px; height: 400px">'.$s.'</textarea></div>';
					echo '<div>【注意】 需要使用UTF-8编辑器，请不要使用WINDOWS 记事本！</div>';
					echo '<div><input type="submit" value=" 下一步" name="formsubmit" onclick="window.location=\'index.php?step=complete\'" /></div>';
					exit;
				}
			} else {
				file_put_contents($configfile, $s);
			}
		}
	}
	
	$master = $conf['db'][$type]['master'];
	if(IN_SAE && ($type == 'mysql' || $type == 'pdo_mysql') && empty($_POST)) {
		$master['host'] = SAE_MYSQL_HOST_M.(SAE_MYSQL_PORT == 3306 ? '' : ':'.SAE_MYSQL_PORT);// SAE_MYSQL_HOST_S
		$master['user'] = SAE_MYSQL_USER;
		$master['password'] = SAE_MYSQL_PASS;
		$master['name'] = SAE_MYSQL_DB;
	}
	include './step_4.php';	
	exit;
} elseif($step == '5') {
	
	is_file($conf['upload_path'].'plugin.json') && unlink($conf['upload_path'].'plugin.json');
	file_put_contents($conf['upload_path'].'install.lock', '');
	
	if(IN_SAE && !is_file($conf['tmp_path'].'_runtime.php')) {
		message('SAE 环境下需要手工上传 tmp 文件夹，请返回上一步，下载 tmp.zip ，解压后上传到服务器。', 'javascript:history:back();');
	}
	// 设置 cookie
	header('Content-Type: text/html; charset=UTF-8');
	echo '<h1>安装完成，点击<a href="../">【跳转到首页】</a>！</h1>';
	echo '<h3>安装完成，为了安全请删除 install 目录</h3><script>setTimeout(function() {window.location="../";}, 3000);</script>';
	exit;

	
}elseif($step == 'saedown') {
	// 检查 tmp 目录是否为空
	if(IN_SAE) {
		// 关闭所有插件
		$file = $conf['upload_path'].'plugin.json';
		file_exists($file) && unlink($file); // 删除 plugin.json
		file_put_contents($file, '');
		
		// 生成 tmp
		core::get_plugins($conf, 1); // 清空缓存
		make_tmp($conf);
		message('SAE 环境安装，此步需要手工安装，点击<a href="'.$conf['upload_url'].'tmp.zip'.'" target="_blank"><b>【下载压缩包:tmp.zip】</b></a>，解压后，将文件上传到 tmp 目录，完成点击<a href="?step=5"><b>【下一步】</b></a>。');
	}
	
}elseif($step=='upgrade'){

}
