
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


-- --------------------------------------------------------

--
-- 表的结构 `le_address`
--

DROP TABLE IF EXISTS `le_address`;
CREATE TABLE IF NOT EXISTS `le_address` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT '0',
  `trueName` varchar(32) NOT NULL DEFAULT '',
  `province` varchar(32) NOT NULL DEFAULT '',
  `city` varchar(32) NOT NULL DEFAULT '',
  `addressDetail` varchar(32) NOT NULL DEFAULT '',
  `postcode` varchar(32) NOT NULL DEFAULT '',
  `cellphone` varchar(32) NOT NULL DEFAULT '',
  `flag` int(2) DEFAULT NULL,
  PRIMARY KEY (`aid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='本地化' AUTO_INCREMENT=2 ;

--
-- 转存表中的数据 `le_address`
--


-- --------------------------------------------------------

--
-- 表的结构 `le_area`
--

DROP TABLE IF EXISTS `le_area`;
CREATE TABLE IF NOT EXISTS `le_area` (
  `areaid` int(11) NOT NULL AUTO_INCREMENT,
  `areaname` varchar(32) NOT NULL DEFAULT '',
  `zm` char(1) NOT NULL DEFAULT '' COMMENT '首字母',
  `referid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`areaid`),
  KEY `referid` (`referid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='本地化' AUTO_INCREMENT=355 ;

--
-- 转存表中的数据 `le_area`
--

INSERT INTO `le_area` (`areaid`, `areaname`, `zm`, `referid`) VALUES
(1, '浙江', 'Z', 0),
(2, '杭州', 'H', 1),
(3, '义乌', 'Y', 1),
(4, '金华', 'J', 1),
(5, '温州', 'W', 1),
(6, '安徽', 'A', 0),
(7, '北京', 'B', 0),
(8, '黄山', 'H', 6),
(9, '马鞍山', 'M', 6),
(10, '合肥', 'H', 6),
(12, '宁波', 'N', 1),
(13, '嘉兴', 'J', 1),
(14, '湖州', 'H', 1),
(15, '绍兴', 'S', 1),
(16, '衢州', '', 1),
(17, '舟山', 'Z', 1),
(18, '台州', 'T', 1),
(19, '丽水', 'L', 1),
(20, '六安', 'L', 6),
(21, '芜湖', 'W', 6),
(22, '淮南', 'H', 6),
(23, '滁州', 'C', 6),
(24, '淮北', 'H', 6),
(25, '铜陵', 'T', 6),
(26, '安庆', 'A', 6),
(27, '阜阳', 'F', 6),
(28, '蚌埠', 'B', 6),
(29, '宿州', 'S', 6),
(30, '亳州', '', 6),
(31, '宣城', 'X', 6),
(32, '巢湖', 'C', 6),
(33, '东城区', 'D', 7),
(34, '西城区', 'X', 7),
(35, '海淀区', 'H', 7),
(36, '朝阳区', 'C', 7),
(37, '丰台区', 'F', 7),
(38, '石景山区', 'S', 7),
(39, '通州区', 'T', 7),
(40, '顺义区', 'S', 7),
(41, '房山区', 'F', 7),
(42, '大兴区', 'D', 7),
(43, '昌平区', 'C', 7),
(44, '怀柔区', 'H', 7),
(45, '平谷区', 'P', 7),
(46, '门头沟区', 'M', 7),
(47, '密云县', 'M', 7),
(48, '延庆县', 'Y', 7),
(49, '天津', 'T', 0),
(50, '重庆', 'Z', 0),
(51, '上海', 'S', 0),
(52, '河北', 'H', 0),
(53, '陕西', 'S', 0),
(54, '山西', 'S', 0),
(55, '辽宁', 'L', 0),
(56, '吉林', 'J', 0),
(57, '黑龙江', 'H', 0),
(58, '江苏', 'J', 0),
(59, '福建', 'F', 0),
(60, '广东', 'G', 0),
(61, '广西', 'G', 0),
(62, '江西', 'J', 0),
(63, '湖南', 'H', 0),
(64, '贵州', 'G', 0),
(65, '云南', 'Y', 0),
(66, '湖南', 'H', 0),
(67, '湖北', 'H', 0),
(68, '山东', 'S', 0),
(69, '四川', 'S', 0),
(70, '青海', 'Q', 0),
(71, '甘肃', 'G', 0),
(72, '西藏', 'X', 0),
(73, '内蒙古', 'N', 0),
(74, '新疆', 'X', 0),
(75, '河南', 'H', 0),
(76, '海南', 'H', 0),
(77, '香港', 'X', 0),
(78, '澳门', 'A', 0),
(79, '台湾', 'T', 0),
(80, '宁夏', 'N', 0),
(81, '石家庄', 'S', 52),
(82, '保定', 'B', 52),
(83, '邯郸', 'H', 52),
(84, '秦皇岛', 'Q', 52),
(85, '张家口', 'Z', 52),
(86, '唐山', 'T', 52),
(87, '承德', 'C', 52),
(88, '廊坊', 'L', 52),
(89, '沧州', 'C', 52),
(90, '衡水', 'H', 52),
(91, '邢台', 'X', 52),
(92, '西安', 'X', 53),
(93, '宝鸡', 'B', 53),
(94, '咸阳', 'X', 53),
(95, '渭南', 'W', 53),
(96, '铜川', 'T', 53),
(97, '延安', 'Y', 53),
(98, '榆林', 'Y', 53),
(99, '汉中', 'H', 53),
(100, '安康', 'A', 53),
(101, '商洛', 'S', 53),
(102, '太原', 'T', 54),
(103, '大同', 'D', 54),
(104, '阳泉', 'Y', 54),
(105, '长治', 'C', 54),
(106, '晋城', 'J', 54),
(107, '朔州', 'S', 54),
(108, '晋中', 'J', 54),
(109, '运城', 'Y', 54),
(110, '忻州', 'X', 54),
(111, '临汾', 'L', 54),
(112, '吕梁', 'L', 54),
(113, '沈阳', 'S', 55),
(114, '大连', 'D', 55),
(115, '鞍山', 'A', 55),
(116, '抚顺', 'F', 55),
(117, '本溪', 'B', 55),
(118, '丹东', 'D', 55),
(119, '锦州', 'J', 55),
(120, '营口', 'Y', 55),
(121, '阜新', 'F', 55),
(122, '辽阳', 'L', 55),
(123, '盘锦', 'P', 55),
(124, '铁岭', 'T', 55),
(125, '朝阳', 'C', 55),
(126, '葫芦岛', 'H', 55),
(127, '长春', 'C', 56),
(128, '四平', 'S', 56),
(129, '辽源', 'L', 56),
(130, '通化', 'T', 56),
(131, '白山', 'B', 56),
(132, '松原', 'S', 56),
(133, '白城', 'B', 56),
(134, '延边', 'Y', 56),
(135, '哈尔滨', 'H', 57),
(136, '齐齐哈尔', 'Q', 57),
(137, '牡丹江', 'M', 57),
(138, '佳木斯', 'J', 57),
(139, '大庆', 'D', 57),
(140, '鸡西', 'J', 57),
(141, '双鸭山', 'S', 57),
(142, '伊春', 'Y', 57),
(143, '七台河', 'Q', 57),
(144, '鹤岗', 'H', 57),
(145, '黑河', 'H', 57),
(146, '绥化', 'S', 57),
(147, '大兴安岭', 'D', 57),
(148, '南京', 'N', 58),
(149, '无锡', 'W', 58),
(150, '徐州', 'X', 58),
(151, '常州', 'C', 58),
(152, '苏州', 'S', 58),
(153, '南通', 'N', 58),
(154, '连云港', 'L', 58),
(155, '淮安', 'H', 58),
(156, '盐城', 'Y', 58),
(157, '扬州', 'Y', 58),
(158, '镇江', 'Z', 58),
(159, '泰州', 'T', 58),
(160, '宿迁', 'S', 58),
(161, '福州', 'F', 59),
(162, '厦门', 'X', 59),
(163, '泉州', 'Q', 59),
(164, '莆田', 'P', 59),
(165, '三明', 'S', 59),
(166, '漳州', 'Z', 59),
(167, '南平', 'N', 59),
(168, '龙岩', 'L', 59),
(169, '宁德', 'N', 59),
(170, '广州', 'G', 60),
(171, '深圳', 'S', 60),
(172, '珠海', 'Z', 60),
(173, '汕头', 'S', 60),
(174, '佛山', 'F', 60),
(175, '韶关', 'S', 60),
(176, '湛江', 'Z', 60),
(177, '肇庆', 'Z', 60),
(178, '江门', 'J', 60),
(179, '茂名', 'M', 60),
(180, '惠州', 'H', 60),
(181, '梅州', 'M', 60),
(182, '汕尾', 'S', 60),
(183, '河源', 'H', 60),
(184, '阳江', 'Y', 60),
(185, '清远', 'Q', 60),
(186, '东莞', 'D', 60),
(187, '中山', 'Z', 60),
(188, '潮州', 'C', 60),
(189, '揭阳', 'J', 60),
(190, '云浮', 'Y', 60),
(191, '南宁', 'N', 61),
(192, '柳州', 'L', 61),
(193, '桂林', 'G', 61),
(194, '梧州', 'W', 61),
(195, '北海', 'B', 61),
(196, '防城巷', 'F', 61),
(197, '钦州', 'Q', 61),
(198, '贵港', 'G', 61),
(199, '玉林', 'Y', 61),
(200, '百色', 'B', 61),
(201, '贺州', 'H', 61),
(202, '河池', 'H', 61),
(203, '来宾', 'L', 61),
(204, '崇左', 'C', 61),
(205, '南昌', 'N', 62),
(206, '上饶', 'S', 62),
(207, '九江', 'J', 62),
(208, '萍乡', 'P', 62),
(209, '新余', 'X', 62),
(210, '鹰潭', 'Y', 62),
(211, '赣州', 'G', 62),
(212, '宜春', 'Y', 62),
(213, '景德镇', 'J', 62),
(214, '吉安', 'J', 62),
(215, '抚州', 'F', 62),
(216, '长沙', 'C', 63),
(217, '株洲', 'Z', 63),
(218, '衡阳', 'H', 63),
(219, '邵阳', 'S', 63),
(220, '岳阳', 'Y', 63),
(221, '张家界', 'Z', 63),
(222, '益阳', 'Y', 63),
(223, '常德', 'C', 63),
(224, '娄底', 'L', 63),
(225, '郴州', 'C', 63),
(226, '永州', 'Y', 63),
(227, '怀化', 'H', 63),
(228, '武汉', 'W', 67),
(229, '黄石', 'H', 67),
(230, '十堰', 'S', 67),
(231, '荆州', 'J', 67),
(232, '宜昌', 'Y', 67),
(233, '襄阳', 'X', 67),
(234, '鄂州', 'E', 67),
(235, '荆门', 'J', 67),
(236, '孝感', 'X', 67),
(237, '黄冈', 'H', 67),
(238, '咸宁', 'X', 67),
(239, '随州', 'S', 67),
(240, '恩施土家族苗族自治州', 'E', 67),
(241, '济南', 'J', 68),
(242, '青岛', 'Q', 68),
(243, '淄博', 'Z', 68),
(244, '枣庄', 'Z', 68),
(245, '东营', 'D', 68),
(246, '烟台', 'Y', 68),
(247, '潍坊', 'W', 68),
(248, '济宁', 'J', 68),
(249, '泰安', 'T', 68),
(250, '威海', 'W', 68),
(251, '日照', 'R', 68),
(252, '滨州', 'B', 68),
(253, '德州', 'D', 68),
(254, '聊城', 'L', 68),
(255, '临忻市', 'L', 68),
(256, '菏泽', 'H', 68),
(257, '莱芜', 'L', 68),
(258, '成都', 'C', 69),
(259, '自贡', 'Z', 69),
(260, '攀枝花', 'P', 69),
(261, '泸州', '', 69),
(262, '德阳', 'D', 69),
(263, '绵羊', 'M', 69),
(264, '广元', 'G', 69),
(265, '遂宁', 'S', 69),
(266, '内江', 'N', 69),
(267, '乐山', 'L', 69),
(268, '南充', 'N', 69),
(269, '宜宾', 'Y', 69),
(270, '眉山', 'M', 69),
(271, '广安', 'G', 69),
(272, '达州', 'D', 69),
(273, '雅安', 'Y', 69),
(274, '巴中', 'B', 69),
(275, '资阳', 'Z', 69),
(276, '西宁', 'X', 70),
(277, '海东地区', 'H', 70),
(278, '海北', 'H', 70),
(279, '黄南', 'H', 70),
(280, '果洛', 'G', 70),
(281, '玉树', 'Y', 70),
(282, '海西', 'H', 70),
(283, '兰州', 'L', 71),
(284, '嘉峪关', 'J', 71),
(285, '金昌市', 'J', 71),
(286, '白银市', 'B', 71),
(287, '天水', 'T', 71),
(288, '武威市', 'W', 71),
(289, '张掖', 'Z', 71),
(290, '酒泉', 'J', 71),
(291, '平凉市', 'P', 71),
(292, '庆阳', 'Q', 71),
(293, '定西市', 'D', 71),
(294, '陇南', 'L', 71),
(295, '临夏', 'L', 71),
(296, '甘南', 'G', 71),
(297, '拉萨', 'L', 72),
(298, '昌都', 'C', 72),
(299, '林芝', 'L', 72),
(300, '山南', 'S', 72),
(301, '日客则', 'R', 72),
(302, '那曲', 'N', 72),
(303, '阿里', 'A', 72),
(304, '呼和浩特', 'H', 73),
(305, '包头', 'B', 73),
(306, '乌海', 'W', 73),
(307, '赤峰', 'C', 73),
(308, '通辽', 'T', 73),
(309, '鄂尔多斯', 'E', 73),
(310, '呼伦贝尔', 'H', 73),
(311, '巴彦淖尔', 'B', 73),
(312, '乌兰察', 'W', 73),
(313, '吐鲁番', 'T', 74),
(314, '哈密', 'H', 74),
(315, '阿克苏', 'A', 74),
(316, '喀什', 'K', 74),
(317, '和田', 'H', 74),
(318, '阿勒台', 'A', 74),
(319, '郑州', 'Z', 75),
(320, '开封', 'K', 75),
(321, '平顶山', 'P', 75),
(322, '洛阳', 'L', 75),
(323, '商丘', 'S', 75),
(324, '安阳', 'A', 75),
(325, '新乡', 'X', 75),
(326, '许昌', 'X', 75),
(327, '鹤壁', 'H', 75),
(338, '焦作', 'J', 75),
(339, '濮阳', '', 75),
(340, '漯河', '', 75),
(341, '三门峡', 'S', 75),
(342, '周口', 'Z', 75),
(343, '南阳', 'N', 75),
(344, '南阳', 'N', 75),
(345, '信阳', 'X', 75),
(346, '济源', 'J', 75),
(347, '海口', 'H', 76),
(348, '三亚', 'S', 76),
(349, '三沙', 'S', 76),
(350, '银川', 'Y', 80),
(351, '石嘴山', 'S', 80),
(352, '吴忠市', 'W', 80),
(353, '固原', 'G', 80),
(354, '中卫市', 'Z', 80);

-- --------------------------------------------------------

--
-- 表的结构 `le_attach`
--

DROP TABLE IF EXISTS `le_attach`;
CREATE TABLE IF NOT EXISTS `le_attach` (
  `attachid` int(11) NOT NULL AUTO_INCREMENT COMMENT '附件ID',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `attachname` char(64) NOT NULL COMMENT '附件名字',
  `attachtype` char(32) NOT NULL DEFAULT '' COMMENT '附件类型',
  `attachurl` char(64) NOT NULL DEFAULT '' COMMENT '附件url',
  `attachsize` char(32) NOT NULL DEFAULT '' COMMENT '附件大小',
  `isshow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`attachid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='附件' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `le_daren`
--

DROP TABLE IF EXISTS `le_daren`;
CREATE TABLE IF NOT EXISTS `le_daren` (
  `darenid` int(11) NOT NULL AUTO_INCREMENT,
  `darenname` varchar(32) NOT NULL DEFAULT '',
  `background` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`darenid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='达人' AUTO_INCREMENT=6 ;

--
-- 转存表中的数据 `le_daren`
--

INSERT INTO `le_daren` (`darenid`, `darenname`, `background`) VALUES
(1, '健康达人', 'images/daren-1.png'),
(2, '美食达人', 'images/daren-2.png'),
(3, '美容美体达人', 'images/daren-3.png'),
(4, '配饰达人', 'images/daren-4.png'),
(5, '居家达人', 'images/daren-5.png');

-- --------------------------------------------------------

--
-- 表的结构 `le_diskyun_options`
--

DROP TABLE IF EXISTS `le_diskyun_options`;
CREATE TABLE IF NOT EXISTS `le_diskyun_options` (
  `optionid` int(11) NOT NULL AUTO_INCREMENT COMMENT '选项ID',
  `optionname` char(32) NOT NULL DEFAULT '' COMMENT '选项名字',
  `optionvalue` char(255) NOT NULL DEFAULT '' COMMENT '选项内容',
  PRIMARY KEY (`optionid`),
  UNIQUE KEY `optionname` (`optionname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='云储存配置' AUTO_INCREMENT=9 ;

--
-- 转存表中的数据 `le_diskyun_options`
--

INSERT INTO `le_diskyun_options` (`optionid`, `optionname`, `optionvalue`) VALUES
(1, 'isopen', '0'),
(2, 'YunCom', ''),
(3, 'AK', ''),
(4, 'SK', ''),
(6, 'Bucket', 'research'),
(7, 'loadUrl', 'http://bcs.duapp.com/research/'),
(8, 'isdel', '0');

-- --------------------------------------------------------

--
-- 表的结构 `le_feed`
--

DROP TABLE IF EXISTS `le_feed`;
CREATE TABLE IF NOT EXISTS `le_feed` (
  `feedid` int(11) NOT NULL AUTO_INCREMENT,
  `feedtype` enum('goods','friend','topic','zhuti') DEFAULT 'goods',
  `connectid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `template` varchar(1024) NOT NULL DEFAULT '' COMMENT '动态模板',
  `data` varchar(1024) NOT NULL DEFAULT '' COMMENT '动态数据',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '时间',
  PRIMARY KEY (`feedid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='全站动态' AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `le_feed`
--

-- --------------------------------------------------------

--
-- 表的结构 `le_goods_cate`
--

DROP TABLE IF EXISTS `le_goods_cate`;
CREATE TABLE IF NOT EXISTS `le_goods_cate` (
  `cate_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `parent_id` smallint(6) DEFAULT '0',
  `cate_name` varchar(80) DEFAULT '',
  `appname` varchar(80) DEFAULT '',
  `tag_num` int(5) NOT NULL DEFAULT '20',
  `seo_keywords` varchar(255) DEFAULT '',
  `seo_desc` varchar(255) DEFAULT '',
  `sort` int(11) DEFAULT '0',
  `is_nav` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`cate_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=75 ;

--
-- 转存表中的数据 `le_goods_cate`
--

INSERT INTO `le_goods_cate` (`cate_id`, `parent_id`, `cate_name`, `appname`, `tag_num`, `seo_keywords`, `seo_desc`, `sort`, `is_nav`) VALUES
(1, 0, '发现', '', 20, '', '', 100, 0),
(2, 0, '上装', 'coats', 20, '', '', 100, 1),
(3, 0, '下装', 'pants', 20, '', '', 100, 1),
(4, 0, '鞋子', 'shoes', 20, '', '', 100, 1),
(5, 0, '包包', 'bags', 20, '', '', 100, 1),
(6, 0, '配饰', 'accessories', 20, '', '', 100, 1),
(7, 0, '美妆', 'beauties', 20, '', '', 100, 1),
(8, 0, '家居', 'home', 20, '', '', 100, 1),
(48, 2, '潮流单品', 'coats', 20, '', '', 0, 1),
(47, 2, '流行元素', 'coats', 20, '', '', 0, 1),
(46, 2, '热门风格', 'coats', 20, '', '', 0, 1),
(45, 2, '材质', 'coats', 20, '', '', 0, 1),
(67, 7, '护肤', 'beauties', 20, '', '', 0, 1),
(66, 7, '彩妆', 'beauties', 20, '', '', 0, 1),
(65, 6, '首饰盒', 'accessories', 20, '', '', 0, 1),
(64, 6, '饰品', 'accessories', 20, '', '', 0, 1),
(63, 6, '风格', 'accessories', 20, '', '', 0, 1),
(62, 6, '元素', 'accessories', 20, '', '', 0, 1),
(61, 5, '热款', 'bags', 20, '', '', 0, 1),
(60, 5, '时尚手袋', 'bags', 20, '', '', 0, 1),
(59, 5, '元素', 'bags', 20, '', '', 0, 1),
(58, 5, '材质', 'bags', 20, '', '', 0, 1),
(57, 4, '热门', 'shoes', 20, '', '', 0, 1),
(55, 4, '元素', 'shoes', 20, '', '', 0, 1),
(54, 4, '休闲', 'shoes', 20, '', '', 0, 1),
(51, 3, '裙子', 'pants', 20, '', '', 0, 1),
(52, 3, '元素', 'pants', 20, '', '', 0, 1),
(53, 4, '单鞋', 'shoes', 20, '', '', 0, 1),
(50, 3, '裤子', 'pants', 20, '', '', 0, 1),
(49, 3, '风格材质', 'pants', 20, '', '', 0, 1),
(68, 7, '功效', 'beauties', 20, '', '', 0, 1),
(69, 7, '品牌', 'beauties', 20, '', '', 0, 1),
(70, 8, '推荐', 'home', 20, '', '', 0, 1),
(71, 8, '起居', 'home', 20, '', '', 0, 1),
(72, 8, '卧室', 'home', 20, '', '', 0, 1),
(73, 8, '厨房', 'home', 20, '', '', 0, 1),
(74, 2, '请修改', '', 20, '', '', 0, 1);

-- --------------------------------------------------------

--
-- 表的结构 `le_goods_category_tags`
--

DROP TABLE IF EXISTS `le_goods_category_tags`;
CREATE TABLE IF NOT EXISTS `le_goods_category_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cate_id` smallint(6) NOT NULL,
  `tag_id` smallint(6) NOT NULL,
  `is_index` int(1) DEFAULT '0',
  `weight` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cate_id` (`cate_id`),
  KEY `tag_id` (`tag_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1265 ;

--
-- 转存表中的数据 `le_goods_category_tags`
--

INSERT INTO `le_goods_category_tags` (`id`, `cate_id`, `tag_id`, `is_index`, `weight`) VALUES
(1135, 8, 2461, 0, 100),
(1134, 8, 2462, 0, 100),
(1133, 8, 2465, 0, 100),
(1132, 8, 2448, 0, 100),
(1131, 8, 2452, 0, 100),
(1130, 8, 2425, 0, 100),
(1129, 8, 2435, 0, 100),
(1128, 8, 2441, 0, 100),
(1123, 8, 2327, 0, 100),
(1122, 8, 2331, 0, 100),
(1120, 8, 2350, 0, 100),
(1119, 8, 2354, 0, 100),
(1118, 8, 2359, 0, 100),
(1117, 8, 2358, 0, 100),
(1116, 8, 2362, 0, 100),
(1115, 8, 2363, 0, 100),
(1114, 8, 2366, 0, 100),
(1113, 8, 2370, 0, 100),
(1112, 8, 2371, 0, 100),
(1111, 8, 2375, 0, 100),
(1110, 8, 2378, 0, 100),
(1109, 8, 2382, 0, 100),
(1108, 8, 2386, 0, 100),
(1107, 8, 2387, 0, 100),
(1106, 8, 2388, 0, 100),
(1105, 8, 2389, 0, 100),
(1104, 8, 2394, 0, 100),
(1103, 8, 2395, 0, 100),
(1102, 8, 2396, 0, 100),
(1101, 8, 2398, 0, 100),
(1100, 8, 2402, 0, 100),
(1099, 8, 2405, 0, 100),
(1098, 8, 2407, 0, 100),
(1097, 8, 2408, 0, 100),
(1096, 8, 2342, 0, 100),
(1094, 5, 1826, 0, 100),
(1093, 8, 2300, 0, 100),
(1092, 8, 2240, 0, 100),
(1091, 8, 2281, 0, 100),
(1090, 8, 2245, 0, 100),
(1089, 8, 2243, 0, 100),
(1087, 8, 2255, 0, 100),
(1086, 8, 2235, 0, 100),
(1085, 8, 2161, 0, 100),
(1084, 8, 2141, 0, 100),
(1083, 8, 2142, 0, 100),
(1081, 8, 2117, 0, 100),
(1080, 8, 2118, 0, 100),
(1082, 8, 2119, 0, 100),
(1078, 7, 1997, 0, 100),
(1077, 7, 2015, 0, 100),
(1076, 7, 2025, 0, 100),
(1075, 7, 2031, 0, 100),
(1074, 7, 2045, 0, 100),
(1073, 7, 2057, 0, 100),
(1072, 7, 2071, 0, 100),
(1071, 7, 2072, 0, 100),
(1070, 7, 2075, 0, 100),
(1069, 7, 1992, 0, 100),
(1068, 7, 1995, 0, 100),
(1067, 7, 1999, 0, 100),
(1066, 7, 2012, 0, 100),
(1065, 7, 2051, 0, 100),
(1064, 7, 2062, 0, 100),
(1063, 7, 2063, 0, 100),
(1062, 7, 2016, 0, 100),
(1061, 7, 2017, 0, 100),
(1060, 7, 2021, 0, 100),
(1054, 7, 1960, 0, 100),
(1048, 3, 1094, 0, 100),
(1053, 6, 1957, 0, 100),
(1045, 7, 1961, 1, 100),
(1044, 0, 1961, 0, 100),
(1043, 0, 1960, 0, 100),
(1040, 0, 236, 0, 100),
(1039, 6, 1914, 1, 100),
(1037, 0, 1914, 0, 100),
(1036, 2, 75, 0, 100),
(1059, 7, 2032, 0, 100),
(1035, 2, 749, 1, 100),
(1023, 4, 1623, 0, 100),
(1014, 4, 1524, 0, 100),
(1013, 4, 1470, 0, 100),
(1012, 4, 1529, 0, 100),
(1011, 4, 1530, 0, 100),
(1010, 4, 1582, 0, 100),
(1016, 4, 1621, 0, 100),
(1008, 4, 1597, 0, 100),
(1005, 4, 1390, 0, 100),
(1004, 4, 1409, 0, 100),
(1003, 4, 1444, 0, 100),
(1002, 4, 1382, 0, 100),
(1001, 4, 1381, 0, 100),
(1015, 4, 1383, 0, 100),
(999, 3, 1120, 0, 100),
(998, 3, 1134, 0, 100),
(997, 2, 918, 0, 100),
(994, 6, 791, 1, 100),
(995, 3, 17, 1, 1000),
(992, 5, 780, 0, 100),
(991, 2, 779, 0, 100),
(990, 5, 778, 0, 100),
(989, 4, 777, 0, 1000),
(988, 6, 776, 0, 1000),
(987, 8, 775, 0, 100),
(986, 7, 774, 0, 100),
(985, 8, 768, 0, 100),
(984, 2, 848, 0, 100),
(983, 2, 835, 0, 1000),
(982, 2, 831, 0, 100),
(980, 2, 830, 0, 100),
(979, 2, 818, 0, 100),
(978, 2, 808, 0, 100),
(977, 2, 804, 0, 100),
(976, 2, 806, 0, 100),
(975, 2, 868, 0, 100),
(974, 3, 868, 0, 100),
(973, 2, 867, 0, 100),
(972, 2, 934, 0, 100),
(971, 8, 990, 0, 100),
(970, 2, 952, 0, 100),
(969, 2, 951, 0, 100),
(968, 2, 1008, 0, 100),
(967, 2, 1005, 0, 100),
(1058, 7, 2033, 0, 100),
(1056, 3, 1091, 0, 100),
(964, 2, 1085, 0, 100),
(963, 3, 1074, 0, 100),
(962, 2, 1074, 0, 100),
(959, 8, 283, 0, 100),
(958, 8, 282, 0, 100),
(957, 8, 270, 0, 100),
(956, 8, 262, 0, 100),
(955, 8, 260, 0, 100),
(954, 8, 258, 0, 100),
(953, 7, 247, 0, 100),
(952, 7, 236, 1, 100),
(951, 7, 229, 0, 100),
(950, 7, 221, 0, 100),
(949, 7, 217, 0, 100),
(948, 6, 192, 0, 100),
(947, 6, 190, 0, 100),
(946, 6, 184, 0, 100),
(945, 5, 177, 0, 100),
(944, 5, 173, 0, 100),
(943, 5, 163, 0, 100),
(942, 5, 158, 0, 100),
(941, 5, 156, 0, 100),
(940, 5, 155, 0, 100),
(939, 4, 122, 0, 100),
(938, 4, 120, 0, 100),
(937, 4, 117, 0, 100),
(936, 4, 115, 0, 100),
(935, 4, 114, 0, 100),
(934, 4, 113, 0, 100),
(933, 4, 108, 0, 100),
(932, 3, 103, 0, 100),
(931, 3, 95, 0, 100),
(930, 3, 92, 0, 1000),
(929, 3, 91, 0, 1000),
(928, 2, 78, 0, 100),
(927, 2, 79, 0, 100),
(926, 2, 77, 0, 100),
(925, 2, 58, 0, 100),
(924, 2, 57, 0, 100),
(923, 2, 39, 0, 100),
(922, 2, 29, 0, 100),
(921, 2, 26, 1, 100),
(920, 4, 25, 0, 100),
(919, 2, 22, 0, 100),
(918, 4, 19, 0, 100),
(917, 3, 802, 1, 1000),
(916, 8, 291, 0, 100),
(915, 6, 286, 0, 100),
(914, 8, 279, 0, 100),
(913, 8, 276, 0, 100),
(912, 8, 257, 0, 100),
(911, 8, 256, 0, 100),
(910, 8, 253, 0, 100),
(908, 7, 245, 0, 100),
(907, 7, 242, 0, 100),
(906, 7, 235, 0, 100),
(905, 7, 234, 0, 100),
(904, 7, 230, 0, 100),
(903, 7, 228, 0, 100),
(902, 7, 227, 0, 100),
(901, 7, 226, 0, 100),
(900, 7, 222, 0, 100),
(899, 6, 209, 0, 100),
(898, 6, 208, 1, 100),
(897, 6, 198, 0, 100),
(896, 6, 195, 0, 100),
(895, 5, 159, 0, 100),
(894, 5, 157, 0, 100),
(893, 5, 152, 0, 100),
(892, 4, 129, 1, 100),
(891, 4, 126, 1, 100),
(890, 4, 123, 1, 100),
(889, 4, 121, 0, 100),
(888, 4, 119, 0, 100),
(887, 3, 102, 1, 100),
(886, 4, 37, 0, 100),
(885, 3, 24, 1, 100),
(884, 3, 21, 0, 100),
(883, 2, 20, 1, 100),
(882, 4, 13, 0, 100),
(996, 3, 1375, 0, 100),
(338, 2, 293, 0, 100),
(339, 2, 294, 0, 100),
(340, 2, 295, 0, 100),
(341, 2, 16, 1, 100),
(342, 2, 296, 0, 100),
(343, 2, 59, 1, 100),
(344, 2, 297, 1, 100),
(345, 2, 298, 0, 100),
(346, 2, 299, 0, 100),
(347, 2, 300, 0, 100),
(348, 2, 301, 0, 100),
(349, 2, 302, 0, 100),
(350, 2, 303, 0, 100),
(351, 2, 304, 0, 100),
(352, 2, 15, 1, 100),
(353, 2, 10, 0, 100),
(354, 2, 11, 0, 100),
(355, 2, 305, 1, 100),
(356, 2, 306, 1, 100),
(357, 2, 307, 0, 100),
(358, 2, 308, 0, 100),
(359, 2, 309, 0, 100),
(360, 2, 310, 0, 100),
(361, 2, 311, 0, 100),
(362, 2, 312, 0, 100),
(363, 2, 313, 0, 100),
(364, 2, 314, 0, 100),
(365, 2, 315, 0, 100),
(366, 2, 316, 0, 100),
(367, 2, 317, 0, 100),
(368, 2, 318, 0, 100),
(369, 2, 319, 0, 100),
(370, 2, 320, 0, 100),
(371, 2, 321, 0, 100),
(372, 2, 322, 0, 100),
(373, 2, 323, 0, 100),
(374, 2, 324, 0, 100),
(375, 2, 325, 0, 100),
(376, 2, 101, 0, 100),
(377, 2, 326, 0, 100),
(378, 2, 327, 0, 100),
(379, 2, 99, 0, 100),
(380, 2, 93, 0, 100),
(381, 2, 328, 0, 100),
(382, 2, 329, 0, 100),
(383, 2, 330, 0, 100),
(384, 2, 331, 0, 100),
(385, 2, 332, 0, 100),
(386, 2, 333, 0, 100),
(387, 2, 334, 0, 100),
(388, 2, 335, 0, 100),
(389, 2, 336, 0, 100),
(390, 2, 337, 0, 100),
(391, 2, 338, 0, 100),
(392, 2, 339, 0, 100),
(393, 2, 340, 0, 100),
(394, 2, 341, 0, 100),
(395, 2, 342, 0, 100),
(396, 2, 343, 0, 100),
(397, 2, 344, 0, 100),
(398, 2, 345, 0, 100),
(399, 2, 346, 0, 100),
(400, 2, 347, 0, 100),
(401, 2, 348, 0, 100),
(961, 3, 1065, 0, 1000),
(403, 2, 350, 0, 100),
(404, 2, 351, 0, 100),
(405, 2, 352, 0, 100),
(406, 2, 80, 0, 100),
(407, 2, 82, 0, 100),
(408, 2, 83, 0, 100),
(409, 2, 353, 0, 100),
(410, 3, 354, 0, 100),
(411, 3, 105, 0, 100),
(412, 3, 104, 0, 100),
(413, 3, 355, 0, 1000),
(414, 3, 356, 0, 100),
(415, 3, 106, 0, 100),
(416, 3, 14, 1, 1000),
(417, 3, 357, 0, 100),
(418, 3, 100, 0, 100),
(419, 3, 358, 0, 100),
(420, 3, 359, 1, 1000),
(421, 3, 96, 0, 1000),
(422, 3, 360, 0, 100),
(423, 3, 107, 1, 100),
(424, 3, 361, 0, 1000),
(425, 3, 94, 0, 100),
(426, 3, 97, 0, 100),
(427, 3, 362, 1, 1000),
(428, 3, 98, 1, 1000),
(429, 3, 363, 0, 1000),
(430, 3, 364, 0, 100),
(431, 3, 365, 0, 1000),
(432, 3, 366, 0, 100),
(433, 3, 367, 0, 1000),
(434, 3, 368, 0, 100),
(960, 3, 349, 0, 1000),
(436, 3, 369, 0, 100),
(437, 3, 370, 0, 1000),
(438, 4, 110, 1, 100),
(439, 4, 23, 1, 100),
(440, 4, 12, 1, 100),
(441, 4, 371, 0, 100),
(442, 4, 372, 0, 100),
(443, 4, 373, 1, 100),
(444, 4, 118, 1, 100),
(445, 4, 374, 0, 100),
(446, 4, 375, 0, 100),
(447, 4, 376, 1, 100),
(448, 4, 111, 0, 100),
(449, 4, 109, 0, 100),
(450, 4, 377, 0, 100),
(451, 4, 378, 0, 100),
(452, 4, 379, 0, 100),
(453, 4, 380, 0, 100),
(454, 4, 112, 0, 100),
(455, 4, 381, 0, 100),
(456, 4, 382, 0, 100),
(457, 4, 116, 0, 100),
(458, 4, 383, 0, 100),
(459, 4, 384, 0, 100),
(460, 4, 385, 0, 100),
(461, 4, 386, 0, 100),
(462, 4, 387, 0, 100),
(463, 5, 388, 0, 100),
(464, 5, 27, 0, 100),
(465, 5, 148, 0, 100),
(466, 5, 149, 0, 100),
(467, 5, 150, 0, 100),
(468, 5, 151, 0, 100),
(469, 5, 28, 1, 100),
(470, 5, 389, 1, 100),
(471, 5, 390, 0, 100),
(472, 5, 164, 0, 100),
(473, 5, 391, 0, 100),
(474, 5, 392, 0, 100),
(475, 5, 393, 0, 100),
(476, 5, 394, 0, 100),
(477, 5, 395, 0, 100),
(478, 5, 396, 1, 100),
(479, 5, 397, 1, 100),
(480, 5, 398, 1, 100),
(481, 5, 399, 1, 100),
(482, 5, 400, 0, 100),
(483, 5, 401, 0, 100),
(484, 5, 153, 1, 100),
(485, 5, 154, 0, 100),
(486, 5, 402, 0, 100),
(487, 5, 403, 0, 100),
(488, 5, 160, 0, 100),
(489, 5, 404, 0, 100),
(490, 5, 405, 0, 100),
(491, 5, 162, 0, 100),
(492, 5, 172, 0, 100),
(493, 5, 406, 0, 100),
(494, 5, 407, 0, 100),
(495, 5, 408, 0, 100),
(496, 5, 147, 0, 100),
(497, 5, 409, 0, 100),
(498, 5, 410, 0, 100),
(499, 5, 411, 0, 100),
(500, 5, 412, 1, 100),
(501, 5, 413, 1, 100),
(502, 5, 414, 0, 100),
(503, 5, 415, 0, 100),
(504, 5, 416, 0, 100),
(505, 5, 417, 0, 100),
(506, 6, 418, 0, 100),
(507, 6, 188, 0, 100),
(508, 6, 419, 0, 100),
(509, 6, 420, 0, 100),
(510, 6, 421, 0, 100),
(511, 6, 18, 0, 100),
(512, 6, 181, 0, 100),
(513, 6, 422, 0, 100),
(514, 6, 423, 0, 100),
(515, 6, 424, 0, 100),
(516, 6, 425, 0, 100),
(517, 6, 183, 0, 100),
(518, 6, 426, 0, 100),
(519, 6, 427, 0, 100),
(520, 6, 428, 0, 100),
(521, 6, 429, 0, 100),
(522, 6, 430, 0, 100),
(523, 6, 431, 0, 100),
(524, 6, 432, 0, 100),
(525, 6, 433, 0, 100),
(526, 6, 434, 0, 100),
(527, 6, 435, 0, 100),
(528, 6, 436, 0, 100),
(529, 6, 437, 0, 100),
(530, 6, 438, 0, 100),
(531, 6, 439, 0, 100),
(532, 6, 440, 0, 100),
(533, 6, 441, 0, 100),
(534, 6, 442, 0, 100),
(535, 6, 443, 0, 100),
(536, 6, 194, 0, 100),
(537, 6, 444, 0, 100),
(538, 6, 445, 0, 100),
(539, 6, 446, 0, 100),
(540, 6, 185, 1, 100),
(541, 6, 447, 0, 100),
(542, 6, 193, 0, 100),
(543, 6, 448, 0, 100),
(544, 6, 189, 1, 100),
(545, 6, 449, 0, 100),
(546, 6, 450, 0, 100),
(547, 6, 451, 1, 100),
(548, 6, 452, 0, 100),
(549, 6, 187, 0, 100),
(550, 6, 182, 0, 100),
(551, 6, 453, 0, 100),
(552, 6, 454, 0, 100),
(553, 6, 259, 0, 100),
(554, 6, 455, 0, 500),
(555, 6, 285, 0, 100),
(556, 6, 456, 0, 100),
(557, 6, 457, 0, 100),
(558, 6, 458, 0, 100),
(559, 6, 459, 1, 100),
(560, 6, 460, 0, 100),
(561, 6, 461, 0, 100),
(562, 6, 462, 0, 100),
(563, 6, 463, 0, 100),
(564, 6, 464, 0, 100),
(565, 6, 465, 0, 100),
(566, 6, 466, 0, 100),
(567, 6, 467, 0, 100),
(568, 6, 468, 0, 100),
(569, 6, 469, 0, 100),
(570, 6, 470, 0, 100),
(571, 6, 471, 0, 100),
(572, 6, 472, 0, 100),
(573, 6, 473, 0, 100),
(574, 6, 196, 1, 100),
(575, 6, 186, 0, 100),
(576, 6, 474, 0, 100),
(577, 6, 475, 0, 100),
(578, 6, 476, 0, 100),
(579, 6, 191, 1, 500),
(580, 6, 477, 0, 100),
(581, 6, 478, 0, 100),
(582, 6, 479, 0, 100),
(583, 6, 480, 0, 100),
(584, 6, 481, 0, 100),
(585, 6, 482, 0, 100),
(586, 6, 483, 0, 100),
(587, 6, 484, 0, 100),
(588, 6, 485, 0, 100),
(589, 6, 486, 0, 100),
(590, 6, 487, 0, 100),
(591, 6, 488, 0, 100),
(592, 6, 489, 0, 100),
(593, 6, 490, 0, 100),
(594, 7, 491, 1, 100),
(595, 7, 252, 0, 100),
(596, 7, 492, 0, 100),
(597, 7, 493, 0, 100),
(598, 7, 215, 0, 100),
(599, 7, 494, 0, 100),
(600, 7, 495, 0, 100),
(601, 7, 496, 0, 100),
(602, 7, 497, 0, 100),
(603, 7, 220, 1, 100),
(604, 7, 498, 0, 100),
(605, 7, 499, 0, 100),
(606, 7, 500, 0, 100),
(607, 7, 501, 0, 100),
(608, 7, 502, 0, 100),
(1046, 7, 237, 1, 100),
(610, 7, 239, 0, 100),
(611, 7, 503, 0, 100),
(612, 7, 504, 0, 100),
(613, 7, 233, 0, 100),
(614, 7, 505, 0, 100),
(615, 7, 238, 0, 100),
(616, 7, 506, 0, 100),
(617, 7, 507, 0, 100),
(618, 7, 232, 0, 100),
(619, 7, 508, 0, 100),
(620, 7, 219, 1, 100),
(621, 7, 509, 1, 100),
(622, 7, 510, 1, 100),
(623, 7, 231, 0, 100),
(624, 7, 511, 0, 100),
(625, 7, 512, 0, 100),
(626, 7, 513, 0, 100),
(627, 7, 514, 0, 100),
(628, 7, 515, 0, 100),
(629, 7, 516, 0, 100),
(630, 7, 517, 0, 100),
(631, 7, 518, 0, 100),
(632, 7, 519, 0, 100),
(633, 7, 520, 0, 100),
(634, 7, 521, 0, 100),
(635, 7, 240, 0, 100),
(636, 7, 522, 0, 100),
(637, 7, 523, 0, 100),
(638, 7, 524, 0, 100),
(639, 7, 525, 1, 100),
(640, 7, 526, 0, 100),
(641, 7, 527, 0, 100),
(642, 7, 528, 0, 100),
(643, 7, 529, 0, 100),
(644, 7, 530, 0, 100),
(645, 7, 531, 0, 100),
(646, 7, 218, 0, 100),
(647, 7, 532, 0, 100),
(648, 7, 533, 0, 100),
(649, 7, 534, 0, 100),
(650, 7, 535, 0, 100),
(651, 7, 536, 0, 100),
(652, 7, 537, 0, 100),
(653, 7, 538, 0, 100),
(654, 7, 224, 0, 100),
(655, 7, 539, 0, 100),
(656, 7, 540, 0, 100),
(657, 7, 541, 0, 100),
(658, 8, 542, 0, 100),
(659, 8, 543, 0, 100),
(660, 8, 544, 0, 100),
(661, 8, 545, 0, 100),
(662, 8, 546, 0, 100),
(663, 8, 547, 0, 100),
(664, 8, 548, 0, 100),
(665, 8, 549, 0, 100),
(666, 8, 550, 0, 100),
(667, 8, 551, 0, 100),
(668, 8, 552, 0, 100),
(669, 8, 553, 0, 100),
(670, 8, 554, 0, 100),
(671, 8, 555, 0, 100),
(672, 8, 556, 0, 100),
(673, 8, 557, 1, 100),
(674, 8, 558, 1, 100),
(675, 8, 559, 0, 100),
(676, 8, 560, 0, 100),
(677, 8, 561, 0, 100),
(678, 8, 562, 0, 100),
(679, 8, 563, 0, 100),
(680, 8, 564, 0, 100),
(681, 8, 565, 0, 100),
(682, 8, 566, 0, 100),
(683, 8, 567, 0, 100),
(684, 8, 568, 0, 100),
(685, 8, 569, 0, 100),
(686, 8, 570, 0, 100),
(687, 8, 571, 0, 100),
(688, 8, 572, 0, 100),
(689, 8, 573, 0, 100),
(690, 8, 574, 0, 100),
(691, 8, 575, 0, 100),
(692, 8, 576, 0, 100),
(693, 8, 577, 0, 100),
(694, 8, 578, 0, 100),
(695, 8, 579, 0, 100),
(696, 8, 580, 0, 100),
(697, 8, 581, 0, 100),
(698, 8, 582, 0, 100),
(699, 8, 583, 0, 100),
(700, 8, 584, 0, 100),
(701, 8, 585, 1, 100),
(702, 8, 586, 0, 100),
(703, 8, 587, 0, 100),
(704, 8, 588, 0, 100),
(705, 8, 589, 0, 100),
(706, 8, 590, 0, 100),
(707, 8, 591, 0, 100),
(708, 8, 592, 0, 100),
(709, 8, 593, 0, 100),
(710, 8, 594, 1, 100),
(711, 8, 595, 0, 100),
(712, 8, 596, 0, 100),
(713, 8, 597, 0, 100),
(714, 8, 598, 0, 100),
(715, 8, 599, 0, 100),
(716, 8, 600, 0, 100),
(717, 8, 601, 0, 100),
(718, 8, 602, 0, 100),
(719, 8, 603, 0, 100),
(720, 8, 604, 0, 100),
(721, 8, 259, 0, 100),
(722, 8, 605, 1, 100),
(723, 8, 606, 0, 100),
(724, 8, 607, 0, 100),
(725, 8, 608, 0, 100),
(726, 8, 609, 0, 100),
(727, 8, 610, 0, 100),
(728, 8, 611, 0, 100),
(729, 8, 612, 0, 100),
(730, 8, 473, 0, 100),
(731, 8, 613, 0, 100),
(732, 8, 614, 0, 100),
(733, 8, 615, 0, 100),
(734, 8, 616, 0, 100),
(735, 8, 617, 0, 100),
(736, 8, 618, 0, 100),
(737, 8, 619, 0, 100),
(738, 8, 274, 0, 100),
(739, 8, 620, 0, 100),
(740, 8, 277, 0, 100),
(741, 8, 621, 0, 100),
(742, 8, 266, 0, 100),
(743, 8, 622, 0, 100),
(744, 8, 623, 0, 100),
(745, 8, 624, 0, 100),
(746, 8, 625, 0, 100),
(747, 8, 626, 0, 100),
(748, 8, 627, 0, 100),
(749, 8, 628, 0, 100),
(750, 8, 629, 0, 100),
(751, 8, 630, 0, 100),
(752, 8, 631, 0, 100),
(753, 8, 632, 0, 100),
(754, 8, 633, 0, 100),
(755, 8, 634, 0, 100),
(756, 8, 635, 0, 100),
(757, 8, 636, 1, 100),
(758, 8, 637, 0, 100),
(759, 8, 638, 0, 100),
(760, 8, 639, 0, 100),
(761, 8, 640, 0, 100),
(762, 8, 641, 0, 100),
(763, 8, 642, 0, 100),
(764, 8, 643, 0, 100),
(765, 8, 644, 0, 100),
(766, 8, 645, 0, 100),
(767, 8, 646, 1, 100),
(768, 8, 647, 0, 100),
(769, 8, 648, 0, 100),
(770, 8, 649, 0, 100),
(771, 8, 650, 0, 100),
(772, 8, 651, 0, 100),
(773, 8, 652, 0, 100),
(774, 8, 653, 0, 100),
(775, 8, 654, 0, 100),
(776, 8, 263, 0, 100),
(777, 8, 655, 0, 100),
(778, 8, 656, 0, 100),
(779, 8, 657, 0, 100),
(780, 8, 658, 0, 100),
(781, 8, 265, 0, 100),
(782, 8, 659, 0, 100),
(783, 8, 269, 0, 100),
(784, 8, 264, 1, 100),
(785, 8, 660, 0, 100),
(786, 8, 661, 0, 100),
(787, 8, 662, 0, 100),
(788, 8, 663, 0, 100),
(789, 8, 664, 0, 100),
(790, 8, 665, 0, 100),
(791, 8, 666, 0, 100),
(792, 8, 667, 0, 100),
(793, 8, 668, 0, 100),
(794, 8, 669, 0, 100),
(795, 8, 670, 0, 100),
(796, 8, 671, 0, 100),
(797, 8, 672, 0, 100),
(798, 8, 673, 0, 100),
(799, 8, 674, 0, 100),
(800, 8, 675, 0, 100),
(801, 8, 676, 0, 100),
(802, 8, 677, 0, 100),
(803, 8, 678, 0, 100),
(804, 8, 679, 0, 100),
(805, 8, 680, 0, 100),
(806, 8, 681, 0, 100),
(807, 8, 682, 0, 100),
(808, 8, 683, 0, 100),
(809, 8, 466, 0, 100),
(810, 8, 684, 0, 100),
(811, 8, 685, 0, 100),
(812, 8, 686, 0, 100),
(813, 8, 261, 0, 100),
(814, 8, 687, 0, 100),
(815, 8, 688, 0, 100),
(816, 8, 689, 0, 100),
(817, 8, 268, 0, 100),
(818, 8, 690, 0, 100),
(819, 8, 691, 0, 100),
(820, 8, 692, 0, 100),
(821, 8, 693, 0, 100),
(822, 8, 694, 0, 100),
(823, 8, 695, 0, 100),
(824, 8, 696, 0, 100),
(825, 8, 697, 0, 100),
(826, 8, 698, 0, 100),
(827, 8, 699, 0, 100),
(828, 8, 700, 0, 100),
(829, 8, 701, 0, 100),
(830, 8, 702, 0, 100),
(831, 8, 703, 0, 100),
(832, 8, 704, 0, 100),
(833, 8, 705, 0, 100),
(834, 8, 706, 0, 100),
(835, 8, 707, 0, 100),
(836, 8, 708, 0, 100),
(837, 8, 709, 0, 100),
(838, 8, 710, 0, 100),
(839, 8, 711, 0, 100),
(840, 8, 712, 0, 100),
(841, 8, 713, 0, 100),
(842, 8, 714, 0, 100),
(843, 8, 715, 0, 100),
(844, 8, 716, 0, 100),
(845, 8, 717, 0, 100),
(846, 8, 718, 0, 100),
(847, 8, 719, 0, 100),
(848, 8, 285, 0, 100),
(849, 8, 720, 0, 100),
(850, 8, 281, 0, 100),
(851, 8, 721, 0, 100),
(852, 8, 153, 0, 100),
(853, 8, 722, 0, 100),
(854, 8, 723, 1, 100),
(855, 8, 724, 0, 100),
(856, 8, 725, 0, 100),
(857, 8, 726, 0, 100),
(858, 8, 727, 0, 100),
(859, 8, 278, 0, 100),
(860, 8, 728, 0, 100),
(861, 8, 729, 0, 100),
(862, 8, 730, 0, 100),
(863, 8, 731, 0, 100),
(864, 8, 732, 0, 100),
(865, 8, 733, 0, 100),
(866, 8, 734, 0, 100),
(867, 8, 735, 0, 100),
(868, 8, 161, 0, 100),
(869, 8, 736, 0, 100),
(870, 8, 737, 0, 100),
(871, 8, 738, 0, 100),
(872, 8, 739, 0, 100),
(873, 8, 740, 0, 100),
(874, 8, 741, 0, 100),
(875, 8, 742, 0, 100),
(876, 8, 743, 0, 100),
(877, 8, 744, 0, 100),
(878, 8, 745, 0, 100),
(879, 8, 746, 0, 100),
(880, 8, 747, 0, 100),
(881, 2, 748, 0, 100),
(1136, 8, 4049, 0, 100),
(1137, 5, 3919, 0, 100),
(1138, 2, 3815, 0, 100),
(1139, 4, 3807, 0, 100),
(1140, 4, 3791, 0, 100),
(1141, 2, 3767, 0, 100),
(1142, 4, 3664, 0, 100),
(1143, 2, 3528, 0, 100),
(1144, 4, 3524, 0, 100),
(1145, 4, 3463, 0, 100),
(1146, 3, 3440, 0, 100),
(1147, 4, 3423, 0, 100),
(1148, 5, 3249, 0, 100),
(1149, 3, 3337, 0, 100),
(1150, 6, 3218, 0, 100),
(1151, 3, 3104, 0, 100),
(1152, 2, 3091, 0, 100),
(1153, 5, 2934, 0, 100),
(1154, 2, 2858, 0, 100),
(1155, 5, 2833, 0, 100),
(1156, 3, 2832, 0, 100),
(1157, 5, 2769, 0, 100),
(1158, 5, 2776, 0, 100),
(1159, 4, 2757, 0, 100),
(1160, 2, 2744, 0, 100),
(1161, 3, 2627, 0, 100),
(1162, 2, 2581, 0, 100),
(1163, 7, 2542, 0, 100),
(1164, 7, 2544, 0, 100),
(1165, 8, 2417, 0, 100),
(1166, 8, 2170, 0, 100),
(1167, 8, 2122, 0, 100),
(1168, 8, 2125, 0, 100),
(1169, 8, 2099, 0, 100),
(1170, 8, 2102, 0, 100),
(1171, 8, 2100, 0, 100),
(1172, 7, 2086, 0, 100),
(1173, 7, 2084, 0, 100),
(1174, 7, 2036, 0, 100),
(1175, 7, 2011, 0, 100),
(1176, 7, 2008, 0, 100),
(1177, 7, 2005, 0, 100),
(1178, 7, 2004, 0, 100),
(1179, 7, 2003, 0, 100),
(1180, 7, 2000, 0, 100),
(1181, 7, 1998, 0, 100),
(1182, 7, 1993, 0, 100),
(1183, 5, 1962, 0, 100),
(1184, 6, 1932, 0, 100),
(1185, 6, 1931, 0, 100),
(1186, 6, 1922, 0, 100),
(1187, 6, 1913, 0, 100),
(1188, 6, 1911, 0, 100),
(1189, 6, 1910, 0, 100),
(1190, 6, 1895, 0, 100),
(1191, 6, 1896, 0, 100),
(1192, 6, 1894, 0, 100),
(1193, 6, 1880, 0, 100),
(1194, 7, 2027, 0, 100),
(1198, 5, 1855, 0, 100),
(1197, 5, 1856, 0, 100),
(1199, 5, 1786, 0, 100),
(1200, 5, 1787, 0, 100),
(1201, 5, 1743, 0, 100),
(1202, 5, 1716, 0, 100),
(1203, 5, 1710, 0, 100),
(1204, 5, 1711, 0, 100),
(1205, 5, 1693, 0, 100),
(1206, 5, 1689, 0, 100),
(1207, 5, 1682, 0, 100),
(1208, 5, 1663, 0, 100),
(1209, 5, 1655, 0, 100),
(1210, 5, 1657, 0, 100),
(1211, 5, 1656, 0, 100),
(1212, 5, 1658, 0, 100),
(1213, 4, 1648, 0, 100),
(1214, 4, 1588, 0, 100),
(1215, 4, 1569, 0, 100),
(1216, 4, 1566, 0, 100),
(1217, 4, 1541, 0, 100),
(1218, 4, 1531, 0, 100),
(1219, 4, 1508, 0, 100),
(1220, 4, 1490, 0, 100),
(1221, 4, 1486, 0, 100),
(1222, 4, 1476, 0, 100),
(1223, 4, 1475, 0, 100),
(1224, 4, 1466, 0, 100),
(1225, 4, 1467, 0, 100),
(1226, 4, 1448, 0, 100),
(1227, 4, 1426, 0, 100),
(1228, 4, 1392, 0, 100),
(1229, 4, 1393, 0, 100),
(1230, 4, 1391, 0, 100),
(1231, 4, 1389, 0, 100),
(1232, 4, 1388, 0, 100),
(1233, 4, 1386, 0, 100),
(1234, 4, 1385, 0, 100),
(1235, 3, 1214, 0, 100),
(1236, 3, 1208, 0, 100),
(1237, 3, 1207, 0, 100),
(1238, 3, 1175, 0, 100),
(1239, 3, 1126, 0, 100),
(1240, 2, 1108, 0, 100),
(1241, 3, 1110, 0, 100),
(1242, 3, 997, 0, 100),
(1243, 2, 927, 0, 100),
(1244, 6, 207, 0, 100),
(1245, 4, 128, 0, 100),
(1246, 4, 127, 0, 100),
(1247, 4, 130, 0, 100),
(1248, 4, 125, 0, 100),
(1249, 4, 124, 0, 100),
(1250, 2, 76, 0, 100),
(1251, 2, 81, 0, 100),
(1252, 2, 51, 0, 100),
(1253, 2, 35, 0, 100),
(1254, 2, 4519, 0, 100),
(1255, 3, 4504, 0, 100),
(1256, 2, 4490, 0, 100),
(1257, 2, 4456, 0, 100),
(1258, 4, 4437, 0, 100),
(1259, 4, 4438, 0, 100),
(1260, 4, 4424, 0, 100),
(1261, 2, 4410, 0, 100),
(1262, 5, 4377, 0, 100),
(1263, 6, 4357, 0, 100),
(1264, 7, 4273, 0, 100);

-- --------------------------------------------------------

--
-- 表的结构 `le_goods_subcate`
--

DROP TABLE IF EXISTS `le_goods_subcate`;
CREATE TABLE IF NOT EXISTS `le_goods_subcate` (
  `subcate_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cate_id` int(11) DEFAULT NULL,
  `subcate_icon` varchar(255) DEFAULT '',
  `tag` text,
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`subcate_id`),
  KEY `cate_id` (`cate_id`) USING BTREE
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=30 ;

--
-- 转存表中的数据 `le_goods_subcate`
--

INSERT INTO `le_goods_subcate` (`subcate_id`, `cate_id`, `subcate_icon`, `tag`, `create_time`) VALUES
(1, 48, 'uploadfile/subcate_ico/20130824/20130824_214652_441.jpg', '衬衫，雪纺衫，T恤，薄外套，背心，蕾丝衫，长袖T，无袖衫，开衫，小西装，棒球衫，娃娃衫，花朵衫，卫衣，防晒衫，风衣', 1377351572),
(2, 47, 'uploadfile/subcate_ico/20130824/20130824_214825_382.jpg', '娃娃领，宽松，大码，条纹，格纹，花朵，短款', 1377351693),
(3, 46, 'uploadfile/subcate_ico/20130824/20130824_214851_444.jpg', '甜美，简约，代购，街头，公主，卡通，韩版，街拍', 1377351700),
(4, 45, 'uploadfile/subcate_ico/20130827/20130827_161208_709.png', '雪纺，真丝，牛仔，蕾丝，纯棉', 1377351705),
(5, 49, 'uploadfile/subcate_ico/20130825/20130825_124913_275.jpg', '甜美，复古，雪纺，蕾丝，花朵，娃娃领，公主风，收腰，显瘦，露肩，棉质，雪纺，薄纱', 1377405822),
(6, 51, 'uploadfile/subcate_ico/20130825/20130825_124835_291.jpg', '连衣裙，半身裙，短袖裙，长袖裙，牛仔裙，长裙，包臀裙', 1377405909),
(7, 50, 'uploadfile/subcate_ico/20130825/20130825_124936_762.jpg', '短裤，牛仔裤，小脚裤，哈伦裤，打底裤，背带裤，休闲裤，连体裤，牛仔短裤，运动裤，西装裤，高腰裤，裙裤，修身裤，印花裤，铅笔裤', 1377405939),
(8, 52, 'uploadfile/subcate_ico/20130825/20130825_125627_873.jpg', '高腰，小脚，显瘦，宽松，破洞，原单，大码，修身，七分', 1377405967),
(9, 53, 'uploadfile/subcate_ico/20130826/20130826_092027_974.jpg', '平底鞋，高跟鞋，尖头鞋，圆头鞋，粗跟鞋，坡跟鞋，方头鞋，漆皮鞋，牛津鞋，水钻单鞋，软底鞋', 1377479682),
(10, 57, 'uploadfile/subcate_ico/20130826/20130826_091845_277.jpg', '豆豆鞋，镂空凉鞋，草编凉鞋，雨鞋，拖鞋，印花鞋，婚鞋，系带凉鞋，平跟鞋，娃娃鞋，早秋新品', 1377479715),
(11, 55, 'uploadfile/subcate_ico/20130826/20130826_091816_949.jpg', '百搭，豹纹，流苏，原单，水钻，系带，松糕，圆头，学生党', 1377479764),
(12, 54, 'uploadfile/subcate_ico/20130826/20130826_091934_702.jpg', '帆布鞋，松糕鞋，运动鞋，厚底鞋，球鞋，高帮鞋，低帮鞋，小白鞋，板鞋，布鞋，草编鞋，高帮帆布鞋，魔术贴，厚底帆布', 1377479820),
(13, 61, 'uploadfile/subcate_ico/20130826/20130826_102825_589.jpg', '单肩包，手提包，斜挎包，双肩包，手拿包，零钱包，铆钉包，旅行包', 1377484072),
(14, 60, 'uploadfile/subcate_ico/20130826/20130826_103208_344.jpg', '小香风，机车包，枕头型，迷你型定型包，水桶包，流苏包，学院风', 1377484323),
(15, 59, 'uploadfile/subcate_ico/20130826/20130826_103440_252.jpg', '豹纹，菱格，甜美，欧美，链条，铆钉，撞色，复古', 1377484407),
(16, 58, 'uploadfile/subcate_ico/20130826/20130826_103446_882.jpg', '真皮，牛皮，PU包，羊皮，帆布，果冻感，漆皮，草编', 1377484427),
(17, 62, 'uploadfile/subcate_ico/20130826/20130826_104213_556.jpg', '纯银，黄金，镶钻，水晶，开运，宝石，辟邪，施华洛世奇', 1377484667),
(18, 65, 'uploadfile/subcate_ico/20130826/20130826_104156_653.jpg', '戒指，耳环，发夹，项链，胸针，发圈，发箍，手链', 1377484700),
(19, 64, 'uploadfile/subcate_ico/20130826/20130826_104202_696.jpg', '发饰，胸饰，耳饰，手表，腰带，假领，镜框，手饰', 1377484728),
(20, 63, 'uploadfile/subcate_ico/20130826/20130826_104208_447.jpg', '复古，韩版，日系，朋克，杂志款，英伦，撞色，百搭', 1377484749),
(21, 67, 'uploadfile/subcate_ico/20130826/20130826_104806_663.jpg', '洁面，面膜，卸妆，唇膏，乳液，精华，面霜，化妆水', 1377485130),
(22, 66, 'uploadfile/subcate_ico/20130826/20130826_104811_920.jpg', 'BB霜，遮瑕，唇彩，睫毛膏，隔离霜，粉底，眼影，眼线', 1377485157),
(23, 68, 'uploadfile/subcate_ico/20130826/20130826_104818_501.jpg', '控油，保湿，去黑头，美白，敏感肌肤，紧致，收缩毛孔', 1377485184),
(24, 69, 'uploadfile/subcate_ico/20130826/20130826_104824_734.jpg', '贝玲妃，雅漾，DIOR，倩碧，兰蔻，雅诗兰黛，资生堂，DHC', 1377485215),
(25, 70, 'uploadfile/subcate_ico/20130828/20130828_165042_248.png', '盆栽，礼品，马克杯，便当盒，文具，玻璃杯，雨伞，风扇，婚礼，烛台，七夕礼物，多肉，盆栽', 1377485374),
(26, 71, 'uploadfile/subcate_ico/20130828/20130828_165101_791.png', '衣帽钩，相片墙，贴纸，地垫，靠垫，盖布，时钟，置物架，盆栽，相机，冰箱贴，挂钟，马口铁，收纳', 1377485394),
(27, 72, 'uploadfile/subcate_ico/20130828/20130828_165115_967.png', '抱枕，坐垫，摆件，窗帘，香薰，加湿器，衣柜，床品套件，床头灯，懒人沙发', 1377485414),
(28, 73, 'uploadfile/subcate_ico/20130828/20130828_165128_663.png', '餐具，勺子，便当盒，烘焙，调味瓶，模具，茶具，密封罐，杯垫', 1377485428);

-- --------------------------------------------------------

--
-- 表的结构 `le_goods_tags`
--

DROP TABLE IF EXISTS `le_goods_tags`;
CREATE TABLE IF NOT EXISTS `le_goods_tags` (
  `tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(100) DEFAULT NULL,
  `img` varchar(1024) NOT NULL DEFAULT '',
  `tag_code` varchar(100) NOT NULL DEFAULT '',
  `sort` smallint(5) NOT NULL DEFAULT '100',
  `is_hot` tinyint(1) NOT NULL,
  `count` int(11) NOT NULL,
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `tag_code` (`tag_code`),
  UNIQUE KEY `tag_name` (`tag_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4866 ;

--
-- 转存表中的数据 `le_goods_tags`
--

INSERT INTO `le_goods_tags` (`tag_id`, `tag_name`, `img`, `tag_code`, `sort`, `is_hot`, `count`) VALUES
(1, '欧美', '', '欧美', 100, 1, 28),
(2, '复古', '', '复古', 100, 1, 458),
(3, '海军', '', '海军', 100, 0, 15),
(4, '度假', '', '度假', 100, 0, 15),
(5, '日系', '', '日系', 100, 1, 0),
(6, '田园', '', '田园', 100, 1, 9),
(7, '清新', '', '清新', 100, 1, 12),
(8, '休闲', '', '休闲', 100, 1, 26),
(9, '波西米亚', '', '波西米亚', 100, 1, 0),
(10, 'T恤', '', 'T恤', 100, 1, 11),
(11, '背心', '', '背心', 100, 0, 4),
(12, '凉鞋', 'cache/tag/20130829/1377743873.jpg', '凉鞋', 100, 1, 1),
(13, '拖鞋', '', '拖鞋', 100, 0, 1),
(14, '短裤', 'cache/tag/20130829/1377741617.jpg', '短裤', 100, 0, 20),
(15, '半身裙', 'cache/tag/20130829/1377739660.jpg', '半身裙', 100, 1, 21),
(16, '衬衫', 'cache/tag/20130829/1377739680.jpg', '衬衫', 100, 0, 4),
(17, '连衣裙', 'cache/tag/20130829/1377741611.jpg', '连衣裙', 100, 1, 9),
(18, '帽子', '', '帽子', 100, 0, 4),
(19, '坡跟鞋', '', '坡跟鞋', 100, 0, 1),
(20, '短袖', 'cache/tag/20130829/1377739695.jpg', '短袖', 100, 0, 6),
(21, '连体裤', '', '连体裤', 100, 0, 0),
(22, '罩衫', '', '罩衫', 100, 0, 1),
(23, '帆布鞋', 'cache/tag/20130829/1377743879.jpg', '帆布鞋', 100, 1, 1),
(24, '长裙', 'cache/tag/20130829/1377741565.jpg', '长裙', 100, 0, 6),
(25, '罗马鞋', '', '罗马鞋', 100, 0, 0),
(26, '泳衣', 'cache/tag/20130829/1377739652.jpg', '泳衣', 100, 0, 0),
(27, '单肩包', '', '单肩包', 100, 1, 74),
(28, '钱包', 'cache/tag/20130829/1377747401.jpg', '钱包', 100, 1, 40),
(29, '防晒衣', '', '防晒衣', 100, 0, 0),
(30, '夏日美包', '', '夏日美包', 100, 0, 0),
(31, '七夕', '', '七夕', 100, 0, 10),
(32, '波点', '', '波点', 100, 1, 0),
(33, '显瘦', '', '显瘦', 100, 0, 0),
(34, '字母', '', '字母', 100, 0, 2),
(35, '雪纺', '', '雪纺', 100, 1, 8),
(36, '条纹', '', '条纹', 100, 1, 3),
(37, '厚底', '', '厚底', 100, 1, 0),
(38, '荧光色', '', '荧光色', 100, 0, 0),
(39, '露肩', '', '露肩', 100, 0, 0),
(40, '动物纹', '', '动物纹', 100, 0, 0),
(41, '印花', '', '印花', 100, 0, 2),
(42, '糖果色', '', '糖果色', 100, 1, 0),
(43, '蓝精灵', '', '蓝精灵', 100, 0, 0),
(44, 'lena同款', '', 'lena同款', 100, 0, 0),
(45, '星座', '', '星座', 100, 0, 3),
(46, '轻松熊', '', '轻松熊', 100, 0, 0),
(47, '城市猎人', '', '城市猎人', 100, 0, 0),
(48, '西瓜', '', '西瓜', 100, 0, 1),
(49, '街拍', '', '街拍', 100, 0, 0),
(50, '兔子', '', '兔子', 100, 0, 4),
(51, '大嘴猴', '', '大嘴猴', 100, 0, 0),
(52, '猫头鹰', '', '猫头鹰', 100, 0, 2),
(53, '徐濠萦', '', '徐濠萦', 100, 0, 1),
(54, '绯闻女孩', '', '绯闻女孩', 100, 0, 0),
(55, 'vivi同款', '', 'vivi同款', 100, 0, 0),
(56, 'hello kitty', '', 'hello kitty', 100, 0, 0),
(57, '防晒衫', '', '防晒衫', 100, 0, 0),
(58, '透视装', '', '透视装', 100, 0, 0),
(59, '雪纺衫', 'cache/tag/20130829/1377739707.jpg', '雪纺衫', 100, 0, 24),
(60, '简约', '', '简约', 100, 0, 27),
(61, '卡通', '', '卡通', 100, 1, 12),
(62, 'BF风', '', 'BF风', 100, 0, 0),
(63, '撞色', '', '撞色', 100, 0, 0),
(64, '拼接', '', '拼接', 100, 1, 2),
(65, '蕾丝', '', '蕾丝', 100, 1, 8),
(66, '钩花', '', '钩花', 100, 0, 1),
(67, '军装', '', '军装', 100, 0, 2),
(68, '透视', '', '透视', 100, 0, 1),
(69, 'OL', '', 'OL', 100, 0, 1),
(70, '公主', '', '公主', 100, 1, 4),
(71, '森系', '', '森系', 100, 0, 0),
(72, '学院', '', '学院', 100, 0, 5),
(73, '中性', '', '中性', 100, 0, 2),
(74, '英伦', '', '英伦', 100, 0, 52),
(75, '娃娃衫', '', '娃娃衫', 100, 0, 0),
(76, 'T裙', '', 'T裙', 100, 0, 0),
(77, '马甲', '', '马甲', 100, 0, 1),
(78, '露肩T', '', '露肩T', 100, 0, 0),
(79, '短T', '', '短T', 100, 0, 0),
(80, '文胸', '', '文胸', 100, 0, 15),
(81, '小可爱', '', '小可爱', 100, 0, 1),
(82, '睡衣', '', '睡衣', 100, 0, 2),
(83, '家居服', '', '家居服', 100, 0, 1),
(84, '美体衣', '', '美体衣', 100, 0, 0),
(85, '碎花', '', '碎花', 100, 1, 1),
(86, '做旧', '', '做旧', 100, 0, 0),
(87, '卡其', '', '卡其', 100, 0, 1),
(88, '百搭', '', '百搭', 100, 1, 0),
(89, '破洞', '', '破洞', 100, 0, 0),
(90, '星条旗', '', '星条旗', 100, 0, 0),
(91, '运动裤', '', '运动裤', 100, 0, 0),
(92, '卡其裤', '', '卡其裤', 100, 0, 0),
(93, '迷你裙', '', '迷你裙', 100, 0, 1),
(94, '直筒裤', '', '直筒裤', 100, 0, 0),
(95, '纱裙', '', '纱裙', 100, 0, 3),
(96, '铅笔裤', '', '铅笔裤', 100, 0, 1),
(97, '休闲裤', '', '休闲裤', 100, 0, 13),
(98, '哈伦裤', 'cache/tag/20130829/1377741578.jpg', '哈伦裤', 100, 1, 2),
(99, '蓬蓬裙', '', '蓬蓬裙', 100, 0, 2),
(100, '阔腿裤', '', '阔腿裤', 100, 0, 2),
(101, '牛仔裙', '', '牛仔裙', 100, 0, 3),
(102, '高腰', 'cache/tag/20130829/1377741558.jpg', '高腰', 100, 1, 2),
(103, '垮裤', '', '垮裤', 100, 0, 0),
(104, '七分裤', '', '七分裤', 100, 0, 3),
(105, '九分裤', '', '九分裤', 100, 0, 2),
(106, '五分裤', '', '五分裤', 100, 0, 1),
(107, '背带裤', 'cache/tag/20130829/1377741602.jpg', '背带裤', 100, 0, 8),
(108, '洞洞鞋', '', '洞洞鞋', 100, 0, 0),
(109, '靴子', '', '靴子', 100, 0, 2),
(110, '单鞋', 'cache/tag/20130829/1377743904.jpg', '单鞋', 100, 1, 22),
(111, '娃娃鞋', '', '娃娃鞋', 100, 0, 3),
(112, '板鞋', '', '板鞋', 100, 0, 29),
(113, '果冻鞋', '', '果冻鞋', 100, 0, 0),
(114, '雨鞋', '', '雨鞋', 100, 0, 5),
(115, '家居鞋', '', '家居鞋', 100, 0, 0),
(116, '松糕鞋', '', '松糕鞋', 100, 0, 2),
(117, '摇摇鞋', '', '摇摇鞋', 100, 0, 0),
(118, '平底鞋', 'cache/tag/20130829/1377743912.jpg', '平底鞋', 100, 0, 2),
(119, '人字拖', '', '人字拖', 100, 0, 0),
(120, '平跟', '', '平跟', 100, 0, 0),
(121, '高跟', '', '高跟', 100, 1, 2),
(122, '粗跟', '', '粗跟', 100, 0, 0),
(123, '坡跟', 'cache/tag/20130829/1377743896.jpg', '坡跟', 100, 1, 0),
(124, '低帮', '', '低帮', 100, 0, 0),
(125, '高帮', '', '高帮', 100, 0, 1),
(126, '鱼嘴', 'cache/tag/20130829/1377743890.jpg', '鱼嘴', 100, 1, 12),
(127, '圆头', '', '圆头', 100, 0, 5),
(128, '尖头', '', '尖头', 100, 0, 8),
(129, '防水台', 'cache/tag/20130829/1377743885.jpg', '防水台', 100, 1, 0),
(130, '罗马', '', '罗马', 100, 0, 4),
(131, '裸色', '', '裸色', 100, 1, 0),
(132, '草编', '', '草编', 100, 1, 3),
(133, '木底', '', '木底', 100, 0, 0),
(134, '镂空', '', '镂空', 100, 1, 5),
(135, '豹纹', '', '豹纹', 100, 1, 1),
(136, '花朵', '', '花朵', 100, 1, 7),
(137, '复古英伦', '', '复古英伦', 100, 0, 0),
(138, '恋爱七夕', '', '恋爱七夕', 100, 0, 0),
(139, '匡威', '', '匡威', 100, 0, 1),
(140, 'adidas', '', 'adidas', 100, 0, 1),
(141, '小辣椒', '', '小辣椒', 100, 0, 1),
(142, '踏浪海滩', '', '踏浪海滩', 100, 0, 0),
(143, '糖果季', '', '糖果季', 100, 0, 0),
(144, '小清新', '', '小清新', 100, 0, 0),
(145, '布洛克', '', '布洛克', 100, 0, 4),
(146, 'Brogue', '', 'Brogue', 100, 0, 1),
(147, '旅行箱', '', '旅行箱', 100, 0, 17),
(148, '手提包', '', '手提包', 100, 1, 47),
(149, '斜挎包', '', '斜挎包', 100, 1, 51),
(150, '双肩包', '', '双肩包', 100, 1, 36),
(151, '手拿包', '', '手拿包', 100, 1, 23),
(152, '相机包', '', '相机包', 100, 1, 0),
(153, '卡包', 'cache/tag/20130829/1377747394.jpg', '卡包', 100, 1, 15),
(154, '零钱包', '', '零钱包', 100, 1, 9),
(155, '托特包', '', '托特包', 100, 0, 0),
(156, '信封包', '', '信封包', 100, 0, 0),
(157, '邮差包', '', '邮差包', 100, 1, 0),
(158, '草编包', '', '草编包', 100, 0, 0),
(159, '链条包', '', '链条包', 100, 1, 0),
(160, '公文包', '', '公文包', 100, 1, 2),
(161, '环保袋', '', '环保袋', 100, 0, 1),
(162, '机车包', '', '机车包', 100, 0, 2),
(163, '水桶包', '', '水桶包', 100, 0, 0),
(164, '帆布包', '', '帆布包', 100, 1, 4),
(165, '通勤', '', '通勤', 100, 0, 7),
(166, '牛仔', '', '牛仔', 100, 1, 1),
(167, '漆皮', '', '漆皮', 100, 0, 1),
(168, '格纹', '', '格纹', 100, 0, 0),
(169, '菱格', '', '菱格', 100, 0, 0),
(170, '流苏', '', '流苏', 100, 0, 3),
(171, '铆钉', '', '铆钉', 100, 0, 1),
(172, '鳄鱼纹', '', '鳄鱼纹', 100, 0, 3),
(173, '创意包包', '', '创意包包', 100, 0, 0),
(174, '鸵鸟纹', '', '鸵鸟纹', 100, 0, 0),
(175, '购物袋', '', '购物袋', 100, 0, 3),
(176, '大牌同款', '', '大牌同款', 100, 0, 0),
(177, '迷你包包', '', '迷你包包', 100, 0, 0),
(178, '手机袋', '', '手机袋', 100, 0, 0),
(179, 'IT', '', 'IT', 100, 0, 0),
(180, 'Bag', '', 'Bag', 100, 0, 0),
(181, '鸭舌帽', '', '鸭舌帽', 100, 0, 0),
(182, '发饰', '', '发饰', 100, 0, 22),
(183, '丝巾', '', '丝巾', 100, 0, 1),
(184, '镜框', '', '镜框', 100, 0, 1),
(185, '项链', 'cache/tag/20130829/1377756164.jpg', '项链', 100, 0, 69),
(186, '耳钉', '', '耳钉', 100, 0, 48),
(187, '胸针', '', '胸针', 100, 0, 5),
(188, '腰带', '', '腰带', 100, 0, 3),
(189, '手链', 'cache/tag/20130829/1377756175.jpg', '手链', 100, 1, 1),
(190, '发带', '', '发带', 100, 0, 3),
(191, '手表', 'cache/tag/20130829/1377756150.jpg', '手表', 100, 1, 1),
(192, '手镯 戒指', '', '手镯 戒指', 100, 0, 0),
(193, '吊坠', '', '吊坠', 100, 1, 1),
(194, '草帽', '', '草帽', 100, 0, 6),
(195, '墨镜', '', '墨镜', 100, 1, 11),
(196, '耳环', 'cache/tag/20130829/1377756158.jpg', '耳环', 100, 1, 36),
(197, '蓝色幻想', '', '蓝色幻想', 100, 0, 0),
(198, 'Zakka', '', 'Zakka', 100, 0, 4),
(199, '手作', '', '手作', 100, 0, 0),
(200, '海洋', '', '海洋', 100, 0, 8),
(201, '卖萌', '', '卖萌', 100, 0, 0),
(202, 'ROCK', '', 'ROCK', 100, 0, 0),
(203, 'SWATCH', '', 'SWATCH', 100, 0, 0),
(204, '施华洛世奇', '', '施华洛世奇', 100, 0, 0),
(205, '奈良美智', '', '奈良美智', 100, 0, 0),
(206, '羽毛', '', '羽毛', 100, 0, 1),
(207, '陶饰', '', '陶饰', 100, 0, 0),
(208, '水晶', 'cache/tag/20130829/1377756181.jpg', '水晶', 100, 0, 42),
(209, '珍珠', '', '珍珠', 100, 0, 3),
(210, '心心相印', '', '心心相印', 100, 0, 0),
(211, '编织', '', '编织', 100, 1, 1),
(212, '玫瑰金', '', '玫瑰金', 100, 0, 0),
(213, '天使之翼', '', '天使之翼', 100, 0, 0),
(214, '清洁', '', '清洁', 100, 0, 4),
(215, '爽肤水', '', '爽肤水', 100, 0, 5),
(216, '喷雾', '', '喷雾', 100, 0, 0),
(217, '精华素', '', '精华素', 100, 0, 0),
(218, '去角质', '', '去角质', 100, 0, 1),
(219, '唇膏', 'cache/tag/20130829/1377757651.jpg', '唇膏', 100, 1, 1),
(220, '面膜', 'cache/tag/20130829/1377757679.jpg', '面膜', 100, 0, 5),
(221, '乳霜', '', '乳霜', 100, 0, 0),
(222, '眼霜', '', '眼霜', 100, 0, 0),
(223, '眼唇膜', '', '眼唇膜', 100, 0, 0),
(224, '防晒', '', '防晒', 100, 1, 1),
(225, '隔离', '', '隔离', 100, 0, 2),
(226, '保湿', '', '保湿', 100, 1, 3),
(227, '美白', '', '美白', 100, 1, 4),
(228, '祛痘', '', '祛痘', 100, 0, 2),
(229, '控油', '', '控油', 100, 0, 0),
(230, '美甲', '', '美甲', 100, 1, 0),
(231, '香水', '', '香水', 100, 1, 1),
(232, '唇彩', '', '唇彩', 100, 1, 2),
(233, '腮红', '', '腮红', 100, 1, 0),
(234, '睫毛膏', '', '睫毛膏', 100, 1, 1),
(235, '眼影', '', '眼影', 100, 1, 0),
(236, '眼线', 'cache/tag/20130829/1377757694.jpg', '眼线', 100, 0, 1),
(237, 'BB霜', 'cache/tag/20130829/1377757684.jpg', 'BB霜', 100, 0, 2),
(238, '蜜粉', '', '蜜粉', 100, 0, 1),
(239, '粉底', '', '粉底', 100, 0, 2),
(240, '化妆刷', '', '化妆刷', 100, 1, 0),
(241, 'MAC', '', 'MAC', 100, 0, 0),
(242, '资生堂', '', '资生堂', 100, 1, 1),
(243, '嘉娜宝', '', '嘉娜宝', 100, 0, 0),
(244, 'KOSE', '', 'KOSE', 100, 0, 0),
(245, '贝玲妃', '', '贝玲妃', 100, 1, 0),
(246, '水宝宝', '', '水宝宝', 100, 0, 0),
(247, '倩碧', '', '倩碧', 100, 0, 1),
(248, '露得清', '', '露得清', 100, 0, 0),
(249, 'Kiehl''s', '', 'Kiehl''s', 100, 0, 0),
(250, '爱丽小屋', '', '爱丽小屋', 100, 0, 0),
(251, '雅漾', '', '雅漾', 100, 0, 0),
(252, '卸妆', '', '卸妆', 100, 1, 1),
(253, '手工皂', '', '手工皂', 100, 1, 0),
(254, '毛孔', '', '毛孔', 100, 0, 2),
(255, '药妆', '', '药妆', 100, 0, 0),
(256, '抱枕', '', '抱枕', 100, 1, 4),
(257, '玩偶', '', '玩偶', 100, 1, 0),
(258, '灯饰', '', '灯饰', 100, 0, 1),
(259, '摆件', '', '摆件', 100, 1, 9),
(260, '厨具', '', '厨具', 100, 0, 0),
(261, '餐具', '', '餐具', 100, 1, 4),
(262, '伞', '', '伞', 100, 0, 0),
(263, '闹钟', '', '闹钟', 100, 0, 1),
(264, '马克杯', 'cache/tag/20130829/1377759677.jpg', '马克杯', 100, 1, 1),
(265, '杯具', '', '杯具', 100, 0, 0),
(266, '储蓄罐', '', '储蓄罐', 100, 0, 0),
(267, '铁盒', '', '铁盒', 100, 1, 3),
(268, '密封罐', '', '密封罐', 100, 0, 2),
(269, '保温杯', '', '保温杯', 100, 0, 0),
(270, '玻璃器皿', '', '玻璃器皿', 100, 0, 0),
(271, '创意礼品', '', '创意礼品', 100, 0, 0),
(272, '笔', '', '笔', 100, 0, 0),
(273, '笔记本', '', '笔记本', 100, 1, 0),
(274, '相册', '', '相册', 100, 1, 0),
(275, '明信片', '', '明信片', 100, 1, 0),
(276, '笔袋', '', '笔袋', 100, 1, 1),
(277, '钥匙扣', '', '钥匙扣', 100, 1, 0),
(278, '笔筒', '', '笔筒', 100, 0, 2),
(279, '贴纸', '', '贴纸&胶带', 100, 1, 0),
(280, '胶带', '', '胶带', 100, 0, 0),
(281, '纸巾盒', '', '纸巾盒', 100, 0, 4),
(282, '橱柜', '', '橱柜', 100, 0, 0),
(283, '收纳箱', '', '收纳箱', 100, 0, 0),
(284, '眼镜盒', '', '眼镜盒', 100, 0, 0),
(285, '首饰盒', '', '首饰盒', 100, 1, 3),
(286, '保护壳', '', '保护壳', 100, 1, 0),
(287, '相机', '', '相机', 100, 1, 3),
(288, '拍立得', '', '拍立得', 100, 0, 0),
(289, '電話', '', '電話', 100, 0, 0),
(290, 'LOMO', '', 'LOMO', 100, 1, 0),
(291, '耳机', '', '耳机', 100, 1, 0),
(292, '手机链', '', '手机链', 100, 1, 1),
(293, '长袖T恤', '', '长袖T恤', 100, 0, 4),
(294, '针织衫', '', '针织衫', 100, 0, 17),
(295, '毛衣', '', '毛衣', 100, 0, 16),
(296, '风衣', '', '风衣', 100, 0, 5),
(297, '短外套', 'cache/tag/20130829/1377739688.jpg', '短外套', 100, 0, 3),
(298, '卫衣', '', '卫衣', 100, 0, 8),
(299, '西装', '', '西装', 100, 0, 2),
(300, '马夹', '', '马夹', 100, 0, 1),
(301, '皮衣', '', '皮衣', 100, 0, 5),
(302, '机车夹克', '', '机车夹克', 100, 0, 0),
(303, '背心裙', '', '背心裙', 100, 0, 2),
(304, '花苞裙', '', '花苞裙', 100, 0, 1),
(305, '吊带衫', 'cache/tag/20130829/1377739642.jpg', '吊带衫', 100, 0, 1),
(306, '吊带裙', 'cache/tag/20130829/1377739671.jpg', '吊带裙', 100, 0, 1),
(307, '短袖T恤', '', '短袖T恤', 100, 0, 6),
(308, '中老年服装', '', '中老年服装', 100, 0, 0),
(309, '婚纱', '', '婚纱', 100, 0, 2),
(310, '礼服', '', '礼服', 100, 0, 1),
(311, '旗袍', '', '旗袍', 100, 0, 2),
(312, '职业套装', '', '职业套装', 100, 0, 0),
(313, '工作制服', '', '工作制服', 100, 0, 0),
(314, '校服', '', '校服', 100, 0, 0),
(315, '唐装', '', '唐装', 100, 0, 1),
(316, '民族服装', '', '民族服装', 100, 0, 0),
(317, '舞台服装', '', '舞台服装', 100, 0, 0),
(318, '休闲套装', '', '休闲套装', 100, 0, 1),
(319, '孕妇装', '', '孕妇装', 100, 0, 4),
(320, '秋冬装', '', '秋冬装', 100, 0, 1),
(321, '蕾丝T', '', '蕾丝T', 100, 0, 0),
(322, '海魂衫', '', '海魂衫', 100, 0, 1),
(323, '小西装', '', '小西装', 100, 0, 4),
(324, '小披肩', '', '小披肩', 100, 0, 3),
(325, '加长T', '', '加长T', 100, 0, 0),
(326, '正装裙', '', '正装裙', 100, 0, 0),
(327, '雪纺裙', '', '雪纺裙', 99, 0, 2),
(328, 'POLO衫', '', 'POLO衫', 100, 0, 0),
(329, '长袖衬衫', '', '长袖衬衫', 100, 0, 17),
(330, '长袖POLO衫', '', '长袖POLO衫', 100, 0, 0),
(331, '套头卫衣', '', '套头卫衣', 100, 0, 1),
(332, '套衫毛衣', '', '套衫毛衣', 100, 0, 0),
(333, '开衫毛衣', '', '开衫毛衣', 100, 0, 1),
(334, '羊绒毛衣', '', '羊绒毛衣', 100, 0, 0),
(335, '开衫卫衣', '', '开衫卫衣', 100, 0, 1),
(336, '夹克', '', '夹克', 100, 0, 2),
(337, '立领夹克', '', '立领夹克', 100, 0, 0),
(338, '休闲西服', '', '休闲西服', 100, 0, 1),
(339, '真皮皮衣', '', '真皮皮衣', 100, 0, 1),
(340, '仿皮皮衣', '', '仿皮皮衣', 100, 0, 0),
(341, '毛呢大衣', '', '毛呢大衣', 100, 0, 1),
(342, '中长棉衣', '', '中长棉衣', 100, 0, 0),
(343, '短款棉衣', '', '短款棉衣', 100, 0, 0),
(344, '短款羽绒服', '', '短款羽绒服', 100, 0, 1),
(345, '中长羽绒服', '', '中长羽绒服', 100, 0, 0),
(346, '短袖POLO衫', '', '短袖POLO衫', 100, 0, 0),
(347, '短袖衬衫', '', '短袖衬衫', 100, 0, 2),
(348, '西服套装', '', '西服套装', 100, 0, 0),
(349, '西裤', '', '西裤', 100, 0, 0),
(350, '大码专区', '', '大码专区', 100, 0, 0),
(351, '西服正装', '', '西服正装', 100, 0, 0),
(352, '工装制服', '', '工装制服', 100, 0, 0),
(353, '内衣', '', '内衣', 100, 0, 7),
(354, '休闲长裤', '', '休闲长裤', 100, 0, 1),
(355, '打底裤', '', '打底裤', 100, 0, 9),
(356, '中裤', '', '中裤', 100, 0, 2),
(357, '灯笼裤', '', '灯笼裤', 100, 0, 1),
(358, '微喇裤', '', '微喇裤', 100, 0, 0),
(359, '小脚裤', 'cache/tag/20130829/1377741584.jpg', '小脚裤', 100, 0, 25),
(360, '工装裤', '', '工装裤', 100, 0, 0),
(361, '连身裤', '', '连身裤', 100, 0, 2),
(362, '牛仔裤', 'cache/tag/20130829/1377741596.jpg', '牛仔裤', 100, 0, 6),
(363, '热裤', '', '热裤', 100, 0, 10),
(364, '靴裤', '', '靴裤', 100, 0, 1),
(365, '牛仔短裤', '', '牛仔短裤', 100, 0, 4),
(366, '休闲短裤', '', '休闲短裤', 100, 0, 1),
(367, '长裤', '', '长裤', 100, 0, 18),
(368, '牛仔长裤', '', '牛仔长裤', 100, 0, 1),
(369, '大PP裤', '', '大PP裤', 100, 0, 0),
(370, '皮裤', '', '皮裤', 100, 0, 1),
(371, '凉拖', '', '凉拖', 100, 0, 1),
(372, '鱼嘴鞋', '', '鱼嘴鞋', 100, 0, 16),
(373, '高跟鞋', 'cache/tag/20130829/1377743864.jpg', '高跟鞋', 100, 0, 6),
(374, '厚底鞋', '', '厚底鞋', 100, 0, 4),
(375, '内增高鞋', '', '内增高鞋', 100, 0, 0),
(376, '高帮鞋', 'cache/tag/20130829/1377743855.jpg', '高帮鞋', 100, 0, 4),
(377, '休闲鞋', '', '休闲鞋', 100, 0, 31),
(378, '休闲皮鞋', '', '休闲皮鞋', 100, 0, 2),
(379, '正装皮鞋', '', '正装皮鞋', 100, 0, 0),
(380, '增高鞋', '', '增高鞋', 100, 0, 1),
(381, '工装靴', '', '工装靴', 100, 0, 1),
(382, '牛仔靴', '', '牛仔靴', 100, 0, 1),
(383, '坡跟单鞋', '', '坡跟单鞋', 100, 0, 1),
(384, '短靴', '', '短靴', 100, 0, 1),
(385, '中筒靴', '', '中筒靴', 100, 0, 1),
(386, '雪地靴', '', '雪地靴', 100, 0, 1),
(387, '皮鞋', '', '皮鞋', 100, 0, 9),
(388, '女包', '', '女包', 100, 0, 1),
(389, '真皮包', 'cache/tag/20130829/1377747410.jpg', '真皮包', 100, 0, 0),
(390, 'PU女包', '', 'PU女包', 100, 0, 0),
(391, '流苏包', '', '流苏包', 100, 0, 1),
(392, '铆钉包', '', '铆钉包', 100, 0, 5),
(393, '蝴蝶结包', '', '蝴蝶结包', 100, 0, 2),
(394, '奢华包', '', '奢华包', 100, 0, 0),
(395, '品质包', '', '品质包', 100, 0, 0),
(396, '单肩', 'cache/tag/20130829/1377747450.jpg', '单肩', 100, 0, 67),
(397, '双肩', 'cache/tag/20130829/1377747437.jpg', '双肩', 100, 0, 12),
(398, '手提', 'cache/tag/20130829/1377747417.jpg', '手提', 100, 0, 50),
(399, '斜挎', 'cache/tag/20130829/1377747444.jpg', '斜挎', 100, 0, 29),
(400, '单肩斜跨', '', '单肩斜跨', 100, 0, 30),
(401, '腰包', '', '腰包', 100, 0, 1),
(402, '钥匙包', '', '钥匙包', 100, 0, 1),
(403, '男包', '', '男包', 100, 0, 3),
(404, '胸包', '', '胸包', 100, 0, 1),
(405, '编织包', '', '编织包', 100, 0, 188),
(406, '格纹包', '', '格纹包', 100, 0, 0),
(407, '豹纹包', '', '豹纹包', 100, 0, 0),
(408, '复古包', '', '复古包', 100, 0, 23),
(409, '拉杆箱', '', '拉杆箱', 100, 0, 19),
(410, '登机箱', '', '登机箱', 100, 0, 6),
(411, '托运箱', '', '托运箱', 100, 0, 1),
(412, '旅行包', 'cache/tag/20130829/1377747424.jpg', '旅行包', 100, 0, 9),
(413, '运动背包', 'cache/tag/20130829/1377747429.jpg', '运动背包', 100, 0, 0),
(414, '帆布背包', '', '帆布背包', 100, 0, 1),
(415, '单肩背包', '', '单肩背包', 100, 0, 1),
(416, '休闲钱包', '', '休闲钱包', 100, 0, 0),
(417, '帆布腰包', '', '帆布腰包', 100, 0, 0),
(418, '女士配件', '', '女士配件', 100, 0, 0),
(419, '宽腰带', '', '宽腰带', 100, 0, 2),
(420, '腰封', '', '腰封', 100, 0, 4),
(421, '腰链', '', '腰链', 100, 0, 0),
(422, '棒球帽', '', '棒球帽', 100, 0, 1),
(423, '贝雷帽', '', '贝雷帽', 100, 0, 0),
(424, '遮阳帽', '', '遮阳帽', 100, 0, 7),
(425, '围巾', '', '围巾', 100, 0, 1),
(426, '头巾', '', '头巾', 100, 0, 0),
(427, '手帕', '', '手帕', 100, 0, 0),
(428, '背带', '', '背带', 100, 0, 5),
(429, '运动颈环', '', '运动颈环', 100, 0, 0),
(430, '面料', '', '面料', 100, 0, 1),
(431, '服装配件', '', '服装配件', 100, 0, 0),
(432, '婚纱配件', '', '婚纱配件', 100, 0, 0),
(433, '男士配件', '', '男士配件', 100, 0, 0),
(434, '皮带', '', '皮带', 100, 0, 1),
(435, '真皮', '', '真皮', 100, 0, 8),
(436, '针扣', '', '针扣', 100, 0, 0),
(437, '自动扣', '', '自动扣', 100, 0, 0),
(438, '平滑扣', '', '平滑扣', 100, 0, 0),
(439, '双环扣', '', '双环扣', 100, 0, 0),
(440, '领带', '', '领带', 100, 0, 1),
(441, '领带夹', '', '领带夹', 100, 0, 0),
(442, '领结', '', '领结', 100, 0, 0),
(443, '袖扣', '', '袖扣', 100, 0, 0),
(444, '大沿帽', '', '大沿帽', 100, 0, 1),
(445, '防晒手套', '', '防晒手套', 100, 0, 0),
(446, '空调披肩', '', '空调披肩', 100, 0, 0),
(447, '项坠', '', '项坠', 100, 0, 1),
(448, '耳饰', '', '耳饰', 100, 0, 20),
(449, '手镯', '', '手镯', 100, 0, 16),
(450, '脚链', '', '脚链', 100, 0, 1),
(451, '戒指', 'cache/tag/20130829/1377756196.jpg', '戒指', 100, 0, 31),
(452, '指环', '', '指环', 100, 0, 10),
(453, '眼镜', '', '眼镜', 100, 0, 3),
(454, '烟具军刀', '', '烟具军刀', 100, 0, 0),
(455, '饰品', '', '饰品', 100, 0, 86),
(456, '展示架', '', '展示架', 100, 0, 0),
(457, '首饰', '', '首饰', 100, 0, 13),
(458, '银饰', '', '银饰', 100, 0, 5),
(459, '太阳镜', 'cache/tag/20130829/1377756188.jpg', '太阳镜', 100, 0, 7),
(460, '镜架', '', '镜架', 100, 0, 1),
(461, '镜片', '', '镜片', 100, 0, 0),
(462, '军刀', '', '军刀', 100, 0, 0),
(463, '打火机', '', '打火机', 100, 0, 0),
(464, 'ZIPPO', '', 'ZIPPO', 100, 0, 0),
(465, '芝宝', '', '芝宝', 100, 0, 0),
(466, '酒具', '', '酒具', 100, 0, 0),
(467, '烟具', '', '烟具', 100, 0, 0),
(468, '烟斗', '', '烟斗', 100, 0, 0),
(469, '烟嘴', '', '烟嘴', 100, 0, 0),
(470, '瑞士军刀', '', '瑞士军刀', 100, 0, 0),
(471, '对戒', '', '对戒', 100, 0, 2),
(472, '裸钻', '', '裸钻', 100, 0, 0),
(473, '挂饰', '', '挂饰', 100, 0, 3),
(474, '发簪', '', '发簪', 100, 0, 0),
(475, '玉佩', '', '玉佩', 100, 0, 0),
(476, '平安扣', '', '平安扣', 100, 0, 0),
(477, '女表', '', '女表', 100, 0, 5),
(478, '男表', '', '男表', 100, 0, 1),
(479, '中性表', '', '中性表', 100, 0, 0),
(480, '情侣表', '', '情侣表', 100, 0, 0),
(481, '儿童表', '', '儿童表', 100, 0, 0),
(482, '怀表', '', '怀表', 100, 0, 3),
(483, '机械表', '', '机械表', 100, 0, 0),
(484, '电子表', '', '电子表', 100, 0, 0),
(485, '时装表', '', '时装表', 100, 0, 2),
(486, '自动机械表', '', '自动机械表', 100, 0, 0),
(487, '光能表', '', '光能表', 100, 0, 0),
(488, '人工动能表', '', '人工动能表', 100, 0, 0),
(489, '石英表', '', '石英表', 100, 0, 1),
(490, '对表', '', '对表', 100, 0, 0),
(491, '护肤', 'cache/tag/20130829/1377757634.jpg', '护肤', 100, 0, 1),
(492, '洁面', '', '洁面', 100, 0, 2),
(493, '化妆水', '', '化妆水', 100, 0, 1),
(494, '精华液', '', '精华液', 100, 0, 2),
(495, '眼部护理', '', '眼部护理', 100, 0, 0),
(496, '乳液', '', '乳液', 100, 0, 8),
(497, '面霜', '', '面霜', 100, 0, 4),
(498, '磨砂膏', '', '磨砂膏', 100, 0, 0),
(499, '去角质膏', '', '去角质膏', 100, 0, 0),
(500, '防晒霜', '', '防晒霜', 100, 0, 3),
(501, '彩妆', '', '彩妆', 100, 0, 1),
(502, '隔离霜', '', '隔离霜', 100, 0, 1),
(503, '遮瑕膏', '', '遮瑕膏', 100, 0, 1),
(504, '粉饼', '', '粉饼', 100, 0, 3),
(505, '胭脂', '', '胭脂', 100, 0, 0),
(506, '散粉', '', '散粉', 100, 0, 0),
(507, '修颜', '', '修颜', 100, 0, 1),
(508, '唇蜜', '', '唇蜜', 100, 0, 0),
(509, '口红', 'cache/tag/20130829/1377757659.jpg', '口红', 100, 0, 1),
(510, '指甲油', 'cache/tag/20130829/1377757669.jpg', '指甲油', 100, 0, 0),
(511, '花香调', '', '花香调', 100, 0, 0),
(512, '花果香', '', '花果香', 100, 0, 1),
(513, '树木香', '', '树木香', 100, 0, 0),
(514, '东方香', '', '东方香', 100, 0, 0),
(515, '海洋香', '', '海洋香', 100, 0, 0),
(516, '森林香', '', '森林香', 100, 0, 1),
(517, '混合香', '', '混合香', 100, 0, 0),
(518, '琥珀香', '', '琥珀香', 100, 0, 0),
(519, '美容', '', '美容', 100, 0, 1),
(520, '化妆', '', '化妆', 100, 0, 1),
(521, '假睫毛', '', '假睫毛', 100, 0, 0),
(522, '化妆棉', '', '化妆棉', 100, 0, 0),
(523, '化妆包', '', '化妆包', 100, 0, 1),
(524, '身体护理', '', '身体护理', 100, 0, 0),
(525, '假发', 'cache/tag/20130829/1377757626.jpg', '假发', 100, 0, 0),
(526, '身体防晒', '', '身体防晒', 100, 0, 0),
(527, '身体乳液', '', '身体乳液', 100, 0, 0),
(528, '脱毛膏', '', '脱毛膏', 100, 0, 0),
(529, '手部保养', '', '手部保养', 100, 0, 0),
(530, '胸部护理', '', '胸部护理', 100, 0, 0),
(531, '瘦身霜', '', '瘦身霜', 100, 0, 0),
(532, '磨砂', '', '磨砂', 100, 0, 3),
(533, '洗发', '', '洗发', 100, 0, 0),
(534, '护发', '', '护发', 100, 0, 0),
(535, '染烫', '', '染烫', 100, 0, 0),
(536, '造型', '', '造型', 100, 0, 1),
(537, '剃须', '', '剃须', 100, 0, 1),
(538, '须后', '', '须后', 100, 0, 2),
(539, '沐浴', '', '沐浴', 100, 0, 0),
(540, '男士彩妆', '', '男士彩妆', 100, 0, 0),
(541, '护理套装', '', '护理套装', 100, 0, 0),
(542, '沙发', '', '沙发', 100, 0, 1),
(543, '电视柜', '', '电视柜', 100, 0, 0),
(544, '衣柜', '', '衣柜', 100, 0, 0),
(545, '书柜', '', '书柜', 100, 0, 1),
(546, '实木床', '', '实木床', 100, 0, 0),
(547, '皮艺床', '', '皮艺床', 100, 0, 0),
(548, '高低床', '', '高低床', 100, 0, 0),
(549, '子母床', '', '子母床', 100, 0, 0),
(550, '儿童床', '', '儿童床', 100, 0, 0),
(551, '电脑桌', '', '电脑桌', 100, 0, 0),
(552, '床垫', '', '床垫', 100, 0, 0),
(553, '茶几', '', '茶几', 100, 0, 2),
(554, '家具', '', '家具', 100, 0, 3),
(555, '餐桌', '', '餐桌', 100, 0, 3),
(556, '餐椅', '', '餐椅', 100, 0, 0),
(557, '书桌', 'cache/tag/20130829/1377759670.jpg', '书桌', 100, 0, 1),
(558, '鞋柜', 'cache/tag/20130829/1377759662.jpg', '鞋柜', 100, 0, 1),
(559, '床头柜', '', '床头柜', 100, 0, 0),
(560, '折叠床', '', '折叠床', 100, 0, 0),
(561, '午休床', '', '午休床', 100, 0, 0),
(562, '布艺床', '', '布艺床', 100, 0, 0),
(563, '搁板', '', '搁板', 100, 0, 0),
(564, '置物架', '', '置物架', 100, 0, 1),
(565, '桌椅', '', '桌椅', 100, 0, 0),
(566, '换鞋凳', '', '换鞋凳', 100, 0, 0),
(567, '躺椅', '', '躺椅', 100, 0, 0),
(568, '梳妆台', '', '梳妆台', 100, 0, 0),
(569, '办公椅', '', '办公椅', 100, 0, 0),
(570, '货架', '', '货架', 100, 0, 0),
(571, '展柜', '', '展柜', 100, 0, 0),
(572, '职员椅', '', '职员椅', 100, 0, 0),
(573, '电脑椅', '', '电脑椅', 100, 0, 0),
(574, '办公桌', '', '办公桌', 100, 0, 0),
(575, '文件柜', '', '文件柜', 100, 0, 0),
(576, '陈列柜', '', '陈列柜', 100, 0, 0),
(577, '大班台', '', '大班台', 100, 0, 0),
(578, '主管台', '', '主管台', 100, 0, 0),
(579, '布艺', '', '布艺', 100, 0, 2),
(580, '软饰', '', '软饰', 100, 0, 0),
(581, '地毯', '', '地毯', 100, 0, 1),
(582, '地垫', '', '地垫', 100, 0, 3),
(583, '壁毯', '', '壁毯', 100, 0, 0),
(584, '挂毯', '', '挂毯', 100, 0, 0),
(585, '十字绣', 'cache/tag/20130829/1377759655.jpg', '十字绣', 100, 0, 0),
(586, '刺绣', '', '刺绣', 100, 0, 3),
(587, '布套', '', '布套', 100, 0, 0),
(588, '桌布', '', '桌布', 100, 0, 1),
(589, '桌旗', '', '桌旗', 100, 0, 0),
(590, '靠垫', '', '靠垫', 100, 0, 7),
(591, '抱枕套', '', '抱枕套', 100, 0, 3),
(592, '盖巾', '', '盖巾', 100, 0, 0),
(593, '墙面软包', '', '墙面软包', 100, 0, 0),
(594, '窗帘', 'cache/tag/20130829/1377759635.jpg', '窗帘', 100, 0, 0),
(595, '卷帘', '', '卷帘', 100, 0, 0),
(596, '百叶帘', '', '百叶帘', 100, 0, 0),
(597, '线帘', '', '线帘', 100, 0, 0),
(598, '门帘', '', '门帘', 100, 0, 0),
(599, '纱窗', '', '纱窗', 100, 0, 0),
(600, '浴帘', '', '浴帘', 100, 0, 0),
(601, '窗帘杆', '', '窗帘杆', 100, 0, 0),
(602, '画框', '', '画框', 100, 0, 0),
(603, '无框画', '', '无框画', 100, 0, 0),
(604, '有框画', '', '有框画', 100, 0, 0),
(605, '墙贴', 'cache/tag/20130829/1377759613.jpg', '墙贴', 100, 0, 0),
(606, '雕刻工艺', '', '雕刻工艺', 100, 0, 0),
(607, '花瓶', '', '花瓶', 100, 0, 3),
(608, '花器', '', '花器', 100, 0, 3),
(609, '仿真花卉', '', '仿真花卉', 100, 0, 1),
(610, '蜡烛', '', '蜡烛', 100, 0, 1),
(611, '烛台', '', '烛台', 100, 0, 0),
(612, '工艺船', '', '工艺船', 100, 0, 0),
(613, '壁饰', '', '壁饰', 100, 0, 1),
(614, '竹碳包', '', '竹碳包', 100, 0, 0),
(615, '风筝', '', '风筝', 100, 0, 0),
(616, '中国结', '', '中国结', 100, 0, 0),
(617, '脸谱', '', '脸谱', 100, 0, 1),
(618, '雨伞', '', '雨伞', 100, 0, 0),
(619, '雨披', '', '雨披', 100, 0, 0),
(620, '烟灰缸', '', '烟灰缸', 100, 0, 0),
(621, '音乐盒', '', '音乐盒', 100, 0, 0),
(622, '招财猫', '', '招财猫', 100, 0, 1),
(623, '阳光罐', '', '阳光罐', 100, 0, 0),
(624, '幸运星', '', '幸运星', 100, 0, 1),
(625, '幸运瓶', '', '幸运瓶', 100, 0, 0),
(626, '扇', '', '扇', 100, 0, 2),
(627, '体重秤', '', '体重秤', 100, 0, 0),
(628, '防蚊贴', '', '防蚊贴', 100, 0, 0),
(629, '手环', '', '手环', 100, 0, 6),
(630, '电蚊香', '', '电蚊香', 100, 0, 0),
(631, '灭蚊灯', '', '灭蚊灯', 100, 0, 0),
(632, '灭鼠剂', '', '灭鼠剂', 100, 0, 0),
(633, '杀虫剂', '', '杀虫剂', 100, 0, 0),
(634, '保健枕', '', '保健枕', 100, 0, 0),
(635, '旅行枕', '', '旅行枕', 100, 0, 0),
(636, '枕头', 'cache/tag/20130829/1377759625.jpg', '枕头', 100, 0, 1),
(637, '枕芯', '', '枕芯', 100, 0, 1),
(638, '蚕丝被', '', '蚕丝被', 100, 0, 0),
(639, '羽绒被', '', '羽绒被', 100, 0, 0),
(640, '秋冬被', '', '秋冬被', 100, 0, 0),
(641, '棉被', '', '棉被', 100, 0, 0),
(642, '羊毛被', '', '羊毛被', 100, 0, 0),
(643, '毛毯', '', '毛毯', 100, 0, 0),
(644, '绒毯', '', '绒毯', 100, 0, 0),
(645, '床褥', '', '床褥', 100, 0, 0),
(646, '床单', 'cache/tag/20130829/1377759649.jpg', '床单', 100, 0, 1),
(647, '床笠', '', '床笠', 100, 0, 2),
(648, '被套', '', '被套', 100, 0, 1),
(649, '被罩', '', '被罩', 100, 0, 0),
(650, '枕套', '', '枕套', 100, 0, 0),
(651, '枕巾', '', '枕巾', 100, 0, 0),
(652, '沙发垫', '', '沙发垫', 100, 0, 1),
(653, '坐垫', '', '坐垫', 100, 0, 1),
(654, '棉拖鞋', '', '棉拖鞋', 100, 0, 1),
(655, '挂钟', '', '挂钟', 100, 0, 1),
(656, '梳妆镜', '', '梳妆镜', 100, 0, 1),
(657, '厨房', '', '厨房', 100, 0, 2),
(658, '保鲜盒', '', '保鲜盒', 100, 0, 0),
(659, '水壶', '', '水壶', 100, 0, 1),
(660, '杯具套装', '', '杯具套装', 100, 0, 0),
(661, '玻璃杯', '', '玻璃杯', 100, 0, 1),
(662, '碗', '', '碗', 100, 0, 4),
(663, '碟', '', '碟', 100, 0, 2),
(664, '盆', '', '盆', 100, 0, 0),
(665, '盘', '', '盘', 100, 0, 2),
(666, '筷子', '', '筷子', 100, 0, 0),
(667, '煎锅', '', '煎锅', 100, 0, 0),
(668, '平底锅', '', '平底锅', 100, 0, 0),
(669, '压力锅', '', '压力锅', 100, 0, 0),
(670, '烹饪', '', '烹饪', 100, 0, 0),
(671, '勺铲', '', '勺铲', 100, 0, 0),
(672, '燃气灶', '', '燃气灶', 100, 0, 0),
(673, '咖啡杯', '', '咖啡杯', 100, 0, 1),
(674, '酒杯', '', '酒杯', 100, 0, 2),
(675, '飘逸杯', '', '飘逸杯', 100, 0, 0),
(676, '茶具', '', '茶具', 100, 0, 1),
(677, '杯子', '', '杯子', 100, 0, 1),
(678, '壶', '', '壶', 100, 0, 1),
(679, '情侣杯', '', '情侣杯', 100, 0, 1),
(680, '隔热杯', '', '隔热杯', 100, 0, 0),
(681, '防漏杯', '', '防漏杯', 100, 0, 0),
(682, '定制杯', '', '定制杯', 100, 0, 0),
(683, '咖啡器具', '', '咖啡器具', 100, 0, 0),
(684, '酒壶', '', '酒壶', 100, 0, 0),
(685, '中西餐具', '', '中西餐具', 100, 0, 0),
(686, '餐桌小物', '', '餐桌小物', 100, 0, 0),
(687, '瓷器', '', '瓷器', 100, 0, 1),
(688, '微波用品', '', '微波用品', 100, 0, 0),
(689, '饭盒', '', '饭盒', 100, 0, 1),
(690, '挂钩', '', '挂钩', 100, 0, 0),
(691, '毛巾', '', '毛巾', 100, 0, 4),
(692, '浴巾', '', '浴巾', 100, 0, 2),
(693, '毛巾挂', '', '毛巾挂', 100, 0, 0),
(694, '毛巾架', '', '毛巾架', 100, 0, 0),
(695, '沐浴品', '', '沐浴品', 100, 0, 0),
(696, '沐浴桶', '', '沐浴桶', 100, 0, 0),
(697, '足浴盆', '', '足浴盆', 100, 0, 0),
(698, '浴室角架', '', '浴室角架', 100, 0, 0),
(699, '浴室用品套件', '', '浴室用品套件', 100, 0, 0),
(700, '浴球', '', '浴球', 100, 0, 0),
(701, '浴镜', '', '浴镜', 100, 0, 0),
(702, '牙膏', '', '牙膏', 100, 0, 0),
(703, '牙膏器', '', '牙膏器', 100, 0, 0),
(704, '牙刷', '', '牙刷', 100, 0, 0),
(705, '牙刷架', '', '牙刷架', 100, 0, 0),
(706, '牙刷座', '', '牙刷座', 100, 0, 0),
(707, '洗发水', '', '洗发水', 100, 0, 0),
(708, '足部护理', '', '足部护理', 100, 0, 0),
(709, '卫生巾', '', '卫生巾', 100, 0, 0),
(710, '卷筒纸', '', '卷筒纸', 100, 0, 0),
(711, '收纳', '', '收纳', 100, 0, 5),
(712, '压缩袋', '', '压缩袋', 100, 0, 0),
(713, '压缩泵', '', '压缩泵', 100, 0, 0),
(714, '挂衣架', '', '挂衣架', 100, 0, 0),
(715, '三角衣架', '', '三角衣架', 100, 0, 0),
(716, '拖把', '', '拖把', 100, 0, 1),
(717, '置地', '', '置地', 100, 0, 0),
(718, '洗衣液', '', '洗衣液', 100, 0, 0),
(719, '裤架', '', '裤架', 100, 0, 0),
(720, '收纳盒', '', '收纳盒', 100, 0, 2),
(721, '纸巾架', '', '纸巾架', 100, 0, 0),
(722, '卡套', '', '卡套', 100, 0, 0),
(723, '手机座', 'cache/tag/20130829/1377759642.jpg', '手机座', 100, 0, 0),
(724, '遥控器收纳', '', '遥控器收纳', 100, 0, 0),
(725, '卫生棉袋', '', '卫生棉袋', 100, 0, 0),
(726, '药盒', '', '药盒', 100, 0, 0),
(727, '医药箱', '', '医药箱', 100, 0, 0),
(728, 'CD盒', '', 'CD盒', 100, 0, 0),
(729, 'CD架', '', 'CD架', 100, 0, 0),
(730, '鞋盒', '', '鞋盒', 100, 0, 0),
(731, '鞋收纳', '', '鞋收纳', 100, 0, 0),
(732, '电线收纳', '', '电线收纳', 100, 0, 0),
(733, '擦地拖鞋', '', '擦地拖鞋', 100, 0, 0),
(734, '桌面除尘扫', '', '桌面除尘扫', 100, 0, 0),
(735, '扫把簸箕', '', '扫把簸箕', 100, 0, 0),
(736, '垃圾桶', '', '垃圾桶', 100, 0, 0),
(737, '垃圾袋', '', '垃圾袋', 100, 0, 0),
(738, '除尘掸', '', '除尘掸', 100, 0, 0),
(739, '地板护理', '', '地板护理', 100, 0, 0),
(740, '玻璃清洁器', '', '玻璃清洁器', 100, 0, 0),
(741, '护洗袋', '', '护洗袋', 100, 0, 0),
(742, '洗衣粉', '', '洗衣粉', 100, 0, 0),
(743, '洗衣皂', '', '洗衣皂', 100, 0, 0),
(744, '甲醛清除剂', '', '甲醛清除剂', 100, 0, 0),
(745, '竹炭包', '', '竹炭包', 100, 0, 0),
(746, '马桶座圈', '', '马桶座圈', 100, 0, 0),
(747, '洁厕剂', '', '洁厕剂', 100, 0, 0),
(748, '衬衣', '', '衬衣', 100, 0, 51),
(749, '开衫', 'cache/tag/20130829/1377739700.jpg', '开衫', 100, 0, 13),
(750, 'leggings', '', 'leggings', 100, 0, 0),
(751, 'one-piece', '', 'one-piece', 100, 0, 0),
(752, '秋日', '', '秋日', 100, 0, 1),
(753, '甜美', '', '甜美', 100, 0, 12),
(754, '混搭', '', '混搭', 100, 0, 0),
(755, '广东', '', '广东', 100, 0, 0),
(756, '浙江', '', '浙江', 100, 0, 0),
(757, '北京', '', '北京', 100, 0, 1),
(758, '上海', '', '上海', 100, 0, 0),
(759, '江苏', '', '江苏', 100, 0, 0),
(760, '四川', '', '四川', 100, 0, 0),
(761, '湖北', '', '湖北', 100, 0, 0),
(762, '沈阳', '', '沈阳', 100, 0, 0),
(763, '亚洲', '', '亚洲', 100, 0, 0),
(764, '欧洲', '', '欧洲', 100, 0, 3),
(765, '北美', '', '北美', 100, 0, 0),
(766, '澳洲', '', '澳洲', 100, 0, 1),
(767, '逛街', '', '逛街', 100, 0, 0),
(768, '居家', '', '居家', 100, 0, 1),
(769, '上学', '', '上学', 100, 0, 0),
(770, '户外', '', '户外', 100, 0, 1),
(771, '约会', '', '约会', 100, 0, 1),
(772, 'office', '', 'office', 100, 0, 0),
(773, '美食', '', '美食', 100, 0, 0),
(774, '美妆', '', '美妆', 100, 0, 0),
(775, '家居', '', '家居', 100, 0, 1),
(776, '配饰', '', '配饰', 100, 0, 1),
(777, '鞋子', '', '鞋子', 100, 0, 39),
(778, '包包', '', '包包', 100, 0, 127),
(779, '衣服', '', '衣服', 100, 0, 1),
(780, 'LV', '', 'LV', 100, 0, 0),
(781, 'Gucci', '', 'Gucci', 100, 0, 2),
(782, 'Dior', '', 'Dior', 100, 0, 2),
(783, 'Chanel', '', 'Chanel', 100, 0, 1),
(784, 'cartier', '', 'cartier', 100, 0, 0),
(785, '手机套', '', '手机套', 100, 0, 0),
(786, 'iphone', '', 'iphone', 100, 0, 1),
(787, 'Hello', '', 'Hello', 100, 0, 5),
(788, 'Kitty', '', 'Kitty', 100, 0, 3),
(789, 'DIY', '', 'DIY', 100, 0, 1),
(790, '小物', '', '小物', 100, 0, 0),
(791, '挂件', 'cache/tag/20130829/1377756203.jpg', '挂件', 100, 0, 2),
(792, '萌物', '', '萌物', 100, 0, 0),
(793, '深圳', '', '深圳', 100, 0, 0),
(794, '香港', '', '香港', 100, 0, 5),
(795, '重庆', '', '重庆', 100, 0, 0),
(796, '湖南', '', '湖南', 100, 0, 0),
(797, '新加坡', '', '新加坡', 100, 0, 0),
(798, '加拿大', '', '加拿大', 100, 0, 0),
(799, '美国', '', '美国', 100, 0, 1),
(800, '亮色', '', '亮色', 100, 0, 3),
(801, '格子', '', '格子', 100, 0, 1),
(802, '短裙', 'cache/tag/20130829/1377741570.jpg', '短裙', 100, 1, 16),
(803, '钉珠', '', '钉珠', 100, 0, 4),
(804, '夏装', '', '夏装', 100, 0, 18),
(805, '修身', '', '修身', 100, 0, 41),
(806, '上装', '', '上装', 100, 0, 540),
(807, '宽松', '', '宽松', 100, 0, 11),
(808, '女装', '', '女装', 100, 0, 23),
(809, '新款', '', '新款', 100, 0, 12),
(810, '韩版', '', '韩版', 100, 0, 9),
(811, '圆领', '', '圆领', 100, 0, 10),
(812, '蝙蝠', '', '蝙蝠', 100, 0, 5),
(813, '2013', '', '2013', 100, 0, 1),
(814, '翻晒', '', '翻晒', 100, 0, 1),
(815, '夏季', '', '夏季', 100, 0, 2),
(816, '韩系女', '', '韩系女', 100, 0, 1),
(817, '专柜', '', '专柜', 100, 0, 2),
(818, '外套', '', '外套', 100, 0, 12),
(819, '新品', '', '新品', 100, 0, 8),
(820, '苹果', '', '苹果', 100, 0, 1),
(821, 'GIRDEAR', '', 'GIRDEAR', 100, 0, 1),
(822, '中长', '', '中长', 100, 0, 16),
(823, '韩版显', '', '韩版显', 100, 0, 3),
(824, '潮流', '', '潮流', 100, 0, 1),
(825, '立领', '', '立领', 100, 0, 4),
(826, '特价', '', '特价', 100, 0, 2),
(827, '件套', '', '件套', 100, 0, 3),
(828, '国志', '', '国志', 100, 0, 1),
(829, '彩条', '', '彩条', 100, 0, 1),
(830, '职业装', '', '职业装', 100, 0, 2),
(831, '工作服', '', '工作服', 100, 0, 1),
(832, '套装', '', '套装', 100, 0, 6),
(833, '摩登舞', '', '摩登舞', 100, 0, 2),
(834, '拉丁舞', '', '拉丁舞', 100, 0, 3),
(835, '上衣', '', '上衣', 100, 0, 23),
(836, '恰恰', '', '恰恰', 100, 0, 1),
(837, '舞蹈', '', '舞蹈', 100, 0, 2),
(838, '健身', '', '健身', 100, 0, 1),
(839, 'Tops', '', 'Tops', 100, 0, 1),
(840, '时尚休闲', '', '时尚休闲', 100, 0, 6),
(841, '黑白', '', '黑白', 100, 0, 1),
(842, '纯色', '', '纯色', 100, 0, 3),
(843, '黄冠', '', '黄冠', 100, 0, 1),
(844, '纯棉', '', '纯棉', 100, 0, 1),
(845, '泡泡', '', '泡泡', 100, 0, 2),
(846, '中老年', '', '中老年', 100, 0, 1),
(847, '妈妈', '', '妈妈', 100, 0, 1),
(848, '品牌女装', '', '品牌女装', 100, 0, 1),
(849, '花色', '', '花色', 100, 0, 6),
(850, '品质', '', '品质', 100, 0, 15),
(851, '紧身', '', '紧身', 100, 0, 1),
(852, '蓝白', '', '蓝白', 100, 0, 2),
(853, '知性', '', '知性', 100, 0, 2),
(854, '春夏', '', '春夏', 100, 0, 2),
(855, '镶嵌', '', '镶嵌', 100, 0, 2),
(856, '绚丽', '', '绚丽', 100, 0, 3),
(857, '个性', '', '个性', 100, 0, 1),
(858, '女款', '', '女款', 100, 0, 1),
(859, '蝴蝶结', '', '蝴蝶结', 100, 0, 11),
(860, '全棉', '', '全棉', 100, 0, 5),
(861, '加长', '', '加长', 100, 0, 1),
(862, '高中生', '', '高中生', 100, 0, 1),
(863, '美丽', '', '美丽', 100, 0, 4),
(864, '翻领', '', '翻领', 100, 0, 22),
(865, '可爱', '', '可爱', 100, 0, 3),
(866, '精品', '', '精品', 100, 0, 5),
(867, '秋装', '', '秋装', 100, 0, 9),
(868, '运动套装', '', '运动套装', 100, 0, 1),
(869, '针织', '', '针织', 100, 0, 11),
(870, '名媛', '', '名媛', 100, 0, 1),
(871, '加大', '', '加大', 100, 0, 1),
(872, '无袖', '', '无袖', 100, 0, 3),
(873, '坎肩', '', '坎肩', 100, 0, 2),
(874, '薄荷', '', '薄荷', 100, 0, 1),
(875, '旗袍裙', '', '旗袍裙', 100, 0, 1),
(876, '短款', '', '短款', 100, 0, 3),
(877, '改良', '', '改良', 100, 0, 1),
(878, '气质', '', '气质', 100, 0, 6),
(879, '透气', '', '透气', 100, 0, 2),
(880, '舒适', '', '舒适', 100, 0, 2),
(881, '娃娃', '', '娃娃', 100, 0, 1),
(882, '麻料女', '', '麻料女', 100, 0, 1),
(883, '淑女', '', '淑女', 100, 1, 14),
(884, '时尚', '', '时尚', 100, 0, 21),
(885, '韩版中', '', '韩版中', 100, 0, 1),
(886, '带帽', '', '带帽', 100, 0, 1),
(887, '拉链', '', '拉链', 100, 0, 2),
(888, '春秋', '', '春秋', 100, 0, 8),
(889, '少女', '', '少女', 100, 0, 2),
(890, '创意', '', '创意', 100, 0, 11),
(891, '正品', '', '正品', 100, 0, 28),
(892, '拉丁', '', '拉丁', 100, 0, 3),
(893, '百褶', '', '百褶', 100, 0, 1),
(894, '摩登', '', '摩登', 100, 0, 2),
(895, '吊带', '', '吊带', 100, 0, 3),
(896, '广场', '', '广场', 100, 0, 3),
(897, '荷叶', '', '荷叶', 100, 0, 13),
(898, '学生', '', '学生', 100, 0, 2),
(899, '银丝', '', '银丝', 100, 0, 1),
(900, '娇小', '', '娇小', 100, 0, 1),
(901, '蘑菇', '', '蘑菇', 100, 0, 9),
(902, '猫咪', '', '猫咪', 100, 0, 2),
(903, '图案', '', '图案', 100, 0, 9),
(904, '清仓', '', '清仓', 100, 0, 3),
(905, '绣花', '', '绣花', 100, 0, 3),
(906, '立体', '', '立体', 100, 0, 21),
(907, '手工', '', '手工', 100, 0, 7),
(908, '纯白', '', '纯白', 100, 0, 2),
(909, '韩版女', '', '韩版女', 100, 0, 5),
(910, '凝华', '', '凝华', 100, 0, 1),
(911, '新风', '', '新风', 100, 0, 2),
(912, '日式', '', '日式', 100, 0, 6),
(913, '几何', '', '几何', 100, 0, 1),
(914, '民族', '', '民族', 100, 0, 2),
(915, '装饰', '', '装饰', 100, 0, 1),
(916, '麻棉', '', '麻棉', 100, 0, 1),
(917, '文艺', '', '文艺', 100, 0, 13),
(918, '长袖', '', '长袖', 100, 0, 96),
(919, '秋季', '', '秋季', 100, 0, 6),
(920, '山茶花', '', '山茶花', 100, 0, 1),
(921, '飘带', '', '飘带', 100, 0, 2),
(922, '韩国', '', '韩国', 100, 0, 8),
(923, '半身', '', '半身', 100, 0, 3),
(924, '正版', '', '正版', 100, 0, 5),
(925, '夏款', '', '夏款', 100, 0, 6),
(926, '爱女', '', '爱女', 100, 0, 1),
(927, '体恤', '', '体恤', 100, 0, 1),
(928, '31062146', '', '31062146', 100, 0, 1),
(929, '女士', '', '女士', 100, 0, 6),
(930, '品牌', '', '品牌', 100, 0, 1),
(931, '女红', '', '女红', 100, 0, 1),
(932, '大款', '', '大款', 100, 0, 2),
(933, '女式', '', '女式', 100, 0, 7),
(934, '衣衫', '', '衣衫', 100, 0, 1),
(935, '包邮秒', '', '包邮秒', 100, 0, 1),
(936, 'polo', '', 'polo', 100, 0, 1),
(937, '植绒', '', '植绒', 100, 0, 5),
(938, '圆点', '', '圆点', 100, 0, 1),
(939, '米色', '', '米色', 100, 0, 1),
(940, '1716', '', '1716', 100, 0, 2),
(941, '网布', '', '网布', 100, 0, 4),
(942, '时尚运动', '', '时尚运动', 100, 0, 2),
(943, '套头', '', '套头', 100, 0, 2),
(944, '范小', '', '范小', 100, 0, 6),
(945, '真丝', '', '真丝', 100, 0, 1),
(946, '粉色', '', '粉色', 100, 0, 19),
(947, 'ROJAY2013', '', 'ROJAY2013', 100, 0, 1),
(948, '弹性', '', '弹性', 100, 0, 1),
(949, '柔软', '', '柔软', 100, 0, 1),
(950, '中学生', '', '中学生', 100, 0, 1),
(951, '蝙蝠衫', '', '蝙蝠衫', 100, 0, 2),
(952, '恤衫', '', '恤衫', 100, 0, 1),
(953, '秋冬', '', '秋冬', 100, 0, 3),
(954, '女童', '', '女童', 100, 0, 5),
(955, '新森', '', '新森', 100, 0, 5),
(956, '小清', '', '小清', 100, 0, 12),
(957, '轻薄', '', '轻薄', 100, 0, 4),
(958, '波浪', '', '波浪', 100, 0, 1),
(959, '花瓣', '', '花瓣', 100, 0, 1),
(960, '清凉', '', '清凉', 100, 0, 3),
(961, '白色', '', '白色', 100, 0, 1),
(962, '秀气', '', '秀气', 100, 0, 2),
(963, '亚麻', '', '亚麻', 100, 0, 6),
(964, '外贸', '', '外贸', 100, 0, 1),
(965, '52017', '', '52017', 100, 0, 3),
(966, '棉质', '', '棉质', 100, 0, 3),
(967, '七分', '', '七分', 100, 0, 3),
(968, '花苞', '', '花苞', 100, 0, 5),
(969, '亮片', '', '亮片', 100, 0, 8),
(970, '低领', '', '低领', 100, 0, 1),
(971, '褶皱', '', '褶皱', 100, 0, 3),
(972, '系带', '', '系带', 100, 0, 8),
(973, '双层', '', '双层', 100, 0, 4),
(974, '女孩', '', '女孩', 100, 0, 4),
(975, '下摆', '', '下摆', 100, 0, 2),
(976, '背部', '', '背部', 100, 0, 2),
(977, '连帽女', '', '连帽女', 100, 0, 2),
(978, '学生潮', '', '学生潮', 100, 0, 1),
(979, 'FELINE', '', 'FELINE', 100, 0, 1),
(980, '绑带', '', '绑带', 100, 0, 5),
(981, '中高', '', '中高', 100, 0, 1),
(982, '边袖仙', '', '边袖仙', 100, 0, 1),
(983, '空调', '', '空调', 100, 0, 1),
(984, '包邮', '', '包邮', 100, 0, 6),
(985, '开襟', '', '开襟', 100, 0, 1),
(986, '春装', '', '春装', 100, 0, 12),
(987, 'trade', '', 'trade', 100, 0, 1),
(988, '丝花', '', '丝花', 100, 0, 1),
(989, '糖果', '', '糖果', 100, 0, 7),
(990, '睡裙', '', '睡裙', 100, 0, 1),
(991, '纽扣', '', '纽扣', 100, 0, 3),
(992, '爱心', '', '爱心', 100, 0, 1),
(993, '购价', '', '购价', 100, 0, 1),
(994, '白领', '', '白领', 100, 0, 1),
(995, '0218', '', '0218', 100, 0, 1),
(996, '女生', '', '女生', 100, 0, 4),
(997, '打底', '', '打底', 100, 0, 11),
(998, '预售', '', '预售', 100, 0, 1),
(999, '定制', '', '定制', 100, 0, 1),
(1000, 'VIVI', '', 'VIVI', 100, 0, 1),
(1001, '秋冬季', '', '秋冬季', 100, 0, 1),
(1002, '装有', '', '装有', 100, 0, 1),
(1003, '原创', '', '原创', 100, 0, 23),
(1004, '号手', '', '号手', 100, 0, 1),
(1005, '瑜伽服', '', '瑜伽服', 100, 0, 1),
(1006, '胸垫', '', '胸垫', 100, 0, 1),
(1007, '天蓝色', '', '天蓝色', 100, 0, 1),
(1008, '运动服', '', '运动服', 100, 0, 1),
(1009, '瑜伽', '', '瑜伽', 100, 0, 1),
(1010, '满百', '', '满百', 100, 0, 3),
(1011, '流行', '', '流行', 100, 0, 2),
(1012, '夏日', '', '夏日', 100, 0, 6),
(1013, '礼物', '', '礼物', 100, 0, 48),
(1014, '先进', '', '先进', 100, 0, 1),
(1015, 'YIGUE', '', 'YIGUE', 100, 0, 1),
(1016, '大方', '', '大方', 100, 0, 2),
(1017, '日韩', '', '日韩', 100, 0, 1),
(1018, '花环', '', '花环', 100, 0, 1),
(1019, 'bongjashop', '', 'bongjashop', 100, 0, 65),
(1020, '优雅', '', '优雅', 100, 0, 5),
(1021, '风格', '', '风格', 100, 0, 1),
(1022, 'babirolen', '', 'babirolen', 100, 0, 33),
(1023, 'anappletree', '', 'anappletree', 100, 0, 27),
(1024, '简洁', '', '简洁', 100, 0, 2),
(1025, 'mimididi', '', 'mimididi', 100, 0, 25),
(1026, '成人', '', '成人', 100, 0, 1),
(1027, '韩版小', '', '韩版小', 100, 0, 5),
(1028, '层层', '', '层层', 100, 0, 2),
(1029, '蛋糕', '', '蛋糕', 100, 0, 2),
(1030, '新正', '', '新正', 100, 0, 1),
(1031, '天波', '', '天波', 100, 0, 1),
(1032, '花边', '', '花边', 100, 0, 2),
(1033, '女孩子', '', '女孩子', 100, 0, 2),
(1034, '风风', '', '风风', 100, 0, 1),
(1035, '领子', '', '领子', 100, 0, 1),
(1036, '随意', '', '随意', 100, 0, 1),
(1037, '林风', '', '林风', 100, 0, 1),
(1038, '唯美', '', '唯美', 100, 0, 1),
(1039, 'sultang', '', 'sultang', 100, 0, 82),
(1040, '大牌', '', '大牌', 100, 0, 62),
(1041, '高端', '', '高端', 100, 0, 3),
(1042, 'tomnrabbit', '', 'tomnrabbit', 100, 0, 90),
(1043, 'pinkboll', '', 'pinkboll', 100, 0, 22),
(1044, '森林', '', '森林', 100, 0, 14),
(1045, '1021', '', '1021', 100, 0, 1),
(1046, '中童', '', '中童', 100, 0, 1),
(1047, '巴布', '', '巴布', 100, 0, 1),
(1048, '新潮', '', '新潮', 100, 0, 2),
(1049, '男童', '', '男童', 100, 0, 2),
(1050, '童装', '', '童装', 100, 0, 6),
(1051, '2013May4', '', '2013May4', 100, 0, 15),
(1052, 'EVEI', '', 'EVEI', 100, 0, 1),
(1053, '不规则', '', '不规则', 100, 0, 1),
(1054, '棉麻', '', '棉麻', 100, 0, 8),
(1055, '印染', '', '印染', 100, 0, 1),
(1056, '夏女', '', '夏女', 100, 0, 1),
(1057, '韩版大', '', '韩版大', 100, 0, 7),
(1058, '儿童', '', '儿童', 100, 0, 2),
(1059, '一字', '', '一字', 100, 0, 4),
(1060, '瘦小', '', '瘦小', 100, 0, 1),
(1061, '曲线', '', '曲线', 100, 0, 1),
(1062, '耳边', '', '耳边', 100, 0, 5),
(1063, '皇冠', '', '皇冠', 100, 0, 6),
(1064, '丝棉', '', '丝棉', 100, 0, 3),
(1065, '裤子', '', '裤子', 100, 0, 5),
(1066, '演绎', '', '演绎', 100, 0, 2),
(1067, '人士', '', '人士', 100, 0, 2),
(1068, '各种', '', '各种', 100, 0, 2),
(1069, '成功', '', '成功', 100, 0, 2),
(1070, '棉纱', '', '棉纱', 100, 0, 1),
(1071, '头家', '', '头家', 100, 0, 1),
(1072, '肚皮', '', '肚皮', 100, 0, 1),
(1073, '女神', '', '女神', 100, 0, 3),
(1074, '服装', '', '服装', 100, 0, 2),
(1075, '领口', '', '领口', 100, 0, 2),
(1076, '春季', '', '春季', 100, 0, 12),
(1077, '点点', '', '点点', 100, 0, 1),
(1078, '新日', '', '新日', 100, 0, 1),
(1079, '国度', '', '国度', 100, 0, 1),
(1080, '女人', '', '女人', 100, 0, 1),
(1081, '镶钻', '', '镶钻', 100, 0, 4),
(1082, '处理', '', '处理', 100, 0, 2),
(1083, '棉布', '', '棉布', 100, 0, 2),
(1084, '促销', '', '促销', 100, 0, 3),
(1085, '学生装', '', '学生装', 100, 0, 3),
(1086, '清新/p-2', '', '清新/p-2', 100, 0, 0),
(1087, '丝光棉', '', '丝光棉', 100, 0, 1),
(1088, '蝴蝶', '', '蝴蝶', 100, 0, 7),
(1089, 'Q113', '', 'Q113', 100, 0, 1),
(1090, '绿色', '', '绿色', 100, 0, 1),
(1091, '女裙', '', '女裙', 100, 1, 3),
(1092, '代购', '', '代购', 100, 0, 4),
(1093, '杨幂同', '', '杨幂同', 100, 0, 1),
(1094, '裙子', '', '裙子', 100, 0, 5),
(1095, '2012', '', '2012', 100, 0, 16),
(1096, '诗琳', '', '诗琳', 100, 0, 1),
(1097, '飘逸', '', '飘逸', 100, 0, 8),
(1098, 'XDR10431', '', 'XDR10431', 100, 0, 1),
(1099, 'LUXLEAD', '', 'LUXLEAD', 100, 0, 1),
(1100, '带露', '', '带露', 100, 0, 1),
(1101, '宝石', '', '宝石', 100, 0, 14),
(1102, '韩版收', '', '韩版收', 100, 0, 1),
(1104, '黄色', '', '黄色', 100, 0, 6),
(1105, '红色', '', '红色', 100, 0, 1),
(1106, '黑色', '', '黑色', 100, 0, 1),
(1107, '清爽', '', '清爽', 100, 0, 7),
(1108, '内衬', '', '内衬', 100, 0, 1),
(1109, '松紧', '', '松紧', 100, 0, 3),
(1110, '衣裤', '', '衣裤', 100, 0, 5),
(1111, '经典', '', '经典', 100, 0, 1),
(1112, '连体', '', '连体', 100, 0, 13),
(1113, '性感', '', '性感', 100, 0, 6),
(1114, 'Krazy', '', 'Krazy', 100, 0, 1);
INSERT INTO `le_goods_tags` (`tag_id`, `tag_name`, `img`, `tag_code`, `sort`, `is_hot`, `count`) VALUES
(1115, '边收腰', '', '边收腰', 100, 0, 2),
(1116, '天猫', '', '天猫', 100, 0, 2),
(1117, '时尚女装', '', '时尚女装', 100, 0, 2),
(1118, '厂家', '', '厂家', 100, 0, 2),
(1119, '风日', '', '风日', 100, 0, 1),
(1120, '裙裤', '', '裙裤', 100, 0, 5),
(1121, '800', '', '800', 100, 0, 1),
(1122, '品牌服饰', '', '品牌服饰', 100, 0, 1),
(1123, '高档', '', '高档', 100, 0, 6),
(1124, '水洗', '', '水洗', 100, 0, 7),
(1125, '颜色', '', '颜色', 100, 0, 1),
(1126, '超短裤', '', '超短裤', 100, 0, 1),
(1127, '设计', '', '设计', 100, 0, 1),
(1128, '披肩', '', '披肩', 100, 0, 1),
(1129, '光头', '', '光头', 100, 0, 1),
(1130, '军风', '', '军风', 100, 0, 1),
(1131, '裤裙', '', '裤裙', 100, 0, 1),
(1132, '推荐', '', '推荐', 100, 0, 6),
(1133, '瘦高', '', '瘦高', 100, 0, 4),
(1134, '女裤', '', '女裤', 100, 0, 2),
(1135, '补丁', '', '补丁', 100, 0, 1),
(1136, '2054', '', '2054', 100, 0, 1),
(1137, '花蓝', '', '花蓝', 100, 0, 1),
(1138, '白黑', '', '白黑', 100, 0, 1),
(1139, '低腰', '', '低腰', 100, 0, 1),
(1140, '侧边', '', '侧边', 100, 0, 1),
(1141, '油画', '', '油画', 100, 0, 1),
(1142, '夏天', '', '夏天', 100, 0, 1),
(1143, '色调', '', '色调', 100, 0, 1),
(1144, '冰激凌', '', '冰激凌', 100, 0, 2),
(1145, '弹力', '', '弹力', 100, 0, 10),
(1146, 'minzi', '', 'minzi', 100, 0, 1),
(1147, '皱褶', '', '皱褶', 100, 0, 1),
(1148, '古风', '', '古风', 100, 0, 1),
(1149, '新高', '', '新高', 100, 0, 1),
(1150, '孙俪', '', '孙俪', 100, 0, 1),
(1151, '灯笼', '', '灯笼', 100, 0, 1),
(1152, '毛边', '', '毛边', 100, 0, 1),
(1153, '连体衣', '', '连体衣', 100, 0, 1),
(1154, '8095', '', '8095', 100, 0, 1),
(1155, '仿真丝', '', '仿真丝', 100, 0, 1),
(1156, '青花瓷', '', '青花瓷', 100, 0, 1),
(1157, '花纹', '', '花纹', 100, 0, 6),
(1158, '边袖', '', '边袖', 100, 0, 1),
(1159, '条斑', '', '条斑', 100, 0, 1),
(1160, '可拆卸', '', '可拆卸', 100, 0, 1),
(1161, '水玉', '', '水玉', 100, 0, 1),
(1162, '腰间', '', '腰间', 100, 0, 1),
(1163, '水墨', '', '水墨', 100, 0, 3),
(1164, '燕尾', '', '燕尾', 100, 0, 1),
(1165, '品汇', '', '品汇', 100, 0, 2),
(1166, '沙滩', '', '沙滩', 100, 0, 40),
(1167, '韩版超', '', '韩版超', 100, 0, 2),
(1168, '批发', '', '批发', 100, 0, 10),
(1169, '依人', '', '依人', 100, 0, 1),
(1170, '春梦', '', '春梦', 100, 0, 1),
(1171, '连衣', '', '连衣', 100, 0, 4),
(1172, '艾薇儿', '', '艾薇儿', 100, 0, 1),
(1173, '伴娘', '', '伴娘', 100, 0, 6),
(1174, '牌女装', '', '牌女装', 100, 0, 1),
(1175, '包臀', '', '包臀', 100, 0, 14),
(1176, '白条', '', '白条', 100, 0, 1),
(1177, '肚子', '', '肚子', 100, 0, 1),
(1178, '子女', '', '子女', 100, 0, 1),
(1179, '包邮！', '', '包邮！', 100, 0, 2),
(1180, 'HAOCY', '', 'HAOCY', 100, 0, 1),
(1181, '优质', '', '优质', 100, 0, 3),
(1182, '小雏', '', '小雏', 100, 0, 6),
(1183, '孕妇', '', '孕妇', 100, 0, 3),
(1184, '胸前', '', '胸前', 100, 0, 1),
(1185, '直销', '', '直销', 100, 0, 8),
(1186, '米亚', '', '米亚', 100, 0, 1),
(1187, '波西', '', '波西', 100, 0, 1),
(1188, 'lianyiquen', '', 'lianyiquen', 100, 0, 1),
(1189, 'Kiss', '', 'Kiss', 100, 0, 1),
(1190, '仙女', '', '仙女', 100, 0, 1),
(1191, '百褶裙', '', '百褶裙', 100, 0, 8),
(1192, '97137', '', '97137', 100, 0, 1),
(1193, '浪花', '', '浪花', 100, 0, 2),
(1194, '边显瘦', '', '边显瘦', 100, 0, 1),
(1195, '抹胸', '', '抹胸', 100, 0, 9),
(1196, '白色棉', '', '白色棉', 100, 0, 1),
(1197, '安全', '', '安全', 100, 0, 1),
(1198, '原来', '', '原来', 100, 0, 3),
(1199, '精致', '', '精致', 100, 0, 2),
(1200, '多层次', '', '多层次', 100, 0, 2),
(1201, '梦丝', '', '梦丝', 100, 0, 2),
(1202, '妩媚', '', '妩媚', 100, 0, 2),
(1203, '白卷', '', '白卷', 100, 0, 1),
(1204, '边小', '', '边小', 100, 0, 1),
(1205, '纯美', '', '纯美', 100, 0, 2),
(1206, '口袋', '', '口袋', 100, 0, 2),
(1207, '三角', '', '三角', 100, 0, 4),
(1208, '内裤', '', '内裤', 100, 0, 1),
(1209, '品牌童装', '', '品牌童装', 100, 0, 1),
(1210, '女人味', '', '女人味', 100, 0, 2),
(1211, '下装', '', '下装', 100, 0, 40),
(1212, '松紧带', '', '松紧带', 100, 0, 1),
(1213, '日本', '', '日本', 100, 0, 2),
(1214, '沙滩裤', '', '沙滩裤', 100, 0, 2),
(1215, '小鸟', '', '小鸟', 100, 0, 1),
(1216, '韩版潮', '', '韩版潮', 100, 0, 15),
(1217, '小猫', '', '小猫', 100, 0, 2),
(1218, '扎染', '', '扎染', 100, 0, 1),
(1219, 'fish', '', 'fish', 100, 0, 1),
(1220, '新马', '', '新马', 100, 0, 1),
(1221, '卡龙', '', '卡龙', 100, 0, 1),
(1222, '半边', '', '半边', 100, 0, 1),
(1223, '一家', '', '一家', 100, 0, 1),
(1224, '时尚前沿', '', '时尚前沿', 100, 0, 1),
(1225, '大门', '', '大门', 100, 0, 2),
(1226, '夏款女', '', '夏款女', 100, 0, 1),
(1227, '连身', '', '连身', 100, 0, 1),
(1228, '魔女', '', '魔女', 100, 0, 1),
(1229, '灰色', '', '灰色', 100, 0, 1),
(1230, '斗篷', '', '斗篷', 100, 0, 1),
(1231, '母女', '', '母女', 100, 0, 1),
(1232, '亲子', '', '亲子', 100, 0, 1),
(1233, '雅伊', '', '雅伊', 100, 0, 1),
(1234, '淑女装', '', '淑女装', 100, 0, 1),
(1235, '热卖', '', '热卖', 100, 0, 2),
(1236, '春夏季', '', '春夏季', 100, 0, 2),
(1237, '衣领', '', '衣领', 100, 0, 1),
(1238, '怀孕', '', '怀孕', 100, 0, 1),
(1239, '高开叉', '', '高开叉', 100, 0, 1),
(1240, '韩版波', '', '韩版波', 100, 0, 3),
(1241, '胖人', '', '胖人', 100, 0, 2),
(1242, '服饰', '', '服饰', 100, 0, 1),
(1243, '夏款拼', '', '夏款拼', 100, 0, 1),
(1244, '后背', '', '后背', 100, 0, 2),
(1245, '多层', '', '多层', 100, 0, 13),
(1246, 'ylxg6235', '', 'ylxg6235', 100, 0, 1),
(1247, '大尾', '', '大尾', 100, 0, 1),
(1248, '胸花', '', '胸花', 100, 0, 1),
(1249, 'Shelley', '', 'Shelley', 100, 0, 1),
(1250, '柠檬', '', '柠檬', 100, 0, 1),
(1251, 'L2099', '', 'L2099', 100, 0, 1),
(1252, '彩花', '', '彩花', 100, 0, 2),
(1253, '1122169069', '', '1122169069', 100, 0, 1),
(1254, '黄底', '', '黄底', 100, 0, 1),
(1255, '肩带', '', '肩带', 100, 0, 1),
(1256, '洋装', '', '洋装', 100, 0, 1),
(1257, '黎依橱', '', '黎依橱', 100, 0, 1),
(1258, '08', '', '08', 100, 0, 1),
(1259, '彩虹', '', '彩虹', 100, 0, 6),
(1260, '配色', '', '配色', 100, 0, 1),
(1261, '8805', '', '8805', 100, 0, 1),
(1262, '垫肩', '', '垫肩', 100, 0, 3),
(1263, '清纯', '', '清纯', 100, 0, 3),
(1264, '范冰冰', '', '范冰冰', 100, 0, 1),
(1265, '休闲风', '', '休闲风', 100, 0, 1),
(1266, '新韵', '', '新韵', 100, 0, 1),
(1267, '边阔腿', '', '边阔腿', 100, 0, 1),
(1268, '特大', '', '特大', 100, 0, 2),
(1269, '四季', '', '四季', 100, 0, 2),
(1270, '情侣', '', '情侣', 100, 0, 28),
(1271, '男女', '', '男女', 100, 0, 29),
(1272, '瑞丽', '', '瑞丽', 100, 0, 3),
(1273, '工装', '', '工装', 100, 0, 2),
(1274, '冰淇淋', '', '冰淇淋', 100, 0, 8),
(1275, '彩色', '', '彩色', 100, 0, 1),
(1276, '花印', '', '花印', 100, 0, 1),
(1277, '通透', '', '通透', 100, 0, 1),
(1278, '蓬蓬', '', '蓬蓬', 100, 0, 4),
(1279, 'JUE', '', 'JUE', 100, 0, 1),
(1280, '连帽', '', '连帽', 100, 0, 1),
(1281, '初见', '', '初见', 100, 0, 1),
(1282, '子夏', '', '子夏', 100, 0, 2),
(1283, 'L19', '', 'L19', 100, 0, 1),
(1284, '香风', '', '香风', 100, 0, 1),
(1285, '乱麻', '', '乱麻', 100, 0, 1),
(1286, '水滴', '', '水滴', 100, 0, 2),
(1287, 'LOTTO', '', 'LOTTO', 100, 0, 1),
(1288, '乐途', '', '乐途', 100, 0, 1),
(1289, 'EKSG', '', 'EKSG', 100, 0, 1),
(1290, '004', '', '004', 100, 0, 1),
(1291, '07E7217', '', '07E7217', 100, 0, 1),
(1292, '浅色', '', '浅色', 100, 0, 3),
(1293, '白薄款', '', '白薄款', 100, 0, 1),
(1294, '质量', '', '质量', 100, 0, 1),
(1295, '连衣服', '', '连衣服', 100, 0, 1),
(1296, '衣饰', '', '衣饰', 100, 0, 1),
(1297, '新大', '', '新大', 100, 0, 1),
(1298, '时尚潮流', '', '时尚潮流', 100, 0, 2),
(1299, '渐变', '', '渐变', 100, 0, 9),
(1300, '心情', '', '心情', 100, 0, 1),
(1301, '肩部', '', '肩部', 100, 0, 1),
(1302, '相映', '', '相映', 100, 0, 1),
(1303, '中年', '', '中年', 100, 0, 2),
(1304, '高雅', '', '高雅', 100, 0, 2),
(1305, '装假', '', '装假', 100, 0, 1),
(1306, '欧根', '', '欧根', 100, 0, 4),
(1307, '老虎头', '', '老虎头', 100, 0, 1),
(1308, 'h003', '', 'h003', 100, 0, 1),
(1309, '便宜', '', '便宜', 100, 0, 1),
(1310, '疯狂', '', '疯狂', 100, 0, 2),
(1311, '反季', '', '反季', 100, 0, 1),
(1312, '实拍', '', '实拍', 100, 0, 3),
(1313, '热销', '', '热销', 100, 0, 1),
(1314, '盛夏', '', '盛夏', 100, 0, 2),
(1315, '竖条', '', '竖条', 100, 0, 1),
(1316, '麦莉娅', '', '麦莉娅', 100, 0, 1),
(1317, '9166', '', '9166', 100, 0, 1),
(1318, 'Q698', '', 'Q698', 100, 0, 1),
(1319, '小米', '', '小米', 100, 0, 2),
(1320, '身长', '', '身长', 100, 0, 1),
(1321, '花中', '', '花中', 100, 0, 2),
(1322, 'LC3V055', '', 'LC3V055', 100, 0, 1),
(1323, '朗玟', '', '朗玟', 100, 0, 1),
(1324, 'LAVU', '', 'LAVU', 100, 0, 1),
(1325, '接收', '', '接收', 100, 0, 2),
(1326, '青涩', '', '青涩', 100, 0, 1),
(1327, '凉爽', '', '凉爽', 100, 0, 1),
(1328, '须须', '', '须须', 100, 0, 1),
(1329, '蓝白色', '', '蓝白色', 100, 0, 1),
(1330, '浅浅', '', '浅浅', 100, 0, 1),
(1331, '干净', '', '干净', 100, 0, 1),
(1332, '外贸童装', '', '外贸童装', 100, 0, 1),
(1333, '宝宝', '', '宝宝', 100, 0, 1),
(1334, '丝光', '', '丝光', 100, 0, 1),
(1335, '超短', '', '超短', 100, 0, 1),
(1336, '韩系', '', '韩系', 100, 0, 1),
(1337, 'ELLE', '', 'ELLE', 100, 0, 1),
(1338, '人气', '', '人气', 100, 0, 3),
(1339, '旅游', '', '旅游', 100, 0, 2),
(1340, '超宽', '', '超宽', 100, 0, 1),
(1341, '质感', '', '质感', 100, 0, 3),
(1342, '洗水', '', '洗水', 100, 0, 1),
(1343, '夏新', '', '夏新', 100, 0, 14),
(1344, '玫瑰', '', '玫瑰', 100, 0, 18),
(1345, '新低', '', '新低', 100, 0, 2),
(1346, '青少年', '', '青少年', 100, 0, 2),
(1347, '天丝', '', '天丝', 100, 0, 5),
(1348, '搭钩', '', '搭钩', 100, 0, 1),
(1349, '简美添', '', '简美添', 100, 0, 1),
(1350, '雅图', '', '雅图', 100, 0, 1),
(1351, '喇叭', '', '喇叭', 100, 0, 2),
(1352, '格连', '', '格连', 100, 0, 1),
(1353, '衣裙', '', '衣裙', 100, 0, 1),
(1354, 'angelababy', '', 'angelababy', 100, 0, 1),
(1355, '杨颖', '', '杨颖', 100, 0, 1),
(1356, '丝线', '', '丝线', 100, 0, 2),
(1357, '日新', '', '日新', 100, 0, 1),
(1358, '上市', '', '上市', 100, 0, 1),
(1359, '烫花', '', '烫花', 100, 0, 1),
(1360, '折扣', '', '折扣', 100, 0, 1),
(1361, '活动', '', '活动', 100, 0, 1),
(1362, '素色', '', '素色', 100, 0, 1),
(1363, '进口', '', '进口', 100, 0, 1),
(1364, '宫】', '', '宫】', 100, 0, 1),
(1365, '100', '', '100', 100, 0, 1),
(1366, '韩式', '', '韩式', 100, 0, 6),
(1367, '裙摆', '', '裙摆', 100, 0, 4),
(1368, '棋盘', '', '棋盘', 100, 0, 1),
(1369, '132ts147', '', '132ts147', 100, 0, 1),
(1370, 'OECE', '', 'OECE', 100, 0, 1),
(1371, 'YMM', '', 'YMM', 100, 0, 1),
(1372, '西子', '', '西子', 100, 0, 1),
(1373, '明星', '', '明星', 100, 0, 2),
(1374, '乔其纱', '', '乔其纱', 100, 0, 1),
(1375, '米亚裙', '', '米亚裙', 100, 0, 1),
(1376, '恬美', '', '恬美', 100, 0, 1),
(1377, '美日', '', '美日', 100, 0, 1),
(1378, '重工', '', '重工', 100, 0, 6),
(1379, '超大', '', '超大', 100, 0, 1),
(1380, '女网', '', '女网', 100, 0, 1),
(1381, '学生鞋', '', '学生鞋', 100, 0, 8),
(1382, '工作鞋', '', '工作鞋', 100, 0, 8),
(1383, '女鞋', '', '女鞋', 100, 0, 9),
(1384, '基本', '', '基本', 100, 0, 1),
(1385, '皮中跟', '', '皮中跟', 100, 0, 2),
(1386, '人字', '', '人字', 100, 0, 1),
(1387, '休闲时尚', '', '休闲时尚', 100, 0, 3),
(1388, '防水', '', '防水', 100, 0, 4),
(1389, '内增高', '', '内增高', 100, 0, 2),
(1390, '平跟鞋', '', '平跟鞋', 100, 0, 3),
(1391, '松糕', '', '松糕', 100, 0, 3),
(1392, '平底', '', '平底', 100, 0, 2),
(1393, '牛皮', '', '牛皮', 100, 0, 15),
(1394, '名牌', '', '名牌', 100, 0, 1),
(1395, '芭蕾舞', '', '芭蕾舞', 100, 0, 1),
(1396, '初中生', '', '初中生', 100, 0, 1),
(1397, '水钻', '', '水钻', 100, 0, 8),
(1398, '包头', '', '包头', 100, 0, 8),
(1399, '005', '', '005', 100, 0, 1),
(1400, '带鱼', '', '带鱼', 100, 0, 2),
(1401, '羊皮', '', '羊皮', 100, 0, 5),
(1402, '宴会', '', '宴会', 100, 0, 2),
(1403, '金属', '', '金属', 100, 0, 2),
(1404, '乖乖', '', '乖乖', 100, 0, 2),
(1405, '全国', '', '全国', 100, 0, 5),
(1406, '中大', '', '中大', 100, 0, 1),
(1407, '春秋季', '', '春秋季', 100, 0, 1),
(1408, '女单', '', '女单', 100, 0, 1),
(1409, '布鞋', '', '布鞋', 100, 0, 4),
(1410, '风钻', '', '风钻', 100, 0, 1),
(1411, 'Kvoll', '', 'Kvoll', 100, 0, 1),
(1412, '鞋业', '', '鞋业', 100, 0, 1),
(1413, '绒面', '', '绒面', 100, 0, 1),
(1414, '低价', '', '低价', 100, 0, 1),
(1415, '闪亮', '', '闪亮', 100, 0, 5),
(1416, '串珠', '', '串珠', 100, 0, 2),
(1417, '防滑', '', '防滑', 100, 0, 6),
(1418, '43', '', '43', 100, 0, 2),
(1419, '鱼嘴女', '', '鱼嘴女', 100, 0, 1),
(1420, '莫蕾寇', '', '莫蕾寇', 100, 0, 1),
(1421, '简单', '', '简单', 100, 0, 1),
(1422, '卡洛', '', '卡洛', 100, 0, 1),
(1423, '娜妮', '', '娜妮', 100, 0, 2),
(1424, '雷丽', '', '雷丽', 100, 0, 1),
(1425, 'Crocs', '', 'Crocs', 100, 0, 3),
(1426, '韩版厚', '', '韩版厚', 100, 0, 1),
(1427, '公牛', '', '公牛', 100, 0, 1),
(1428, '巨人', '', '巨人', 100, 0, 1),
(1429, '简】', '', '简】', 100, 0, 1),
(1430, '缕空', '', '缕空', 100, 0, 1),
(1431, '工厂', '', '工厂', 100, 0, 1),
(1432, '金边', '', '金边', 100, 0, 2),
(1433, '其乐', '', '其乐', 100, 0, 1),
(1434, '正装', '', '正装', 100, 0, 1),
(1435, '英国', '', '英国', 100, 0, 13),
(1436, 'Clarks', '', 'Clarks', 100, 0, 1),
(1437, 'Clover', '', 'Clover', 100, 0, 1),
(1438, '磨砂皮', '', '磨砂皮', 100, 0, 1),
(1439, '超值', '', '超值', 100, 0, 1),
(1440, '最爱', '', '最爱', 100, 0, 5),
(1441, '魅力', '', '魅力', 100, 0, 1),
(1442, '潮流时尚', '', '潮流时尚', 100, 0, 1),
(1443, '交叉', '', '交叉', 100, 0, 1),
(1444, '沙滩鞋', '', '沙滩鞋', 100, 0, 1),
(1445, '一箭', '', '一箭', 100, 0, 1),
(1446, '定做', '', '定做', 100, 0, 1),
(1447, '特色', '', '特色', 100, 0, 1),
(1448, '金靴', '', '金靴', 100, 0, 1),
(1449, '世家', '', '世家', 100, 0, 1),
(1450, 'meiibeauty', '', 'meiibeauty', 100, 0, 1),
(1451, '色漆', '', '色漆', 100, 0, 1),
(1452, '环带', '', '环带', 100, 0, 1),
(1453, '火热', '', '火热', 100, 0, 1),
(1454, '皮带扣', '', '皮带扣', 100, 0, 2),
(1455, '字型', '', '字型', 100, 0, 1),
(1456, '大气', '', '大气', 100, 0, 1),
(1457, '牛筋', '', '牛筋', 100, 0, 5),
(1458, '子真', '', '子真', 100, 0, 1),
(1459, '富贵', '', '富贵', 100, 0, 1),
(1460, 'N371103K', '', 'N371103K', 100, 0, 1),
(1461, '网状', '', '网状', 100, 0, 1),
(1462, '丝网', '', '丝网', 100, 0, 1),
(1463, '皮鱼', '', '皮鱼', 100, 0, 1),
(1464, '靓丽', '', '靓丽', 100, 0, 1),
(1465, 'OGX830140', '', 'OGX830140', 100, 0, 1),
(1466, '柳钉风', '', '柳钉风', 100, 0, 1),
(1467, '鱼嘴坡', '', '鱼嘴坡', 100, 0, 2),
(1468, '检察官', '', '检察官', 100, 0, 1),
(1469, '蛇皮', '', '蛇皮', 100, 0, 2),
(1470, '童鞋', '', '童鞋', 100, 0, 3),
(1471, '表演', '', '表演', 100, 0, 1),
(1472, 'jondas', '', 'jondas', 100, 0, 1),
(1473, '帆布', '', '帆布', 100, 0, 2),
(1474, '小青', '', '小青', 100, 0, 1),
(1475, '鱼嘴粗', '', '鱼嘴粗', 100, 0, 1),
(1476, '韩版坡', '', '韩版坡', 100, 0, 1),
(1477, '结平', '', '结平', 100, 0, 1),
(1478, '女真', '', '女真', 100, 0, 1),
(1479, '皮特', '', '皮特', 100, 0, 1),
(1480, '工作单', '', '工作单', 100, 0, 1),
(1481, '蜻蜓', '', '蜻蜓', 100, 0, 1),
(1482, '瘦腿', '', '瘦腿', 100, 0, 1),
(1483, '奢华', '', '奢华', 100, 0, 9),
(1484, '打折', '', '打折', 100, 0, 3),
(1485, '电镀', '', '电镀', 100, 0, 2),
(1486, '高坡', '', '高坡', 100, 0, 1),
(1487, '职业', '', '职业', 100, 0, 2),
(1488, '异型', '', '异型', 100, 0, 1),
(1489, '闪闪', '', '闪闪', 100, 0, 1),
(1490, '鱼嘴细', '', '鱼嘴细', 100, 0, 1),
(1491, '夏秋', '', '夏秋', 100, 0, 4),
(1492, '韩版撞', '', '韩版撞', 100, 0, 1),
(1493, '2012vivi', '', '2012vivi', 100, 0, 1),
(1494, '小坡', '', '小坡', 100, 0, 4),
(1495, '妮克', '', '妮克', 100, 0, 1),
(1496, '柯玛', '', '柯玛', 100, 0, 1),
(1497, '风头', '', '风头', 100, 0, 1),
(1498, '复合', '', '复合', 100, 0, 1),
(1499, '波希米亚', '', '波希米亚', 100, 0, 1),
(1500, '美琪', '', '美琪', 100, 0, 1),
(1501, '雕花', '', '雕花', 100, 0, 10),
(1502, '杂志', '', '杂志', 100, 0, 1),
(1503, '教主', '', '教主', 100, 0, 1),
(1504, '必备', '', '必备', 100, 0, 1),
(1505, '洛丽塔', '', '洛丽塔', 100, 0, 1),
(1506, '订做', '', '订做', 100, 0, 2),
(1507, 'lolilt', '', 'lolilt', 100, 0, 1),
(1508, '包跟', '', '包跟', 100, 0, 1),
(1509, '风露', '', '风露', 100, 0, 1),
(1510, '魔术', '', '魔术', 100, 0, 1),
(1511, '高级', '', '高级', 100, 0, 3),
(1512, '走路', '', '走路', 100, 0, 1),
(1513, '洋气', '', '洋气', 100, 0, 3),
(1514, '1003004', '', '1003004', 100, 0, 1),
(1515, '麻底坡', '', '麻底坡', 100, 0, 1),
(1516, '子潮', '', '子潮', 100, 0, 1),
(1517, '银色', '', '银色', 100, 0, 4),
(1518, '范儿', '', '范儿', 100, 0, 1),
(1519, '涛涛', '', '涛涛', 100, 0, 1),
(1520, 'T3102', '', 'T3102', 100, 0, 1),
(1521, '丁字', '', '丁字', 100, 0, 1),
(1522, '丝绸', '', '丝绸', 100, 0, 2),
(1523, '方头', '', '方头', 100, 0, 2),
(1524, '舞鞋', '', '舞鞋', 100, 0, 1),
(1525, '缝线', '', '缝线', 100, 0, 1),
(1526, '鱼嘴修', '', '鱼嘴修', 100, 0, 1),
(1527, '口中', '', '口中', 100, 0, 1),
(1528, '上班', '', '上班', 100, 0, 1),
(1529, '牛皮鞋', '', '牛皮鞋', 100, 0, 1),
(1530, '舞蹈鞋', '', '舞蹈鞋', 100, 0, 1),
(1531, '细高跟', '', '细高跟', 100, 0, 3),
(1532, '手绘', '', '手绘', 100, 0, 1),
(1533, '涂鸦', '', '涂鸦', 100, 0, 7),
(1534, '皮色', '', '皮色', 100, 0, 1),
(1535, '冬季', '', '冬季', 100, 0, 4),
(1536, '橡胶', '', '橡胶', 100, 0, 1),
(1537, '纤细', '', '纤细', 100, 0, 1),
(1627, 'L591010', '', 'L591010', 100, 0, 1),
(1539, '马毛', '', '马毛', 100, 0, 1),
(1540, '豆豆', '', '豆豆', 100, 0, 8),
(1541, '奥康', '', '奥康', 100, 0, 1),
(1542, '火鸟', '', '火鸟', 100, 0, 1),
(1543, '跟头', '', '跟头', 100, 0, 1),
(1544, '修改', '', '修改', 100, 0, 1),
(1545, '标题', '', '标题', 100, 0, 1),
(1546, '斑马', '', '斑马', 100, 0, 3),
(1547, '太阳', '', '太阳', 100, 0, 1),
(1548, '现货', '', '现货', 100, 0, 14),
(1549, '轻便', '', '轻便', 100, 0, 1),
(1550, '工作', '', '工作', 100, 0, 2),
(1551, '闪耀', '', '闪耀', 100, 0, 1),
(1552, '卡昂', '', '卡昂', 100, 0, 2),
(1553, '日常', '', '日常', 100, 0, 2),
(1554, '订制', '', '订制', 100, 0, 2),
(1555, '邻家', '', '邻家', 100, 0, 1),
(1556, '限量', '', '限量', 100, 0, 1),
(1557, '牛仔布', '', '牛仔布', 100, 0, 4),
(1625, '潮浪', '', '潮浪', 100, 0, 1),
(1559, '蜂巢', '', '蜂巢', 100, 0, 1),
(1560, '尚无', '', '尚无', 100, 0, 1),
(1561, '高中', '', '高中', 100, 0, 2),
(1562, '环球', '', '环球', 100, 0, 1),
(1563, '风范', '', '风范', 100, 0, 3),
(1564, '尊贵', '', '尊贵', 100, 0, 1),
(1565, '丝带', '', '丝带', 100, 0, 1),
(1566, '鞋店', '', '鞋店', 100, 0, 1),
(1567, '细带', '', '细带', 100, 0, 1),
(1568, '名星', '', '名星', 100, 0, 1),
(1569, '增高', '', '增高', 100, 0, 3),
(1570, '米亚风', '', '米亚风', 100, 0, 3),
(1571, '皮平', '', '皮平', 100, 0, 1),
(1572, '捷克', '', '捷克', 100, 0, 2),
(1573, '脚背', '', '脚背', 100, 0, 1),
(1574, '风尚', '', '风尚', 100, 0, 1),
(1575, '璀璨', '', '璀璨', 100, 0, 1),
(1576, '花样', '', '花样', 100, 0, 1),
(1577, '小小', '', '小小', 100, 0, 1),
(1578, '藏有', '', '藏有', 100, 0, 1),
(1579, '15063', '', '15063', 100, 0, 1),
(1580, '大红色', '', '大红色', 100, 0, 2),
(1581, '宝蓝色', '', '宝蓝色', 100, 0, 2),
(1582, '鞋带', '', '鞋带', 100, 0, 1),
(1583, '方扣', '', '方扣', 100, 0, 1),
(1584, '保暖', '', '保暖', 100, 0, 3),
(1585, '热推', '', '热推', 100, 0, 1),
(1586, '韩版粗', '', '韩版粗', 100, 0, 1),
(1587, '适中', '', '适中', 100, 0, 1),
(1588, '皮坡跟', '', '皮坡跟', 100, 0, 1),
(1589, '杏色', '', '杏色', 100, 0, 1),
(1590, '花布', '', '花布', 100, 0, 1),
(1591, '小童', '', '小童', 100, 0, 1),
(1592, '韩版秋', '', '韩版秋', 100, 0, 1),
(1593, '蓝色', '', '蓝色', 100, 0, 17),
(1594, '脚踝', '', '脚踝', 100, 0, 1),
(1595, '樱花', '', '樱花', 100, 0, 1),
(1596, '女中', '', '女中', 100, 0, 1),
(1597, '时装鞋', '', '时装鞋', 100, 0, 1),
(1598, '新春', '', '新春', 100, 0, 1),
(1599, '风平', '', '风平', 100, 0, 1),
(1600, '棕色', '', '棕色', 100, 0, 3),
(1601, '冠军', '', '冠军', 100, 0, 1),
(1602, 'Vividress', '', 'Vividress', 100, 0, 1),
(1603, '布面', '', '布面', 100, 0, 1),
(1604, '韩版细', '', '韩版细', 100, 0, 1),
(1605, '莫蕾蔻', '', '莫蕾蔻', 100, 0, 2),
(1606, '高彩', '', '高彩', 100, 0, 1),
(1607, '名典', '', '名典', 100, 0, 1),
(1608, '大号', '', '大号', 100, 0, 2),
(1609, '透明', '', '透明', 100, 0, 1),
(1610, '初夏', '', '初夏', 100, 0, 1),
(1611, '涉水', '', '涉水', 100, 0, 1),
(1612, '质保', '', '质保', 100, 0, 1),
(1613, '黑红', '', '黑红', 100, 0, 1),
(1614, '唐卡', '', '唐卡', 100, 0, 1),
(1615, '职业女性', '', '职业女性', 100, 0, 1),
(1616, '派对', '', '派对', 100, 0, 1),
(1617, '女色', '', '女色', 100, 0, 1),
(1618, '鱼嘴套', '', '鱼嘴套', 100, 0, 1),
(1619, '皮夹', '', '皮夹', 100, 0, 5),
(1620, '芙琳', '', '芙琳', 100, 0, 1),
(1621, '韩版鞋', '', '韩版鞋', 100, 0, 1),
(1622, '驾车', '', '驾车', 100, 0, 1),
(1623, '达芙妮', '', '达芙妮', 100, 0, 1),
(1624, '人本', '', '人本', 100, 0, 1),
(1626, '荧光', '', '荧光', 100, 0, 2),
(1628, '韩版扣', '', '韩版扣', 100, 0, 1),
(1629, '走秀', '', '走秀', 100, 0, 2),
(1630, '晚宴', '', '晚宴', 100, 0, 8),
(1631, '意大利', '', '意大利', 100, 0, 1),
(1632, '情歌', '', '情歌', 100, 0, 1),
(1633, 'Mantova', '', 'Mantova', 100, 0, 1),
(1634, 'AR1203', '', 'AR1203', 100, 0, 1),
(1635, '限时', '', '限时', 100, 0, 2),
(1636, '丫丫', '', '丫丫', 100, 0, 1),
(1637, '特卖', '', '特卖', 100, 0, 1),
(1638, '风潮', '', '风潮', 100, 0, 22),
(1639, '大小', '', '大小', 100, 0, 2),
(1640, '41', '', '41', 100, 0, 1),
(1641, '方跟', '', '方跟', 100, 0, 1),
(1642, '链条', '', '链条', 100, 0, 30),
(1643, '办公室', '', '办公室', 100, 0, 1),
(1644, '校园', '', '校园', 100, 0, 1),
(1645, '面包', '', '面包', 100, 0, 2),
(1646, '高贵', '', '高贵', 100, 0, 1),
(1647, '女超', '', '女超', 100, 0, 1),
(1648, '高粗跟', '', '高粗跟', 100, 0, 1),
(1649, '办公', '', '办公', 100, 0, 3),
(1650, '雨靴', '', '雨靴', 100, 0, 6),
(1651, '出口日本', '', '出口日本', 100, 0, 1),
(1652, '链子', '', '链子', 100, 0, 1),
(1653, '锯齿', '', '锯齿', 100, 0, 1),
(1654, '藤编', '', '藤编', 100, 0, 1),
(1655, '草包', '', '草包', 100, 0, 38),
(1656, '休闲包', '', '休闲包', 100, 0, 6),
(1657, '箱子', '', '箱子', 100, 0, 6),
(1658, 'HelloKitty', '', 'HelloKitty', 100, 0, 1),
(1659, '棉球', '', '棉球', 100, 0, 2),
(1660, '小毛', '', '小毛', 100, 0, 1),
(1661, '全场', '', '全场', 100, 0, 1),
(1662, '水桶', '', '水桶', 100, 0, 13),
(1663, '大包', '', '大包', 100, 0, 20),
(1664, '编制', '', '编制', 100, 0, 1),
(1665, '批发价', '', '批发价', 100, 0, 2),
(1666, '大容量', '', '大容量', 100, 0, 6),
(1667, '韩版百', '', '韩版百', 100, 0, 1),
(1668, '艺丰', '', '艺丰', 100, 0, 1),
(1669, '多用', '', '多用', 100, 0, 1),
(1670, '陀螺', '', '陀螺', 100, 0, 1),
(1671, '钩针', '', '钩针', 100, 0, 9),
(1672, '提篮', '', '提篮', 100, 0, 1),
(1673, '包袋', '', '包袋', 100, 0, 7),
(1674, '珠花', '', '珠花', 100, 0, 1),
(1675, '纯天然', '', '纯天然', 100, 0, 2),
(1676, '材质', '', '材质', 100, 0, 2),
(1677, '乡村', '', '乡村', 100, 0, 2),
(1678, '封包', '', '封包', 100, 0, 1),
(1679, '配角', '', '配角', 100, 0, 1),
(1680, '最佳', '', '最佳', 100, 0, 1),
(1681, '皮把', '', '皮把', 100, 0, 1),
(1682, '包百搭', '', '包百搭', 100, 0, 3),
(1683, '巴黎', '', '巴黎', 100, 0, 2),
(1684, '老虎', '', '老虎', 100, 0, 1),
(1685, '包邮呛', '', '包邮呛', 100, 0, 1),
(1686, '行包', '', '行包', 100, 0, 1),
(1687, '拎包', '', '拎包', 100, 0, 2),
(1688, '贝壳', '', '贝壳', 100, 0, 6),
(1689, '挎包', '', '挎包', 100, 0, 5),
(1690, '包邮金', '', '包邮金', 100, 0, 1),
(1691, '包潮', '', '包潮', 100, 0, 5),
(1692, '牛品】', '', '牛品】', 100, 0, 1),
(1693, '小包', '', '小包', 100, 0, 42),
(1694, '丫头', '', '丫头', 100, 0, 1),
(1695, '迷你', '', '迷你', 100, 0, 11),
(1696, '手柄', '', '手柄', 100, 0, 2),
(1697, '牡丹花', '', '牡丹花', 100, 0, 2),
(1698, '刘亦菲', '', '刘亦菲', 100, 0, 2),
(1699, '蜜蜂', '', '蜜蜂', 100, 0, 1),
(1700, '包森女', '', '包森女', 100, 0, 1),
(1701, '巴厘岛', '', '巴厘岛', 100, 0, 1),
(1702, '风情', '', '风情', 100, 0, 4),
(1703, '水草', '', '水草', 100, 0, 1),
(1704, '扇子', '', '扇子', 100, 0, 2),
(1705, '漂亮', '', '漂亮', 100, 0, 2),
(1706, '韩潮', '', '韩潮', 100, 0, 1),
(1707, '毛球球', '', '毛球球', 100, 0, 1),
(1708, '咖啡', '', '咖啡', 100, 0, 3),
(1709, '包邮★', '', '包邮★', 100, 0, 4),
(1710, '背包', '', '背包', 100, 0, 41),
(1711, '方箱', '', '方箱', 100, 0, 1),
(1712, '泰迪', '', '泰迪', 100, 0, 2),
(1713, '木柄', '', '木柄', 100, 0, 3),
(1714, '狗熊', '', '狗熊', 100, 0, 1),
(1715, '包邮萝', '', '包邮萝', 100, 0, 1),
(1716, '箱包', '', '箱包', 100, 0, 14),
(1717, '包心', '', '包心', 100, 0, 1),
(1718, '草席', '', '草席', 100, 0, 1),
(1719, '海滩', '', '海滩', 100, 0, 1),
(1720, '商务', '', '商务', 100, 0, 4),
(1721, '米亚单', '', '米亚单', 100, 0, 1),
(1722, '芊芊', '', '芊芊', 100, 0, 2),
(1723, '美女', '', '美女', 100, 0, 1),
(1724, '色色', '', '色色', 100, 0, 1),
(1725, '向日葵', '', '向日葵', 100, 0, 2),
(1726, '睫毛', '', '睫毛', 100, 0, 4),
(1727, '心形', '', '心形', 100, 0, 3),
(1728, '秋子', '', '秋子', 100, 0, 1),
(1729, '包拼色', '', '包拼色', 100, 0, 2),
(1730, '七彩', '', '七彩', 100, 0, 3),
(1731, '新手', '', '新手', 100, 0, 1),
(1732, '87411', '', '87411', 100, 0, 1),
(1733, 'm3220', '', 'm3220', 100, 0, 1),
(1734, 'pvc', '', 'pvc', 100, 0, 1),
(1735, '亏本', '', '亏本', 100, 0, 1),
(1736, 'joie', '', 'joie', 100, 0, 1),
(1737, '包带', '', '包带', 100, 0, 1),
(1738, '小女', '', '小女', 100, 0, 1),
(1739, '满三件', '', '满三件', 100, 0, 1),
(1740, '舒心', '', '舒心', 100, 0, 1),
(1741, '菊花', '', '菊花', 100, 0, 3),
(1742, '毛线', '', '毛线', 100, 0, 1),
(1743, '包日系', '', '包日系', 100, 0, 1),
(1744, '韩风', '', '韩风', 100, 0, 1),
(1745, '七彩虹', '', '七彩虹', 100, 0, 1),
(1746, '白富美', '', '白富美', 100, 0, 1),
(1747, '包藤', '', '包藤', 100, 0, 1),
(1748, '边饼', '', '边饼', 100, 0, 1),
(1749, '海滨', '', '海滨', 100, 0, 1),
(1750, '鱼鳞', '', '鱼鳞', 100, 0, 1),
(1751, '好看', '', '好看', 100, 0, 1),
(1752, '大花', '', '大花', 100, 0, 1),
(1753, '包邮五', '', '包邮五', 100, 0, 1),
(1754, '出游', '', '出游', 100, 0, 1),
(1755, '海边', '', '海边', 100, 0, 1),
(1756, '包纸绳', '', '包纸绳', 100, 0, 1),
(1757, '小花', '', '小花', 100, 0, 5),
(1758, '钥匙', '', '钥匙', 100, 0, 2),
(1759, '旅行', '', '旅行', 100, 0, 14),
(1760, '22183', '', '22183', 100, 0, 1),
(1761, '兰心', '', '兰心', 100, 0, 1),
(1762, '印度', '', '印度', 100, 0, 1),
(1763, '缤纷', '', '缤纷', 100, 0, 1),
(1764, 'm3383', '', 'm3383', 100, 0, 1),
(1765, '方格', '', '方格', 100, 0, 2),
(1766, '包三件', '', '包三件', 100, 0, 1),
(1767, '包邮】', '', '包邮】', 100, 0, 2),
(1768, '传统', '', '传统', 100, 0, 1),
(1769, 'm3371', '', 'm3371', 100, 0, 1),
(1770, '麦草', '', '麦草', 100, 0, 1),
(1771, '包复', '', '包复', 100, 0, 6),
(1772, '花帽', '', '花帽', 100, 0, 1),
(1773, '头花', '', '头花', 100, 0, 6),
(1774, '头饰', '', '头饰', 100, 0, 11),
(1775, '仿真', '', '仿真', 100, 0, 1),
(1776, '包软', '', '包软', 100, 0, 1),
(1777, '太阳花', '', '太阳花', 100, 0, 2),
(1778, '怀旧', '', '怀旧', 100, 0, 4),
(1779, '子母', '', '子母', 100, 0, 8),
(1780, '包夹', '', '包夹', 100, 0, 1),
(1781, '街头', '', '街头', 100, 0, 2),
(1782, '锁扣', '', '锁扣', 100, 0, 3),
(1783, 'SMILYAN2013', '', 'SMILYAN2013', 100, 0, 1),
(1784, '邮差', '', '邮差', 100, 0, 27),
(1785, '织女', '', '织女', 100, 0, 1),
(1786, '包车', '', '包车', 100, 0, 2),
(1787, '手包', '', '手包', 100, 0, 16),
(1788, '小燕子', '', '小燕子', 100, 0, 1),
(1789, '熊头', '', '熊头', 100, 0, 1),
(1790, '草类', '', '草类', 100, 0, 1),
(1791, '包大', '', '包大', 100, 0, 2),
(1792, '布条', '', '布条', 100, 0, 1),
(1793, '大圆', '', '大圆', 100, 0, 1),
(1794, '新手机', '', '新手机', 100, 0, 1),
(1795, '零钱', '', '零钱', 100, 0, 1),
(1796, 'm3374', '', 'm3374', 100, 0, 1),
(1797, 'BellaBello', '', 'BellaBello', 100, 0, 1),
(1798, '潮红', '', '潮红', 100, 0, 1),
(1799, '欧美明星', '', '欧美明星', 100, 0, 1),
(1800, '梦幻', '', '梦幻', 100, 0, 3),
(1801, '邮费', '', '邮费', 100, 0, 2),
(1802, '熊熊', '', '熊熊', 100, 0, 1),
(1803, '翻盖', '', '翻盖', 100, 0, 4),
(1804, '织布', '', '织布', 100, 0, 1),
(1805, '纸质', '', '纸质', 100, 0, 2),
(1806, '江浙沪', '', '江浙沪', 100, 0, 1),
(1807, '麻织', '', '麻织', 100, 0, 1),
(1808, '天使', '', '天使', 100, 0, 24),
(1809, '包小', '', '包小', 100, 0, 1),
(1810, '小甜甜', '', '小甜甜', 100, 0, 1),
(1811, '布包', '', '布包', 100, 0, 1),
(1812, '提手', '', '提手', 100, 0, 2),
(1813, '任选', '', '任选', 100, 0, 1),
(1814, '巴洛克', '', '巴洛克', 100, 0, 6),
(1815, '麻花', '', '麻花', 100, 0, 3),
(1816, '扇面', '', '扇面', 100, 0, 1),
(1817, '丽莎', '', '丽莎', 100, 0, 2),
(1818, '藤制', '', '藤制', 100, 0, 1),
(1819, 'LIZLISA', '', 'LIZLISA', 100, 0, 1),
(1820, 'LISA', '', 'LISA', 100, 0, 2),
(1821, '包邮※', '', '包邮※', 100, 0, 2),
(1822, '新版', '', '新版', 100, 0, 1),
(1823, '防盗', '', '防盗', 100, 0, 1),
(1824, '包小锁', '', '包小锁', 100, 0, 1),
(1825, '麻包', '', '麻包', 100, 0, 1),
(1826, '手袋', '', '手袋', 100, 0, 1),
(1827, 'CH600', '', 'CH600', 100, 0, 1),
(1828, '马鞍', '', '马鞍', 100, 0, 1),
(1829, '压花', '', '压花', 100, 0, 1),
(1830, '信封', '', '信封', 100, 0, 1),
(1831, '包女', '', '包女', 100, 0, 1),
(1832, '假日', '', '假日', 100, 0, 1),
(1833, '天兰', '', '天兰', 100, 0, 1),
(1834, '藤条', '', '藤条', 100, 0, 1),
(1835, '小巧', '', '小巧', 100, 0, 5),
(1836, '送花', '', '送花', 100, 0, 1),
(1837, '辣椒', '', '辣椒', 100, 0, 1),
(1838, '樱桃', '', '樱桃', 100, 0, 5),
(1839, '菜价', '', '菜价', 100, 0, 1),
(1840, '麦秸', '', '麦秸', 100, 0, 1),
(1841, '0016', '', '0016', 100, 0, 1),
(1842, '多花', '', '多花', 100, 0, 1),
(1843, '0012', '', '0012', 100, 0, 1),
(1844, '独家', '', '独家', 100, 0, 40),
(1845, '混编', '', '混编', 100, 0, 1),
(1846, '海星', '', '海星', 100, 0, 1),
(1847, '浪漫', '', '浪漫', 100, 0, 7),
(1848, '苏格兰', '', '苏格兰', 100, 0, 1),
(1849, '椰子', '', '椰子', 100, 0, 1),
(1850, '泰国', '', '泰国', 100, 0, 4),
(1851, '大象', '', '大象', 100, 0, 1),
(1852, '热带', '', '热带', 100, 0, 1),
(1853, '爱美', '', '爱美', 100, 0, 1),
(1854, '出行', '', '出行', 100, 0, 1),
(1855, '包森系', '', '包森系', 100, 0, 3),
(1856, '心包', '', '心包', 100, 0, 1),
(1857, '销售', '', '销售', 100, 0, 1),
(1858, '首发', '', '首发', 100, 0, 1),
(1859, 'AD300', '', 'AD300', 100, 0, 1),
(1860, '包邮波', '', '包邮波', 100, 0, 1),
(1861, '9.9', '', '9.9', 100, 0, 1),
(1862, '织田', '', '织田', 100, 0, 1),
(1863, '单件', '', '单件', 100, 0, 2),
(1864, '棉绳', '', '棉绳', 100, 0, 1),
(1865, '中号', '', '中号', 100, 0, 2),
(1866, '车轮', '', '车轮', 100, 0, 1),
(1867, '天和', '', '天和', 100, 0, 1),
(1868, '鱼骨', '', '鱼骨', 100, 0, 1),
(1869, '衣架', '', '衣架', 100, 0, 1),
(1870, '田野', '', '田野', 100, 0, 1),
(1871, '时装', '', '时装', 100, 0, 4),
(1872, '锁骨', '', '锁骨', 100, 0, 20),
(1873, '金奥钻', '', '金奥钻', 100, 0, 1),
(1874, '休闲表', '', '休闲表', 100, 0, 1),
(1875, '果冻', '', '果冻', 100, 0, 7),
(1876, '硅胶', '', '硅胶', 100, 0, 5),
(1877, '卡子', '', '卡子', 100, 0, 3),
(1878, '夹子', '', '夹子', 100, 0, 1),
(1879, '哥特', '', '哥特', 100, 0, 2),
(1880, '颈链', '', '颈链', 100, 0, 3),
(1881, '奥地利', '', '奥地利', 100, 0, 6),
(1882, '镀金', '', '镀金', 100, 0, 6),
(1883, '发圈', '', '发圈', 100, 0, 8),
(1884, '眼镜框', '', '眼镜框', 100, 0, 3),
(1885, '斑点', '', '斑点', 100, 0, 1),
(1886, '最新', '', '最新', 100, 0, 2),
(1887, '施华', '', '施华', 100, 0, 3),
(1888, '女友', '', '女友', 100, 0, 10),
(1889, '生日', '', '生日', 100, 0, 13),
(1890, '手腕', '', '手腕', 100, 0, 1),
(1891, '婚庆', '', '婚庆', 100, 0, 3),
(1892, '新娘', '', '新娘', 100, 0, 12),
(1893, '结婚', '', '结婚', 100, 0, 5),
(1894, '颈饰', '', '颈饰', 100, 0, 1),
(1895, '耳坠', '', '耳坠', 100, 0, 6),
(1896, '时尚饰品', '', '时尚饰品', 100, 0, 4),
(1897, '单色', '', '单色', 100, 0, 1),
(1898, '多彩', '', '多彩', 100, 0, 4),
(1899, '单排', '', '单排', 100, 0, 3),
(1900, '娇娘', '', '娇娘', 100, 0, 1),
(1901, '耳针', '', '耳针', 100, 0, 2),
(1902, '对称', '', '对称', 100, 0, 3),
(1903, '大耳', '', '大耳', 100, 0, 2),
(1904, '圆形', '', '圆形', 100, 0, 3),
(1905, '莲娜', '', '莲娜', 100, 0, 1),
(1906, '丽晶', '', '丽晶', 100, 0, 1),
(1907, '食指', '', '食指', 100, 0, 2),
(1908, '方块', '', '方块', 100, 0, 3),
(1909, '十字架', '', '十字架', 100, 0, 4),
(1910, '纯银', '', '纯银', 100, 0, 23),
(1911, '银饰品', '', '银饰品', 100, 0, 3),
(1912, '飞翔', '', '飞翔', 100, 0, 1),
(1913, '发卡', '', '发卡', 100, 0, 10),
(1914, '发夹', 'cache/tag/20130829/1377756209.jpg', '发夹', 100, 0, 22),
(1915, '婴幼儿', '', '婴幼儿', 100, 0, 1),
(1916, '紫水晶', '', '紫水晶', 100, 0, 3),
(1917, '夸张', '', '夸张', 100, 0, 8),
(1918, '韩版长', '', '韩版长', 100, 0, 2),
(1919, '925', '', '925', 100, 0, 7),
(1920, '过敏', '', '过敏', 100, 0, 3),
(1921, '缎带', '', '缎带', 100, 0, 1),
(1922, '水晶手链', '', '水晶手链', 100, 0, 3),
(1923, '水晶球', '', '水晶球', 100, 0, 1),
(1924, '新光', '', '新光', 100, 0, 1),
(1925, '婴儿', '', '婴儿', 100, 0, 1),
(1926, '狮子头', '', '狮子头', 100, 0, 1),
(1927, '丝绒', '', '丝绒', 100, 0, 1),
(1928, '珠子', '', '珠子', 100, 0, 1),
(1929, '装饰品', '', '装饰品', 100, 0, 2),
(1930, '晶珠', '', '晶珠', 100, 0, 2),
(1931, '手饰', '', '手饰', 100, 0, 4),
(1932, '头饰品', '', '头饰品', 100, 0, 7),
(1933, '绸带', '', '绸带', 100, 0, 1),
(1934, '一对', '', '一对', 100, 0, 4),
(1935, '小孩', '', '小孩', 100, 0, 2),
(1936, '白银', '', '白银', 100, 0, 1),
(1937, '白金', '', '白金', 100, 0, 5),
(1938, '紫色', '', '紫色', 100, 0, 1),
(1939, '长方形', '', '长方形', 100, 0, 1),
(1940, '项绳', '', '项绳', 100, 0, 1),
(1941, '鉴定证', '', '鉴定证', 100, 0, 1),
(1942, '猫眼石', '', '猫眼石', 100, 0, 6),
(1943, '康乃馨', '', '康乃馨', 100, 0, 1),
(1944, '防紫外线', '', '防紫外线', 100, 0, 1),
(1945, '太阳眼镜', '', '太阳眼镜', 100, 0, 4),
(1946, '超酷', '', '超酷', 100, 0, 1),
(1947, '宫廷', '', '宫廷', 100, 0, 2),
(1948, '钛钢', '', '钛钢', 100, 0, 4),
(1949, '钢珠', '', '钢珠', 100, 0, 1),
(1950, '男士', '', '男士', 100, 0, 19),
(1951, '主流', '', '主流', 100, 0, 2),
(1952, '周岁', '', '周岁', 100, 0, 1),
(1953, '拍照', '', '拍照', 100, 0, 2),
(1954, '花田', '', '花田', 100, 0, 1),
(1955, '超长', '', '超长', 100, 0, 5),
(1956, '配件', '', '配件', 100, 0, 2),
(1957, '挂链', '', '挂链', 100, 0, 1),
(1958, '玫瑰花', '', '玫瑰花', 100, 0, 3),
(1960, 'DHL', '', 'DHL', 100, 0, 1),
(1961, '洗面奶', 'cache/tag/20130829/1377757644.jpg', '洗面奶', 100, 0, 7),
(1962, '书包', '', '书包', 100, 0, 31),
(1963, 'Fourone', '', 'Fourone', 100, 0, 1),
(1964, '开学', '', '开学', 100, 0, 2),
(1965, '骷髅', '', '骷髅', 100, 0, 1),
(1966, '医生', '', '医生', 100, 0, 3),
(1967, '国旗', '', '国旗', 100, 0, 1),
(1968, 'Vintage', '', 'Vintage', 100, 0, 12),
(1969, '古小', '', '古小', 100, 0, 1),
(1970, '古着', '', '古着', 100, 0, 1),
(1971, '三用', '', '三用', 100, 0, 1),
(1972, '万圣节', '', '万圣节', 100, 0, 1),
(1973, '虾条', '', '虾条', 100, 0, 1),
(1974, '零食', '', '零食', 100, 0, 5),
(1975, '品网', '', '品网', 100, 0, 1),
(1976, '马来西亚', '', '马来西亚', 100, 0, 1),
(1977, '咪咪', '', '咪咪', 100, 0, 1),
(1978, '正宗', '', '正宗', 100, 0, 1),
(1979, '风味', '', '风味', 100, 0, 1),
(1980, '20g', '', '20g', 100, 0, 1),
(1981, '月饼', '', '月饼', 100, 0, 1),
(1982, '中秋月饼', '', '中秋月饼', 100, 0, 1),
(1983, '华美', '', '华美', 100, 0, 1),
(1984, '500g', '', '500g', 100, 0, 1),
(1985, '回车键', '', '回车键', 100, 0, 1),
(1986, '按键', '', '按键', 100, 0, 1),
(1987, 'HOME', '', 'HOME', 100, 0, 1),
(1988, 'iphone5', '', 'iphone5', 100, 0, 1),
(1989, 'IPAD', '', 'IPAD', 100, 0, 1),
(1990, '云霄', '', '云霄', 100, 0, 1),
(4457, 'AA2271', '', 'AA2271', 100, 0, 1),
(1992, '补水', '', '补水', 100, 0, 2),
(1993, '滋养', '', '滋养', 100, 0, 1),
(1994, '动感', '', '动感', 100, 0, 1),
(1995, '化妆品', '', '化妆品', 100, 0, 2),
(1996, '专卖', '', '专卖', 100, 0, 3),
(1997, '120ml', '', '120ml', 100, 0, 3),
(1998, '定妆', '', '定妆', 100, 0, 1),
(1999, '眼线笔', '', '眼线笔', 100, 0, 1),
(2000, '晕染', '', '晕染', 100, 0, 2),
(2001, '国防', '', '国防', 100, 0, 1),
(2002, '自动', '', '自动', 100, 0, 1),
(2003, '美宝莲', '', '美宝莲', 100, 0, 1),
(2004, '纤长', '', '纤长', 100, 0, 1),
(2005, '浓密', '', '浓密', 100, 0, 1),
(2006, '胖子', '', '胖子', 100, 0, 1),
(2007, '特惠', '', '特惠', 100, 0, 1),
(2008, '蜗牛', '', '蜗牛', 100, 0, 1),
(2009, '全能', '', '全能', 100, 0, 2),
(2010, '神仙', '', '神仙', 100, 0, 1),
(2011, '修复', '', '修复', 100, 0, 1),
(2012, '洁肤', '', '洁肤', 100, 0, 1),
(2013, '温和', '', '温和', 100, 0, 2),
(2014, 'Clinique', '', 'Clinique', 100, 0, 1),
(2015, '200ml', '', '200ml', 100, 0, 4),
(2016, '洁面膏', '', '洁面膏', 100, 0, 3),
(2017, '欧珀莱', '', '欧珀莱', 100, 0, 1),
(2018, '均衡', '', '均衡', 100, 0, 1),
(2019, '商城', '', '商城', 100, 0, 1),
(2020, '125', '', '125', 100, 0, 1),
(2021, '玉兰', '', '玉兰', 100, 0, 3),
(2022, '油水', '', '油水', 100, 0, 1),
(2023, '旗舰', '', '旗舰', 100, 0, 2),
(2024, '动力', '', '动力', 100, 0, 1),
(2025, '150ml', '', '150ml', 100, 0, 2),
(2026, '无瑕', '', '无瑕', 100, 0, 1),
(2027, '肤色', '', '肤色', 100, 0, 1),
(2028, '极致', '', '极致', 100, 0, 1),
(2029, '修正', '', '修正', 100, 0, 1),
(2030, '罗兰紫', '', '罗兰紫', 100, 0, 1),
(2031, '10ml', '', '10ml', 100, 0, 2),
(2032, '加芬', '', '加芬', 100, 0, 1),
(2033, '雅诗兰黛', '', '雅诗兰黛', 100, 0, 1),
(2034, '精粹', '', '精粹', 100, 0, 1),
(2035, '名品', '', '名品', 100, 0, 14),
(2036, '精油', '', '精油', 100, 0, 7),
(2037, '香皂', '', '香皂', 100, 0, 1),
(2038, '肥皂', '', '肥皂', 100, 0, 1),
(2039, '薰衣草', '', '薰衣草', 100, 0, 2),
(2040, '洗脸', '', '洗脸', 100, 0, 2),
(2041, '郑明明', '', '郑明明', 100, 0, 1),
(2042, '杏仁', '', '杏仁', 100, 0, 1),
(2043, '150', '', '150', 100, 0, 1),
(2044, 'CMM', '', 'CMM', 100, 0, 1),
(2045, 'ml', '', 'ml', 100, 0, 1),
(2046, '格丽', '', '格丽', 100, 0, 1),
(2047, '轻盈', '', '轻盈', 100, 0, 1),
(2048, 'Bvlgari', '', 'Bvlgari', 100, 0, 1),
(2049, '花舞', '', '花舞', 100, 0, 1),
(2050, '调理水', '', '调理水', 100, 0, 1),
(2051, '收缩毛孔', '', '收缩毛孔', 100, 0, 1),
(2052, '纯净', '', '纯净', 100, 0, 1),
(2053, 'Prox', '', 'Prox', 100, 0, 1),
(2054, 'Olay', '', 'Olay', 100, 0, 2),
(2055, '水份', '', '水份', 100, 0, 1),
(2056, '自然', '', '自然', 100, 0, 1),
(2057, '30ml', '', '30ml', 100, 0, 1),
(2058, '双色', '', '双色', 100, 0, 3),
(2059, '10g', '', '10g', 100, 0, 1),
(2060, 'BB', '', 'BB', 100, 0, 1),
(2061, '去死皮素', '', '去死皮素', 100, 0, 2),
(2062, '嫩白', '', '嫩白', 100, 0, 1),
(2063, '角质', '', '角质', 100, 0, 1),
(2064, '老化', '', '老化', 100, 0, 1),
(2065, '去除', '', '去除', 100, 0, 2),
(2066, '阿芙', '', '阿芙', 100, 0, 1),
(2067, '单方', '', '单方', 100, 0, 1),
(2068, '保养', '', '保养', 100, 0, 1),
(2069, '女性', '', '女性', 100, 0, 1),
(2070, '9.99', '', '9.99', 100, 0, 1),
(2071, '100ml', '', '100ml', 100, 0, 6),
(2072, '洁面乳', '', '洁面乳', 100, 0, 8),
(2073, '橄榄', '', '橄榄', 100, 0, 1),
(2074, '深层', '', '深层', 100, 0, 4),
(2075, '韩洛依', '', '韩洛依', 100, 0, 1),
(2076, '旗舰店', '', '旗舰店', 100, 0, 2),
(2077, '官方', '', '官方', 100, 0, 1),
(2078, '斯顿', '', '斯顿', 100, 0, 1),
(2079, '动能', '', '动能', 100, 0, 1),
(2080, '镇静', '', '镇静', 100, 0, 1),
(2081, '舒缓', '', '舒缓', 100, 0, 2),
(2082, '按摩', '', '按摩', 100, 0, 4),
(2083, '香膏', '', '香膏', 100, 0, 1),
(2084, '面部', '', '面部', 100, 0, 1),
(2085, '春露', '', '春露', 100, 0, 1),
(2086, '滋润', '', '滋润', 100, 0, 8),
(2087, '花艺', '', '花艺', 100, 0, 3),
(2088, '竹编', '', '竹编', 100, 0, 1),
(2089, '欧式', '', '欧式', 100, 0, 7),
(2090, '陶瓷', '', '陶瓷', 100, 0, 10),
(2091, '整体', '', '整体', 100, 0, 1),
(2092, '国际象棋', '', '国际象棋', 100, 0, 1),
(2093, '美式', '', '美式', 100, 0, 2),
(2094, '摆设', '', '摆设', 100, 0, 2),
(2095, '树脂', '', '树脂', 100, 0, 5),
(2096, '工艺品', '', '工艺品', 100, 0, 3),
(2097, '华凌', '', '华凌', 100, 0, 1),
(2098, '异彩', '', '异彩', 100, 0, 1),
(2099, '家纺', '', '家纺', 100, 0, 1),
(2100, '床上用品', '', '床上用品', 100, 0, 2),
(2101, '案头', '', '案头', 100, 0, 1),
(2102, '家居饰品', '', '家居饰品', 100, 0, 2),
(2103, '工艺', '', '工艺', 100, 0, 1),
(2104, '水杯', '', '水杯', 100, 0, 1),
(2105, '玻璃', '', '玻璃', 100, 0, 5),
(2106, '果汁', '', '果汁', 100, 0, 2),
(2107, '乐逗', '', '乐逗', 100, 0, 1),
(2108, '马口', '', '马口', 100, 0, 1),
(2109, '下雪天', '', '下雪天', 100, 0, 1),
(2110, '小鹿', '', '小鹿', 100, 0, 1),
(2111, '方形', '', '方形', 100, 0, 1),
(2112, '雪花', '', '雪花', 100, 0, 1),
(2113, '圣诞节', '', '圣诞节', 100, 0, 1),
(2114, 'middot', '', 'middot', 100, 0, 4),
(2115, '童家', '', '童家', 100, 0, 2),
(2116, '米字旗', '', '米字旗', 100, 0, 2),
(2117, '马口铁', '', '马口铁', 100, 0, 3),
(2118, '密封', '', '密封', 100, 0, 1),
(2119, '储物罐', '', '储物罐', 100, 0, 2),
(2120, '两用', '', '两用', 100, 0, 1),
(2121, '折叠', '', '折叠', 100, 0, 1),
(2122, '被子', '', '被子', 100, 0, 2),
(2123, '多功能', '', '多功能', 100, 0, 4),
(2124, '汽车', '', '汽车', 100, 0, 1),
(2125, '家饰', '', '家饰', 100, 0, 4),
(2126, '纸巾', '', '纸巾', 100, 0, 3),
(2127, '古典', '', '古典', 100, 0, 2),
(2128, '良品', '', '良品', 100, 0, 1),
(2129, '可居', '', '可居', 100, 0, 1),
(2130, '底纹', '', '底纹', 100, 0, 1),
(2131, '木桌', '', '木桌', 100, 0, 1),
(2132, '座钟', '', '座钟', 100, 0, 5),
(2133, '山水', '', '山水', 100, 0, 1),
(2134, '系列', '', '系列', 100, 0, 14),
(2135, '台钟', '', '台钟', 100, 0, 2),
(2136, '古雅', '', '古雅', 100, 0, 1),
(2137, '铁艺', '', '铁艺', 100, 0, 1),
(2138, '钟表', '', '钟表', 100, 0, 2),
(2139, '正方形', '', '正方形', 100, 0, 1),
(2140, '铁皮', '', '铁皮', 100, 0, 2),
(2141, '纸盒', '', '纸盒', 100, 0, 2),
(2142, '家居用品', '', '家居用品', 100, 0, 2),
(2143, 'sucre', '', 'sucre', 100, 0, 1),
(2144, 'Le', '', 'Le', 100, 0, 1),
(2145, '白瓷', '', '白瓷', 100, 0, 2),
(2146, '纸杯', '', '纸杯', 100, 0, 1),
(2147, '随手', '', '随手', 100, 0, 1),
(2148, '138', '', '138', 100, 0, 1),
(2149, 'CH', '', 'CH', 100, 0, 1),
(2150, '长耳朵', '', '长耳朵', 100, 0, 1),
(2151, '树脂工艺', '', '树脂工艺', 100, 0, 2),
(2152, '胖胖', '', '胖胖', 100, 0, 2),
(2153, '地中海', '', '地中海', 100, 0, 7),
(2154, '客厅', '', '客厅', 100, 0, 1),
(2155, '帆船', '', '帆船', 100, 0, 1),
(2156, '模型', '', '模型', 100, 0, 2),
(2157, '瓶罐', '', '瓶罐', 100, 0, 2),
(2158, '香料', '', '香料', 100, 0, 1),
(2159, '咖啡馆', '', '咖啡馆', 100, 0, 1),
(2160, '调味', '', '调味', 100, 0, 2),
(2161, '餐厅', '', '餐厅', 100, 0, 1),
(2162, '缇娜', '', '缇娜', 100, 0, 1),
(2163, '康妮', '', '康妮', 100, 0, 1),
(2164, '芮诗凯', '', '芮诗凯', 100, 0, 3),
(2165, '高温', '', '高温', 100, 0, 1),
(2166, '储物', '', '储物', 100, 0, 1),
(2167, '浮雕玻璃', '', '浮雕玻璃', 100, 0, 1),
(2168, '水滴形', '', '水滴形', 100, 0, 1),
(2169, '刻花', '', '刻花', 100, 0, 1),
(2170, '茶杯', '', '茶杯', 100, 0, 2),
(2171, '琉璃', '', '琉璃', 100, 0, 2),
(2172, '安娜', '', '安娜', 100, 0, 1),
(2173, '嫣然', '', '嫣然', 100, 0, 1),
(2174, '电表箱', '', '电表箱', 100, 0, 1),
(2175, '壁挂', '', '壁挂', 100, 0, 2),
(2176, '墙面', '', '墙面', 100, 0, 1),
(2177, '下午', '', '下午', 100, 0, 1),
(2178, '铁木', '', '铁木', 100, 0, 1),
(2179, '酒吧', '', '酒吧', 100, 0, 1),
(2180, '火车头', '', '火车头', 100, 0, 1),
(2181, '蒸汽机', '', '蒸汽机', 100, 0, 1),
(2182, 'Way', '', 'Way', 100, 0, 1),
(2183, 'My', '', 'My', 100, 0, 1),
(2184, '耐热', '', '耐热', 100, 0, 1),
(2185, '幸运', '', '幸运', 100, 0, 3),
(2186, 'JP3877', '', 'JP3877', 100, 0, 1),
(2187, '高硼硅', '', '高硼硅', 100, 0, 1),
(2188, '尼贝尔', '', '尼贝尔', 100, 0, 1),
(2189, '毛巾布', '', '毛巾布', 100, 0, 1),
(2190, '美美', '', '美美', 100, 0, 1),
(2191, 'roomseven', '', 'roomseven', 100, 0, 1),
(2192, 'MMK', '', 'MMK', 100, 0, 1),
(2193, '一碟', '', '一碟', 100, 0, 1),
(2194, '一杯', '', '一杯', 100, 0, 1),
(2195, '搪瓷', '', '搪瓷', 100, 0, 1),
(2196, '回忆', '', '回忆', 100, 0, 1),
(2197, '0.42', '', '0.42', 100, 0, 1),
(2198, 'kg', '', 'kg', 100, 0, 2),
(2199, '柳编', '', '柳编', 100, 0, 1),
(2200, '杂物', '', '杂物', 100, 0, 1),
(2201, '篮子', '', '篮子', 100, 0, 1),
(2202, '遥控器', '', '遥控器', 100, 0, 1),
(2203, '工具', '', '工具', 100, 0, 1),
(2204, '宜家', '', '宜家', 100, 0, 1),
(2205, '北欧', '', '北欧', 100, 0, 2),
(2206, '克美', '', '克美', 100, 0, 3),
(2207, '野马', '', '野马', 100, 0, 1),
(2208, '台灯', '', '台灯', 100, 0, 2),
(2209, '会所', '', '会所', 100, 0, 1),
(2210, '风雨同舟', '', '风雨同舟', 100, 0, 1),
(2211, '小号', '', '小号', 100, 0, 2),
(2212, '革命', '', '革命', 100, 0, 1),
(2213, '礼品', '', '礼品', 100, 0, 2),
(2214, '289', '', '289', 100, 0, 1),
(2215, '19', '', '19', 100, 0, 1),
(2216, '大毛', '', '大毛', 100, 0, 1),
(2217, '面巾', '', '面巾', 100, 0, 1),
(2218, '加厚', '', '加厚', 100, 0, 6),
(2219, '五星级', '', '五星级', 100, 0, 1),
(2220, '酒店', '', '酒店', 100, 0, 1),
(2221, '康尔馨', '', '康尔馨', 100, 0, 1),
(2222, '靠枕', '', '靠枕', 100, 0, 5),
(2223, '双人', '', '双人', 100, 0, 1),
(2224, '床头', '', '床头', 100, 0, 3),
(2225, '实木', '', '实木', 100, 0, 2),
(2226, '木质', '', '木质', 100, 0, 3),
(2227, '鸭子', '', '鸭子', 100, 0, 1),
(2228, '新婚', '', '新婚', 100, 0, 1),
(2229, '原木', '', '原木', 100, 0, 1),
(2230, '奥本罗', '', '奥本罗', 100, 0, 1),
(2231, '超细', '', '超细', 100, 0, 1),
(2232, '门垫', '', '门垫', 100, 0, 3),
(2233, '吸水', '', '吸水', 100, 0, 2),
(2234, '浴室', '', '浴室', 100, 0, 1),
(2235, '卧室', '', '卧室', 100, 0, 2),
(2236, '超强', '', '超强', 100, 0, 1),
(2237, '纤维', '', '纤维', 100, 0, 2),
(2238, '笑脸', '', '笑脸', 100, 0, 3),
(2239, '牛奶', '', '牛奶', 100, 0, 1),
(2240, '脚垫', '', '脚垫', 100, 0, 1),
(2241, '琳娜', '', '琳娜', 100, 0, 1),
(2242, '六人', '', '六人', 100, 0, 1),
(2243, '餐厅家具', '', '餐厅家具', 100, 0, 1),
(2244, '法式', '', '法式', 100, 0, 3),
(2245, '饭桌', '', '饭桌', 100, 0, 1),
(2246, 'F602', '', 'F602', 100, 0, 1),
(2247, '博洋', '', '博洋', 100, 0, 1),
(2248, '斜纹', '', '斜纹', 100, 0, 1),
(2249, '花开', '', '花开', 100, 0, 3),
(2250, '活性', '', '活性', 100, 0, 2),
(2251, '球形', '', '球形', 100, 0, 1),
(2252, '无烟', '', '无烟', 100, 0, 1),
(2253, '情人节', '', '情人节', 100, 0, 4),
(2254, '时光', '', '时光', 100, 0, 5),
(2255, '奶瓶', '', '奶瓶', 100, 0, 1),
(2256, '奶牛', '', '奶牛', 100, 0, 1),
(2257, '胡瓶', '', '胡瓶', 100, 0, 1),
(2258, '连座', '', '连座', 100, 0, 1),
(2259, '整理箱', '', '整理箱', 100, 0, 1),
(2260, '抗菌', '', '抗菌', 100, 0, 1),
(2261, '无纺布', '', '无纺布', 100, 0, 1),
(2262, '衣物', '', '衣物', 100, 0, 1),
(2263, 'J08813', '', 'J08813', 100, 0, 1),
(2264, '彩绘', '', '彩绘', 100, 0, 2),
(2265, '木制', '', '木制', 100, 0, 2),
(2266, '甜心', '', '甜心', 100, 0, 1),
(2267, '绿意', '', '绿意', 100, 0, 1),
(2268, '套件', '', '套件', 100, 0, 4),
(2269, '船舵', '', '船舵', 100, 0, 2),
(2270, '家居装饰', '', '家居装饰', 100, 0, 1),
(2271, '领航', '', '领航', 100, 0, 1),
(2272, '中包', '', '中包', 100, 0, 2),
(2273, 'hearts', '', 'hearts', 100, 0, 3),
(2274, 'iconic', '', 'iconic', 100, 0, 1),
(2275, 'MORI', '', 'MORI', 100, 0, 1),
(2276, 'HI', '', 'HI', 100, 0, 1),
(2277, '英文', '', '英文', 100, 0, 1),
(2278, '花盆', '', '花盆', 100, 0, 1),
(2279, '17', '', '17', 100, 0, 1),
(2280, '22', '', '22', 100, 0, 1),
(2281, '杂物盒', '', '杂物盒', 100, 0, 1),
(2282, '奶粉', '', '奶粉', 100, 0, 1),
(2283, '唱歌', '', '唱歌', 100, 0, 1),
(2284, '圣诞', '', '圣诞', 100, 0, 2),
(2285, '磨毛', '', '磨毛', 100, 0, 1),
(2286, '花影', '', '花影', 100, 0, 1),
(2287, '仙子', '', '仙子', 100, 0, 1),
(2288, '酒店宾馆', '', '酒店宾馆', 100, 0, 1),
(2289, '宾馆', '', '宾馆', 100, 0, 1),
(2290, '贡缎', '', '贡缎', 100, 0, 2),
(2291, '提花', '', '提花', 100, 0, 4),
(2292, '可可', '', '可可', 100, 0, 1),
(2293, '雕刻', '', '雕刻', 100, 0, 1),
(2294, '惊喜', '', '惊喜', 100, 0, 1),
(2295, '绝对', '', '绝对', 100, 0, 1),
(2296, '调味料', '', '调味料', 100, 0, 1),
(2297, '软木塞', '', '软木塞', 100, 0, 1),
(2298, '底座', '', '底座', 100, 0, 1),
(2299, '胡椒', '', '胡椒', 100, 0, 2),
(2300, '景德镇', '', '景德镇', 100, 0, 2),
(2301, '素朴', '', '素朴', 100, 0, 1);
INSERT INTO `le_goods_tags` (`tag_id`, `tag_name`, `img`, `tag_code`, `sort`, `is_hot`, `count`) VALUES
(2302, '娟秀', '', '娟秀', 100, 0, 1),
(2303, '丽新', '', '丽新', 100, 0, 1),
(2304, '天鹅绒', '', '天鹅绒', 100, 0, 1),
(2305, '米床', '', '米床', 100, 0, 1),
(2306, '1.2', '', '1.2', 100, 0, 1),
(2307, '1.5', '', '1.5', 100, 0, 1),
(2308, '名片盒', '', '名片盒', 100, 0, 1),
(2309, '烤漆', '', '烤漆', 100, 0, 2),
(2310, '草莓', '', '草莓', 100, 0, 4),
(2311, '盒子', '', '盒子', 100, 0, 15),
(2312, '0.035', '', '0.035', 100, 0, 1),
(2313, '碧丝', '', '碧丝', 100, 0, 1),
(2314, '姬卡', '', '姬卡', 100, 0, 1),
(2315, '夏凉', '', '夏凉', 100, 0, 1),
(2316, '靠背', '', '靠背', 100, 0, 2),
(2317, '配套', '', '配套', 100, 0, 1),
(2318, '盐罐', '', '盐罐', 100, 0, 1),
(2319, '佐料', '', '佐料', 100, 0, 1),
(2320, '调料', '', '调料', 100, 0, 1),
(2321, '移动', '', '移动', 100, 0, 1),
(2322, 'CJ009', '', 'CJ009', 100, 0, 1),
(2323, '边几', '', '边几', 100, 0, 1),
(2324, '排排', '', '排排', 100, 0, 1),
(2325, '拱形', '', '拱形', 100, 0, 1),
(2326, '坐坐', '', '坐坐', 100, 0, 1),
(2327, '书架', '', '书架', 100, 0, 1),
(2328, '昨日', '', '昨日', 100, 0, 1),
(2329, '五彩', '', '五彩', 100, 0, 1),
(2330, '桌面', '', '桌面', 100, 0, 5),
(2331, '茶壶', '', '茶壶', 100, 0, 1),
(2332, '凉水', '', '凉水', 100, 0, 1),
(2333, '冷水', '', '冷水', 100, 0, 1),
(2334, '朗润', '', '朗润', 100, 0, 1),
(2335, '双面', '', '双面', 100, 0, 1),
(2336, '莫代尔', '', '莫代尔', 100, 0, 1),
(2337, '三口', '', '三口', 100, 0, 1),
(2338, '长颈鹿', '', '长颈鹿', 100, 0, 1),
(2339, '懒人', '', '懒人', 100, 0, 4),
(2340, '睡袋', '', '睡袋', 100, 0, 1),
(2341, '黑熊', '', '黑熊', 100, 0, 1),
(2342, '毛绒玩具', '', '毛绒玩具', 100, 0, 1),
(2343, '鲨鱼', '', '鲨鱼', 100, 0, 1),
(2344, '温暖', '', '温暖', 100, 0, 1),
(2345, '来自', '', '来自', 100, 0, 1),
(2346, '水培', '', '水培', 100, 0, 1),
(2347, '创意家居', '', '创意家居', 100, 0, 1),
(2348, '唯心', '', '唯心', 100, 0, 1),
(2349, '落地', '', '落地', 100, 0, 3),
(2350, '落地灯', '', '落地灯', 100, 0, 1),
(2351, '宫庭', '', '宫庭', 100, 0, 1),
(2352, '相架', '', '相架', 100, 0, 1),
(2353, '浮雕', '', '浮雕', 100, 0, 3),
(2354, '相框', '', '相框', 100, 0, 2),
(2355, '喜糖', '', '喜糖', 100, 0, 1),
(2356, '礼品盒', '', '礼品盒', 100, 0, 1),
(2357, '感恩', '', '感恩', 100, 0, 1),
(2358, '小屋', '', '小屋', 100, 0, 1),
(2359, '房子', '', '房子', 100, 0, 1),
(2360, '花型', '', '花型', 100, 0, 1),
(2361, '水星', '', '水星', 100, 0, 2),
(2362, '蓝语迷', '', '蓝语迷', 100, 0, 1),
(2363, '床头灯', '', '床头灯', 100, 0, 2),
(2364, '动物', '', '动物', 100, 0, 4),
(2365, '地中', '', '地中', 100, 0, 1),
(2366, '腰靠', '', '腰靠', 100, 0, 1),
(2367, '海风', '', '海风', 100, 0, 1),
(2368, '史努比', '', '史努比', 100, 0, 1),
(2369, 'PISCES', '', 'PISCES', 100, 0, 1),
(2370, '浴室用品', '', '浴室用品', 100, 0, 1),
(2371, '方巾', '', '方巾', 100, 0, 1),
(2372, '组合', '', '组合', 100, 0, 3),
(2373, 'Harbor', '', 'Harbor', 100, 0, 1),
(2374, 'House', '', 'House', 100, 0, 1),
(2375, '餐巾', '', '餐巾', 100, 0, 2),
(2376, '科西嘉', '', '科西嘉', 100, 0, 1),
(2377, '819046', '', '819046', 100, 0, 1),
(2378, '书房', '', '书房', 100, 0, 1),
(2379, '真假', '', '真假', 100, 0, 1),
(2380, '道具', '', '道具', 100, 0, 2),
(2381, 'FF14', '', 'FF14', 100, 0, 1),
(2382, '台布', '', '台布', 100, 0, 1),
(2383, '木船', '', '木船', 100, 0, 1),
(2384, '商务礼品', '', '商务礼品', 100, 0, 1),
(2385, '奖品', '', '奖品', 100, 0, 1),
(2386, '酒吧台', '', '酒吧台', 100, 0, 1),
(2387, '酒架', '', '酒架', 100, 0, 1),
(2388, '酒桶', '', '酒桶', 100, 0, 1),
(2389, '酒柜', '', '酒柜', 100, 0, 1),
(2390, '橡木', '', '橡木', 100, 0, 1),
(2391, '紫蓝', '', '紫蓝', 100, 0, 1),
(2392, '悦达', '', '悦达', 100, 0, 1),
(2393, '色织', '', '色织', 100, 0, 1),
(2394, '情趣', '', '情趣', 100, 0, 1),
(2395, '盆栽', '', '盆栽', 100, 0, 1),
(2396, '盆景', '', '盆景', 100, 0, 1),
(2397, '拍摄', '', '拍摄', 100, 0, 1),
(2398, '小盘子', '', '小盘子', 100, 0, 1),
(2399, '银杏叶', '', '银杏叶', 100, 0, 1),
(2400, '碟子', '', '碟子', 100, 0, 1),
(2401, '0.1', '', '0.1', 100, 0, 1),
(2402, '迷迭香', '', '迷迭香', 100, 0, 1),
(2403, '规格', '', '规格', 100, 0, 1),
(2404, '抽象', '', '抽象', 100, 0, 1),
(2405, '储物置', '', '储物置', 100, 0, 1),
(2406, '花形三', '', '花形三', 100, 0, 1),
(2407, '调味盒', '', '调味盒', 100, 0, 1),
(2408, '厨房用品', '', '厨房用品', 100, 0, 1),
(2409, 'LEC', '', 'LEC', 100, 0, 1),
(2410, '双耳', '', '双耳', 100, 0, 1),
(2411, '汤碗', '', '汤碗', 100, 0, 1),
(2412, '微波', '', '微波', 100, 0, 2),
(2413, '震撼', '', '震撼', 100, 0, 1),
(2414, '餐馆', '', '餐馆', 100, 0, 1),
(2415, '灿烂', '', '灿烂', 100, 0, 1),
(2416, '盖储物', '', '盖储物', 100, 0, 1),
(2417, '学生床', '', '学生床', 100, 0, 1),
(2418, '米四', '', '米四', 100, 0, 1),
(2419, '吊脚', '', '吊脚', 100, 0, 1),
(2420, '人偶', '', '人偶', 100, 0, 1),
(2421, '房间', '', '房间', 100, 0, 1),
(2422, '斯里兰卡', '', '斯里兰卡', 100, 0, 1),
(2423, '凤凰', '', '凤凰', 100, 0, 1),
(2424, '孔雀', '', '孔雀', 100, 0, 1),
(2425, '时钟', '', '时钟', 100, 0, 1),
(2426, '法国', '', '法国', 100, 0, 3),
(2427, '订单', '', '订单', 100, 0, 1),
(2428, '奥雅', '', '奥雅', 100, 0, 3),
(2429, '迪佳', '', '迪佳', 100, 0, 3),
(2430, '舵手', '', '舵手', 100, 0, 1),
(2431, '单面', '', '单面', 100, 0, 1),
(2432, '搬迁', '', '搬迁', 100, 0, 1),
(2433, '6.5', '', '6.5', 100, 0, 1),
(2434, '盒带', '', '盒带', 100, 0, 1),
(2435, '茶叶罐', '', '茶叶罐', 100, 0, 1),
(2436, '高密', '', '高密', 100, 0, 1),
(2437, '封性', '', '封性', 100, 0, 1),
(2438, '天源', '', '天源', 100, 0, 1),
(2439, '三条', '', '三条', 100, 0, 1),
(2440, '抑菌', '', '抑菌', 100, 0, 1),
(2441, '陈列品', '', '陈列品', 100, 0, 1),
(2442, '书本', '', '书本', 100, 0, 1),
(2443, '字典', '', '字典', 100, 0, 1),
(2444, '海鸟', '', '海鸟', 100, 0, 1),
(2445, '仿古', '', '仿古', 100, 0, 2),
(2446, '飞鸟集', '', '飞鸟集', 100, 0, 1),
(2447, '品家', '', '品家', 100, 0, 1),
(2448, '陶瓷器', '', '陶瓷器', 100, 0, 1),
(2449, '花茶', '', '花茶', 100, 0, 1),
(2450, '塞纳', '', '塞纳', 100, 0, 1),
(2451, '烟灰色', '', '烟灰色', 100, 0, 1),
(2452, '啤酒杯', '', '啤酒杯', 100, 0, 1),
(2453, '威士忌', '', '威士忌', 100, 0, 1),
(2454, '冷饮', '', '冷饮', 100, 0, 1),
(2455, '闪光', '', '闪光', 100, 0, 1),
(2456, 'Janeouya', '', 'Janeouya', 100, 0, 1),
(2457, '皮革', '', '皮革', 100, 0, 1),
(2458, '新房', '', '新房', 100, 0, 1),
(2459, '宝丽', '', '宝丽', 100, 0, 1),
(2460, '花插', '', '花插', 100, 0, 1),
(2461, '仿真花', '', '仿真花', 100, 0, 1),
(2462, '烘培机', '', '烘培机', 100, 0, 1),
(2463, '全自动', '', '全自动', 100, 0, 1),
(2464, '时时', '', '时时', 100, 0, 1),
(2465, '镇宅', '', '镇宅', 100, 0, 1),
(2466, '辟邪', '', '辟邪', 100, 0, 1),
(2467, '船形', '', '船形', 100, 0, 1),
(2468, '骨瓷', '', '骨瓷', 100, 0, 1),
(2469, '面碗', '', '面碗', 100, 0, 1),
(2470, '三脚', '', '三脚', 100, 0, 1),
(2471, '和风', '', '和风', 100, 0, 1),
(2472, '米饭', '', '米饭', 100, 0, 1),
(2473, 'J11153', '', 'J11153', 100, 0, 1),
(2474, '灯塔', '', '灯塔', 100, 0, 3),
(2475, '健康杯', '', '健康杯', 100, 0, 1),
(2476, '耐高温', '', '耐高温', 100, 0, 1),
(2477, '待用', '', '待用', 100, 0, 1),
(2478, 'teatime', '', 'teatime', 100, 0, 1),
(2479, '环保', '', '环保', 100, 0, 1),
(2480, '餐垫', '', '餐垫', 100, 0, 1),
(2481, '杯垫', '', '杯垫', 100, 0, 1),
(2482, '木盒', '', '木盒', 100, 0, 1),
(2483, '花家', '', '花家', 100, 0, 1),
(2484, '黄麻', '', '黄麻', 100, 0, 1),
(2485, '整理', '', '整理', 100, 0, 1),
(2486, '食品', '', '食品', 100, 0, 1),
(2487, '卡塔尼', '', '卡塔尼', 100, 0, 1),
(2488, '救生圈', '', '救生圈', 100, 0, 1),
(2489, '游泳', '', '游泳', 100, 0, 1),
(2490, '毛巾被', '', '毛巾被', 100, 0, 1),
(2491, '锦绣', '', '锦绣', 100, 0, 1),
(2492, '珊瑚', '', '珊瑚', 100, 0, 1),
(2493, '恒源祥', '', '恒源祥', 100, 0, 1),
(2494, '装饰布', '', '装饰布', 100, 0, 1),
(2495, '花姿绿', '', '花姿绿', 100, 0, 1),
(2496, '翠西亚', '', '翠西亚', 100, 0, 1),
(2497, '扇型', '', '扇型', 100, 0, 1),
(2498, '祖母绿', '', '祖母绿', 100, 0, 1),
(2499, '瓶口', '', '瓶口', 100, 0, 1),
(2500, '双拼', '', '双拼', 100, 0, 1),
(2501, '返利', '', '返利', 100, 0, 1),
(2502, '单人床', '', '单人床', 100, 0, 1),
(2503, '三四', '', '三四', 100, 0, 1),
(2504, '西班牙', '', '西班牙', 100, 0, 1),
(2505, '色彩', '', '色彩', 100, 0, 1),
(2506, '乌篷船', '', '乌篷船', 100, 0, 1),
(2507, '绍兴', '', '绍兴', 100, 0, 1),
(2508, '民俗', '', '民俗', 100, 0, 1),
(2509, '民间', '', '民间', 100, 0, 1),
(2510, '子木', '', '子木', 100, 0, 1),
(2511, '托架', '', '托架', 100, 0, 1),
(2512, '安眠', '', '安眠', 100, 0, 1),
(2513, '仿真植物', '', '仿真植物', 100, 0, 1),
(2514, '睡莲', '', '睡莲', 100, 0, 1),
(2515, '人造', '', '人造', 100, 0, 2),
(2516, '花卉', '', '花卉', 100, 0, 1),
(2517, '竹盖', '', '竹盖', 100, 0, 2),
(2518, '碳化', '', '碳化', 100, 0, 1),
(2519, '竹木', '', '竹木', 100, 0, 1),
(2520, '优惠', '', '优惠', 100, 0, 1),
(2521, '床罩', '', '床罩', 100, 0, 1),
(2522, '三格', '', '三格', 100, 0, 1),
(2523, '杂货', '', '杂货', 100, 0, 3),
(2524, '牙签筒', '', '牙签筒', 100, 0, 1),
(2525, '牙签', '', '牙签', 100, 0, 1),
(2526, '药品', '', '药品', 100, 0, 1),
(2527, '乔迁', '', '乔迁', 100, 0, 1),
(2528, '出口美国', '', '出口美国', 100, 0, 1),
(2529, '嬉戏', '', '嬉戏', 100, 0, 1),
(2530, 'COSMOS', '', 'COSMOS', 100, 0, 1),
(2531, '车模', '', '车模', 100, 0, 1),
(2532, '橱窗', '', '橱窗', 100, 0, 1),
(2533, '花架', '', '花架', 100, 0, 1),
(2534, '木架', '', '木架', 100, 0, 1),
(2535, '熊第一', '', '熊第一', 100, 0, 1),
(2536, 'FT01', '', 'FT01', 100, 0, 1),
(2537, '利特', '', '利特', 100, 0, 1),
(2538, '玛格', '', '玛格', 100, 0, 1),
(2539, '居室', '', '居室', 100, 0, 1),
(2540, '巨大', '', '巨大', 100, 0, 1),
(2541, '数字', '', '数字', 100, 0, 1),
(2542, '化妆镜', '', '化妆镜', 100, 0, 1),
(2543, '台面', '', '台面', 100, 0, 1),
(2544, '镜子', '', '镜子', 100, 0, 1),
(2545, '水果盘', '', '水果盘', 100, 0, 1),
(2546, '果盘', '', '果盘', 100, 0, 1),
(2547, '甜品', '', '甜品', 100, 0, 1),
(2548, '点心', '', '点心', 100, 0, 1),
(2549, '挂牌', '', '挂牌', 100, 0, 1),
(2550, '门牌', '', '门牌', 100, 0, 1),
(2551, '卫生间', '', '卫生间', 100, 0, 1),
(2552, '厕所', '', '厕所', 100, 0, 1),
(2553, '木刻', '', '木刻', 100, 0, 1),
(2554, '幸福', '', '幸福', 100, 0, 1),
(2555, '生活', '', '生活', 100, 0, 1),
(2556, '支架', '', '支架', 100, 0, 1),
(2557, '水杯子', '', '水杯子', 100, 0, 1),
(2558, '对杯', '', '对杯', 100, 0, 1),
(2559, '埃及', '', '埃及', 100, 0, 1),
(2560, '异域风情', '', '异域风情', 100, 0, 1),
(2561, '工艺饰品', '', '工艺饰品', 100, 0, 1),
(2562, '热带鱼', '', '热带鱼', 100, 0, 1),
(2563, '团购', '', '团购', 100, 0, 1),
(2564, '坐姿', '', '坐姿', 100, 0, 1),
(2565, '销量', '', '销量', 100, 0, 1),
(2566, '公务', '', '公务', 100, 0, 1),
(2567, '韩剧', '', '韩剧', 100, 0, 1),
(2568, '听见', '', '听见', 100, 0, 1),
(2569, '声音', '', '声音', 100, 0, 1),
(2570, '张慧星', '', '张慧星', 100, 0, 1),
(2571, '金丝绒', '', '金丝绒', 100, 0, 3),
(2572, 'LYQ126', '', 'LYQ126', 100, 0, 1),
(2573, '徽章', '', '徽章', 100, 0, 3),
(2574, '勋章', '', '勋章', 100, 0, 4),
(2575, '混纺', '', '混纺', 100, 0, 1),
(2576, '异域', '', '异域', 100, 0, 2),
(2577, '周一', '', '周一', 100, 0, 1),
(2578, 'A6651', '', 'A6651', 100, 0, 1),
(2579, '调整型', '', '调整型', 100, 0, 12),
(2580, '聚拢', '', '聚拢', 100, 0, 13),
(2581, '女士内衣', '', '女士内衣', 100, 0, 4),
(2582, '丰渡', '', '丰渡', 100, 0, 1),
(2583, '8355', '', '8355', 100, 0, 1),
(2584, '拉菲', '', '拉菲', 100, 0, 5),
(2585, 'KAPU', '', 'KAPU', 100, 0, 2),
(2586, 'ladyangel', '', 'ladyangel', 100, 0, 16),
(2587, 'L40060', '', 'L40060', 100, 0, 1),
(2588, '大朵', '', '大朵', 100, 0, 2),
(2589, '精美', '', '精美', 100, 0, 4),
(2590, 'imugirls', '', 'imugirls', 100, 0, 1),
(2591, '32450038', '', '32450038', 100, 0, 1),
(2592, '母贝', '', '母贝', 100, 0, 1),
(2593, '天然', '', '天然', 100, 0, 13),
(2594, 'DA846', '', 'DA846', 100, 0, 1),
(2595, '星星', '', '星星', 100, 0, 1),
(2596, '秋冬款', '', '秋冬款', 100, 0, 2),
(2597, '维维安', '', '维维安', 100, 0, 12),
(2598, '松垮', '', '松垮', 100, 0, 1),
(2599, '彩棉', '', '彩棉', 100, 0, 1),
(2600, '爆裂', '', '爆裂', 100, 0, 1),
(2601, '异形', '', '异形', 100, 0, 1),
(2602, '小丑', '', '小丑', 100, 0, 2),
(2603, 'TX1858', '', 'TX1858', 100, 0, 1),
(2604, 'mimius', '', 'mimius', 100, 0, 8),
(2605, 'com', '', 'com', 100, 0, 1),
(2606, 'KS1177', '', 'KS1177', 100, 0, 1),
(2607, '宁夏', '', '宁夏', 100, 0, 1),
(2608, '乔丢丢', '', '乔丢丢', 100, 0, 2),
(2609, '夏末', '', '夏末', 100, 0, 8),
(2610, 'TS18', '', 'TS18', 100, 0, 1),
(2611, '纳帕', '', '纳帕', 100, 0, 1),
(2612, '出清', '', '出清', 100, 0, 6),
(2613, 'FA0259', '', 'FA0259', 100, 0, 1),
(2614, 'Swise2013', '', 'Swise2013', 100, 0, 1),
(2615, '清单', '', '清单', 100, 0, 1),
(2616, '梦想', '', '梦想', 100, 0, 1),
(2617, '商品', '', '商品', 100, 0, 1),
(2618, '初秋', '', '初秋', 100, 0, 9),
(2619, '风简', '', '风简', 100, 0, 2),
(2620, '甜香', '', '甜香', 100, 0, 1),
(2621, '姗姗', '', '姗姗', 100, 0, 13),
(2622, '小镇', '', '小镇', 100, 0, 14),
(2623, 'Nimes', '', 'Nimes', 100, 0, 1),
(2624, '小怡', '', '小怡', 100, 0, 18),
(2625, '两三', '', '两三', 100, 0, 8),
(2626, '姿态', '', '姿态', 100, 0, 1),
(2627, '花裤', '', '花裤', 100, 0, 1),
(2628, 'mimius2013', '', 'mimius2013', 100, 0, 33),
(2629, 'M2131', '', 'M2131', 100, 0, 1),
(2630, '海蓝色', '', '海蓝色', 100, 0, 1),
(2631, '韩版国', '', '韩版国', 100, 0, 1),
(2632, '环形', '', '环形', 100, 0, 1),
(2633, '标本', '', '标本', 100, 0, 2),
(2634, '植物', '', '植物', 100, 0, 4),
(2635, '11200744', '', '11200744', 100, 0, 1),
(2636, 'Catworld', '', 'Catworld', 100, 0, 20),
(2637, '金葱', '', '金葱', 100, 0, 1),
(2638, '原色', '', '原色', 100, 0, 1),
(2639, '长衫', '', '长衫', 100, 0, 2),
(2640, '行旅', '', '行旅', 100, 0, 1),
(2641, '皮箱', '', '皮箱', 100, 0, 4),
(2642, '新平', '', '新平', 100, 0, 2),
(2643, '打结', '', '打结', 100, 0, 2),
(2644, '开车', '', '开车', 100, 0, 1),
(2645, '满满', '', '满满', 100, 0, 1),
(2646, '11101084', '', '11101084', 100, 0, 1),
(2647, '圆珠', '', '圆珠', 100, 0, 1),
(2648, '女朋友', '', '女朋友', 100, 0, 1),
(2649, '小提琴', '', '小提琴', 100, 0, 1),
(2650, 'KIKOT', '', 'KIKOT', 100, 0, 6),
(2651, '560', '', '560', 100, 0, 1),
(2652, 'M2024', '', 'M2024', 100, 0, 1),
(2653, '风彩', '', '风彩', 100, 0, 1),
(2654, '代表作品', '', '代表作品', 100, 0, 1),
(2655, '极品', '', '极品', 100, 0, 1),
(2656, '高品质', '', '高品质', 100, 0, 1),
(2657, '定型', '', '定型', 100, 0, 15),
(2658, '戴妃', '', '戴妃', 100, 0, 1),
(2659, '繁花', '', '繁花', 100, 0, 2),
(2660, '烂漫', '', '烂漫', 100, 0, 1),
(2661, '艳丽', '', '艳丽', 100, 0, 1),
(2662, 'zd05045', '', 'zd05045', 100, 0, 1),
(2663, '海绵', '', '海绵', 100, 0, 4),
(2664, 'Toucino', '', 'Toucino', 100, 0, 1),
(2665, '眼镜架', '', '眼镜架', 100, 0, 2),
(2666, '近视', '', '近视', 100, 0, 4),
(2667, '眼睛', '', '眼睛', 100, 0, 2),
(2668, '乖巧', '', '乖巧', 100, 0, 1),
(2669, 'A23807', '', 'A23807', 100, 0, 1),
(2670, '贵族', '', '贵族', 100, 0, 2),
(2671, '纯情', '', '纯情', 100, 0, 1),
(2672, '百分', '', '百分', 100, 0, 1),
(2673, 'A23646', '', 'A23646', 100, 0, 1),
(2674, 'eastide', '', 'eastide', 100, 0, 2),
(2675, '包双', '', '包双', 100, 0, 1),
(2676, '耳语', '', '耳语', 100, 0, 1),
(2677, '思念', '', '思念', 100, 0, 1),
(2678, '节日', '', '节日', 100, 0, 1),
(2679, 'AA1334', '', 'AA1334', 100, 0, 1),
(2680, '元宝', '', '元宝', 100, 0, 1),
(2681, 'MAOMAOHOME', '', 'MAOMAOHOME', 100, 0, 4),
(2682, 'candy', '', 'candy', 100, 0, 2),
(2683, '透亮', '', '透亮', 100, 0, 1),
(2684, '斑驳', '', '斑驳', 100, 0, 2),
(2685, 'HAB004', '', 'HAB004', 100, 0, 1),
(2686, '里格', '', '里格', 100, 0, 6),
(2687, 'A23820', '', 'A23820', 100, 0, 1),
(2688, '花草', '', '花草', 100, 0, 1),
(2689, '16003233', '', '16003233', 100, 0, 1),
(2690, '阿尔', '', '阿尔', 100, 0, 1),
(2691, '法意', '', '法意', 100, 0, 1),
(2692, '情调', '', '情调', 100, 0, 2),
(2693, '剪裁', '', '剪裁', 100, 0, 1),
(2694, '超高', '', '超高', 100, 0, 4),
(2695, '网眼', '', '网眼', 100, 0, 2),
(2696, '年代', '', '年代', 100, 0, 1),
(2697, '空】', '', '空】', 100, 0, 1),
(2698, '软陶', '', '软陶', 100, 0, 1),
(2699, '皮夹克', '', '皮夹克', 100, 0, 2),
(2700, '机车', '', '机车', 100, 0, 1),
(2701, 'zd05040', '', 'zd05040', 100, 0, 1),
(2702, 'A23582', '', 'A23582', 100, 0, 1),
(2703, '潮连', '', '潮连', 100, 0, 1),
(2704, '满减', '', '满减', 100, 0, 1),
(2705, '西服', '', '西服', 100, 0, 2),
(2706, 'M2094', '', 'M2094', 100, 0, 1),
(2707, '村井', '', '村井', 100, 0, 2),
(2708, '电脑', '', '电脑', 100, 0, 5),
(2709, '蛇年', '', '蛇年', 100, 0, 3),
(2710, '珐琅', '', '珐琅', 100, 0, 2),
(2711, '蛇头', '', '蛇头', 100, 0, 1),
(2712, '1940', '', '1940', 100, 0, 1),
(2713, '古铜', '', '古铜', 100, 0, 2),
(2714, '车库', '', '车库', 100, 0, 1),
(2715, '蛤蟆', '', '蛤蟆', 100, 0, 1),
(2716, 'Ksubi', '', 'Ksubi', 100, 0, 1),
(2717, '电脑书', '', '电脑书', 100, 0, 2),
(2718, '完美', '', '完美', 100, 0, 3),
(2719, '眼袋', '', '眼袋', 100, 0, 5),
(2720, '自制', '', '自制', 100, 0, 8),
(2721, 'P0645', '', 'P0645', 100, 0, 1),
(2722, '艺术', '', '艺术', 100, 0, 3),
(2723, 'AA1656', '', 'AA1656', 100, 0, 1),
(2724, '锆石', '', '锆石', 100, 0, 6),
(2725, '米仓', '', '米仓', 100, 0, 3),
(2726, '女巫', '', '女巫', 100, 0, 1),
(2727, '五金', '', '五金', 100, 0, 1),
(2728, '个头', '', '个头', 100, 0, 1),
(2729, 'r13B200', '', 'r13B200', 100, 0, 1),
(2730, '足金', '', '足金', 100, 0, 2),
(2731, '转运', '', '转运', 100, 0, 4),
(2732, '无邪', '', '无邪', 100, 0, 1),
(2733, '中秋节', '', '中秋节', 100, 0, 1),
(2734, '黄金', '', '黄金', 100, 0, 3),
(2735, '999', '', '999', 100, 0, 2),
(2736, '心结', '', '心结', 100, 0, 1),
(2737, 'Sakura', '', 'Sakura', 100, 0, 3),
(2738, '皮绳', '', '皮绳', 100, 0, 5),
(2739, '边压皱', '', '边压皱', 100, 0, 1),
(2740, 'YL9358', '', 'YL9358', 100, 0, 1),
(2741, '大大', '', '大大', 100, 0, 1),
(2742, '小脚', '', '小脚', 100, 0, 13),
(2743, 'JY2105', '', 'JY2105', 100, 0, 1),
(2744, '韩都衣', '', '韩都衣', 100, 0, 1),
(2745, '回力', '', '回力', 100, 0, 2),
(2746, '炫彩', '', '炫彩', 100, 0, 1),
(2747, '男鞋', '', '男鞋', 100, 0, 29),
(2748, 'S8865', '', 'S8865', 100, 0, 1),
(2749, '安格拉', '', '安格拉', 100, 0, 10),
(2750, '1998', '', '1998', 100, 0, 1),
(2751, '11200750', '', '11200750', 100, 0, 1),
(2752, '人棉', '', '人棉', 100, 0, 2),
(2753, '空气', '', '空气', 100, 0, 9),
(2754, '塑身', '', '塑身', 100, 0, 1),
(2755, '锥形', '', '锥形', 100, 0, 1),
(2756, 'ZZlady', '', 'ZZlady', 100, 0, 1),
(2757, '运动鞋', '', '运动鞋', 100, 0, 2),
(2758, '同步', '', '同步', 100, 0, 4),
(2759, '利款低', '', '利款低', 100, 0, 1),
(2760, 'XIAO', '', 'XIAO', 100, 0, 1),
(2761, 'P0641', '', 'P0641', 100, 0, 1),
(2762, '天晴', '', '天晴', 100, 0, 12),
(2763, '剪刀', '', '剪刀', 100, 0, 1),
(2764, 'HP5034', '', 'HP5034', 100, 0, 1),
(2765, '卡其色', '', '卡其色', 100, 0, 1),
(2766, '双排', '', '双排', 100, 0, 2),
(2767, '出口', '', '出口', 100, 0, 4),
(2768, '蜈蚣', '', '蜈蚣', 100, 0, 1),
(2769, '旅游包', '', '旅游包', 100, 0, 2),
(2770, '木村', '', '木村', 100, 0, 1),
(2771, '情侣装', '', '情侣装', 100, 0, 4),
(2772, '弯弯', '', '弯弯', 100, 0, 4),
(2773, '小姐', '', '小姐', 100, 0, 2),
(2774, '合作', '', '合作', 100, 0, 1),
(2775, '万向轮', '', '万向轮', 100, 0, 13),
(2776, '行李箱', '', '行李箱', 100, 0, 11),
(2777, 'travels', '', 'travels', 100, 0, 1),
(2778, 'Music', '', 'Music', 100, 0, 1),
(2779, '2428', '', '2428', 100, 0, 1),
(2780, '色系', '', '色系', 100, 0, 4),
(2781, '2way', '', '2way', 100, 0, 2),
(2782, '腰线', '', '腰线', 100, 0, 1),
(2783, 'T1833', '', 'T1833', 100, 0, 1),
(2784, 'DT1029', '', 'DT1029', 100, 0, 1),
(2785, '歌路', '', '歌路', 100, 0, 1),
(2786, '胸罩', '', '胸罩', 100, 0, 6),
(2787, '专利', '', '专利', 100, 0, 2),
(2788, '小马', '', '小马', 100, 0, 3),
(2789, 'HOWRU', '', 'HOWRU', 100, 0, 8),
(2790, '狐狸', '', '狐狸', 100, 0, 1),
(2791, 'T1671A', '', 'T1671A', 100, 0, 1),
(2792, '球衫', '', '球衫', 100, 0, 2),
(2793, '人手', '', '人手', 100, 0, 1),
(2794, '教师节', '', '教师节', 100, 0, 2),
(2795, 'FIINAL', '', 'FIINAL', 100, 0, 9),
(2796, 'F349', '', 'F349', 100, 0, 1),
(2797, '钢圈', '', '钢圈', 100, 0, 2),
(2798, '公爵', '', '公爵', 100, 0, 1),
(2799, '期内', '', '期内', 100, 0, 1),
(2800, '夫人', '', '夫人', 100, 0, 1),
(2801, '1303012', '', '1303012', 100, 0, 1),
(2802, '宝贝', '', '宝贝', 100, 0, 3),
(2803, '毛呢', '', '毛呢', 100, 0, 3),
(2804, 'CUTIEPIGIE', '', 'CUTIEPIGIE', 100, 0, 5),
(2805, 'ZF153', '', 'ZF153', 100, 0, 1),
(2806, '学生包', '', '学生包', 100, 0, 1),
(2807, '熊猫', '', '熊猫', 100, 0, 2),
(2808, '米奴仙', '', '米奴仙', 100, 0, 1),
(2809, '单边', '', '单边', 100, 0, 1),
(2810, 'AA2407', '', 'AA2407', 100, 0, 1),
(2811, 'XS', '', 'XS', 100, 0, 6),
(2812, '下身', '', '下身', 100, 0, 1),
(2813, '木耳', '', '木耳', 100, 0, 9),
(2814, 'M1287', '', 'M1287', 100, 0, 1),
(2815, '方根', '', '方根', 100, 0, 1),
(2816, '750g', '', '750g', 100, 0, 1),
(2817, 'rbeauty2013', '', 'rbeauty2013', 100, 0, 1),
(2818, 'r13B6552', '', 'r13B6552', 100, 0, 1),
(2819, '迪贝尔', '', '迪贝尔', 100, 0, 1),
(2820, 'W0569', '', 'W0569', 100, 0, 1),
(2821, '丹迪', '', '丹迪', 100, 0, 1),
(2822, '猫眼', '', '猫眼', 100, 0, 2),
(2823, '掌柜', '', '掌柜', 100, 0, 1),
(2824, '层叠', '', '层叠', 100, 0, 3),
(2825, 'M1719', '', 'M1719', 100, 0, 1),
(2826, '硬壳', '', '硬壳', 100, 0, 1),
(2827, '围脖', '', '围脖', 100, 0, 1),
(2828, 'omlesa', '', 'omlesa', 100, 0, 1),
(2829, '品特', '', '品特', 100, 0, 1),
(2830, '边侧夹', '', '边侧夹', 100, 0, 1),
(2831, '椭圆', '', '椭圆', 100, 0, 1),
(2832, '马裤', '', '马裤', 100, 0, 0),
(2833, '新包', '', '新包', 100, 0, 1),
(2834, 'MIKKO2013', '', 'MIKKO2013', 100, 0, 5),
(2835, 'AD1843', '', 'AD1843', 100, 0, 1),
(2836, '好评', '', '好评', 100, 0, 2),
(2837, '重磅', '', '重磅', 100, 0, 1),
(2838, '端庄', '', '端庄', 100, 0, 1),
(2839, '原版', '', '原版', 100, 0, 1),
(2840, '2007', '', '2007', 100, 0, 1),
(2841, '背后', '', '背后', 100, 0, 5),
(2842, 'L30174', '', 'L30174', 100, 0, 1),
(2843, '婷美', '', '婷美', 100, 0, 1),
(2844, '中厚', '', '中厚', 100, 0, 1),
(2845, '荷塘', '', '荷塘', 100, 0, 1),
(2846, '柔美', '', '柔美', 100, 0, 1),
(2847, '月色', '', '月色', 100, 0, 1),
(2848, '金色', '', '金色', 100, 0, 12),
(2849, 'KZ621', '', 'KZ621', 100, 0, 1),
(2850, '修脚', '', '修脚', 100, 0, 1),
(2851, '兰奇', '', '兰奇', 100, 0, 1),
(2852, '登机', '', '登机', 100, 0, 5),
(2853, '切面', '', '切面', 100, 0, 1),
(2854, '满天星', '', '满天星', 100, 0, 1),
(2855, '刻字', '', '刻字', 100, 0, 4),
(2856, '男式', '', '男式', 100, 0, 1),
(2857, '本命年', '', '本命年', 100, 0, 4),
(2858, '婚纱礼服', '', '婚纱礼服', 100, 0, 7),
(2859, '豪华', '', '豪华', 100, 0, 1),
(2860, '满庭芳', '', '满庭芳', 100, 0, 1),
(2861, 'S619', '', 'S619', 100, 0, 1),
(2862, '多环', '', '多环', 100, 0, 1),
(2863, 'BRIOSO2013', '', 'BRIOSO2013', 100, 0, 1),
(2864, '气场', '', '气场', 100, 0, 3),
(2865, '菁菁', '', '菁菁', 100, 0, 1),
(2866, '本原', '', '本原', 100, 0, 3),
(2867, 'M1345', '', 'M1345', 100, 0, 1),
(2868, '波士顿', '', '波士顿', 100, 0, 3),
(2869, '图腾', '', '图腾', 100, 0, 2),
(2870, '调节', '', '调节', 100, 0, 2),
(2871, 'A23728', '', 'A23728', 100, 0, 1),
(2872, 'M1808', '', 'M1808', 100, 0, 1),
(2873, '62130005', '', '62130005', 100, 0, 1),
(2874, '11200680', '', '11200680', 100, 0, 1),
(2875, '13097', '', '13097', 100, 0, 1),
(2876, 'M1950', '', 'M1950', 100, 0, 1),
(2877, '摆式', '', '摆式', 100, 0, 1),
(2878, 'MS1851', '', 'MS1851', 100, 0, 1),
(2879, '罗纹', '', '罗纹', 100, 0, 1),
(2880, '15002564', '', '15002564', 100, 0, 1),
(2881, '裤腿', '', '裤腿', 100, 0, 1),
(2882, 'zd04154', '', 'zd04154', 100, 0, 1),
(2883, 'AA1266', '', 'AA1266', 100, 0, 1),
(2884, 'CA191', '', 'CA191', 100, 0, 1),
(2885, 'HoneyWeb', '', 'HoneyWeb', 100, 0, 2),
(2886, '链式', '', '链式', 100, 0, 1),
(2887, 'HDB001', '', 'HDB001', 100, 0, 1),
(2888, '包亮版', '', '包亮版', 100, 0, 1),
(2889, '包编格', '', '包编格', 100, 0, 1),
(2890, '505g', '', '505g', 100, 0, 1),
(2891, '行者', '', '行者', 100, 0, 2),
(2892, '6095', '', '6095', 100, 0, 1),
(2893, 'abs', '', 'abs', 100, 0, 3),
(2894, '18', '', '18', 100, 0, 2),
(2895, 'KZ00505', '', 'KZ00505', 100, 0, 1),
(2896, 'KZ576', '', 'KZ576', 100, 0, 1),
(2897, '女王', '', '女王', 100, 0, 3),
(2898, '元素', '', '元素', 100, 0, 10),
(2899, '采用', '', '采用', 100, 0, 2),
(2900, '胡子', '', '胡子', 100, 0, 2),
(2901, '西湖', '', '西湖', 100, 0, 3),
(2902, '村上', '', '村上', 100, 0, 3),
(2903, 'comrain', '', 'comrain', 100, 0, 1),
(2904, '脱卸', '', '脱卸', 100, 0, 1),
(2905, '帅气', '', '帅气', 100, 0, 8),
(2906, '267', '', '267', 100, 0, 1),
(2907, '艾路丝', '', '艾路丝', 100, 0, 1),
(2908, 'M1962', '', 'M1962', 100, 0, 1),
(2909, '香阁', '', '香阁', 100, 0, 1),
(2910, '光面', '', '光面', 100, 0, 1),
(2911, '隐形', '', '隐形', 100, 0, 2),
(2912, '板材', '', '板材', 100, 0, 1),
(2913, '绚烂', '', '绚烂', 100, 0, 1),
(2914, '陶素器', '', '陶素器', 100, 0, 1),
(2915, '410', '', '410', 100, 0, 1),
(2916, '行李', '', '行李', 100, 0, 5),
(2917, 'INANNA', '', 'INANNA', 100, 0, 1),
(2918, 'EUPING', '', 'EUPING', 100, 0, 2),
(2919, 'MT', '', 'MT', 100, 0, 1),
(2920, '项圈', '', '项圈', 100, 0, 1),
(2921, '宝藏', '', '宝藏', 100, 0, 2),
(2922, '百年', '', '百年', 100, 0, 1),
(2923, 'F405', '', 'F405', 100, 0, 1),
(2924, '纺纱', '', '纺纱', 100, 0, 1),
(2925, '人头', '', '人头', 100, 0, 1),
(2926, '11403795', '', '11403795', 100, 0, 1),
(2927, '桑蚕丝', '', '桑蚕丝', 100, 0, 4),
(2928, 'WT842', '', 'WT842', 100, 0, 1),
(2929, 'MP0194', '', 'MP0194', 100, 0, 1),
(2930, '连帽薄', '', '连帽薄', 100, 0, 1),
(2931, 'M1197mimius', '', 'M1197mimius', 100, 0, 1),
(2932, '小狗', '', '小狗', 100, 0, 1),
(2933, 'AJDJ', '', 'AJDJ', 100, 0, 1),
(2934, '电脑包', '', '电脑包', 100, 0, 4),
(2935, '银美', '', '银美', 100, 0, 1),
(2936, '预订', '', '预订', 100, 0, 1),
(2937, 'RICHBON', '', 'RICHBON', 100, 0, 2),
(2938, '官网', '', '官网', 100, 0, 2),
(2939, '俏皮', '', '俏皮', 100, 0, 5),
(2940, 'swise', '', 'swise', 100, 0, 1),
(2941, '粉嫩', '', '粉嫩', 100, 0, 5),
(2942, '芭蕾', '', '芭蕾', 100, 0, 2),
(2943, '舞者', '', '舞者', 100, 0, 1),
(2944, 'D855', '', 'D855', 100, 0, 1),
(2945, '旧时', '', '旧时', 100, 0, 1),
(2946, '美人', '', '美人', 100, 0, 2),
(2947, '山月', '', '山月', 100, 0, 1),
(2948, '叙旧', '', '叙旧', 100, 0, 3),
(2949, 'MC1222', '', 'MC1222', 100, 0, 1),
(2950, 'MaxAC', '', 'MaxAC', 100, 0, 1),
(2951, '金蛇', '', '金蛇', 100, 0, 1),
(2952, '短袜', '', '短袜', 100, 0, 1),
(2953, '丝袜', '', '丝袜', 100, 0, 2),
(2954, '边日系', '', '边日系', 100, 0, 1),
(2955, 'L40134', '', 'L40134', 100, 0, 1),
(2956, 'r13B6010', '', 'r13B6010', 100, 0, 1),
(2957, 'beauty', '', 'beauty', 100, 0, 4),
(2958, 'zd05174', '', 'zd05174', 100, 0, 1),
(2959, 'C5333', '', 'C5333', 100, 0, 1),
(2960, '贴兜', '', '贴兜', 100, 0, 1),
(2961, '花呢', '', '花呢', 100, 0, 2),
(2962, '时代', '', '时代', 100, 0, 1),
(2963, '15002585', '', '15002585', 100, 0, 1),
(2964, '新绿', '', '新绿', 100, 0, 1),
(2965, '木木', '', '木木', 100, 0, 2),
(2966, 'MumuHome', '', 'MumuHome', 100, 0, 1),
(2967, '11700168', '', '11700168', 100, 0, 1),
(2968, '韩版篓', '', '韩版篓', 100, 0, 1),
(2969, '梨子', '', '梨子', 100, 0, 1),
(2970, 'A23651', '', 'A23651', 100, 0, 1),
(2971, '撒哈拉', '', '撒哈拉', 100, 0, 4),
(2972, 'TOPSHOP', '', 'TOPSHOP', 100, 0, 7),
(2973, '405g', '', '405g', 100, 0, 1),
(2974, '网格', '', '网格', 100, 0, 1),
(2975, '姐妹', '', '姐妹', 100, 0, 1),
(2976, '通用', '', '通用', 100, 0, 2),
(2977, '9185', '', '9185', 100, 0, 1),
(2978, 'Tata', '', 'Tata', 100, 0, 1),
(2979, 'AQ', '', 'AQ', 100, 0, 1),
(2980, '彩金', '', '彩金', 100, 0, 2),
(2981, '梅地亚', '', '梅地亚', 100, 0, 1),
(2982, '圆环', '', '圆环', 100, 0, 2),
(2983, 'M209204', '', 'M209204', 100, 0, 1),
(2984, '亚克力', '', '亚克力', 100, 0, 1),
(2985, '19.9', '', '19.9', 100, 0, 2),
(2986, '465', '', '465', 100, 0, 1),
(2987, '搭配', '', '搭配', 100, 0, 1),
(2988, '新年', '', '新年', 100, 0, 1),
(2989, '泰坦尼克号', '', '泰坦尼克号', 100, 0, 1),
(2990, '之心', '', '之心', 100, 0, 3),
(2991, '设计师', '', '设计师', 100, 0, 8),
(2992, '米亚坡', '', '米亚坡', 100, 0, 1),
(2993, '生皮', '', '生皮', 100, 0, 1),
(2994, 'SY5795', '', 'SY5795', 100, 0, 1),
(2995, '麦昆', '', '麦昆', 100, 0, 1),
(2996, '亚历山大', '', '亚历山大', 100, 0, 1),
(2997, '俄罗斯', '', '俄罗斯', 100, 0, 1),
(2998, 'Alexander', '', 'Alexander', 100, 0, 1),
(2999, 'McQueen', '', 'McQueen', 100, 0, 1),
(3000, '29.9', '', '29.9', 100, 0, 1),
(3001, '包邮潮', '', '包邮潮', 100, 0, 2),
(3002, '1409', '', '1409', 100, 0, 1),
(3003, '好雨', '', '好雨', 100, 0, 1),
(3004, '高筒', '', '高筒', 100, 0, 2),
(3005, '气机', '', '气机', 100, 0, 1),
(3006, '时节', '', '时节', 100, 0, 1),
(3007, '泼墨', '', '泼墨', 100, 0, 1),
(3008, '甜蜜', '', '甜蜜', 100, 0, 2),
(3009, '加宽', '', '加宽', 100, 0, 1),
(3010, '高腰桔', '', '高腰桔', 100, 0, 1),
(3011, 'WEIS', '', 'WEIS', 100, 0, 1),
(3012, 'GJ1300', '', 'GJ1300', 100, 0, 1),
(3013, '高腰波', '', '高腰波', 100, 0, 1),
(3014, '华奢', '', '华奢', 100, 0, 1),
(3015, '32450019', '', '32450019', 100, 0, 1),
(3016, '年华', '', '年华', 100, 0, 1),
(3017, '拖地', '', '拖地', 100, 0, 12),
(3018, '雅致', '', '雅致', 100, 0, 2),
(3019, '新田园', '', '新田园', 100, 0, 1),
(3020, '开运', '', '开运', 100, 0, 1),
(3021, '吉祥', '', '吉祥', 100, 0, 1),
(3022, 'B035', '', 'B035', 100, 0, 1),
(3023, '拉杆', '', '拉杆', 100, 0, 3),
(3024, 'HP5027', '', 'HP5027', 100, 0, 1),
(3025, '1520', '', '1520', 100, 0, 1),
(3026, '435213102', '', '435213102', 100, 0, 1),
(3027, '韩伊儿', '', '韩伊儿', 100, 0, 1),
(3028, '11303167', '', '11303167', 100, 0, 1),
(3029, 'HP5012', '', 'HP5012', 100, 0, 1),
(3030, '稻草人', '', '稻草人', 100, 0, 2),
(3031, '奢侈', '', '奢侈', 100, 0, 1),
(3032, 'T1825', '', 'T1825', 100, 0, 1),
(3033, '手机', '', '手机', 100, 0, 3),
(3034, '爪牙', '', '爪牙', 100, 0, 5),
(3035, '超薄', '', '超薄', 100, 0, 9),
(3036, '夏小', '', '夏小', 100, 0, 1),
(3037, '高腰大', '', '高腰大', 100, 0, 1),
(3038, '光影', '', '光影', 100, 0, 1),
(3039, '圈圈', '', '圈圈', 100, 0, 1),
(3040, '螺旋', '', '螺旋', 100, 0, 1),
(3041, '小口袋', '', '小口袋', 100, 0, 1),
(3042, '16003122', '', '16003122', 100, 0, 1),
(3043, 'AA2029', '', 'AA2029', 100, 0, 1),
(3044, '丝巾扣', '', '丝巾扣', 100, 0, 1),
(3045, '天鹅', '', '天鹅', 100, 0, 2),
(3046, '别针', '', '别针', 100, 0, 1),
(3047, '国货', '', '国货', 100, 0, 2),
(3048, '155', '', '155', 100, 0, 1),
(3049, '波士', '', '波士', 100, 0, 1),
(3050, 'BOSCAT', '', 'BOSCAT', 100, 0, 1),
(3051, '大胡子', '', '大胡子', 100, 0, 1),
(3052, '雅丽', '', '雅丽', 100, 0, 1),
(3053, '功能', '', '功能', 100, 0, 2),
(3054, '1947', '', '1947', 100, 0, 1),
(3055, '亚大', '', '亚大', 100, 0, 2),
(3056, '木纹', '', '木纹', 100, 0, 1),
(3057, '抓绒', '', '抓绒', 100, 0, 1),
(3058, '韩版拼', '', '韩版拼', 100, 0, 2),
(3059, '韩版搭', '', '韩版搭', 100, 0, 1),
(3060, '绸缎', '', '绸缎', 100, 0, 1),
(3061, 'QZL616', '', 'QZL616', 100, 0, 1),
(3062, 'DA1008', '', 'DA1008', 100, 0, 1),
(3063, '保罗衫', '', '保罗衫', 100, 0, 1),
(3064, '全羊', '', '全羊', 100, 0, 1),
(3065, '米兰', '', '米兰', 100, 0, 1),
(3066, '皮皮', '', '皮皮', 100, 0, 1),
(3067, '顶级', '', '顶级', 100, 0, 3),
(3068, 'MISSNING2013', '', 'MISSNING2013', 100, 0, 1),
(3069, '巴格达', '', '巴格达', 100, 0, 1),
(3070, '水绿', '', '水绿', 100, 0, 1),
(3071, '雅痞', '', '雅痞', 100, 0, 1),
(3072, '妖精', '', '妖精', 100, 0, 4),
(3073, '海盗船', '', '海盗船', 100, 0, 1),
(3074, '上手', '', '上手', 100, 0, 1),
(3075, '极好', '', '极好', 100, 0, 1),
(3076, '0518PG0034', '', '0518PG0034', 100, 0, 1),
(3077, '效果', '', '效果', 100, 0, 1),
(3078, '护士', '', '护士', 100, 0, 1),
(3079, 'island', '', 'island', 100, 0, 3),
(3080, 'River', '', 'River', 100, 0, 2),
(3081, 'Swise2012', '', 'Swise2012', 100, 0, 1),
(3082, '手串', '', '手串', 100, 0, 2),
(3083, '小女孩', '', '小女孩', 100, 0, 1),
(3084, '韩夏', '', '韩夏', 100, 0, 1),
(3085, '包裙', '', '包裙', 100, 0, 2),
(3086, '半圆', '', '半圆', 100, 0, 1),
(3087, '褪色', '', '褪色', 100, 0, 3),
(3088, '别致', '', '别致', 100, 0, 2),
(3089, '夏时', '', '夏时', 100, 0, 1),
(3090, 'MJ1129', '', 'MJ1129', 100, 0, 1),
(3091, '牛仔服', '', '牛仔服', 100, 0, 1),
(3092, 'PinClove', '', 'PinClove', 100, 0, 2),
(3093, '80168', '', '80168', 100, 0, 1),
(3094, '瓦尼', '', '瓦尼', 100, 0, 1),
(3095, '掉色', '', '掉色', 100, 0, 2),
(3096, '真金', '', '真金', 100, 0, 3),
(3097, '镭射', '', '镭射', 100, 0, 1),
(3098, '小球', '', '小球', 100, 0, 2),
(3099, '满钻', '', '满钻', 100, 0, 1),
(3100, 'BA0690', '', 'BA0690', 100, 0, 1),
(3101, 'M1258', '', 'M1258', 100, 0, 1),
(3102, '毛绒', '', '毛绒', 100, 0, 1),
(3103, '地板', '', '地板', 100, 0, 1),
(3104, '超短裙', '', '超短裙', 100, 0, 1),
(3105, 'r13B5017', '', 'r13B5017', 100, 0, 1),
(3106, '洛世奇', '', '洛世奇', 100, 0, 1),
(3107, '哈伦', '', '哈伦', 100, 0, 1),
(3108, 'ZD256', '', 'ZD256', 100, 0, 1),
(3109, '化妆箱', '', '化妆箱', 100, 0, 2),
(3110, '白塔', '', '白塔', 100, 0, 1),
(3111, '手提箱', '', '手提箱', 100, 0, 2),
(3112, '小桃', '', '小桃', 100, 0, 1),
(3113, '小卡', '', '小卡', 100, 0, 1),
(3114, '价格', '', '价格', 100, 0, 2),
(3115, 'AD1314', '', 'AD1314', 100, 0, 1),
(3116, 'AA1401', '', 'AA1401', 100, 0, 1),
(3117, 'M1760', '', 'M1760', 100, 0, 1),
(3118, '台湾', '', '台湾', 100, 0, 1),
(3119, 'AA2152', '', 'AA2152', 100, 0, 1),
(3120, '粉白', '', '粉白', 100, 0, 1),
(3121, '相间', '', '相间', 100, 0, 1),
(3122, '毛毡', '', '毛毡', 100, 0, 2),
(3123, '店主', '', '店主', 100, 0, 4),
(3124, 'habana', '', 'habana', 100, 0, 3),
(3125, 'girl', '', 'girl', 100, 0, 5),
(3126, 'La', '', 'La', 100, 0, 2),
(3127, '白鸟', '', '白鸟', 100, 0, 1),
(3128, '苜蓿', '', '苜蓿', 100, 0, 1),
(3129, '浪尖', '', '浪尖', 100, 0, 1),
(3130, '白花', '', '白花', 100, 0, 1),
(3131, '插画', '', '插画', 100, 0, 2),
(3132, '11101068', '', '11101068', 100, 0, 1),
(3133, '麻质', '', '麻质', 100, 0, 2),
(3134, '丸子', '', '丸子', 100, 0, 2),
(3135, '糯米', '', '糯米', 100, 0, 2),
(3136, '率性', '', '率性', 100, 0, 1),
(3137, 'AW1095', '', 'AW1095', 100, 0, 1),
(3138, 'LM8303', '', 'LM8303', 100, 0, 1),
(3139, 'r13B2032', '', 'r13B2032', 100, 0, 1),
(3140, '子鱼', '', '子鱼', 100, 0, 1),
(3141, '马卡龙', '', '马卡龙', 100, 0, 3),
(3142, '米奇', '', '米奇', 100, 0, 1),
(3143, '迪士尼', '', '迪士尼', 100, 0, 6),
(3144, '2190', '', '2190', 100, 0, 1),
(3145, '02', '', '02', 100, 0, 1),
(3146, 'AF', '', 'AF', 100, 0, 1),
(3147, 'AF728', '', 'AF728', 100, 0, 1),
(3148, '木内', '', '木内', 100, 0, 1),
(3149, '休闲运动', '', '休闲运动', 100, 0, 2),
(3150, '小象', '', '小象', 100, 0, 3),
(3151, '光板', '', '光板', 100, 0, 1),
(3152, '至尊', '', '至尊', 100, 0, 1),
(3153, '18K', '', '18K', 100, 0, 5),
(3154, '浅蓝色', '', '浅蓝色', 100, 0, 2),
(3155, '14000766', '', '14000766', 100, 0, 1),
(3156, '24', '', '24', 100, 0, 3),
(3157, '20', '', '20', 100, 0, 3),
(3158, '迪斯尼', '', '迪斯尼', 100, 0, 1),
(3159, '水袋', '', '水袋', 100, 0, 2),
(3160, '丽影', '', '丽影', 100, 0, 11),
(3161, '无敌', '', '无敌', 100, 0, 2),
(3162, 'UVB', '', 'UVB', 100, 0, 1),
(3163, 'UVA', '', 'UVA', 100, 0, 1),
(3164, '色长', '', '色长', 100, 0, 3),
(3165, 'QCL753', '', 'QCL753', 100, 0, 1),
(3166, '波普', '', '波普', 100, 0, 2),
(3167, '多宝', '', '多宝', 100, 0, 2),
(3168, '蜜蜡', '', '蜜蜡', 100, 0, 2),
(3169, '中东', '', '中东', 100, 0, 1),
(3170, '钻戒', '', '钻戒', 100, 0, 8),
(3171, '惊艳', '', '惊艳', 100, 0, 1),
(3172, '离题', '', '离题', 100, 0, 1),
(3173, '卡西欧', '', '卡西欧', 100, 0, 1),
(3174, '电池', '', '电池', 100, 0, 1),
(3175, '清晰', '', '清晰', 100, 0, 1),
(3176, 'casio', '', 'casio', 100, 0, 1),
(3177, '126', '', '126', 100, 0, 1),
(3178, '砗磲', '', '砗磲', 100, 0, 1),
(3179, '天然水晶', '', '天然水晶', 100, 0, 1),
(3180, '葫芦', '', '葫芦', 100, 0, 2),
(3181, '银圈', '', '银圈', 100, 0, 1),
(3182, '电脑袋', '', '电脑袋', 100, 0, 1),
(3183, 'SUPER', '', 'SUPER', 100, 0, 5),
(3184, 'LOVER', '', 'LOVER', 100, 0, 4),
(3185, 'SY149', '', 'SY149', 100, 0, 1),
(3186, '麻裤。', '', '麻裤。', 100, 0, 1),
(3187, '鸵鸟', '', '鸵鸟', 100, 0, 2),
(3188, '维多利亚', '', '维多利亚', 100, 0, 1),
(3189, 'M1407', '', 'M1407', 100, 0, 1),
(3190, '前襟', '', '前襟', 100, 0, 1),
(3191, '尖角', '', '尖角', 100, 0, 1),
(3192, 'MemoryHouse', '', 'MemoryHouse', 100, 0, 1),
(3193, 'ZH071', '', 'ZH071', 100, 0, 1),
(3194, '11303084', '', '11303084', 100, 0, 1),
(3195, 'dress', '', 'dress', 100, 0, 2),
(3196, 'Black', '', 'Black', 100, 0, 1),
(3197, 'AA1813', '', 'AA1813', 100, 0, 1),
(3198, 'test', '', 'test', 100, 0, 0),
(3199, '偏光镜', '', '偏光镜', 100, 0, 1),
(3200, '006', '', '006', 100, 0, 1),
(3201, 'LJ', '', 'LJ', 100, 0, 1),
(3202, 'Baboon', '', 'Baboon', 100, 0, 1),
(3203, 'M2022', '', 'M2022', 100, 0, 1),
(3204, '暖房', '', '暖房', 100, 0, 1),
(3205, '旺夫', '', '旺夫', 100, 0, 1),
(3206, '桃花', '', '桃花', 100, 0, 2),
(3207, '小尾', '', '小尾', 100, 0, 1),
(3208, '表白', '', '表白', 100, 0, 2),
(3209, '古百搭', '', '古百搭', 100, 0, 1),
(3210, '背面', '', '背面', 100, 0, 1),
(3211, '太阳帽', '', '太阳帽', 100, 0, 3),
(3212, 'M1648', '', 'M1648', 100, 0, 1),
(3213, '红唇', '', '红唇', 100, 0, 1),
(3214, '嘴巴', '', '嘴巴', 100, 0, 1),
(3215, '腰围', '', '腰围', 100, 0, 1),
(3216, 'BA0575', '', 'BA0575', 100, 0, 1),
(3217, 'puff', '', 'puff', 100, 0, 1),
(3218, '纱巾', '', '纱巾', 100, 0, 1),
(3219, '夏阳', '', '夏阳', 100, 0, 1),
(3220, '透露', '', '透露', 100, 0, 1),
(3221, '石绿', '', '石绿', 100, 0, 1),
(3222, '深海', '', '深海', 100, 0, 1),
(3223, '拇指', '', '拇指', 100, 0, 1),
(3224, '带子', '', '带子', 100, 0, 1),
(3225, '容量', '', '容量', 100, 0, 2),
(3226, '一夏', '', '一夏', 100, 0, 1),
(3227, '十月', '', '十月', 100, 0, 1),
(3228, 'L10199', '', 'L10199', 100, 0, 1),
(3229, '小妞', '', '小妞', 100, 0, 1),
(3230, '谎言', '', '谎言', 100, 0, 1),
(3231, '情缘', '', '情缘', 100, 0, 1),
(3232, '袖口', '', '袖口', 100, 0, 1),
(3233, '初恋', '', '初恋', 100, 0, 1),
(3234, 'SY5772', '', 'SY5772', 100, 0, 1),
(3235, '沙绿', '', '沙绿', 100, 0, 1),
(3236, '香芋', '', '香芋', 100, 0, 2),
(3237, 'AD1839', '', 'AD1839', 100, 0, 1),
(3238, 'MIKKO', '', 'MIKKO', 100, 0, 4),
(3239, '足银', '', '足银', 100, 0, 1),
(3240, '镯子', '', '镯子', 100, 0, 2),
(3241, '龙凤', '', '龙凤', 100, 0, 1),
(3242, '宝诚', '', '宝诚', 100, 0, 1),
(3243, '月亮', '', '月亮', 100, 0, 1),
(3244, '207', '', '207', 100, 0, 1),
(3245, 'L30162', '', 'L30162', 100, 0, 1),
(3246, '骑士', '', '骑士', 100, 0, 1),
(3247, '15002570', '', '15002570', 100, 0, 1),
(3248, '185', '', '185', 100, 0, 1),
(3249, '皮包', '', '皮包', 100, 0, 2),
(3250, '台工', '', '台工', 100, 0, 1),
(3251, 'stylenanda', '', 'stylenanda', 100, 0, 1),
(3252, 'makilo', '', 'makilo', 100, 0, 1),
(3253, '大帝', '', '大帝', 100, 0, 1),
(3254, '河马', '', '河马', 100, 0, 1),
(3255, '童趣', '', '童趣', 100, 0, 1),
(3256, '嘻哈', '', '嘻哈', 100, 0, 5),
(3257, 'YH1373', '', 'YH1373', 100, 0, 1),
(3258, '卓欧', '', '卓欧', 100, 0, 1),
(3259, '881680', '', '881680', 100, 0, 1),
(3260, 'M1733', '', 'M1733', 100, 0, 1),
(3261, '黑底', '', '黑底', 100, 0, 1),
(3262, 'SY5110', '', 'SY5110', 100, 0, 1),
(3263, '11101094', '', '11101094', 100, 0, 1),
(3264, '小高', '', '小高', 100, 0, 1),
(3265, '点缀', '', '点缀', 100, 0, 2),
(3266, '分享', '', '分享', 100, 0, 2),
(3267, 'A23799', '', 'A23799', 100, 0, 1),
(3268, '贝因', '', '贝因', 100, 0, 1),
(3269, '错过', '', '错过', 100, 0, 1),
(3270, '不可', '', '不可', 100, 0, 1),
(3271, 'QCL719', '', 'QCL719', 100, 0, 1),
(3272, '红珊瑚', '', '红珊瑚', 100, 0, 1),
(3273, '黛眉', '', '黛眉', 100, 0, 1),
(3274, '绿松石', '', '绿松石', 100, 0, 2),
(3275, '216', '', '216', 100, 0, 1),
(3276, '对夹', '', '对夹', 100, 0, 1),
(3277, '皮质', '', '皮质', 100, 0, 1),
(3278, '弹簧', '', '弹簧', 100, 0, 2),
(3279, '银首饰', '', '银首饰', 100, 0, 1),
(3280, '相随', '', '相随', 100, 0, 1),
(3281, '84104', '', '84104', 100, 0, 1),
(3282, '白破洞', '', '白破洞', 100, 0, 1),
(3283, 'SUKIIRED', '', 'SUKIIRED', 100, 0, 1),
(3284, '0071', '', '0071', 100, 0, 1),
(3285, 'ST', '', 'ST', 100, 0, 1),
(3286, '吸盘', '', '吸盘', 100, 0, 0),
(3287, '赫本', '', '赫本', 100, 0, 1),
(3288, '大波', '', '大波', 100, 0, 3),
(3289, '质地', '', '质地', 100, 0, 1),
(3290, 'ZD276', '', 'ZD276', 100, 0, 1),
(3291, 'top', '', 'top', 100, 0, 1),
(3292, '独角兽', '', '独角兽', 100, 0, 2),
(3293, 'STRIPPER', '', 'STRIPPER', 100, 0, 1),
(3294, '1740', '', '1740', 100, 0, 1),
(3295, 'AMO', '', 'AMO', 100, 0, 1),
(3296, 'zd03088', '', 'zd03088', 100, 0, 1),
(3297, '花靥的', '', '花靥的', 100, 0, 1),
(3298, '藏青', '', '藏青', 100, 0, 1),
(3299, 'zd04178', '', 'zd04178', 100, 0, 1),
(3300, '包臀裙', '', '包臀裙', 100, 0, 1),
(3301, 'M2060', '', 'M2060', 100, 0, 1),
(3302, '9602', '', '9602', 100, 0, 1),
(3303, 'M1980mimius2013', '', 'M1980mimius2013', 100, 0, 1),
(3304, '钱币', '', '钱币', 100, 0, 1),
(3305, '各国', '', '各国', 100, 0, 1),
(3306, 'FBI', '', 'FBI', 100, 0, 1),
(3307, '包邮艾', '', '包邮艾', 100, 0, 1),
(3308, '2111', '', '2111', 100, 0, 1),
(3309, 'SHOP', '', 'SHOP', 100, 0, 6),
(3310, '米字', '', '米字', 100, 0, 1),
(3311, '尚格', '', '尚格', 100, 0, 1),
(3312, '点中', '', '点中', 100, 0, 1),
(3313, '122', '', '122', 100, 0, 1),
(3314, '片式', '', '片式', 100, 0, 1),
(3315, 'Cityhoney', '', 'Cityhoney', 100, 0, 2),
(3316, 'DadaYuga2013', '', 'DadaYuga2013', 100, 0, 1),
(3317, '韩版送', '', '韩版送', 100, 0, 1),
(3318, '32450054', '', '32450054', 100, 0, 1),
(3319, '夜场', '', '夜场', 100, 0, 1),
(3320, '钱夹', '', '钱夹', 100, 0, 9),
(3321, '粉彩', '', '粉彩', 100, 0, 2),
(3322, '运动休闲', '', '运动休闲', 100, 0, 1),
(3323, '32440007', '', '32440007', 100, 0, 1),
(3324, '驼色', '', '驼色', 100, 0, 1),
(3325, '猪皮', '', '猪皮', 100, 0, 1),
(3326, '冰莹', '', '冰莹', 100, 0, 1),
(3327, '萤光', '', '萤光', 100, 0, 1),
(3328, 'GA159', '', 'GA159', 100, 0, 1),
(3329, 'AA1540', '', 'AA1540', 100, 0, 1),
(3330, '单个', '', '单个', 100, 0, 1),
(3331, '那些', '', '那些', 100, 0, 1),
(3332, 'zd06087', '', 'zd06087', 100, 0, 1),
(3333, '凯蒂猫', '', '凯蒂猫', 100, 0, 1),
(3334, '一中', '', '一中', 100, 0, 1),
(3335, '1764', '', '1764', 100, 0, 1),
(3336, '连裤袜', '', '连裤袜', 100, 0, 1),
(3337, '连裤', '', '连裤', 100, 0, 1),
(3338, '勾丝', '', '勾丝', 100, 0, 1),
(3339, '蔷薇', '', '蔷薇', 100, 0, 3),
(3340, '主人', '', '主人', 100, 0, 1),
(3341, '花漾', '', '花漾', 100, 0, 1),
(3342, '钻石', '', '钻石', 100, 0, 1),
(3343, '珠宝', '', '珠宝', 100, 0, 2),
(3344, 'GAGA', '', 'GAGA', 100, 0, 2),
(3345, '子波', '', '子波', 100, 0, 1),
(3346, 'AA1275', '', 'AA1275', 100, 0, 1),
(3347, '大衣呢', '', '大衣呢', 100, 0, 1),
(3348, '活力', '', '活力', 100, 0, 2),
(3349, 'FC0065', '', 'FC0065', 100, 0, 1),
(3350, '翅膀', '', '翅膀', 100, 0, 2),
(3351, 'AF706', '', 'AF706', 100, 0, 1),
(3352, 'C491', '', 'C491', 100, 0, 1),
(3353, '戒子', '', '戒子', 100, 0, 2),
(3354, 'Sliver', '', 'Sliver', 100, 0, 1),
(3355, '考林', '', '考林', 100, 0, 1),
(3356, '32550013', '', '32550013', 100, 0, 1),
(3357, '粉红', '', '粉红', 100, 0, 2),
(3358, 'xisello', '', 'xisello', 100, 0, 1),
(3359, '点收', '', '点收', 100, 0, 1),
(3360, '空」', '', '空」', 100, 0, 1),
(3361, '包裙一', '', '包裙一', 100, 0, 1),
(3362, '轻巧', '', '轻巧', 100, 0, 1),
(3363, '古包弯', '', '古包弯', 100, 0, 1),
(3364, '435g', '', '435g', 100, 0, 1),
(3365, '双料', '', '双料', 100, 0, 1),
(3366, 'T1861', '', 'T1861', 100, 0, 1),
(3367, '埃菲尔铁塔', '', '埃菲尔铁塔', 100, 0, 2),
(3368, '扑克牌', '', '扑克牌', 100, 0, 2),
(3369, '江南', '', '江南', 100, 0, 2),
(3370, 'BA0698', '', 'BA0698', 100, 0, 1),
(3371, '包臀露', '', '包臀露', 100, 0, 1),
(3372, 'OSA2013', '', 'OSA2013', 100, 0, 2),
(3373, '开始', '', '开始', 100, 0, 1),
(3374, '317', '', '317', 100, 0, 1),
(3375, '雅伊特', '', '雅伊特', 100, 0, 1),
(3376, '610', '', '610', 100, 0, 1),
(3377, '挂表', '', '挂表', 100, 0, 2),
(3378, 'DECOWATCH', '', 'DECOWATCH', 100, 0, 2),
(3379, 'AXIS', '', 'AXIS', 100, 0, 2),
(3380, 'Orange', '', 'Orange', 100, 0, 1),
(3381, 'Desire', '', 'Desire', 100, 0, 1),
(3382, '伊朗', '', '伊朗', 100, 0, 1),
(3383, '库存', '', '库存', 100, 0, 1),
(3384, 'ROJAY', '', 'ROJAY', 100, 0, 1),
(3385, '视网', '', '视网', 100, 0, 1),
(3386, 'krazy2013', '', 'krazy2013', 100, 0, 1),
(3387, '396', '', '396', 100, 0, 1),
(3388, '羽翼', '', '羽翼', 100, 0, 1),
(3389, '罗娜', '', '罗娜', 100, 0, 1),
(3390, '贝丹诗', '', '贝丹诗', 100, 0, 1),
(3391, '卡娜', '', '卡娜', 100, 0, 1),
(3392, 'AD0186', '', 'AD0186', 100, 0, 1),
(3393, '边后', '', '边后', 100, 0, 1),
(3394, '韩版外', '', '韩版外', 100, 0, 1),
(3395, '贝贝', '', '贝贝', 100, 0, 1),
(3396, 'kiskiy', '', 'kiskiy', 100, 0, 1),
(3397, '文字', '', '文字', 100, 0, 1),
(3398, '彼得', '', '彼得', 100, 0, 4),
(3399, '潘领', '', '潘领', 100, 0, 1),
(3400, '3088', '', '3088', 100, 0, 1),
(3401, '风车', '', '风车', 100, 0, 1),
(3402, '收藏馆', '', '收藏馆', 100, 0, 1),
(3403, '果子', '', '果子', 100, 0, 1),
(3404, '树叶', '', '树叶', 100, 0, 2),
(3405, '瞬间', '', '瞬间', 100, 0, 2),
(3406, '国风', '', '国风', 100, 0, 4),
(3407, '婉约', '', '婉约', 100, 0, 1),
(3408, '碧玺', '', '碧玺', 100, 0, 1),
(3409, '性价比', '', '性价比', 100, 0, 1),
(3410, '含有', '', '含有', 100, 0, 1),
(3411, '珍贵', '', '珍贵', 100, 0, 1),
(3412, '27893', '', '27893', 100, 0, 1),
(3413, 'Marni', '', 'Marni', 100, 0, 1),
(3414, '卡位', '', '卡位', 100, 0, 3),
(3415, '脚蹬', '', '脚蹬', 100, 0, 1),
(3416, '扣扣', '', '扣扣', 100, 0, 1),
(3417, '睡醒', '', '睡醒', 100, 0, 1),
(3418, '男人', '', '男人', 100, 0, 1),
(3419, '爱情', '', '爱情', 100, 0, 1),
(3420, 'jeremy', '', 'jeremy', 100, 0, 1),
(3421, 'Scott', '', 'Scott', 100, 0, 1),
(3422, 'Color', '', 'Color', 100, 0, 3),
(3423, '高桶靴', '', '高桶靴', 100, 0, 1),
(3424, 'obyo', '', 'obyo', 100, 0, 1),
(3425, 'AD', '', 'AD', 100, 0, 1),
(3426, 'POPFIRST', '', 'POPFIRST', 100, 0, 1),
(3427, '爱爱', '', '爱爱', 100, 0, 2),
(3428, '5.09', '', '5.09', 100, 0, 1),
(3429, '回纹', '', '回纹', 100, 0, 1),
(3430, '织带', '', '织带', 100, 0, 1),
(3431, '特种', '', '特种', 100, 0, 1),
(3432, '方领', '', '方领', 100, 0, 1),
(3433, '14000738', '', '14000738', 100, 0, 1),
(3434, '银匠', '', '银匠', 100, 0, 1),
(3435, '玛瑙', '', '玛瑙', 100, 0, 4),
(3436, '13cm', '', '13cm', 100, 0, 1),
(3437, '沙滩装', '', '沙滩装', 100, 0, 1),
(3438, '边拉菲', '', '边拉菲', 100, 0, 1),
(3439, 'GUTEN', '', 'GUTEN', 100, 0, 1),
(3440, '高腰裙', '', '高腰裙', 100, 0, 2),
(3441, '气泡', '', '气泡', 100, 0, 1),
(3442, '夏风】', '', '夏风】', 100, 0, 1),
(3443, '休闲潮', '', '休闲潮', 100, 0, 1),
(3444, '1307', '', '1307', 100, 0, 1),
(3445, 'DECKAS', '', 'DECKAS', 100, 0, 1),
(3446, '珠玉', '', '珠玉', 100, 0, 1),
(3447, '佳人', '', '佳人', 100, 0, 1),
(3448, 'BX00231', '', 'BX00231', 100, 0, 1),
(3449, 'EVERY', '', 'EVERY', 100, 0, 1),
(3450, 'LUNA', '', 'LUNA', 100, 0, 4),
(3451, 'LOVE', '', 'LOVE', 100, 0, 2),
(3452, '初高中', '', '初高中', 100, 0, 1),
(3453, '海蓝', '', '海蓝', 100, 0, 3),
(3454, '天空之城', '', '天空之城', 100, 0, 1),
(3455, '后花园', '', '后花园', 100, 0, 1),
(3456, '圆球', '', '圆球', 100, 0, 2),
(3457, '5114', '', '5114', 100, 0, 1),
(3458, '婚宴', '', '婚宴', 100, 0, 1),
(3459, 'jioijio', '', 'jioijio', 100, 0, 1),
(3460, '硬币', '', '硬币', 100, 0, 1),
(3461, 'M2027', '', 'M2027', 100, 0, 1),
(3462, '2402', '', '2402', 100, 0, 1),
(3463, '水靴', '', '水靴', 100, 0, 1),
(3464, '袋中', '', '袋中', 100, 0, 1),
(3465, '百合', '', '百合', 100, 0, 1),
(3466, 'G2301', '', 'G2301', 100, 0, 1),
(3467, 'airmimius', '', 'airmimius', 100, 0, 1),
(3468, 'LY5310', '', 'LY5310', 100, 0, 1),
(3469, '手写', '', '手写', 100, 0, 1),
(3470, '姓名', '', '姓名', 100, 0, 1),
(3471, 'AD1550', '', 'AD1550', 100, 0, 1),
(3472, '麦琪', '', '麦琪', 100, 0, 1),
(3473, '安蒂', '', '安蒂', 100, 0, 1),
(3474, '腕表', '', '腕表', 100, 0, 4),
(3475, 'Mouche', '', 'Mouche', 100, 0, 1),
(3476, '02221', '', '02221', 100, 0, 1),
(3477, 'Andre', '', 'Andre', 100, 0, 1),
(3478, '妹子', '', '妹子', 100, 0, 2),
(3479, 'joyrich', '', 'joyrich', 100, 0, 1),
(3480, '爱丽丝', '', '爱丽丝', 100, 0, 1),
(3481, '纱布', '', '纱布', 100, 0, 1),
(3482, '霓虹', '', '霓虹', 100, 0, 1),
(3483, 'vera', '', 'vera', 100, 0, 1),
(3484, 'wang', '', 'wang', 100, 0, 1),
(3485, 'MM0401', '', 'MM0401', 100, 0, 1),
(3486, '紫檀木', '', '紫檀木', 100, 0, 1),
(3487, '开光', '', '开光', 100, 0, 2),
(3488, '佛珠', '', '佛珠', 100, 0, 2),
(3489, '平安', '', '平安', 100, 0, 1),
(3490, '保佑', '', '保佑', 100, 0, 1),
(3491, 'D219', '', 'D219', 100, 0, 1),
(3492, 'ZZ004', '', 'ZZ004', 100, 0, 1),
(3493, 'braccialini', '', 'braccialini', 100, 0, 1);
INSERT INTO `le_goods_tags` (`tag_id`, `tag_name`, `img`, `tag_code`, `sort`, `is_hot`, `count`) VALUES
(3494, '腰部', '', '腰部', 100, 0, 2),
(3495, 'A23806', '', 'A23806', 100, 0, 1),
(3496, '奥吉', '', '奥吉', 100, 0, 1),
(3497, '金亮', '', '金亮', 100, 0, 1),
(3498, '小立', '', '小立', 100, 0, 1),
(3499, 'zd05049', '', 'zd05049', 100, 0, 1),
(3500, '质检', '', '质检', 100, 0, 1),
(3501, 'NECKLACE', '', 'NECKLACE', 100, 0, 1),
(3502, 'NATALIA', '', 'NATALIA', 100, 0, 1),
(3503, 'BRILLI', '', 'BRILLI', 100, 0, 1),
(3504, 'HELMUT', '', 'HELMUT', 100, 0, 1),
(3505, '12.27', '', '12.27', 100, 0, 1),
(3506, 'JUJU', '', 'JUJU', 100, 0, 2),
(3507, 'M1875', '', 'M1875', 100, 0, 1),
(3508, '梨花', '', '梨花', 100, 0, 1),
(3509, '石头', '', '石头', 100, 0, 2),
(3510, 'M1890', '', 'M1890', 100, 0, 1),
(3511, 'M2089mimius2013', '', 'M2089mimius2013', 100, 0, 1),
(3512, 'M2009', '', 'M2009', 100, 0, 1),
(3513, '小调', '', '小调', 100, 0, 1),
(3514, 'A282', '', 'A282', 100, 0, 1),
(3515, 'zipper', '', 'zipper', 100, 0, 2),
(3516, '花红', '', '花红', 100, 0, 1),
(3517, '刚玉', '', '刚玉', 100, 0, 1),
(3518, '马赛克', '', '马赛克', 100, 0, 1),
(3519, '阑珊', '', '阑珊', 100, 0, 1),
(3520, '心意', '', '心意', 100, 0, 1),
(3521, 'QZ633', '', 'QZ633', 100, 0, 1),
(3522, '色布', '', '色布', 100, 0, 1),
(3523, '品红', '', '品红', 100, 0, 1),
(3524, '洛克鞋', '', '洛克鞋', 100, 0, 1),
(3525, '元气', '', '元气', 100, 0, 1),
(3526, '033', '', '033', 100, 0, 1),
(3527, '渡假', '', '渡假', 100, 0, 1),
(3528, '夹克衫', '', '夹克衫', 100, 0, 1),
(3529, '棒球', '', '棒球', 100, 0, 1),
(3530, 'bechance', '', 'bechance', 100, 0, 1),
(3531, '2789', '', '2789', 100, 0, 1),
(3532, '解构', '', '解构', 100, 0, 1),
(3533, '主义', '', '主义', 100, 0, 1),
(3534, '红豆', '', '红豆', 100, 0, 1),
(3535, '地摊', '', '地摊', 100, 0, 1),
(3536, '货源', '', '货源', 100, 0, 1),
(3537, '相思', '', '相思', 100, 0, 1),
(3538, '珠链', '', '珠链', 100, 0, 1),
(3539, '子男', '', '子男', 100, 0, 1),
(3540, '华丽', '', '华丽', 100, 0, 2),
(3541, '339', '', '339', 100, 0, 1),
(3542, 'leeswell', '', 'leeswell', 100, 0, 1),
(3543, '乐斯微', '', '乐斯微', 100, 0, 1),
(3544, '毛圈棉', '', '毛圈棉', 100, 0, 1),
(3545, '静谧', '', '静谧', 100, 0, 1),
(3546, '齐刘海', '', '齐刘海', 100, 0, 0),
(3547, '米妮', '', '米妮', 100, 0, 2),
(3548, '麦瑞家', '', '麦瑞家', 100, 0, 1),
(3549, '妮斯', '', '妮斯', 100, 0, 1),
(3550, '德国', '', '德国', 100, 0, 1),
(3551, 'Fuchsia', '', 'Fuchsia', 100, 0, 1),
(3552, 'Camilla', '', 'Camilla', 100, 0, 1),
(3553, 'Royal', '', 'Royal', 100, 0, 1),
(3554, 'Marc', '', 'Marc', 100, 0, 3),
(3555, 'Blue', '', 'Blue', 100, 0, 1),
(3556, 'infinity', '', 'infinity', 100, 0, 1),
(3557, '永远', '', '永远', 100, 0, 1),
(3558, '爱你', '', '爱你', 100, 0, 1),
(3559, '性感内衣', '', '性感内衣', 100, 0, 1),
(3560, '丰胸', '', '丰胸', 100, 0, 1),
(3561, '郁金香', '', '郁金香', 100, 0, 1),
(3562, '2011144', '', '2011144', 100, 0, 1),
(3563, 'CANNCI', '', 'CANNCI', 100, 0, 3),
(3564, 'S601', '', 'S601', 100, 0, 1),
(3565, '乌龟', '', '乌龟', 100, 0, 1),
(3566, '无印', '', '无印', 100, 0, 1),
(3567, '长大', '', '长大', 100, 0, 1),
(3568, '烫金', '', '烫金', 100, 0, 1),
(3569, '包快』', '', '包快』', 100, 0, 1),
(3570, '民族风情', '', '民族风情', 100, 0, 1),
(3571, 'SZ00222', '', 'SZ00222', 100, 0, 1),
(3572, 'M1953', '', 'M1953', 100, 0, 1),
(3573, '古铜色', '', '古铜色', 100, 0, 1),
(3574, '提升', '', '提升', 100, 0, 1),
(3575, '格高', '', '格高', 100, 0, 1),
(3576, '灰黄', '', '灰黄', 100, 0, 1),
(3577, '名片', '', '名片', 100, 0, 1),
(3578, 'mercuryduo', '', 'mercuryduo', 100, 0, 1),
(3579, 'YH1392', '', 'YH1392', 100, 0, 1),
(3580, '景泰蓝', '', '景泰蓝', 100, 0, 1),
(3581, '嫁衣', '', '嫁衣', 100, 0, 1),
(3582, '齐地', '', '齐地', 100, 0, 1),
(3583, '烟雨', '', '烟雨', 100, 0, 1),
(3584, 'Cityhoney2013', '', 'Cityhoney2013', 100, 0, 1),
(3585, 'M2130', '', 'M2130', 100, 0, 1),
(3586, '唐家', '', '唐家', 100, 0, 1),
(3587, '雁子', '', '雁子', 100, 0, 1),
(3588, '百岁', '', '百岁', 100, 0, 1),
(3589, 'OPPO', '', 'OPPO', 100, 0, 1),
(3590, '1987', '', '1987', 100, 0, 1),
(3591, 'YL9583', '', 'YL9583', 100, 0, 1),
(3592, '宇津', '', '宇津', 100, 0, 1),
(3593, 'Mercibeaucoup', '', 'Mercibeaucoup', 100, 0, 1),
(3594, '盒装', '', '盒装', 100, 0, 1),
(3595, '皮菱格', '', '皮菱格', 100, 0, 1),
(3596, '华宝', '', '华宝', 100, 0, 1),
(3597, 'OLANS', '', 'OLANS', 100, 0, 1),
(3598, 'QZ145', '', 'QZ145', 100, 0, 1),
(3599, 'A23111', '', 'A23111', 100, 0, 1),
(3600, '韩版森', '', '韩版森', 100, 0, 1),
(3601, 'AMGZ', '', 'AMGZ', 100, 0, 1),
(3602, 'mdash', '', 'mdash', 100, 0, 1),
(3603, '0220', '', '0220', 100, 0, 1),
(3604, '7.5', '', '7.5', 100, 0, 1),
(3605, 'CM', '', 'CM', 100, 0, 1),
(3606, '牛津布', '', '牛津布', 100, 0, 1),
(3607, '恐龙蛋', '', '恐龙蛋', 100, 0, 1),
(3608, 'aircross', '', 'aircross', 100, 0, 1),
(3609, '年货', '', '年货', 100, 0, 1),
(3610, '刻版', '', '刻版', 100, 0, 1),
(3611, 'vivienne', '', 'vivienne', 100, 0, 2),
(3612, 'westwood', '', 'westwood', 100, 0, 1),
(3613, '宁愿', '', '宁愿', 100, 0, 1),
(3614, '孩子', '', '孩子', 100, 0, 1),
(3615, '机械手', '', '机械手', 100, 0, 1),
(3616, '天津', '', '天津', 100, 0, 1),
(3617, '海鸥', '', '海鸥', 100, 0, 1),
(3618, 'M198S', '', 'M198S', 100, 0, 1),
(3619, '南风', '', '南风', 100, 0, 4),
(3620, '公文', '', '公文', 100, 0, 3),
(3621, '呢子', '', '呢子', 100, 0, 3),
(3622, '早春', '', '早春', 100, 0, 2),
(3623, 'Ucm', '', 'Ucm', 100, 0, 1),
(3624, '钢带', '', '钢带', 100, 0, 2),
(3625, '15002560', '', '15002560', 100, 0, 1),
(3626, '大公', '', '大公', 100, 0, 1),
(3627, '最低价', '', '最低价', 100, 0, 1),
(3628, '运动', '', '运动', 100, 0, 13),
(3629, '620', '', '620', 100, 0, 1),
(3630, 'D207', '', 'D207', 100, 0, 1),
(3631, '亲亲', '', '亲亲', 100, 0, 1),
(3632, '高腰显', '', '高腰显', 100, 0, 2),
(3633, '13263', '', '13263', 100, 0, 1),
(3634, '389', '', '389', 100, 0, 1),
(3635, '边飞肩', '', '边飞肩', 100, 0, 1),
(3636, '0527', '', '0527', 100, 0, 1),
(3637, '353', '', '353', 100, 0, 1),
(3638, 'Kidston', '', 'Kidston', 100, 0, 1),
(3639, 'Cath', '', 'Cath', 100, 0, 1),
(3640, '蒸汽', '', '蒸汽', 100, 0, 2),
(3641, '花露', '', '花露', 100, 0, 1),
(3642, '韩版裹', '', '韩版裹', 100, 0, 2),
(3643, '11403789', '', '11403789', 100, 0, 1),
(3644, '海贼王', '', '海贼王', 100, 0, 1),
(3645, 'GAOKONG', '', 'GAOKONG', 100, 0, 1),
(3646, '小王子', '', '小王子', 100, 0, 1),
(3647, 'Leleshop', '', 'Leleshop', 100, 0, 1),
(3648, '免费', '', '免费', 100, 0, 1),
(3649, '武西', '', '武西', 100, 0, 1),
(3650, '1375', '', '1375', 100, 0, 1),
(3651, '列侬', '', '列侬', 100, 0, 1),
(3652, '遮阳', '', '遮阳', 100, 0, 2),
(3653, 'lady', '', 'lady', 100, 0, 2),
(3654, '04.22', '', '04.22', 100, 0, 1),
(3655, '费～', '', '费～', 100, 0, 1),
(3656, 'linapelicci', '', 'linapelicci', 100, 0, 1),
(3657, '胸牌', '', '胸牌', 100, 0, 1),
(3658, '眼球', '', '眼球', 100, 0, 1),
(3659, 'S130607', '', 'S130607', 100, 0, 1),
(3660, 'nana', '', 'nana', 100, 0, 1),
(3661, 'F0135', '', 'F0135', 100, 0, 1),
(3662, 'myelsa', '', 'myelsa', 100, 0, 1),
(3663, '20166', '', '20166', 100, 0, 1),
(3664, '花鞋', '', '花鞋', 100, 0, 2),
(3665, '新生儿', '', '新生儿', 100, 0, 1),
(3666, '成品', '', '成品', 100, 0, 1),
(3667, 'honeyDIY', '', 'honeyDIY', 100, 0, 1),
(3668, '材料', '', '材料', 100, 0, 1),
(3669, 'BA0494', '', 'BA0494', 100, 0, 1),
(3670, 'SPADE', '', 'SPADE', 100, 0, 2),
(3671, '赫本风', '', '赫本风', 100, 0, 3),
(3672, 'KATE', '', 'KATE', 100, 0, 2),
(3673, '墨绿色', '', '墨绿色', 100, 0, 1),
(3674, '霸气', '', '霸气', 100, 0, 1),
(3675, '仓单', '', '仓单', 100, 0, 1),
(3676, '表带', '', '表带', 100, 0, 2),
(3677, 'FO', '', 'FO', 100, 0, 1),
(3678, '布复', '', '布复', 100, 0, 1),
(3679, '风帆', '', '风帆', 100, 0, 1),
(3680, '古扣', '', '古扣', 100, 0, 1),
(3681, 'CA249', '', 'CA249', 100, 0, 1),
(3682, '古董', '', '古董', 100, 0, 1),
(3683, 'classic', '', 'classic', 100, 0, 1),
(3684, 'ASOS', '', 'ASOS', 100, 0, 3),
(3685, '1.15', '', '1.15', 100, 0, 1),
(3686, 'UK', '', 'UK', 100, 0, 1),
(3687, 'KE0031', '', 'KE0031', 100, 0, 1),
(3688, '风起', '', '风起', 100, 0, 1),
(3689, '涟漪', '', '涟漪', 100, 0, 1),
(3690, '夏秋季', '', '夏秋季', 100, 0, 1),
(3691, '路肩', '', '路肩', 100, 0, 1),
(3692, 'SY815', '', 'SY815', 100, 0, 1),
(3693, '毛靴两', '', '毛靴两', 100, 0, 1),
(3694, '美高', '', '美高', 100, 0, 1),
(3695, '包臀显', '', '包臀显', 100, 0, 1),
(3696, '座椅', '', '座椅', 100, 0, 1),
(3697, '露天', '', '露天', 100, 0, 1),
(3698, '貔貅', '', '貔貅', 100, 0, 1),
(3699, '吉祥物', '', '吉祥物', 100, 0, 1),
(3700, '母亲节', '', '母亲节', 100, 0, 2),
(3701, 'zd05095', '', 'zd05095', 100, 0, 1),
(3702, '35CM', '', '35CM', 100, 0, 1),
(3703, '闪电', '', '闪电', 100, 0, 1),
(3704, 'PaVLa', '', 'PaVLa', 100, 0, 1),
(3705, '叶草', '', '叶草', 100, 0, 1),
(3706, '绿野仙踪', '', '绿野仙踪', 100, 0, 1),
(3707, 'CS00344', '', 'CS00344', 100, 0, 1),
(3708, '杰西', '', '杰西', 100, 0, 1),
(3709, 'JessieJane', '', 'JessieJane', 100, 0, 1),
(3710, '淡雅', '', '淡雅', 100, 0, 1),
(3711, '最后', '', '最后', 100, 0, 1),
(3712, 'AK1258', '', 'AK1258', 100, 0, 1),
(3713, 'r13B6039', '', 'r13B6039', 100, 0, 1),
(3714, '铁城', '', '铁城', 100, 0, 3),
(3715, 'CITIZEN', '', 'CITIZEN', 100, 0, 2),
(3716, 'watch', '', 'watch', 100, 0, 1),
(3717, '1110', '', '1110', 100, 0, 1),
(3718, 'club', '', 'club', 100, 0, 1),
(3719, 'SY1943', '', 'SY1943', 100, 0, 1),
(3720, '细雨', '', '细雨', 100, 0, 1),
(3721, 'DC06', '', 'DC06', 100, 0, 1),
(3722, 'M1982', '', 'M1982', 100, 0, 1),
(3723, '利时', '', '利时', 100, 0, 2),
(3724, '切割', '', '切割', 100, 0, 1),
(3725, '格格', '', '格格', 100, 0, 1),
(3726, '萝卜', '', '萝卜', 100, 0, 1),
(3727, 'OTHERMIX', '', 'OTHERMIX', 100, 0, 1),
(3728, '12T10015', '', '12T10015', 100, 0, 1),
(3729, '铂金', '', '铂金', 100, 0, 2),
(3730, 'AD1714', '', 'AD1714', 100, 0, 1),
(3731, '风清', '', '风清', 100, 0, 1),
(3732, '秋衣', '', '秋衣', 100, 0, 1),
(3733, 'M1046', '', 'M1046', 100, 0, 1),
(3734, '荔枝', '', '荔枝', 100, 0, 1),
(3735, 'ZZ030', '', 'ZZ030', 100, 0, 1),
(3736, '菱形', '', '菱形', 100, 0, 2),
(3737, '青花', '', '青花', 100, 0, 1),
(3738, '获赠', '', '获赠', 100, 0, 1),
(3739, '购买', '', '购买', 100, 0, 1),
(3740, 'mini', '', 'mini', 100, 0, 1),
(3741, '缠绕', '', '缠绕', 100, 0, 2),
(3742, '国行', '', '国行', 100, 0, 1),
(3743, 'people', '', 'people', 100, 0, 1),
(3744, 'free', '', 'free', 100, 0, 1),
(3745, 'LM9064', '', 'LM9064', 100, 0, 1),
(3746, 'Artmi2013', '', 'Artmi2013', 100, 0, 2),
(3747, '罗盘', '', '罗盘', 100, 0, 1),
(3748, '神秘', '', '神秘', 100, 0, 1),
(3749, '曼谷', '', '曼谷', 100, 0, 1),
(3750, '人生', '', '人生', 100, 0, 1),
(3751, '银绿', '', '银绿', 100, 0, 1),
(3752, '干练', '', '干练', 100, 0, 1),
(3753, '可子', '', '可子', 100, 0, 1),
(3754, 'ff00659', '', 'ff00659', 100, 0, 1),
(3755, '大中学生', '', '大中学生', 100, 0, 1),
(3756, 'BA0404', '', 'BA0404', 100, 0, 1),
(3757, '骆驼', '', '骆驼', 100, 0, 2),
(3758, '微笑', '', '微笑', 100, 0, 2),
(3759, '桃木', '', '桃木', 100, 0, 1),
(3760, '环绕', '', '环绕', 100, 0, 1),
(3761, '马海毛', '', '马海毛', 100, 0, 1),
(3762, '流星雨', '', '流星雨', 100, 0, 1),
(3763, '小方', '', '小方', 100, 0, 2),
(3764, '鳄鱼', '', '鳄鱼', 100, 0, 1),
(3765, '柠檬黄', '', '柠檬黄', 100, 0, 3),
(3766, '鸡心领', '', '鸡心领', 100, 0, 1),
(3767, '晚礼服', '', '晚礼服', 100, 0, 1),
(3768, '圣罗兰', '', '圣罗兰', 100, 0, 1),
(3769, '独特', '', '独特', 100, 0, 1),
(3770, '石英', '', '石英', 100, 0, 1),
(3771, '20495', '', '20495', 100, 0, 1),
(3772, '2956', '', '2956', 100, 0, 1),
(3773, '箭头', '', '箭头', 100, 0, 2),
(3774, '小众', '', '小众', 100, 0, 1),
(3775, '初春', '', '初春', 100, 0, 1),
(3776, '296', '', '296', 100, 0, 1),
(3777, 'S005', '', 'S005', 100, 0, 1),
(3778, 'QQ', '', 'QQ', 100, 0, 0),
(3779, '天时', '', '天时', 100, 0, 1),
(3780, 'BDS21015', '', 'BDS21015', 100, 0, 1),
(3781, '舒服', '', '舒服', 100, 0, 1),
(3782, '金属片', '', '金属片', 100, 0, 2),
(3783, '张小笨', '', '张小笨', 100, 0, 1),
(3784, 'QCL758', '', 'QCL758', 100, 0, 1),
(3785, '蒲公英', '', '蒲公英', 100, 0, 1),
(3786, '起来', '', '起来', 100, 0, 1),
(3787, '13048', '', '13048', 100, 0, 1),
(3788, 'K013', '', 'K013', 100, 0, 1),
(3789, '黑猫', '', '黑猫', 100, 0, 1),
(3790, '28', '', '28', 100, 0, 1),
(3791, '玻璃鞋', '', '玻璃鞋', 100, 0, 1),
(3792, '1306', '', '1306', 100, 0, 1),
(3793, '斯汀', '', '斯汀', 100, 0, 3),
(3794, 'X030', '', 'X030', 100, 0, 1),
(3795, '真丝绸', '', '真丝绸', 100, 0, 1),
(3796, '缎面', '', '缎面', 100, 0, 1),
(3797, '计时', '', '计时', 100, 0, 1),
(3798, '层次', '', '层次', 100, 0, 3),
(3799, '恋爱', '', '恋爱', 100, 0, 1),
(3800, '裁剪', '', '裁剪', 100, 0, 1),
(3801, '开口', '', '开口', 100, 0, 1),
(3802, '诱惑', '', '诱惑', 100, 0, 1),
(3803, 'lara', '', 'lara', 100, 0, 1),
(3804, '高腰裤', '', '高腰裤', 100, 0, 1),
(3805, 'Giuseppe', '', 'Giuseppe', 100, 0, 1),
(3806, 'Zanotti', '', 'Zanotti', 100, 0, 1),
(3807, '三叶草', '', '三叶草', 100, 0, 2),
(3808, 'GAGAI', '', 'GAGAI', 100, 0, 1),
(3809, 'forever', '', 'forever', 100, 0, 1),
(3810, 'new', '', 'new', 100, 0, 1),
(3811, 'SY3303', '', 'SY3303', 100, 0, 1),
(3812, 'Lazy', '', 'Lazy', 100, 0, 1),
(3813, 'Oaf', '', 'Oaf', 100, 0, 1),
(3814, '韩版侧', '', '韩版侧', 100, 0, 1),
(3815, '羽绒服', '', '羽绒服', 100, 0, 4),
(3816, '绵羊皮', '', '绵羊皮', 100, 0, 1),
(3817, '毛领', '', '毛领', 100, 0, 2),
(3818, '真爱', '', '真爱', 100, 0, 1),
(3819, '巴拿马', '', '巴拿马', 100, 0, 1),
(3820, '礼帽', '', '礼帽', 100, 0, 1),
(3821, '爵士', '', '爵士', 100, 0, 1),
(3822, '仙姿', '', '仙姿', 100, 0, 1),
(3823, '神韵', '', '神韵', 100, 0, 1),
(3824, 'HEA002', '', 'HEA002', 100, 0, 1),
(3825, 'DIS', '', 'DIS', 100, 0, 1),
(3826, 'CO', '', 'CO', 100, 0, 1),
(3827, '小胡子', '', '小胡子', 100, 0, 1),
(3828, '火爆', '', '火爆', 100, 0, 1),
(3829, 'T2S73', '', 'T2S73', 100, 0, 1),
(3830, '袜子', '', '袜子', 100, 0, 1),
(3831, '轻松', '', '轻松', 100, 0, 0),
(3832, '一堂', '', '一堂', 100, 0, 1),
(3833, '五角星', '', '五角星', 100, 0, 1),
(3834, '康桥', '', '康桥', 100, 0, 1),
(3835, '包身', '', '包身', 100, 0, 2),
(3836, 'J31338', '', 'J31338', 100, 0, 1),
(3837, '金熹', '', '金熹', 100, 0, 1),
(3838, 'DS005', '', 'DS005', 100, 0, 1),
(3839, '舒雅', '', '舒雅', 100, 0, 1),
(3840, '桃花鱼', '', '桃花鱼', 100, 0, 1),
(3841, '出品', '', '出品', 100, 0, 1),
(3842, '珍藏版', '', '珍藏版', 100, 0, 1),
(3843, '美中', '', '美中', 100, 0, 2),
(3844, '32420016', '', '32420016', 100, 0, 1),
(3845, 'FENG88', '', 'FENG88', 100, 0, 1),
(3846, 'W034', '', 'W034', 100, 0, 1),
(3847, 'oversize', '', 'oversize', 100, 0, 1),
(3848, '茱莉', '', '茱莉', 100, 0, 1),
(3849, '季秋', '', '季秋', 100, 0, 1),
(3850, '霓虹灯', '', '霓虹灯', 100, 0, 1),
(3851, '3026', '', '3026', 100, 0, 1),
(3852, '超特', '', '超特', 100, 0, 1),
(3853, '明治', '', '明治', 100, 0, 1),
(3854, '环食', '', '环食', 100, 0, 1),
(3855, '蓝宝石', '', '蓝宝石', 100, 0, 2),
(3856, 'KA115', '', 'KA115', 100, 0, 1),
(3857, '工长', '', '工长', 100, 0, 1),
(3858, '养牛', '', '养牛', 100, 0, 1),
(3859, 'REDMOON', '', 'REDMOON', 100, 0, 1),
(3860, '古着财', '', '古着财', 100, 0, 1),
(3861, '麻编坡', '', '麻编坡', 100, 0, 1),
(3862, '倾心', '', '倾心', 100, 0, 1),
(3863, '蛋壳', '', '蛋壳', 100, 0, 1),
(3864, '759', '', '759', 100, 0, 1),
(3865, 'Francisco', '', 'Francisco', 100, 0, 1),
(3866, '流浪', '', '流浪', 100, 0, 1),
(3867, '皮波西', '', '皮波西', 100, 0, 1),
(3868, '夹头', '', '夹头', 100, 0, 1),
(3869, 'ForeverKid', '', 'ForeverKid', 100, 0, 1),
(3870, '伊洛', '', '伊洛', 100, 0, 1),
(3871, 'SOLUDOS', '', 'SOLUDOS', 100, 0, 1),
(3872, 'RANGE', '', 'RANGE', 100, 0, 1),
(3873, '5.16', '', '5.16', 100, 0, 1),
(3874, 'MIRO', '', 'MIRO', 100, 0, 1),
(3875, '新秀', '', '新秀', 100, 0, 1),
(3876, '11CM', '', '11CM', 100, 0, 1),
(3877, '风琴', '', '风琴', 100, 0, 1),
(3878, '70185', '', '70185', 100, 0, 1),
(3879, '沙色', '', '沙色', 100, 0, 1),
(3880, '丝麻', '', '丝麻', 100, 0, 1),
(3881, 'burch', '', 'burch', 100, 0, 1),
(3882, '契约', '', '契约', 100, 0, 1),
(3883, '萨库拉', '', '萨库拉', 100, 0, 1),
(3884, '5199', '', '5199', 100, 0, 1),
(3885, '素雅', '', '素雅', 100, 0, 1),
(3886, '62130009', '', '62130009', 100, 0, 1),
(3887, 'DA1163', '', 'DA1163', 100, 0, 1),
(3888, '沃克', '', '沃克', 100, 0, 1),
(3889, '凯伦', '', '凯伦', 100, 0, 1),
(3890, 'WALKER', '', 'WALKER', 100, 0, 1),
(3891, 'KAREN', '', 'KAREN', 100, 0, 1),
(3892, 'San', '', 'San', 100, 0, 1),
(3893, '中通', '', '中通', 100, 0, 1),
(3894, '华晟', '', '华晟', 100, 0, 1),
(3895, '纯金', '', '纯金', 100, 0, 1),
(3896, 'AD1696', '', 'AD1696', 100, 0, 1),
(3897, '4167', '', '4167', 100, 0, 1),
(3898, '小西', '', '小西', 100, 0, 1),
(3899, '边缘', '', '边缘', 100, 0, 1),
(3900, 'CA228', '', 'CA228', 100, 0, 1),
(3901, '花漾菱', '', '花漾菱', 100, 0, 1),
(3902, '护照', '', '护照', 100, 0, 1),
(3903, 'youkshimwon', '', 'youkshimwon', 100, 0, 1),
(3904, 'galleryAM', '', 'galleryAM', 100, 0, 1),
(3905, 'CONWOOD', '', 'CONWOOD', 100, 0, 1),
(3906, '麋鹿', '', '麋鹿', 100, 0, 2),
(3907, 'M2146', '', 'M2146', 100, 0, 1),
(3908, '萤火虫', '', '萤火虫', 100, 0, 1),
(3909, '回家', '', '回家', 100, 0, 1),
(3910, 'special', '', 'special', 100, 0, 1),
(3911, '温柔', '', '温柔', 100, 0, 1),
(3912, '铅笔', '', '铅笔', 100, 0, 1),
(3913, 'LEGGING', '', 'LEGGING', 100, 0, 1),
(3914, '骑车', '', '骑车', 100, 0, 2),
(3915, '玻璃珠', '', '玻璃珠', 100, 0, 1),
(3916, 'MANGO2012', '', 'MANGO2012', 100, 0, 1),
(3917, '66637062', '', '66637062', 100, 0, 1),
(3918, 'TOUCH', '', 'TOUCH', 100, 0, 1),
(3919, '公事包', '', '公事包', 100, 0, 1),
(3920, 'AD1663', '', 'AD1663', 100, 0, 1),
(3921, '包撞色', '', '包撞色', 100, 0, 1),
(3922, '包斜跨', '', '包斜跨', 100, 0, 1),
(3923, '指套', '', '指套', 100, 0, 1),
(3924, 'PUNK', '', 'PUNK', 100, 0, 1),
(3925, '螺纹', '', '螺纹', 100, 0, 2),
(3926, '兔毛', '', '兔毛', 100, 0, 1),
(3927, '古斜跨', '', '古斜跨', 100, 0, 1),
(3928, '男朋友', '', '男朋友', 100, 0, 1),
(3929, 'palillo', '', 'palillo', 100, 0, 1),
(3930, 'daniel', '', 'daniel', 100, 0, 1),
(3931, 'AA2492', '', 'AA2492', 100, 0, 1),
(3932, '雀跃', '', '雀跃', 100, 0, 1),
(3933, '青春', '', '青春', 100, 0, 1),
(3934, 'P0156', '', 'P0156', 100, 0, 1),
(3935, '机器猫', '', '机器猫', 100, 0, 1),
(3936, '哆啦', '', '哆啦', 100, 0, 1),
(3937, '叮当', '', '叮当', 100, 0, 1),
(3938, '芳香', '', '芳香', 100, 0, 1),
(3939, '牛津', '', '牛津', 100, 0, 4),
(3940, 'Grace', '', 'Grace', 100, 0, 1),
(3941, 'gift', '', 'gift', 100, 0, 1),
(3942, '拉卡', '', '拉卡', 100, 0, 1),
(3943, '罗夏', '', '罗夏', 100, 0, 1),
(3944, '头像', '', '头像', 100, 0, 2),
(3945, '13169', '', '13169', 100, 0, 2),
(3946, '无印良品', '', '无印良品', 100, 0, 2),
(3947, 'yizi', '', 'yizi', 100, 0, 1),
(3948, '苹果树', '', '苹果树', 100, 0, 1),
(3949, 'AP2106', '', 'AP2106', 100, 0, 1),
(3950, '云朵', '', '云朵', 100, 0, 2),
(3951, 'r13C2006', '', 'r13C2006', 100, 0, 1),
(3952, '棉线', '', '棉线', 100, 0, 1),
(3953, '女西服', '', '女西服', 100, 0, 1),
(3954, '芥末', '', '芥末', 100, 0, 2),
(3955, '10M', '', '10M', 100, 0, 1),
(3956, '全新', '', '全新', 100, 0, 1),
(3957, '范百搭', '', '范百搭', 100, 0, 1),
(3958, '亚行', '', '亚行', 100, 0, 1),
(3959, 'QCL743', '', 'QCL743', 100, 0, 1),
(3960, 'E31', '', 'E31', 100, 0, 1),
(3961, 'SY982', '', 'SY982', 100, 0, 1),
(3962, '基础', '', '基础', 100, 0, 1),
(3963, 'julius', '', 'julius', 100, 0, 1),
(3964, '多瑙河', '', '多瑙河', 100, 0, 1),
(3965, 'joydivision', '', 'joydivision', 100, 0, 1),
(3966, '密码箱', '', '密码箱', 100, 0, 1),
(3967, '11403511', '', '11403511', 100, 0, 1),
(3968, 'miss', '', 'miss', 100, 0, 2),
(3969, 'amp', '', 'amp', 100, 0, 4),
(3970, 'viken', '', 'viken', 100, 0, 1),
(3971, '巴比伦', '', '巴比伦', 100, 0, 1),
(3972, '美满', '', '美满', 100, 0, 1),
(3973, 'ayomi', '', 'ayomi', 100, 0, 1),
(3974, '110W', '', '110W', 100, 0, 1),
(3975, '04.04', '', '04.04', 100, 0, 1),
(3976, 'A23761', '', 'A23761', 100, 0, 1),
(3977, 'X1920', '', 'X1920', 100, 0, 1),
(3978, '2436', '', '2436', 100, 0, 1),
(3979, 'CICI', '', 'CICI', 100, 0, 1),
(3980, '迷你型', '', '迷你型', 100, 0, 1),
(3981, '球鞋', '', '球鞋', 100, 0, 2),
(3982, '跑步', '', '跑步', 100, 0, 1),
(3983, '变色', '', '变色', 100, 0, 1),
(3984, 'Jaicee', '', 'Jaicee', 100, 0, 1),
(3985, 'Jeans', '', 'Jeans', 100, 0, 1),
(3986, '5103', '', '5103', 100, 0, 1),
(3987, '苏安真', '', '苏安真', 100, 0, 3),
(3988, 'LY00445', '', 'LY00445', 100, 0, 1),
(3989, 'BLING', '', 'BLING', 100, 0, 1),
(3990, '盒式', '', '盒式', 100, 0, 1),
(3991, '松石', '', '松石', 100, 0, 1),
(3992, 'L30007', '', 'L30007', 100, 0, 1),
(3993, '榛果', '', '榛果', 100, 0, 1),
(3994, '打开', '', '打开', 100, 0, 1),
(3995, 'DAISY', '', 'DAISY', 100, 0, 1),
(3996, 'XB015', '', 'XB015', 100, 0, 1),
(3997, 'junjoy2013', '', 'junjoy2013', 100, 0, 1),
(3998, '婚礼', '', '婚礼', 100, 0, 2),
(3999, '摇摇', '', '摇摇', 100, 0, 2),
(4000, '苏醒', '', '苏醒', 100, 0, 1),
(4001, '艾莉诺', '', '艾莉诺', 100, 0, 1),
(4002, '藕荷色', '', '藕荷色', 100, 0, 1),
(4003, '精工', '', '精工', 100, 0, 1),
(4004, '海豚', '', '海豚', 100, 0, 1),
(4005, 'JPF', '', 'JPF', 100, 0, 1),
(4006, '40459', '', '40459', 100, 0, 1),
(4007, 'M2058', '', 'M2058', 100, 0, 1),
(4008, '夏潮', '', '夏潮', 100, 0, 1),
(4009, '早秋', '', '早秋', 100, 0, 1),
(4010, '淡紫色', '', '淡紫色', 100, 0, 1),
(4011, '天天', '', '天天', 100, 0, 3),
(4012, '季小', '', '季小', 100, 0, 1),
(4013, '谢娜版', '', '谢娜版', 100, 0, 1),
(4014, '鱼尾', '', '鱼尾', 100, 0, 1),
(4015, '工字', '', '工字', 100, 0, 1),
(4016, '汉堡', '', '汉堡', 100, 0, 1),
(4017, '物欲', '', '物欲', 100, 0, 1),
(4018, 'colette', '', 'colette', 100, 0, 1),
(4019, 'Snake', '', 'Snake', 100, 0, 1),
(4020, 'Cobra', '', 'Cobra', 100, 0, 1),
(4021, 'Vans', '', 'Vans', 100, 0, 1),
(4022, '蓝标', '', '蓝标', 100, 0, 1),
(4023, '尔斯', '', '尔斯', 100, 0, 1),
(4024, '尼龙', '', '尼龙', 100, 0, 1),
(4025, '仲夏', '', '仲夏', 100, 0, 1),
(4026, '最美', '', '最美', 100, 0, 1),
(4027, '大爱', '', '大爱', 100, 0, 2),
(4028, 'r13B6041', '', 'r13B6041', 100, 0, 1),
(4029, '枧牨媾摰', '', '枧牨媾摰', 100, 0, 0),
(4030, '殁€⑩€氱┖', '', '殁€⑩€氱┖', 100, 0, 0),
(4031, '鑽鈥扮尖€', '', '鑽鈥扮尖€', 100, 0, 0),
(4032, '瑁歌鈥安', '', '瑁歌鈥安', 100, 0, 0),
(4033, '娉㈣タ绫充号', '', '娉㈣タ绫充号', 100, 0, 0),
(4034, '浼鈥橀鈥敳', '', '浼鈥橀鈥敳', 100, 0, 0),
(4035, '娓鈥︽鈥摪', '', '娓鈥︽鈥摪', 100, 0, 0),
(4036, '玮€澃邂€涵', '', '玮€澃邂€涵', 100, 0, 0),
(4037, '玮劉炬惌', '', '玮劉炬惌', 100, 0, 0),
(4038, '驸€敟绯', '', '驸€敟绯', 100, 0, 0),
(4039, '纰沤枧牨', '', '纰沤枧牨', 100, 0, 0),
(4040, '邂€Μ涓', '', '邂€Μ涓', 100, 0, 0),
(4041, '桠€⒕涓', '', '桠€⒕涓', 100, 0, 0),
(4042, '驸€辜媾渐', '', '驸€辜媾渐', 100, 0, 0),
(4043, '娆х九', '', '娆х九', 100, 0, 0),
(4265, '昊天', '', '昊天', 100, 0, 1),
(4045, '绯鈥撴啪艙桠€安', '', '绯鈥撴啪艙桠€安', 100, 0, 0),
(4046, '殁€邯绾', '', '殁€邯绾', 100, 0, 0),
(4047, '娉㈢鈥毠', '', '娉㈢鈥毠', 100, 0, 0),
(4048, '上托', '', '上托', 100, 0, 0),
(4049, '床品', '', '床品', 100, 0, 0),
(4050, '集线器', '', '集线器', 100, 0, 0),
(4051, 'COSPLAY', '', 'COSPLAY', 100, 0, 0),
(4052, '莉雅', '', '莉雅', 100, 0, 0),
(4053, '短发', '', '短发', 100, 0, 0),
(4054, '酒', '', '酒', 100, 0, 0),
(4055, '白羊座', '', '白羊座', 100, 0, 0),
(4056, '女装夏装2013新款短袖', '', '女装夏装2013新款短袖', 100, 0, 0),
(4057, '丰臀', '', '丰臀', 100, 0, 0),
(4058, '马丁底', '', '马丁底', 100, 0, 1),
(4059, '微胖', '', '微胖', 100, 0, 0),
(4060, '飞鱼', '', '飞鱼', 100, 0, 1),
(4061, '运动装', '', '运动装', 100, 0, 1),
(4062, '学院风', '', '学院风', 100, 0, 1),
(4063, '生大', '', '生大', 100, 0, 1),
(4064, '新学', '', '新学', 100, 0, 1),
(4065, '20D', '', '20D', 100, 0, 0),
(4066, '12312', '', '12312', 100, 0, 0),
(4067, 'Pint', '', 'Pint', 100, 0, 0),
(4068, '包邮日', '', '包邮日', 100, 0, 0),
(4069, '玉颜', '', '玉颜', 100, 0, 1),
(4070, '菁华', '', '菁华', 100, 0, 1),
(4071, 'Herborist', '', 'Herborist', 100, 0, 1),
(4072, '精华', '', '精华', 100, 0, 4),
(4073, '果绿色', '', '果绿色', 100, 0, 1),
(4074, '拉格', '', '拉格', 100, 0, 1),
(4075, '莱格', '', '莱格', 100, 0, 1),
(4076, '菲比寻常', '', '菲比寻常', 100, 0, 1),
(4077, 'Ferragamo', '', 'Ferragamo', 100, 0, 1),
(4078, 'EDT', '', 'EDT', 100, 0, 7),
(4079, '活肤', '', '活肤', 100, 0, 2),
(4080, '欧莱雅', '', '欧莱雅', 100, 0, 2),
(4081, '抗皱', '', '抗皱', 100, 0, 4),
(4082, '甘油', '', '甘油', 100, 0, 1),
(4083, '红玫瑰', '', '红玫瑰', 100, 0, 1),
(4084, '125g', '', '125g', 100, 0, 1),
(4085, '润肤霜', '', '润肤霜', 100, 0, 1),
(4086, '舒爽', '', '舒爽', 100, 0, 3),
(4087, '修护', '', '修护', 100, 0, 5),
(4088, '大红', '', '大红', 100, 0, 1),
(4089, '喜庆', '', '喜庆', 100, 0, 1),
(4090, '樱草', '', '樱草', 100, 0, 1),
(4091, '身体', '', '身体', 100, 0, 1),
(4092, '润肤', '', '润肤', 100, 0, 2),
(4093, 'CAMENAE', '', 'CAMENAE', 100, 0, 1),
(4094, '日霜', '', '日霜', 100, 0, 3),
(4095, '使用', '', '使用', 100, 0, 1),
(4096, 'Loreal', '', 'Loreal', 100, 0, 1),
(4097, '45ML', '', '45ML', 100, 0, 1),
(4098, '洁净', '', '洁净', 100, 0, 1),
(4099, 'Lom', '', 'Lom', 100, 0, 1),
(4100, 'Eve', '', 'Eve', 100, 0, 1),
(4101, '雅宝', '', '雅宝', 100, 0, 1),
(4102, '精灵', '', '精灵', 100, 0, 3),
(4103, 'Arpels', '', 'Arpels', 100, 0, 1),
(4104, 'Cleef', '', 'Cleef', 100, 0, 1),
(4105, '50ML', '', '50ML', 100, 0, 3),
(4106, 'Van', '', 'Van', 100, 0, 1),
(4107, '莱雅', '', '莱雅', 100, 0, 1),
(4108, '护肤品', '', '护肤品', 100, 0, 1),
(4109, '柏珀', '', '柏珀', 100, 0, 1),
(4110, '嫩肤', '', '嫩肤', 100, 0, 1),
(4111, '矿物', '', '矿物', 100, 0, 1),
(4112, '白水', '', '白水', 100, 0, 1),
(4113, '莉芙', '', '莉芙', 100, 0, 1),
(4114, '持久', '', '持久', 100, 0, 3),
(4115, 'ugshoes', '', 'ugshoes', 100, 0, 1),
(4116, '晚霜', '', '晚霜', 100, 0, 1),
(4117, '肌肤', '', '肌肤', 100, 0, 3),
(4118, '用于', '', '用于', 100, 0, 1),
(4119, '所有', '', '所有', 100, 0, 1),
(4120, '50g', '', '50g', 100, 0, 1),
(4121, '亮采', '', '亮采', 100, 0, 1),
(4122, '净白', '', '净白', 100, 0, 1),
(4123, '高夫', '', '高夫', 100, 0, 3),
(4124, '受损', '', '受损', 100, 0, 2),
(4125, '大宝', '', '大宝', 100, 0, 1),
(4126, '绿茶', '', '绿茶', 100, 0, 2),
(4127, 'SOD', '', 'SOD', 100, 0, 1),
(4128, '安安', '', '安安', 100, 0, 2),
(4129, '蝴蝶斑', '', '蝴蝶斑', 100, 0, 1),
(4130, '黑斑', '', '黑斑', 100, 0, 1),
(4131, '黄褐斑', '', '黄褐斑', 100, 0, 1),
(4132, '芦荟', '', '芦荟', 100, 0, 1),
(4133, '淡化', '', '淡化', 100, 0, 1),
(4134, '祛斑', '', '祛斑', 100, 0, 1),
(4135, '胶原', '', '胶原', 100, 0, 1),
(4136, '蛋白', '', '蛋白', 100, 0, 2),
(4137, '雪莲', '', '雪莲', 100, 0, 1),
(4138, '授权', '', '授权', 100, 0, 4),
(4139, '100g', '', '100g', 100, 0, 4),
(4140, '迪奥', '', '迪奥', 100, 0, 2),
(4141, '沙丘', '', '沙丘', 100, 0, 1),
(4142, '蓄水', '', '蓄水', 100, 0, 1),
(4143, '水库', '', '水库', 100, 0, 1),
(4144, '快速', '', '快速', 100, 0, 1),
(4145, 'FEEL', '', 'FEEL', 100, 0, 1),
(4146, 'JOY', '', 'JOY', 100, 0, 1),
(4147, '新颜', '', '新颜', 100, 0, 1),
(4148, '橄榄油', '', '橄榄油', 100, 0, 1),
(4149, '金纯', '', '金纯', 100, 0, 1),
(4150, '尿酸', '', '尿酸', 100, 0, 1),
(4151, '单片', '', '单片', 100, 0, 1),
(4152, '日记', '', '日记', 100, 0, 1),
(4153, 'Mild', '', 'Mild', 100, 0, 1),
(4154, 'Pure', '', 'Pure', 100, 0, 1),
(4155, 'II', '', 'II', 100, 0, 2),
(4156, '马皮', '', '马皮', 100, 0, 1),
(4157, '象牙白', '', '象牙白', 100, 0, 1),
(4158, '黑眼圈', '', '黑眼圈', 100, 0, 1),
(4159, 'niniMONICA', '', 'niniMONICA', 100, 0, 1),
(4160, 'Harajuku', '', 'Harajuku', 100, 0, 1),
(4161, 'Lovers', '', 'Lovers', 100, 0, 1),
(4162, '海藻', '', '海藻', 100, 0, 1),
(4163, '舒敏', '', '舒敏', 100, 0, 1),
(4164, '舒润', '', '舒润', 100, 0, 1),
(4165, '甘菊', '', '甘菊', 100, 0, 1),
(4166, '班纳', '', '班纳', 100, 0, 2),
(4167, '绅士', '', '绅士', 100, 0, 2),
(4168, 'GABBANA', '', 'GABBANA', 100, 0, 1),
(4169, 'DOLCE', '', 'DOLCE', 100, 0, 1),
(4170, '杜嘉', '', '杜嘉', 100, 0, 2),
(4171, '范思哲', '', '范思哲', 100, 0, 1),
(4172, '可乐', '', '可乐', 100, 0, 1),
(4173, '75ML', '', '75ML', 100, 0, 1),
(4174, '蒂尔', '', '蒂尔', 100, 0, 1),
(4175, '小样', '', '小样', 100, 0, 3),
(4176, '花之', '', '花之', 100, 0, 1),
(4177, '5ML', '', '5ML', 100, 0, 2),
(4178, '活化', '', '活化', 100, 0, 1),
(4179, 'MER', '', 'MER', 100, 0, 1),
(4180, '片仔癀', '', '片仔癀', 100, 0, 2),
(4181, '皇后', '', '皇后', 100, 0, 1),
(4182, '亚麻布', '', '亚麻布', 100, 0, 1),
(4183, '思亲', '', '思亲', 100, 0, 1),
(4184, '葡萄', '', '葡萄', 100, 0, 1),
(4185, '茶叶', '', '茶叶', 100, 0, 0),
(4186, '倦容', '', '倦容', 100, 0, 1),
(4187, 'Relovery8', '', 'Relovery8', 100, 0, 1),
(4188, 'Eight', '', 'Eight', 100, 0, 1),
(4189, '香奈儿', '', '香奈儿', 100, 0, 1),
(4190, '东方', '', '东方', 100, 0, 1),
(4191, 'COCO', '', 'COCO', 100, 0, 2),
(4192, '瑞士', '', '瑞士', 100, 0, 1),
(4193, '睡眠', '', '睡眠', 100, 0, 2),
(4194, 'VAQUA', '', 'VAQUA', 100, 0, 1),
(4195, '心机', '', '心机', 100, 0, 1),
(4196, '熊果素', '', '熊果素', 100, 0, 1),
(4197, '普罗旺斯', '', '普罗旺斯', 100, 0, 1),
(4198, '有机', '', '有机', 100, 0, 1),
(4199, '75g', '', '75g', 100, 0, 1),
(4200, '茶多酚', '', '茶多酚', 100, 0, 1),
(4201, '泡沫', '', '泡沫', 100, 0, 1),
(4202, '网纱', '', '网纱', 100, 0, 0),
(4203, '柔滑', '', '柔滑', 100, 0, 1),
(4204, '健胸', '', '健胸', 100, 0, 1),
(4205, '娇韵诗', '', '娇韵诗', 100, 0, 1),
(4206, '增大', '', '增大', 100, 0, 1),
(4207, '胸部', '', '胸部', 100, 0, 1),
(4208, '扩大', '', '扩大', 100, 0, 1),
(4209, 'Clarins', '', 'Clarins', 100, 0, 1),
(4210, '15ml', '', '15ml', 100, 0, 1),
(4211, '白多效', '', '白多效', 100, 0, 1),
(4212, '黄亮', '', '黄亮', 100, 0, 1),
(4213, '光美', '', '光美', 100, 0, 1),
(4214, '双唇', '', '双唇', 100, 0, 1),
(4215, '至爱', '', '至爱', 100, 0, 1),
(4216, 'LANSUR', '', 'LANSUR', 100, 0, 1),
(4217, '香氛', '', '香氛', 100, 0, 1),
(4218, '珍宝', '', '珍宝', 100, 0, 1),
(4219, '晶莹', '', '晶莹', 100, 0, 1),
(4220, '25ML', '', '25ML', 100, 0, 1),
(4221, '油垢', '', '油垢', 100, 0, 1),
(4222, '舒活', '', '舒活', 100, 0, 1),
(4223, '能量', '', '能量', 100, 0, 1),
(4224, '香精', '', '香精', 100, 0, 1),
(4225, 'Femme', '', 'Femme', 100, 0, 1),
(4226, 'Nuit', '', 'Nuit', 100, 0, 1),
(4227, 'Pour', '', 'Pour', 100, 0, 1),
(4228, 'Boss', '', 'Boss', 100, 0, 1),
(4229, '75', '', '75', 100, 0, 1),
(4230, '50', '', '50', 100, 0, 1),
(4231, '诺曼', '', '诺曼', 100, 0, 1),
(4232, '双效', '', '双效', 100, 0, 1),
(4233, '深度', '', '深度', 100, 0, 1),
(4234, 'pc', '', 'pc', 100, 0, 1),
(4235, '赤道', '', '赤道', 100, 0, 1),
(4236, '紫外线', '', '紫外线', 100, 0, 1),
(4237, 'SPF', '', 'SPF', 100, 0, 1),
(4238, 'PA', '', 'PA', 100, 0, 1),
(4239, 'Samsung', '', 'Samsung', 100, 0, 0),
(4240, '古驰罪', '', '古驰罪', 100, 0, 1),
(4241, '古琦', '', '古琦', 100, 0, 1),
(4242, '雅顿', '', '雅顿', 100, 0, 1),
(4243, '调理', '', '调理', 100, 0, 1),
(4244, '普通', '', '普通', 100, 0, 1),
(4245, '细发', '', '细发', 100, 0, 1),
(4246, '南宁', '', '南宁', 100, 0, 0),
(4247, '柔白', '', '柔白', 100, 0, 1),
(4248, '氨基酸', '', '氨基酸', 100, 0, 1),
(4249, '石榴', '', '石榴', 100, 0, 1),
(4250, '排毒', '', '排毒', 100, 0, 1),
(4251, '养颜', '', '养颜', 100, 0, 1),
(4252, 'skii', '', 'skii', 100, 0, 1),
(4253, 'SK', '', 'SK', 100, 0, 1),
(4254, '净化', '', '净化', 100, 0, 1),
(4255, '清润', '', '清润', 100, 0, 1),
(4256, '盘发', '', '盘发', 100, 0, 1),
(4257, '职场', '', '职场', 100, 0, 1),
(4258, 'D217', '', 'D217', 100, 0, 1),
(4259, '尔丹', '', '尔丹', 100, 0, 1),
(4260, '纯银饰品', '', '纯银饰品', 100, 0, 2),
(4261, '方框', '', '方框', 100, 0, 1),
(4262, 'tr90', '', 'tr90', 100, 0, 1),
(4263, '耸肩', '', '耸肩', 100, 0, 3),
(4264, 'r13C1439', '', 'r13C1439', 100, 0, 1),
(4266, '五色', '', '五色', 100, 0, 1),
(4267, '金珀', '', '金珀', 100, 0, 1),
(4268, '波罗', '', '波罗', 100, 0, 1),
(4269, '地海', '', '地海', 100, 0, 1),
(4270, '朱砂', '', '朱砂', 100, 0, 2),
(4271, '13402', '', '13402', 100, 0, 1),
(4272, '爱华', '', '爱华', 100, 0, 1),
(4273, '去黑头', '', '去黑头', 100, 0, 1),
(4274, '草木', '', '草木', 100, 0, 1),
(4275, 'hitorat', '', 'hitorat', 100, 0, 1),
(4276, '蜡笔', '', '蜡笔', 100, 0, 1),
(4277, '小胖', '', '小胖', 100, 0, 1),
(4278, '碧水', '', '碧水', 100, 0, 1),
(4279, '07', '', '07', 100, 0, 1),
(4280, '浅紫色', '', '浅紫色', 100, 0, 1),
(4281, 'DW0668', '', 'DW0668', 100, 0, 1),
(4282, '香熏', '', '香熏', 100, 0, 1),
(4283, '香薰', '', '香薰', 100, 0, 1),
(4284, '净化空气', '', '净化空气', 100, 0, 1),
(4285, '熏香', '', '熏香', 100, 0, 1),
(4286, '缓解', '', '缓解', 100, 0, 1),
(4287, '干花', '', '干花', 100, 0, 2),
(4288, '仓库', '', '仓库', 100, 0, 1),
(4289, '包皮', '', '包皮', 100, 0, 1),
(4290, 'K047', '', 'K047', 100, 0, 1),
(4291, '油膏', '', '油膏', 100, 0, 1),
(4292, '金牌', '', '金牌', 100, 0, 1),
(4293, '卡伊', '', '卡伊', 100, 0, 1),
(4294, '守护', '', '守护', 100, 0, 1),
(4295, 'PT900', '', 'PT900', 100, 0, 1),
(4296, 'AD1532', '', 'AD1532', 100, 0, 1),
(4297, '莉娜', '', '莉娜', 100, 0, 1),
(4298, '藤井', '', '藤井', 100, 0, 1),
(4299, '结发', '', '结发', 100, 0, 1),
(4300, '影音', '', '影音', 100, 0, 0),
(4301, '层次感', '', '层次感', 100, 0, 1),
(4302, '全套', '', '全套', 100, 0, 1),
(4303, '天蓝', '', '天蓝', 100, 0, 1),
(4304, '发售', '', '发售', 100, 0, 2),
(4305, '鞋套', '', '鞋套', 100, 0, 1),
(4306, '染色', '', '染色', 100, 0, 1),
(4307, '爱丽', '', '爱丽', 100, 0, 1),
(4308, '16003210', '', '16003210', 100, 0, 1),
(4309, 'r13B6307', '', 'r13B6307', 100, 0, 1),
(4310, '果果', '', '果果', 100, 0, 1),
(4311, 'sinequanone', '', 'sinequanone', 100, 0, 1),
(4312, '仰望', '', '仰望', 100, 0, 1),
(4313, '如果', '', '如果', 100, 0, 1),
(4314, '2145', '', '2145', 100, 0, 1),
(4315, '04', '', '04', 100, 0, 1),
(4316, '剑桥', '', '剑桥', 100, 0, 1),
(4317, 'Cambridge', '', 'Cambridge', 100, 0, 1),
(4318, '公仔', '', '公仔', 100, 0, 1),
(4319, '节日礼品', '', '节日礼品', 100, 0, 1),
(4320, '马戏团', '', '马戏团', 100, 0, 1),
(4321, '忧伤', '', '忧伤', 100, 0, 1),
(4322, '休闲女装', '', '休闲女装', 100, 0, 1),
(4323, '3296', '', '3296', 100, 0, 1),
(4324, '参与', '', '参与', 100, 0, 1),
(4325, '399', '', '399', 100, 0, 1),
(4326, '喜宝', '', '喜宝', 100, 0, 1),
(4327, '美金', '', '美金', 100, 0, 1),
(4328, '白的', '', '白的', 100, 0, 1),
(4329, '378', '', '378', 100, 0, 1),
(4330, '吸顶灯', '', '吸顶灯', 100, 0, 1),
(4331, '灯具', '', '灯具', 100, 0, 1),
(4332, '现代', '', '现代', 100, 0, 1),
(4333, '866', '', '866', 100, 0, 1),
(4334, '擎天柱', '', '擎天柱', 100, 0, 1),
(4335, '金刚', '', '金刚', 100, 0, 1),
(4336, '声光', '', '声光', 100, 0, 1),
(4337, '黄蜂', '', '黄蜂', 100, 0, 1),
(4338, '机器人', '', '机器人', 100, 0, 1),
(4339, '玩具', '', '玩具', 100, 0, 1),
(4340, '战神', '', '战神', 100, 0, 1),
(4341, '变形', '', '变形', 100, 0, 1),
(4342, '电瓶车', '', '电瓶车', 100, 0, 1),
(4343, '摩托车', '', '摩托车', 100, 0, 1),
(4344, 'B11052', '', 'B11052', 100, 0, 1),
(4345, 'P0532', '', 'P0532', 100, 0, 1),
(4346, '仕女', '', '仕女', 100, 0, 1),
(4347, 'AA2625', '', 'AA2625', 100, 0, 1),
(4348, '132NS137', '', '132NS137', 100, 0, 1),
(4349, '皮格纹', '', '皮格纹', 100, 0, 1),
(4350, '马桶', '', '马桶', 100, 0, 1),
(4351, '洗护用品', '', '洗护用品', 100, 0, 0),
(4352, 'A23760', '', 'A23760', 100, 0, 1),
(4353, '套色', '', '套色', 100, 0, 1),
(4354, 'LM0411', '', 'LM0411', 100, 0, 1),
(4355, 'ZE103', '', 'ZE103', 100, 0, 1),
(4356, '安妮特', '', '安妮特', 100, 0, 1),
(4357, '锁链', '', '锁链', 100, 0, 1),
(4358, '叉子', '', '叉子', 100, 0, 1),
(4359, '崔美', '', '崔美', 100, 0, 1),
(4360, '料理', '', '料理', 100, 0, 0),
(4361, '平胸', '', '平胸', 100, 0, 0),
(4362, 'J3401', '', 'J3401', 100, 0, 1),
(4363, 'Jacobs', '', 'Jacobs', 100, 0, 2),
(4364, '长三', '', '长三', 100, 0, 1),
(4365, '星空', '', '星空', 100, 0, 2),
(4366, '尚品', '', '尚品', 100, 0, 1),
(4367, '尤物', '', '尤物', 100, 0, 1),
(4368, 'K051', '', 'K051', 100, 0, 1),
(4369, '保健', '', '保健', 100, 0, 0),
(4370, '龙发', '', '龙发', 100, 0, 1),
(4371, '马卡', '', '马卡', 100, 0, 1),
(4372, '迷幻', '', '迷幻', 100, 0, 1),
(4373, '秀丽', '', '秀丽', 100, 0, 1),
(4374, '典雅', '', '典雅', 100, 0, 1),
(4375, 'WONDER', '', 'WONDER', 100, 0, 1),
(4376, '尼泊尔', '', '尼泊尔', 100, 0, 1),
(4377, '提包', '', '提包', 100, 0, 1),
(4378, '陌上', '', '陌上', 100, 0, 1),
(4379, '织锦', '', '织锦', 100, 0, 1),
(4380, '褐色', '', '褐色', 100, 0, 1),
(4381, '5.14', '', '5.14', 100, 0, 1),
(4382, '印花布', '', '印花布', 100, 0, 1),
(4383, 'andshop', '', 'andshop', 100, 0, 1),
(4384, '女帽', '', '女帽', 100, 0, 1),
(4385, '天大', '', '天大', 100, 0, 1),
(4386, '圆顶', '', '圆顶', 100, 0, 1),
(4387, '诱人', '', '诱人', 100, 0, 1),
(4388, '购物', '', '购物', 100, 0, 1),
(4389, '橙色', '', '橙色', 100, 0, 1),
(4390, '强势', '', '强势', 100, 0, 1),
(4391, 'A23731', '', 'A23731', 100, 0, 1),
(4392, 'zd05014', '', 'zd05014', 100, 0, 1),
(4393, 'VEGOO', '', 'VEGOO', 100, 0, 1),
(4394, 'AM10001', '', 'AM10001', 100, 0, 1),
(4395, '纪念版', '', '纪念版', 100, 0, 1),
(4396, 'CHARLOTTE', '', 'CHARLOTTE', 100, 0, 1),
(4397, 'OLYMPIA', '', 'OLYMPIA', 100, 0, 1),
(4398, '猪娃', '', '猪娃', 100, 0, 1),
(4399, '镜面', '', '镜面', 100, 0, 1),
(4400, 'mng', '', 'mng', 100, 0, 1),
(4401, '红宝石', '', '红宝石', 100, 0, 1),
(4402, '我们的爱', '', '我们的爱', 100, 0, 1),
(4403, '邂逅', '', '邂逅', 100, 0, 1),
(4404, '谢师宴', '', '谢师宴', 100, 0, 0),
(4405, '黛妃', '', '黛妃', 100, 0, 1),
(4406, '少量', '', '少量', 100, 0, 1),
(4407, '密码', '', '密码', 100, 0, 1),
(4408, '33miss', '', '33miss', 100, 0, 1),
(4409, '7017', '', '7017', 100, 0, 1),
(4410, '羊毛衣', '', '羊毛衣', 100, 0, 1),
(4411, '波纹', '', '波纹', 100, 0, 1),
(4412, 'BA0653', '', 'BA0653', 100, 0, 1),
(4413, '13087', '', '13087', 100, 0, 1),
(4414, '边领', '', '边领', 100, 0, 1),
(4415, '风水', '', '风水', 100, 0, 2),
(4416, 'AD1861', '', 'AD1861', 100, 0, 1),
(4417, '莉娅', '', '莉娅', 100, 0, 1),
(4418, '135E4B290', '', '135E4B290', 100, 0, 1),
(4419, '肩章', '', '肩章', 100, 0, 2),
(4420, 'piece', '', 'piece', 100, 0, 1),
(4421, 'one', '', 'one', 100, 0, 1),
(4422, '阿甘', '', '阿甘', 100, 0, 2),
(4423, '双包', '', '双包', 100, 0, 1),
(4424, '跑鞋', '', '跑鞋', 100, 0, 1),
(4425, '炮弹', '', '炮弹', 100, 0, 2),
(4426, '公鸡', '', '公鸡', 100, 0, 1),
(4427, '固执', '', '固执', 100, 0, 1),
(4428, '2092', '', '2092', 100, 0, 1),
(4429, '03', '', '03', 100, 0, 1),
(4430, 'AP', '', 'AP', 100, 0, 1),
(4431, '丽娜', '', '丽娜', 100, 0, 1),
(4432, '生日礼品', '', '生日礼品', 100, 0, 2),
(4433, '3048', '', '3048', 100, 0, 1),
(4434, '满钻爆', '', '满钻爆', 100, 0, 1),
(4435, 'TX085', '', 'TX085', 100, 0, 1),
(4436, '猫和老鼠', '', '猫和老鼠', 100, 0, 0),
(4437, '女靴', '', '女靴', 100, 0, 5),
(4438, '雪地', '', '雪地', 100, 0, 1),
(4439, 'L100', '', 'L100', 100, 0, 1),
(4440, 'L30173', '', 'L30173', 100, 0, 1),
(4441, 'AA1429', '', 'AA1429', 100, 0, 1),
(4442, '韩版亮', '', '韩版亮', 100, 0, 1),
(4443, 'Gladys', '', 'Gladys', 100, 0, 1),
(4444, 'Kathy', '', 'Kathy', 100, 0, 1),
(4445, '挂坠', '', '挂坠', 100, 0, 1),
(4446, '许愿', '', '许愿', 100, 0, 1),
(4447, '专用', '', '专用', 100, 0, 1),
(4448, 'HUMMI2013', '', 'HUMMI2013', 100, 0, 1),
(4449, '三彩', '', '三彩', 100, 0, 2),
(4450, '浮动', '', '浮动', 100, 0, 1),
(4451, '翡翠', '', '翡翠', 100, 0, 1),
(4452, 'r13B6042', '', 'r13B6042', 100, 0, 1),
(4453, 'TS83', '', 'TS83', 100, 0, 1),
(4454, '儿童节', '', '儿童节', 100, 0, 1),
(4455, '趣味', '', '趣味', 100, 0, 1),
(4456, '衣裳', '', '衣裳', 100, 0, 1),
(4458, 'KZ214', '', 'KZ214', 100, 0, 1),
(4459, 'Layered', '', 'Layered', 100, 0, 1),
(4460, 'tulle', '', 'tulle', 100, 0, 1),
(4461, '男生', '', '男生', 100, 0, 1),
(4462, '小个子', '', '小个子', 100, 0, 0),
(4463, '特平', '', '特平', 100, 0, 1),
(4464, '安吉', '', '安吉', 100, 0, 1),
(4465, '金石', '', '金石', 100, 0, 3),
(4466, 'SY874', '', 'SY874', 100, 0, 1),
(4467, '前后', '', '前后', 100, 0, 1),
(4468, 'DA793', '', 'DA793', 100, 0, 1),
(4469, 'L20042', '', 'L20042', 100, 0, 1),
(4470, '铁塔', '', '铁塔', 100, 0, 1),
(4471, '母子', '', '母子', 100, 0, 1),
(4472, '弧形', '', '弧形', 100, 0, 1),
(4473, '2013LANUOS', '', '2013LANUOS', 100, 0, 1),
(4474, '荧光粉', '', '荧光粉', 100, 0, 1),
(4475, '实用', '', '实用', 100, 0, 1),
(4476, 'Baker', '', 'Baker', 100, 0, 1),
(4477, '瑰丽', '', '瑰丽', 100, 0, 1),
(4478, '鲜艳', '', '鲜艳', 100, 0, 1),
(4479, 'BA0515', '', 'BA0515', 100, 0, 1),
(4480, 'skgirl', '', 'skgirl', 100, 0, 1),
(4481, 'D021', '', 'D021', 100, 0, 1),
(4482, '皮卡丘', '', '皮卡丘', 100, 0, 1),
(4483, '人网', '', '人网', 100, 0, 1),
(4484, '淘宝', '', '淘宝', 100, 0, 1),
(4485, '花纱', '', '花纱', 100, 0, 1),
(4486, '3194', '', '3194', 100, 0, 1),
(4487, '原价', '', '原价', 100, 0, 1),
(4488, 'Z2077', '', 'Z2077', 100, 0, 1),
(4489, '0948', '', '0948', 100, 0, 1),
(4490, '套衫', '', '套衫', 100, 0, 1),
(4491, '棒针', '', '棒针', 100, 0, 1),
(4492, 'F128', '', 'F128', 100, 0, 1),
(4493, '漂流', '', '漂流', 100, 0, 1),
(4494, '3905', '', '3905', 100, 0, 1),
(4495, 'lena', '', 'lena', 100, 0, 1),
(4496, '红蓝', '', '红蓝', 100, 0, 1),
(4497, '格调', '', '格调', 100, 0, 1),
(4498, 'Doice', '', 'Doice', 100, 0, 1),
(4499, 'Vita', '', 'Vita', 100, 0, 1),
(4500, '男友', '', '男友', 100, 0, 2),
(4501, '激光', '', '激光', 100, 0, 1),
(4502, 'A23622', '', 'A23622', 100, 0, 1),
(4503, '花小', '', '花小', 100, 0, 1),
(4504, '裤长', '', '裤长', 100, 0, 2),
(4505, '278', '', '278', 100, 0, 1),
(4506, 'MIRROR', '', 'MIRROR', 100, 0, 1),
(4507, 'FUN', '', 'FUN', 100, 0, 1),
(4508, '整机', '', '整机', 100, 0, 0),
(4509, 'L10033', '', 'L10033', 100, 0, 1),
(4510, 'n7100', '', 'n7100', 100, 0, 0),
(4511, '879', '', '879', 100, 0, 1),
(4512, 'YM', '', 'YM', 100, 0, 1),
(4513, 'DE23L', '', 'DE23L', 100, 0, 1),
(4514, '桃色', '', '桃色', 100, 0, 1),
(4515, '袖子', '', '袖子', 100, 0, 1),
(4516, '特别', '', '特别', 100, 0, 1),
(4517, '6321', '', '6321', 100, 0, 1),
(4518, '黛青', '', '黛青', 100, 0, 1),
(4519, '大衣', '', '大衣', 100, 0, 2),
(4520, '穿法', '', '穿法', 100, 0, 1),
(4521, 'viviandrea', '', 'viviandrea', 100, 0, 1),
(4522, '乔安', '', '乔安', 100, 0, 1),
(4523, 'Joannekitten', '', 'Joannekitten', 100, 0, 1),
(4524, '思力', '', '思力', 100, 0, 1),
(4525, 'Q130303', '', 'Q130303', 100, 0, 1),
(4526, '608', '', '608', 100, 0, 1),
(4527, 'AA2559', '', 'AA2559', 100, 0, 1),
(4528, 'M1897', '', 'M1897', 100, 0, 1),
(4529, '玻璃球', '', '玻璃球', 100, 0, 1),
(4530, 'M1036', '', 'M1036', 100, 0, 1),
(4531, '盛典', '', '盛典', 100, 0, 1),
(4532, '年度', '', '年度', 100, 0, 1),
(4533, '大星', '', '大星', 100, 0, 1),
(4534, 'Memory', '', 'Memory', 100, 0, 1),
(4535, '1989', '', '1989', 100, 0, 1),
(4536, '暴龙', '', '暴龙', 100, 0, 0),
(4537, '法老', '', '法老', 100, 0, 1),
(4538, '法老王', '', '法老王', 100, 0, 1),
(4539, 'AA2254', '', 'AA2254', 100, 0, 1),
(4540, '健康', '', '健康', 100, 0, 0),
(4541, '3266', '', '3266', 100, 0, 1),
(4542, '花生', '', '花生', 100, 0, 1),
(4543, '星辰', '', '星辰', 100, 0, 1),
(4544, '1794', '', '1794', 100, 0, 1),
(4545, '韩版北', '', '韩版北', 100, 0, 1),
(4546, '权志', '', '权志', 100, 0, 1),
(4547, '线春', '', '线春', 100, 0, 1),
(4548, '马克', '', '马克', 100, 0, 1),
(4549, 'S6076', '', 'S6076', 100, 0, 1),
(4550, '毛线衣', '', '毛线衣', 100, 0, 1),
(4551, '龙猫', '', '龙猫', 100, 0, 1),
(4552, '吃货', '', '吃货', 100, 0, 1),
(4553, '饭桶', '', '饭桶', 100, 0, 1),
(4554, 'TOTORO', '', 'TOTORO', 100, 0, 1),
(4555, '464', '', '464', 100, 0, 1),
(4556, 'dhh2013', '', 'dhh2013', 100, 0, 1),
(4557, '夏夜', '', '夏夜', 100, 0, 1),
(4558, '昆虫', '', '昆虫', 100, 0, 1),
(4559, 'Chic', '', 'Chic', 100, 0, 1),
(4560, 'Holy', '', 'Holy', 100, 0, 1),
(4561, '马杰克', '', '马杰克', 100, 0, 1),
(4562, '情人', '', '情人', 100, 0, 1),
(4563, '3030', '', '3030', 100, 0, 1),
(4564, '中空', '', '中空', 100, 0, 1),
(4565, 'AG311', '', 'AG311', 100, 0, 1),
(4566, 'LOBAQUE', '', 'LOBAQUE', 100, 0, 1),
(4567, '月份', '', '月份', 100, 0, 1),
(4618, '绒毛', '', '绒毛', 100, 0, 1),
(4619, 'Array', '', 'Array', 100, 0, 694),
(4620, 'Guciheaven7897', '', 'Guciheaven7897', 100, 0, 1),
(4621, '女子', '', '女子', 100, 0, 1),
(4622, '翻毛', '', '翻毛', 100, 0, 1),
(4623, '棉鞋', '', '棉鞋', 100, 0, 1),
(4624, '如水', '', '如水', 100, 0, 1),
(4625, '打蜡', '', '打蜡', 100, 0, 1),
(4626, '一席之地', '', '一席之地', 100, 0, 1),
(4627, '大头鞋', '', '大头鞋', 100, 0, 3),
(4628, '2014vivi', '', '2014vivi', 100, 0, 1),
(4629, '男款', '', '男款', 100, 0, 5),
(4630, '洛克', '', '洛克', 100, 0, 3),
(4631, '流布', '', '流布', 100, 0, 1),
(4632, '大洋洲', '', '大洋洲', 100, 0, 1),
(4633, '轻质', '', '轻质', 100, 0, 1),
(4634, '袋鼠', '', '袋鼠', 100, 0, 2),
(4635, '美英', '', '美英', 100, 0, 1),
(4636, '韩版欧', '', '韩版欧', 100, 0, 1),
(4637, '耐磨', '', '耐磨', 100, 0, 1),
(4638, '克罗', '', '克罗', 100, 0, 1),
(4639, 'les', '', 'les', 100, 0, 1),
(4640, '王老', '', '王老', 100, 0, 1),
(4641, '懒虫', '', '懒虫', 100, 0, 1),
(4642, '尔康', '', '尔康', 100, 0, 1),
(4643, '小白', '', '小白', 100, 0, 3),
(4644, '平价', '', '平价', 100, 0, 1),
(4645, '世子', '', '世子', 100, 0, 1),
(4646, '中低', '', '中低', 100, 0, 2),
(4647, '口头', '', '口头', 100, 0, 1),
(4648, '土黄色', '', '土黄色', 100, 0, 1),
(4649, '头皮', '', '头皮', 100, 0, 1),
(4650, '全真', '', '全真', 100, 0, 1),
(4651, '古奇', '', '古奇', 100, 0, 1),
(4652, '天伦', '', '天伦', 100, 0, 1),
(4653, 'FOREST', '', 'FOREST', 100, 0, 1),
(4654, '中平', '', '中平', 100, 0, 1),
(4655, '大头', '', '大头', 100, 0, 1),
(4656, '皮套', '', '皮套', 100, 0, 1),
(4657, '志同', '', '志同', 100, 0, 1),
(4658, '图米', '', '图米', 100, 0, 1),
(4659, '西武', '', '西武', 100, 0, 1),
(4660, '小圆', '', '小圆', 100, 0, 1),
(4661, '行风', '', '行风', 100, 0, 1),
(4662, '花酒', '', '花酒', 100, 0, 1),
(4663, '范日系', '', '范日系', 100, 0, 1),
(4664, '2014', '', '2014', 100, 0, 31),
(4665, '风度', '', '风度', 100, 0, 1),
(4666, '主婚', '', '主婚', 100, 0, 1),
(4667, '滑板鞋', '', '滑板鞋', 100, 0, 2),
(4668, '苏小', '', '苏小', 100, 0, 1),
(4669, '虎头鞋', '', '虎头鞋', 100, 0, 1),
(4670, '学步', '', '学步', 100, 0, 1),
(4671, '平地', '', '平地', 100, 0, 1),
(4672, '春天', '', '春天', 100, 0, 1),
(4673, '软底鞋', '', '软底鞋', 100, 0, 1),
(4674, 'Miya', '', 'Miya', 100, 0, 1),
(4675, '洞洞', '', '洞洞', 100, 0, 1),
(4676, '底版', '', '底版', 100, 0, 1),
(4677, '聚酯', '', '聚酯', 100, 0, 1),
(4678, 'KangaRoos', '', 'KangaRoos', 100, 0, 1),
(4679, '相伴', '', '相伴', 100, 0, 1),
(4680, '跟脚', '', '跟脚', 100, 0, 1),
(4681, '马蹄', '', '马蹄', 100, 0, 1),
(4682, '泰和', '', '泰和', 100, 0, 1),
(4683, '男单', '', '男单', 100, 0, 1),
(4684, '街头时尚', '', '街头时尚', 100, 0, 1),
(4685, '迷糊', '', '迷糊', 100, 0, 1),
(4686, '男装', '', '男装', 100, 0, 7),
(4687, '新品上市', '', '新品上市', 100, 0, 1),
(4688, 'Vanila', '', 'Vanila', 100, 0, 1),
(4689, '小天鹅', '', '小天鹅', 100, 0, 1),
(4690, '裤袜', '', '裤袜', 100, 0, 1),
(4691, '边波点', '', '边波点', 100, 0, 1),
(4692, '半截', '', '半截', 100, 0, 1),
(4693, '巴拉', '', '巴拉', 100, 0, 1),
(4694, '子午', '', '子午', 100, 0, 1),
(4695, '表情', '', '表情', 100, 0, 1),
(4696, '风汉', '', '风汉', 100, 0, 1),
(4697, '中式', '', '中式', 100, 0, 1),
(4698, '中国', '', '中国', 100, 0, 1),
(4699, 'R33C66', '', 'R33C66', 100, 0, 1),
(4700, '小麦', '', '小麦', 100, 0, 2),
(4701, '深色', '', '深色', 100, 0, 2),
(4702, '荷花', '', '荷花', 100, 0, 1),
(4703, '皮草', '', '皮草', 100, 0, 1),
(4704, '呢料', '', '呢料', 100, 0, 1),
(4705, '8411600784', '', '8411600784', 100, 0, 1),
(4706, '榴莲', '', '榴莲', 100, 0, 1),
(4707, '福字', '', '福字', 100, 0, 1),
(4708, '麻绳', '', '麻绳', 100, 0, 1),
(4709, '8321500181', '', '8321500181', 100, 0, 1),
(4710, 'channel', '', 'channel', 100, 0, 3),
(4711, '灯芯绒', '', '灯芯绒', 100, 0, 5),
(4712, '慵懒', '', '慵懒', 100, 0, 1),
(4713, '磨边', '', '磨边', 100, 0, 1),
(4714, '草人', '', '草人', 100, 0, 1),
(4715, '布衣', '', '布衣', 100, 0, 1),
(4716, '阿卡', '', '阿卡', 100, 0, 1),
(4717, 'SA10239Q', '', 'SA10239Q', 100, 0, 1),
(4718, '牛仔衫', '', '牛仔衫', 100, 0, 1),
(4719, '尖尖', '', '尖尖', 100, 0, 1),
(4720, 'T0481', '', 'T0481', 100, 0, 1),
(4721, 'V8321800764', '', 'V8321800764', 100, 0, 1),
(4722, '盘扣', '', '盘扣', 100, 0, 1),
(4723, '特斯', '', '特斯', 100, 0, 1),
(4724, '邦威', '', '邦威', 100, 0, 1),
(4725, '牌价', '', '牌价', 100, 0, 1),
(4726, '橡筋', '', '橡筋', 100, 0, 1),
(4727, '太平', '', '太平', 100, 0, 2),
(4728, '分割', '', '分割', 100, 0, 1),
(4729, '8413310464', '', '8413310464', 100, 0, 1),
(4730, '麻纱', '', '麻纱', 100, 0, 1),
(4731, '所向', '', '所向', 100, 0, 1),
(4732, '书童', '', '书童', 100, 0, 1),
(4733, '8413340569', '', '8413340569', 100, 0, 1),
(4734, 'V8321800887', '', 'V8321800887', 100, 0, 1),
(4735, '妹妹', '', '妹妹', 100, 0, 1),
(4736, '裤脚', '', '裤脚', 100, 0, 1),
(4737, '黄鸭', '', '黄鸭', 100, 0, 1);
INSERT INTO `le_goods_tags` (`tag_id`, `tag_name`, `img`, `tag_code`, `sort`, `is_hot`, `count`) VALUES
(4738, '毛茸茸', '', '毛茸茸', 100, 0, 1),
(4739, '小船', '', '小船', 100, 0, 2),
(4740, 'tanimism', '', 'tanimism', 100, 0, 1),
(4741, '梭织', '', '梭织', 100, 0, 1),
(4742, '金金', '', '金金', 100, 0, 1),
(4743, '达人', '', '达人', 100, 0, 1),
(4744, '毛衫', '', '毛衫', 100, 0, 1),
(4745, '艾衣', '', '艾衣', 100, 0, 1),
(4746, '裙装', '', '裙装', 100, 0, 1),
(4747, '安哥拉', '', '安哥拉', 100, 0, 1),
(4748, '娃娃领', '', '娃娃领', 100, 0, 1),
(4749, '', ' ', '', 100, 0, 0),
(4750, '测试', ' ', '测试', 100, 0, 0),
(4751, '好的', ' ', '好的', 100, 0, 0),
(4752, 'FP33080662', '', 'FP33080662', 100, 0, 1),
(4753, 'INXX', '', 'INXX', 100, 0, 1),
(4754, '套裙', '', '套裙', 100, 0, 1),
(4755, '束腰', '', '束腰', 100, 0, 1),
(4756, '国小', '', '国小', 100, 0, 2),
(4757, '新装', '', '新装', 100, 0, 2),
(4758, '亮丽', '', '亮丽', 100, 0, 10),
(4759, 'Sasan', '', 'Sasan', 100, 0, 3),
(4760, '码洋', '', '码洋', 100, 0, 1),
(4761, '流行时尚', '', '流行时尚', 100, 0, 1),
(4762, '年末', '', '年末', 100, 0, 1),
(4763, 'Q0388', '', 'Q0388', 100, 0, 1),
(4764, '范】', '', '范】', 100, 0, 1),
(4765, '定位', '', '定位', 100, 0, 1),
(4766, '1380', '', '1380', 100, 0, 1),
(4767, '耐克', '', '耐克', 100, 0, 20),
(4768, '男子', '', '男子', 100, 0, 20),
(4769, '631656', '', '631656', 100, 0, 20),
(4770, 'NIKE', '', 'NIKE', 100, 0, 20),
(4771, '047', '', '047', 100, 0, 20),
(4772, '福克斯', '', '福克斯', 100, 0, 2),
(4773, '别克', '', '别克', 100, 0, 2),
(4774, '鲁兹', '', '鲁兹', 100, 0, 2),
(4775, '把套', '', '把套', 100, 0, 2),
(4776, '冰丝', '', '冰丝', 100, 0, 2),
(4777, '方向盘套', '', '方向盘套', 100, 0, 2),
(4778, '凯越', '', '凯越', 100, 0, 2),
(4779, '兰多', '', '兰多', 100, 0, 1),
(4780, '超级', '', '超级', 100, 0, 1),
(4781, '左边', '', '左边', 100, 0, 1),
(4782, '小人', '', '小人', 100, 0, 1),
(4783, '纷扬', '', '纷扬', 100, 0, 1),
(4784, 'G032400', '', 'G032400', 100, 0, 1),
(4785, '开开', '', '开开', 100, 0, 1),
(4786, '白包', '', '白包', 100, 0, 1),
(4787, '自留', '', '自留', 100, 0, 1),
(4788, '和服', '', '和服', 100, 0, 1),
(4789, '情趣内衣', '', '情趣内衣', 100, 0, 2),
(4790, '角色扮演', '', '角色扮演', 100, 0, 1),
(4791, '制服', '', '制服', 100, 0, 1),
(4792, '吊袜带', '', '吊袜带', 100, 0, 1),
(4793, '薄纱', '', '薄纱', 100, 0, 1),
(4794, '罩杯', '', '罩杯', 100, 0, 1),
(4795, '蒂娜', '', '蒂娜', 100, 0, 1),
(4796, 'YSDN15569', '', 'YSDN15569', 100, 0, 1),
(4797, '雅戈尔', '', '雅戈尔', 100, 0, 1),
(4798, '蜜桃', '', '蜜桃', 100, 0, 1),
(4799, '学院派', '', '学院派', 100, 0, 1),
(4800, '白搭', '', '白搭', 100, 0, 2),
(4801, '1141010260', '', '1141010260', 100, 0, 1),
(4802, 'NJ3091', '', 'NJ3091', 100, 0, 1),
(4803, '直营', '', '直营', 100, 0, 1),
(4804, '罗西尼', '', '罗西尼', 100, 0, 1),
(4805, '机芯', '', '机芯', 100, 0, 1),
(4806, '不锈钢', '', '不锈钢', 100, 0, 1),
(4807, '机械', '', '机械', 100, 0, 1),
(4808, '淘宝网', '', '淘宝网', 100, 0, 18),
(4809, '我喜欢', '', '我喜欢', 100, 0, 3),
(4810, '陈冠希', '', '陈冠希', 100, 0, 1),
(4811, '反绒', '', '反绒', 100, 0, 2),
(4812, '千层底', '', '千层底', 100, 0, 1),
(4813, '绣花鞋', '', '绣花鞋', 100, 0, 1),
(4814, '特步', '', '特步', 100, 0, 1),
(4815, '子平', '', '子平', 100, 0, 1),
(4816, '杀价', '', '杀价', 100, 0, 1),
(4817, '颠覆', '', '颠覆', 100, 0, 1),
(4818, '砂皮', '', '砂皮', 100, 0, 1),
(4819, '风磨', '', '风磨', 100, 0, 1),
(4820, '马丁', '', '马丁', 100, 0, 2),
(4821, '迟放', '', '迟放', 100, 0, 2),
(4822, '阿木', '', '阿木', 100, 0, 1),
(4823, '里外', '', '里外', 100, 0, 1),
(4824, '子夜', '', '子夜', 100, 0, 1),
(4825, '花花', '', '花花', 100, 0, 1),
(4826, '版心', '', '版心', 100, 0, 1),
(4827, '棉裤', '', '棉裤', 100, 0, 1),
(4828, 'Jieer', '', 'Jieer', 100, 0, 1),
(4829, '圆弧', '', '圆弧', 100, 0, 1),
(4830, 'FASHION', '', 'FASHION', 100, 0, 1),
(4831, '韩后', '', '韩后', 100, 0, 2),
(4832, '十全十美', '', '十全十美', 100, 0, 1),
(4833, '去眼袋', '', '去眼袋', 100, 0, 1),
(4834, '玲珑', '', '玲珑', 100, 0, 1),
(4835, '2332920', '', '2332920', 100, 0, 1),
(4836, 'ulzzang', '', 'ulzzang', 100, 0, 1),
(4837, 'KAKASA', '', 'KAKASA', 100, 0, 1),
(4838, 'korea', '', 'korea', 100, 0, 1),
(4839, '薄外套', ' ', '薄外套', 100, 0, 0),
(4840, '蕾丝衫', ' ', '蕾丝衫', 100, 0, 0),
(4841, '长袖T', ' ', '长袖T', 100, 0, 0),
(4842, '无袖衫', ' ', '无袖衫', 100, 0, 0),
(4843, '棒球衫', ' ', '棒球衫', 100, 0, 0),
(4844, '花朵衫', ' ', '花朵衫', 100, 0, 0),
(4845, '314361006', '', '314361006', 100, 0, 1),
(4846, 'VeroModa', '', 'VeroModa', 100, 0, 1),
(4847, '200', '', '200', 100, 0, 1),
(4848, '尖头鞋', ' ', '尖头鞋', 100, 0, 0),
(4849, '圆头鞋', ' ', '圆头鞋', 100, 0, 0),
(4850, '粗跟鞋', ' ', '粗跟鞋', 100, 0, 0),
(4851, '方头鞋', ' ', '方头鞋', 100, 0, 0),
(4852, '漆皮鞋', ' ', '漆皮鞋', 100, 0, 0),
(4853, '牛津鞋', ' ', '牛津鞋', 100, 0, 0),
(4854, '水钻单鞋', ' ', '水钻单鞋', 100, 0, 0),
(4855, '今日', '', '今日', 100, 0, 1),
(4856, 'SPF20', '', 'SPF20', 100, 0, 1),
(4857, '汗水', '', '汗水', 100, 0, 1),
(4858, '金瓶', '', '金瓶', 100, 0, 1),
(4859, '安耐晒', '', '安耐晒', 100, 0, 1),
(4860, '防辐射', '', '防辐射', 100, 0, 1),
(4861, 'SPF25', '', 'SPF25', 100, 0, 1),
(4862, '奇缘', '', '奇缘', 100, 0, 1),
(4863, '绽放', '', '绽放', 100, 0, 1),
(4864, '包装', '', '包装', 100, 0, 1),
(4865, '魔法', '', '魔法', 100, 0, 1);

-- --------------------------------------------------------

--
-- 表的结构 `le_group`
--

DROP TABLE IF EXISTS `le_group`;
CREATE TABLE IF NOT EXISTS `le_group` (
  `groupid` int(11) NOT NULL AUTO_INCREMENT COMMENT '小组ID',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `groupname` char(32) NOT NULL DEFAULT '' COMMENT '群组名字',
  `groupname_en` char(32) NOT NULL DEFAULT '' COMMENT '小组英文名称',
  `groupdesc` text NOT NULL COMMENT '小组介绍',
  `path` char(32) NOT NULL DEFAULT '' COMMENT '图标路径',
  `groupicon` char(100) DEFAULT '' COMMENT '小组图标',
  `count_topic` int(11) NOT NULL DEFAULT '0' COMMENT '帖子统计',
  `count_topic_today` int(11) NOT NULL DEFAULT '0' COMMENT '统计今天发帖',
  `count_user` int(11) NOT NULL DEFAULT '0' COMMENT '小组成员数',
  `joinway` tinyint(1) NOT NULL DEFAULT '0' COMMENT '加入方式',
  `role_leader` char(32) NOT NULL DEFAULT '组长' COMMENT '组长角色名称',
  `role_admin` char(32) NOT NULL DEFAULT '管理员' COMMENT '管理员角色名称',
  `role_user` char(32) NOT NULL DEFAULT '成员' COMMENT '成员角色名称',
  `addtime` int(11) DEFAULT '0' COMMENT '创建时间',
  `isrecommend` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否推荐',
  `isopen` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否公开或者私密',
  `isaudit` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否审核',
  `ispost` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否允许会员发帖',
  `isshow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `uptime` int(11) NOT NULL DEFAULT '0' COMMENT '最后更新时间',
  PRIMARY KEY (`groupid`),
  KEY `userid` (`userid`),
  KEY `isshow` (`isshow`),
  KEY `groupname` (`groupname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='小组' AUTO_INCREMENT=3 ;

--
-- 转存表中的数据 `le_group`
--

INSERT INTO `le_group` (`groupid`, `userid`, `groupname`, `groupname_en`, `groupdesc`, `path`, `groupicon`, `count_topic`, `count_topic_today`, `count_user`, `joinway`, `role_leader`, `role_admin`, `role_user`, `addtime`, `isrecommend`, `isopen`, `isaudit`, `ispost`, `isshow`, `uptime`) VALUES
(1, 1, '主题', '', '向大家打包推荐一系列的宝贝。凡是通过你创作的主题而产生购买的，宝贝相应的佣金也全部归你', '', 'cache/groupicon/80/86eb9cd9f9_80_80.jpg', 3, 2, 1, 0, '组长', '管理员', '成员', 1376537188, 1, 0, 0, 0, 0, 1396338185),
(2, 1, '开学季', '', '开学季，书包等！', '', 'cache/groupicon/80/fc894d37a6_80_80.jpg', 0, 0, 1, 0, '组长', '管理员', '成员', 1377564743, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- 表的结构 `le_group_cates`
--

DROP TABLE IF EXISTS `le_group_cates`;
CREATE TABLE IF NOT EXISTS `le_group_cates` (
  `cateid` int(11) NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `catename` char(32) NOT NULL DEFAULT '' COMMENT '分类名字',
  `catereferid` int(11) NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `count_group` int(11) NOT NULL DEFAULT '0' COMMENT '群组个数',
  `uptime` int(11) NOT NULL DEFAULT '0' COMMENT '最后更新时间',
  PRIMARY KEY (`cateid`),
  KEY `referid` (`catereferid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `le_group_cates_index`
--

DROP TABLE IF EXISTS `le_group_cates_index`;
CREATE TABLE IF NOT EXISTS `le_group_cates_index` (
  `groupid` int(11) NOT NULL DEFAULT '0' COMMENT '小组ID',
  `cateid` int(11) NOT NULL DEFAULT '0' COMMENT '分类ID',
  UNIQUE KEY `groupid_2` (`groupid`,`cateid`),
  KEY `groupid` (`groupid`),
  KEY `cateid` (`cateid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='小组分类索引';

-- --------------------------------------------------------

--
-- 表的结构 `le_group_links`
--

DROP TABLE IF EXISTS `le_group_links`;
CREATE TABLE IF NOT EXISTS `le_group_links` (
  `groupid` int(11) NOT NULL DEFAULT '0',
  `linkid` int(11) NOT NULL DEFAULT '0',
  KEY `groupid` (`groupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `le_group_options`
--

DROP TABLE IF EXISTS `le_group_options`;
CREATE TABLE IF NOT EXISTS `le_group_options` (
  `optionname` char(12) NOT NULL DEFAULT '' COMMENT '选项名字',
  `optionvalue` char(255) NOT NULL DEFAULT '' COMMENT '选项内容',
  UNIQUE KEY `optionname` (`optionname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='配置';

--
-- 转存表中的数据 `le_group_options`
--

INSERT INTO `le_group_options` (`optionname`, `optionvalue`) VALUES
('appname', '讨论'),
('appdesc', '乐兔淘讨论'),
('isenable', '0'),
('iscreate', '0'),
('isaudit', '0'),
('iscate', '1'),
('ismode', '0');

-- --------------------------------------------------------

--
-- 表的结构 `le_group_topics`
--

DROP TABLE IF EXISTS `le_group_topics`;
CREATE TABLE IF NOT EXISTS `le_group_topics` (
  `topicid` int(11) NOT NULL AUTO_INCREMENT COMMENT '话题ID',
  `typeid` int(11) NOT NULL DEFAULT '0' COMMENT '帖子分类ID,0代表普通，1代表主题讨论帖',
  `groupid` int(11) NOT NULL DEFAULT '0' COMMENT '小组ID',
  `themeid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `title` char(64) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `count_comment` int(11) NOT NULL DEFAULT '0' COMMENT '回复统计',
  `count_view` int(11) NOT NULL DEFAULT '0' COMMENT '帖子展示数',
  `count_attach` int(11) NOT NULL DEFAULT '0' COMMENT '统计附件',
  `istop` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否置顶',
  `isshow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `iscomment` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否允许评论',
  `isphoto` tinyint(1) NOT NULL DEFAULT '0',
  `isattach` tinyint(1) NOT NULL DEFAULT '0',
  `isnotice` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否通知',
  `isposts` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否精华帖子',
  `isask` tinyint(1) DEFAULT '0',
  `addtime` int(11) DEFAULT '0' COMMENT '创建时间',
  `uptime` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`topicid`),
  KEY `groupid` (`groupid`),
  KEY `userid` (`userid`),
  KEY `title` (`title`),
  KEY `groupid_2` (`groupid`,`isshow`),
  KEY `typeid` (`typeid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='小组话题' AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `le_group_topics`
--

-- --------------------------------------------------------

--
-- 表的结构 `le_group_topics_collects`
--

DROP TABLE IF EXISTS `le_group_topics_collects`;
CREATE TABLE IF NOT EXISTS `le_group_topics_collects` (
  `userid` int(11) NOT NULL DEFAULT '0',
  `topicid` int(11) NOT NULL DEFAULT '0',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '收藏时间',
  UNIQUE KEY `userid_2` (`userid`,`topicid`),
  KEY `userid` (`userid`),
  KEY `topicid` (`topicid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='帖子收藏';

-- --------------------------------------------------------

--
-- 表的结构 `le_group_topics_comments`
--

DROP TABLE IF EXISTS `le_group_topics_comments`;
CREATE TABLE IF NOT EXISTS `le_group_topics_comments` (
  `commentid` int(11) NOT NULL AUTO_INCREMENT COMMENT '评论ID',
  `referid` int(11) NOT NULL DEFAULT '0',
  `topicid` int(11) NOT NULL DEFAULT '0' COMMENT '话题ID',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `content` text NOT NULL COMMENT '回复内容',
  `addtime` int(11) DEFAULT '0' COMMENT '回复时间',
  `showflag` int(2) DEFAULT NULL,
  PRIMARY KEY (`commentid`),
  KEY `topicid` (`topicid`),
  KEY `userid` (`userid`),
  KEY `referid` (`referid`,`topicid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='话题回复/评论' AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `le_group_topics_comments`
--

-- --------------------------------------------------------

--
-- 表的结构 `le_group_topics_type`
--

DROP TABLE IF EXISTS `le_group_topics_type`;
CREATE TABLE IF NOT EXISTS `le_group_topics_type` (
  `typeid` int(11) NOT NULL AUTO_INCREMENT COMMENT '帖子分类ID',
  `groupid` int(11) NOT NULL DEFAULT '0' COMMENT '小组ID',
  `typename` char(32) NOT NULL DEFAULT '' COMMENT '帖子分类名称',
  `count_topic` int(11) NOT NULL DEFAULT '0' COMMENT '统计帖子',
  PRIMARY KEY (`typeid`),
  KEY `groupid` (`groupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='帖子分类' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `le_group_users`
--

DROP TABLE IF EXISTS `le_group_users`;
CREATE TABLE IF NOT EXISTS `le_group_users` (
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `groupid` int(11) NOT NULL DEFAULT '0' COMMENT '群组ID',
  `isadmin` int(11) NOT NULL DEFAULT '0' COMMENT '是否管理员',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '加入时间',
  UNIQUE KEY `userid_2` (`userid`,`groupid`),
  KEY `userid` (`userid`),
  KEY `groupid` (`groupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='群组和用户对应关系';

--
-- 转存表中的数据 `le_group_users`
--


-- --------------------------------------------------------

--
-- 表的结构 `le_home_info`
--

DROP TABLE IF EXISTS `le_home_info`;
CREATE TABLE IF NOT EXISTS `le_home_info` (
  `infoid` int(11) NOT NULL AUTO_INCREMENT,
  `infokey` char(32) NOT NULL DEFAULT '',
  `infocontent` text NOT NULL,
  PRIMARY KEY (`infoid`),
  UNIQUE KEY `infokey` (`infokey`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- 转存表中的数据 `le_home_info`
--

INSERT INTO `le_home_info` (`infoid`, `infokey`, `infocontent`) VALUES
(1, 'about', '<p>乐兔淘购物分享系统是一款基于PHP+MYSQL技术架构的购物分享社区系统，经过2年精心研发与升级，现可以为大中型网站以及个人站长提供分享购物社区系统的解决方案，并得到一致好评。</p>\r\n<p>乐兔淘购物分享系统它综合当下热门流行的Pinterest类购物分享模式开发的一款非常易用的购物分享社区系统。</p>\r\n<p>乐兔淘购物分享系统可用于建设淘宝客网站、社会化电子商务网站、商品展示网站、淘宝店铺推广网站、兴趣类或话题类网站。他的最大特点是可直接通过淘宝商品链接一键分享商品和强大的后台一键采集商品功能，可轻松获取想要展示或要分享的商品。</p>\r\n<p>系统的每一个操作流程都是经过精心策划的，在充分考虑到系统执行效率前提下，系统广泛应用了当前最流行的AJAX技术，以简化操作流程和提升用户体验。同时系统也实现了前后台完全分离，静态文件和动态程序完全分离，并且针对常见安全漏洞采取了防范措施。数据库方面我们采用了最优化的程序算法、高速的缓存机制，支持千万级数据量和分布式部署等系列实用与高效的功能。</p>\r\n\r\n<p>购买授权：<a target="_blank" href="http://www.tuntron.com/buy.html">点击查看授权费用</a></p>\r\n\r\n<p>售前客服：<a target="_blank" href="http://wpa.qq.com/msgrd?v=3&uin=860260016&site=qq&menu=yes"><img border="0" src="http://wpa.qq.com/pa?p=2:860260016:42" alt="点击这里给我发消息" title="点击这里给我发消息"></a></p>\r\n<p>售后服务：<a target="_blank" href="http://wpa.qq.com/msgrd?v=3&uin=2696933386&site=qq&menu=yes"><img border="0" src="http://wpa.qq.com/pa?p=2:2696933386:42" alt="点击这里给我发消息" title="点击这里给我发消息"></a></p>\r\n<p>单项服务：<a target="_blank" href="http://wpa.qq.com/msgrd?v=3&uin=706700559&site=qq&menu=yes"><img border="0" src="http://wpa.qq.com/pa?p=2:706700559:42" alt="点击这里给我发消息" title="点击这里给我发消息"></a></p>'),
(2, 'contact', '<p>购买授权：<a target="_blank" href="http://www.tuntron.com/buy.html">点击查看授权费用</a></p>\r\n<p>地 址：安徽省黄山市屯溪区黄山中路49号E区北侧12-14</p>\r\n<p>电 话：0559-2324349（9：00-18：00）</p>\r\n<p>传 真：0559-2324340</p>\r\n<p>Email：admin@tuntron.com</p>\r\n<p>售前客服：<a target="_blank" href="http://wpa.qq.com/msgrd?v=3&uin=860260016&site=qq&menu=yes"><img border="0" src="http://wpa.qq.com/pa?p=2:860260016:42" alt="点击这里给我发消息" title="点击这里给我发消息"></a></p>\r\n<p>售后服务：<a target="_blank" href="http://wpa.qq.com/msgrd?v=3&uin=2696933386&site=qq&menu=yes"><img border="0" src="http://wpa.qq.com/pa?p=2:2696933386:42" alt="点击这里给我发消息" title="点击这里给我发消息"></a></p>\r\n<p>单项服务：<a target="_blank" href="http://wpa.qq.com/msgrd?v=3&uin=706700559&site=qq&menu=yes"><img border="0" src="http://wpa.qq.com/pa?p=2:706700559:42" alt="点击这里给我发消息" title="点击这里给我发消息"></a></p>\r\n\r\n<p>商家权益？</p>\r\n<p>1） 参加我们在全网推广的超过100个的运营活动计划，共享超过1亿精准用户流量。</p>\r\n<p>2） 拥有一个与我们用户互动的商家小站，了解详情</p>\r\n<p>3） 享受被我们收录的商品在本站上优先展示（排名靠前，优先推荐等）</p>\r\n<p>4） 采用淘宝客CPS付费模式，无报名费，无赞助成本，0风险</p>\r\n<p>广告投放</p>\r\n<p>1） 本站内(首焦，频道等），360导航、qzone、微博、网盟及其它站外投放</p>\r\n<p>2） 预计到达活动页精准流量：全年超1亿流量，每场流量100万起</p>\r\n<p>报名要求</p>\r\n<p>1） 主营商品类目：女装、女鞋、包包、配饰</p>\r\n<p>2） 皇冠店或天猫店，店铺DSR评分行业平均及以上</p>\r\n<p>3） 淘宝客全店佣金大于等于20%（可对我们单独设置定向推广计划），佣金高者优先。 注：佣金比例和流量转化率会影响你的推广权重。</p>\r\n<p>4） 商家对我们的佣金定向计划至少保持1年以上。</p>'),
(3, 'agreement', '        <p><h3>计算机软件著作权保护的对象是什么？</h3></p>\r\n        <p>计算机软件著作权保护的对象是计算机软件，不延及开发软件所用的思想、处理过程、操作方法或者数学概念等。</p>\r\n        <p><h3>什么是计算机软件?</h3></p>\r\n        <p>计算机软件是指计算机程序及其有关文档。</p>\r\n        <p>计算机程序，是指为了得到某种结果而可以由计算机等具有信息处理能力的装置执行的代码化指令序列，或者可以被自动转换成代码化指令序列的符号化指令序列或者符号化语句序列。同一计算机程序的源程序和目标程序为同一作品。</p>\r\n        <p>文档，是指用来描述程序的内容、组成、设计、功能规格、开发情况、测试结果及使用方法的文字资料和图表等，如程序设计说明书、流程图、用户手册等。</p>\r\n\r\n      \r\n        <p><h3>如何确定软件著作权的归属？</h3></p>\r\n        \r\n          <p>软件著作权属于软件开发者，即属于实际组织开发、直接进行开发，并对开发完成的软件承担责任的法人或者其他组织；或者依靠自己具有的条件独立完成软件开发，并对软件承担责任的自然人。</p>\r\n          <p>合作开发的软件，其著作权的归属由合作开发者签订书面合同约定。无书面合同或者合同未作明确约定，合作开发的软件可以分割使用的，开发者对各自开发的部分可以单独享有著作权；合作开发的软件不能分割使用的，其著作权由各合作开发者共同享有。</p>\r\n          <p>接受他人委托开发的软件，其著作权的归属由委托人与受托人签订书面合同约定；无书面合同或者合同未作明确约定的，其著作权由受托人享有。</p>\r\n          <p>由国家机关下达任务开发的软件，著作权的归属与行使由项目任务书或者合同规定；项目任务书或者合同中未作明确规定的，软件著作权由接受任务的法人或者其他组织享有。</p>\r\n\r\n          <p>自然人在法人或者其他组织中任职期间所开发的软件有下列情形之一的，该软件著作权由该法人或者其他组织享有：<p></p>\r\n            \r\n              <p>针对本职工作中明确指定的开发目标所开发的软件；</p>\r\n              <p>开发的软件是从事本职工作活动所预见的结果或者自然的结果；</p>\r\n              <p>主要使用了法人或者其他组织的资金、专用设备、未公开的专门信息等物质技术条件所开发并由法人或者其他组织承担责任的软件。</p>\r\n            </ol>\r\n\r\n          </p>\r\n        </ol>\r\n        \r\n        <p><h3>软件著作权人享有哪些权利？</h3></p>\r\n        \r\n          <p>发表权，即决定软件是否公之于众的权利；</p>\r\n          <p>署名权，即表明开发者身份，在软件上署名的权利；</p>\r\n          <p>修改权，即对软件进行增补、删节，或者改变指令、语句顺序的权利；</p>\r\n\r\n          <p>复制权，即将软件制作一份或者多份的权利；</p>\r\n          <p>发行权，即以出售或者赠与方式向公众提供软件的原件或者复制件的权利；</p>\r\n          <p>出租权，即有偿许可他人临时使用软件的权利，但是软件不是出租的主要标的的除外；</p>\r\n          <p>信息网络传播权，即以有线或者无线方式向公众提供软件，使公众可以在其个人选定的时间和地点获得软件的权利；</p>\r\n          <p>翻译权，即将原软件从一种自然语言文字转换成另一种自然语言文字的权利；</p>\r\n          <p>应当由软件著作权人享有的其他权利。<br>软件著作权人可以许可他人行使其软件著作权，并有权获得报酬。<br>软件著作权人可以全部或者部分转让其软件著作权，并有权获得报酬。</p>\r\n\r\n        </ol>\r\n      \r\n        <p><h3>软件开发者开发的软件与已经存在的软件相似的，是否必然构成侵权？</h3></p>\r\n        <p>软件开发者开发的软件，由于可供选用的表达方式有限而与已经存在的软件相似的，不构成对已经存在的软件的著作权的侵犯。</p>\r\n      \r\n        <p><h3>在什么情况下使用计算机软件，可以不经软件著作权人许可，不向其支付报酬？</h3></p>\r\n        <p>为了学习和研究软件内含的设计思想和原理，通过安装、显示、传输或者存储软件等方式使用软件的，可以不经软件著作权人许可，不向其支付报酬。</p>\r\n      \r\n        <p><h3>在软件的合法复制品所有人享有哪些权利？</h3></p>\r\n\r\n        \r\n          <p>根据使用的需要把该软件装入计算机等具有信息处理能力的装置内；</p>\r\n          <p>为了防止复制品损坏而制作备份复制品；</p>\r\n          <p>为了把该软件用于实际的计算机应用环境或者改进其功能、性能而进行必要的修改。</p>\r\n        </ol>\r\n          \r\n        <p><h3>软件的复制品持有人不知道该软件是侵权复制品的，是否构成侵权？</h3></p>\r\n        <p>软件的复制品持有人不知道也没有合理理由应当知道该软件是侵权复制品的，不承担赔偿责任；但是，应当停止使用、销毁该侵权复制品。如果停止使用并销毁该侵权复制品将给复制品使用人造成重大损失的，复制品使用人可以在向软件著作权人支付合理费用后继续使用。</p>'),
(4, 'privacy', '乐兔淘购物分享社区，综合当下热门流行的分享购物模式开发的一款简单实用的购物分享社区系统。');

-- --------------------------------------------------------

--
-- 表的结构 `le_image_file`
--

DROP TABLE IF EXISTS `le_image_file`;
CREATE TABLE IF NOT EXISTS `le_image_file` (
  `imageid` int(11) NOT NULL AUTO_INCREMENT,
  `imageurl` char(120) NOT NULL DEFAULT '',
  `addtime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`imageid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='图片附件表' AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `le_image_file`
--


-- --------------------------------------------------------

--
-- 表的结构 `le_indexslide`
--

DROP TABLE IF EXISTS `le_indexslide`;
CREATE TABLE IF NOT EXISTS `le_indexslide` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '幻灯ID',
  `title` char(64) DEFAULT '' COMMENT '幻灯标题',
  `desc` text COMMENT '幻灯简介',
  `url` char(100) NOT NULL COMMENT '幻灯链接',
  `img` char(100) NOT NULL COMMENT '幻灯图片',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '幻灯排序',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='幻灯/广告' AUTO_INCREMENT=6 ;

--
-- 转存表中的数据 `le_indexslide`
--

INSERT INTO `le_indexslide` (`id`, `title`, `desc`, `url`, `img`, `sort`, `addtime`) VALUES
(1, '', '', 'http://www.letushuo.com/', 'cache/bigpic/20130814/1376473705.jpg', 0, 1377354337),
(2, '我的午后时光', '静谧的角落，明媚的阳光\r\n一杯热气腾腾的咖啡 \r\n 午后的时光总会镀上慵懒的味道\r\n  放慢脚步，享受这一切', 'http://www.letushuo.com/', 'cache/bigpic/20130824/1377354335.jpg', 0, 1377354337),
(3, '弄堂里的味道', '每天上学奔跑嬉闹的那条弄堂\r\n 每到放学热闹非凡的那条弄堂 \r\n多少少年时缤纷的梦想\r\n永远留在了那条记忆中的弄堂', 'http://www.letushuo.com/', 'cache/bigpic/20130814/1376473711.jpg', 0, 1377354337),
(5, '流浪，一路向西', '你有没有想过，有些事\r\n如果你现在不做，可能以后都没有机会再做了\r\n凤凰、敦煌、拉萨，向更远的西边\r\n一个背包，一台单反，一颗说走就走的心', 'http://www.letushuo.com/', 'cache/bigpic/20130814/1376473714.jpg', 0, 1377354337),
(4, '别怕秋老虎', '进入秋天，秋老虎又来横行霸道。\r\n它把一年里毒辣炎热的温度抛给了我们，\r\n于是，我们要奋起抵抗，\r\n坚决不能让秋老虎将我们打败！', 'http://www.letushuo.com/', 'cache/bigpic/20130814/1376473716.jpg', 0, 1377354337);

-- --------------------------------------------------------

--
-- 表的结构 `le_mail_options`
--

DROP TABLE IF EXISTS `le_mail_options`;
CREATE TABLE IF NOT EXISTS `le_mail_options` (
  `optionid` int(11) NOT NULL AUTO_INCREMENT COMMENT '选项ID',
  `optionname` char(12) NOT NULL DEFAULT '' COMMENT '选项名字',
  `optionvalue` char(255) NOT NULL DEFAULT '' COMMENT '选项内容',
  PRIMARY KEY (`optionid`),
  UNIQUE KEY `optionname` (`optionname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='配置' AUTO_INCREMENT=8 ;

--
-- 转存表中的数据 `le_mail_options`
--

INSERT INTO `le_mail_options` (`optionid`, `optionname`, `optionvalue`) VALUES
(1, 'appname', '邮件'),
(2, 'appdesc', '乐兔淘'),
(3, 'isenable', '0'),
(4, 'mailhost', 'smtp.qq.com'),
(5, 'mailport', '25'),
(6, 'mailuser', ''),
(7, 'mailpwd', '');

-- --------------------------------------------------------

--
-- 表的结构 `le_message`
--

DROP TABLE IF EXISTS `le_message`;
CREATE TABLE IF NOT EXISTS `le_message` (
  `messageid` int(11) NOT NULL AUTO_INCREMENT COMMENT '消息ID',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '发送用户ID',
  `touserid` int(11) NOT NULL DEFAULT '0' COMMENT '接收消息的用户ID',
  `content` text NOT NULL COMMENT '内容',
  `isread` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否已读',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`messageid`),
  KEY `touserid` (`touserid`,`isread`),
  KEY `userid` (`userid`,`touserid`,`isread`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='短消息表' AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `le_message`
--

-- --------------------------------------------------------

--
-- 表的结构 `le_mobileslide`
--
DROP TABLE IF EXISTS `le_mobileslide`;
CREATE TABLE IF NOT EXISTS `le_mobileslide` (
  `id` int(11) NOT NULL auto_increment COMMENT '幻灯ID',
  `title` char(64) default '' COMMENT '幻灯标题',
  `desc` text COMMENT '幻灯简介',
  `img` char(100) NOT NULL COMMENT '幻灯图片',
  `sort` int(11) NOT NULL default '0' COMMENT '幻灯排序',
  `addtime` int(11) NOT NULL default '0' COMMENT '创建时间',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='幻灯/广告' AUTO_INCREMENT=6 ;

--
-- 转存表中的数据 `le_mobileslide`
--

INSERT INTO `le_mobileslide` (`id`, `title`, `desc`, `img`, `sort`, `addtime`) VALUES
(1, '九块九包邮哦', '九块九', 'cache/bigpic/20141206/1417868666.jpg', 3, 1417870559),
(2, '冬季新款', '冬季', 'cache/bigpic/20141206/1417869843.jpg', 2, 1417870559),
(3, '优惠', '优惠', 'cache/bigpic/20141206/1417869965.jpg', 1, 1417870559),
(4, '双十二', '双十二', 'cache/bigpic/20141206/1417870048.jpg', 4, 1417870559);

-- --------------------------------------------------------

--
-- 表的结构 `le_mobile_cate`
--

DROP TABLE IF EXISTS `le_mobile_cate`;
CREATE TABLE IF NOT EXISTS `le_mobile_cate` (
  `cate_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `tbcateid` int(11) NOT NULL,
  `cate_name` varchar(80) DEFAULT '',
  `sort` int(11) DEFAULT '0',
  `is_nav` tinyint(1) NOT NULL DEFAULT '1',
  `img` varchar(1000) NOT NULL,
  PRIMARY KEY (`cate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- 转存表中的数据 `le_mobile_cate`
--

INSERT INTO `le_mobile_cate` (`cate_id`, `tbcateid`, `cate_name`, `sort`, `is_nav`, `img`) VALUES
(1, 2, '上装', 1, 0, 'cache/tag/20140317/1395000417.jpg'),
(2, 3, '下装', 2, 0, 'cache/tag/20140317/1395000430.jpg'),
(3, 4, '鞋子', 3, 0, 'cache/tag/20140317/1395000442.jpg'),
(4, 5, '包包', 4, 0, 'cache/tag/20140317/1395000472.jpg'),
(5, 6, '配饰', 5, 0, 'cache/tag/20140313/1394701663.png'),
(6, 7, '美妆', 6, 0, 'cache/tag/20140313/1394701733.jpg'),
(7, 8, '家居', 7, 0, 'cache/tag/20140313/1394701740.png');

-- --------------------------------------------------------

--
-- 表的结构 `le_mobile_options`
--

DROP TABLE IF EXISTS `le_mobile_options`;
CREATE TABLE IF NOT EXISTS `le_mobile_options` (
  `optionid` int(11) NOT NULL AUTO_INCREMENT COMMENT '选项ID',
  `optionname` char(32) NOT NULL DEFAULT '' COMMENT '选项名字',
  `optionvalue` char(255) NOT NULL DEFAULT '' COMMENT '选项内容',
  PRIMARY KEY (`optionid`),
  UNIQUE KEY `optionname` (`optionname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='手机配置' AUTO_INCREMENT=7 ;

--
-- 转存表中的数据 `le_mobile_options`
--

INSERT INTO `le_mobile_options` (`optionid`, `optionname`, `optionvalue`) VALUES
(1, 'name', '乐兔淘'),
(2, 'appkey', ''),
(3, 'logo', 'http://www.letushuo.com/images/logo-app.png'),
(4, 'about', '关于我们！'),
(5, 'andriod_down', 'http://www.tuntron.com/%E4%B9%90%E5%85%94%E6%B7%98-v1.0.apk'),
(6, 'ios_down', 'http://www.tuntron.com/%E4%B9%90%E5%85%94%E6%B7%98-v1.0.ipa');

-- --------------------------------------------------------

--
-- 表的结构 `le_order`
--

DROP TABLE IF EXISTS `le_order`;
CREATE TABLE IF NOT EXISTS `le_order` (
  `orderid` int(11) NOT NULL AUTO_INCREMENT,
  `orderkey` varchar(255) NOT NULL,
  `goodid` int(11) NOT NULL,
  `num` int(11) NOT NULL,
  `color` varchar(255) CHARACTER SET utf8 NOT NULL,
  `size` varchar(255) NOT NULL,
  `msg` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `addressid` int(11) NOT NULL,
  `flag` varchar(2) CHARACTER SET utf8 DEFAULT NULL,
  `addtime` int(11) DEFAULT NULL,
  PRIMARY KEY (`orderid`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `le_order`
--

-- --------------------------------------------------------

--
-- 表的结构 `le_pay_options`
--

DROP TABLE IF EXISTS `le_pay_options`;
CREATE TABLE IF NOT EXISTS `le_pay_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `account` varchar(255) NOT NULL,
  `alipay_key` varchar(255) NOT NULL,
  `parterid` varchar(255) NOT NULL,
  `service_type` int(2) NOT NULL,
  `description` longtext,
  `pay_method` int(2) DEFAULT NULL,
  `pay_rate` int(11) DEFAULT NULL,
  `pay_fix` int(11) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- 转存表中的数据 `le_pay_options`
--

INSERT INTO `le_pay_options` (`id`, `name`, `account`, `alipay_key`, `parterid`, `service_type`, `description`, `pay_method`, `pay_rate`, `pay_fix`, `code`) VALUES
(4, '支付宝', '70020765@qq.com', '', '', 0, '支付宝是国内领先的独立第三方支付平台，由阿里巴巴集团创办。致力于为中国电子商务提供"简单、安全、快速"的在线支付解决方案。', 0, 0, 0, 'Alipay');

-- --------------------------------------------------------

--
-- 表的结构 `le_photo`
--

DROP TABLE IF EXISTS `le_photo`;
CREATE TABLE IF NOT EXISTS `le_photo` (
  `photoid` int(11) NOT NULL AUTO_INCREMENT,
  `albumid` int(11) NOT NULL DEFAULT '0' COMMENT '相册ID',
  `userid` int(11) NOT NULL DEFAULT '0',
  `photoname` char(64) NOT NULL DEFAULT '',
  `phototype` char(32) NOT NULL DEFAULT '',
  `path` char(32) NOT NULL DEFAULT '' COMMENT '图片路径',
  `photourl` char(120) NOT NULL DEFAULT '',
  `photosize` char(32) NOT NULL DEFAULT '',
  `photodesc` char(120) NOT NULL DEFAULT '',
  `count_view` int(11) NOT NULL DEFAULT '0',
  `isrecommend` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0不推荐1推荐',
  `addtime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`photoid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `le_photo_album`
--

DROP TABLE IF EXISTS `le_photo_album`;
CREATE TABLE IF NOT EXISTS `le_photo_album` (
  `albumid` int(11) NOT NULL AUTO_INCREMENT COMMENT '相册ID',
  `userid` int(11) NOT NULL DEFAULT '0',
  `path` char(32) NOT NULL DEFAULT '' COMMENT '相册路径',
  `albumface` char(64) NOT NULL DEFAULT '' COMMENT '相册封面',
  `albumname` char(64) NOT NULL DEFAULT '',
  `albumdesc` varchar(400) NOT NULL DEFAULT '' COMMENT '相册介绍',
  `count_photo` int(11) NOT NULL DEFAULT '0',
  `count_view` int(11) NOT NULL DEFAULT '0',
  `isrecommend` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否推荐',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `uptime` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`albumid`),
  KEY `userid` (`userid`),
  KEY `isrecommend` (`isrecommend`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='相册' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `le_photo_comment`
--

DROP TABLE IF EXISTS `le_photo_comment`;
CREATE TABLE IF NOT EXISTS `le_photo_comment` (
  `commentid` int(11) NOT NULL AUTO_INCREMENT COMMENT '评论ID',
  `referid` int(11) NOT NULL DEFAULT '0',
  `photoid` int(11) NOT NULL DEFAULT '0' COMMENT '相册ID',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `content` char(255) NOT NULL DEFAULT '' COMMENT '回复内容',
  `addtime` int(11) DEFAULT '0' COMMENT '回复时间',
  PRIMARY KEY (`commentid`),
  KEY `userid` (`userid`),
  KEY `referid` (`referid`,`photoid`),
  KEY `photoid` (`photoid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='图片回复/评论' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `le_photo_options`
--

DROP TABLE IF EXISTS `le_photo_options`;
CREATE TABLE IF NOT EXISTS `le_photo_options` (
  `optionid` int(11) NOT NULL AUTO_INCREMENT COMMENT '选项ID',
  `optionname` char(16) NOT NULL DEFAULT '' COMMENT '选项名字',
  `optionvalue` char(255) NOT NULL DEFAULT '' COMMENT '选项内容',
  PRIMARY KEY (`optionid`),
  UNIQUE KEY `optionname` (`optionname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='配置' AUTO_INCREMENT=3 ;

--
-- 转存表中的数据 `le_photo_options`
--

INSERT INTO `le_photo_options` (`optionid`, `optionname`, `optionvalue`) VALUES
(1, 'appname', '相册'),
(2, 'appdesc', '相册APP');

-- --------------------------------------------------------

--
-- 表的结构 `le_pictorial`
--

DROP TABLE IF EXISTS `le_pictorial`;
CREATE TABLE IF NOT EXISTS `le_pictorial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(1000) NOT NULL DEFAULT '',
  `tag` varchar(1000) NOT NULL,
  `photo` varchar(1000) NOT NULL DEFAULT '',
  `width` varchar(32) NOT NULL DEFAULT '',
  `height` varchar(32) NOT NULL DEFAULT '',
  `addtime` int(11) NOT NULL DEFAULT '0',
  `bhnum` int(11) NOT NULL DEFAULT '0',
  `goodslink` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `referid` (`addtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='画报' AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `le_pictorial`
--

-- --------------------------------------------------------

--
-- 表的结构 `le_p_str`
--

DROP TABLE IF EXISTS `le_p_str`;
CREATE TABLE IF NOT EXISTS `le_p_str` (
  `pictorialId` int(11) NOT NULL AUTO_INCREMENT,
  `title` char(255) NOT NULL,
  `cateid` int(11) NOT NULL,
  `num` int(11) NOT NULL,
  `p_str` varchar(1000) NOT NULL DEFAULT '',
  `userid` int(11) NOT NULL DEFAULT '0',
  `is_im_index` int(1) NOT NULL DEFAULT '0',
  `is_im` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pictorialId`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='画报关联' AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `le_p_str`
--

-- --------------------------------------------------------

--
-- 表的结构 `le_search_key`
--

DROP TABLE IF EXISTS `le_search_key`;
CREATE TABLE IF NOT EXISTS `le_search_key` (
  `keyid` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT '0',
  `keyword` char(32) NOT NULL DEFAULT '',
  `addtime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`keyid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='搜索关键词' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `le_share_goods`
--

DROP TABLE IF EXISTS `le_share_goods`;
CREATE TABLE IF NOT EXISTS `le_share_goods` (
  `goods_id` int(11) NOT NULL AUTO_INCREMENT,
  `is_loc` int(1) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL,
  `themeid` int(10) DEFAULT '0',
  `comment` text DEFAULT NULL,
  `count_comment` int(11) DEFAULT '0',
  `count_view` int(11) DEFAULT '0',
  `count_like` int(11) DEFAULT '0',
  `count_worth` int(11) DEFAULT '0',
  `img` varchar(255) DEFAULT '',
  `img_w` int(10) DEFAULT NULL,
  `img_h` int(10) DEFAULT NULL,
  `oldimg_w` int(10) DEFAULT NULL,
  `oldimg_h` int(10) DEFAULT NULL,
  `simg` varchar(100) DEFAULT NULL,
  `simg_170` varchar(100) DEFAULT '',
  `simg_str` text,
  `smimg` varchar(100) DEFAULT NULL,
  `bigpic` varchar(100) DEFAULT NULL,
  `oldimg` text,
  `bd_oldimg` varchar(100) DEFAULT NULL,
  `name` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `price` decimal(10,2) DEFAULT '0.00',
  `coupon_price` decimal(10,2) DEFAULT '0.00',
  `coupon_start_time` int(11) DEFAULT '0',
  `coupon_end_time` int(11) DEFAULT '0',
  `cate_id` int(11) NOT NULL DEFAULT '0',
  `taoke_url` varchar(1024) DEFAULT '',
  `istop` tinyint(1) DEFAULT '0',
  `sort` smallint(5) DEFAULT '10',
  `seller_credit_score` int(2) DEFAULT '0',
  `shop_info` varchar(1024) DEFAULT NULL,
  `uptime` int(11) DEFAULT '0',
  `content` longtext DEFAULT NULL,
  `mobile_today` tinyint(1) NOT NULL default '0',
  `size` varchar(255) DEFAULT NULL,
  `color` varchar(255) DEFAULT NULL,
  `salenum` int(11) DEFAULT NULL,
  PRIMARY KEY (`goods_id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- 转存表中的数据 `le_share_goods`
--

INSERT INTO `le_share_goods` (`goods_id`, `is_loc`, `uid`, `themeid`, `comment`, `count_comment`, `count_view`, `count_like`, `count_worth`, `img`, `img_w`, `img_h`, `oldimg_w`, `oldimg_h`, `simg`, `simg_170`, `simg_str`, `smimg`, `bigpic`, `oldimg`, `bd_oldimg`, `name`, `url`, `price`, `coupon_price`, `coupon_start_time`, `coupon_end_time`, `cate_id`, `taoke_url`, `istop`, `sort`, `seller_credit_score`, `shop_info`, `uptime`, `content`, `size`, `color`, `salenum`) VALUES
(5, 1, 0, 0, NULL, 0, 12, 0, 0, 'cache/thumb/index/20140520/rRcG3KVqxbLiVbw210.jpg', NULL, 210, 460, 460, NULL, '', NULL, NULL, NULL, 'cache/bigpic/20140520/1400551516.jpg', NULL, '2014夏季爆款女装甜美时尚流行气质修身无袖雪纺小衫', '', '49.00', '0.00', 0, 0, 0, '', 0, 10, 0, '0', 1400552389, '<img src="/letutaosvn/plugins/pubs/kindeditor/attached/image/20140520/20140520020956_32774.jpg" alt="" />', 'M,L,XL', '玫红,黑色,白色,黄色', 124),
(6, 0, 1, 0, '', 1, 0, 1, 0, 'cache/thumb/index/20140526/pDbmBxV2ZeI4lPw210.jpg', NULL, 210, NULL, NULL, NULL, '', NULL, NULL, NULL, 'http://gi3.md.alicdn.com/bao/uploaded/i3/18557023147695005/T1Ov5DXu0gXXXXXXXX_!!0-item_pic.jpg|http://gi1.md.alicdn.com/imgextra/i1/787688557/T2snibXlXcXXXXXXXX_!!787688557.jpg|http://gi2.md.alicdn.com/imgextra/i2/787688557/T2G.qhXSBXXXXXXXXX_!!787688557.jpg|http://gi3.md.alicdn.com/imgextra/i3/787688557/T2ySGhXSRXXXXXXXXX_!!787688557.jpg|http://gi1.md.alicdn.com/imgextra/i1/787688557/T2qC1hXShXXXXXXXXX_!!787688557.jpg|', NULL, '美诗欧2014夏装女装韩版撞色雪纺衫薄荷绿短袖衬衫小上衣2332920', 'http://item.taobao.com/item.htm?id=23781716676', '389.00', '0.00', 0, 0, 2, '', 0, 10, 0, 'N;', 1401119538, NULL, NULL, NULL, NULL),
(7, 0, 1, 0, '', 0, 1, 0, 0, 'cache/thumb/index/20140526/3ffmNj1f8DiQ3Iw210.jpg', NULL, 210, 480, 480, NULL, '', NULL, NULL, NULL, 'http://img02.taobaocdn.com/bao/uploaded/i2/T1.g5hFEtoXXXXXXXX_!!0-item_pic.jpg|http://img03.taobaocdn.com/imgextra/i3/214607717/T22BRwX2daXXXXXXXX_!!214607717.jpg|', NULL, '▲KAKASA韩国korea直送ulzzang东大门小格子娃娃衫雪纺衫淘宝网', 'http://item.taobao.com/item.htm?id=39107913615', '85.00', '0.00', 0, 0, 2, '', 0, 10, 0, 'N;', 1401119979, NULL, NULL, NULL, NULL),
(8, 0, 1, 0, '', 0, 1, 1, 0, 'cache/thumb/index/20140527/DF5Nusovs4Au1dw210.jpg', NULL, 210, 458, 458, NULL, '', NULL, NULL, NULL, 'http://img01.taobaocdn.com/bao/uploaded/i1/T1aNpCFRhcXXXXXXXX_!!0-item_pic.jpg|', NULL, '阿依莲2014春夏新款女装韩版衣裙蕾丝网纱刺绣七分袖雪纺上衣女淘宝网', 'http://item.taobao.com/item.htm?id=38644832507', '176.00', '0.00', 0, 0, 2, '', 0, 10, 0, 'N;', 1401120406, NULL, NULL, NULL, NULL),
(9, 0, 1, 0, '', 0, 0, 0, 0, 'cache/thumb/index/20140527/Rx6F4yZPFaCnZWw210.jpg', NULL, 210, NULL, NULL, NULL, '', NULL, NULL, NULL, 'http://img02.taobaocdn.com/bao/uploaded/i2/T1fxe_FUNXXXXXXXXX_!!0-item_pic.jpg|http://img02.taobaocdn.com/imgextra/i2/1089144034/T2Z7VAX5hXXXXXXXXX_!!1089144034.jpg|http://img04.taobaocdn.com/imgextra/i4/1089144034/T2xdBBX4xXXXXXXXXX_!!1089144034.jpg|http://img04.taobaocdn.com/imgextra/i4/1089144034/T2UAFBX1FXXXXXXXXX_!!1089144034.jpg|http://img04.taobaocdn.com/imgextra/i4/1089144034/T28XRDXWxXXXXXXXXX_!!1089144034.jpg|', NULL, '2014夏装新款女版清新显瘦！蝙蝠袖宽松大版纯色套头雪纺衫淘宝网', 'http://item.taobao.com/item.htm?id=39116524907', '77.00', '0.00', 0, 0, 2, '', 0, 10, 0, 'N;', 1401120515, NULL, NULL, NULL, NULL),
(10, 0, 1, 0, '', 0, 0, 0, 0, 'cache/thumb/index/20140527/4iSsIzfAR4dmsmw210.jpg', NULL, 210, NULL, NULL, NULL, '', NULL, NULL, NULL, 'http://img01.taobaocdn.com/bao/uploaded/i1/T1m1rFFpxeXXXXXXXX_!!0-item_pic.jpg|http://img01.taobaocdn.com/imgextra/i1/T1tpCiFA8cXXXXXXXX_!!0-item_pic.jpg|http://img01.taobaocdn.com/imgextra/i1/866137709/T2MBYYXrXaXXXXXXXX-866137709.jpg|http://img01.taobaocdn.com/imgextra/i1/866137709/T27YY0XzlXXXXXXXXX-866137709.jpg|', NULL, '波点雪纺衫上衣女春装新款韩版修身宽松七分袖泡泡袖配饰雪纺衫淘宝网', 'http://item.taobao.com/item.htm?id=37872575892', '158.00', '0.00', 0, 0, 2, '', 0, 10, 0, 'N;', 1401120578, NULL, NULL, NULL, NULL),
(11, 0, 1, 0, '', 0, 0, 0, 0, 'cache/thumb/index/20140527/2Ox2FO0O2O5828w210.jpg', NULL, 205, NULL, NULL, NULL, '', NULL, NULL, NULL, 'http://img02.taobaocdn.com/bao/uploaded/i2/T1pe98FNBcXXXXXXXX_!!0-item_pic.jpg|', NULL, '2014春夏新款后背拉链雪纺背心无袖雪纺衫女上衣夏3色入淘宝网', 'http://item.taobao.com/item.htm?id=38876396504', '49.00', '0.00', 0, 0, 2, '', 0, 10, 0, 'N;', 1401120747, NULL, NULL, NULL, NULL),
(12, 0, 1, 0, '', 4, 1, 1, 0, 'cache/thumb/index/20140527/0s09sBKa1A0q4aw210.jpg', NULL, 210, 600, 600, NULL, '', NULL, NULL, NULL, 'http://img04.taobaocdn.com/bao/uploaded/i4/T15v_RFQXbXXXXXXXX_!!0-item_pic.jpg|http://img02.taobaocdn.com/imgextra/i2/72846656/T2bW7OXN4aXXXXXXXX_!!72846656.jpg|http://img02.taobaocdn.com/imgextra/i2/72846656/T2rRESXMdXXXXXXXXX_!!72846656.jpg|http://img03.taobaocdn.com/imgextra/i3/72846656/T2guAPXMXXXXXXXXXX_!!72846656.jpg|http://img01.taobaocdn.com/imgextra/i1/72846656/T29mATXLhXXXXXXXXX_!!72846656.jpg|', NULL, '韩国代购名媛风露肩雪纺衫吊带甜美蛋糕层小洋装上衣淘宝网', 'http://item.taobao.com/item.htm?id=38966047308', '59.00', '0.00', 0, 0, 2, '', 0, 10, 0, 'N;', 1401121022, NULL, NULL, NULL, NULL),
(13, 0, 1, 0, '', 8, 2, 0, 0, 'cache/thumb/index/20140527/NW4zD88de4Z488w210.jpg', NULL, 210, 800, 800, NULL, '', NULL, NULL, NULL, 'http://img03.taobaocdn.com/bao/uploaded/i3/T1IFuXFzxhXXXXXXXX_!!0-item_pic.jpg|http://img04.taobaocdn.com/imgextra/i4/853587350/T2MVlmXZ0XXXXXXXXX_!!853587350.jpg|http://img03.taobaocdn.com/imgextra/i3/853587350/T2p59pXSXXXXXXXXXX_!!853587350.jpg|http://img04.taobaocdn.com/imgextra/i4/853587350/T2UXyqXK8XXXXXXXXX_!!853587350.jpg|http://img03.taobaocdn.com/imgextra/i3/853587350/T24LepXShXXXXXXXXX_!!853587350.jpg|http://img02.taobaocdn.com/imgextra/i2/853587350/T2M_uoXGhaXXXXXXXX_!!853587350.jpg|', NULL, '2014夏装新款大码女装韩版打底雪纺衫衬衫气质显瘦蕾丝刺绣上衣女淘宝网', 'http://item.taobao.com/item.htm?id=38476107658', '298.00', '0.00', 0, 0, 2, '', 0, 10, 0, 'N;', 1401121133, NULL, NULL, NULL, NULL),
(14, 0, 1, 0, '', 0, 0, 1, 0, 'cache/thumb/index/20140527/pppNv4pa4mQe6Hw210.jpg', NULL, 210, NULL, NULL, NULL, '', NULL, NULL, NULL, 'http://img02.taobaocdn.com/bao/uploaded/i2/T1lyaLFzXbXXXXXXXX_!!0-item_pic.jpg|http://img04.taobaocdn.com/imgextra/i4/860932771/T2j8HuXyxXXXXXXXXX_!!860932771.jpg|', NULL, '包邮夏装新款韩版女打底背心无袖波浪边雪纺蕾丝衫吊带背心上衣淘宝网', 'http://item.taobao.com/item.htm?id=19280583087', '78.00', '0.00', 0, 0, 2, '', 0, 10, 0, 'N;', 1401121592, NULL, NULL, NULL, NULL);
-- --------------------------------------------------------

--
-- 表的结构 `le_share_goods_comments`
--

DROP TABLE IF EXISTS `le_share_goods_comments`;
CREATE TABLE IF NOT EXISTS `le_share_goods_comments` (
  `commentid` int(11) NOT NULL AUTO_INCREMENT COMMENT '评论ID',
  `referid` int(11) DEFAULT '0',
  `shareid` int(11) DEFAULT '0' COMMENT '分享ID',
  `userid` int(11) DEFAULT '0' COMMENT '用户ID',
  `content` text COMMENT '回复内容',
  `commentType` tinyint(1) DEFAULT '0',
  `addtime` int(11) DEFAULT '0' COMMENT '回复时间',
  PRIMARY KEY (`commentid`),
  KEY `shareid` (`shareid`),
  KEY `userid` (`userid`),
  KEY `referid` (`referid`,`shareid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='分享回复/评论' AUTO_INCREMENT=82 ;

--
-- 转存表中的数据 `le_share_goods_comments`
--

INSERT INTO `le_share_goods_comments` (`commentid`, `referid`, `shareid`, `userid`, `content`, `commentType`, `addtime`) VALUES
(1, 0, 6, 0, '倪***巧|||很好哦，尺码都合适，发货也快，客服回答的很详细很有耐心，有介绍朋友来买，赞', 0, 1400761778),
(2, 0, 12, 0, 'hy7730|||收到衣服很惊艳，衣服好漂亮，质量也很好，值了，颜色会稍微深一点点，但依旧很美，不会显黑', 0, 1400160229),
(3, 0, 12, 0, '泡***冻|||有色差，更喜欢图片上的深红色，实物颜色也可以接受', 0, 1400674707),
(4, 0, 12, 0, 'tb1458892_2012|||有一点点大大的感觉  可能衣服就是这样设计的吧   只等烈日炎炎的时候穿啦   总体还可以&middot;&middot;', 0, 1400298252),
(5, 0, 12, 0, '林楚莹lcy23|||不错', 0, 1401086649),
(6, 0, 13, 0, '夏***8|||衣服面料很好是雪纺纱的.穿着凉快.颜色很正.没色差.是我喜欢的款式和面料.只是压得比较皱不过还是值得.好评!', 0, 1398582935),
(7, 0, 13, 0, '精灵meinv|||老板你好，货早收到了，特地等穿完在来评价的。雪纺的摸起很舒服，面料也很柔和，穿起很合身，也很凉爽，物流挺快的，我很喜欢，祝老板生意兴隆。<br/>\n', 0, 1400843626),
(8, 0, 13, 0, 'wang_lijuan82619|||老板你好，货昨天收到的，今天穿着去上班同事们都说好漂亮，说我会买东西，雪纺的摸起很舒服，面料也很柔和，穿起很合身，也很凉爽，物流挺快的，我很喜欢，祝老板生意兴隆。', 0, 1399976927),
(9, 0, 13, 0, 'c***s|||今天接到的宝贝  很漂亮 做工精细  尤其是刺绣的地方 非常漂亮哦 雪纺柔柔的 速度也很快 赞个', 0, 1400581649),
(10, 0, 13, 0, 'x***n|||发的第一件袖口一大一小，找到卖家二话不说就给换了货。态度满分！！换货的衣服拿到了，上身试穿了效果不错。我155高44公斤 买的m码刚刚好，给后面的mm一个参考', 0, 1400327462),
(11, 0, 13, 0, '雨淋7212992|||衣服收到了,衣服面料很好是雪纺纱的..颜色很正.没色差.是我喜欢的款式和面料,袖子的蕾丝是亮点，穿上不显胖，开始还以为是宽松的，不是很宽松，大小刚好。很显身材，', 0, 1400584189),
(12, 0, 13, 0, '刘涵旭66|||衣服质量相当好，比想像的要好，面料柔软，穿起来合身舒服，，这么好又这么便宜的衣服是有史以来最满意的一次网购,非常满意，推荐大家购买<br/>\n<br/>\n', 0, 1399632024),
(13, 0, 13, 0, 'l***1|||宝贝收到了，质量很好，给好评啦，质量好，面料舒服，效果不错，价格贵了.....尺寸小了，客服也很耐心，以后有新款记得给推荐哦。。。。', 0, 1399643228);

-- --------------------------------------------------------

--
-- 表的结构 `le_share_goods_like`
--

DROP TABLE IF EXISTS `le_share_goods_like`;
CREATE TABLE IF NOT EXISTS `le_share_goods_like` (
  `userid` int(11) NOT NULL DEFAULT '0',
  `goods_id` int(11) NOT NULL DEFAULT '0',
  `commentType` tinyint(2) NOT NULL DEFAULT '0',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '喜欢时间',
  KEY `userid` (`userid`),
  KEY `goods_id` (`goods_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='喜欢的分享';

--
-- 转存表中的数据 `le_share_goods_like`
--

-- --------------------------------------------------------

--
-- 表的结构 `le_share_theme_like`
--

DROP TABLE IF EXISTS `le_share_theme_like`;
CREATE TABLE IF NOT EXISTS `le_share_theme_like` (
  `userid` int(11) NOT NULL DEFAULT '0',
  `themeid` int(11) NOT NULL DEFAULT '0',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '喜欢时间',
  KEY `userid` (`userid`),
  KEY `themeid` (`themeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='喜欢的主题';

-- --------------------------------------------------------

--
-- 表的结构 `le_system_options`
--

DROP TABLE IF EXISTS `le_system_options`;
CREATE TABLE IF NOT EXISTS `le_system_options` (
  `optionid` int(11) NOT NULL AUTO_INCREMENT COMMENT '选项ID',
  `optionname` char(32) NOT NULL DEFAULT '' COMMENT '选项名字',
  `optionvalue` char(255) NOT NULL DEFAULT '' COMMENT '选项内容',
  PRIMARY KEY (`optionid`),
  UNIQUE KEY `optionname` (`optionname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='系统管理配置' AUTO_INCREMENT=34 ;

--
-- 转存表中的数据 `le_system_options`
--

INSERT INTO `le_system_options` (`optionid`, `optionname`, `optionvalue`) VALUES
(1, 'site_title', '乐兔淘2.7'),
(2, 'site_subtitle', '发现宝贝、收藏喜欢、分享美丽'),
(3, 'site_url', 'http://127.0.0.1/'),
(4, 'site_email', 'admin@admin.com'),
(6, 'site_icp', '苏ICP备11052261号'),
(7, 'isface', '0'),
(8, 'site_key', '乐兔淘,letutao,橙创'),
(9, 'site_desc', '乐兔淘购物分享'),
(10, 'site_theme', 'miliao'),
(11, 'site_urltype', '1'),
(12, 'isgzip', ''),
(13, 'timezone', 'Asia/Hong_Kong'),
(14, 'lang', ''),
(15, 'site_sinaweibo', 'http://weibo.com/tuntron'),
(16, 'site_qqweibo', 'http://t.qq.com/tuntron'),
(17, 'PID', '14370356'),
(18, 'AppKey', '12369186'),
(19, 'AppSecret', '5d31a6bf340c5119a292457f932a40c9'),
(20, 'site_checkcode', ''),
(21, 'site_lication', ''),
(22, 'lic_username', ''),
(23, 'site_indexcut', 'index'),
(24, 'bigpic', '0'),
(25, 'isucenter', '0'),
(26, 'goodlink', 'goodid'),
(27, 'is_open', '1'),
(28, 'close_tip', '系统维护中...'),
(29, 'tdj_PID', 'mm_14370356_4056781_13206339'),
(30, 'liststyle', 'pin'),
(31, 'site_Logo', ''),
(32, 'site_bottomLogo', ''),
(33, 'collecttype', '0');

-- --------------------------------------------------------

--
-- 表的结构 `le_tag`
--

DROP TABLE IF EXISTS `le_tag`;
CREATE TABLE IF NOT EXISTS `le_tag` (
  `tagid` int(11) NOT NULL AUTO_INCREMENT,
  `tagname` char(16) NOT NULL DEFAULT '',
  `count_user` int(11) NOT NULL DEFAULT '0',
  `count_group` int(11) NOT NULL DEFAULT '0',
  `count_topic` int(11) NOT NULL DEFAULT '0',
  `count_bang` int(11) NOT NULL DEFAULT '0',
  `count_article` int(11) NOT NULL DEFAULT '0',
  `isenable` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否可用',
  `uptime` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tagid`),
  UNIQUE KEY `tagname` (`tagname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `le_tag_article_index`
--

DROP TABLE IF EXISTS `le_tag_article_index`;
CREATE TABLE IF NOT EXISTS `le_tag_article_index` (
  `articleid` int(11) NOT NULL DEFAULT '0' COMMENT '帖子ID',
  `tagid` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `articleid_2` (`articleid`,`tagid`),
  KEY `articleid` (`articleid`),
  KEY `tagid` (`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `le_tag_default_goods`
--

DROP TABLE IF EXISTS `le_tag_default_goods`;
CREATE TABLE IF NOT EXISTS `le_tag_default_goods` (
  `goods_id` int(11) NOT NULL DEFAULT '0' COMMENT '分享ID',
  `tagid` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `goods_id_2` (`goods_id`,`tagid`),
  KEY `goods_id` (`goods_id`),
  KEY `tagid` (`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `le_tag_default_goods`
--


-- --------------------------------------------------------

--
-- 表的结构 `le_tag_group_index`
--

DROP TABLE IF EXISTS `le_tag_group_index`;
CREATE TABLE IF NOT EXISTS `le_tag_group_index` (
  `groupid` int(11) NOT NULL DEFAULT '0',
  `tagid` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `groupid_2` (`groupid`,`tagid`),
  KEY `groupid` (`groupid`),
  KEY `tagid` (`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `le_tag_share_goods`
--

DROP TABLE IF EXISTS `le_tag_share_goods`;
CREATE TABLE IF NOT EXISTS `le_tag_share_goods` (
  `goods_id` int(11) NOT NULL DEFAULT '0' COMMENT '分享ID',
  `tagid` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `goods_id_2` (`goods_id`,`tagid`),
  KEY `goods_id` (`goods_id`),
  KEY `tagid` (`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `le_tag_share_goods`
--

INSERT INTO `le_tag_share_goods` (`goods_id`, `tagid`) VALUES
(6, 59),
(6, 347),
(6, 804),
(6, 808),
(6, 835),
(6, 874),
(6, 1492),
(7, 59),
(7, 801),
(7, 881),
(7, 1225),
(8, 35),
(8, 586),
(8, 854),
(8, 1353),
(9, 59),
(9, 804),
(9, 842),
(10, 59),
(10, 809),
(10, 845),
(10, 967),
(11, 11),
(11, 35),
(11, 59),
(11, 809),
(12, 59),
(12, 753),
(12, 835),
(12, 870),
(12, 895),
(12, 922),
(12, 1256),
(12, 1509),
(13, 16),
(13, 59),
(13, 65),
(13, 586),
(13, 804),
(13, 808),
(13, 809),
(13, 835),
(13, 997),
(14, 11),
(14, 35),
(14, 65),
(14, 804),
(14, 835),
(14, 872),
(14, 958),
(14, 997);

-- --------------------------------------------------------

--
-- 表的结构 `le_tag_topic_index`
--

DROP TABLE IF EXISTS `le_tag_topic_index`;
CREATE TABLE IF NOT EXISTS `le_tag_topic_index` (
  `topicid` int(11) NOT NULL DEFAULT '0' COMMENT '帖子ID',
  `tagid` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `topicid_2` (`topicid`,`tagid`),
  KEY `topicid` (`topicid`),
  KEY `tagid` (`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `le_tag_user_index`
--

DROP TABLE IF EXISTS `le_tag_user_index`;
CREATE TABLE IF NOT EXISTS `le_tag_user_index` (
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `tagid` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `userid_2` (`userid`,`tagid`),
  KEY `userid` (`userid`),
  KEY `tagid` (`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- 表的结构 `le_theme`
--

DROP TABLE IF EXISTS `le_theme`;
CREATE TABLE IF NOT EXISTS `le_theme` (
  `themeid` int(11) NOT NULL AUTO_INCREMENT,
  `topicid` int(11) NOT NULL DEFAULT '0',
  `title` char(64) NOT NULL,
  `desc` char(200) NOT NULL DEFAULT '' COMMENT '主题描述',
  `cate` varchar(225) DEFAULT NULL COMMENT '分类id',
  `userid` int(11) NOT NULL COMMENT '创建者',
  `userjy` varchar(200) NOT NULL,
  `indextj` tinyint(4) NOT NULL DEFAULT '0',
  `goodsnum` int(11) NOT NULL DEFAULT '0' COMMENT '主题商品数',
  `strgoodid` varchar(1024) DEFAULT NULL,
  `likenum` int(11) DEFAULT '0',
  `istop` tinyint(1) NOT NULL DEFAULT '0',
  `recom` int(1) NOT NULL DEFAULT '0',
  `strtag` varchar(100) NOT NULL DEFAULT '',
  `topStyle` varchar(1024) DEFAULT NULL COMMENT '主题背景',
  `simg` varchar(225) DEFAULT NULL,
  `pageStyle` varchar(1024) DEFAULT NULL,
  `pagePhoto` varchar(255) DEFAULT NULL,
  `headerPhoto` varchar(255) DEFAULT NULL,
  `addtime` int(11) DEFAULT '0' COMMENT '添加时间',
  `uptime` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`themeid`),
  KEY `cate_id` (`cate`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='主题' AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `le_theme`
--

-- --------------------------------------------------------

--
-- 表的结构 `le_theme_cate`
--

DROP TABLE IF EXISTS `le_theme_cate`;
CREATE TABLE IF NOT EXISTS `le_theme_cate` (
  `cateid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL COMMENT '分类名',
  PRIMARY KEY (`cateid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='主题分类' AUTO_INCREMENT=3 ;

--
-- 转存表中的数据 `le_theme_cate`
--

INSERT INTO `le_theme_cate` (`cateid`, `name`) VALUES
(1, '连衣裙'),
(2, '裤子');

-- --------------------------------------------------------

--
-- 表的结构 `le_tuan`
--

DROP TABLE IF EXISTS `le_tuan`;
CREATE TABLE IF NOT EXISTS `le_tuan` (
  `tuanid` int(11) NOT NULL AUTO_INCREMENT COMMENT '团购ID',
  `cateid` int(11) NOT NULL DEFAULT '0' COMMENT '团购分类ID',
  `title` char(64) NOT NULL DEFAULT '' COMMENT '标题',
  `images` char(64) NOT NULL DEFAULT '' COMMENT '图片',
  `price_tuan` decimal(10,2) DEFAULT '0.00' COMMENT '团购价格',
  `price_market` decimal(10,2) DEFAULT '0.00' COMMENT '市场价格',
  `count_sold` int(11) NOT NULL DEFAULT '0' COMMENT '已购买数',
  `tuan_url` varchar(1024) DEFAULT '' COMMENT '转跳地址',
  `istop` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否置顶',
  `isshow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `addtime` int(11) DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`tuanid`),
  KEY `cateid` (`cateid`),
  KEY `title` (`title`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='团购' AUTO_INCREMENT=8 ;

--
-- 转存表中的数据 `le_tuan`
--

INSERT INTO `le_tuan` (`tuanid`, `cateid`, `title`, `images`, `price_tuan`, `price_market`, `count_sold`, `tuan_url`, `istop`, `isshow`, `addtime`) VALUES
(1, 1, '【裳品会+全国包邮】韩版字母印花套装1套，休闲运动透气有型', '/uploadfile/tuanfile/2013-05/35_1369129840.jpg', '59.00', '85.00', 532, 'http://gaopeng.qq.com/huangshan/deal/show/473907?channelid=14', 0, 0, 1369129840),
(2, 1, '精致复古的一款连衣裙', '/uploadfile/tuanfile/2013-05/70_1369150889.jpg', '54.00', '78.00', 167, 'http://item.taobao.com/item.htm?id=19561679725', 0, 0, 1369150889),
(3, 1, '红人最爱的复古高腰牛仔短裤！四色任选，显瘦得腿长，一年四季任何风格都可以hold住~！！', '/uploadfile/tuanfile/2013-05/7_1369151091.jpg', '39.00', '89.00', 5857, 'http://item.taobao.com/item.htm?id=23773104799', 0, 0, 1369151091),
(4, 2, '原价59元现仅需39.9元还包邮 2013最新夏季夹趾豹纹平底凉鞋', '/uploadfile/tuanfile/2013-05/45_1369151184.jpg', '39.90', '59.00', 666, 'http://item.taobao.com/item.htm?id=23612528128', 0, 0, 1369151184),
(5, 2, '亏本超值40元包邮 荧光色车菱格透气厚底懒人鞋', '/uploadfile/tuanfile/2013-05/68_1369151274.jpg', '40.00', '59.00', 103, 'http://item.taobao.com/item.htm?id=17897853691', 0, 0, 1369151274);

-- --------------------------------------------------------

--
-- 表的结构 `le_tuan_cate`
--

DROP TABLE IF EXISTS `le_tuan_cate`;
CREATE TABLE IF NOT EXISTS `le_tuan_cate` (
  `cate_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `cate_name` varchar(80) DEFAULT '',
  `is_nav` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`cate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- 转存表中的数据 `le_tuan_cate`
--

INSERT INTO `le_tuan_cate` (`cate_id`, `cate_name`, `is_nav`) VALUES
(1, '服饰', 1),
(2, '鞋子', 1),
(3, '包包', 1),
(4, '美妆', 1),
(5, '家居', 1),
(6, '美食', 1);

-- --------------------------------------------------------

--
-- 表的结构 `le_user`
--

DROP TABLE IF EXISTS `le_user`;
CREATE TABLE IF NOT EXISTS `le_user` (
  `userid` int(11) NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `pwd` char(32) NOT NULL DEFAULT '' COMMENT '用户密码',
  `salt` char(32) NOT NULL DEFAULT '' COMMENT '加点盐',
  `email` char(32) NOT NULL DEFAULT '' COMMENT '用户email',
  `resetpwd` char(32) NOT NULL DEFAULT '' COMMENT '重设密码',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `pwd` (`pwd`,`email`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='用户' AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `le_user`
--

-- --------------------------------------------------------

--
-- 表的结构 `le_user_follow`
--

DROP TABLE IF EXISTS `le_user_follow`;
CREATE TABLE IF NOT EXISTS `le_user_follow` (
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `userid_follow` int(11) NOT NULL DEFAULT '0' COMMENT '被关注的用户ID',
  `new` int(1) DEFAULT '1',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  UNIQUE KEY `userid_2` (`userid`,`userid_follow`),
  KEY `userid` (`userid`),
  KEY `userid_follow` (`userid_follow`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户关注跟随';

--
-- 转存表中的数据 `le_user_follow`
--


-- --------------------------------------------------------

--
-- 表的结构 `le_user_info`
--

DROP TABLE IF EXISTS `le_user_info`;
CREATE TABLE IF NOT EXISTS `le_user_info` (
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `ucid` int(11) NOT NULL DEFAULT '0' COMMENT 'Ucenter通信ID',
  `fuserid` int(11) NOT NULL DEFAULT '0' COMMENT '来自邀请用户',
  `username` char(32) NOT NULL DEFAULT '' COMMENT '用户名',
  `email` char(32) NOT NULL DEFAULT '',
  `sex` tinyint(1) NOT NULL DEFAULT '0' COMMENT '性别',
  `phone` char(16) NOT NULL DEFAULT '' COMMENT '电话号码',
  `roleid` int(11) NOT NULL DEFAULT '1' COMMENT '角色ID',
  `areaid` int(11) NOT NULL DEFAULT '0' COMMENT '区县ID',
  `darenid` int(11) DEFAULT '0',
  `path` char(32) NOT NULL DEFAULT '' COMMENT '头像路径',
  `face` char(64) NOT NULL DEFAULT '' COMMENT '会员头像',
  `net_face` varchar(64) DEFAULT NULL,
  `signed` char(64) NOT NULL DEFAULT '' COMMENT '签名',
  `blog` char(32) NOT NULL DEFAULT '' COMMENT '博客',
  `about` char(255) NOT NULL DEFAULT '' COMMENT '关于我',
  `ip` varchar(16) NOT NULL DEFAULT '' COMMENT '登陆IP',
  `address` char(64) NOT NULL DEFAULT '',
  `qq_openid` char(32) NOT NULL DEFAULT '',
  `qq_token` char(32) NOT NULL DEFAULT '',
  `qq_token2.0` char(32) NOT NULL DEFAULT '',
  `qq_secret` char(32) NOT NULL DEFAULT '',
  `qqt_oauth_token` char(32) NOT NULL DEFAULT '',
  `qqt_oauth_token_secret` char(32) NOT NULL DEFAULT '',
  `isqqt` tinyint(1) NOT NULL DEFAULT '0',
  `sina_access_token` char(64) NOT NULL DEFAULT '',
  `taobao_access_token` char(32) NOT NULL DEFAULT '',
  `count_score` int(11) NOT NULL DEFAULT '0' COMMENT '统计积分',
  `count_follow` int(11) NOT NULL DEFAULT '0' COMMENT '统计用户跟随的',
  `count_followed` int(11) NOT NULL DEFAULT '0' COMMENT '统计用户被跟随的',
  `isadmin` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否是管理员',
  `isenable` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否启用：0启用1禁用',
  `isverify` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未验证1验证',
  `verifycode` char(11) NOT NULL DEFAULT '' COMMENT '验证码',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `uptime` int(11) DEFAULT '0' COMMENT '登陆时间',
  `share_num` int(11) NOT NULL DEFAULT '0',
  `dianpu_num` int(11) NOT NULL DEFAULT '0',
  `goods_num` int(11) NOT NULL DEFAULT '0',
  `taobaoke` varchar(100) NOT NULL,
  `dp_QQ` int(20) NOT NULL,
  `dp_xlweibo` varchar(1000) NOT NULL,
  `dp_txweibo` varchar(1000) NOT NULL,
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `userid` (`userid`),
  UNIQUE KEY `username` (`username`),
  KEY `qq_openid` (`qq_openid`),
  KEY `fuserid` (`fuserid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户';

--
-- 转存表中的数据 `le_user_info`
--

-- --------------------------------------------------------

--
-- 表的结构 `le_user_invites`
--

DROP TABLE IF EXISTS `le_user_invites`;
CREATE TABLE IF NOT EXISTS `le_user_invites` (
  `inviteid` int(11) NOT NULL AUTO_INCREMENT,
  `invitecode` char(32) NOT NULL DEFAULT '' COMMENT '邀请码',
  `isused` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否使用',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`inviteid`),
  KEY `isused` (`isused`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户邀请码' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- 表的结构 `le_user_options`
--

DROP TABLE IF EXISTS `le_user_options`;
CREATE TABLE IF NOT EXISTS `le_user_options` (
  `optionid` int(11) NOT NULL AUTO_INCREMENT COMMENT '选项ID',
  `optionname` char(12) NOT NULL DEFAULT '' COMMENT '选项名字',
  `optionvalue` char(255) NOT NULL DEFAULT '' COMMENT '选项内容',
  PRIMARY KEY (`optionid`),
  UNIQUE KEY `optionname` (`optionname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='配置' AUTO_INCREMENT=10 ;

--
-- 转存表中的数据 `le_user_options`
--

INSERT INTO `le_user_options` (`optionid`, `optionname`, `optionvalue`) VALUES
(1, 'appname', '用户'),
(2, 'appdesc', '用户中心'),
(3, 'isenable', '0'),
(4, 'isregister', '0'),
(5, 'isvalidate', '0'),
(6, 'isrewrite', '0'),
(7, 'isauthcode', '0'),
(8, 'isgroup', ''),
(9, 'isfollow', '1');

-- --------------------------------------------------------

--
-- 表的结构 `le_user_role`
--

DROP TABLE IF EXISTS `le_user_role`;
CREATE TABLE IF NOT EXISTS `le_user_role` (
  `roleid` int(11) NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `rolename` char(32) NOT NULL DEFAULT '' COMMENT '角色名称',
  PRIMARY KEY (`roleid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='角色' AUTO_INCREMENT=18 ;

--
-- 转存表中的数据 `le_user_role`
--

INSERT INTO `le_user_role` (`roleid`, `rolename`) VALUES
(1, '列兵'),
(2, '下士'),
(3, '中士'),
(4, '上士'),
(5, '三级准尉'),
(6, '二级准尉'),
(7, '一级准尉'),
(8, '少尉'),
(9, '中尉'),
(10, '上尉'),
(11, '少校'),
(12, '中校'),
(13, '上校'),
(14, '准将'),
(15, '少将'),
(16, '中将'),
(17, '上将');

-- --------------------------------------------------------

--
-- 表的结构 `le_user_scores`
--

DROP TABLE IF EXISTS `le_user_scores`;
CREATE TABLE IF NOT EXISTS `le_user_scores` (
  `scoreid` int(11) NOT NULL AUTO_INCREMENT COMMENT '积分ID',
  `userid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `scorename` char(64) NOT NULL DEFAULT '' COMMENT '积分说明',
  `score` int(11) NOT NULL DEFAULT '0' COMMENT '得分',
  `addtime` int(11) NOT NULL DEFAULT '0' COMMENT '积分时间',
  PRIMARY KEY (`scoreid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='用户积分' AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `le_user_scores`
--

