<?php
defined('IN_TS') or die('Access Denied.');

class template {
	var $var_regexp = "\@?\\\$[a-zA-Z_][\\\$\w]*(?:\[[\w\-\.\"\'\[\]\$]+\])*";
	var $vtag_regexp = "\<\?php echo (\@?\\\$[a-zA-Z_][\\\$\w]*(?:\[[\w\-\.\"\'\[\]\$]+\])*)\;\?\>";
	var $const_regexp = "\{([\w]+)\}";

	/**
	 *  ģҳ滻д뵽cacheҳ
	 *
	 * @param string $tplfile ģԴļַ
	 * @param string $objfile ģcacheļַ
	 * @return string
	 */
	function complie($tplfile, $objfile) {

		$template = file_get_contents($tplfile);
		$template = $this->parse($template);
		makedir(dirname($objfile));
		isWriteFile($objfile, $template, $mod = 'w', TRUE);

	}

	/**
	 *  ģǩ
	 *
	 * @param string $template ģԴļ
	 * @return string
	 */
	function parse($template) {
	
		//BY QIUJUN 2011-10-22 tsurl·ģǩ
		$template = preg_replace("/\{tsurl(.*?)\}/s", "{php echo tsurl\\1}", $template);
	
		$template = preg_replace("/\<\!\-\-\{(.+?)\}\-\-\>/s", "{\\1}", $template);//ȥhtmlעͷ<!---->
		$template = preg_replace("/\{($this->var_regexp)\}/", "<?php echo \\1;?>", $template);//滻{}ı
		$template = preg_replace("/\{($this->const_regexp)\}/", "<?php echo \\1;?>", $template);//滻{}ĳ
		$template = preg_replace("/(?<!\<\?php echo |\\\\)$this->var_regexp/", "<?php echo \\0;?>", $template);//滻ظ<?php echo
		$template = preg_replace("/\{php (.*?)\}/ies", "\$this->stripvTag('<?php \\1?>')", $template);//滻phpǩ
		$template = preg_replace("/\{for (.*?)\}/ies", "\$this->stripvTag('<?php for(\\1) {?>')", $template);//滻forǩ
		
		$template = preg_replace("/\{elseif\s+(.+?)\}/ies", "\$this->stripvTag('<?php } elseif (\\1) { ?>')", $template);//滻elseifǩ
		for($i=0; $i<3; $i++) {
			$template = preg_replace("/\{loop\s+$this->vtag_regexp\s+$this->vtag_regexp\s+$this->vtag_regexp\}(.+?)\{\/loop\}/ies", "\$this->loopSection('\\1', '\\2', '\\3', '\\4')", $template);
			$template = preg_replace("/\{loop\s+$this->vtag_regexp\s+$this->vtag_regexp\}(.+?)\{\/loop\}/ies", "\$this->loopSection('\\1', '', '\\2', '\\3')", $template);
		}
		$template = preg_replace("/\{if\s+(.+?)\}/ies", "\$this->stripvTag('<?php if(\\1) { ?>')", $template);//滻ifǩ
		$template = preg_replace("/\{include\s+(.*?)\}/is", "<?php include \\1; ?>", $template);//滻includeǩ
		
		$template = preg_replace("/\{template\s+(\w+?)\}/is", "<?php include template('\\1'); ?>", $template);//滻templateǩ
		$template = preg_replace("/\{block (.*?)\}/ies", "\$this->stripBlock('\\1')", $template);//滻blockǩ
		$template = preg_replace("/\{else\}/is", "<?php } else { ?>", $template);//滻elseǩ
		$template = preg_replace("/\{\/if\}/is", "<?php } ?>", $template);//滻/ifǩ
		$template = preg_replace("/\{\/for\}/is", "<?php } ?>", $template);//滻/forǩ
		$template = preg_replace("/$this->const_regexp/", "<?php echo \\1;?>", $template);//note {else} Ҳϳʽ˴ҪעȺ˳??
		$template = preg_replace("/(\\\$[a-zA-Z_]\w+\[)([a-zA-Z_]\w+)\]/i", "\\1'\\2']", $template);//ά滻ɴŵı׼ģʽ
		/* $template = "<?php if(!defined('IN_TS')) exit('Access Denied');?>\r\n$template"; */
		$template = "$template";

		return $template;
	}

	/**
	 * ʽƥ滻
	 *
	 * @param string $s 
	 * @return string
	 */
	function stripvTag($s) {
		return preg_replace("/$this->vtag_regexp/is", "\\1", str_replace("\\\"", '"', $s));
	}

	function stripTagQuotes($expr) {
		$expr = preg_replace("/\<\?php echo (\\\$.+?);\?\>/s", "{\\1}", $expr);
		$expr = str_replace("\\\"", "\"", preg_replace("/\[\'([a-zA-Z0-9_\-\.\x7f-\xff]+)\'\]/s", "[\\1]", $expr));
		return $expr;
	}
	
	function stripv($vv){
		$vv = str_replace('<?php','',$vv);
		$vv = str_replace('echo','',$vv);
		$vv = str_replace(';','',$vv);
		$vv = str_replace('?>','',$vv);
		return $vv;
	}
	
	/**
	 * ģеĿ滻BLOCK
	 *
	 * @param string $blockname 
	 * @param string $parameter 
	 * @return string
	 */
	function stripBlock($parameter) {
		return $this->stripTagQuotes("<?php Mooblock(\"$parameter\"); ?>");
	}

	/**
	 * 滻ģеLOOPѭ
	 *
	 * @param string $arr 
	 * @param string $k 
	 * @param string $v 
	 * @param string $statement 
	 * @return string
	 */
	function loopSection($arr, $k, $v, $statement) {
		$arr = $this->stripvTag($arr);
		$k = $this->stripvTag($k);
		$v = $this->stripvTag($v);
		$statement = str_replace("\\\"", '"', $statement);
		return $k ? "<?php foreach((array)$arr as $k=>$v) {?>$statement<?php }?>" : "<?php foreach((array)$arr as $v) {?>$statement<?php } ?>";
	}
}