<?php
/*
 * 乐兔淘购物分享系统_全局函数文件
 * @copyright (c) 2010-2015 Tuntron All Rights Reserved
 * @Email:70020765@qq.com
 */

defined('IN_TS') or die('Access Denied.');
function lication(){}

function aac($appname){
	global $db;
	$class = $appname;
	$path = THINKAPP.'/'.$appname.'/';
	if(!class_exists($class)){
		include_once  $path.'class.'.$class.'.php';
	}
	if(!class_exists($class)){
		return false;
	}
	$obj = new $class($db);
	return $obj;
	unset($db);

}

//editor Special info  to html
function editor2html($str)
{
	global $db;
	//匹配本地图片
	preg_match_all('/\[(photo)=(\d+)\]/is', $str, $photos);
	foreach ($photos[2] as $item) {
		$strPhoto = aac('photo')->getPhotoForApp($item);
		$str = str_replace("[photo={$item}]",'<a href="'.SITE_URL.'uploadfile/photo/'.$strPhoto['photourl'].'" target="_blank">
							<img class="thumbnail" src="'.SITE_URL.miniimg($strPhoto['photourl'],'photo','500','500',$strPhoto['path']).'" title="'.$strTopic['title'].$item.'" /></a>', $str);
	}

	//匹配附件
	preg_match_all('/\[(attach)=(\d+)\]/is', $str, $attachs);
	if($attachs[2]){
		foreach ($attachs[2] as $aitem) {
			$strAttach = aac('attach')->getOneAttach($aitem);
			if($strAttach['isattach'] == '1'){
				$str = str_replace("[attach={$aitem}]",'<span class="attach_down">附件下载：
									 <a href="'.SITE_URL.'index.php?app=attach&ac=ajax&ts=down&attachid='.$aitem.'" target="_blank">'.$strAttach["attachname"].'</a></span>', $str);
			}else{
				$str = str_replace("[attach={$aitem}]",'', $str);
			}
		}
	}

	$find = array("http://","-",'.',"/",'?','=','&');
	$replace = array("",'_','','','','','');

	preg_match_all('/\[(video)=(.*?)\]/is', $str, $video);
	if($video[2]){
		foreach ($video[2] as $aitem) {
			//img play title
			$arr = explode(',',$aitem);
			$id = str_replace($find,$replace,$arr[0]);
			$html = '<div id="img_'.$id.'"><a href="javascript:void(0)" onclick="showVideo(\''.$id.'\',\''.$arr[1].'\');"><img src="'.$arr[0].'"/></a></div>';
			$html .= '<div id="play_'.$id.'" style="display:none">'.$arr['2'].' <a href="javascript:void(0)" onclick="showVideo(\''.$id.'\',\''.$arr[1].'\');">收起</a>
			<div id="swf_'.$id.'"></div> </div>';
			$str = str_replace("[video={$aitem}]",$html, $str);

		}
	}

	preg_match_all('/\[(mp3)=(.*?)\]/is', $str, $music);
	if($music[2]){
		foreach ($music[2] as $aitem) {
			//url title
			$arr = explode(',',$aitem);
			$id = str_replace($find,$replace,$arr[0]);

			//$mp3flash = '<div id="mp3img_'.$id.'"><a href="javascript:void(0)" onclick="showMp3(\''.$id.'\',\''.$arr[1].'\');"><img src="'.SITE_URL.'public/flash/music.gif" /></a></div>';

			$mp3flash ='<div id="mp3swf_'.$id.'" class="mp3player">
			<div>'.$arr[1].' <a href="'.$aitem.'" target="_blank">下载</a> </div>
			<object height="24" width="290" data="'.SITE_URL.'public/flash/player.swf" type="application/x-shockwave-flash">
				<param value="'.SITE_URL.'public/flash/player.swf" name="movie"/>
				<param value="autostart=no&bg=0xCDDFF3&leftbg=0x357DCE&lefticon=0xF2F2F2&rightbg=0xF06A51&rightbghover=0xAF2910&righticon=0xF2F2F2&righticonhover=0xFFFFFF&text=0x357DCE&slider=0x357DCE&track=0xFFFFFF&border=0xFFFFFF&loader=0xAF2910&soundFile='.$aitem.'" name="FlashVars"/>
				<param value="high" name="quality"/>
				<param value="false" name="menu"/>
				<param value="#FFFFFF" name="bgcolor"/>
				</object></div>';
			$str = str_replace("[mp3={$aitem}]",$mp3flash, $str);


		}
	}
	return $str;
	unset($db);
}


//系统消息

function qiMsg($msg,$button='点击返回>>',$url='javascript:history.back(-1);', $isAutoGo=false){
	echo
<<<EOT
<html>
<head>
EOT;
	if($isAutoGo){
		echo "<meta http-equiv=\"refresh\" content=\"2;url=$url\" />";
	}
	echo
<<<EOT
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>提示</title>
<style type="text/css">
<!--
body {
background-color:#F9F9EF;
font-family: Arial;
font-size: 12px;
line-height:150%;
text-align:center;
}
a{color:#555555;}
.main {
width:500px;
background-color:#FFFFFF;
font-size: 12px;
color: #666666;
margin:50px auto 0;
list-style:none;
padding:20px;
background-color: #fff;
border: 1px solid #ccc;
box-shadow: 0 0 5px rgba(0,0,0,0.2);
border-radius: 3px;
color: #333;
outline: none;
}
.main p {
line-height: 18px;
margin: 10px 20px;
font-size:14px;
}
a{text-decoration:none; color:#069; font-weight:bold}
-->
</style>
</head>
<body>
<div class="main">
<p>$msg</p>
<p><a href="$url">$button</a></p>
</div>
</body>
</html>
EOT;
	exit;
}


/*
 * 分页函数
 *
 * @param int $count 条目总数
 * @param int $perlogs 每页显示条数目
 * @param int $page 当前页码
 * @param string $url 页码的地址
 * @return unknown
 */

function pagination($count,$perlogs,$page,$url,$suffix=''){
	$pnums = @ceil($count / $perlogs);
	$sy = $page-1;
	$xy = $page+1;
	$re = '';
	for ($i = $page-5;$i <= $page+5 && $i <= $pnums; $i++){
		if ($i > 0){
			if ($i == $page){
				$re .= ' <span class="current">'.$i.'</span> ';
			} else {
				$re .= '<a href="'.$url.$i.$suffix.'">'.$i.'</a>';
			}
		}
	}
	if ($page > 1) $re = '<a class="prev" href="'.$url.$sy.$suffix.'" title="上一页">上一页</a>'.$re;
	if ($page < $pnums) $re .= '<a class="prev" href="'.$url.$xy.$suffix.'" title="下一页">下一页</a>';
	if ($page+5 < $pnums) $re .= '<a class="prev" href="'.$url.$pnums.$suffix.'" title="尾页">尾页</a>';
	if ($pnums <= 1) $re = '';
	return $re;
}

function tuan_pagination($count,$perlogs,$page,$url,$suffix=''){
	$pnums = @ceil($count / $perlogs);
	$sy = $page-1;
	$xy = $page+1;
	$re = '';
	for ($i = $page-5;$i <= $page+5 && $i <= $pnums; $i++){
		if ($i > 0){
			if ($i == $page){
				$re .= ' <span class="page-this">'.$i.'</span> ';
			} else {
				$re .= '<a href="'.$url.$i.$suffix.'">'.$i.'</a>';
			}
		}
	}
	if ($page > 1) {
		$re = '<a class="page-prev" href="'.$url.$sy.$suffix.'" title="上一页">上一页</a>'.$re;
	}else{
		$re = '<span class="page-start">上一页</span>'.$re;
	}
	if ($page < $pnums) {
		$re .= '<a class="page-next" href="'.$url.$xy.$suffix.'" title="下一页">下一页</a>';
	}else{
		$re .= '<span class="page-end">下一页</span>';
	}
	if ($page+5 < $pnums) $re .= '<a class="page-next" href="'.$url.$pnums.$suffix.'" title="尾页">尾页</a>';
	if ($pnums <= 1) $re = '';
	return $re;
}

function nopin_pagination($count,$perlogs,$page,$url,$suffix=''){
	$pnums = @ceil($count / $perlogs);
	$sy = $page-1;
	$xy = $page+1;
	$re = '';

	$re .= '<ul>';
	for ($i = $page-5;$i <= $page+5 && $i <= $pnums; $i++){
		if ($i > 0){
			if ($i == $page){
				$re .= ' <li><span>第 '.$i.' 页</span></li> ';
			} else {
				$re .= '<li><A href="'.$url.$i.$suffix.'">第 '.$i.' 页</A></li>';
			}
		}
	}
	$re .= '</ul>';
	$re .= '<span class="current">第 '.$page.'  页</span>';
	if ($page < $pnums) {
		$re .= '<a title="翻翻下一页" href="'.$url.$xy.$suffix.'" class="next">翻翻下一页&gt;</a>';
	}else{
		if ($page > 1) $re .= '<a title="翻翻上一页" href="'.$url.$sy.$suffix.'" class="next">&lt; 翻翻上一页</a>';
	}
	return $re;
}

//验证Email

function valid_email($email){
	if (!@ereg("^[^@]{1,64}@[^@]{1,255}$", $email)){
		return false;
	}
	$email_array		= explode("@", $email);
	$local_array		= explode(".", $email_array[0]);
	for ($i = 0; $i < sizeof($local_array); $i++){
		if (!@ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])){
			return false;
		 }
	}
	if (!@ereg("^\[?[0-9\.]+\]?$", $email_array[1])){
		$domain_array = explode(".", $email_array[1]);
		if (sizeof($domain_array) < 2){
			return false;
		}
		for ($i = 0; $i < sizeof($domain_array); $i++){
			if (!@ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])){
				return false;
			}
		}
	}
	return true;
}

//处理时间的函数

function getTime($btime, $etime){

	if ($btime < $etime) {
		$stime = $btime;
		$endtime = $etime;
	}else {
		$stime = $etime;
		$endtime = $btime;
	}
	$timec = $endtime - $stime;
	$days = intval($timec / 86400);
	$rtime = $timec % 86400;
	$hours = intval($rtime / 3600);
	$rtime = $rtime % 3600;
	$mins = intval($rtime / 60);
	$secs = $rtime % 60;
	if($days>=1){
		return $days.' 天前';
	}
	if($hours>=1){
		return $hours.' 小时前';
	}

	if($mins>=1){
		return $mins.' 分钟前';
	}
	if($secs>=1){
		return $secs.' 秒前';
	}

}

//获取用户IP

function getIp(){

	if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')){
		$PHP_IP = getenv('HTTP_CLIENT_IP');
	}elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')){
		$PHP_IP = getenv('HTTP_X_FORWARDED_FOR');
	}elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')){
		$PHP_IP = getenv('REMOTE_ADDR');
	}elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')){
		$PHP_IP = $_SERVER['REMOTE_ADDR'];
	}
	preg_match("/[\d\.]{7,15}/", $PHP_IP, $ipmatches);
	$PHP_IP = $ipmatches[0] ? $ipmatches[0] : 'unknown';
	return $PHP_IP;
}



//过滤脚本代码
function cleanJs($text){
	$text = trim ( $text );
	$text = stripslashes ( $text );
	//完全过滤注释
	$text = preg_replace ( '/<!--?.*-->/', '', $text );
	//完全过滤动态代码

	$text = preg_replace ( '/<\?|\?>/', '', $text );

	//完全过滤js
	$text = preg_replace ( '/<script?.*\/script>/', '', $text );
	//过滤多余html
	$text = preg_replace ( '/<\/?(html|head|meta|link|base|body|title|style|script|form|iframe|frame|frameset)[^><]*>/i', '', $text );
	//过滤on事件lang js
	while ( preg_match ( '/(<[^><]+)(lang|onfinish|onmouse|onexit|onerror|onclick|onkey|onload|onchange|onfocus|onblur)[^><]+/i', $text, $mat ) ){
		$text = str_replace ( $mat [0], $mat [1], $text );
		}
	while ( preg_match ( '/(<[^><]+)(window\.|javascript:|js:|about:|file:|document\.|vbs:|cookie)([^><]*)/i', $text, $mat ) ){
		$text = str_replace ( $mat [0], $mat [1] . $mat [3], $text );
		}
	return $text;
}

//纯文本输入
function t($text){
	$text = cleanJs ( $text );
	//彻底过滤空格BY QINIAO
	$text = preg_replace('/\s(?=\s)/', '', $text);
	$text = preg_replace('/[\n\r\t]/', ' ', $text);
	$text = str_replace ( '  ', ' ', $text );
	$text = str_replace ( ' ', '', $text );
	$text = str_replace ( '&nbsp;', '', $text );
	$text = str_replace ( '&', '', $text );
	$text = str_replace ( '=', '', $text );
	$text = str_replace ( '-', '', $text );
	$text = str_replace ( '#', '', $text );
	$text = str_replace ( '%', '', $text );
	$text = str_replace ( '!', '', $text );
	$text = str_replace ( '@', '', $text );
	$text = str_replace ( '^', '', $text );
	$text = str_replace ( '*', '', $text );
	$text = str_replace ( 'amp;', '', $text );

	$text = strip_tags ( $text );
	$text = htmlspecialchars ( $text );
	$text = str_replace ( "'", "", $text );
	return $text;
}

//输入安全的html，针对存入数据库中的数据进行的过滤和转义

function h($text){
	$text = trim ( $text );
	$text = htmlspecialchars ( $text );
	$text = addslashes ( $text );
	return $text;
}

//主要针对输出的内容，对动态脚本，静态html，动态语言全部通吃
function hview($text){
	$text = stripslashes($text);
	$text = nl2br($text);
	return $text;
}

//反序列化为UTF-8
function mb_unserialize($serial_str) {
	$serial_str= preg_replace('!s:(\d+):"(.*?)";!se', "'s:'.strlen('$2').':\"$2\";'", $serial_str );
	$serial_str= str_replace("\r", "", $serial_str);
	return unserialize($serial_str);
}

//反序列化为ASC
function asc_unserialize($serial_str) {
	$serial_str = preg_replace('!s:(\d+):"(.*?)";!se', '"s:".strlen("$2").":\"$2\";"', $serial_str );
	$serial_str= str_replace("\r", "", $serial_str);
	return unserialize($serial_str);
}

//utf-8截取
function getsubstrutf8($string, $start = 0,$sublen,$append=true){
	$pa = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|\xe0[\xa0-\xbf][\x80-\xbf]|[\xe1-\xef][\x80-\xbf][\x80-\xbf]|\xf0[\x90-\xbf][\x80-\xbf][\x80-\xbf]|[\xf1-\xf7][\x80-\xbf][\x80-\xbf][\x80-\xbf]/";
	preg_match_all($pa, $string, $t_string);
	if(count($t_string[0]) - $start > $sublen && $append==true){
		return join('', array_slice($t_string[0], $start, $sublen))."...";
	}else{
		return join('', array_slice($t_string[0], $start, $sublen));
	}
}

//读取目录列表函数dirs,files
function dirList($dir, $bool = "dirs"){

   $truedir = $dir; //注意：确定路劲是否带有'/'

   $dir = scandir($dir);
   if($bool == "files"){
		$direct = 'is_dir';
   }elseif($bool == "dirs"){
		$direct = 'is_file';
   }

   foreach($dir as $k => $v){
		if(($direct($truedir.'/'.$dir[$k])) || $dir[$k] == '.' || $dir[$k] == '..'  || $dir[$k] == '.svn'){
			unset($dir[$k]);
		}
   }
   $dir = array_values($dir);
   return $dir;
}

//计算时间
function getmicrotime(){
	list($usec, $sec) = explode(" ",microtime());
	return ((float)$usec + (float)$sec);
}

/*写入文件
 @By QiuJun 2011-12-10
 @$file 缓存文件
 @$dir 缓存目录
 @$data 内容
 */
function fileWrite($file,$dir,$data){

	!is_dir($dir)?mkdir($dir,0777):'';

	$dfile = $dir.'/'.$file;

	if($dfile) unlink($dfile);

	$data = "<?php\ndefined('IN_TS') or die('Access Denied.');\nreturn ".var_export($data,true).";";

	file_put_contents($dfile,$data);

	return true;

}

/*读取文件，过渡期Letutao1.6，到1.8的时间可以全面进行精简到fileRead($dfile)
 @$file 文件
 @$dir 目录
 @$app 过渡一下app
*/
function fileRead($file,$dir,$app,$plugin=''){

	if($plugin!=''){

		//plugins
		if(is_file($dir.'/'.$app.'/'.$plugin.'/'.$file)){
			$data = include $dir.'/'.$app.'/'.$plugin.'/'.$file;
			return $data;
		}

	}else{

		//app
		if(is_file($dir.'/'.$app.'_'.$file)){
			$data = include $dir.'/'.$app.'_'.$file;
			return $data;
		}elseif(is_file($dir.'/cache/'.$app.'/'.$file)){
			$data = include $dir.'/cache/'.$app.'/'.$file;
			return $data;
		}

	}

}

//把数组转换为,号分割的字符串
function array_to_str($arr) {
	$str = '';
	$count = 1;
	if(is_array($arr)){
		foreach ($arr as $a) {
			if ($count==1) {
				$str .= $a;
			} else {
				$str .= ','.$a;
			}
				$count++;
		}
	}
	return $str;
}


//生成随机数(1数字,0字母数字组合)
function random($length, $numeric = 0) {
	PHP_VERSION < '4.2.0' ? mt_srand((double)microtime() * 1000000) : mt_srand();
	$seed = base_convert(md5(print_r($_SERVER, 1).microtime()), 16, $numeric ? 10 : 35);
	$seed = $numeric ? (str_replace('0', '', $seed).'012340567890') : ($seed.'zZ'.strtoupper($seed));
	$hash = '';
	$max = strlen($seed) - 1;
	for($i = 0; $i < $length; $i++) {
		$hash .= $seed[mt_rand(0, $max)];
	}
	return $hash;
}

/*
 *封装一个采集函数
 *@ $url 网址
 *@ $proxy 代理
 *@ $timeout 跳出时间
 */

function getHtmlByCurl($url,$proxy,$timeout){
	$ch = curl_init();
	curl_setopt ($ch, CURLOPT_PROXY, $proxy);
	curl_setopt ($ch, CURLOPT_URL, $url);
	curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
	$file_contents = curl_exec($ch);
	return $file_contents;
}

//计算文件大小
function format_bytes($size) {
	$units = array(' B', ' KB', ' MB', ' GB', ' TB');
	for ($i = 0; $size >= 1024 && $i < 4; $i++) $size /= 1024;
	return round($size, 2).$units[$i];
}

/*
 * 功能:               判断是否是手机访问
 * 参数:               无
 * 返回值:            返回1为是手机访问,返回0时为不是
 */
function is_wap() {
	$http_via = isset($_SERVER['HTTP_VIA']) ? strtolower($_SERVER['HTTP_VIA']) : '';
	return !empty($http_via) && strstr($http_via, 'wap') ? 1 : 0;
}

//object_array 对象转数组
function object_array($array){
	if(is_object($array)){
		$array = (array)$array;
	}
	if(is_array($array)){
		foreach($array as $key=>$value){
			$array[$key] = object_array($value);
		}
	}
	return $array;
}

/*此处开始借用moophp的模板代码*/

/**
* 写文件
* @param string $file - 需要写入的文件，系统的绝对路径加文件名
* @param string $content - 需要写入的内容
* @param string $mod - 写入模式，默认为w
* @param boolean $exit - 不能写入是否中断程序，默认为中断
* @return boolean 返回是否写入成功
*/
function isWriteFile($file, $content, $mod = 'w', $exit = TRUE) {
if(!@$fp = @fopen($file, $mod)) {
	if($exit) {
		exit('Letutao File :<br>'.$file.'<br>Have no access to write!');
	} else {
		return false;
	}
} else {
	@flock($fp, 2);
	@fwrite($fp, $content);
	@fclose($fp);
	return true;
}
}

//创建目录
function makedir($dir) {
return is_dir($dir) or (makedir(dirname($dir)) and mkdir($dir, 0777));
}

/**
* 加载模板
* @param string $file - 模板文件名
* @return string 返回编译后模板的系统绝对路径
*/
function template($file) {
	global $app;
	if($file=='404'){
		$tplfile = 'public/html/404.html';
		$objfile = 'cache/template/404.tpl.php';
	}else{
		$tplfile = 'app/'.$app.'/html/'.$file.'.html';
		$objfile = 'cache/template/'.$app.'.'.$file.'.tpl.php';
	}
	if(@filemtime($tplfile) > @filemtime($objfile)) {
		//note 加载模板类文件
		require_once 'letutao/class.template.php';
		$T = new template();
		$T->complie($tplfile, $objfile);

	}

	return $objfile;
	unset($app);
}

//加载公用html模板文件
function pubTemplate($file) {
$tplfile = 'public/html/'.$file.'.html';
$objfile = 'cache/template/public.'.$file.'.tpl.php';

if(@filemtime($tplfile) > @filemtime($objfile)) {
	//note 加载模板类文件

	require_once 'letutao/class.template.php';
	$T = new template();

	$T->complie($tplfile, $objfile);
}

return $objfile;
}

//针对app各个的插件部分，修改自Emlog
/**
* 该函数在插件中调用,挂载插件函数到预留的钩子上
*
* @param string $hook
* @param string $actionFunc
* @return boolearn
*/
function addAction($hook, $actionFunc){
	global $tsHooks;
	if (!@in_array($actionFunc, $tsHooks[$hook])){
		$tsHooks[$hook][] = $actionFunc;
	}

	return true;
}

/**
* 执行挂在钩子上的函数,支持多参数 eg:doAction('post_comment', $author, $email, $url, $comment);
*
* @param string $hook
*/

function links_html(){
	$arrLink = fileRead('data.php','plugins','faxian','links');
	foreach($arrLink as $item){
		echo '<dd><a target="_blank" href="'.$item['linkurl'].'">'.$item['linkname'].'</a></dd> ';
	}
}


function doAction($hook){
	global $tsHooks;
	$args = array_slice(func_get_args(), 1);
	if (isset($tsHooks[$hook])){
		foreach ($tsHooks[$hook] as $function){
			$string = call_user_func_array($function, $args);
		}
	}
}

function createFolders($path)  {
	//递归创建
	if (!file_exists($path)){
		createFolders(dirname($path));//取得最后一个文件夹的全路径返回开始的地方
		mkdir($path, 0777);
	}
}

//删除文件夹和文件夹下所有的文件
function delDir($dir=''){
	if (empty($dir)){
		$dir = rtrim(RUNTIME_PATH,'/');
	}
	if (substr($dir,-1) == '/'){
		$dir = rtrim($dir,'/');
	}
	if (!file_exists($dir)) return true;
	if (!is_dir($dir) || is_link($dir)) return @unlink($dir);
	foreach (scandir($dir) as $item) {
		if ($item == '.' || $item == '..') continue;
		if (!delDir($dir . "/" . $item)) {
			@chmod($dir . "/" . $item, 0777);
			if (!delDir($dir . "/" . $item)) return false;
		};
	}
	return @rmdir($dir);
}

//获取带http的网站域名 BY QIUJUN
function getHttpUrl(){
	$arrUri = explode('index.php',$_SERVER['REQUEST_URI']);
	$site_url = 'http://'.$_SERVER['HTTP_HOST'].$arrUri[0];
	return $site_url;
}

// 10位MD5值
function md10($str=''){
	return substr(md5($str),10,10);
}

/*BY QIUJUN
 * # 缩略图 (图片SRC, 宽度, 高度)
 * $file：数据库里的图片url
 * $app：app名称
 * $w：缩略图片宽度
 * $h：缩略图片高度
 * $c:1裁切,0不裁切
 */
function miniimg($file, $app , $w, $h='',$path='',$c='0'){
	if(!$file) { return;}

	$info = explode('.',$file);

	$name = md10($file).'_'.$w.'_'.$h.'.'.$info[1];

	if($path==''){
		$cpath = 'cache/'.$app.'/'.$w.'/'.$name;
	}else{
		$cpath = 'cache/'.$app.'/'.$path.'/'.$w.'/'.$name;
	}


	if(!is_file($cpath)){
		createFolders('cache/'.$app.'/'.$path.'/'.$w);
		$dest = 'uploadfile/'.$app.'/'.$file;
		$arrImg = getimagesize($dest);
		if($arrImg[0] <= $w){
			copy($dest,$cpath);
		}else{
			require_once 'letutao/class.image.php';
			$resizeimage = new tsImg("$dest", $w, $h, $c,"$cpath");

		}
	}
	return $cpath;
}



function fileiimg($file, $app , $w, $h='',$path='',$c='0'){
	if(!$file) { return;}

	$info = explode('.',$file);

	$name = md10($file).'_'.$w.'_'.$h.'.jpg';

	if($path==''){
		$cpath = 'cache/'.$app.'/'.$w.'/'.$name;
	}else{
		$cpath = 'cache/'.$app.'/'.$path.'/'.$w.'/'.$name;
	}


	if(!is_file($cpath)){
		createFolders('cache/'.$app.'/'.$path.'/'.$w);
		$arrImg = getimagesize($file);
		if($arrImg[0] <= $w){
			copy($file,$cpath);
		}else{
			require_once 'letutao/class.image.php';
			$resizeimage = new tsImg("$file", $w, $h, $c,"$cpath");
			}
	}
	return $cpath;
}


//gzip压缩输出
function ob_gzip($content) {
	if( !headers_sent() && extension_loaded("zlib") && strstr($_SERVER["HTTP_ACCEPT_ENCODING"],"gzip")) {
		//$content = gzencode($content." \n//此页已压缩",9);
		$content = gzencode($content,9);
		header("Content-Encoding: gzip");
		header("Vary: Accept-Encoding");
		header("Content-Length: ".strlen($content));
	}
	return $content;
}


/* tsUrl()
 * tsUrl提供至少4种的url展示方式
 * (1)index.php?app=group&ac=topic&topicid=1 //标准默认模式
 * (2)index.php/group/topic/topicid-1   //path_info模式
 * (3)group-topic-topicid-1.html   //rewrite模式1
 * (4)group/topic/topicid-1   //rewrite模式2
 */

function tsurl($app,$ac='',$params=array(),$tag='',$sort='',$k='',$subcate=''){

	if(is_file('data/system_options.php')){
		$options = include 'data/system_options.php';
	}else{
		$options = include 'data/cache/system/options.php';
	}

	$urlset = $options['site_urltype'];
	$goodlink = $options['goodlink']?$options['goodlink']:'baobei';

	if($app=='baobei') $app=$goodlink;

	if($urlset==1){

		if($sort){
		$tagu = $tag?'&tag='.$tag:'';
		$kw = $k?'&k='.$k:'';
		$is_subcate= $subcate?'&subcate='.$subcate:'';
		$url = 'index.php?app='.$app.'&sort='.$sort.$tagu.$kw.$is_subcate;
		}else{
		foreach($params as $k=>$v){
			$str .= '&'.$k.'='.$v;
		}
		if($ac==''){
			$ac = '';
		}else{
			$ac='&ac='.$ac;
		}
		$url = 'index.php?app='.$app.$ac.$str;
		}
	}elseif($urlset == 2){
		foreach($params as $k=>$v){
			$str .= '/'.$k.'-'.$v;
		}
		if($ac==''){
			$ac='';
		}else{
			$ac='/'.$ac;
		}
		$url = 'index.php/'.$app.$ac.$str;
	}elseif($urlset == 3){
		foreach($params as $k=>$v){
			$str .= '-'.$k.'-'.$v;
		}
		$url = $app.'-'.$ac.$str.'.html';
	}elseif($urlset == 4){
		if($sort){
		$tagu = $tag?'/tag-'.$tag:'';
		$kw = $k?'/k-'.$k:'';
		$is_subcate= $subcate?'/subcate-'.$subcate:'';
		$url = $app.$tagu.$kw.$is_subcate.'/sort-'.$sort;
		}else{
		foreach($params as $k=>$v){
			$str .= '/'.$k.'-'.$v;
		}

		if($ac==''){
			$ac='';
		}else{
			$ac='/'.$ac;
		}

		$url = $app.$ac.$str;
		}
	}
	return $url;
}


function reurl(){

	$scriptName = explode('index.php',$_SERVER['SCRIPT_NAME']);

	$rurl = substr($_SERVER['REQUEST_URI'], strlen($scriptName[0]));

	if(strpos($rurl,'?')==false){

		if(preg_match('/index.php/i',$rurl)){
			$rurl = str_replace('index.php','',$rurl);
			$rurl = substr($rurl, 1);
			$params = $rurl;
		}else{
			$params = $rurl;
		}

		if($rurl){

			$params = explode('/', $params);
			foreach( $params as $p => $v )
			{
				switch($p)
				{
					case 0:$_GET['app']=$v;break;
					case 1:
					if(strstr($v,'-')){
					$_GET['ac']='index';

					$kv = explode('-', $v);

					$_GET[$kv[0]] = rawurldecode($kv[1]);


					}else{

					$_GET['ac']=$v;
					}

					break;
					default:
						$kv = explode('-', $v);
						if(count($kv)>1)
						{
							$_GET[$kv[0]] = $kv[1];
						}
						else
						{
							$_GET['params'.$p] = $kv[0];
						}
						break;
				}
			}
		}
	}
}

//链接数组函数，根据传入的条件返回当前页面下所有get参数的数组，提供给tsurl
	function url_array($c,$p_id){
		global $subcate,$tag,$style,$sort,$p;

		if($subcate&&$c!=='subcate'&&$c!=='tag'){
			$url_array_subcate = array('subcate'=>$subcate);
			$url_array = $url_array?array_merge($url_array,$url_array_subcate):$url_array_subcate;
		}
		if($tag){
			$url_array_tag = array('tag'=>$tag);
			$url_array = $url_array?array_merge($url_array,$url_array_tag):$url_array_tag;
		}
		if($style&&$c!=='style'){
			$url_array_style = array('kouwei'=>$style);
			$url_array = $url_array?array_merge($url_array,$url_array_style):$url_array_style;
		}
		if($sort&&$c!=='sort'){
			$url_array_sort = array('sort'=>$sort);
			$url_array = $url_array?array_merge($url_array,$url_array_sort):$url_array_sort;
		}
		if($p&&$c!=='p'){
			$url_array_p = array('shicai'=>$p);
			$url_array = $url_array?array_merge($url_array,$url_array_p):$url_array_p;
		}
		if($c){
			$url_array_c = array($c=>$p_id);
			$url_array = $url_array?array_merge($url_array,$url_array_c):$url_array_c;
		}else{
			$url_array = $url_array?$url_array:array();
		}
		return $url_array;
	}

//检测目录是否可写1可写，0不可写
function iswriteable($file){
	if(is_dir($file)){
		$dir=$file;
		if($fp = @fopen("$dir/test.txt", 'w')) {
			@fclose($fp);
			@unlink("$dir/test.txt");
			$writeable = 1;
		} else {
			$writeable = 0;
		}
	}else{
		if($fp = @fopen($file, 'a+')) {
			@fclose($fp);
			$writeable = 1;
		}else {
			$writeable = 0;
		}
	}
	return $writeable;
}

//删除目录下文件
function delDirFile($dir){
	$arrFiles = dirList($dir,'files');
	foreach($arrFiles as $item){
		unlink($dir.'/'.$item);
	}
}

function outputJson($result,$re=0)
{
	static $json = NULL;
	if($json === NULL)
	{
		require 'class.json.php';
		$json = new Json();
	}
	if($re){

		return $json->encode($result);

	}else{

		die($json->encode($result));
	}
}

/**
 * 返回json信息
 * @param mixed $result
 * @return string
 */
function getJson($result)
{
	static $json = NULL;
	if($json === NULL)
	{
		require 'class.json.php';
		$json = new Json();
	}
	return $json->encode($result);
}

/**
 * 解码json信息
 * @param mixed $result
 * @return string
 */
function decodeJson($str)
{
	static $json = NULL;
	if($json === NULL)
	{
		require 'class.json.php';
		$json = new Json();
	}
	return $json->decode($str);
}

function fMysqlLikeQuote($str)
{
    return strtr($str, array("\\\\" => "\\\\\\\\", '_' => '\_', '%' => '\%', "\'" => "\\\\\'"));
}

/**
 * 字符转义
 * @return string
 */
function fAddslashes($string)
{
	if(is_array($string))
	{
		foreach($string as $key => $val)
		{
			unset($string[$key]);
			$string[addslashes($key)] = fAddslashes($val);
		}
	}
	else
	{
		$string = addslashes($string);
	}

	return $string;
}

//去除二维数组重复
function unique_arr($array2D,$stkeep=false,$ndformat=true)
{
    // 判断是否保留一级数组键 (一级数组键可以为非数字)
    if($stkeep) $stArr = array_keys($array2D);

    // 判断是否保留二级数组键 (所有二级数组键必须相同)
    if($ndformat) $ndArr = array_keys(end($array2D));

    //降维,也可以用implode,将一维数组转换为用逗号连接的字符串
    foreach ($array2D as $v){
        $v = join(",",$v);
        $temp[] = $v;
    }

    //去掉重复的字符串,也就是重复的一维数组
    $temp = array_unique($temp);

    //再将拆开的数组重新组装
    foreach ($temp as $k => $v)
    {
        if($stkeep) $k = $stArr[$k];
        if($ndformat)
        {
            $tempArr = explode(",",$v);
            foreach($tempArr as $ndkey => $ndval) $output[$k][$ndArr[$ndkey]] = $ndval;
        }
        else $output[$k] = explode(",",$v);
    }

    return $output;
}
//php对数组进行分组
//
function splitArray($array,$num){
    $isExtra = false;
    if(is_array($array)){
        $num = intval($num);
        $length = count($array);
        if($length < $num)
        return $array;
        $start = 0;
        $extra = (int)($length % $num);
        $enum = (int)($length/$num);
        $result = array();
        for($i = 0; $i < $num; $i++){
            if($i < ($num - 1)){
                if($extra != 0 && $i < $extra){
                    $isExtra = true;
                    $result[] = array_slice($array, $start,($enum+1));
                }else{
                    $isExtra = false;
                    $result[] = array_slice($array, $start,$enum);
                }
            }else{
                $isExtra = false;
                $result[] = array_slice($array, $start);
            }
            if($isExtra) {
                $start += ($enum+1);
            }else{
                $start += $enum;
            }

        }
        return $result;
    }
}

/**
 * 重组数组
 */

function splitArrayc($array,$num){
    $isExtra = false;
    if(is_array($array)){
        $num = intval($num);
        $length = count($array);
        $start = 0;
        $enum = ceil($length/$num);
        $result = array();
        for($i = 0; $i < $enum; $i++){
           		$result[] = array_slice($array, $start,$num);
                $start = (int)($start+$num);
        }
        return $result;
    }
}

//取得$_GET里的变量
function _get($var, $convert_fun='', $default = null) {
	Filter($_GET);
    if(isset($_GET[$var])) {
        if($convert_fun) return $convert_fun($_GET[$var]);
        return $_GET[$var];
    }
    return $default;
}
//取得$_POST里的变量
function _post($var, $convert_fun='', $default = null) {
	Filter($_POST);
    if(isset($_POST[$var])) {
        if($convert_fun) return $convert_fun($_POST[$var]);
        return $_POST[$var];
    }

    return $default;
}

//处理过滤
function Filter(&$array){
	if (is_array($array)) {
		foreach ($array as $key => $value) {
			if (!is_array($value)) {
				$array[$key] = addslashes($value);
			} else {
				Filter($array[$key]);
			}
		}
	}
}

/**
 * 快速文件数据读取和保存 针对简单类型数据 字符串、数组
 * @param string $name 缓存名称
 * @param mixed $value 缓存值
 * @param string $path 缓存路径
 * @return mixed
 */
function F($name, $value='', $path=THINKDATA) {
	//$path= sys_get_temp_dir();//百度云测试
    static $_cache  = array();
    $filename       = $path .'/'. $name . '.php';
    if ('' !== $value) {
        if (is_null($value)) {
            // 删除缓存
            return unlink($filename);
        } else {
            // 缓存数据
            $dir            =   dirname($filename);
            // 目录不存在则创建
            if (!is_dir($dir))
                mkdir($dir,0777,true);
            $_cache[$name]  =   $value;
            return file_put_contents($filename, json_encode($value));
        }
    }
    if (isset($_cache[$name]))
        return $_cache[$name];
    // 获取缓存数据
    if (is_file($filename)) {
        $value          =   json_decode(file_get_contents($filename),true);
        $_cache[$name]  =   $value;
    } else {
        $value          =   false;
    }
    return $value;
}


//扫描目录
function leScanDir($dir,$isDir=null){

	if($isDir == null){
		$dirs = array_filter(glob($dir.'/'.'*'), 'is_dir');
	}else{
		$dirs = array_filter(glob($dir.'/'.'*'), 'is_file');
	}

	foreach($dirs as $key=>$item){
		$y=explode('/',$item);
		$arrDirs[] = array_pop($y);
	}

	return $arrDirs;

}

//删除目录下所有文件
function rmrf($dir) {
    foreach (glob($dir) as $file) {
        if (is_dir($file)) {
            rmrf("$file/*");
            rmdir($file);
        } else {
            unlink($file);
        }
    }
}


//二维数组转换为一维数组
//$pam为二维数组内要转换为一维数组的值
function arr2_arr1($array,$pam) {
	foreach($array as $key=>$value)
	{
	  $arr1[$key]=$value[$pam];
	}
	return $arr1;
}

//判断远程文件是否存在
function img_exists($url)
{
    if(@file_get_contents($url,0,null,0,1))
        return 1;
else
        return 0;
}

//取得字节单位
function size_bytes($val) {
    $val = trim($val);
    $last = strtolower($val{strlen($val)-1});
    switch($last) {
        case 'g':
             $val *= 1024;
        case 'm':
             $val *= 1024;
        case 'k':
             $val *= 1024;
    }
    return $val;
}
//判断是否为utf-8
function IsUTF8($string) {

    return preg_match('%^(?:
          [\x09\x0A\x0D\x20-\x7E]            # ASCII
        | [\xC2-\xDF][\x80-\xBF]             # non-overlong 2-byte
        |  \xE0[\xA0-\xBF][\x80-\xBF]        # excluding overlongs
        | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  # straight 3-byte
        |  \xED[\x80-\x9F][\x80-\xBF]        # excluding surrogates
        |  \xF0[\x90-\xBF][\x80-\xBF]{2}     # planes 1-3
        | [\xF1-\xF3][\x80-\xBF]{3}          # planes 4-15
        |  \xF4[\x80-\x8F][\x80-\xBF]{2}     # plane 16
    )*$%xs', $string);
}

//判断是否urlencode,仅限get参数判断
function IsUrlencode($string) {

   return  strstr($string,"%");
}
//截取汉字
function cut_str($string, $sublen,$lastStr = '', $start = 0, $code = 'gb2312')
{
    if($code == 'UTF-8')
    {
        $pa = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|\xe0[\xa0-\xbf][\x80-\xbf]|[\xe1-\xef][\x80-\xbf][\x80-\xbf]|\xf0[\x90-\xbf][\x80-\xbf][\x80-\xbf]|[\xf1-\xf7][\x80-\xbf][\x80-\xbf][\x80-\xbf]/";
        preg_match_all($pa, $string, $t_string);

        if(count($t_string[0]) - $start > $sublen) return join('', array_slice($t_string[0], $start, $sublen))."...";
        return join('', array_slice($t_string[0], $start, $sublen));
    }
    else
    {
        $start = $start*2;
        $sublen = $sublen*2;
        $strlen = strlen($string);
        $tmpstr = '';

        for($i=0; $i< $strlen; $i++)
        {
            if($i>=$start && $i< ($start+$sublen))
            {
                if(ord(substr($string, $i, 1))>129)
                {
                    $tmpstr.= substr($string, $i, 2);
                }
                else
                {
                    $tmpstr.= substr($string, $i, 1);
                }
            }
            if(ord(substr($string, $i, 1))>129) $i++;
        }
        if(strlen($tmpstr)< $strlen ) $tmpstr.= $lastStr;
        return $tmpstr;
    }
}

function getCateOption($cate_name,$type='cate_name'){
			global $db;
			$arrcate = $db->fetch_all_assoc("select cate_id,cate_name from ".dbprefix."goods_cate where cate_id>1 and parent_id=0 order by cate_id asc");

			foreach($arrcate as $key=>$item){
				$cate_html .= $cate_name==$item[$type]?'<option value="'.$item[$type].'" selected="selected">'.$item['cate_name'].'</option>':'<option value="'.$item[$type].'">'.$item['cate_name'].'</option>';

		}
			return $cate_html;

}


function RemoveXSS($val) {
   // remove all non-printable characters. CR(0a) and LF(0b) and TAB(9) are allowed
   // this prevents some character re-spacing such as <java\0script>
   // note that you have to handle splits with \n, \r, and \t later since they *are* allowed in some inputs
   $val = preg_replace('/([\x00-\x08,\x0b-\x0c,\x0e-\x19])/', '', $val);

   // straight replacements, the user should never need these since they're normal characters
   // this prevents like <IMG SRC=@avascript:alert('XSS')>
   $search = 'abcdefghijklmnopqrstuvwxyz';
   $search .= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
   $search .= '1234567890!@#$%^&*()';
   $search .= '~`";:?+/={}[]-_|\'\\';
   for ($i = 0; $i < strlen($search); $i++) {
      // ;? matches the ;, which is optional
      // 0{0,7} matches any padded zeros, which are optional and go up to 8 chars

      // @ @ search for the hex values
      $val = preg_replace('/(&#[xX]0{0,8}'.dechex(ord($search[$i])).';?)/i', $search[$i], $val); // with a ;
      // @ @ 0{0,7} matches '0' zero to seven times
      $val = preg_replace('/(&#0{0,8}'.ord($search[$i]).';?)/', $search[$i], $val); // with a ;
   }

   // now the only remaining whitespace attacks are \t, \n, and \r
   $ra1 = Array('javascript', 'vbscript', 'expression', 'applet', 'meta', 'xml', 'blink', 'link', 'style', 'script', 'embed', 'object', 'iframe', 'frame', 'frameset', 'ilayer', 'layer', 'bgsound', 'title', 'base');
   $ra2 = Array('onabort', 'onactivate', 'onafterprint', 'onafterupdate', 'onbeforeactivate', 'onbeforecopy', 'onbeforecut', 'onbeforedeactivate', 'onbeforeeditfocus', 'onbeforepaste', 'onbeforeprint', 'onbeforeunload', 'onbeforeupdate', 'onblur', 'onbounce', 'oncellchange', 'onchange', 'onclick', 'oncontextmenu', 'oncontrolselect', 'oncopy', 'oncut', 'ondataavailable', 'ondatasetchanged', 'ondatasetcomplete', 'ondblclick', 'ondeactivate', 'ondrag', 'ondragend', 'ondragenter', 'ondragleave', 'ondragover', 'ondragstart', 'ondrop', 'onerror', 'onerrorupdate', 'onfilterchange', 'onfinish', 'onfocus', 'onfocusin', 'onfocusout', 'onhelp', 'onkeydown', 'onkeypress', 'onkeyup', 'onlayoutcomplete', 'onload', 'onlosecapture', 'onmousedown', 'onmouseenter', 'onmouseleave', 'onmousemove', 'onmouseout', 'onmouseover', 'onmouseup', 'onmousewheel', 'onmove', 'onmoveend', 'onmovestart', 'onpaste', 'onpropertychange', 'onreadystatechange', 'onreset', 'onresize', 'onresizeend', 'onresizestart', 'onrowenter', 'onrowexit', 'onrowsdelete', 'onrowsinserted', 'onscroll', 'onselect', 'onselectionchange', 'onselectstart', 'onstart', 'onstop', 'onsubmit', 'onunload');
   $ra = array_merge($ra1, $ra2);

   $found = true; // keep replacing as long as the previous round replaced something
   while ($found == true) {
      $val_before = $val;
      for ($i = 0; $i < sizeof($ra); $i++) {
         $pattern = '/';
         for ($j = 0; $j < strlen($ra[$i]); $j++) {
            if ($j > 0) {
               $pattern .= '(';
               $pattern .= '(&#[xX]0{0,8}([9ab]);)';
               $pattern .= '|';
               $pattern .= '|(&#0{0,8}([9|10|13]);)';
               $pattern .= ')*';
            }
            $pattern .= $ra[$i][$j];
         }
         $pattern .= '/i';
         $replacement = substr($ra[$i], 0, 2).'<x>'.substr($ra[$i], 2); // add in <> to nerf the tag
         $val = preg_replace($pattern, $replacement, $val); // filter out the hex tags
         if ($val_before == $val) {
            // no replacements were made, so exit the loop
            $found = false;
         }
      }
   }
   $val =  t($val);
   return $val;
}
/*
 *当选择服务器采集时判断是否已采集
 */
 function collected($url)
 {
	 global $db;

		$id =getid($url);

		if($id == 0)
		return false;
		$taobao_url  = "http://item.taobao.com/item.htm?id=".$id;
		$tmall_url  = "http://detail.tmall.com/item.htm?id=".$id;


		$key = 'taobao_'.$id;
		$share_goods = 0;
		$share_goods = $db->once_fetch_assoc("select * from ".dbprefix."share_goods where url = '$taobao_url'");

		if($share_goods)
		{
			$result['status'] = -1;
			$result['goods_id'] = $share_goods['goods_id'];
			return $result;
		}
 }

 /*
 *获取ID
 */
function getid($url)
	{
		$id = 0;
		$parse = parse_url($url);
		if(isset($parse['query']))
		{
		parse_str($parse['query'],$params);
		if(isset($params['id']))
		$id = $params['id'];
		elseif(isset($params['item_id']))
		$id = $params['item_id'];
		elseif(isset($params['default_item_id']))
		$id = $params['default_item_id'];
		}
		return $id;
	}

/**
 * 被禁止的关键字检测
 *
 * @param string $string 	要检测的字符串
 * @param string $fileName	屏蔽关键字文件
 * @return bool
 */
function banwordCheck( $string)
{
	global $TS_USER,$app,$le,$ts;
	$arr_words = fileRead('banwords.php','data','system');
	$le=$le?$le:$ts;
	$words=$arr_words[2];
	if ($words){

		$matched = preg_match('/'.$words.'/i', $string, $result);
		if ( $matched && isset($result[0]) && strlen($result[0]) > 0 )
		{
			if ( strlen($result[0]) == 2 ){
				$matched = preg_match('/'.$words.'/iu', $string, $result);
			}	
			if ( $matched && isset($result[0]) && strlen($result[0]) > 0 )	{
				$ip = getIp();
				$time=date("Y-m-d H:i:s");
				$str="关键词：".$result[0]. "，出处：".$app."/".$le."， 发布者：".$TS_USER['user']['username']." ， IP：".$ip."  时间：".$time."\r\n";
				$l=fopen($arr_words[1].".txt","a");
				fwrite($l,$str);
				fclose($l);
				return true;
			}else{
				return false;
			}		
		}else{
			return false;
		}
	}
}

	//判断用户是否手机访问
function check_wap(){
	  	// 先检查是否为wap代理，准确度高
		if(stristr($_SERVER['HTTP_VIA'],"wap")){
	    	return true;
	  	}
		// 检查浏览器是否接受 WML.
    	elseif(strpos(strtoupper($_SERVER['HTTP_ACCEPT']),"VND.WAP.WML") > 0){
        	return true;
   		}   		
		//检查USER_AGENT
  		elseif(preg_match('/(blackberry|configuration\/cldc|hp |hp-|htc |htc_|htc-|iemobile|kindle|midp|mmp|motorola|mobile|nokia|opera mini|opera |Googlebot-Mobile|YahooSeeker\/M1A1-R2D2|android|iphone|ipod|mobi|palm|palmos|pocket|portalmmm|ppc;|smartphone|sonyericsson|sqh|spv|symbian|treo|up.browser|up.link|vodafone|windows ce|xda |xda_)/i', $_SERVER['HTTP_USER_AGENT'])){
        	return true;             
    	}
    	else{
        	return false;    
   		}
	}

//淘宝正则匹配
	function get_word($html,$star,$end){
			$pat = '/'.$star.'(.*?)'.$end.'/s';
			if(!preg_match_all($pat, $html, $mat)) {
			}else{
				$wd= $mat[1][0];
			}
			return $wd;
	}
