<?php
/**
 * mobile公共方法
 *
 * 公共方法
 *
 * @package    function
 * @copyright  Copyright (c) 2014-2015 TaomiSC Inc. (http://www.taomisc.com)
 * @license    http://www.taomisc.com/
 * @link       http://www.taomisc.com/
 * @author	   TaomiSC Team
 * @since      File available since Release v1.1
 */
defined('IN_TS') or die('Access Denied.');

function output_data($datas, $extend_data = array()) {
    $data = array();
    $data['code'] = 200;

    if(!empty($extend_data)) {
        $data = array_merge($data, $extend_data);
    }

    $data['datas'] = $datas;
    
    if(!empty($_GET['callback'])) {
        echo $_GET['callback'].'('.json_encode($data).')';die;
    } else {
        echo json_encode($data);die;
    }
}

function output_error($message, $extend_data = array()) {
    $datas = array('error' => $message);
    output_data($datas, $extend_data);
}

function mobile_page($page_count) {
    //输出是否有下一页
    $extend_data = array();
    $current_page = intval($_GET['curpage']);
    if($current_page <= 0) {
        $current_page = 1;
    }
    if($current_page >= $page_count) {
        $extend_data['hasmore'] = false;
    } else {
        $extend_data['hasmore'] = true;
    }
    $extend_data['page_total'] = $page_count;
    return $extend_data;
}

