<?php
/* 乐兔淘授权
 * @version 1.0.0
 * @author 70020765@qq.com
 * @copyright © 2013, Tuntron Corporation. All rights reserved.
 */
 
require_once("URL.class.php");

class LetushuoOauth{

    const VERSION = "1.0";
    const GET_AUTH_CODE_URL = "http://au.letushuo.com/index.php?app=oauth&ac=authorize_new";

    protected $recorder;
    public $urlUtils;
    protected $error;
	
	private $lic_username;
    private $lic_code;
    private $lic_url;
    
    function __construct(){
        $this->urlUtils = new URL();
		$this->error = new ErrorCase();
		$options_lic = fileRead('options.php','data','system');
		$lic_url = 'index.php?app=lic&ac=lication';
        $this->lic_username = urlencode($options_lic['lic_username']);
		$this->lic_code = $options_lic['site_lication'];
		$this->lic_url = base64_encode($_SERVER['HTTP_HOST']);
    }
	
	 public function check_licinfo(){
		 

        //-------构造请求参数列表
        $keysArr = array(
            "lic_username" => $this->lic_username,
            "lic_code"     => $this->lic_code,
            "lic_url"      => $this->lic_url,
			"action"       => 'licinfo',
        );
       // $get_url =  $this->urlUtils->combineURL(self::GET_AUTH_CODE_URL, $keysArr);
		$response = $this->urlUtils->post(self::GET_AUTH_CODE_URL, $keysArr);
		
		  //--------验证state防止CSRF攻击
        if(empty($response)){
            $this->error->showError("30001");
        }
		
       return $response;
    }

    public function set_options($post){

        //-------构造请求参数列表
        $keysArr = array(
            "lic_username" => $this->lic_username,
            "lic_code"     => $this->lic_code,
            "lic_url"      => $this->lic_url,
			"action"       => 'options',
            "post"         =>  base64_encode(getJson($post))
        );
       // $get_url =  $this->urlUtils->combineURL(self::GET_AUTH_CODE_URL, $keysArr);
		$response = $this->urlUtils->post(self::GET_AUTH_CODE_URL, $keysArr);
		
		  //--------验证state防止CSRF攻击
        if(empty($response)){
            $this->error->showError("30001");
        }
		
       return $response;
    }
	
	
	public function isCode($username,$code){
		
        //-------构造请求参数列表
        $keysArr = array(
            "lic_username" => urlencode($username),
            "lic_code"     => $code,
            "lic_url"      => $this->lic_url,
			"action"       => 'isCode'
        );
		$response = $this->urlUtils->post(self::GET_AUTH_CODE_URL, $keysArr);
		
       return $response;
    }

	
}
