<?php
/**
 * TOP API: taobao.hotel.name.get request
 * 
 * @author auto create
 * @since 1.0, 2013-11-17 16:59:01
 */
class HotelNameGetRequest
{
	/** 
	 * 城市编码。参见：http://kezhan.trip.taobao.com/area.html。
domestic为true时，province,city,district不能同时为空或为0
	 **/
	private $city;
	
	/** 
	 * domestic为true时，固定China；
domestic为false时，必须传定义的海外国家编码值，是必填项。参见：http://kezhan.trip.taobao.com/countrys.html
	 **/
	private $country;
	
	/** 
	 * 区域（县级市）编码。参见：http://kezhan.trip.taobao.com/area.html。
domestic为true时，province,city,district不能同时为空或为0
	 **/
	private $district;
	
	/** 
	 * 是否国内酒店。可选值：true，false
	 **/
	private $domestic;
	
	/** 
	 * 酒店全部名称/别名。不能超过60字节
	 **/
	private $name;
	
	/** 
	 * 省份编码。参见：http://kezhan.trip.taobao.com/area.html。
domestic为true时，province,city,district不能同时为空或为0
	 **/
	private $province;
	
	private $apiParas = array();
	
	public function setCity($city)
	{
		$this->city = $city;
		$this->apiParas["city"] = $city;
	}

	public function getCity()
	{
		return $this->city;
	}

	public function setCountry($country)
	{
		$this->country = $country;
		$this->apiParas["country"] = $country;
	}

	public function getCountry()
	{
		return $this->country;
	}

	public function setDistrict($district)
	{
		$this->district = $district;
		$this->apiParas["district"] = $district;
	}

	public function getDistrict()
	{
		return $this->district;
	}

	public function setDomestic($domestic)
	{
		$this->domestic = $domestic;
		$this->apiParas["domestic"] = $domestic;
	}

	public function getDomestic()
	{
		return $this->domestic;
	}

	public function setName($name)
	{
		$this->name = $name;
		$this->apiParas["name"] = $name;
	}

	public function getName()
	{
		return $this->name;
	}

	public function setProvince($province)
	{
		$this->province = $province;
		$this->apiParas["province"] = $province;
	}

	public function getProvince()
	{
		return $this->province;
	}

	public function getApiMethodName()
	{
		return "taobao.hotel.name.get";
	}
	
	public function getApiParas()
	{
		return $this->apiParas;
	}
	
	public function check()
	{
		
		RequestCheckUtil::checkNotNull($this->domestic,"domestic");
		RequestCheckUtil::checkNotNull($this->name,"name");
		RequestCheckUtil::checkMaxLength($this->name,60,"name");
	}
	
	public function putOtherTextParam($key, $value) {
		$this->apiParas[$key] = $value;
		$this->$key = $value;
	}
}
