<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class admin_control extends common_control {

	function __construct(&$conf) {
		// hook admin_control_construct_before.php
		parent::__construct($conf);
		// hook admin_control_construct_after.php
		
		// 这里可能会有跨站脚本导致的提交，可以触发安全警报。管理员应该定期查看后台日志。
		$this->check_mod_group();
		$admin_auth = core::gpc($this->conf['cookie_pre'].'admin_auth', 'R');
		$login = 0;
		if(empty($admin_auth)) {
			// 登录页面放行
			 if(!(core::gpc(0) == 'index' && (core::gpc(1) == 'login' || core::gpc(1) == 'logout'))) {
				$login = 1;
			}
		} else {
			$browser = md5($_SERVER['HTTP_USER_AGENT']);
			$key = $this->conf['auth_key'].$browser;
			$s = decrypt($admin_auth, $key);
			if(empty($s)) {
				$login = 1;
			} else {
				$arr = explode("\t", $s);
				if(empty($arr)) {
					$login = 1;
				} else {
					list($time, $ip, $browser) = $arr;
					
					/*
						1. 超出一小时，退出登录，设置一天，解决时差问题。
						2. IP发生变化，退出登录
						3. 更换浏览器，退出登录
					*/
					
					if($_SERVER['time'] - $time > 3600 || $ip != $_SERVER['ip'] || (!(core::gpc(0) == 'forum' && core::gpc(1) == 'uploadicon') && $browser != md5($_SERVER['HTTP_USER_AGENT']))) {
						$login = 1;
					}
				}
			}
			// dateline	ip	browser
		}
		if($login) {
			misc::setcookie($this->conf['cookie_pre'].'admin_auth', '', $_SERVER['time'], '/');
			misc::setcookie($this->conf['cookie_pre'].'admin_auth', '', $_SERVER['time'], 'admin/');
			echo '<html><body><script>top.location="?index-login.htm"</script></body></html>';
			exit;
		}
		
		// hook admin_control_check_after.php
	}
	
	// 是否为最高级别的管理员
	protected function check_admin_group() {
		if($this->_group['groupid'] != 1) {
			$this->message('对不起，您不是管理员，无权访问。');
		}
	}
	
	protected function check_mod_group() {
		if($this->_group['groupid'] == 0 || $this->_group['groupid']  > 5) {
			log::write("非法尝试后台登录", 'login.php');
			$this->message('对不起，您所在的用户组不是管理组，无权访问。');
		}
	}
	
	//hook admin_admin_control_after.php
}

?>