<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'admin/control/admin_control.class.php';

class conf_control extends admin_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->check_admin_group();
	}
	
	public function on_index() {
		
		$this->on_base();
	}
	
	public function on_base() {
		$conf = $this->conf;
		
		$input = array();
		$kvconf = $this->kv->xget('conf') + $this->kv->xget('conf_ext');
		$error = $post = array();
		//$bbs = include POST_PATH.'conf/conf.php';
		//$error = $post = array();
		if($this->form_submit()) {
			$post['app_name'] = core::gpc('app_name', 'P');
			$post['urlrewrite'] = intval(core::gpc('urlrewrite', 'P'));
			$post['timeoffset'] = core::gpc('timeoffset', 'P');
			$post['upload_url'] = core::gpc('upload_url', 'P');
			$post['static_url'] = core::gpc('static_url', 'P');
			$post['post_update_expiry'] = intval(core::gpc('post_update_expiry', 'P'));
			$post['credits_policy_post'] = intval(core::gpc('credits_policy_post', 'P'));
			$post['credits_policy_reply'] = intval(core::gpc('credits_policy_reply', 'P'));
			$post['golds_policy_reply'] = intval(core::gpc('golds_policy_reply', 'P'));
			$post['credits_policy_thread'] = intval(core::gpc('credits_policy_thread', 'P'));
			$post['credits_policy_digest_1'] = intval(core::gpc('credits_policy_digest_1', 'P'));
			$post['credits_policy_digest_2'] = intval(core::gpc('credits_policy_digest_2', 'P'));
			$post['credits_policy_digest_3'] = intval(core::gpc('credits_policy_digest_3', 'P'));
			$post['golds_policy_post'] = intval(core::gpc('golds_policy_post', 'P'));
			$post['golds_policy_thread'] = intval(core::gpc('golds_policy_thread', 'P'));
			$post['golds_policy_digest_1'] = intval(core::gpc('golds_policy_digest_1', 'P'));
			$post['golds_policy_digest_2'] = intval(core::gpc('golds_policy_digest_2', 'P'));
			$post['golds_policy_digest_3'] = intval(core::gpc('golds_policy_digest_3', 'P'));
			$post['cache_pid'] = intval(core::gpc('cache_pid', 'P'));
			$post['cache_tid'] = intval(core::gpc('cache_tid', 'P'));
			$post['app_brief'] = core::gpc('app_brief', 'P');
			$post['app_starttime'] = core::gpc('app_starttime', 'P');
			$post['tmp_path'] = core::gpc('tmp_path', 'P');
			$post['click_server'] = core::gpc('click_server', 'P');
			$post['reg_on'] = intval(core::gpc('reg_on', 'P'));
			//$post['reg_ucenter'] = intval(core::gpc('reg_ucenter', 'P'));
			$post['reg_email_on'] = intval(core::gpc('reg_email_on', 'P'));
			$post['reg_init_golds'] = intval(core::gpc('reg_init_golds', 'P'));
			$post['resetpw_on'] = intval(core::gpc('resetpw_on', 'P'));
			$post['app_copyright'] = core::gpc('app_copyright', 'P');
			$post['seo_title'] = core::gpc('seo_title', 'P');
			$post['seo_keywords'] = core::gpc('seo_keywords', 'P');
			$post['seo_description'] = core::gpc('seo_description', 'P');
			$post['threadlist_hotviews'] = intval(core::gpc('threadlist_hotviews', 'P'));
			$post['search_type'] = core::gpc('search_type', 'P');
			$post['sphinx_host'] = core::gpc('sphinx_host', 'P');
			$post['sphinx_port'] = core::gpc('sphinx_port', 'P');
			$post['sphinx_datasrc'] = core::gpc('sphinx_datasrc', 'P');
			$post['sphinx_deltasrc'] = core::gpc('sphinx_deltasrc', 'P');
			$post['china_icp'] = core::gpc('china_icp', 'P');
			$post['footer_js'] = core::gpc('footer_js', 'P');
			$post['site_pv'] = intval(core::gpc('site_pv', 'P'));
			$post['site_runlevel'] = intval(core::gpc('site_runlevel', 'P'));
			$post['forum_index_pagesize'] = intval(core::gpc('forum_index_pagesize', 'P'));
			$post['pagesize'] = intval(core::gpc('pagesize', 'P'));
			
			$post['url_forum'] = core::gpc('url_forum', 'P');
			$post['url_topic'] = core::gpc('url_topic', 'P');
			$post['today_forum'] = intval(core::gpc('today_forum', 'P'));
			
			// hook admin_conf_base_gpc_after.php
			
			// check 数据格式
			$error['app_name'] = $this->check_app_name($post['app_name']);
			
			if(!array_filter($error)) {
				$error = array();
				
				// 全局的，加载合并到 runtime, 每次请求都从 runtime 加载。
				foreach(array('app_name', 'app_copyright', 'seo_title', 'seo_keywords', 'seo_description', 
					'threadlist_hotviews', 'post_update_expiry', 'china_icp', 'footer_js', 'site_pv', 'site_runlevel', 'forum_index_pagesize','pagesize','reg_on', 'search_type','urlrewrite','url_forum','url_topic','today_forum'
					) as $k) {
					$this->runtime->xset($k, $post[$k], 'runtime');
					$this->kv->xset($k, $post[$k], 'conf');
				}
				
				// 局部的，按需加载 conf_ext
				foreach(array('credits_policy_post', 'credits_policy_thread', 
					'credits_policy_digest_1', 'credits_policy_digest_2', 'credits_policy_digest_3',
					'golds_policy_post', 'golds_policy_thread',
					'golds_policy_digest_1', 'golds_policy_digest_2', 'golds_policy_digest_3',
					'reg_email_on', 'reg_init_golds', 'resetpw_on',
					'sphinx_host', 'sphinx_port', 'sphinx_datasrc', 'sphinx_deltasrc',
					) as $k) {
					$this->kv->xset($k, $post[$k], 'conf_ext');
				}
				
/*				$this->mconf->set_to('app_name', $post['app_name']);
				$this->mconf->set_to('urlrewrite', $post['urlrewrite']);
				$this->mconf->set_to('timeoffset', $post['timeoffset']);
				$this->mconf->set_to('upload_url', $post['upload_url']);
				$this->mconf->set_to('static_url', $post['static_url']);
				$this->mconf->set_to('click_server', $post['click_server']);
				$this->mconf->set_to('credits_policy_post', $post['credits_policy_post']);
				$this->mconf->set_to('credits_policy_reply', $post['credits_policy_reply']);
				$this->mconf->set_to('golds_policy_reply', $post['golds_policy_reply']);
				$this->mconf->set_to('credits_policy_thread', $post['credits_policy_thread']);
				$this->mconf->set_to('credits_policy_digest_1', $post['credits_policy_digest_1']);
				$this->mconf->set_to('credits_policy_digest_2', $post['credits_policy_digest_2']);
				$this->mconf->set_to('credits_policy_digest_3', $post['credits_policy_digest_3']);
				$this->mconf->set_to('golds_policy_post', $post['golds_policy_post']);
				$this->mconf->set_to('golds_policy_thread', $post['golds_policy_thread']);
				$this->mconf->set_to('golds_policy_digest_1', $post['golds_policy_digest_1']);
				$this->mconf->set_to('golds_policy_digest_2', $post['golds_policy_digest_2']);
				$this->mconf->set_to('golds_policy_digest_3', $post['golds_policy_digest_3']);
				$this->mconf->set_to('cache_pid', $post['cache_pid']);
				$this->mconf->set_to('cache_tid', $post['cache_tid']);
				$this->mconf->set_to('app_brief', $post['app_brief']);
				$this->mconf->set_to('app_starttime', $post['app_starttime']);
				$this->mconf->set_to('reg_on', $post['reg_on']);
				//$this->mconf->set_to('reg_ucenter', $post['reg_ucenter']);
				$this->mconf->set_to('reg_email_on', $post['reg_email_on']);
				$this->mconf->set_to('reg_init_golds', $post['reg_init_golds']);
				$this->mconf->set_to('resetpw_on', $post['resetpw_on']);
				$this->mconf->set_to('app_copyright', $post['app_copyright']);
				$this->mconf->set_to('seo_title', $post['seo_title']);
				$this->mconf->set_to('seo_keywords', $post['seo_keywords']);
				$this->mconf->set_to('seo_description', $post['seo_description']);
				$this->mconf->set_to('threadlist_hotviews', $post['threadlist_hotviews']);
				$this->mconf->set_to('search_type', $post['search_type']);
				$this->mconf->set_to('sphinx_host', $post['sphinx_host']);
				$this->mconf->set_to('sphinx_port', $post['sphinx_port']);
				$this->mconf->set_to('sphinx_datasrc', $post['sphinx_datasrc']);
				$this->mconf->set_to('sphinx_deltasrc', $post['sphinx_deltasrc']);
				$this->mconf->set_to('china_icp', $post['china_icp']);
				$this->mconf->set_to('footer_js', $post['footer_js']);
				$this->mconf->set_to('site_pv', $post['site_pv']);
				$this->mconf->set_to('site_runlevel', $post['site_runlevel']);
				$this->mconf->set_to('forum_index_pagesize', $post['forum_index_pagesize']);
				$this->mconf->set_to('pagesize', $post['pagesize']);*/
				
				// hook admin_conf_base_set_after.php
				
				//$this->mconf->set_to('tmp_path', $post['tmp_path']);
				//$this->mconf->save();
			}
			
			// 删除模板缓存
			//$this->truncate_tpl_cache();
		}
		
		// 用 $post 覆盖 $bbs
		$bbs = array_merge($kvconf, $post);

		$input['app_name'] = form::get_text('app_name', $bbs['app_name'], 300);
		$input['app_copyright'] = form::get_text('app_copyright', $bbs['app_copyright'], 300);
		//$input['app_starttime'] = form::get_text('app_starttime', $bbs['app_starttime'], 150);
		//$input['static_url'] = form::get_text('static_url', $bbs['static_url'], 300);
		//$input['upload_url'] = form::get_text('upload_url', $bbs['upload_url'], 300);
		//$input['click_server'] = form::get_text('click_server', $bbs['click_server'], 300);
		//$input['tmp_path'] = form::get_text('tmp_path', str_replace('\\', '/', realpath($bbs['tmp_path'])).'/', 300);
		$input['urlrewrite'] = form::get_radio_yes_no('urlrewrite', $bbs['urlrewrite']);
		//$input['timeoffset'] = form::get_select('timeoffset', $timezones, $bbs['timeoffset']);
		$input['credits_policy_post'] = form::get_text('credits_policy_post', $bbs['credits_policy_post'], 50);
		//$input['credits_policy_reply'] = form::get_text('credits_policy_reply', $bbs['credits_policy_reply'], 50);
		//$input['golds_policy_reply'] = form::get_text('golds_policy_reply', $bbs['golds_policy_reply'], 50);
		$input['credits_policy_thread'] = form::get_text('credits_policy_thread', $bbs['credits_policy_thread'], 50);
		$input['credits_policy_digest_1'] = form::get_text('credits_policy_digest_1', $bbs['credits_policy_digest_1'], 50);
		$input['credits_policy_digest_2'] = form::get_text('credits_policy_digest_2', $bbs['credits_policy_digest_2'], 50);
		$input['credits_policy_digest_3'] = form::get_text('credits_policy_digest_3', $bbs['credits_policy_digest_3'], 50);
		$input['golds_policy_post'] = form::get_text('golds_policy_post', $bbs['golds_policy_post'], 50);
		$input['golds_policy_thread'] = form::get_text('golds_policy_thread', $bbs['golds_policy_thread'], 50);
		$input['golds_policy_digest_1'] = form::get_text('golds_policy_digest_1', $bbs['golds_policy_digest_1'], 50);
		$input['golds_policy_digest_2'] = form::get_text('golds_policy_digest_2', $bbs['golds_policy_digest_2'], 50);
		$input['golds_policy_digest_3'] = form::get_text('golds_policy_digest_3', $bbs['golds_policy_digest_3'], 50);
		//$input['cache_pid'] = form::get_radio_yes_no('cache_pid', $bbs['cache_pid']);
		//$input['cache_tid'] = form::get_radio_yes_no('cache_tid', $bbs['cache_tid']);
		$input['reg_on'] = form::get_radio_yes_no('reg_on', $bbs['reg_on']);
		//$input['reg_ucenter'] = form::get_radio_yes_no('reg_ucenter', $bbs['reg_ucenter']);
		$input['reg_email_on'] = form::get_radio_yes_no('reg_email_on', $bbs['reg_email_on']);
		$input['reg_init_golds'] = form::get_text('reg_init_golds', $bbs['reg_init_golds'], 50);
		$input['resetpw_on'] = form::get_radio_yes_no('resetpw_on', $bbs['resetpw_on']);
		$input['seo_title'] = form::get_text('seo_title', $bbs['seo_title'], 300);
		$input['seo_keywords'] = form::get_text('seo_keywords', $bbs['seo_keywords'], 300);
		$input['seo_description'] = form::get_text('seo_description', $bbs['seo_description'], 300);
		$input['threadlist_hotviews'] = form::get_text('threadlist_hotviews', $bbs['threadlist_hotviews'], 50);
		$input['post_update_expiry'] = form::get_text('post_update_expiry', $bbs['post_update_expiry'], 50);
		$input['search_type'] = form::get_radio('search_type', array(''=>'无', 'title'=>'标题', 'baidu'=>'百度', 'google'=>'谷歌', 'bing'=>'Bing', 'sphinx'=>'Sphinx'), $bbs['search_type']);
		$input['sphinx_host'] = form::get_text('sphinx_host', $bbs['sphinx_host'], 150);
		$input['sphinx_port'] = form::get_text('sphinx_port', $bbs['sphinx_port'], 100);
		//$input['sphinx_datasrc'] = form::get_text('sphinx_datasrc', $bbs['sphinx_datasrc'], 100);
		//$input['sphinx_deltasrc'] = form::get_text('sphinx_deltasrc', $bbs['sphinx_deltasrc'], 100);
		$input['china_icp'] = form::get_text('china_icp', $bbs['china_icp'], 150);
		$input['footer_js'] = form::get_text('footer_js', htmlspecialchars($bbs['footer_js']), 300);
		$input['site_pv'] = form::get_text('site_pv', $bbs['site_pv'], 70);
		$input['site_runlevel'] = form::get_radio('site_runlevel', array(0=>'所有人可访问', 1=>'会员可访问', 2=>'吧主可访问', 3=>'管理员可访问'), $bbs['site_runlevel']);
		$input['forum_index_pagesize'] =  form::get_text('forum_index_pagesize', $bbs['forum_index_pagesize'], 50);
		$input['pagesize'] =  form::get_text('pagesize', $bbs['pagesize'], 50);
		$input['url_forum'] =  form::get_text('url_forum', $bbs['url_forum'], 300);
		$input['url_topic'] =  form::get_text('url_topic', $bbs['url_topic'], 300);
		$input['today_forum'] =  form::get_text('today_forum', $bbs['today_forum'], 50);
		
		// hook admin_conf_base_input_after.php
		
		$maxtid = $this->topic->maxid();
		
		$limittid = $maxtid; // $maxtid * 2
		
		$this->view->assign('limittid', $limittid);
		$this->view->assign('maxtid', $maxtid);
		$this->view->assign('input', $input);
		$this->view->assign('bbs', $bbs);
		$this->view->assign('error', $error);
		$this->view->display('conf_base.html');
	}
	
	private function replace_key_value($k, $v, $s) {
		$s = preg_replace('#\$'.$k.'\s*=\s*(\d+?);#ism', "\$$k = $v;", $s);
		$s = preg_replace('#\$'.$k.'\s*=\s*\'(.*?)\';#ism', "\$$k = '$v';", $s);
		return $s;
	}
		// 设置 SMTP 账号
	public function on_mail() {
		$this->_checked['mail']=1;
		$error = array();
		
		$mailconf = $this->kv->get('mail_conf');
		
		$sendtype = &$mailconf['sendtype'];
		$smtplist = &$mailconf['smtplist'];
		if($this->form_submit()) {
			$email = (array)core::gpc('email', 'P');
			$host = (array)core::gpc('host', 'P');
			$port = (array)core::gpc('port', 'P');
			$user = (array)core::gpc('user', 'P');
			$pass = (array)core::gpc('pass', 'P');
			$delete = (array)core::gpc('delete', 'P');
			$sendtype = intval(core::gpc('sendtype', 'P'));
			$smtplist = array();
			foreach($email as $k=>$v) {
				empty($port[$k]) && $port[$k] = 25;
				if(in_array($k, $delete)) continue;
				if(empty($email[$k]) || empty($host[$k]) || empty($user[$k])) continue;
				$smtplist[$k] = array('email'=>$email[$k], 'host'=>$host[$k], 'port'=>$port[$k], 'user'=>$user[$k], 'pass'=>$pass[$k]);
			}
			
			$this->kv->set('mail_conf', $mailconf);
			
			$mail_smtplist = $smtplist;
			
			// hook admin_conf_mail_view_before.php
			
		}
		
		$input = array();
		$input['sendtype'] = form::get_radio('sendtype', array(0=>'PHP内置mail函数 ', 1=>'SMTP 方式'), $sendtype);
		
		$this->view->assign('error', $error);
		$this->view->assign('smtplist', $smtplist);
		$this->view->assign('input', $input);
		
		// hook admin_conf_mail_view_before.php
		
		$this->view->display('conf_mail.html');
	}
	// 关键词过滤
	public function on_badword() {
		$badword = $this->kv->get('badword');
		$badword === FALSE && $badword = array();
		$badword_on = $this->conf['badword_on'];
		$error = $input = array();
		if($this->form_submit()) {
			$badword = trim(core::gpc('badword', 'P'));
			$badword = str_replace("　 ", ' ', $badword);
			$badword = str_replace("：", ':', $badword);
			$badword = str_replace(": ", ':', $badword);
			$badword = preg_replace('#\s+#is', ' ', $badword);
			$badword_on = intval(core::gpc('badword_on', 'P'));
			// $error['badword'] = $badword;
			$badword = misc::explode(':', ' ', $badword);
			//$badword = array_filter($badword);

			$this->kv->set('badword', $badword);
			$this->kv->xset('badword_on', $badword_on);
			$this->runtime->xset('badword_on', $badword_on);
			$this->conf['badword_on'] = $badword_on;
		}
		$input['badword_on'] = form::get_radio_yes_no('badword_on', $this->conf['badword_on']);
		core::htmlspecialchars($badword);
		$badword = misc::implode(':', ' ', $badword);
		$this->view->assign('badword', $badword);
		$this->view->assign('input', $input);
		$this->view->assign('error', $error);
		$this->view->display('conf_badword.html');
	}
    public function on_cache() {
		
		$tmp = core::gpc('tmp', 'P');
		$runtime = core::gpc('runtime', 'P');
		$forum = core::gpc('forum', 'P');
		//$thread_new = core::gpc('thread_new', 'P');
		$count_maxid = core::gpc('count_maxid', 'P');
		
		// tmp
		if($tmp) {
			$this->clear_tmp();
		}
		
		// 清空 runtime
		if($runtime) {
			$this->runtime->truncate();
		}
		
		// 清空版块缓存
		if($forum) {
			$forumarr = $this->conf['forumarr'];
			foreach($forumarr as $fid=>$name) {
				$this->mcache->clear('forum', $fid);
				$this->mcache->clear('forum_fn',$name);
			}
			$this->runtime->xupdate('forumarr');
		}
		$kvarr=array('hotuser','rank_today','rank_week','rank_all','rank_reply','rank_forum','rank_tags','rank_lastuser','rank_followuser','rank_postuser','index_newlist','index_replylist');
		foreach($kvarr as $k){
			$this->kv->delete($k);
		}
		
		// 校对 framework 的 count, maxid
		if($count_maxid) {

                        // copy  from install_mongodb           
                        $maxs = array(
                                'group'=>'groupid',
                                'member'=>'uid',
                                'member_access'=>'uid',
                                'forum'=>'fid',
                                'forum_access'=>'fid',
                                'topic'=>'tid',
                                'post'=>'pid',
                                'attachment'=>'aid',
                                'pm'=>'pmid',
								'category'=>'id'
                        );

                        foreach($maxs as $table=>$maxcol) {
                                if(isset($this->$table->maxcol)) {
                                        $m = $this->$table->index_maxid();
                                        $this->$table->maxid($m);
                                }
                                
                                $n = $this->$table->index_count();
                                $this->$table->count($n);
                        }
                        
                        // online 比较特殊
                        $n = $this->online->index_count();
                        $this->online->count($n);
                        $this->runtime->xset('onlines', $n);
                }
                
		// hook admin_conf_cache_view_before.php
		
		$this->view->display('conf_cache.html');
	}
	private function check_app_name(&$app_name) {
		if(utf8::strlen($app_name) > 32) {
			return '站点名称不能超过32个字符: '.$app_name.'<br />';
		}
		return '';
	}

	public function truncate_tpl_cache() {
		$this->clear_cache($this->conf['tmp_path'], 'bbs_');
		$this->clear_cache($this->conf['tmp_path'], 'bbsadmin_');
	}
	
	private function clear_cache($dir, $pre) {
		$dh = opendir($dir);
		while(($file = readdir($dh)) !== false ) {
			if($file != "." && $file != ".." ) {
				if(is_dir( $dir . $file ) ) {
					//opendir_recursive( $dir . $file . "/", $recall);
				} else {
					if(substr($file, 0, strlen($pre)) == $pre) {
						unlink($dir."$file");
					}
				}
			}
		}
		closedir($dh);
	}
		
	private function truncate_dir($dir) {
		$dh = opendir($dir);
		while(($file = readdir($dh)) !== false ) {
			if($file != "." && $file != ".." ) {
				if(is_dir( $dir . $file ) ) {
					//opendir_recursive( $dir . $file . "/", $recall);
				} else {
					unlink($dir."$file");
				}
			}
		}
		closedir($dh);
	}
	
	//hook admin_conf_control_after.php

}

?>