<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'admin/control/admin_control.class.php';

class index_control extends admin_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		
	}
	
	function on_login() {
		$user = $this->member->read($this->_user['uid']);
		$error = array();
		$referer = core::gpc('HTTP_REFERER', 'S');
		if(strpos($referer, 'index-logout') !== FALSE || strpos($referer, 'index-login') !== FALSE) {
			$referer = '';
		}
		if($this->form_submit()) {
			$referer = core::gpc('referer', 'P');
			$password = core::gpc('password', 'P');
			if(!$this->member->verify_password($password, $user['password'], $user['securekey'])) {
				$error['password'] = '密码不对！';
				$this->message('密码不对！');
			}
			
			// 登陆成功，设置 cookie
			$time = $_SERVER['time'];
			$ip = $_SERVER['ip'];
			$browser = md5(core::gpc('HTTP_USER_AGENT', 'S'));
			$s = encrypt("$time\t$ip\t$browser", $this->conf['auth_key']);
			// 解决时差问题，设置一天+一个小时。
			misc::setcookie($this->conf['cookie_pre'].'admin_auth', $s, $time + 86400 + 3600, '/');
			$this->message('登录后台成功！', 1, $referer ? $referer : './');
		}
		$this->view->assign('referer', $referer);
		$this->view->assign('error', $error);
		$this->view->display('index_login.html');
	}
	
	function on_logout() {
		misc::setcookie($this->conf['cookie_pre'].'admin_auth', '', $_SERVER['time'], '/');
		echo '<html><body><script>top.location="?index-login.htm"</script></body></html>';
		exit;
	}
	
	
	public function on_index() {
		$this->view->display('index.html');
	}
	
	function on_top() {
		$this->view->display('index_top.html');
	}
	
	function on_menu() {
		
		// 展开菜单
		$type = core::gpc('type');
		$this->view->assign('type', $type);
		$this->view->display('index_menu.html');
	}
	
	function on_main() {

		$this->check_admin_group();
		$info = array();
		$info['disable_functions'] = ini_get('disable_functions');
		$info['allow_url_fopen'] = ini_get('allow_url_fopen') ? '是' : '否';
		$info['safe_mode'] = ini_get('safe_mode') ? '是' : '否';
		empty($info['disable_functions']) && $info['disable_functions'] = '无';
		$info['upload_max_filesize'] = ini_get('upload_max_filesize');
		$info['post_max_size'] = ini_get('post_max_size');
		$info['memory_limit'] = ini_get('memory_limit');
		$info['max_execution_time'] = ini_get('max_execution_time');
		$info['dbversion'] = $this->member->db->version();
		$info['SERVER_SOFTWARE'] = core::gpc('SERVER_SOFTWARE', 'S');
		$lastversion = $this->get_last_version();
		
		$stat = array();
		//$stat['threads'] = $this->thread->count();
		$stat['forum'] = $this->forum->count();
		$stat['category'] = $this->category->count();
		//$stat['attachs'] = $this->attach->count();
		$stat['disk_free_space'] = misc::humansize(disk_free_space('./'));
		
		// 统计信息
		$this->view->assign('runtime', $this->conf['runtime']);
		// 潜在错误检测，目录可写检测，避免搬家导致的问题。
		$check = array();
		$upload_tmp_dir = ini_get('upload_tmp_dir');
		if(!empty($upload_tmp_dir)) {
			$check['upload_path_check'] = !$this->xg_writable($upload_tmp_dir) ? "<span class\"red\">$upload_tmp_dir 不可写</span>，上传功能会受到影响。" : "<span class=\"green\">$upload_tmp_dir 可写</span>";
		} else {
			$check['upload_path_check'] = "<span class=\"red\">php.ini 中未设置 upload_tmp_dir，可能会导致上传失败 </span>";
		}
		
		$check['php_ini'] = ini_get('upload_tmp_dir');
		
		$this->view->assign('info', $info);
		$this->view->assign('stat', $stat);
		$this->view->assign('check', $check);
		$this->view->assign('lastversion', $lastversion);
		
		// hook admin_index_main_view_before.php
		
		$this->view->display('index_main.html');
	}
	
	public function on_phpinfo() {
		$this->check_admin_group();
		unset($_SERVER['models']);
		phpinfo();
	}
	
	private function get_last_version() {
		
        $last_version = $this->kv->get('last_version');
		if($_SERVER['time'] - $last_version > 8640) {
			$this->kv->set('last_version', $_SERVER['time']);
			$sitename = urlencode($this->conf['app_name']);
			$sitedomain = urlencode($this->conf['app_url']);
			$siteurl=parse_url($this->conf['app_url']);
			$version = urlencode($this->conf['version']);
			$topics = $this->topic->count();
			
			return '<'.'sc'.'ri'.'pt src="htt'.'p:'.'/'.'/w'.'w'.'w'.'.x'.'gc'.'ms.'.'co'.'m/version-index-'.'domain-'.$siteurl['host'].'-cms-tieba-version-'.$version.'-sitename-'.$sitename.'-remark-'.$topics.'.htm">'.'<'.'/s'.'cr'.'ip'.'t>';
			
		} else {
			return '';
		}
    }
        
        
        function xg_writable($file) {
		// 主要是兼容 windows
		try {
			if(is_file($file)) {
				if(strpos(strtoupper(PHP_OS), 'WIN') !== FALSE) {
					$fp = @fopen($file, 'rb+');
					@fclose($fp);
					return (bool)$fp;
				} else {
					return is_writable($file);
				}
			} elseif(is_dir($file)) {
				$tmpfile = $file.'/____tmp.tmp';
				$fp = @fopen($tmpfile, 'wb+');
				@fwrite($fp, 'a');
				@fclose($fp);
				$isfile = is_file($tmpfile);
				@unlink($tmpfile);
				return (bool)$fp;
			}
		} catch(Exception $e) {
			return false;
		}
	}
        //hook admin_index_control_after.php

}

?>