<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'admin/control/admin_control.class.php';

class member_control extends admin_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->check_admin_group();
	}
	
	public function on_index() {
		$this->view->display('user.htm');
	}
	
	public function on_list() {
		$this->_title[] = '用户列表';
		$this->_nav[] = '<a href="./">用户列表</a>';
		
		$keyword = urldecode(core::gpc('keyword', 'R'));
		$keyword_url = urlencode($keyword);

		$cond = array();
		if($keyword) {
			if(is_numeric($keyword)) {
				$cond = array('uid'=>intval($keyword));
			} elseif(strpos($keyword, '@') !== FALSE) {
				$cond = array('email'=>$keyword);
			} else {
				$cond = array('username'=>array('LIKE'=>$keyword));
			}
		}
		if($this->form_submit()) {
			$uids = core::gpc('uids', 'P');
			if(!empty($uids)) {
				foreach($uids as $uid) {
					$uid = intval($uid);
					if($uid != 1 && $uid != $this->conf['system_uid']) {
						$this->member->xdelete($uid);
					}
				}
			}
		}
		
		$page = misc::page();
		$users = $cond ? 1 : $this->member->count();
		$userlist = $this->member->index_fetch($cond, array('regdate'=>2), ($page - 1) * $this->conf['pagesize'], $this->conf['pagesize']);
		foreach($userlist as &$user) {
			$this->member->format($user);
			$user['groupname'] = $this->group->groupid_to_name($user['groupid']);
		}
		
		$pages = misc::pages("?member-list.htm", $users, $page, $this->conf['pagesize']);
		
		$this->view->assign('t',$t);
		$this->view->assign('page', $page);
		$this->view->assign('$keyword', $$keyword);
		$this->view->assign('pages', $pages);
		$this->view->assign('users',$users);
		$this->view->assign('userlist', $userlist);
		
		// hook admin_user_list_view_before.php
		
		$this->view->display('member_list.html');
	}
	
	// 批量添加
	public function on_create() {
		$this->_title[] = '用户注册';
		$this->_nav[] = '用户注册';
		
		$user = $error = array();
		if($this->form_submit()) {
			
			// 接受数据
			$user['email'] = core::gpc('email', 'P');
			$user['username'] = core::gpc('username', 'P');
			$user['password'] = core::gpc('password', 'P');
			$password2 = core::gpc('password2', 'P');
			$user['regdate'] = $_SERVER['time'];
			
			$user['groupid'] = intval(core::gpc('groupid', 'P'));
			$user['topics'] = intval(core::gpc('topics', 'P'));
			$user['posts'] = intval(core::gpc('posts', 'P'));

			$post['digests'] = intval(core::gpc('digests', 'P'));
			$user['credits'] = intval(core::gpc('credits', 'P'));
			$user['golds'] = intval(core::gpc('golds', 'P'));
			$user['money'] = intval(core::gpc('money', 'P'));
			$user['password'] = core::gpc('password', 'P');
			
			
			
			// check 数据格式
			$error['email'] = $this->member->check_email($user['email']);
			$error['email_exists'] = $this->member->check_email_exists($user['email']);
			$error['username'] = $this->member->check_username($user['username']);
			$error['password'] = $this->member->check_password($user['password']);
			$error['password2'] = $this->member->check_password2($user['password'], $password2);
			
			// 判断结果
			if(!array_filter($error)) {
				$error = array();
				$salt = rand(100000, 999999);
				$user['securekey'] = $salt;
				$user['password'] = $this->member->md5_md5($user['password'], $salt);
				$this->member->create($user);
				$this->runtime->xset('users', '+1');
			}
		}
		
		$grouplist = $this->group->get_list();
		$grouparr = misc::arrlist_key_values($grouplist, 'groupid', 'name');
		$input['groupid'] = form::get_select('groupid', $grouparr,11);

		$input['topics'] = form::get_text('topics','', 100);
		$input['posts'] = form::get_text('posts', '', 100);
		$input['digests'] = form::get_text('digests', '', 100);
		$input['credits'] = form::get_text('credits','', 100);
		$input['golds'] = form::get_text('golds', '', 100);
		$input['money'] = form::get_text('money','', 100);
		
		
		$this->view->assign('input', $input);
		$this->view->assign('user', $user);
		$this->view->assign('error', $error);
		
		// hook admin_user_create_view_before.php
		
		$this->view->display('member_create.html');
	}
	
	// 修改
	public function on_update() {
		$this->_title[] = '修改用户资料';
		$this->_nav[] = '修改用户资料';
		
		$uid = intval(core::gpc('uid'));
		$user = $this->member->get($uid);
		$this->check_user_exists($user);
		
		$input = $error = array();
		if($this->form_submit()) {
			$post = array('uid'=>$uid);

			$post['email'] = core::gpc('email', 'P');
			$post['groupid'] = intval(core::gpc('groupid', 'P'));
			$post['topics'] = intval(core::gpc('topics', 'P'));
			$post['posts'] = intval(core::gpc('posts', 'P'));

		    $post['digests'] = intval(core::gpc('digests', 'P'));
			$post['credits'] = intval(core::gpc('credits', 'P'));
			$post['golds'] = intval(core::gpc('golds', 'P'));
			$post['money'] = intval(core::gpc('money', 'P'));
			$post['password'] = core::gpc('password', 'P');
			
			// check 数据格式
			$error['email'] = $this->member->check_email($post['email']);
			if(!empty($post['password'])) {
				$error['password'] = $this->member->check_password($post['password']);
				$post['password'] = $this->member->md5_md5($post['password'], $user['securekey']);
			} else {
				$post['password'] = $user['password'];
			}
			if(!array_filter($error)) {
				$error = array();
				$user = array_merge($user, $post);
				$this->member->update($user);
			}
		}
		
		//$input['username'] = form::get_text('username', $user['username'], 300);
		//$input['email'] = form::get_text('email', $user['email'], 300);
		$grouplist = $this->group->get_list();
		$grouparr = misc::arrlist_key_values($grouplist, 'groupid', 'name');
		$input['groupid'] = form::get_select('groupid', $grouparr, $user['groupid']);
		
		$input['topics'] = form::get_text('topics', $user['topics'], 100);
		$input['posts'] = form::get_text('posts', $user['posts'], 100);

		$input['digests'] = form::get_text('digests', $user['digests'], 100);
		$input['credits'] = form::get_text('credits', $user['credits'], 100);
		$input['golds'] = form::get_text('golds', $user['golds'], 100);
		$input['money'] = form::get_text('money', $user['money'], 100);
		
		$this->view->assign('input', $input);
		$this->view->assign('user', $user);
		$this->view->assign('error', $error);
		
		// hook admin_user_update_view_before.php
		
		$this->view->display('member_update.html');
	}
	
	// 读取
	public function on_read() {
		$this->_title[] = '查看用户资料';
		$this->_nav[] = '查看用户资料';
		
		$uid = intval(core::gpc('uid'));
		empty($uid) && $uid = $this->_user['uid'];
		$user = $this->user->get($uid);
		$this->check_user_exists($user);
		$this->user->format($user);
		$this->view->assign('user', $user);
		
		// hook admin_user_read_view_before.php
		
		$this->view->display('user_read.htm');
	}
	
	//* 转移到前台。
	public function on_delete() {
		$this->_title[] = '删除用户';
		$this->_nav[] = '删除用户';
		
		$uid = intval(core::gpc('uid'));
		$user = $this->member->read($uid);
		$this->check_user_exists($user);
		
		if($uid == 1) {
			$this->message('NO.1 管理员不能删除！');
		} elseif($uid == $this->conf['system_uid']) {
			$this->message('系统账户不能删除！');
		} else {
			$this->member->xdelete($uid);
			
			// hook admin_user_delete_after.php
			
			$this->message('删除用户成功！', TRUE, $_SERVER['HTTP_REFERER']);
		}
	}
	
	/*/ 禁言用户，加时间戳
	public function on_access() {
		$this->_title[] = '禁止用户';
		$this->_nav[] = '禁止用户';
		
		$uid = intval(core::gpc('uid'));
		$user = $this->user->read($uid);
		$this->check_user_exists($user);
		$access = $this->user_access->read($uid);
		if(empty($access)) {
			$access = array(
				'uid'=>$uid,
				'allowread'=>1,
				'allowthread'=>1,
				'allowpost'=>1,
				'allowreply'=>1,
				'allowattach'=>1,
				'expiry'=>$_SERVER['time'] + 86400 * 365
			);
		}
		
		$input = $error = array();
		if($this->form_submit()) {
			$post = array('uid'=>$uid);
			$post['allowpost'] = intval(!core::gpc('allowpost', 'P'));
			$post['allowreply'] = intval(!core::gpc('allowreply', 'P'));
			$post['allowthread'] = intval(!core::gpc('allowthread', 'P'));
			$post['allowattach'] = intval(!core::gpc('allowattach', 'P'));
			$post['allowdown'] = intval(!core::gpc('allowdown', 'P'));
			$post['allowread'] = intval(!core::gpc('allowread', 'P'));
			$post['expiry'] = strtotime(core::gpc('expiry', 'P'));
			
			if(misc::values_empty($error)) {
				$error = array();
				$access = array_merge($access, $post);
				$this->user_access->update($uid, $access);
			}
		}
		
		//print_r($access);exit;
		$input['allowpost'] = form::get_checkbox_yes_no('allowpost', empty($access['allowpost']));
		$input['allowreply'] = form::get_checkbox_yes_no('allowreply', empty($access['allowreply']));
		$input['allowthread'] = form::get_checkbox_yes_no('allowthread', empty($access['allowthread']));
		$input['allowattach'] = form::get_checkbox_yes_no('allowattach', empty($access['allowattach']));
		$input['allowdown'] = form::get_checkbox_yes_no('allowdown', empty($access['allowdown']));
		$input['allowread'] = form::get_checkbox_yes_no('allowread', empty($access['allowread']));
		$input['expiry'] = form::get_text('expiry', misc::date($access['expiry'], 'Y-n-j'), 150);
		
		$this->view->assign('input', $input);
		$this->view->assign('user', $user);
		$this->view->assign('error', $error);
		
		// hook admin_user_access_view_before.php
		
		$this->view->display('user_access.htm');
	}
	*/
	
	//hook admin_user_control_after.php
	
}

?>