<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class rank_control extends common_control {
	
    function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked = array('bbs'=>' class="checked"');
	}
	public function on_index(){
		$this->_checked['rank']=" class='current'";
		$this->_title[] = '排行榜';
		$this->_seo_keywords = '热门帖子,热点事件,'.$this->conf['seo_keywords'];
		$this->_seo_description = $this->conf['seo_description'].'查看最新帖子';
		/*$list=$this->topic->index_fetch(array(),array(),30001,10000);
		foreach($list as $v){
			$arr= array('fid'=>$v['fid'],'tid'=>$v['tid'],'views'=>$v['views'],'yesterdayviews'=>$v['views']-rand(10,$v['views']),'dayviews'=>rand(100,$v['views']),'weekviews'=>rand(1000,$v['views']),'monthviews'=>$v['views']-rand(10000,$v['views']),'updatetime'=>$_SERVER['time']);
			$this->topic_views->create($arr);
		}*/
		$cond=array();
		//hook rank_index_get_list_before.php
		//今日热门帖子
		$rank_today=$this->kv->get('rank_today');
		if(!$rank_today){
		    $rank_today=$this->topic_views->get_list(array(),array('dayviews'=>-1),0,10);
			$this->kv->set('rank_today',$rank_today,3600);
		}
		//本周热门帖子
		$rank_week=$this->kv->get('rank_week');
		if(!$rank_week){
		    $rank_week=$this->topic_views->get_list(array(),array('weekviews'=>-1),0,10);
			$this->kv->set('rank_week',$rank_week,86400);
		}
		//总热门帖子
		$rank_all=$this->kv->get('rank_all');
		if(!$rank_all){
		    $rank_all=$this->topic_views->get_list(array(),array('views'=>-1),0,10);
			$this->kv->set('rank_all',$rank_all,3600);
		}
		//总热门回复
		$rank_reply=$this->kv->get('rank_reply');
		if(!$rank_reply){
		    $rank_reply=$this->topic->get_hotlist($cond,10);
			$this->kv->set('rank_reply',$rank_reply,3600);
		}
		//热门贴吧
		$rank_forum=$this->kv->get('rank_forum');
		if(!$rank_forum){
			$rank_forum=$this->forum->get_list(array(),array('posts'=>-1),0,7);
			foreach($rank_forum as &$forum){
			  $this->forum->format($forum);	
			}
			$this->kv->set('rank_forum',$rank_forum,3600);
		}
		//热门标签
		$rank_tags=$this->kv->get('rank_tags');
		if(!$rank_tags){
		    $rank_tags=$this->tags->get_hots($num=30);
			$this->kv->set('rank_tags',$rank_tags,3600);
		}
		//最新注册用户
		$rank_lastuser=$this->kv->get('rank_lastuser');
		if(!$rank_lastuser){
			$rank_lastuser=$this->member->index_fetch(array(), array('regdate'=>-1), 0, 10);
			foreach($rank_lastuser as &$v1){
				$this->member->format($v1);
			}
			$this->kv->set('rank_lastuser',$rank_lastuser,600);
		}
		//粉丝排行
		$rank_followuser=$this->kv->get('rank_followuser');
		if(!$rank_followuser){
			$rank_followuser=$this->member->index_fetch(array(), array('followeds'=>-1), 0, 10);
			foreach($rank_followuser as &$v2){
				$this->member->format($v2);
			}
			$this->kv->set('rank_followuser',$rank_followuser,86400);
		}
		//发帖排行
		$rank_postuser=$this->kv->get('rank_postuser');
		if(!$rank_postuser){
			$rank_postuser=$this->member->index_fetch(array(), array('posts'=>-1), 0, 10);
			foreach($rank_postuser as &$v){
				$this->member->format($v);
			}
			$this->kv->set('rank_postuser',$rank_postuser,600);
		}
		
		$this->view->assign('rank_today',$rank_today);
		$this->view->assign('rank_week',$rank_week);
		$this->view->assign('rank_all',$rank_all);
		$this->view->assign('rank_reply',$rank_reply); 
		$this->view->assign('rank_forum',$rank_forum);
		$this->view->assign('rank_tags',$rank_tags);
		$this->view->assign('rank_lastuser',$rank_lastuser);
		$this->view->assign('rank_followuser',$rank_followuser);
		$this->view->assign('rank_postuser',$rank_postuser);
		
		$this->view->display('rank_index.html');
	}
	
}



?>