<?php

/*
 * Copyright (C) xgcms.com
 */

class forum extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'forum';
		$this->primarykey = array('fid');
		$this->maxcol = 'fid';
	}
    
	// 取版块列表，二级
	public function get_list($cond=array(),$order=array('rank'=>1),$start=0,$limit=1000) {
		$forumlist = $this->index_fetch($cond, $order, $start, $limit);
		misc::arrlist_change_key($forumlist, 'fid');
		return $forumlist;
	}
	
	
	// 更新版块的最后发帖
	public function update_last($fid) {
		$forum = $this->read($fid);
		$threadlist = $this->topic->index_fetch(array('fid'=>$fid), array('tid'=>-1), 0, 1);
		if(empty($threadlist)) {
			$forum['lasttid'] = 0;
			$forum['lastsubject'] = '';
			$forum['lastuid'] = 0;
			$forum['lastusername'] = '';
			$forum['lastpost'] = 0;
		} else {
			$thread = array_pop($threadlist);
			$forum['lasttid'] = $thread['tid'];
			$forum['lastsubject'] = $thread['subject'];
			$forum['lastuid'] = $thread['uid'];
			$forum['lastusername'] = $thread['username'];
			$forum['lastpost'] = $thread['lastpost'] ? $thread['lastpost'] : $thread['dateline'];
		}
		$this->update($fid, $forum);
	}
	


	public function _delete($fid) {
		$return = $this->delete($fid);
		if($return) {
			$this->count('-1');
		}
		return $return;
	}
	
	// 取贴吧列表 666095
	public function get_forum_list($where=array(),$start='0',$size='1000') {
		$forumlist = $this->index_fetch($where, array('posts'=>-1), $start, $size);
		foreach($forumlist as &$forum){
		    $this->format($forum);
		}
		return $forumlist;
	}
	
	// 最简单的格式 fid=>name
	public function get_all_forum() {
		return $this->index_fetch(array(), array(), 0, 1000);
	}
	
	// 取子版块
	public function get_forumlist_by_fup($fup) {
		return $this->index_fetch(array('fup'=>intval($fup)), array('rank'=>1), 0, 1000);
	}
	
	// 生成 <option>，超版和管理员能看到所有版块？
	public function get_forum_options($checkedfid = 0, $groupid = 0) {
		$s = '';
		$catelist = $this->category->get_category_list();
		foreach($catelist as &$cate) {
			$checked = $checkedfid == $cate['id'] ? ' selected="selected"' : '';
			$s .= '<option value="'.$cate['id'].'"'.$checked.' style="font-weight: 800;">'.$cate['name'].'</option>';
			foreach($cate['catelist_son'] as &$cate_s) {
				$checked = $checkedfid == $cate_s['id'] ? ' selected="selected"' : '';
				$s .= '<option value="'.$cate_s['id'].'"'.$checked.'>    &nbsp;   &nbsp; |-'.$cate_s['name'].'</option>';
			}
		}
		return $s;
	}
	
	public function check_fup($fid, $fup) {
		$forum = $this->read($fup);
		if($forum['fup'] != 0) {
			return "$forum[name] 是板块，不是分类。";
		}
		return '';
	}
	
	public function check_name(&$name) {
		if(empty($name)) {
			return '贴吧名称不能为空。';
		}
		return '';
	}
	
	public function check_rank(&$rank) {
		if(empty($rank)) {
			return '显示倒序不能为空。';
		}
		return '';
	}
	
	public function check_brief(&$brief) {
		if(empty($brief)) {
			return '版块简介不能为空。';
		}
		return '';
	}
	
	public function check_rule(&$rule) {
		if(empty($rule)) {
			return '版规不能为空。';
		}
		return '';
	}
	
	public function check_icon(&$icon) {
		if(empty($icon)) {
			return '版块图标不能为空。';
		}
		return '';
	}
	
	public function format(&$forum,$page=1) {
        $url_forum=substr($this->conf['url_forum'],0,stripos($this->conf['url_forum'],'|'));
		$url_forum=$this->conf['app_url'].$url_forum;
		
		$forum['url']=$this->conf['urlrewrite']?str_replace(array('[fid]','[name]'),array($forum['fid'],$forum['name']),$url_forum):'?forum-index-fid-'.$forum['fid'].'.htm';
		$forum['forumicon_small'] = $forum['icon'] ? $this->conf['upload_url']."forum/$forum[fid]_small.gif" :$this->conf['upload_url']."forum/default.png";
		$forum['forumicon_middle'] = $forum['icon'] ? $this->conf['upload_url']."forum/$forum[fid]_middle.gif" : $this->conf['upload_url']."forum/default.png";
		$forum['forumicon_big'] = $forum['icon'] ? $this->conf['upload_url']."forum/$forum[fid]_big.gif" : $this->conf['upload_url']."forum/default.png";
		//$forum['lastpost_fmt'] = misc::humandate($forum['lastpost']);
		
		// 版主
		$forum['modlist'] = array();
		if(!empty($forum['modids'])) {
			$modidarr = explode(' ', $forum['modids']);
			$modnamearr = explode(' ', $forum['modnames']);
			foreach($modidarr as $k=>$modid) {
				$forum['modlist'][$modid] = $modnamearr[$k];
			}
		}
		
		// 分类名称
		$forum['catename'] = $this->category->get_list_by_cid($forum['cat_id']);
	}
	
	public function get_name_by_fid($fid) {
		$f = $this->index_fetch(array('fid'=>$fid), array(), 0, 1);
		foreach($f as $v){
			return $v['fname'];
		}
		return '未知';
	}
	// 获取有权限管理的版块列表，默认第一个，如果有权限限制，则查询用户组权限，仅供斑竹列表使用
	public function get_options($uid, $groupid, $checkedfid, &$defaultfid) {
		$forumlist = $this->forum->get_list();
		$s = '';
		$checkedfid && $defaultfid = $checkedfid;
		foreach($forumlist as $forum) {
			if($groupid == 1 || $groupid == 2 || ($groupid == 4 && strpos(' '.$forum['modids'].' ', ' '.$uid.' ') !== FALSE)) {
				
				// 隐藏权限不足的版块。
				$fid = $forum['fid'];
				if(!isset($this->conf['forumarr'][$fid])) {
					continue;
				}
				
				empty($checkedfid) && empty($defaultfid) && $defaultfid = $fid;
				
				$checked = $checkedfid == $forum['fid'] ? ' selected="selected"' : '';
				$s .= '<option value="'.$forum['fid'].'"'.$checked.' style="font-weight: 800;">'.$forum['name'].'</option>';
			}
		}
		return $s;
	}
	
	// 获取版块列表
	public function get_public_options($checkfid = 0, $user = array()) {
		$s = '';
		$forumarr = $this->conf['forumarr'];
		foreach($forumarr as $fid=>$name) {
			if(!empty($forumarr[$fid])) {
				$access = $this->forum_access->read($fid, $user['groupid']);
				if(!empty($access) && !$access['allowread']) {
					unset($forumarr[$fid]);
					continue;
				}
			}
			$checked = $checkfid == $fid ? ' selected="selected"' : '';
			$s .= '<option value="'.$fid.'"'.$checked.'>'.$name.'</option>';
		}
		return $s;
	}
	
	public function xupdate($forum) {
		$fid = $forum['fid'];
/*		$forum = $this->read($fid);
		
		$cache = $this->mcache->read('forum', $fid);
		foreach($new as $k=>$v) {
			isset($forum[$k]) && !is_array($new[$k]) && $forum[$k] = $v;
			if($k == 'typecates' && !is_array($v)) continue; // todo: 此行代码为了兼容，正式版可以去掉了。
			isset($cache[$k]) && $cache[$k] = $v;
		}
		$this->update($forum);
		$this->mcache->real_set('forum', $fid, $cache);*/
		$this->update($forum);
		$this->mcache->clear('forum', $fid);
			$this->mcache->clear('forum_fn', $forum['name']);
			$this->mcache->clear('cateforum', $forum['cat_tid']);
	}
	
	// hook forum_model_end.php
}
?>