<?php

/*
 * Copyright (C) xgcms.com
 */

// 采用文件缓存，不利于分布式部署。
class mcache extends base_model {
	
	private $vars;// 缓存已经加载的数据
	
	function __construct(&$conf) {
		parent::__construct($conf);
		
		// hook mcache_construct_end.php
	}

	/*
		$arg3, $arg4, 用来兼容 base_model.update() 方法参数个数。没有用处。
	*/
	public function read($cachename, $arg = NULL, $arg3 = FALSE, $arg4 = FALSE) {
		$key = $cachename.'_'.$arg;
		if(isset($this->vars[$key])) {
			return $this->vars[$key];// 避免重复加载，此处提升效率明显！
		}
		
		$data = $this->real_get($cachename, $arg);
		if(empty($data)) {
			$data = $this->_update($cachename, $arg);
		}
		$this->vars[$key] = $data;
		return $data;
	}
	
	public function clear($cachename, $arg = NULL) {
		return $this->real_delete($cachename, $arg);
	}
	
	// 格式化以后的数据存入 cache
	private function get_forum($fid) {
		$forum = $this->forum->read($fid);
		$forum && $this->forum->format($forum);
		//$forum && $this->forum->format_thread_type($forum);
		
		// hook mcache_model_forum_end.php
		return $forum;
	}
	// 格式化以后的数据存入 cache
	private function get_forum_fn($fn) {
		$forum = $this->forum->index_fetch(array('name'=>$fn),array(),0,1);
		$forum=array_pop($forum);
		$forum && $this->forum->format($forum);
		//$forum && $this->forum->format_thread_type($forum);
		
		// hook mcache_model_forum_end.php
		return $forum;
	}
	public function real_get($cachename, $arg) {
		$k = "cache_{$cachename}_$arg";
		return $this->kv->get($k);
	}
	
	public function real_delete($cachename, $arg) {
		$k = "cache_{$cachename}_$arg";
		$this->kv->delete($k);
		return TRUE;
	}
	
	public function real_set($cachename, $arg, $data) {
		$k = "cache_{$cachename}_$arg";
		$this->kv->set($k, $data);
		return TRUE;
	}
	
	private function _update($cachename, $arg) {
		$method = "get_$cachename";
		if(method_exists($this, $method)) {
			$data = $this->$method($arg);
			if(empty($data)) {
				return array();// 强行返回，不保存到文件
			}
		} else {
			throw new Exception('cache_model: '.$method.' does not exists');
		}
		$this->real_set($cachename, $arg, $data);
		return $data;
	}
	
	// hook mcache_model_end.php
	
	

	private function save($var, $cachefile) {
		$s = "<?php\r\n";
		$s .= 'return '.var_export($var, TRUE).";";
		$s .= "\r\n?>";
		if(!($fp = fopen($cachefile, 'wb'))) {
			throw new Exception('cache_model: cache unwritable');
		}
		if(function_exists('flock') && !flock($fp, LOCK_EX)) {
			fclose($fp);
			return FALSE;
		}
		fwrite($fp, $s, strlen($s));
		fclose($fp);
		return TRUE;
	}

	private function get_forumarr() {
		$arr = array();
		$forumlist = $this->forum->get_forum_list();

		foreach($forumlist as &$forum) {
			/*if(!$forum['status']) {
				continue;
			}*/
			$arr[$forum['fid']]['name'] = $forum['name'];
			$arr2 = array();
			foreach($forum['forumlist'] as &$forum2) {
				/*
				if(!$forum['status']) {
					continue;
				}
				*/
				$arr2[$forum2['fid']] = $forum2['name'];
				
			}
			$arr[$forum['fid']]['forumlist'] = $arr2;
		}
		return $arr;
	}
	
	// 只能获取非隐藏版块
	private function get_forumlist() {
		$forumlist = $this->forum->get_forum_list();
		foreach($forumlist as $forumkey=>&$forum) {
			if(!$forum['status']) {
				unset($forumlist[$forumkey]);
				continue;
			}
			
			$this->forum->format($forum);
		}
		return $forumlist;
	}
	//获取分类下的贴吧
	private function get_cateforum($cid) {

		$where=array();
		if(0<intval($cid)){
			$where=array('cat_tid'=>$cid);
		}
		$forumlist = $this->forum->get_forum_list($where,0,7);
		foreach($forumlist as $forumkey=>&$forum) {
			
			if(!$forum['status']) {
				unset($forumlist[$forumkey]);
				continue;
			}
			$this->forum->format($forum);
		}
		return $forumlist;
	}
	//获取二级分类下的贴吧
	private function get_soncateforum($cid) {
		$where=array();
		if(0<intval($cid)){
			$where=array('cat_id'=>$cid);
		}
		$forumlist = $this->forum->get_forum_list($where);
		foreach($forumlist as $forumkey=>&$forum) {
			if(!$forum['status']) {
				unset($forumlist[$forumkey]);
				continue;
			}
			$this->forum->format($forum);
		}
		return $forumlist;
	}
	//获取分类
	private function get_catelist(){
		$catelist = $this->category->get_category_list();
		return $catelist;
	}
	private function get_group($groupid) {
		$group = $this->group->read($groupid);
		$group && $this->group->format($group);
		return $group;
	}
	
	private function get_grouplist() {
		return $this->group->get_list();
	}
	
	// 获取常见的几种 id name 格式
	private function get_miscarr() {
		// forum fid=>name
		$arr = array();
/*		$forumlist = $this->forum->get_all_forum();
		foreach($forumlist as $forum) {
			$arr['forum'][$forum['fid']] = $forum['name'];
		}*/
		
		//category cid=>catename
		$catelist = $this->category->get_category_all_list();
		foreach($catelist as $cate) {
			$arr['category'][$cate['id']] = $cate['name'];
		}
		
		// group groupid=>name
		$grouplist = $this->group->get_list();
		foreach($grouplist as $group) {
			$arr['group'][$group['groupid']] = !empty($group['color']) ? "<span style=\"color: $group[color]\">$group[name]</span>" : $group['name'];
		}
		
		return $arr;
	}
	
	private function get_friendlink() {
		$friendlinklist = array();
		$friendlinklist[0] = $this->friendlink->index_fetch(array('type'=>0), array('rank'=>-1), 0, 1000);
		foreach($friendlinklist[0] as &$friendlink) {
			$this->friendlink->format($friendlink);
		}
		
		$friendlinklist[1] = $this->friendlink->index_fetch(array('type'=>1), array('rank'=>-1), 0, 1000);
		foreach($friendlinklist[1] as &$friendlink) {
			$this->friendlink->format($friendlink);
		}
		return $friendlinklist;
	}
	
}
?>