<?php

/*
 * Copyright (C) xgcms.com
 */

class reply extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'reply';
		$this->primarykey = array('fid', 'replyid');
		$this->maxcol = 'replyid';
		
	}


	public function get_list_by_page($fid, $pid, $page) {
		$start = ($page - 1) * $this->conf['pagesize'];
		$limit = $this->conf['pagesize'];
		$arrlist = $this->index_fetch(array('fid'=>$fid, 'pid'=>$pid), array(), $start, $limit);
		foreach($arrlist as &$arr) {
			$this->format($arr);
		}
		return $arrlist;
	}
	
	// 板块最新的回复，根据replyid 倒排
	public function get_list_by_fid($fid, $page, $pagesize) {
		$start = ($page - 1) * $pagesize;
		$limit = $pagesize;
		$arrlist = $this->index_fetch(array('fid'=>$fid), array('replyid'=>-1), $start, $limit);
		foreach($arrlist as &$arr) {
			$this->format($arr);
		}
		return $arrlist;
	}
	
	public function check_subject(&$subject) {
		if(empty($subject)) {
			return '回复内容不能为空。';
		}
		if(utf8::strlen($subject) > 128) {
			return '回复内容不能超过 128 个字符。';
		}
		return '';
	}
	
	// 用来显示给用户
	public function format(&$reply) {
		isset($reply['dateline']) && $reply['dateline_fmt'] = misc::minidate($reply['dateline'], $this->conf['timeoffset']);
	}
	
	public function _delete($fid, $replyid) {
		$return = $this->delete($fid, $replyid);
		if($return) {
			$this->count('-1');
		}
		return $return;
	}
	
	// 删除回帖，非主题帖。相对比较简单，是相对！万恶的删除和缓存啊！不过现在终于可以把它封起来了，稳定了。
	public function xdelete($fid, $replyid) {
		// post, thread, forum ,user -1
		$reply = $this->read($fid, $replyid);
		$post = $this->post->read($fid, $reply['pid']);
		if(empty($post)) return;
		$post['replies']--;
		$this->post->update($fid, $reply['pid'], $post);
		
		$thread = $this->topic->read($fid, $reply['tid']);
		if(empty($thread)) return;
		$thread['replies']--;
		$this->topic->update($fid, $reply['tid'], $thread);
		
		$forum = $this->forum->read($fid);
		if(empty($forum)) return;
		$forum['replies']--;
		$this->forum->update($fid, $forum);
		$this->mcache->clear('forum', $fid);
		
		// 更新用户
		$user = $this->member->read($reply['uid']);
		if(empty($user)) return;
		$user['replies']--;
		$user['credits'] -= $this->conf['credits_policy_reply'];
		$user['golds'] -= $this->conf['golds_policy_reply'];
		$groupid = $user['groupid'];
		$user['groupid'] = $this->group->get_groupid_by_credits($user['groupid'], $user['credits']);
		if($groupid != $user['groupid']) {
			$this->member->set_login_cookie($user);
		}
		$this->member->update($reply['uid'], $user);
		
		$this->_delete($fid, $replyid);
	}
	
	// 删除一个帖子下所有的楼层，最多1000。
	public function delete_by_fid_pid($fid, $pid) {
		$r = array();
		$replies = 0;
		$arrlist = $this->index_fetch(array('fid'=>$fid, 'pid'=>$pid), array(), 0, 1000);
		foreach($arrlist as $arr) {
			!isset($r[$arr['uid']]) && $r[$arr['uid']] = array('credits'=>0, 'golds'=>0, 'replies'=>0);
			$r[$arr['uid']]['credits'] += $this->conf['credits_policy_reply'];
			$r[$arr['uid']]['golds'] += $this->conf['golds_policy_reply'];
			$r[$arr['uid']]['replies'] += 1;
			$this->_delete($arr['fid'], $arr['replyid']);
			$replies++;
		}
		return array($r, $replies);
	}
	
	// 暂时不考虑高楼
	public function update_fid_by_fid_pid($fid, $pid, $newfid) {
		$arrlist = $this->index_fetch(array('fid'=>$fid, 'pid'=>$pid), array(), 0, 1000);
		foreach($arrlist as $arr) {
			$arr['fid'] = $newfid;
			$this->_delete($arr['fid'], $arr['replyid']);
			$this->update($arr['fid'], $arr['replyid'], $arr);
		}
		return count($arrlist);
	}
	
}
?>