function XzTab(option){
	var opt = option;
	this.content = typeof(opt.content) == "string" ? jQ("#"+opt.content) : opt.content;
	this.nav = typeof(opt.nav) == "string" ? jQ("#"+opt.nav) : opt.nav;
	this.tabItem = opt.tabItem ? jQ("."+opt.tabItem) : this.content.children("li");
	this.navItem = opt.navItem ? jQ("."+opt.navItem) : this.nav.children("li");
	this.len = this.tabItem.length;
	this.curNav = opt.curNav || "current";
	this.autoChange = opt.autoChange || 0; //ǷԶлĬΪ
	this.changeTime = opt.changeTime || 3000;  //Զлʱ䣬ĬΪ3000
	this.initPos = opt.initPos || 0; //ʼλΪ0
	this.type = opt.type || "click"; //л,,hover  click	
	this.lazyLoad = opt.lazyLoad || 0; //ǷӳټأĬΪ
	this.srcAttr = opt.srcAttr || "load_src"; //ӳټҪ޸ĵ
	this.placeHolder = opt.placeHolder; //ռλͼƬ
	this.prevIndex = this.curIndex = this.initPos = opt.initPos || 0;
	this.timing = null;
	this.init();
}

XzTab.prototype = {
	init : function(){
		this.switchover(this.initPos);
		this.control();
		this.setPlaceHolder();
		this.autoChangeFun();
	},
	switchover : function(index){
		this.lazyLoadFun(index);
		this.navItem.eq(this.prevIndex).removeClass(this.curNav);
		this.navItem.eq(index).addClass(this.curNav);
		this.tabItem.eq(this.prevIndex).hide();
		this.tabItem.eq(index).show();
	},
	control : function(){
		var that = this;
		this.navItem[this.type](function(){
			that.prevIndex = that.curIndex;
			that.curIndex = that.navItem.index(jQ(this));
			if(that.prevIndex == that.curIndex){ return false; }
			that.switchover(that.curIndex);
			return false;
		});
	},
	autoChangeFun : function(){
		if(!this.autoChange){return;}
		var that = this;
		var autoFun = function(){
			that.prevIndex = that.curIndex;
			that.curIndex = (that.curIndex < that.len - 1) ? that.curIndex + 1 : 0;
			that.switchover(that.curIndex);
		}	
		this.timing = setInterval(autoFun, this.changeTime);
		this.stopAutoChange(autoFun);
	},
	stopAutoChange : function(fn){
		var that = this,
			arr = [this.content, this.navItem];
			
		for(var i=0,len=arr.length; i<len; i++){
			arr[i].hover(
				function(){
					clearInterval(that.timing);
				},
				function(){
					that.timing = setInterval(fn, that.changeTime);
				}
			);
		}
	},
	lazyLoadFun : function(index){
		if(!this.lazyLoad){return;}
		var i = 0,	
			imgs = this.tabItem.eq(index).find("img"),
			len = imgs.length,
			target, imgSrc;
		for(; i<len; i++){
			target = imgs.eq(i);
			imgSrc = target.attr(this.srcAttr);
			if(imgSrc){
				target.attr("src", imgSrc);
				target.removeAttr(this.srcAttr);
			}
		}
	},
	setPlaceHolder : function(){
		if(!this.lazyLoad || !this.placeHolder){return;}
		
		var i = 0,	
			imgs = this.tabItem.eq(index).find("img");
			len = imgs.length,
			target, imgSrc;
		for(; i<len; i++){
			target = imgs.eq(i);
			imgSrc = target.attr(this.srcAttr);
			if(imgSrc){
				var p = /^\s*#.+\s*$/.test(this.placeHolder) ? this.placeHolder : 'url(' + this.placeHolder + ') center center no-repeat';
				target.css({background: p});
			}
		}
	}
}

function darenShow(container){		
	var container = jQ("#"+container),
		li = container.find("li"),
		totalW = container.width(),
		liW = li.eq(0).outerWidth(),
		liLen = li.length,
		lastIndex = 0,
		posArr = [132, 58],
		tmpL,
		sLiW = Math.round((totalW-liW)/(liLen-1));
	if(liLen != 2){return;}
	li.eq(1).css({left:posArr[0]});
	li.eq(lastIndex).find("p").css({bottom:0});
	li.eq(lastIndex).addClass("current");
	li.live("mouseover", function(){
		var index = li.index(jQ(this));
		if(lastIndex == index){return;}
		li.eq(index).addClass("current");
		li.eq(index).find("p").stop().animate({bottom:0}, 600);
		li.eq(lastIndex).removeClass("current");
		li.eq(lastIndex).find("p").stop().animate({bottom:"-24px"}, 600);
		lastIndex = index;
		li.eq(1).stop().animate({left:posArr[index]+"px", "z-index":10}, 600);
	});
}
//Ӧ
function xzBlockClick(option){
	var opt = option || {},
		elem = typeof(opt.elem) === "string" ? jQ("."+opt.elem) : opt.elem,
		hoverClass = opt.hoverClass || "hover";
	if(!elem){return;}
	elem.live("mouseover", function(){
			if(jQ(this).hasClass("no_block")){return;}
			//jQ(this).css({cursor:"pointer"});
			if(!jQ(this).find(".create_link").length){
				jQ(this).append('<a href="' + jQ(this).find("a").eq(0).attr("href") + '" target="_blank" class="create_link"></a>');
			}
			hoverClass && jQ(this).addClass(hoverClass);
		})
		.live("mouseout", function(){
			if(jQ(this).hasClass("no_block")){return;}
			hoverClass && jQ(this).removeClass(hoverClass);
		});
}

var xzTab1 = new XzTab({nav:jQ(".focus_nav"), content:jQ(".focus_content"), type:"mouseover", autoChange:1, changeTime:5000});
xzBlockClick({elem:"img_desc"});
darenShow("daren_show");