function darenShow(opt){
var container = opt.id,
li = container.find("li"),
totalW = container.width(),
liW = li.eq(0).outerWidth(),
liLen = li.length,
lastIndex = 0,
posArr = [150, 68],
tmpL,
sLiW = Math.round((totalW-liW)/(liLen-1));
if(liLen != 2){return;}
li.eq(1).css({left:posArr[0]});
li.eq(lastIndex).find("p").css({bottom:0});
li.eq(lastIndex).addClass("current");
li.live("mouseover", function(){
var index = li.index(jQ(this));
if(lastIndex == index){return;}
li.eq(index).addClass("current");
li.eq(index).find("p").stop().animate({bottom:0}, 600);
li.eq(lastIndex).removeClass("current");
li.eq(lastIndex).find("p").stop().animate({bottom:"-24px"}, 600);
lastIndex = index;

li.eq(1).stop().animate({left:posArr[index]+"px", "z-index":10}, 600);
});
}

var overlay = {
	overlay : jQ("#my_overlay"),
	max : function(dir){
		var d = document.documentElement;
		switch(dir){
			case "h" :
			return Math.max(d.scrollHeight, d.clientHeight);
			break;
			
			case "w" :
			return Math.max(d.scrollWidth, d.clientWidth);
			break;
		}
	},
	create : function(opacity){
		var that = this;
		if(!this.overlay.length){
			jQ('<div id="my_overlay"></div>').appendTo("body");
			this.overlay = jQ("#my_overlay");
			this.overlay.css({background:"#333", display:"block", opacity:opacity?opacity:0.2, position:"absolute", left:0, top:0, "z-index":999});
		}	
		this.overlay.css({height:that.max("h"), width:that.max("w")});
		this.overlay.show();
		jQ(window).scroll(function(){ that.overlay.css({height:that.max("h"), width:that.max("w")});});
		jQ(window).resize(function(){ that.overlay.css({height:that.max("h"), width:that.max("w")});});
	},
	close : function(){
		if(this.overlay.length){
			this.overlay.hide();
		}
	}
}

function PopBox(opt){
	this.boxId = opt.boxId;
	this.titleVal = opt.titleVal || "ʾ";
	//this.showOverlay = opt.showOverlay || false;
	this.title = null;
	this.closeFunc = opt.closeFunc;
	this.content = null;
	this.box = null;
	
	this.init();
}
PopBox.prototype = {
	init : function(){
		this.create();
	},
	create : function(){
		if(!this.box){
			var that = this,
				tmp = '<div class="pop_box" id="'+this.boxId+'" style="display:none;"><h4 class="title">'+this.titleVal+'</h4><span class="close"></span><div class="pop_box_con"></div></div>';
			jQ("body").append(tmp);
			this.box = jQ("#"+this.boxId);
			this.title = this.box.find(".title");
			this.content = this.box.find(".pop_box_con");
			this.box.find(".close").click(function(){
				that.close(); 
			});
		}
	},
	open : function(btn){
		var that = this;
		overlay.create();
		this.getPos(btn);
		this.box.show();
	},
	close : function(){
		overlay.close();
		this.box.hide();
		this.closeFunc&&this.closeFunc();
	},
	setContent : function(content){
		this.content.html(content);
	},
	changeTitle : function(newTitle){
		this.title.html(newTitle);
	},
	getPos : function(btn){
		if(btn){
			var referW = btn.outerWidth(),
				referT = btn.offset().top,
				referL = btn.offset().left,
				boxH = this.box.outerHeight(),
				boxW = this.box.outerWidth();
			this.box.css({position:"absolute", top:referT-boxH-4+"px", left:referL-(boxW-referW)/2+"px"});
			return;
		}
		
		var isIe6 = jQ.browser.msie && (jQ.browser.version == "6.0") && !jQ.support.style,
			eHeight = this.box.outerHeight()/2,
			eWidth = this.box.outerWidth()/2;
		this.box.css({position:"fixed", top:"50%", left:"50%", "margin-left":-eWidth+"px"});
		
		if(!isIe6){
			this.box.css({"margin-top":-eHeight+"px"});
			return;
		}
		
		var wTop = document.documentElement.scrollTop + document.documentElement.clientHeight/2 - eHeight;	
		this.box.css({position:"absolute", top:wTop});
	}
}

function boxhover(option){
	var id = typeof(option.id)=="string" ? jQ("#"+option.id) : option.id,
		idHeight = id.outerHeight(true); 
	id.hover(function(){
		jQ(this).addClass("box_hover");
		if(jQ(this).hasClass("no_block")){return;}
		if(!jQ(this).find(".create_link").length){
			jQ(this).append('<a href="' + jQ(this).find("a").eq(0).attr("href") + '" target="_blank" class="create_link"></a>');
		}
		jQ(".create_link").css({height:idHeight});
	},function(){
		jQ(this).removeClass("box_hover");
	});
}

boxhover({id:jQ(".imgTextArea")});
darenShow({id:jQ("#daren_show")});
jQ("#funtion_home").hover(function(){jQ(this).find("li").addClass("hover");},function(){
jQ(this).find("li").removeClass("hover");});
jQ("#funtion_home li").mouseover(function(){jQ(this).removeClass("hover");});
jQ("#funtion_home li").mouseleave(function(){jQ(this).addClass("hover");})