(function($){
	var scroller = $('#hot_wordscroll');
	var temp = $('#hot_words');
	var taglist = [];
	var tagcursor = 0;
	var paused = false;
	function itemColor(str){
		var colors = ['color1', 'color2', 'color3','color4', 'color5', 'color6'];
		var colorlen = colors.length;
		var hash = 0;
		for(var n = 0; n<str.length; n++){
			hash+= str.charCodeAt(n)%colorlen;
		}
		return colors[hash%colorlen];
	}
	scroller.bind('initWithTags', function(e, tagname){
		taglist = tagname.split(',');
		if(taglist.length > 0){
			scroller.data('taglist', taglist);
		}
	});
	scroller.bind('start', function(e){
		var minWidth = 44;
		var fixLeft = this.offsetLeft;
		var fixTop = this.offsetTop;
		var offsetLeft = fixLeft;
		var offsetTop = fixTop;
		var rowWidth = this.offsetWidth;
		var rowHeight = this.offsetHeight;
		var self = $(this);
		function getNextTag(){
			if(taglist.length <= 0){
				return false;
			}
			if(tagcursor < 0 || tagcursor >= taglist.length){
				tagcursor = 0;
			}
			var rval = taglist[tagcursor];
			tagcursor++;
			return rval;
		}
		// 完成一次填充循环后调用
		function finishLoop(){
			if(paused){
				setTimeout(finishLoop, 2000);
				return;
			}
			if($.browser.msie){
				scroller.empty();
				loopCreateItem();
			}else{
				var children = scroller.children();
				children.each(function(index, obj){
					function hideItem(){
						$(obj).css({
							left:0,
							opacity:0
						});
						setTimeout(function(){
							$(obj).remove();
						}, 200);
					}
					setTimeout(hideItem, 100*index);
				});
				setTimeout(loopCreateItem, 200);
			}
		}
		function itemMouseOver(){
			if($.browser.msie){
				this._width = this.offsetWidth - 20;
				this.style.marginLeft = '-15px';
				this.style.marginTop = '-5px';
				this.style.lineHeight = '30px';
				this.style.height = '30px';
				this.style.fontSize = '15px';
				this.style.fontWeight = 'bold';
				this.style.width = this._width + 30 + 'px';
			}
		}
		function itemMouseOut(){
			if($.browser.msie){
				this.style.marginLeft = 0;
				this.style.marginTop = 0;
				this.style.lineHeight = '';
				this.style.height = '';
				this.style.fontSize = '';
				this.style.fontWeight = '';
				this.style.width = this._width + 'px';
			}
		}
		function loopCreateItem(){
			// 1. 创建tag标签并添加到起始位置
			var tag = getNextTag();
			var atag = $('<a target="_blank" href="search.php?mod=forum&srchtxt=' + encodeURIComponent(tag) + '&formhash=' + hotword_hash + '&searchsubmit=true&source=hotsearch" class="' + itemColor(tag) + '">' + tag + '</a>').css({
				'opacity':'0',
				'top':fixTop,
				'left':380
			}).bind('mouseover', itemMouseOver).bind('mouseout', itemMouseOut).appendTo(self);
			// 2. 动画到指定位置
			function animateItem(){
				var obj = atag.get(0);
				atag.css({
					left:offsetLeft,
					top:offsetTop,
					opacity:1
				});
				// 3. 计算下一个的位置
				offsetLeft += obj.offsetWidth + 3;
				if(offsetLeft - fixLeft + minWidth > rowWidth){
					var widthInBlank = rowWidth - offsetLeft + fixLeft + 3;
					$(obj).css({
						width:obj.offsetWidth-20+(widthInBlank)
					});
					if(widthInBlank < 0){
						atag.attr('title', obj.innerText);
					}
					offsetLeft = fixLeft;
					offsetTop += 25;
				}
				if(offsetTop - fixTop < rowHeight){
					// 4. 创建下一个tag
					loopCreateItem();
				}else{
					// 结束循环
					offsetLeft = fixLeft;
					offsetTop = fixTop;
					setTimeout(finishLoop, 5000);
				}
			}
			if($.browser.msie){
				animateItem();
			}else{
				setTimeout(animateItem,100);
			}
		}
		setTimeout(loopCreateItem, 100);
	});
	scroller.bind('mouseenter', function(){
		paused = true;
	});
	scroller.bind('mouseleave', function(){
		paused = false;
	});
	scroller.trigger('initWithTags', hotwords);
	scroller.trigger('start');

})(jQuery);