(function($){
	$.fn.slideshow	= function(param){
		var $this			= $(this);
		var $slides_ctn		= $this.find('.slides');
		var $slides			= $slides_ctn.find('ul');
		var $slides_nav		= $('<div class="slidenav"><ul></ul></div>');
		var $slides_title	= $('<div class="slidetip"><div class="bg"></div><div class="front"></div><p></p></div>');
		var $slides_map		= param && param['map'] ? $(param['map']) : false;
		if($slides_map.length <= 0){$slides_map = false;}
		var overlay			= param && param['overlay'] ? param['overlay'] : false;
		var direction		= param && param['direction'] ? param['direction'] : false;
		var trigger			= param && param['trigger'] ? param['trigger'] : 'click';
		if(overlay){
			var $overlay = $this.find(overlay);
			overlay = $overlay.length > 0 ? overlay : false;
		}

		param	= param||{};
		
		var interval = 0;
		var slide_index = -1;
		var isanimate = false;
		var new_id = -1;
		var mousein = false;
		
		// 切换时间
		var slides_maptrigger		= param && param['maptrigger'] ? param['maptrigger'] : 'click';
		var interval_time	= param && param['interval'] ? param['interval'] : 4000;
		// 幻灯宽
		var slide_width		= param && param['width'] ? param['width'] : 400;
		// 幻灯高
		var slide_height	= param && param['height'] ? param['height'] : 300;
		var animate_time	= param && param['animate'] ? param['animate'] : 500;
		var nobreak			= param && param['nobreak'] == true ? true : false;
		// 是否显示标题
		var show_title		= param && param['showtitle'] ? param['showtitle'] : false;
		var title_height		= param && param['titleheight'] ? param['titleheight'] : 28;
		
		var slides_count		= $slides.children("li").length;
		if($slides.length <= 0 || slides_count <= 0){
			return;
		}

		init();
		if(slides_count <= 1){return;}
		play(0);

		function init(){
			$this.css({
			});
			$slides_ctn.css({
				"overflow"	: 'hidden',
				"width"		: slide_width,
				"height"	: slide_height
			});
			$slides.css({
				"width"		: slide_width,
				"height"	: slide_height
			});
			$slides.find('li img').css({
				"display"		: 'block'
			});

			$this.append($slides_nav);
			if(show_title){
				$this.append($slides_title);
				$slides_title.css({
					"top"		: slide_height - title_height,
					"width"		: slide_width,
					"height"	: title_height,
					"z-index"	: 88
				}).find('.bg').css({
					"width"		: slide_width,
					"height"	: title_height
				});
			}
			var slidenavlist =[];
			for(var n=0; n < slides_count; n++){
				slidenavlist.push('<li slideindex="' + n + '"><a href="#" onclick="return false;"><span>' + (n+1) + '</span></a></li>');
			}
			$slides_nav.find('ul').append(slidenavlist.join(''));
			
			for(var i = 0;i < $("#slides_thumbs li").length;i++){
				$("#slides_thumbs li").eq(i).attr("slideindex",i).append("<span class='bspan'></span>");				
			}
	
			if(slides_count > 1){
				switch(direction){
				case 'top': 
					$slides.find('li').css({
						"float"		: 'left',
						"width"		: slide_width,
						"height"	: slide_height
					});
					break;
				case 'left':
					$slides.css({
						"width"		: slides_count*slide_width
					});
					$slides.find('li').css({
						"float"		: 'left',
						"width"		: slide_width,
						"height"	: slide_height
					});
					break;
				default: 
					direction = false;
					$slides.find('li').css({
						"position"	: 'absolute',
						"float"		: 'left',
						"width"		: slide_width,
						"height"	: slide_height,
						"opacity"	: 0,
						"display"	: 'none'
					});
					break;
				}
			}else{
				$slides.find('li').css({
					"width"		: slide_width,
					"height"	: slide_height
				});
				// 显示标题
				var n_title = $slides.find('li:first a').attr('title');
				var n_url = $slides.find('li:first a').attr('href');
				var n_target = $slides.find('li:first a').attr('target');
				var desc =newli.find('a').attr('name');
				var n_desc;
				if(desc!=undefined){
					n_desc =desc;		
				}else{
					n_desc="";
				}
				if(show_title && typeof n_title == 'string' && n_title !== ''){
					n_url = !n_url || n_url == '' ? '' : ' href="' + n_url + '"';
					n_target = !n_url || n_url == '' ? '' : ' target="' + n_url + '"';
					$slides_title.find('.front').html('<a' + n_url + n_target + '>' + n_title + '</a>' + '<p>' + n_desc + '</p>');
					$slides_title.show();
				}else{
					$slides_title.hide();
				}
				return;
			}
			
			if(trigger && trigger !== 'click'){
				$slides_nav.bind(trigger, function(e){
					var $li = $(e.target).closest('li');
					var idx = parseInt($li.attr('slideindex'));
					if(!isNaN(idx) && idx >= 0 && idx < slides_count){
						play(idx);
					}
				});
			}
			$slides_nav.click(function(e){
				var $li = $(e.target).closest('li');
				var idx = parseInt($li.attr('slideindex'));
				if(!isNaN(idx) && idx >= 0 && idx < slides_count){
					play(idx);
				}
			});
			
			 
			if(trigger && trigger !== 'click'){
				$("#slides_thumbs").bind(trigger, function(e){
					var $li = $(e.target).closest('li');
					var idx = parseInt($li.attr('slideindex'));
					if(!isNaN(idx) && idx >= 0 && idx < slides_count){
						play(idx);
					}
				});
			}
			$("#slides_thumbs").click(function(e){
				var $li = $(e.target).closest('li');
				var idx = parseInt($li.attr('slideindex'));
				if(!isNaN(idx) && idx >= 0 && idx < slides_count){
					play(idx);
				}
			});
			
			if($slides_map){
				$slides_map.bind(slides_maptrigger, function(){
					var idx = $slides_map.index($(this).closest('li'));
					play(idx);
				});
			}
			
			if(!nobreak){
				$this.mouseenter(function(){
					mousein = true;
					pause();
				}).mouseleave(function(){
					mousein = false;
					start();
				});
			}
        }
		function next(){
			if(!mousein){
				play(slide_index+1);
			}
		}
		function pause(){
			clearTimeout(interval);
		}
		function start(){
			clearTimeout(interval);
			interval = setTimeout(next, interval_time);
		}
		function slidefin(idx){
			var newli = $slides.find('li').eq(idx);
			if(overlay){
				var alink = newli.find('a');
				$overlay.html('<a href="' + alink.attr('href') + '" target="' + alink.attr('target') + '"></a>');
			}
			isanimate = false;
			slide_index = idx;
			if(new_id >= 0){
				play(new_id);
				new_id = -1;
			}else{
				start();
			}
		}
        function play(idx){
			if(isanimate && idx !== slide_index){
				new_id = idx;
			}
			if(isanimate || idx == slide_index || typeof idx !== 'number'){
				start();
				return;
			}
			if(idx >= slides_count){
				idx = 0;
			}
			isanimate = true;
			
			var oldli = $slides.find('li').eq(slide_index);
			var newli = $slides.find('li').eq(idx);
			// 显示标题
			var n_title = newli.find('a').attr('title');
			var n_url = newli.find('a').attr('href');
			var n_target = newli.find('a').attr('target');
			var desc =newli.find('a').attr('name');
				var n_desc;
				if(desc!=undefined){
					n_desc =desc;		
				}else{
					n_desc="";
				}
			if(show_title && typeof n_title == 'string' && n_title !== ''){
				n_url = !n_url || n_url == '' ? '' : ' href="' + n_url + '"';
				n_target = !n_url || n_url == '' ? '' : ' target="' + n_url + '"';
				$slides_title.find('.front').html('<a' + n_url + n_target + '>' + n_title + '</a>' +'<p>' + n_desc + '</p>');
				if(!param['map']){
					$slides_title.find('.front').css({
						width:param['width'] - $slides_nav.width() > 0 ? param['width'] - $slides_nav.width() : 'auto'
					});
				}
				$slides_title.show();
			}else{
				$slides_title.hide();
			}
			if(direction == false){
				oldli.css({'z-index':0}).animate({
					'opacity': 0
				}, animate_time,'linear', function(){
					oldli.hide();
				});
				newli.css({'z-index':1}).show().animate({
					'opacity': 1
				}, animate_time,'linear', function(){
					slidefin(idx);
				});
			}else{
				if(direction == 'top'){
					$slides.animate({'margin-top': -idx*slide_height}, animate_time, 'linear', function(){
						slidefin(idx);
					});
				}
				if(direction == 'left'){
					$slides.animate({'margin-left': -idx*slide_width}, animate_time, 'linear', function(){
						slidefin(idx);
					});
				}
			}
			$slides_nav.find('li').eq(slide_index).removeClass('active');
			$slides_nav.find('li').eq(idx).addClass('active');
			$("#slides_thumbs").find('li').eq(slide_index).find(".bspan").hide();
			$("#slides_thumbs").find('li').eq(idx).find(".bspan").show();
			if($slides_map && $slides_map.length > 0){
				$slides_map.eq(slide_index).removeClass('active');
				$slides_map.eq(idx).addClass('active');
			}
        }
    };
})(jQuery);