<?php
! defined ( 'ACLOUD_PATH' ) && exit ( 'Forbidden' );

define ( 'MESSAGE_INVALID_PARAMS', 601 );
define ( 'MESSAGE_UID_ERROR', 602 );
define ( 'MESSAGE_SEND_FAIL', 603 );

class ACloudVerCommonMessage extends ACloudVerCommonBase {
	/**
	 * 
	 * ͳûδ֪ͨ
	 * 
	 * @param int $uid
	 * @return int
	 */
	public function countUnreadMessage($uid) {
		$user = new PwUserBo ( intval ( $uid ) );
		$result = $user->info ['messages'];
		if (! $result)
			return $this->buildResponse ( MESSAGE_UID_ERROR );
		return $this->buildResponse ( 0, $result );
	}
	
	/**
	 * 
	 * ȡûӦĶԻб
	 * 
	 * @param int $uid
	 * @param int $start
	 * @param int $limit
	 * @return array 
	 */
	public function getMessageByUid($uid, $offset, $limit) {
		$user = new PwUserBo ( $uid );
		if (! $user->isExists ())
			return $this->buildResponse ( MESSAGE_UID_ERROR );
		$result = $this->getPwMessageService ()->getDialogs ( $uid, $offset, $limit );
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		return $this->buildResponse ( 0, $result );
	}
	
	public function getReplyThreadMessage($uid, $offset, $limit) {
	
	}
	
	/**
	 * ûID˽
	 * 
	 * @param int $uid
	 * @param string $content
	 * @return PwError|boolean
	 */
	public function sendMessage($fromUid, $toUid, $title, $content) {
		$result = $this->getPwMessageService ()->sendMessageByUid ( $toUid, $content, $fromUid );
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		return $this->buildResponse ( 0, $result );
	}
	
	public function replyMessage($messageId, $relationId, $uid, $content) {
	
	}
	
	/**
	 * ȡԻϢб
	 *
	 * @param int $messageId
	 * @param int $start
	 * @param int $limit
	 * @return array
	 */
	public function getMessageAndReply($messageId, $relationId, $uid, $offset, $limit) {
		$result = $this->getPwMessageService ()->getDialogMessageList ( $messageId, $offset, $limit );
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		return $this->buildResponse ( 0, $result );
	}
	
	private function getPwMessageService() {
		return wekit::load ( 'SRV:message.srv.PwMessageService' );
	}
}