<?php
! defined ( 'ACLOUD_PATH' ) && exit ( 'Forbidden' );

define ( 'USER_INVALID_PARAMS', 201 );
define ( 'USER_INVALID_USERNAME', 202 );
define ( 'USER_UPDATE_ERROR', 203 );
define ( 'USER_DELETE_ERROR', 204 );
define ( 'USER_NOT_EXISTS', 205 );
define ( 'USER_PWD_ERROR', 206 );
define ( 'USER_REGISTER_CLOSE', 207 );
define ( 'USER_REGISTER_SAME_USERNAME_PASSWORD', 208 );
define ( 'USER_REGISTER_FAIL', 209 );
define ( 'FORUM_FAVOR_MAX', 210 );
define ( 'FORUM_FAVOR_ALREADY', 211 );

class ACloudVerCustomizedUser extends ACloudVerCustomizedBase {
	
	/** 
	 * ûIDûϢ
	 *
	 * @param int $uid 	ûID
	 * @return array
	 */
	public function getByUid($uid) {
		$uid = intval ( $uid );
		if ($uid < 1)
			return $this->buildResponse ( USER_INVALID_PARAMS,"");
		$userInfo = $this->getUser ()->getUserByUid ( $uid, PwUser::FETCH_ALL );
		$groupId = ($userInfo['groupid'] == 0) ? $userInfo['memberid'] : $userInfo['groupid'];
		$group = $this->getUserGroup()->getGroupByGid($groupId);
		$loginUser = Wekit::getLoginUser ();
		$subjectNum = $this->getThread ()->countThreadByUid ( $uid );	//û
		$result = $this->buildInfo ( $userInfo, $loginUser, $group ['name'], $subjectNum );
		return $this->buildResponse ( 0, $result );
	}
	
	/** 
	 * ûֻûϢ
	 *
	 * @param string $username  û
	 * @return array
	 */
	public function getByName($username) {
		$username = trim ( $username );
		if (! $username)
			return $this->buildResponse ( USER_INVALID_USERNAME,"" );
		$userInfo = $this->getUser ()->getUserByName ( trim ( $username ), PwUser::FETCH_ALL );
		if ($userInfo instanceof PwError)
			return $this->buildResponse ( - 1, $userInfo->getError () );
		$groupId = ($userInfo['groupid'] == 0) ? $userInfo['memberid'] : $userInfo['groupid'];
		$group = $this->getUserGroup()->getGroupByGid($groupId);
		$loginUser = Wekit::getLoginUser ();
		$subjectNum = $this->getThread ()->countThreadByUid ( $userInfo ['uid'] );
		$result = $this->buildInfo ( $userInfo, $loginUser, $group ['name'], $subjectNum );
		return $this->buildResponse ( 0, $result );
	}
	
	public function updateIcon($uid) {
		$userBo = Wekit::getLoginUser();
		if($userBo->uid != $uid) return $this->buildResponse ( USER_NOT_LOGIN,"ûδ¼" );
		Wind::import('SRV:upload.action.PwAvatarUpload');
		Wind::import('LIB:upload.PwUpload');
		$bhv = new PwAvatarUpload($userBo);
		
		$upload = new PwUpload($bhv);
		
		if (($result = $upload->check()) === true) {
			$result = $upload->execute();
		}
		if ($result !== true) {
			return $this->buildResponse ( USER_UPDATE_ERROR, "ͷ" );
		} else {
			return $this->buildResponse ( 0, '³ɹ' );
		}
	}
	
	/**
	 * ȡĳûİ
	 *
	 * @param int $uid
	 * @return array
	 */
	public function getFavoritesForumByUid($uid) {
		$uid = intval ( $uid );
		if ($uid < 1)
			return $this->buildResponse ( USER_INVALID_USERNAME,"" );
		$loginUser = Wekit::getLoginUser ();
		if ($loginUser ['uid'] == 0)
			return $this->buildResponse ( USER_NOT_LOGIN,"ûδ¼" );
		$result = $this->getForumUser ()->getFroumByUid ( $uid );
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		$fids = array_keys ( $result );
		$forumInfo = $this->getForum ()->fetchForum ( $fids, 3 );
		$result = array_values ( $result );
		
		$forums = array ();
		foreach ( $result as $k => $v ) {
			$forums [$k] ['fid'] = $v ['fid'];
			$forums [$k] ['forumname'] = $forumInfo [$v ['fid']] ['name'];
			$forums [$k] ['todaypost'] = $forumInfo [$v ['fid']] ['todayposts'];
		}
		return $this->buildResponse ( 0, array ('forums' => $forums, 'count' => count ( $forums ) ) );
	}
	
	/**
	 * 
	 *
	 * @param int $uid
	 * @param int $fid
	 * @return int $count
	 */
	public function addFavoritesForumByUid($uid, $fid) {
		list ( $uid, $fid ) = array (intval ( $uid ), intval ( $fid ) );
		if ($fid < 1 || $uid < 1)
			return $this->buildResponse ( USER_INVALID_PARAMS,"" );
		$loginUser = Wekit::getLoginUser ();
		if ($loginUser ['uid'] == 0)
			return $this->buildResponse ( USER_NOT_LOGIN ,"ûδ¼");
		if ($this->getForumUser ()->get ( $uid, $fid ))
			return $this->buildResponse ( FORUM_FAVOR_ALREADY,"ðѾղ" );
		$result = $this->getForumUser ()->join ( $uid, $fid );
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		$count = count ( $this->getForumUser ()->getFroumByUid ( $uid ) );
		return $this->buildResponse ( 0, array ('count' => $count ) );
	}
	
	/**
	 * ˳
	 *
	 * @param int $uid
	 * @param int $fid
	 * @return array
	 */
	public function deleteFavoritesForumByUid($uid, $fid) {
		list ( $uid, $fid ) = array (intval ( $uid ), intval ( $fid ) );
		if ($fid < 1 || $uid < 1)
			return $this->buildResponse ( USER_INVALID_PARAMS,"" );
		$loginUser = Wekit::getLoginUser ();
		if ($loginUser ['uid'] == 0)
			return $this->buildResponse ( USER_NOT_LOGIN ,"ûδ¼");
		$result = $this->getForumUser ()->quit ( $uid, $fid );
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		$count = count ( $this->getForumUser ()->getFroumByUid ( $uid ) );
		return $this->buildResponse ( 0, array ('count' => $count ) );
	}
	
	/**
	 * û¼
	 *
	 * @param string $username û¼ʺ
	 * @param string $password û¼
	 * @return array
	 */
	public function userLogin($username, $password) {
		list ( $username, $password ) = array (trim ( $username ), trim ( $password ) );
		if (empty ( $username ) || empty ( $password ))
			return $this->buildResponse ( USER_INVALID_PARAMS ,"");
		$ip = Wind::getApp ()->getRequest ()->getClientIp ();
		$result = $this->getLoginService ()->login ( $username, $password, $ip );
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		return $this->buildResponse ( 0, array ('uid' => $result ['uid'] ) );
	}
	
	/** 
	 * ûעϢ
	 * 
	 * @return boolean|int
	 */
	public function userRegister($username, $password, $email) {
		if (! trim ( $username ))
			return $this->buildResponse ( USER_INVALID_USERNAME,"" );
		if (! $password || ! $email || WindValidator::isEmail ( $email ) !== true)
			return $this->buildResponse ( USER_INVALID_PARAMS,"" );
		Wind::import ( 'SRV:user.srv.PwRegisterService' );
		Wind::import ( 'SRC:service.user.dm.PwUserInfoDm' );
		
		$userDm = new PwUserInfoDm ();
		$userDm->setUsername ( $username );
		$userDm->setPassword ( $password );
		$userDm->setEmail ( $email );
		$userDm->setRegdate ( Pw::getTime () );
		$userDm->setRegip ( Wind::getApp ()->getRequest ()->getClientIp () );

		$registerService = new PwRegisterService ();
		$registerService->setUserDm ( $userDm );
		$result = $registerService->register ();
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		return $this->buildResponse ( 0, array ('uid' => $result ['uid'] ) );
	}
	
	/** 
	 * ༭email
	 *
	 * @param int $uid ûid
	 * @param int $email email
	 * @return boolean|PwError
	 */
	public function updateEmail($uid, $email) {
		$uid = intval ( $uid );
		if ($uid < 1)
			return $this->buildResponse ( USER_INVALID_PARAMS ,"");
		$loginUser = Wekit::getLoginUser ();
		if ($loginUser ['uid'] == 0)
			return $this->buildResponse ( USER_NOT_LOGIN ,"ûδ¼");
		if (! $email || WindValidator::isEmail ( $email ) !== true)
			return $this->buildResponse ( USER_INVALID_PARAMS,"" );
		
		Wind::import ( 'SRC:service.user.dm.PwUserInfoDm' );
		$userDm = new PwUserInfoDm ($uid);
		$userDm->setEmail ( $email );
		$result = $this->getUser ()->editUser ( $userDm, PwUser::FETCH_MAIN );
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		return $this->buildResponse ( 0, array ('uid' => $uid ) );
	}
	
	private function buildInfo($userInfo, $loginUser, $groupName, $subjectNum) {
		$result = array ();
		$result ['uid'] = $userInfo ['uid'];
		$result ['username'] = $userInfo ['username'];
		$result ['gender'] = $userInfo ['gender'];
		$result ['icon'] = Pw::getAvatar ( $userInfo ['uid'] );
		$result ['birthday'] = $userInfo ['byear'] . '-' . $userInfo ['bmonth'] . '-' . $userInfo ['bday'];
		$result ['honor'] = ''; //Զͷ
		$result ['postnum'] = $userInfo ['postnum'];
		$result ['ltitle'] = $groupName;
		$isFollowed = $this->getAttention ()->isFollowed ( $user->uid, $userInfo ['uid'] );
		$result ['isfollowed'] = ($isFollowed == true) ? 1 : 0;
		$result ['replycount'] = $userInfo ['postnum'] - $subjectNum ;
		$result ['favorcount'] = 0; //ղ
		$result ['messages'] = $userInfo['messages'];
		$result ['notices'] = $userInfo['notices'];
		$result ['weibo'] = $this->getWeiboInfo ( $userInfo ['uid'], $userInfo ['fans'], $userInfo ['follows'] );
		return $result;
	}
	
	private function getWeiboInfo($uid, $fans, $follows) {
		$weiboDs = $this->getWeibo ();
		$result ['followedweibo'] = 0; //ͳûע΢
		$result ['userweibo'] = 0; //ͳû΢
		$result ['referweibo'] = 0; //ȡᵽҵ΢
		$result ['fans'] = $fans;
		$result ['follows'] = $follows;
		return $result;
	}

	public function checkCookie($cookie){
		if (empty($cookie)) {
			$uid = $password = '';
		} else {
			list($uid, $password) = explode("\t", Pw::decrypt($cookie));
		}
		Wind::import('SRV:user.bo.PwUserBo');
		$user = new PwUserBo($uid);
		if (!$user->isExists() || Pw::getPwdCode($user->info['password']) != $password) {
			return $this->buildResponse(-1,'cookieǷ');
		} else {
			return $this->buildResponse(0,array('uid'=>$uid,'username'=>$user->username));
		}
		
	}

	public function getUserBindInfo($uid,$type=''){
		$extService = Wekit::load('EXT:account.service.srv.App_Account_CommonService');		
		if(!is_object($extService)){
			return $this->buildResponse(-1,'can not find extension');
		}
		$info = $extService->getUserBoundInfo($uid,$type);
		return $this->buildResponse(0,$info);
	}
	
	private function getUser() {
		return Wekit::load ( 'SRV:user.PwUser' );
	}
	
	private function getForumUser() {
		return Wekit::load ( 'SRV:forum.PwForumUser' );
	}
	
	private function getLoginService() {
		return Wekit::load ( 'SRV:user.srv.PwLoginService' );
	}
	
	private function getUserBanService() {
		return Wekit::load ( 'SRV:user.srv.PwUserBanService' );
	}
	
	private function getAttention() {
		return Wekit::load ( 'SRV:attention.PwAttention' );
	}
	
	private function getThread() {
		return Wekit::load ( 'SRV:forum.PwThread' );
	}
	
	private function getWeibo() {
		return Wekit::load ( 'SRV:weibo.PwWeibo' );
	}
	
	private function getUserGroup(){
		return Wekit::load('SRV:usergroup.PwUserGroups');
	}
	
	private function getForum() {
		return Wekit::load ( 'SRV:forum.PwForum' );
	}
}