<?php
/**
 * ݷ
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwStyle.php 24585 2013-02-01 04:02:37Z jieyin $
 * @package service.style
 */
class PwStyle {
	
	/**
	 * 
	 *
	 * @param PwStyleDm $dm
	 * @return PwError|boolean
	 */
	public function addStyle(PwStyleDm $dm) {
		if (($r = $dm->beforeAdd()) instanceof PwError) return $r;
		return $this->_styleDao()->addStyle($dm->getData());
	}
	
	/**
	 * ޸
	 *
	 * @param int $styleid
	 * @param array $data
	 * @return boolean
	 */
	public function updateStyle(PwStyleDm $dm) {
		if (($r = $dm->beforeUpdate()) instanceof PwError) return $r;
		return $this->_styleDao()->updateStyle($dm->getField('app_id'), $dm->getData());
	}
	
	/**
	 * ɾ
	 *
	 * @param int $styleid
	 * @return booelan
	 */
	public function deleteStyle($styleid) {
		return $this->_styleDao()->deleteStyle($styleid);
	}
	
	/**
	 * ͳƷ
	 *
	 * @return int
	 */
	public function countByType($type = 'site') {
		return $this->_styleDao()->countByType(trim($type));
	}
	
	/**
	 * ȡǰ
	 *
	 * @return array
	 */
	public function getCurrentStyleByType($type = 'site') {
		return $this->_styleDao()->getCurrentStyleByType(trim($type));
	}
	
	/**
	 * ȡз
	 *
	 * @param int $offset
	 * @param int $limit
	 * @param string $orderBy
	 * @return array
	 */
	public function getStyleListByType($type = 'site', $num = 10, $start = 0) {
		return $this->_styleDao()->getStyleListByType(trim($type), (int)$num, (int)$start);
	}
	
	/**
	 * ȡϸϢ
	 *
	 * @param int $styleid
	 * @return array
	 */
	public function getStyle($styleid) {
		return $this->_styleDao()->getStyle($styleid);
	}
	
	/**
	 * ȡз
	 *
	 * @param string $type
	 */
	public function getAllStyle($type = 'site') {
		return $this->_styleDao()->getAllStyles(trim($type));
	}

	/**
	 * ݷĿ¼ҷ
	 *
	 * @param array|string $package
	 */
	public function fetchStyleByAliasAndType($alias, $type = 'site', $index = 'app_id') {
		if (!$alias) return array();
		return $this->_styleDao()->fetchStyleByAliasAndType($alias, $type, $index);
	}
	
	/**
	 * ӦIDӦ
	 *
	 * @param string $appId
	 * @return PwError boolean
	 */
	public function findByAppId($appId) {
		if (!$appId) return new PwError('APPCENTER:validate.fail', array('error' => 'ӦòʱӦIDǷ'));
		return $this->_styleDao()->findByAppId($appId);
	}
	
	/**
	 * @return PwStyleDao
	 */
	private function _styleDao() {
		return Wekit::loadDao('APPCENTER:service.dao.PwStyleDao');
	}
}

?>