<?php
Wind::import('APPCENTER:service.srv.helper.PwApplicationHelper');
Wind::import('APPCENTER:service.srv.helper.PwManifest');
/**
 * pw ϵͳӦðװ
 *
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwInstallApplication.php 24585 2013-02-01 04:02:37Z jieyin $
 * @package products
 * @subpackage appcenter.service.srv
 */
class PwInstallApplication {
	const CONF_PATH = 'APPCENTER:conf.install.php';
	/**
	 * װʱλ
	 *
	 * @var string
	 */
	protected $tmpPath = '';
	protected $tmpPackage = '';
	protected $tmpInstallLog = '';
	/**
	 * ӦϢ
	 *
	 * @var array
	 */
	protected $_config = array();
	/**
	 *
	 * @var PwManifest
	 */
	protected $_manifest = null;
	protected $_appId = '';
	private $_hash = '';
	private $_log = array();
	private $_step = false;

	/**
	 * ʼװ
	 */
	public function __construct() {
		$this->_appId = 'L000' . time() . WindUtility::generateRandStr(4);
		$this->_config = @include (Wind::getRealPath(self::CONF_PATH, true));
		$this->tmpPath = Wind::getRealPath($this->getConfig('tmp_dir') . '.' . Pw::getTime(), false);
		$this->tmpInstallLog = Wind::getRealPath($this->getConfig('log_dir'), false);
	}

	/**
	 * ߰װͳһ
	 *
	 * 1. УIDǷϷǷѾװ
	 * 2. ذװ
	 * 3. УhashֵϷ
	 * 4. ѹװ
	 * 5. Ӧ
	 * 6. У汾ǷϷǷϷ
	 *
	 * @param int $id        	
	 * @param string $hash        	
	 * @return PwError true
	 */
	public function install($id) {
		$this->_appId = $id;
		$_r = $this->download();
		if ($_r instanceof PwError) return $_r;
		file_put_contents(DATA_PATH . 'tmp/log', 'Download!');
		$extends = $this->getOnlineInfo();
		if ($extends instanceof PwError) return $extends;
		file_put_contents(DATA_PATH . 'tmp/log', 'getOnlineInfo!', FILE_APPEND);
		if (true !== $_r = $this->initInstall('', $extends)) return $_r;
		file_put_contents(DATA_PATH . 'tmp/log', 'initInstall!', FILE_APPEND);
		if (true !== $_r = $this->doInstall('all', $this->_hash)) {
			$this->rollback();
			return $_r;
		}
		
		$this->clear();
		return true;
	}

	/**
	 * Ӧðװӿͳһ
	 *
	 * @param string $id
	 *        	appID
	 * @return PwError true
	 */
	public function onlineInstall($id) {
		$this->_appId = $id;
		$manifest = $this->getOnlineInfo();
		if ($manifest instanceof PwError) return $manifest;
		$manifest['application']['alias'] = $id;
		if (true !== $_r = $this->initInstall(array(), $manifest)) return $_r;
		if (true !== $_r = $this->doInstall('all', $this->_hash)) {
			$this->rollback();
			return $_r;
		}
		$this->clear();
		return true;
	}

	/**
	 * ػװͳһ
	 *
	 * @param string $installPack        	
	 * @return PwError true
	 */
	public function localInstall($installPack) {
		if (true !== ($_r = $this->extractPackage($installPack))) return $_r;
		if (true !== $_r = $this->initInstall()) return $_r;
		if (true !== $_r = $this->doInstall('all', $this->_hash)) {
			$this->rollback();
			return $_r;
		}
		
		$this->clear();
		return true;
	}

	/**
	 * ѹѹ
	 *
	 * step 2
	 * 
	 * @param string $packageFile        	
	 * @return true PwError
	 */
	public function extractPackage($packageFile) {
		$this->_hash = md5_file($packageFile);
		$this->tmpPackage = PwApplicationHelper::extract($packageFile, $this->tmpPath);
		if ($this->tmpPackage === false || !is_dir($this->tmpPackage)) return new PwError(
			'APPCENTER:install.checkpackage.format.fail', array('{{error}}' => $this->tmpPackage));
		return true;
	}

	/**
	 * ʼװϢעᰲװ򵽰װ
	 * עӦðװϢӦðװ
	 *
	 * step 3
	 * 
	 * @param array $manifest        	
	 * @return PwError true
	 */
	public function initInstall($manifest = '', $extends = array()) {
		if ($manifest === '') {
			$manifest = $this->tmpPackage . '/' . $this->getConfig('manifest');
			if (!is_file($manifest)) return new PwError('APPCENTER:install.mainfest.not.exist');
		} 
		
		$this->_manifest = new PwManifest($manifest, $extends);
		// TODO УϵͳǷϷ У汾ǷϷ УϢǷϷ У
		// 'APPCENTER:install.manifest.fail'
		return true;
	}

	/**
	 * ִаװ̣Ƿװɹ
	 *
	 * step 4
	 * հװĿ¼
	 * 1. 鲢ѹװʱĿ¼£鰲װĸʽԼ
	 * 3. ʼذװ
	 * 2. װƶĿλ
	 * 3. עӦİװаװ
	 * 
	 * @param string $step
	 *        	Ҫִеİװ
	 * @return PwError true next
	 */
	public function doInstall($step, $hash) {
		try {
			$this->tmpInstallLog .= '/' . $hash . '.log';
			$this->_step = ($step !== 'all');
			/* @var $install PwInstallApplication */
			list($service, , $install) = $this->resolvedInstallation($this->tmpInstallLog);
			if (empty($service)) return new PwError('APPCENTER:install.service.fail');
			$this->_appId = $install->getAppId();
			
			$next = true;
			if ($step !== 'all') {
				if (!isset($service[$step])) return new PwError('APPCENTER:install.step.fail');
				isset($service[$step + 1]) && $next = array(
					$step + 1, 
					$service[$step + 1]['message']);
				$service = array($service[$step]);
			}
			foreach ($service as $key => $var) {
				if (!isset($var['class'])) continue;
				$_install = Wekit::load($var['class']);
				if (!$_install instanceof iPwInstall) return new PwError(
					'APPCENTER:install.classtype');
				$_m = empty($var['method']) ? 'install' : $var['method'];
				$r = $_install->$_m($install);
				if ($r instanceof PwError) return $r;
			}
			if ($next !== true) {
				$installation = array('installation' => base64_encode(serialize($install)));
				PwApplicationHelper::writeInstallLog($this->tmpInstallLog, $installation, true);
			} else {
				$fields = array();
				foreach ($install->getInstallLog() as $key => $value) {
					$_tmp = array(
						'app_id' => $install->getAppId(), 
						'log_type' => $key, 
						'data' => $value, 
						'created_time' => WEKIT_TIMESTAMP, 
						'modified_time' => WEKIT_TIMESTAMP);
					$fields[] = $_tmp;
				}
				$this->_loadInstallLog()->batchAdd($fields);
			}
			return $next;
		} catch (Exception $e) {
			$error = $e->getMessage();
			is_array($error) || $error = array(
				'APPCENTER:install.fail', 
				array('{{error}}' => $e->getMessage()));
			return new PwError($error[0], $error[1]);
		}
	}

	/**
	 * Ӧðװʱع
	 *
	 * step 5
	 * 
	 * @return oid
	 */
	public function rollback() {
		list(, $rollback, $install) = $this->resolvedInstallation($this->tmpInstallLog);
		foreach ($rollback as $var) {
			if (!isset($var['class'])) continue;
			$_install = Wekit::load($var['class']);
			if (!$_install instanceof iPwInstall) return new PwError('APPCENTER:install.classtype');
			$_install->rollback($install);
		}
	}

	/**
	 * װвʱϢ
	 *
	 * step 5
	 * 
	 * @return void
	 */
	public function clear() {
		list(, , $install) = $this->resolvedInstallation($this->tmpInstallLog);
		if (is_file($this->tmpInstallLog)) WindFile::del($this->tmpInstallLog);
		if ($install->getTmpPackage()) WindFolder::rm($install->getTmpPackage(), true);
		if ($install->getTmpPath()) WindFolder::rm($install->getTmpPath(), true);
	}

	/**
	 *
	 * @param string $key        	
	 */
	public function getInstallLog($key = '') {
		return $key === '' ? $this->_log : (isset($this->_log[$key]) ? $this->_log[$key] : array());
	}

	/**
	 * ռװ־
	 *
	 * @param string $key        	
	 * @param array $value        	
	 */
	public function setInstallLog($key, $value) {
		$this->_log[$key] = $value;
	}

	/**
	 * ռװ־
	 *
	 * @param string $key        	
	 * @param array $value        	
	 */
	public function addInstallLog($key, $value) {
		if (!isset($this->_log[$key])) $this->_log[$key] = array();
		$this->_log[$key][] = $value;
	}
	
	/**
	 * Ӧ
	 *
	 * @return boolean|PwError
	 */
	public function download() {
		if (function_exists('gzinflate')) {
			$r = $this->downloadInstallPack();
			if ($r instanceof PwError) {
				return $r;
			}
			$r = $this->extractPackage($r);
			if ($r instanceof PwError) {
				return $r;
			}
		} else {
			$r = $this->downloadFiles();
			if ($r instanceof PwError) return $r;
		}
		return true;
	}
	
	/**
	 * ļ
	 *
	 * @return PwError
	 */
	public function downloadFiles() {
		return new PwError('APPCENTER:unsupport.zip');
	}

	/**
	 * ӦðװhashУ飬غַ
	 *
	 * step 1
	 * 
	 * @return string PwError
	 */
	public function downloadInstallPack() {
		$url = PwApplicationHelper::acloudUrl(
			array('a' => 'forward', 'do' => 'getDownLoadUrl', 'appid' => $this->_appId));
		$info = PwApplicationHelper::requestAcloudData($url);
		if ($info['code'] !== '0') return new PwError('APPCENTER:install.download.fail', 
			array('{{error}}' => $info['msg']));
		list($bool, $package) = PwApplicationHelper::requestAcloudData($info['info']['download'], 
			$this->tmpPath);
		if (!$bool) return new PwError('APPCENTER:install.download.fail', array('{{error}}' => $package));
		if ($info['info']['hash'] !== md5_file($package)) {
			return new PwError('APPCENTER:install.checkpackage.fail');
		}
		$this->_hash = $info['hash'];
		return $package;
	}
	
	/**
	 * ȡӦûϢӦύӦдlogo
	 *
	 * @return PwError|array  
	 */
	public function getOnlineInfo() {
		$url = PwApplicationHelper::acloudUrl(
			array('a' => 'forward', 'do' => 'getAppById', 'appid' => $this->_appId));
		$data = PwApplicationHelper::requestAcloudData($url);
		if ($data['code'] !== '0') return new PwError('APPCENTER:install.fail',
			array('{{error}}' => $data['msg']));
		$manifest = array(
			'application' => array(
				'name' => $data['info']['app_name'],
				'version' => $data['info']['version'],
				'pw-version' => $data['info']['bbs_version'],
				'description' => trim($data['info']['description'], '\'"'),
				'logo' => $data['info']['icon'],
				'author-name' => trim($data['info']['app_author'], '\'"'),
				'website' => $data['info']['author_url'],
				'charset' => ACloudSysCoreCommon::getGlobal('g_charset')
				));
		return $manifest;
	}

	/**
	 * ȡֵ
	 *
	 * @return mixed
	 */
	public function getConfig($configName = '', $subConfigName = '', $default = '') {
		if ($configName === '') return $this->_config;
		if (!isset($this->_config[$configName])) return $default;
		if ($subConfigName === '') return $this->_config[$configName];
		if (!isset($this->_config[$configName][$subConfigName])) return $default;
		return $this->_config[$configName][$subConfigName];
	}

	/**
	 * ȡװע
	 *
	 * @return array
	 */
	protected function resolvedInstallation($file) {
		$install = null;
		if ($this->_step && is_file($file)) {
			$service = PwApplicationHelper::readInstallLog($file, 'services');
			$rollback = PwApplicationHelper::readInstallLog($file, 'rollback');
			$install = PwApplicationHelper::readInstallLog($file, 'installation');
			$install = unserialize(base64_decode($install));
		} else {
			$service = $rollback = array();
			$conf = $this->getConfig('install-type', 
				$this->getManifest()->getApplication('type', 'app'));
			if (!empty($conf['step']['before'])) {
				foreach ($conf['step']['before'] as $var) {
					$var['class'] = $conf['class'];
					$service[] = $var;
				}
			} else
				$service[] = $conf;
			
			$rollback[] = $conf;
			foreach ($this->getManifest()->getInstallationService() as $var) {
				// TODO ӹлȡ
				$_tmp = $this->getConfig('installation-service', $var);
				if (!$_tmp) continue;
				$_tmp['_key'] = $var;
				$rollback[] = $service[] = $_tmp;
				$this->addInstallLog('service', $_tmp);
			}
			
			if (!empty($conf['step']['after'])) {
				foreach ($conf['step']['after'] as $var) {
					$var['class'] = $conf['class'];
					$service[] = $var;
				}
			}
			
			$manifest = $this->getManifest()->getManifest();
			if (isset($manifest['install']) && $manifest['install']) {
				$_tmp = array('class' => $manifest['install']);
				$service[] = $_tmp;
				$this->addInstallLog('service', $_tmp);
			}
			
			$this->addInstallLog('service', $conf);
			if ($this->_step) {
				PwApplicationHelper::writeInstallLog($file, 
					array(
						'services' => $service, 
						'rollback' => $rollback, 
						'installation' => base64_encode(serialize($this))));
			}
			$install = $this;
		}
		return array($service, $rollback, $install);
	}

	/**
	 *
	 * @return PwManifest
	 */
	public function getManifest() {
		return $this->_manifest;
	}

	/**
	 *
	 * @return string
	 */
	public function getTmpPath() {
		return $this->tmpPath;
	}

	/**
	 *
	 * @param string $path        	
	 */
	public function setTmpPath($path) {
		$this->tmpPath = $path;
	}

	/**
	 *
	 * @return string
	 */
	public function getTmpPackage() {
		return $this->tmpPackage;
	}
	
	/**
	 *
	 * @param string
	 */
	public function setTmpPackage($package) {
		$this->tmpPackage = $package;
	}

	/**
	 *
	 * @return string
	 */
	public function getHash() {
		return $this->_hash;
	}

	/**
	 *
	 * @return string
	 */
	public function getAppId() {
		return $this->_appId;
	}
	
	/**
	 *
	 * @return PwApplicationLog
	 */
	private function _loadInstallLog() {
		return Wekit::load('APPCENTER:service.PwApplicationLog');
	}

}

?>