<?php
/**
 * Zipļѹ
 *
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwExtractZip.php 7688 2012-04-10 11:22:26Z long.shi $
 * @package wind
 */

class PwExtractZip {
	
	const EOF_CENTRAL_DIRECTORY = 0x06054b50;//end of central directory record
	const LOCAL_FILE_HEADER = 0x04034b50;//Local file header
	const CENTRAL_DIRECTORY = 0x02014b50;//Central directory
	
	private $fileHandle = '';
	
	/**
	 * ѹһļ
	 * @param $zipfile string ѹZIPļ
	 * @param $zipfile string ȡѹеļ
	 * @return array ѹݣаʱ䡢ļ
	 */
	public function extract($zipPack, $aFile='') {
		if (!$zipPack || !is_file($zipPack)) return false;
		$extractedData = array();
		$this->fileHandle = fopen($zipPack, 'rb');
		$filesize = sprintf('%u', filesize($zipPack));
		$EofCentralDirData = $this->_findEOFCentralDirectoryRecord($filesize);
		if (!is_array($EofCentralDirData)) return false;
		$centralDirectoryHeaderOffset = $EofCentralDirData['centraldiroffset'];
		for ($i = 0; $i < $EofCentralDirData['totalentries']; $i++) {
			rewind($this->fileHandle);
			fseek($this->fileHandle, $centralDirectoryHeaderOffset);
			$centralDirectoryData = $this->_readCentralDirectoryData();
			if (!is_array($centralDirectoryData)) {
				$centralDirectoryHeaderOffset += 46;
				continue;
			}
			$centralDirectoryHeaderOffset += 46 + $centralDirectoryData['filenamelength'] + $centralDirectoryData['extrafieldlength'] + $centralDirectoryData['commentlength'];
			if (substr($centralDirectoryData['filename'], -1) === '/') continue;
			
			if (!$aFile) {
				$data = $this->_readLocalFileHeaderAndData($centralDirectoryData);
				if ($data === false) continue;
				$extractedData[$i] = array(
					'filename' => $centralDirectoryData['filename'],
					'timestamp' => $centralDirectoryData['time'],
					'data' => $data,
				);
			} elseif ($aFile === $centralDirectoryData['filename']) {
				$data = $this->_readLocalFileHeaderAndData($centralDirectoryData);
				if ($data === false) return false;
				$extractedData = $data;
				break;
			}
		}
		fclose($this->fileHandle);
		return $extractedData;
	}
	
	public function getFileLists($zipPack) {
		if (!$zipPack || !is_file($zipPack)) return false;
		$extractedData = array();
		$this->fileHandle = fopen($zipPack, 'rb');
		$filesize = sprintf('%u', filesize($zipPack));
		$EofCentralDirData = $this->_findEOFCentralDirectoryRecord($filesize);
		if (!is_array($EofCentralDirData)) return false;
		$centralDirectoryHeaderOffset = $EofCentralDirData['centraldiroffset'];
		for ($i = 0; $i < $EofCentralDirData['totalentries']; $i++) {
			rewind($this->fileHandle);
			fseek($this->fileHandle, $centralDirectoryHeaderOffset);
			$centralDirectoryData = $this->_readCentralDirectoryData();
			if (!is_array($centralDirectoryData)) {
				$centralDirectoryHeaderOffset += 46;
				continue;
			}
			$centralDirectoryHeaderOffset += 46 + $centralDirectoryData['filenamelength'] + $centralDirectoryData['extrafieldlength'] + $centralDirectoryData['commentlength'];
			if (substr($centralDirectoryData['filename'], -1) === '/') {
				$extractedData['folder'][$i] = $centralDirectoryData['filename'];
			} else {
				$extractedData['file'][$i] = $centralDirectoryData['filename'];
			}
		}
		fclose($this->fileHandle);
		return $extractedData;
	}
	
	public function extract2($zipPack, $target) {
		if (!$zipPack || !is_file($zipPack)) return false;
		$extractedData = array();
		$target = rtrim($target, '/');
		WindFolder::mkRecur($target, 0777);
		$this->fileHandle = fopen($zipPack, 'rb');
		$filesize = sprintf('%u', filesize($zipPack));
		$EofCentralDirData = $this->_findEOFCentralDirectoryRecord($filesize);
		if (!is_array($EofCentralDirData)) return false;
		$centralDirectoryHeaderOffset = $EofCentralDirData['centraldiroffset'];
		for ($i = 0; $i < $EofCentralDirData['totalentries']; $i++) {
			rewind($this->fileHandle);
			fseek($this->fileHandle, $centralDirectoryHeaderOffset);
			$centralDirectoryData = $this->_readCentralDirectoryData();
			if (!is_array($centralDirectoryData)) {
				$centralDirectoryHeaderOffset += 46;
				continue;
			}
			$centralDirectoryHeaderOffset += 46 + $centralDirectoryData['filenamelength'] + $centralDirectoryData['extrafieldlength'] + $centralDirectoryData['commentlength'];
			if (substr($centralDirectoryData['filename'], -1) === '/') {
				WindFolder::mkRecur($target . '/' . $centralDirectoryData['filename'], 0777);
				$extractedData['folder'][$i] = $centralDirectoryData['filename'];
				continue;
			} else {
				$data = $this->_readLocalFileHeaderAndData($centralDirectoryData);
				if ($data === false) continue;
				WindFile::write($target . '/' . $centralDirectoryData['filename'] , $data);
				$extractedData['file'][$i] = $centralDirectoryData['filename'];
			}
		}
		fclose($this->fileHandle);
		return $extractedData;
	}
	
	/**
	 * ȡѹе'Local file header'ѹ
	 * @param $centralDirectoryData array 'Central directory' 
	 * @return array
	 */
	private function _readLocalFileHeaderAndData($centralDirectoryData) {
		fseek($this->fileHandle, $centralDirectoryData['localheaderoffset']);
		$localFileHeaderSignature = unpack('Vsignature', fread($this->fileHandle, 4));
		if ($localFileHeaderSignature['signature'] != PwExtractZip::LOCAL_FILE_HEADER) return false;
		$localFileHeaderData = fread($this->fileHandle, 26);
		$localFileHeaderData = unpack('vextractversion/vflag/vcompressmethod/vmodtime/vmoddate/Vcrc/Vcompressedsize/Vuncompressedsize/vfilenamelength/vextrafieldlength', $localFileHeaderData);
		$localFileHeaderData['filenamelength'] && $localFileHeaderData['filename'] = fread($this->fileHandle, $localFileHeaderData['filenamelength']);
		$localFileHeaderData['extrafieldlength'] && $localFileHeaderData['extrafield'] = fread($this->fileHandle, $localFileHeaderData['extrafieldlength']);
		if (!$this->_checkLocalFileHeaderAndCentralDir($localFileHeaderData, $centralDirectoryData)) return false;
		//ļܹ
		if ($localFileHeaderData['flag'] & 1) return false;
		$compressedData = fread($this->fileHandle, $localFileHeaderData['compressedsize']);
		$data = $this->_unCompressData($compressedData, $localFileHeaderData['compressmethod']);
		//crc32 У鲻һ»򳤶Ȳһ
		if (crc32($data) != $localFileHeaderData['crc'] || strlen($data) != $localFileHeaderData['uncompressedsize']) return false;
		return $data;
	}
	
	/**
	 * ѹѹ
	 * @param $data string ѹ
	 * @param $compressMethod int ѹķʽ
	 * @return string ѹ
	 */
	private function _unCompressData($data, $compressMethod) {
		if (!$compressMethod) return $data;
		switch ($compressMethod) {
			case 8 : // compressed by deflate
				$data = gzinflate($data);
				break;
			default :
				return false;
				break;
		}
		return $data;
	}
	
	/**
	 * У 'Local file header'  'Central directory'
	 * @param unknown_type $localFileHeaderData
	 * @param unknown_type $centralDirectoryData
	 * @return bool
	 */
	private function _checkLocalFileHeaderAndCentralDir($localFileHeaderData, $centralDirectoryData) { 
		return true; //ʱ֤Ҫʱչ
	}
	
	/**
	 * ȡ'Central directory' 
	 * @return string
	 */
	private function _readCentralDirectoryData() {
		$centralDirectorySignature = unpack('Vsignature', fread($this->fileHandle, 4)); // 'Central directory' ı
		if ($centralDirectorySignature['signature'] != PwExtractZip::CENTRAL_DIRECTORY) return false;
		$centralDirectoryData = fread($this->fileHandle, 42); // 'Central directory' , file name, extra field, file comment 
		$centralDirectoryData = unpack('vmadeversion/vextractversion/vflag/vcompressmethod/vmodtime/vmoddate/Vcrc/Vcompressedsize/Vuncompressedsize/vfilenamelength/vextrafieldlength/vcommentlength/vdiskstart/vinternal/Vexternal/Vlocalheaderoffset', $centralDirectoryData);
		$centralDirectoryData['filenamelength'] && $centralDirectoryData['filename'] = fread($this->fileHandle, $centralDirectoryData['filenamelength']); //ȡļ
		$centralDirectoryData['extrafieldlength'] && $centralDirectoryData['extrafield'] = fread($this->fileHandle, $centralDirectoryData['extrafieldlength']); //ȡextra field
		$centralDirectoryData['commentlength'] && $centralDirectoryData['comment'] = fread($this->fileHandle, $centralDirectoryData['commentlength']); //ȡ file comment
		$centralDirectoryData['time'] = $this->_recoverFromDosFormatTime($centralDirectoryData['modtime'], $centralDirectoryData['moddate']); //ȡʱϢ
		return $centralDirectoryData;
	}
	
	/**
	 * ȡ'end of central directory record'
	 * @param $filesize int ļС
	 * @return string 
	 */
	private function _findEOFCentralDirectoryRecord($filesize) {
		fseek($this->fileHandle, $filesize - 22); // 'End of central directory record' һûע͵λڸλ
		$EofCentralDirSignature = unpack('Vsignature', fread($this->fileHandle, 4));
		if ($EofCentralDirSignature['signature'] != PwExtractZip::EOF_CENTRAL_DIRECTORY) { // 'End of central directory record' ĩβ22ֽڵλãע͵
			$maxLength = 65535 + 22; //'End of central directory record' ܵĳȣΪעͳȵĳΪ2ֽڣ2ֽɱĳ655350xFFFF22Ϊ'End of central directory record' ȥעͺĳ
			$maxLength > $filesize && $maxLength = $filesize; //ܳļĴС
			fseek($this->fileHandle, $filesize - $maxLength);
			$searchPos = ftell($this->fileHandle);
			while ($searchPos < $filesize) {
				fseek($this->fileHandle, $searchPos);
				$sigData = unpack('Vsignature', fread($this->fileHandle, 4));
				if ($sigData['signature'] == PwExtractZip::EOF_CENTRAL_DIRECTORY) {
					break;
				}
				$searchPos++;
			}
		}
		$EofCentralDirData = unpack('vdisknum/vdiskstart/vcentraldirnum/vtotalentries/Vcentraldirsize/Vcentraldiroffset/vcommentlength', fread($this->fileHandle, 18)); // 'End of central directory record'signatureע
		$EofCentralDirData['commentlength'] && $EofCentralDirData['comment'] = fread($this->fileHandle, $EofCentralDirData['commentlength']);
		return $EofCentralDirData;
	}
	
	/**
	 * ԭDOSʽʱΪʱ
	 * @param $time
	 * @param $date
	 * @return int
	 */
	private function _recoverFromDosFormatTime($time, $date) {
		$year = (($date & 0xFE00) >> 9) + 1980;
		$month = ($date & 0x01E0) >> 5;
		$day = $date & 0x001F;
		$hour = ($time & 0xF800) >> 11;
		$minutes = ($time & 0x07E0) >> 5;
		$seconds = ($time & 0x001F)*2;
		return mktime($hour, $minutes, $seconds, $month, $day, $year);
	}
}