
DROP TABLE IF EXISTS `pw_acloud_apis`;
CREATE TABLE `pw_acloud_apis` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `template` text,
  `argument` varchar(255) NOT NULL DEFAULT '',
  `argument_type` varchar(255) NOT NULL DEFAULT '',
  `fields` varchar(255) NOT NULL DEFAULT '',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `category` tinyint(3) NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='aCloudԤϵͳӿб';

DROP TABLE IF EXISTS `pw_acloud_apps`;
CREATE TABLE `pw_acloud_apps` (
  `app_id` char(22) NOT NULL DEFAULT '',
  `app_name` varchar(60) NOT NULL DEFAULT '',
  `app_token` char(128) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`app_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Ӧõվõtoken';

DROP TABLE IF EXISTS `pw_acloud_app_configs`;
CREATE TABLE `pw_acloud_app_configs` (
  `app_id` char(22) NOT NULL DEFAULT '',
  `app_key` varchar(30) NOT NULL DEFAULT '',
  `app_value` text,
  `app_type` tinyint(3) NOT NULL DEFAULT '1',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `app_id` (`app_id`,`app_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ӦԶ';

DROP TABLE IF EXISTS `pw_acloud_extras`;
CREATE TABLE `pw_acloud_extras` (
  `ekey` varchar(100) NOT NULL DEFAULT '',
  `evalue` text,
  `etype` tinyint(3) NOT NULL DEFAULT '1',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ekey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='վƽ̨״̬ͻ';

DROP TABLE IF EXISTS `pw_acloud_keys`;
CREATE TABLE `pw_acloud_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key1` char(128) NOT NULL DEFAULT '',
  `key2` char(128) NOT NULL DEFAULT '',
  `key3` char(128) NOT NULL DEFAULT '',
  `key4` char(128) NOT NULL DEFAULT '',
  `key5` char(128) NOT NULL DEFAULT '',
  `key6` char(128) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='վƽ̨ͨʹõԿ';

DROP TABLE IF EXISTS `pw_acloud_sql_log`;
CREATE TABLE `pw_acloud_sql_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log` text,
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='aCloudִSQL¼־';

DROP TABLE IF EXISTS `pw_acloud_table_settings`;
CREATE TABLE `pw_acloud_table_settings` (
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `category` tinyint(3) NOT NULL DEFAULT '0',
  `primary_key` varchar(20) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ûץȡʱ';

DROP TABLE IF EXISTS `pw_admin_auth`;
CREATE TABLE `pw_admin_auth` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0' COMMENT 'ûID',
  `username` varchar(15) NOT NULL DEFAULT '' COMMENT 'û',
  `roles` varchar(255) NOT NULL DEFAULT '' COMMENT 'ɫ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  PRIMARY KEY (`id`),
  KEY `idx_uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ûȨ޽ɫ';

DROP TABLE IF EXISTS `pw_admin_config`;
CREATE TABLE `pw_admin_config` (
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '',
  `namespace` varchar(15) NOT NULL DEFAULT 'global' COMMENT 'ռ',
  `value` text COMMENT 'ֵ',
  `vtype` enum('string','array','object') NOT NULL DEFAULT 'string' COMMENT 'ֵ',
  `description` text COMMENT 'ý',
  PRIMARY KEY (`namespace`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='վñ';

DROP TABLE IF EXISTS `pw_admin_custom`;
CREATE TABLE `pw_admin_custom` (
  `username` varchar(15) NOT NULL,
  `custom` text COMMENT 'ò˵',
  PRIMARY KEY (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='̨ò˵';

DROP TABLE IF EXISTS `pw_admin_role`;
CREATE TABLE `pw_admin_role` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL DEFAULT '' COMMENT 'ɫ',
  `auths` text COMMENT 'Ȩ޵',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='̨ûɫ';

DROP TABLE IF EXISTS `pw_advertisement`;
CREATE TABLE `pw_advertisement` (
  `pid` int(10) unsigned NOT NULL,
  `identifier` varchar(30) NOT NULL,
  `type_id` tinyint(3) unsigned NOT NULL,
  `width` smallint(6) NOT NULL DEFAULT '0',
  `height` smallint(6) NOT NULL DEFAULT '0',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `schedule` varchar(100) NOT NULL,
  `show_type` tinyint(3) NOT NULL DEFAULT '0',
  `condition` text,
  UNIQUE KEY `pid` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='λݱ';

DROP TABLE IF EXISTS `pw_announce`;
CREATE TABLE `pw_announce` (
  `aid` smallint(6) NOT NULL AUTO_INCREMENT,
  `vieworder` smallint(6) NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `typeid` tinyint(1) NOT NULL DEFAULT '0',
  `url` varchar(80) DEFAULT '',
  `subject` varchar(100) NOT NULL DEFAULT '',
  `content` MEDIUMTEXT,
  `start_date` int(10) unsigned NOT NULL DEFAULT '0',
  `end_date` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`),
  KEY `idx_startdate` (`start_date`),
  KEY `idx_vieworder` (`vieworder`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_application`;
CREATE TABLE `pw_application` (
  `app_id` char(20) NOT NULL DEFAULT '' COMMENT 'Ӧid',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '',
  `alias` varchar(100) NOT NULL DEFAULT '' COMMENT '',
  `logo` varchar(100) NOT NULL DEFAULT '' COMMENT 'Ӧlogo',
  `author_name` varchar(30) NOT NULL DEFAULT '' COMMENT '',
  `author_icon` varchar(100) NOT NULL DEFAULT '' COMMENT 'ͷ',
  `author_email` varchar(200) NOT NULL DEFAULT '' COMMENT 'email',
  `website` varchar(200) NOT NULL DEFAULT '' COMMENT 'վ',
  `version` varchar(50) NOT NULL DEFAULT '' COMMENT 'Ӧð汾',
  `pwversion` varchar(50) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  PRIMARY KEY (`app_id`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ӦϢ';

DROP TABLE IF EXISTS `pw_application_log`;
CREATE TABLE `pw_application_log` (
  `app_id` char(20) NOT NULL DEFAULT '' COMMENT 'Ӧid',
  `log_type` char(10) NOT NULL DEFAULT '' COMMENT '־',
  `data` text COMMENT '־',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  UNIQUE KEY `app_id` (`app_id`,`log_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Ӧðװ־';

DROP TABLE IF EXISTS `pw_app_poll`;
CREATE TABLE `pw_app_poll` (
  `poll_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `voter_num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱ',
  `isafter_view` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'ǷͶƱ鿴',
  `isinclude_img` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'ǷͼƬ',
  `option_limit` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱѡ',
  `regtime_limit` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱעʱ',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱ',
  `app_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱ',
  `expired_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱЧʱ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱʱ',
  PRIMARY KEY (`poll_id`),
  KEY `idx_createduserid_createdtime` (`created_userid`,`created_time`),
  KEY `idx_voternum` (`voter_num`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ͶƱϢ';

DROP TABLE IF EXISTS `pw_app_poll_option`;
CREATE TABLE `pw_app_poll_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ѡID',
  `poll_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱID',
  `voted_num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ѡͶƱ',
  `content` varchar(255) NOT NULL DEFAULT '' COMMENT 'ѡ',
  `image` varchar(255) NOT NULL DEFAULT '' COMMENT 'ѡͼƬ',
  PRIMARY KEY (`option_id`),
  KEY `idx_pollid` (`poll_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ͶƱѡ';

DROP TABLE IF EXISTS `pw_app_poll_thread`;
CREATE TABLE `pw_app_poll_thread` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `poll_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱID',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱ',
  PRIMARY KEY (`tid`),
  KEY `idx_pollid` (`poll_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ͶƱϵ';

DROP TABLE IF EXISTS `pw_app_poll_voter`;
CREATE TABLE `pw_app_poll_voter` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱID',
  `poll_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱѡID',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱʱ',
  KEY `idx_uid_createdtime` (`uid`,`created_time`),
  KEY `idx_pollid` (`poll_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ûͶƱ¼';

DROP TABLE IF EXISTS `pw_attachs`;
CREATE TABLE `pw_attachs` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(80) NOT NULL DEFAULT '' COMMENT 'ļ',
  `type` varchar(15) NOT NULL DEFAULT '' COMMENT 'ļ',
  `size` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ļС',
  `path` varchar(80) NOT NULL DEFAULT '' COMMENT '洢·',
  `ifthumb` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿͼ',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϴûid',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϴʱ',
  `app` varchar(15) NOT NULL DEFAULT '' COMMENT 'Ӧ',
  `app_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ӧģid',
  `descrip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ļ',
  PRIMARY KEY (`aid`),
  KEY `idx_app_appid` (`app`,`app_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_attachs_thread`;
CREATE TABLE `pw_attachs_thread` (
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'id',
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'id',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'id',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ظid',
  `name` varchar(80) NOT NULL DEFAULT '' COMMENT 'ļ',
  `type` varchar(15) NOT NULL DEFAULT '' COMMENT 'ļ',
  `size` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ļС',
  `hits` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `width` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'ͼƬ',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'ͼƬ߶',
  `path` varchar(80) NOT NULL DEFAULT '' COMMENT '洢·',
  `ifthumb` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿͼ',
  `special` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿ',
  `cost` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ܼ۸',
  `ctype` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϴûid',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϴʱ',
  `descrip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ļ',
  PRIMARY KEY (`aid`),
  KEY `idx_createduserid` (`created_userid`),
  KEY `idx_tid_pid` (`tid`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Ӹ';

DROP TABLE IF EXISTS `pw_attachs_thread_buy`;
CREATE TABLE `pw_attachs_thread_buy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `cost` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ctype` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_aid` (`aid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Ӹ¼';

DROP TABLE IF EXISTS `pw_attachs_thread_download`;
CREATE TABLE `pw_attachs_thread_download` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'aid',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `cost` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ѻ',
  `ctype` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'ѻ',
  PRIMARY KEY (`id`),
  KEY `idx_aid` (`aid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Ӹؼ¼' ;

DROP TABLE IF EXISTS `pw_attention`;
CREATE TABLE `pw_attention` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `touid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`touid`,`uid`),
  KEY `idx_uid_createdtime` (`uid`,`created_time`),
  KEY `idx_touid_createdtime` (`touid`,`created_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ע';

DROP TABLE IF EXISTS `pw_attention_fresh`;
CREATE TABLE `pw_attention_fresh` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `src_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_createduserid_createdtime` (`created_userid`,`created_time`),
  KEY `idx_type_srcid` (`type`,`src_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_attention_fresh_index`;
CREATE TABLE `pw_attention_fresh_index` (
  `fresh_id` int(10) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fresh_id`),
  KEY `idx_tid` (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ӹ';

DROP TABLE IF EXISTS `pw_attention_fresh_relations`;
CREATE TABLE `pw_attention_fresh_relations` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `fresh_id` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `idx_uid_createdtime` (`uid`,`created_time`),
  KEY `idx_freshid` (`fresh_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='¹ϵ';

DROP TABLE IF EXISTS `pw_attention_recommend_cron`;
CREATE TABLE `pw_attention_recommend_cron` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûuid',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ʶ˸';

DROP TABLE IF EXISTS `pw_attention_recommend_record`;
CREATE TABLE `pw_attention_recommend_record` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûuid',
  `recommend_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ǳں',
  `same_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͬ',
  UNIQUE KEY `idx_uid_puid_suid` (`uid`,`recommend_uid`,`same_uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ͬע¼';

DROP TABLE IF EXISTS `pw_attention_recommend_friends`;
CREATE TABLE `pw_attention_recommend_friends` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûuid',
  `recommend_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ƼID',
  `recommend_username` varchar(15) NOT NULL DEFAULT '' COMMENT 'Ƽû',
  `cnt` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `recommend_user` text COMMENT 'ƼϢ',
  UNIQUE KEY `idx_uid_recommenduid` (`uid`,`recommend_uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ʶ˻';

DROP TABLE IF EXISTS `pw_attention_type`;
CREATE TABLE `pw_attention_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ע';

DROP TABLE IF EXISTS `pw_attention_type_relations`;
CREATE TABLE `pw_attention_type_relations` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `touid` int(10) unsigned NOT NULL DEFAULT '0',
  `typeid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`,`touid`,`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='עϵ';

DROP TABLE IF EXISTS `pw_bbsinfo`;
CREATE TABLE `pw_bbsinfo` (
  `id` smallint(3) unsigned NOT NULL auto_increment COMMENT 'ID',
  `newmember` varchar(15) NOT NULL default '' COMMENT '»Ա',
  `totalmember` mediumint(8) unsigned NOT NULL default '0' COMMENT 'Ա',
  `higholnum` mediumint(8) unsigned NOT NULL default '0' COMMENT '',
  `higholtime` int(10) unsigned NOT NULL default '0' COMMENT '߷',
  `yposts` mediumint(8) unsigned NOT NULL default '0' COMMENT 'շ',
  `hposts` mediumint(8) unsigned NOT NULL default '0' COMMENT 'շ',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='̳Ϣ';

DROP TABLE IF EXISTS `pw_bbs_forum`;
CREATE TABLE `pw_bbs_forum` (
  `fid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type` enum('category','forum','sub','sub2') NOT NULL DEFAULT 'forum',
  `issub` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hassub` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `descrip` text,
  `vieworder` smallint(5) unsigned NOT NULL DEFAULT '0',
  `across` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `manager` varchar(255) NOT NULL DEFAULT '',
  `uppermanager` varchar(255) NOT NULL DEFAULT '',
  `icon` varchar(100) NOT NULL DEFAULT '',
  `logo` varchar(100) NOT NULL DEFAULT '',
  `fup` varchar(30) NOT NULL DEFAULT '',
  `fupname` varchar(255) NOT NULL DEFAULT '',
  `isshow` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `isshowsub` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `newtime` smallint(5) unsigned NOT NULL DEFAULT '0',
  `password` varchar(32) NOT NULL DEFAULT '',
  `allow_visit` varchar(255) NOT NULL DEFAULT '',
  `allow_read` varchar(255) NOT NULL DEFAULT '',
  `allow_post` varchar(255) NOT NULL DEFAULT '',
  `allow_reply` varchar(255) NOT NULL DEFAULT '',
  `allow_upload` varchar(255) NOT NULL DEFAULT '',
  `allow_download` varchar(255) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_ip` int(10) unsigned NOT NULL DEFAULT '0',
  `style` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`fid`),
  KEY `idx_issub_vieworder` (`issub`,`vieworder`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Ϣ';

DROP TABLE IF EXISTS `pw_bbs_forum_extra`;
CREATE TABLE `pw_bbs_forum_extra` (
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `seo_description` varchar(255) NOT NULL DEFAULT '',
  `seo_keywords` varchar(255) NOT NULL DEFAULT '',
  `settings_basic` text,
  `settings_credit` text,
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='չϢ';

DROP TABLE IF EXISTS `pw_bbs_forum_statistics`;
CREATE TABLE `pw_bbs_forum_statistics` (
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `todayposts` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `todaythreads` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `article` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `posts` int(10) unsigned NOT NULL DEFAULT '0',
  `threads` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `subposts` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `subthreads` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `lastpost_info` char(35) NOT NULL DEFAULT '',
  `lastpost_time` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost_username` varchar(15) NOT NULL DEFAULT '',
  `lastpost_tid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ͳƱ';

DROP TABLE IF EXISTS `pw_bbs_forum_user`;
CREATE TABLE `pw_bbs_forum_user` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `join_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`,`fid`),
  KEY `idx_fid_jointime` (`fid`,`join_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Ա';

DROP TABLE IF EXISTS `pw_bbs_posts`;
CREATE TABLE `pw_bbs_posts` (
  `pid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ischeck` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `ifshield` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `replies` int(10) unsigned NOT NULL DEFAULT '0',
  `useubb` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `usehtml` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `aids` smallint(5) unsigned NOT NULL DEFAULT '0',
  `rpid` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) NOT NULL DEFAULT '',
  `content` text,
  `like_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `sell_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_ip` varchar(40) NOT NULL DEFAULT '',
  `reply_notice` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_username` varchar(15) NOT NULL DEFAULT '',
  `modified_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_ip` varchar(40) NOT NULL DEFAULT '',
  `reminds` varchar(255) NOT NULL DEFAULT '',
  `word_version` smallint(5) unsigned NOT NULL DEFAULT '0',
  `ipfrom` varchar(255) NOT NULL DEFAULT '',
  `manage_remind` varchar(150) NOT NULL DEFAULT '',
  `topped` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `idx_tid_disabled_createdtime` (`tid`,`disabled`,`created_time`),
  KEY `idx_disabled_createdtime` (`disabled`,`created_time`),
  KEY `idx_createduserid_createdtime` ( `created_userid` , `created_time` )
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ӻظ';

DROP TABLE IF EXISTS `pw_bbs_posts_reply`;
CREATE TABLE `pw_bbs_posts_reply` (
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `rpid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `idx_rpid_pid` (`rpid`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ظĻظ';

DROP TABLE IF EXISTS `pw_bbs_posts_topped`;
CREATE TABLE `pw_bbs_posts_topped` (
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'pid',
  `tid` int(10) unsigned NOT NULL COMMENT 'tid',
  `floor` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '¥',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ö',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'öʱ',
  PRIMARY KEY (`pid`),
  KEY `idx_tid_createdtime` (`tid`,`created_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ö';

DROP TABLE IF EXISTS `pw_bbs_specialsort`;
CREATE TABLE `pw_bbs_specialsort` (
  `sort_type` char(16) NOT NULL DEFAULT '',
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `extra` int(10) NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_bbs_threads`;
CREATE TABLE `pw_bbs_threads` (
  `tid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `topic_type` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) NOT NULL DEFAULT '',
  `overtime` int(10) unsigned NOT NULL DEFAULT '0',
  `highlight` varchar(64) NOT NULL DEFAULT '',
  `inspect` varchar(30) NOT NULL DEFAULT '',
  `ifshield` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `digest` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `topped` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ischeck` tinyint(3) NOT NULL DEFAULT '1',
  `replies` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `like_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `special` varchar(20) NOT NULL DEFAULT '0',
  `tpcstatus` int(10) unsigned NOT NULL DEFAULT '0',
  `ifupload` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_ip` varchar(40) NOT NULL DEFAULT '',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_username` varchar(15) NOT NULL DEFAULT '',
  `modified_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_ip` varchar(40) NOT NULL DEFAULT '',
  `lastpost_time` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost_username` varchar(15) NOT NULL DEFAULT '',
  `special_sort` tinyint(4) NOT NULL DEFAULT '0',
  `reply_notice` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `reply_topped` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `thread_status` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `idx_fid_disabled_lastposttime` (`fid`,`disabled`,`lastpost_time`),
  KEY `idx_disabled_createdtime` (`disabled`,`created_time`),
  KEY `idx_createduserid_createdtime` ( `created_userid` , `created_time` )
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ӻϢ';

DROP TABLE IF EXISTS `pw_bbs_threads_buy`;
CREATE TABLE `pw_bbs_threads_buy` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `ctype` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `cost` mediumint(8) unsigned NOT NULL DEFAULT '0',
  KEY `idx_tid_pid_createdtime` (`tid`,`pid`,`created_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ӹ¼';

DROP TABLE IF EXISTS `pw_bbs_threads_cate_index`;
CREATE TABLE `pw_bbs_threads_cate_index` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `cid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `idx_cid_lastposttime` (`cid`,`lastpost_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='-';

DROP TABLE IF EXISTS `pw_bbs_threads_content`;
CREATE TABLE `pw_bbs_threads_content` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `useubb` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `usehtml` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `aids` smallint(5) unsigned NOT NULL DEFAULT '0',
  `content` text,
  `sell_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `reminds` varchar(255) NOT NULL DEFAULT '',
  `word_version` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tags` varchar(255) NOT NULL DEFAULT '',
  `ipfrom` varchar(255) NOT NULL DEFAULT '',
  `manage_remind` varchar(150) NOT NULL DEFAULT '',
  PRIMARY KEY (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ݱ';

DROP TABLE IF EXISTS `pw_bbs_threads_digest_index`;
CREATE TABLE `pw_bbs_threads_digest_index` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `cid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `topic_type` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost_time` int(10) unsigned NOT NULL DEFAULT '0',
  `operator` varchar(15) NOT NULL DEFAULT '',
  `operator_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `operator_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `idx_cid_lastposttime` (`cid`,`lastpost_time`),
  KEY `idx_fid_lastposttime_topictype` (`fid`,`lastpost_time`,`topic_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_bbs_threads_hits`;
CREATE TABLE `pw_bbs_threads_hits` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8  COMMENT='ӵ¼';

DROP TABLE IF EXISTS `pw_bbs_threads_index`;
CREATE TABLE `pw_bbs_threads_index` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `idx_lastposttime` (`lastpost_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='-';

DROP TABLE IF EXISTS `pw_bbs_threads_overtime`;
CREATE TABLE `pw_bbs_threads_overtime` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `m_type` enum('topped','highlight') NOT NULL,
  `overtime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_tid_mtype` (`tid`,`m_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Ӳʱ';

DROP TABLE IF EXISTS `pw_bbs_threads_sort`;
CREATE TABLE `pw_bbs_threads_sort` (
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `extra` int(10) NOT NULL DEFAULT '0' COMMENT 'չֶ,ö123',
  `sort_type` varchar(20) NOT NULL DEFAULT '' COMMENT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`fid`,`tid`),
  KEY `idx_tid` (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_bbs_topic_type`;
CREATE TABLE `pw_bbs_topic_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `fid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `name` varchar(255) NOT NULL COMMENT '',
  `parentid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϼID',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT 'ͼ',
  `vieworder` tinyint(3) NOT NULL DEFAULT '0' COMMENT 'ʾ',
  `issys` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿר(1-,0-)',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_bbs_topped`;
CREATE TABLE `pw_bbs_topped` (
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ö';

DROP TABLE IF EXISTS `pw_cache`;
CREATE TABLE `pw_cache` (
  `cache_key` char(32) NOT NULL COMMENT 'MD5ֵ',
  `cache_value` text COMMENT 'ֵ',
  `cache_expire` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`cache_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_common_config`;
CREATE TABLE `pw_common_config` (
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '',
  `namespace` varchar(15) NOT NULL DEFAULT 'global' COMMENT 'ռ',
  `value` text COMMENT 'ֵ',
  `vtype` enum('string','array','object') NOT NULL DEFAULT 'string' COMMENT 'ֵ',
  `description` text COMMENT 'ý',
  PRIMARY KEY (`namespace`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='վñ';

DROP TABLE IF EXISTS `pw_common_cron`;
CREATE TABLE `pw_common_cron` (
  `cron_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ƻID',
  `subject` varchar(50) NOT NULL DEFAULT '' COMMENT 'ƻ',
  `loop_type` varchar(10) NOT NULL DEFAULT '' COMMENT 'ѭmonth/week/day/hour/now',
  `loop_daytime` varchar(50) NOT NULL DEFAULT '' COMMENT 'ѭʱ䣨-ʱ-֣',
  `cron_file` varchar(50) NOT NULL DEFAULT '' COMMENT 'ƻִļ',
  `isopen` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'Ƿ 0 1ǣ2ϵͳ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ƻ񴴽ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ƻϴִнʱ',
  `next_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'һִʱ',
  PRIMARY KEY (`cron_id`),
  KEY `idx_next_time` (`next_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ƻ';

DROP TABLE IF EXISTS `pw_common_emotion`;
CREATE TABLE `pw_common_emotion` (
  `emotion_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `category_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `emotion_name` varchar(20) NOT NULL DEFAULT '' COMMENT '',
  `emotion_folder` varchar(20) NOT NULL DEFAULT '' COMMENT 'ļ',
  `emotion_icon` varchar(50) NOT NULL DEFAULT '' COMMENT 'ͼ',
  `vieworder` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `isused` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'Ƿʹ',
  PRIMARY KEY (`emotion_id`),
  KEY `idx_catid` (`category_id`),
  KEY `idx_isused` (`isused`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ݱ';

DROP TABLE IF EXISTS `pw_common_emotion_category`;
CREATE TABLE `pw_common_emotion_category` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `category_name` varchar(20) NOT NULL DEFAULT '' COMMENT '',
  `emotion_folder` varchar(20) NOT NULL DEFAULT '' COMMENT 'ļ',
  `emotion_apps` varchar(50) NOT NULL DEFAULT '' COMMENT 'ʹõӦ',
  `orderid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `isopen` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿʹ',
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_common_nav`;
CREATE TABLE `pw_common_nav` (
  `navid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `parentid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϼID',
  `rootid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT '',
  `sign` varchar(32) NOT NULL DEFAULT '' COMMENT 'ǰλʶ',
  `name` char(50) NOT NULL DEFAULT '' COMMENT '',
  `style` char(50) NOT NULL DEFAULT '' COMMENT 'ʽ',
  `link` char(100) NOT NULL DEFAULT '' COMMENT '',
  `alt` char(50) NOT NULL DEFAULT '' COMMENT 'ALTϢ',
  `image` varchar(100) NOT NULL DEFAULT '' COMMENT 'Сͼ',
  `target` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿ´ڴ',
  `isshow` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿʹ',
  `orderid` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '',
  PRIMARY KEY (`navid`),
  KEY `idx_type` (`type`),
  KEY `idx_rootid` (`rootid`),
  KEY `idx_orderid` (`orderid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_common_process`;
CREATE TABLE `pw_common_process` (
  `flag` varchar(20) NOT NULL DEFAULT '' COMMENT '̱',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'û',
  `expired_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`flag`(10),`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='̿Ʊ';

DROP TABLE IF EXISTS `pw_credit_log`;
CREATE TABLE `pw_credit_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ctype` varchar(8) NOT NULL DEFAULT '',
  `affect` int(10) NOT NULL DEFAULT '0',
  `logtype` varchar(40) NOT NULL DEFAULT '',
  `descrip` varchar(255) NOT NULL DEFAULT '',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_createduserid_createdtime` (`created_userid`,`created_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='־';

DROP TABLE IF EXISTS `pw_credit_log_operate`;
CREATE TABLE `pw_credit_log_operate` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `operate` varchar(40) NOT NULL DEFAULT '',
  `num` smallint(5) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`,`operate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ֲ־';

DROP TABLE IF EXISTS `pw_design_bak`;
CREATE TABLE `pw_design_bak` (
  `bak_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `page_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ҳ',
  `is_snapshot` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿ',
  `bak_info` MEDIUMTEXT COMMENT 'Ϣ',
  PRIMARY KEY (`page_id`,`bak_type`,`is_snapshot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Żݱ';

DROP TABLE IF EXISTS `pw_design_image`;
CREATE TABLE `pw_design_image` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `path` varchar(80) NOT NULL DEFAULT '' COMMENT 'ԭͼƬ·',
  `thumb` varchar(80) NOT NULL DEFAULT '' COMMENT 'ͼ·',
  `width` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͼ',
  `height` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͼ',
  `moduleid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ģ',
  `data_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ŻID',
  `sign` varchar(50) NOT NULL DEFAULT '' COMMENT 'ǩkey',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'ԭͼƬ״̬10',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Ż첽ͼƬ';

DROP TABLE IF EXISTS `pw_design_component`;
CREATE TABLE `pw_design_component` (
  `comp_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ԪID',
  `model_flag` varchar(20) NOT NULL DEFAULT '' COMMENT 'Ԫͱʶ',
  `comp_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'ģԪ',
  `comp_tpl` text COMMENT 'ģ',
  `sys_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϵͳ',
  PRIMARY KEY (`comp_id`),
  KEY `idx_modelflag` (`model_flag`(10))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ģԪ';

DROP TABLE IF EXISTS `pw_design_cron`;
CREATE TABLE `pw_design_cron` (
  `module_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ģID',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`module_id`),
  KEY `idx_createdtime` (`created_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Ż¶б';

DROP TABLE IF EXISTS `pw_design_data`;
CREATE TABLE `pw_design_data` (
  `data_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `from_type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Դ',
  `from_app` varchar(20) NOT NULL DEFAULT '' COMMENT 'ԴӦ',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ԴID',
  `module_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ģID',
  `standard` varchar(255) NOT NULL DEFAULT '' COMMENT '׼ǩ',
  `style` varchar(255) NOT NULL DEFAULT '' COMMENT 'ʽ',
  `extend_info` text COMMENT '',
  `data_type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '1Զ 2̶ 3޸',
  `is_edited` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿ޸Ĺ',
  `is_reservation` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'ǷΪԤϢ',
  `vieworder` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `start_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʼʱ',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`data_id`),
  KEY `idx_moduleid` (`module_id`),
  KEY `idx_vieworder` (`vieworder`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ݻ';

DROP TABLE IF EXISTS `pw_design_module`;
CREATE TABLE `pw_design_module` (
  `module_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ģID',
  `page_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ҳID',
  `segment` varchar(50) NOT NULL DEFAULT '' COMMENT 'ģƬ',
  `module_struct` varchar(20) NOT NULL DEFAULT '' COMMENT 'ģṹ',
  `model_flag` varchar(20) NOT NULL DEFAULT '' COMMENT 'ģ',
  `module_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'ģ',
  `module_property` text COMMENT 'ģ',
  `module_title` text COMMENT 'ģ',
  `module_style` text COMMENT 'ģʽ',
  `module_compid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ģԪID',
  `module_tpl` text COMMENT 'ģģ',
  `module_cache` varchar(255) NOT NULL DEFAULT '' COMMENT 'ģ',
  `isused` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿʹ',
  `module_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'ģ 1 ҷ2 3 ̨',
  PRIMARY KEY (`module_id`),
  KEY `idx_pageid` (`page_id`),
  KEY `idx_moduletype` (`module_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ģ';

DROP TABLE IF EXISTS `pw_design_page`;
CREATE TABLE `pw_design_page` (
  `page_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ҳID',
  `page_type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'ҳ',
  `page_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'ҳ',
  `page_router` varchar(50) NOT NULL DEFAULT '' COMMENT 'ҳ·Ϣ',
  `page_unique` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ҳΨһʶ',
  `is_unique` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ψһʶıʶ',
  `module_ids` TEXT  COMMENT 'ҳģ',
  `struct_names` TEXT  COMMENT 'ҳṹ',
  `segments` TEXT COMMENT 'ҳģƬ',
  `design_lock` varchar(50) NOT NULL DEFAULT '' COMMENT '༭',
  PRIMARY KEY (`page_id`),
  KEY `idx_pagerouter` (`page_router`(10))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ҳϢ';

DROP TABLE IF EXISTS `pw_design_permissions`;
CREATE TABLE `pw_design_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'IDʶ',
  `design_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '1ҳ棬2ģ',
  `design_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '͵ıʶID',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `permissions` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ȩ޼',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `idx_designtype_designid_uid` (`design_type`,`design_id`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Ȩޱ';

DROP TABLE IF EXISTS `pw_design_portal`;
CREATE TABLE `pw_design_portal` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ʶID',
  `pagename` varchar(50) NOT NULL DEFAULT '' COMMENT 'ҳ',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'titleϢ',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT 'keywordsϢ',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT 'descriptionϢ',
  `domain` varchar(50) NOT NULL DEFAULT '' COMMENT '',
  `cover` varchar(255) NOT NULL DEFAULT '' COMMENT 'ͼƬ',
  `isopen` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿʹ',
  `header` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿʹùͷ',
  `navigate` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿʹù',
  `footer` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿʹùҳ',
  `template` varchar(50) NOT NULL DEFAULT '' COMMENT 'ʹõģ',
  `style` varchar(255) NOT NULL DEFAULT '' COMMENT 'Զʽ',
  `created_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`id`),
  KEY `idx_domain` (`domain`(10))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ԶҳϢ';

DROP TABLE IF EXISTS `pw_design_push`;
CREATE TABLE `pw_design_push` (
  `push_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `push_from_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ԴID',
  `push_from_model` varchar(20) NOT NULL DEFAULT '' COMMENT 'ԴӦ',
  `module_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ģID',
  `push_standard` varchar(255) NOT NULL DEFAULT '' COMMENT '׼ǩ',
  `push_style` varchar(255) NOT NULL DEFAULT '' COMMENT 'ʽ',
  `push_orderid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `push_extend` text COMMENT '',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `author_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'UID',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '״̬ʾ0 Ҫˣ1',
  `neednotice` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'ǷҪվ',
  `check_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `start_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʼʱ',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `checked_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`push_id`),
  KEY `idx_end_time` (`end_time`),
  KEY `idx_status` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Ϣͱ';

DROP TABLE IF EXISTS `pw_design_script`;
CREATE TABLE `pw_design_script` (
  `module_id` int(10) unsigned NOT NULL COMMENT 'ģID',
  `token` char(10) NOT NULL COMMENT 'ܴ',
  `view_times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ô',
  PRIMARY KEY (`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ģù';

DROP TABLE IF EXISTS `pw_design_segment`;
CREATE TABLE `pw_design_segment` (
  `segment` varchar(50) NOT NULL DEFAULT '' COMMENT 'Ƭ',
  `page_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'ҳID',
  `segment_tpl` MEDIUMTEXT COMMENT 'Ƭδ',
  `segment_struct` MEDIUMTEXT  COMMENT 'Ƭνṹ',
  PRIMARY KEY (`segment`,`page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ŻƬα';

DROP TABLE IF EXISTS `pw_design_shield`;
CREATE TABLE `pw_design_shield` (
  `shield_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ʶID',
  `from_app` varchar(20) NOT NULL DEFAULT '' COMMENT 'ԴӦ',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ԴID',
  `module_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'εģ',
  `shield_title` varchar(255) NOT NULL DEFAULT '',
  `shield_url` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`shield_id`),
  KEY `idx_formid_formapp` (`from_id`,`from_app`(5))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Żģα';

DROP TABLE IF EXISTS `pw_design_structure`;
CREATE TABLE `pw_design_structure` (
  `struct_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'ṹ',
  `struct_title` text COMMENT 'ṹ',
  `struct_style` text COMMENT 'ṹʽ',
 `segment` varchar(50) NOT NULL DEFAULT '' COMMENT 'ṹƬ',
  PRIMARY KEY (`struct_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ṹݱ';

DROP TABLE IF EXISTS `pw_domain`;
CREATE TABLE `pw_domain` (
  `domain_key` varchar(100) NOT NULL DEFAULT '' COMMENT 'ʶ',
  `domain_type` varchar(15) NOT NULL DEFAULT '' COMMENT '',
  `domain` varchar(15) NOT NULL DEFAULT '' COMMENT '',
  `root` varchar(45) NOT NULL DEFAULT '' COMMENT '',
  `first` char(1) NOT NULL DEFAULT '' COMMENT 'ĸڸ',
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ӧõidֵ',
  PRIMARY KEY (`domain_key`),
  KEY `idx_domaintype` (`domain_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_draft`;
CREATE TABLE `pw_draft` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ݸid',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '',
  `content` text COMMENT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`id`),
  KEY `idx_uid` (`created_userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ݸ';

DROP TABLE IF EXISTS `pw_frag_template`;
CREATE TABLE `pw_frag_template` (
  `tpl_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `frag_cid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tpl_name` varchar(50) NOT NULL DEFAULT '',
  `template` text,
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_hook`;
CREATE TABLE `pw_hook` (
  `name` varchar(50) NOT NULL DEFAULT '',
  `app_id` char(20) NOT NULL DEFAULT '' COMMENT 'Ӧid',
  `app_name` varchar(100) NOT NULL DEFAULT '' COMMENT 'Ӧ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  `document` text COMMENT 'ϸϢ',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ӻϢ';

DROP TABLE IF EXISTS `pw_hook_inject`;
CREATE TABLE `pw_hook_inject` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` char(20) NOT NULL DEFAULT '',
  `app_name` varchar(100) NOT NULL DEFAULT '',
  `hook_name` varchar(100) NOT NULL DEFAULT '' COMMENT '',
  `alias` varchar(100) NOT NULL DEFAULT '' COMMENT 'ر',
  `class` varchar(100) NOT NULL DEFAULT '' COMMENT '',
  `method` varchar(100) NOT NULL DEFAULT '' COMMENT '÷',
  `loadway` varchar(20) NOT NULL DEFAULT '' COMMENT '뷽ʽ',
  `expression` varchar(100) NOT NULL DEFAULT '' COMMENT 'ʽ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_hook_name` (`hook_name`,`alias`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ӹط';

DROP TABLE IF EXISTS `pw_invite_code`;
CREATE TABLE `pw_invite_code` (
  `code` char(32) NOT NULL DEFAULT '',
  `created_userid` int(10) NOT NULL DEFAULT '0',
  `invited_userid` int(10) NOT NULL DEFAULT '0',
  `ifused` tinyint(1) NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`code`),
  KEY `idx_createduid` (`created_userid`),
  KEY `idx_inviteduid` (`invited_userid`),
  KEY `idx_createdtime` (`created_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='¼';

DROP TABLE IF EXISTS `pw_like_content`;
CREATE TABLE `pw_like_content` (
  `likeid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ϲID',
  `typeid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϲԴ',
  `fromid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ԴID',
  `isspecial` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿ',
  `users` varchar(255) NOT NULL DEFAULT '' COMMENT 'ϲûID',
  `reply_pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '»ظID',
  PRIMARY KEY (`likeid`),
  KEY `idx_isspecial` (`isspecial`),
  KEY `idx_typeid_fromid` (`typeid`,`fromid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ϲݱ';

DROP TABLE IF EXISTS `pw_like_log`;
CREATE TABLE `pw_like_log` (
  `logid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ʶID',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `likeid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϲID',
  `tagids` varchar(50) NOT NULL DEFAULT '' COMMENT 'ǩID',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`logid`),
  KEY `idx_uid` (`uid`),
  KEY `idx_created_time` (`created_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ϲ¼';

DROP TABLE IF EXISTS `pw_like_source`;
CREATE TABLE `pw_like_source` (
  `sid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ʶID',
  `subject` varchar(250) NOT NULL DEFAULT '' COMMENT '',
  `sourceUrl` varchar(50) NOT NULL DEFAULT '' COMMENT 'ԴURL',
  `fromApp` varchar(20) NOT NULL DEFAULT '' COMMENT 'ԴӦ',
  `fromid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ԴID',
  `like_count` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ϲͳ',
  PRIMARY KEY (`sid`),
  KEY `idx_fromid` (`fromid`,`fromApp`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ϲappԴ';

DROP TABLE IF EXISTS `pw_like_statistics`;
CREATE TABLE `pw_like_statistics` (
  `signkey` varchar(20) NOT NULL COMMENT 'ʶkey',
  `likeid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϲID',
  `typeid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `fromid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ԴID',
  `number` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  KEY `idx_number` (`number`),
  KEY `idx_signkey` (`signkey`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ϲ̬ݱ';

DROP TABLE IF EXISTS `pw_like_tag`;
CREATE TABLE `pw_like_tag` (
  `tagid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ǩID',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `tagname` varchar(20) NOT NULL COMMENT 'ǩ',
  `number` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͳ',
  PRIMARY KEY (`tagid`),
  KEY `idx_uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ϲ';

DROP TABLE IF EXISTS `pw_like_tag_relations`;
CREATE TABLE `pw_like_tag_relations` (
  `logid` int(10) unsigned NOT NULL COMMENT 'logʶID',
  `tagid` int(10) unsigned NOT NULL COMMENT 'ǩID',
  KEY `idx_logid` (`logid`),
  KEY `idx_tagid` (`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ϲ-ϲϵ';

DROP TABLE IF EXISTS `pw_link`;
CREATE TABLE `pw_link` (
  `lid` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `vieworder` tinyint(3) NOT NULL DEFAULT '0' COMMENT '',
  `name` varchar(15) NOT NULL DEFAULT '' COMMENT '',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  `descrip` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  `logo` varchar(100) NOT NULL DEFAULT '' COMMENT 'logo',
  `iflogo` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿlogo',
  `ifcheck` tinyint(3) NOT NULL DEFAULT '0' COMMENT 'Ƿ',
  `contact` varchar(100) NOT NULL DEFAULT '' COMMENT 'ϵʽ',
  PRIMARY KEY (`lid`),
  KEY `idx_ifcheck_vieworder` (`ifcheck`,`vieworder`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ӱ';

DROP TABLE IF EXISTS `pw_link_relations`;
CREATE TABLE `pw_link_relations` (
  `lid` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'id',
  PRIMARY KEY (`lid`,`typeid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ӷϵ';

DROP TABLE IF EXISTS `pw_link_type`;
CREATE TABLE `pw_link_type` (
  `typeid` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ӷID',
  `typename` varchar(6) NOT NULL DEFAULT '' COMMENT '',
  `vieworder` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '˳',
  PRIMARY KEY (`typeid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ӷ';

DROP TABLE IF EXISTS `pw_log`;
CREATE TABLE `pw_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `typeid` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'ID',
  `created_userid` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'UID',
  `created_time` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ʱ',
  `created_username` varchar(15) NOT NULL DEFAULT '' COMMENT '',
  `operated_uid` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'UID',
  `operated_username` varchar(15) NOT NULL DEFAULT '' COMMENT '',
  `ip` varchar(40) NOT NULL DEFAULT '' COMMENT 'IP',
  `fid` smallint(6) unsigned NOT NULL DEFAULT 0 COMMENT 'ID',
  `tid` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ID',
  `pid` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ӻظID',
  `extends` varchar(100) NOT NULL DEFAULT '' COMMENT 'չϢ',
  `content` text COMMENT '־',
  PRIMARY KEY (`id`),
  KEY `idx_tid_pid` (`tid`, `pid`),
  KEY `idx_fid` (`fid`),
  KEY `idx_created_time` (`created_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ǰ̨־';

DROP TABLE IF EXISTS `pw_log_login`;
CREATE TABLE `pw_log_login` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `uid` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ûID',
  `username` varchar(15) NOT NULL DEFAULT '' COMMENT 'û',
  `typeid` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ʱ',
  `ip` varchar(40) NOT NULL DEFAULT '' COMMENT 'IP',
  PRIMARY KEY (`id`),
  KEY `idx_username` (`username`),
  KEY `idx_ip` (`ip`),
  KEY `idx_created_time` (`created_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ǰ̨û¼־';

DROP TABLE IF EXISTS `pw_medal_info`;
CREATE TABLE `pw_medal_info` (
  `medal_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ѫID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT 'ѫ',
  `path` varchar(50) NOT NULL DEFAULT '' COMMENT 'ѫ·',
  `image` varchar(50) NOT NULL DEFAULT '' COMMENT 'ѫͼƬ(ϵͳѫ´·)',
  `icon` varchar(50) NOT NULL DEFAULT '' COMMENT 'ѫͼ(ϵͳѫ´·)',
  `descrip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ѫ¼',
  `medal_type` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'ѫ',
  `receive_type` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'ѫ»ȡ',
  `medal_gids` varchar(50) NOT NULL DEFAULT '' COMMENT 'û',
  `award_type` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'ѫ',
  `award_condition` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'ѫ',
  `expired_days` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Ч',
  `isopen` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'Ƿ',
  `vieworder` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '',
  PRIMARY KEY (`medal_id`),
  KEY `idx_orderid` (`vieworder`),
  KEY `idx_isopen` (`isopen`),
  KEY `idx_award_type` (`award_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ѫϢ';

DROP TABLE IF EXISTS `pw_medal_log`;
CREATE TABLE `pw_medal_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ѫ¼¼ID',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `medal_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ѫID',
  `award_status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'ѫ״̬1,23ȡ4,ʾ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `expired_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `log_order` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'ûѫ',
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `idx_uid_medalid` (`uid`,`medal_id`),
  KEY `idx_expired_time` (`expired_time`),
  KEY `idx_log_order` (`log_order`),
  KEY `idx_awardstatus` (`award_status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ѫ¼¼';

DROP TABLE IF EXISTS `pw_medal_user`;
CREATE TABLE `pw_medal_user` (
  `uid` int(10) unsigned NOT NULL COMMENT 'ûID',
  `medals` varchar(255) NOT NULL DEFAULT '' COMMENT 'ӵеѫID',
  `counts` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ѫ',
  `expired_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ĺʱ',
  PRIMARY KEY (`uid`),
  KEY `idx_counts` (`counts`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ѫû-ͳƱ';

DROP TABLE IF EXISTS `pw_message_config`;
CREATE TABLE `pw_message_config` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûuid',
  `privacy` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'ע˲ܷ˽',
  `notice_types` varchar(255) NOT NULL DEFAULT '' COMMENT '֪ͨ',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Ϣûñ';

DROP TABLE IF EXISTS `pw_message_notices`;
CREATE TABLE `pw_message_notices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '֪ͨid',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûuid',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'id',
  `param` int(10) NOT NULL DEFAULT '0' COMMENT 'Ӧid',
  `is_read` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'ǷѶ',
  `is_ignore` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿ',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  `extend_params` text COMMENT 'չ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  PRIMARY KEY (`id`),
  KEY `idx_uid_read_modifiedtime` (`uid`,`is_read`,`modified_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='֪ͨ';

DROP TABLE IF EXISTS `pw_online_guest`;
CREATE TABLE `pw_online_guest` (
  `ip` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûIP',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modify_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `fid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `request` char(50) NOT NULL DEFAULT '' COMMENT 'ǰϢ',
  PRIMARY KEY (`ip`,`created_time`),
  KEY `idx_fid` (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='-οͱ';

DROP TABLE IF EXISTS `pw_online_statistics`;
CREATE TABLE `pw_online_statistics` (
  `signkey` char(20) NOT NULL DEFAULT '' COMMENT 'ͳƱʶ',
  `number` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͳ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`signkey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='-ͳƱ';

DROP TABLE IF EXISTS `pw_online_user`;
CREATE TABLE `pw_online_user` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `username` char(15) NOT NULL DEFAULT '' COMMENT 'û',
  `modify_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `gid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'û',
  `fid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `request` char(50) NOT NULL DEFAULT '' COMMENT 'ǰϢ',
  PRIMARY KEY (`uid`),
  KEY `idx_fid` (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='-û';

DROP TABLE IF EXISTS `pw_pay_order`;
CREATE TABLE `pw_pay_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_no` char(30) NOT NULL DEFAULT '',
  `price` decimal(8,2) NOT NULL DEFAULT '0.00',
  `number` smallint(5) unsigned NOT NULL DEFAULT '0',
  `state` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `payemail` varchar(60) NOT NULL DEFAULT '',
  `paymethod` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `paytype` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `buy` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `extra_1` int(10) unsigned NOT NULL DEFAULT '0',
  `extra_2` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_orderno` (`order_no`),
  KEY `idx_createduserid` (`created_userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='֧';

DROP TABLE IF EXISTS `pw_recycle_reply`;
CREATE TABLE `pw_recycle_reply` (
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` int(10) unsigned NOT NULL DEFAULT '0',
  `operate_time` int(10) unsigned NOT NULL DEFAULT '0',
  `operate_username` varchar(15) NOT NULL,
  `reason` text,
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ظվ';

DROP TABLE IF EXISTS `pw_recycle_topic`;
CREATE TABLE `pw_recycle_topic` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `operate_time` int(10) unsigned NOT NULL DEFAULT '0',
  `operate_username` varchar(15) NOT NULL,
  `reason` text,
  PRIMARY KEY (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='վ';

DROP TABLE IF EXISTS `pw_remind`;
CREATE TABLE `pw_remind` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûuid',
  `touid` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='@ѱ';

DROP TABLE IF EXISTS `pw_report`;
CREATE TABLE `pw_report` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ٱid',
  `type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'ٱ',
  `type_id` int(10) NOT NULL DEFAULT '0' COMMENT 'ٱӦid',
  `content` varchar(100) NOT NULL DEFAULT '' COMMENT '',
  `content_url` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  `author_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ٱ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ٱʱ',
  `reason` varchar(255) NOT NULL DEFAULT '' COMMENT 'ԭ',
  `ifcheck` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿ',
  `operate_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ٱ',
  `operate_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ٱʱ',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ٱ';

DROP TABLE IF EXISTS `pw_seo`;
CREATE TABLE `pw_seo` (
  `mod` varchar(15) NOT NULL DEFAULT '' COMMENT 'ģ',
  `page` varchar(20) NOT NULL DEFAULT '' COMMENT 'ҳ',
  `param` varchar(20) NOT NULL DEFAULT '' COMMENT '',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT 'ؼ',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  PRIMARY KEY (`mod`,`page`,`param`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='seo';

DROP TABLE IF EXISTS `pw_space`;
CREATE TABLE `pw_space` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `space_name` varchar(50) NOT NULL DEFAULT '' COMMENT 'ռ',
  `space_descrip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ռ',
  `space_domain` varchar(20) NOT NULL DEFAULT '' COMMENT '',
  `space_style` varchar(20) NOT NULL DEFAULT '' COMMENT 'ռ',
  `back_image` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  `visit_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͳ',
  `visitors` TEXT  COMMENT '',
  `tovisitors` TEXT  COMMENT 'ҵķʼ¼',
  `space_privacy` tinyint(4) NOT NULL DEFAULT '0' COMMENT '˽ȼ',
  PRIMARY KEY (`uid`),
  KEY `idx_space_domain` (`space_domain`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='˿ռϢ';

DROP TABLE IF EXISTS `pw_space_domain`;
CREATE TABLE `pw_space_domain` (
  `domain` varchar(15) NOT NULL DEFAULT '' COMMENT 'ռ',
  `uid` INT(10) NOT NULL DEFAULT 0 COMMENT 'ûid',
  PRIMARY KEY  (`domain`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT = 'ռ';

DROP TABLE IF EXISTS `pw_style`;
CREATE TABLE `pw_style` (
  `app_id` char(20) NOT NULL DEFAULT '',
  `iscurrent` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'ǷĬ',
  `style_type` char(10) NOT NULL DEFAULT '' COMMENT '',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '',
  `alias` varchar(100) NOT NULL DEFAULT '' COMMENT 'Ӧñ',
  `logo` varchar(100) NOT NULL DEFAULT '' COMMENT 'ͼ',
  `author_name` varchar(30) NOT NULL DEFAULT '' COMMENT '',
  `author_icon` varchar(100) NOT NULL DEFAULT '' COMMENT 'ͷ',
  `author_email` varchar(200) NOT NULL DEFAULT '' COMMENT 'email',
  `website` varchar(200) NOT NULL DEFAULT '' COMMENT 'վ',
  `version` varchar(50) NOT NULL DEFAULT '' COMMENT 'Ӧð汾',
  `pwversion` varchar(50) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  PRIMARY KEY (`app_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_tag`;
CREATE TABLE `pw_tag` (
  `tag_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `parent_tag_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϼid',
  `tag_name` char(60) NOT NULL DEFAULT '' COMMENT '',
  `tag_logo` varchar(255) NOT NULL DEFAULT '' COMMENT 'logo',
  `ifhot` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '',
  `excerpt` varchar(255) NOT NULL DEFAULT '' COMMENT 'ժҪ',
  `content_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `attention_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ע',
  `hits` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `iflogo` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿlogo',
  `seo_title` varchar(255) NOT NULL DEFAULT '' COMMENT 'seo',
  `seo_description` varchar(255) NOT NULL DEFAULT '' COMMENT 'seo',
  `seo_keywords` varchar(255) NOT NULL DEFAULT '' COMMENT 'seoؼ',
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `idx_tagname` (`tag_name`),
  KEY `idx_parenttagid` (`parent_tag_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_tag_attention`;
CREATE TABLE `pw_tag_attention` (
  `uid` int(10) unsigned NOT NULL COMMENT 'ûuid',
  `tag_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'id',
  `last_read_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'עʱ',
  PRIMARY KEY (`tag_id`,`uid`),
  KEY `idx_uid_lastreadtime` (`uid`,`last_read_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ע';

DROP TABLE IF EXISTS `pw_tag_category`;
CREATE TABLE `pw_tag_category` (
  `category_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `category_name` char(20) NOT NULL DEFAULT '' COMMENT '',
  `alias` varchar(15) NOT NULL DEFAULT '' COMMENT '',
  `vieworder` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '˳',
  `tag_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `seo_title` varchar(255) NOT NULL DEFAULT '' COMMENT 'seo',
  `seo_description` varchar(255) NOT NULL DEFAULT '' COMMENT 'seo',
  `seo_keywords` varchar(255) NOT NULL DEFAULT '' COMMENT 'seoؼ',
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_tag_category_relation`;
CREATE TABLE `pw_tag_category_relation` (
  `tag_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'id',
  `category_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'id',
  PRIMARY KEY (`category_id`,`tag_id`),
  KEY `idx_tagid` (`tag_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ϵ';

DROP TABLE IF EXISTS `pw_tag_record`;
CREATE TABLE `pw_tag_record` (
  `tag_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'id',
  `is_reply` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿظ',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  KEY `idx_tagid` (`tag_id`),
  KEY `idx_updatetime` (`update_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ͳƱ';

DROP TABLE IF EXISTS `pw_tag_relation`;
CREATE TABLE `pw_tag_relation` (
  `tag_id` int(10) unsigned NOT NULL COMMENT 'id',
  `content_tag_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'id',
  `type_id` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Ӧ÷id',
  `param_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ӧid',
  `ifcheck` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'Ƿ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`type_id`,`param_id`,`content_tag_id`),
  KEY `idx_tagid_typeid` (`tag_id`,`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ݹϵ';

DROP TABLE IF EXISTS `pw_task`;
CREATE TABLE `pw_task` (
  `taskid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `pre_task` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ǰID',
  `is_auto` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ǷԶʶ',
  `is_display_all` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿʾû',
  `view_order` smallint(6) NOT NULL DEFAULT '0' COMMENT '˳',
  `is_open` tinyint(3) NOT NULL DEFAULT '0' COMMENT 'Ƿ״̬',
  `start_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʼʱ',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `period` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Ƿ',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  `icon` varchar(200) NOT NULL DEFAULT '' COMMENT 'ͼ·',
  `user_groups` varchar(255) NOT NULL DEFAULT '-1' COMMENT 'û',
  `reward` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  `conditions` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  PRIMARY KEY (`taskid`),
  KEY `idx_pretask` (`pre_task`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_task_cache`;
CREATE TABLE `pw_task_cache` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `task_ids` varchar(200) NOT NULL DEFAULT '' COMMENT 'ûID¼ID¼',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='񻺴';

DROP TABLE IF EXISTS `pw_task_group`;
CREATE TABLE `pw_task_group` (
  `taskid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `gid` int(10) NOT NULL DEFAULT '0' COMMENT 'ûID',
  `is_auto` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿ',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`gid`,`taskid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='';

DROP TABLE IF EXISTS `pw_task_user`;
CREATE TABLE `pw_task_user` (
  `taskid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `task_status` tinyint(3) NOT NULL DEFAULT '0' COMMENT '״̬',
  `is_period` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿ',
  `step` varchar(100) NOT NULL DEFAULT '' COMMENT 'ɵĽϢ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `finish_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`uid`,`taskid`),
  KEY `idx_uid_taskstatus` (`uid`,`task_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='û';

DROP TABLE IF EXISTS `pw_user`;
CREATE TABLE `pw_user` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `username` varchar(15) NOT NULL DEFAULT '' COMMENT 'û',
  `email` varchar(40) NOT NULL DEFAULT '' COMMENT 'Emailַ',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '',
  `status` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '״̬',
  `groupid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ǰûID',
  `memberid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ԱID',
  `regdate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'עʱ',
  `realname` varchar(50) NOT NULL DEFAULT '' COMMENT 'ʵ',
  `groups` varchar(255) NOT NULL DEFAULT '' COMMENT 'ûIDֶ',
  PRIMARY KEY (`uid`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='û';

DROP TABLE IF EXISTS `pw_user_active_code`;
CREATE TABLE `pw_user_active_code` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `email` varchar(80) NOT NULL DEFAULT '' COMMENT 'Emailַ',
  `code` varchar(10) NOT NULL DEFAULT '' COMMENT '',
  `send_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `active_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `typeid` tinyint(1) NOT NULL DEFAULT '0' COMMENT '-ע伤һ',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='û伤';

DROP TABLE IF EXISTS `pw_user_ban`;
CREATE TABLE `pw_user_ban` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `typeid` char(20) NOT NULL DEFAULT '' COMMENT '',
  `fid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID---δ',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ִID',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʼʱ',
  `reason` varchar(80) NOT NULL DEFAULT '' COMMENT 'ԭ',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_uid_typeid_fid` (`uid`,`typeid`,`fid`),
  KEY `idx_createdUid` (`created_userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ûֹ¼';

DROP TABLE IF EXISTS `pw_user_behavior`;
CREATE TABLE `pw_user_behavior` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUID',
  `behavior` char(20) NOT NULL DEFAULT '' COMMENT 'Ϊʶ',
  `number` int(10) NOT NULL DEFAULT '0' COMMENT 'Ϊͳ',
  `expired_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `extend_info` varchar(255) NOT NULL DEFAULT '' COMMENT 'Ϣ',
  PRIMARY KEY (`uid`,`behavior`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ûΪͳƱ';

DROP TABLE IF EXISTS `pw_user_belong`;
CREATE TABLE `pw_user_belong` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `gid` mediumint(8) NOT NULL DEFAULT '0' COMMENT 'ûID',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ч',
  UNIQUE KEY `idx_uid_gid` (`uid`,`gid`),
  KEY `idx_gid` (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ûû';

DROP TABLE IF EXISTS `pw_user_data`;
CREATE TABLE `pw_user_data` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `lastvisit` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `lastloginip` varchar(20) NOT NULL DEFAULT '' COMMENT '¼IP',
  `lastpost` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `lastactivetime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `onlinetime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `trypwd` varchar(16) NOT NULL DEFAULT '' COMMENT 'Եĵ¼Ϣtrydate|trynum',
  `postcheck` varchar(16) NOT NULL DEFAULT '' COMMENT '',
  `postnum` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `digest` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `todaypost` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '췢',
  `todayupload` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ϴ',
  `findpwd` varchar(26) NOT NULL DEFAULT '' COMMENT 'һ볢Դ,trydate|trynum',
  `follows` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ע',
  `fans` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '˿',
  `message_tone` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'ǷϢ',
  `messages` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '˽',
  `notices` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Ϣ',
  `likes` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϲ',
  `punch` varchar(200) NOT NULL DEFAULT '' COMMENT '',
  `credit1` int(10) NOT NULL DEFAULT '0' COMMENT 'ֶ1',
  `credit2` int(10) NOT NULL DEFAULT '0' COMMENT 'ֶ2',
  `credit3` int(10) NOT NULL DEFAULT '0' COMMENT 'ֶ3',
  `credit4` int(10) NOT NULL DEFAULT '0' COMMENT 'ֶ4',
  `credit5` int(10) NOT NULL DEFAULT '0',
  `credit6` int(10) NOT NULL DEFAULT '0',
  `credit7` int(10) NOT NULL DEFAULT '0',
  `credit8` int(10) NOT NULL DEFAULT '0',
  `join_forum` varchar(255) NOT NULL DEFAULT '' COMMENT 'İ',
  `recommend_friend` varchar(255) NOT NULL DEFAULT '' COMMENT 'Ƽ',
  `last_credit_affect_log` varchar(255) NOT NULL DEFAULT '' COMMENT 'ֱ䶯',
  `medal_ids` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ûչݱ';

DROP TABLE IF EXISTS `pw_user_education`;
CREATE TABLE `pw_user_education` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `schoolid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ѧУID',
  `degree` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT 'ѧID',
  `start_time` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`id`),
  KEY `idx_uid_startTime` (`uid`,`start_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ûϢ';

DROP TABLE IF EXISTS `pw_user_groups`;
CREATE TABLE `pw_user_groups` (
  `gid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ûID',
  `name` varchar(64) NOT NULL DEFAULT '' COMMENT 'û',
  `type` enum('default','member','system','special','vip') NOT NULL COMMENT 'û',
  `image` varchar(32) NOT NULL DEFAULT '' COMMENT 'ûͼ',
  `points` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûҪĵ',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='û';

DROP TABLE IF EXISTS `pw_user_info`;
CREATE TABLE `pw_user_info` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `gender` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ա',
  `byear` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `bmonth` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '·',
  `bday` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `location` int(10) NOT NULL DEFAULT '0' COMMENT 'סID',
  `location_text` varchar(100) NOT NULL DEFAULT '',
  `hometown` int(10) NOT NULL DEFAULT '0' COMMENT 'ͥID',
  `hometown_text` varchar(100) NOT NULL DEFAULT '',
  `homepage` varchar(75) NOT NULL DEFAULT '' COMMENT 'ҳ',
  `qq` varchar(12) NOT NULL DEFAULT '' COMMENT 'QQ ',
  `msn` varchar(40) NOT NULL DEFAULT '' COMMENT 'MSN',
  `aliww` varchar(30) NOT NULL DEFAULT '' COMMENT '',
  `mobile` varchar(16) NOT NULL DEFAULT '' COMMENT 'ֻ',
  `alipay` varchar(30) NOT NULL DEFAULT '' COMMENT '֧ʺ',
  `bbs_sign` text COMMENT 'ǩ',
  `profile` text COMMENT '˼',
  `regreason` varchar(200) NOT NULL DEFAULT '' COMMENT 'עԭ',
  `telphone` varchar(20) NOT NULL DEFAULT '' COMMENT '绰',
  `address` varchar(100) NOT NULL DEFAULT '' COMMENT 'ʼĵַ',
  `zipcode` varchar(10) NOT NULL DEFAULT '' COMMENT '',
  `secret` varchar(500) NOT NULL DEFAULT '' COMMENT '˽',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ûչϢ';

DROP TABLE IF EXISTS `pw_user_login_ip_recode`;
CREATE TABLE `pw_user_login_ip_recode` (
  `ip` varchar(20) NOT NULL DEFAULT '' COMMENT 'IPַ',
  `last_time` varchar(10) NOT NULL DEFAULT '' COMMENT 'ʱ',
  `error_count` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '',
  PRIMARY KEY (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ûIP¼¼-ûIP¼';

DROP TABLE IF EXISTS `pw_user_mobile`;
CREATE TABLE `pw_user_mobile` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûuid',
  `mobile` bigint(11) unsigned NOT NULL DEFAULT '0' COMMENT 'ûֻ',
  PRIMARY KEY (`uid`),
  UNIQUE KEY `idx_mobile` (`mobile`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ûֻ֤';

DROP TABLE IF EXISTS `pw_user_mobile_verify`;
CREATE TABLE `pw_user_mobile_verify` (
  `mobile` bigint(11) unsigned NOT NULL DEFAULT '0' COMMENT 'ûֻ',
  `code` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '֤',
  `expired_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `number` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`mobile`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ûֻ֤';

DROP TABLE IF EXISTS `pw_user_permission_groups`;
CREATE TABLE `pw_user_permission_groups` (
  `gid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `rkey` varchar(64) NOT NULL DEFAULT '' COMMENT 'Ȩ޵',
  `rtype` enum('basic','system','systemforum') NOT NULL DEFAULT 'basic' COMMENT 'Ȩ',
  `rvalue` text COMMENT 'Ȩֵ',
  `vtype` enum('string','array') NOT NULL DEFAULT 'string' COMMENT 'Ȩֵ',
  PRIMARY KEY (`gid`,`rkey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ûȨޱ';

DROP TABLE IF EXISTS `pw_user_register_check`;
CREATE TABLE `pw_user_register_check` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `ifchecked` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'ǷѾ',
  `ifactived` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'ǷѾ',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ûע˼¼';

DROP TABLE IF EXISTS `pw_user_register_ip`;
CREATE TABLE `pw_user_register_ip` (
  `ip` varchar(20) NOT NULL DEFAULT '' COMMENT 'IPַ',
  `last_regdate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'עʱ',
  `num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  PRIMARY KEY (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='¼IPͳƱ';

DROP TABLE IF EXISTS `pw_user_tag`;
CREATE TABLE `pw_user_tag` (
  `tag_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ԱǩID',
  `name` varchar(20) NOT NULL DEFAULT '' COMMENT 'Աǩ',
  `ifhot` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿűǩ',
  `used_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʹô',
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `idx_name` (`name`),
  KEY `idx_usedcount` (`used_count`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='û˱ǩϢ';

DROP TABLE IF EXISTS `pw_user_tag_relation`;
CREATE TABLE `pw_user_tag_relation` (
  `tag_id` int(10) unsigned NOT NULL COMMENT 'ԱǩID',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`uid`,`tag_id`),
  KEY `idx_createdtime` (`created_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='û˱ǩûĹϵ';

DROP TABLE IF EXISTS `pw_user_work`;
CREATE TABLE `pw_user_work` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûID',
  `company` varchar(100) NOT NULL DEFAULT '' COMMENT '˾',
  `starty` smallint(4) NOT NULL DEFAULT '0' COMMENT 'ʼ',
  `endy` smallint(4) NOT NULL DEFAULT '0' COMMENT '',
  `startm` tinyint(2) NOT NULL DEFAULT '0' COMMENT 'ʼ·',
  `endm` tinyint(2) NOT NULL DEFAULT '0' COMMENT '·',
  PRIMARY KEY (`id`),
  KEY `idx_uid_starty_startm` (`uid`,`starty`,`startm`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='û';

DROP TABLE IF EXISTS `pw_upgrade_log`;
CREATE TABLE `pw_upgrade_log` (
  `id` varchar(25) NOT NULL DEFAULT '' COMMENT 'id',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '־',
  `data` text COMMENT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='־';

DROP TABLE IF EXISTS `pw_weibo`;
CREATE TABLE `pw_weibo` (
  `weibo_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `src_id` int(10) unsigned NOT NULL DEFAULT '0',
  `content` text,
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `comments` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `extra` text,
  `like_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`weibo_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='΢';

DROP TABLE IF EXISTS `pw_weibo_comment`;
CREATE TABLE `pw_weibo_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `weibo_id` int(10) unsigned NOT NULL DEFAULT '0',
  `content` text,
  `extra` text,
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_id`),
  KEY `idx_weiboid_createdtime` (`weibo_id`,`created_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='΢۱';

DROP TABLE IF EXISTS `pw_windid_application`;
CREATE TABLE `pw_windid_application` (
  `app_id` char(20) NOT NULL DEFAULT '' COMMENT 'Ӧid',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '',
  `alias` varchar(100) NOT NULL DEFAULT '' COMMENT '',
  `logo` varchar(100) NOT NULL DEFAULT '' COMMENT 'Ӧlogo',
  `author_name` varchar(30) NOT NULL DEFAULT '' COMMENT '',
  `author_icon` varchar(100) NOT NULL DEFAULT '' COMMENT 'ͷ',
  `author_email` varchar(200) NOT NULL DEFAULT '' COMMENT 'email',
  `website` varchar(200) NOT NULL DEFAULT '' COMMENT 'վ',
  `version` varchar(50) NOT NULL DEFAULT '' COMMENT 'Ӧð汾',
  `pwversion` varchar(50) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  PRIMARY KEY (`app_id`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ӦϢ';

DROP TABLE IF EXISTS `pw_windid_application_log`;
CREATE TABLE `pw_windid_application_log` (
  `app_id` char(20) NOT NULL DEFAULT '' COMMENT 'Ӧid',
  `log_type` char(10) NOT NULL DEFAULT '' COMMENT '־',
  `data` text COMMENT '־',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  UNIQUE KEY `app_id` (`app_id`,`log_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Ӧðװ־';

DROP TABLE IF EXISTS `pw_windid_hook`;
CREATE TABLE `pw_windid_hook` (
  `name` varchar(50) NOT NULL DEFAULT '',
  `app_id` char(20) NOT NULL DEFAULT '' COMMENT 'Ӧid',
  `app_name` varchar(100) NOT NULL DEFAULT '' COMMENT 'Ӧ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  `document` text COMMENT 'ϸϢ',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='ӻϢ';

DROP TABLE IF EXISTS `pw_windid_hook_inject`;
CREATE TABLE `pw_windid_hook_inject` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` char(20) NOT NULL DEFAULT '',
  `app_name` varchar(100) NOT NULL DEFAULT '',
  `hook_name` varchar(100) NOT NULL DEFAULT '' COMMENT '',
  `alias` varchar(100) NOT NULL DEFAULT '' COMMENT 'ر',
  `class` varchar(100) NOT NULL DEFAULT '' COMMENT '',
  `method` varchar(100) NOT NULL DEFAULT '' COMMENT '÷',
  `loadway` varchar(20) NOT NULL DEFAULT '' COMMENT '뷽ʽ',
  `expression` varchar(100) NOT NULL DEFAULT '' COMMENT 'ʽ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_hook_name` (`hook_name`,`alias`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ӹط';

DROP TABLE IF EXISTS `pw_windid_admin_auth`;
CREATE TABLE `pw_windid_admin_auth` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0' COMMENT 'ûID',
  `username` varchar(15) NOT NULL DEFAULT '' COMMENT 'û',
  `roles` varchar(255) NOT NULL DEFAULT '' COMMENT 'ɫ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  PRIMARY KEY (`id`),
  KEY `idx_uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ûȨ޽ɫ';

DROP TABLE IF EXISTS `pw_windid_admin_config`;
CREATE TABLE `pw_windid_admin_config` (
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '',
  `namespace` varchar(15) NOT NULL DEFAULT 'global' COMMENT 'ռ',
  `value` text COMMENT 'ֵ',
  `vtype` enum('string','array','object') NOT NULL DEFAULT 'string' COMMENT 'ֵ',
  `description` text COMMENT 'ý',
  PRIMARY KEY (`namespace`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='վñ';

DROP TABLE IF EXISTS `pw_windid_admin_custom`;
CREATE TABLE `pw_windid_admin_custom` (
  `username` varchar(15) NOT NULL,
  `custom` text COMMENT 'ò˵',
  PRIMARY KEY (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='̨ò˵';

DROP TABLE IF EXISTS `pw_windid_admin_role`;
CREATE TABLE `pw_windid_admin_role` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL DEFAULT '' COMMENT 'ɫ',
  `auths` text COMMENT 'Ȩ޵',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='̨ûɫ';


DROP TABLE IF EXISTS `pw_windid_app`;
CREATE TABLE `pw_windid_app` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `siteurl` varchar(128) NOT NULL DEFAULT '',
  `siteip` varchar(20) NOT NULL DEFAULT '',
  `secretkey` varchar(50) NOT NULL DEFAULT '',
  `apifile` varchar(128) NOT NULL DEFAULT '' COMMENT '֪ͨļ',
  `charset`  varchar(16) NOT NULL DEFAULT '' COMMENT 'ͻ˱',
  `issyn` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `isnotify` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Ӧݱ';

DROP TABLE IF EXISTS `pw_windid_area`;
CREATE TABLE `pw_windid_area` (
  `areaid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ַID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '',
  `joinname` varchar(100) NOT NULL DEFAULT '' COMMENT '·cacheַ',
  `parentid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ϼ·ID',
  `vieworder` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '˳',
  PRIMARY KEY (`areaid`),
  KEY `idx_name` (`name`),
  KEY `idx_parentid_vieworder` (`parentid`,`vieworder`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ͳһ';

DROP TABLE IF EXISTS `pw_windid_config`;
CREATE TABLE `pw_windid_config` (
  `name` varchar(30) NOT NULL COMMENT '',
  `namespace` varchar(15) NOT NULL DEFAULT 'global' COMMENT 'ռ',
  `value` text COMMENT 'ֵ',
  `vtype` enum('string','array','object') NOT NULL DEFAULT 'string' COMMENT 'ֵ',
  `descrip` text COMMENT '',
  PRIMARY KEY (`namespace`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='windidñ';

DROP TABLE IF EXISTS `pw_windid_message`;
CREATE TABLE `pw_windid_message` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Ϣid',
  `from_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `to_uid` int(10) unsigned NOT NULL DEFAULT '0',
  `content` text COMMENT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
  PRIMARY KEY (`message_id`),
  KEY `idx_fromuid_touid` (`from_uid`,`to_uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Ϣݱ';

DROP TABLE IF EXISTS `pw_windid_message_dialog`;
CREATE TABLE `pw_windid_message_dialog` (
  `dialog_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Իid',
  `to_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `from_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `unread_count` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'δ',
  `message_count` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ܶԻ',
  `last_message` text COMMENT '¶Ի',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '޸ʱ',
  PRIMARY KEY (`dialog_id`),
  UNIQUE KEY `idx_touid_fromuid` (`to_uid`,`from_uid`),
  KEY `idx_touid_modifiedtime` (`to_uid`,`modified_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ϢԻ';

DROP TABLE IF EXISTS `pw_windid_message_relation`;
CREATE TABLE `pw_windid_message_relation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ϵid',
  `dialog_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Իid',
  `message_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '˽id',
  `is_read` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'ǷѶ',
  `is_send` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'ǷΪ˽',
  PRIMARY KEY (`id`),
  KEY `idx_dialogid` (`dialog_id`),
  KEY `idx_messageid` ( `message_id` ),
  KEY `idx_isread` ( `is_read` ),
  KEY `idx_issend` ( `is_send` )

) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Ϣϵ';

DROP TABLE IF EXISTS `pw_windid_notify`;
CREATE TABLE `pw_windid_notify` (
  `nid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `appid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `operation` varchar(50) NOT NULL DEFAULT '',
  `param` text COMMENT 'Ϣ',
  `timestamp` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='֪ͨб';

DROP TABLE IF EXISTS `pw_windid_notify_log`;
CREATE TABLE `pw_windid_notify_log` (
  `logid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nid` int(10) unsigned NOT NULL DEFAULT '0',
  `appid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `complete` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `send_num` int(10) unsigned NOT NULL DEFAULT '0',
  `reason` varchar(16) NOT NULL DEFAULT '',
  PRIMARY KEY (`logid`),
  KEY `idx_complete` (`complete`),
  KEY `idx_appid` (`appid`),
  KEY `idx_nid` (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='֪ͨͼ¼';

DROP TABLE IF EXISTS `pw_windid_school`;
CREATE TABLE `pw_windid_school` (
  `schoolid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ѧУID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT 'ѧУ',
  `areaid` int(10) NOT NULL DEFAULT '0' COMMENT 'ID',
  `typeid` tinyint(3) NOT NULL DEFAULT '0' COMMENT 'ͣѧ//',
  `first_char` char(1) NOT NULL DEFAULT '' COMMENT 'ѧУֵĸ',
  PRIMARY KEY (`schoolid`),
  KEY `idx_areaid_firstchar` (`areaid`,`first_char`),
  KEY `idx_name_firstchar` (`name`,`first_char`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='ͳһwindidѧУ';

DROP TABLE IF EXISTS `pw_windid_user`;
CREATE TABLE `pw_windid_user` (
  `uid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ûID',
  `username` varchar(15) NOT NULL DEFAULT '' COMMENT 'û',
  `email` varchar(80) NOT NULL DEFAULT '' COMMENT 'Email',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '',
  `salt` char(6) NOT NULL DEFAULT '' COMMENT 'ֵ',
  `safecv` char(8) NOT NULL DEFAULT '' COMMENT 'ȫ',
  `regdate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'עʱ',
  `regip` varchar(20) NOT NULL DEFAULT '' COMMENT 'עIP',
  PRIMARY KEY (`uid`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_email` (`email`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='windidûϢ';

DROP TABLE IF EXISTS `pw_windid_user_black`;
CREATE TABLE `pw_windid_user_black` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûuid',
  `blacklist` text COMMENT '',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='û';

DROP TABLE IF EXISTS `pw_windid_user_data`;
CREATE TABLE `pw_windid_user_data` (
  `uid` int(10) unsigned NOT NULL COMMENT 'ûID',
  `messages` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT 'ûϢ',
  `credit1` int(10) NOT NULL DEFAULT '0' COMMENT '1',
  `credit2` int(10) NOT NULL DEFAULT '0' COMMENT '2',
  `credit3` int(10) NOT NULL DEFAULT '0' COMMENT '3',
  `credit4` int(10) NOT NULL DEFAULT '0' COMMENT '4',
  `credit5` int(10) NOT NULL DEFAULT '0',
  `credit6` int(10) NOT NULL DEFAULT '0',
  `credit7` int(10) NOT NULL DEFAULT '0',
  `credit8` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='windidû';

DROP TABLE IF EXISTS `pw_windid_user_info`;
CREATE TABLE `pw_windid_user_info` (
  `uid` int(10) unsigned NOT NULL COMMENT 'ûID',
  `realname` varchar(20) NOT NULL DEFAULT '',
  `icon` varchar(100) NOT NULL DEFAULT '' COMMENT 'ͷ---δ',
  `gender` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ա',
  `byear` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `bmonth` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '·',
  `bday` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '',
  `hometown` int(10) NOT NULL DEFAULT '0' COMMENT 'ַͥID',
  `location` int(10) NOT NULL DEFAULT '0' COMMENT 'סID',
  `homepage` varchar(128) NOT NULL DEFAULT '' COMMENT 'ҳ',
  `qq` varchar(12) NOT NULL DEFAULT '' COMMENT 'QQ ',
  `aliww` varchar(30) NOT NULL DEFAULT '' COMMENT '',
  `mobile` varchar(16) NOT NULL DEFAULT '' COMMENT 'ֻ',
  `alipay` varchar(80) NOT NULL DEFAULT '' COMMENT '֧',
  `msn` varchar(80) NOT NULL DEFAULT '' COMMENT 'MSN',
  `profile` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`),
  KEY `idx_bday` (`bday`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='windidûչϢ';

DROP TABLE IF EXISTS `pw_word`;
CREATE TABLE `pw_word` (
  `word_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'дID',
  `word_type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'д',
  `word` varchar(100) NOT NULL DEFAULT '' COMMENT 'д',
  `word_replace` varchar(100) NOT NULL DEFAULT '' COMMENT 'д滻',
  `word_from` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'дԴ',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'дʴʱ',
  PRIMARY KEY (`word_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='дʱ';
