<?php

/**
 * ϵͳǰ̨
 *
 * @author xiaoxia.xu <x_824@sina.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: IndexController.php 23994 2013-01-18 03:51:46Z long.shi $
 * @package src.products.task.controller
 */
class IndexController extends PwBaseController {
	private $perpage = 20;
	
	/* (non-PHPdoc)
	 * @see PwBaseController::beforeAction()
	 */
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		if (!$this->loginUser->isExists()) {
			$this->forwardAction('u/login/run', array('backurl' => WindUrlHelper::createUrl('task/index/run')));
		}
		if (0 == Wekit::C('site', 'task.isOpen')) {
			$this->showError('TASK:app.no.open');
		}
		$this->setOutput($this->perpage, 'perpage');
	}
	
	/* (non-PHPdoc)
	 * @see WindController::run()
	 */
	public function run() {
		$page = $this->_getPage();
		/* @var $taskDs PwTaskUser */
		$taskDs = Wekit::load('task.PwTaskUser');
		$count = $taskDs->countMyTasksByStatus($this->loginUser->uid, 3);
		$list = array();
		if ($count > 0) {
			$totalPage = ceil($count/$this->perpage);
			$page = $page < 1 ? 1 : ($page > $totalPage ? intval($totalPage) : $page);
			/*@var $taskService PwTaskService */
			$taskService = Wekit::load('task.srv.PwTaskService');
			$list = $taskService->getMyTaskListWithStatu($this->loginUser->uid, 3, $page, $this->perpage);
		}
		$this->setOutput($count, 'count');
		$this->setOutput($list, 'list');
		$this->setOutput($this->_getTaskMode(), 'modes');
		
		// seo
		Wind::import('SRV:seo.bo.PwSeoBo');
		$seoBo = PwSeoBo::getInstance();
		$lang = Wind::getComponent('i18n');
		$seoBo->setCustomSeo($lang->getMessage('SEO:task.index.run.title'), '', '');
		Wekit::setV('seo', $seoBo);
	}
	
	/**
	 * չʾб
	 */
	public function applicableListAction() {
		$page = $this->_getPage();
		/*@var $taskService PwTaskService */
		$taskService = Wekit::load('task.srv.PwTaskService');
		list($count, $list) = $taskService->getApplicableTaskList($this->loginUser->uid, $page, $this->perpage);
		$this->setOutput($count, 'count');
		$this->setOutput($list, 'list');
		$this->setOutput($this->_getTaskMode(), 'modes');
		$this->setTemplate('index_applicable');
		
		// seo
		Wind::import('SRV:seo.bo.PwSeoBo');
		$seoBo = PwSeoBo::getInstance();
		$lang = Wind::getComponent('i18n');
		$seoBo->setCustomSeo($lang->getMessage('SEO:task.index.applicable.title'), '', '');
		Wekit::setV('seo', $seoBo);
	}
	
	/**
	 * չʾɵб
	 */
	public function completeListAction() {
		$page = $this->_getPage();
		/* @var $taskDs PwTaskUser */
		$taskDs = Wekit::load('task.PwTaskUser');
		$count = $taskDs->countMyTasksByStatus($this->loginUser->uid, 4);
		$list = array();
		if ($count > 0) {
			$totalPage = ceil($count/$this->perpage);
			$page = $page < 1 ? 1 : ($page > $totalPage ? intval($totalPage) : $page);
			/*@var $taskService PwTaskService */
			$taskService = Wekit::load('task.srv.PwTaskService');
			$list = $taskService->getMyTaskListWithStatu($this->loginUser->uid, 4, $page, $this->perpage);
		}
		$this->setOutput($count, 'count');
		$this->setOutput($list, 'list');
		$this->setTemplate('index_complete');
		
		// seo
		Wind::import('SRV:seo.bo.PwSeoBo');
		$seoBo = PwSeoBo::getInstance();
		$lang = Wind::getComponent('i18n');
		$seoBo->setCustomSeo($lang->getMessage('SEO:task.index.complete.title'), '', '');
		Wekit::setV('seo', $seoBo);
	}
	
	/**
	 * 
	 */
	public function applyTaskAction() {
		$id = intval($this->getInput('id'));
		if ($id < 0) $this->showError('TASK:id.illegal');
		Wind::import('SRV:task.srv.PwTaskApply');
		/*@var $taskApply PwTaskApply */
		$taskApply = new PwTaskApply($this->loginUser->uid);
		if (($result = $taskApply->apply($id)) instanceof PwError) $this->showError($result->getError());
		$condition = unserialize($result['conditions']);
		$reward = unserialize($result['reward']);
		$url = $condition['url'] ? $condition['url'] : 'task/index/run';
		//ȥַ
		$this->addMessage(WindUrlHelper::createUrl($url), 'url');
		//
		$this->addMessage($reward['descript'] ? $reward['descript'] : '', 'reward');
		//
		$this->addMessage($result['title'], 'title');
		//Ŀ
		$this->addMessage($result['description'], 'description');
		//ǰ
		$parent = '';
		if ($result['pre_task']) {
			$pre_task = Wekit::load('task.PwTask')->get($result['pre_task']);
			$parent['parent'] = $pre_task['title'];
		}
		$this->addMessage($parent, 'pre_task');
		//ʱ
		$time = '';
		if ($result['start_time'] || $result['end_time'] != PwTaskDm::MAXENDTIME) {
			$start_time = $result['start_time'] ? Pw::time2str($result['start_time'], 'Y-m-d') : '';
			$end_time = $result['end_time'] == PwTaskDm::MAXENDTIME ? '' : Pw::time2str($result['end_time'], 'Y-m-d');
			$time = $start_time . '  ' . $end_time;
		}
		$this->addMessage($time, 'time');
		$this->showMessage('TASK:apply.success');
	}
	
	/**
	 * ý
	 */
	public function rewardAction() {
		$id = $this->getInput('id');
		Wind::import('SRV:task.srv.PwTaskGainReward');
		$gainReward = new PwTaskGainReward($this->loginUser->uid, $id);
		if (($result = $gainReward->gainReward()) instanceof PwError) $this->showError($result->getError());
		$reward = $gainReward->taskInfo['reward']['descript'];
		$this->addMessage($reward ? $reward : '', 'reward');
		$this->addMessage($gainReward->taskInfo['title'], 'title');
		$this->showMessage('TASK:gain.task.reward.success');
	}
	
	/**
	 * ҳ
	 *
	 * @return int
	 */
	private function _getPage() {
		$page = intval($this->getInput('page'));
		($page < 1) && $page = 1;
		$this->setOutput($page, 'page');
		$this->setOutput($this->perpage, 'perpage');
		return $page;
	}
	
	/**
	 * ģʽ
	 *
	 * @return array
	 */
	private function _getTaskMode() {
		$mode = array(1 => array('class' => 'task_mode_end', 'button' => 'ȥ'),//Ѿȡ
			2 => array('class' => 'task_mode_expired', 'button' => 'ѹ'),//Ѿر
			3 => array('class' => 'task_mode_expired', 'button' => 'ѹ'),//Ѿ
			4 => array('class' => 'task_mode_end', 'button' => ''),//ڽ
			5 => array('class' => 'task_mode_arrow', 'button' => 'ȡ'));//
		return $mode;
	}
}
?>