<?php

/**
 * չ
 *
 * @author xiaoxia.xu <x_824@sina.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwTaskExtends.php 7054 2012-03-29 04:04:21Z xiaoxia.xuxx $
 * @package src.modules.task.service
 */
class PwTaskExtends {
	private $config = null;
	
	/**
	 * ýչб
	 * 
	 * @param array $reward õĽֵ
	 * @return array
	 */
	public function getRewardTypeList($reward = array()) {
		$list = $this->getExtendsList('reward');
		unset($reward['type']);
		$key = $reward ? serialize((array)$reward) : '';
		return $this->buildList($list, $key);
	}
	
	/**
	 * չб
	 * 
	 * @param array $condition õֵ
	 * @return array
	 */
	public function getConditionTypeList($condition = array()) {
		$list = $this->getExtendsList('condition');
		unset($condition['type'], $condition['child']);
		$var = $condition ? serialize((array)$condition) : '';
		$return = array();
		foreach ($list as $key => $item) {
			$return[$key] = array('title' => $item['title']);
			$return[$key]['children'] = $this->buildList($item['children'], $var);
		}
		return $return;
	}
	
	/**
	 * ݸʽ
	 *
	 * @param array $data
	 * @param string $var  ݸûĲ
	 * @return array
	 */
	private function buildList($data, $var = '') {
		$return = array();
		foreach ($data as $key => $item) {
			$return[$key] = array('title' => $item['title'], 'var' => $var, 'url' => $item['setting_url'] ? WindUrlHelper::createUrl($item['setting_url']) : '');
		}
		return $return;
	}
	
	/**
	 * չб
	 * 
	 * @param string $type
	 * @return array
	 */
	private function getExtendsList($type) {
		if ($this->config === null) {
			$this->config = include (Wind::getRealPath('APPS:task.conf.taskExtends.php', true));
		}
		return isset($this->config[$type]) ? $this->config[$type] : array();
	}
}