<?php
Wind::import('SRV:user.srv.PwFindPassword');
Wind::import('APPS:u.service.helper.PwUserHelper');
Wind::import('SRV:user.validator.PwUserValidator');
/**
 * 
 * óɹһ  һһΣŻ֤״̬һ
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: FindPwdController.php 22230 2012-12-19 21:45:20Z xiaoxia.xuxx $
 * @package src.products.user.controller
 */
class FindPwdController extends PwBaseController {
	private $isMailOpen = false;
	private $isMobileOpen = false;

	/* (non-PHPdoc)
	 * @see PwBaseController::beforeAction()
	 */
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		if ($this->loginUser->isExists()) $this->forwardRedirect(WindUrlHelper::createUrl('bbs/index/run'));
		$this->isMailOpen = Wekit::C('email', 'mailOpen') ? true : false;
		$this->isMobileOpen = Wekit::C('login', 'mobieFindPasswd') ? true : false;
	}

	/* (non-PHPdoc)
	 * @see WindController::run()
	 */
	public function run() {
		if (false === ($this->isMailOpen || $this->isMobileOpen)) {
			$this->setTemplate('findpwd_close');
		}
	}
	
	/**
	 * û
	 */
	public function checkUsernameAction() {
		$username = $this->getInput('username', 'post');
		if (!$username) {
			$this->showError('USER:findpwd.username.require', 'u/findPwd/run');
		}
		
		/*û*/
		if (!PwUserValidator::checkUsernameExist($username)) $this->showError('USER:user.error.-14');
		$findPasswordBp = new PwFindPassword($username);
		
		/*[û֧1ûаκοһķʽ]*/
		if (false === ($findPasswordBp->isBindMail() || $findPasswordBp->isBindMobile())) {
			$this->showError('USER:findpwd.notbind');
		}
		$isOverMail = $findPasswordBp->isOverByMail();
		$isOverMobile = $findPasswordBp->isOverByMobile();
		/*[û֧2ַʽһ붼Ѿմ]*/
		if ($isOverMail && $isOverMobile) {
			$this->showError('USER:findpwd.over.limit');
		}
		
		/*֧1ֻֻͨվͨˣֻһ뷽ʽ*/
		if (false === $this->isMailOpen && $this->isMobileOpen) {
			if ($isOverMobile) $this->showError('USER:findpwd.over.limit.mobile');
			if ($this->getInput('step', 'post') == 'do') {
				$this->forwardAction('u/findPwd/bymobile?username=' . $username);
			}
			$this->showMessage();
		}
		/*֧2ֻͨ䡿վͨˣһ뷽ʽ*/
		if (false === $this->isMobileOpen && $this->isMailOpen) {
			if ($isOverMail) $this->showError('USER:findpwd.over.limit.email');
			if ($this->getInput('step', 'post') == 'do') {
				$this->forwardAction('u/findPwd/bymail?username=' . $username);
			}
			$this->showMessage();
		}
		/*֧3رավرһ뷽ʽ*/
		if (false === ($this->isMobileOpen || $this->isMailOpen)) {
			$this->showError('USER:findpwd.way.close');
			if ($this->getInput('step', 'post') == 'do') {
				$this->forwardAction('u/findPwd/bymail?username=' . $username);
			}
			$this->showMessage();
		}
		
		/*֧4ͨվͨˣֻһһ뷽ʽ*/
		/*[֧4.1ûֻֻһ뷽ʽ]*/
		if (false === $findPasswordBp->isBindMail() && $findPasswordBp->isBindMobile()) {
			if ($isOverMobile) {
				$this->showError('USER:findpwd.over.limit.mobile');
			}
			if ($this->getInput('step', 'post') == 'do') {
				$this->forwardAction('u/findPwd/bymobile?username=' . $username);
			}
			$this->showMessage();
		}
		/*[֧4.2 ûֻһ뷽ʽ]*/
		if (false === $findPasswordBp->isBindMobile() && $findPasswordBp->isBindMail()) {
			if ($isOverMail) {
				$this->showError('USER:findpwd.over.limit.email');
			}
			if ($this->getInput('step', 'post') == 'do') {
				$this->forwardAction('u/findPwd/bymail?username=' . $username);
			}
			$this->showMessage();
		}
		
		/*[֧4.3ûַʽ]*/
		/*վַ֧ʽһ*/
		if ($this->getInput('step', 'post') == 'do') {
			$this->setOutput($username, 'username');
			$this->setTemplate('findpwd_way');
		} else {
			$this->showMessage('');
		}
	}
	
	/**
	 * ͨһ
	 */
	public function bymailAction() {
		$username = $this->getInput('username');
		if (!$username) {
			$this->showError('USER:findpwd.username.require', 'u/findPwd/run');
		}
		if (!$this->isMailOpen) {
			$this->showError('USER:findpwd.way.email.close', 'u/findPwd/run');
		}
		$findPasswordBp = new PwFindPassword($username);
		$this->setOutput($findPasswordBp->getFuzzyEmail(), 'mayEmail');
		$this->setOutput(in_array('resetpwd', Wekit::C('verify', 'showverify')), 'verify');
		$this->setOutput($username, 'username');
		$this->setOutput(2, 'step');
	}
	
	/**
	 * ЧǷȷ
	 */
	public function dobymailAction() {
		if (!$this->isMailOpen) {
			$this->showError('USER:findpwd.way.email.close', 'u/findPwd/run');
		}
		list($username, $email, $code) = $this->getInput(array('username', 'email', 'code'), 'post');
		$this->checkCode($code);
		/*Ƿȷ*/
		$findPasswordBp = new PwFindPassword($username);
		if (true !== ($result = $findPasswordBp->checkEmail($email))) {
			$this->showError($result->getError());
		}
		/*ʼ*/
		if (!$findPasswordBp->sendResetEmail(PwFindPassword::createFindPwdIdentify($username, PwFindPassword::WAY_EMAIL, $email))) {
			$this->showError('USER:findpwd.error.sendemail');
		}
		
		$this->setOutput($username, 'username');
		$this->setOutput($findPasswordBp->getEmailUrl(), 'emailUrl');
		$this->setOutput(3, 'step');
		$this->setTemplate('findpwd_bymail');
	}
	
	/**
	 * ֻͨһ
	 */
	public function bymobileAction() {
		$username = $this->getInput('username');
		if (!$username) {
			$this->showError('USER:findpwd.username.require', 'u/findPwd/run');
		}
		if (!$this->isMobileOpen) {
			$this->showError('USER:findpwd.way.mobile.close', 'u/findPwd/run');
		}
		$this->setOutput(in_array('resetpwd', Wekit::C('verify', 'showverify')), 'verify');
		$this->setOutput($username, 'username');
		$this->setOutput(2, 'step');
	}
	
	/**
	 * ֻ֤֤
	 */
	public function checkmobilecodeAction() {
		if (!$this->isMobileOpen) {
			$this->showError('USER:findpwd.way.mobile.close', 'u/findPwd/run');
		}
		list($username, $mobileCode, $mobile) = $this->getInput(array('username', 'mobileCode', 'mobile'), 'post');
		!PwUserValidator::isMobileValid($mobile) && $this->showError('USER:error.mobile', 'u/findPwd/run');
		!$mobileCode && $this->showError('USER:mobile.code.empty', 'u/findPwd/run');

		$userInfo = $this->_getUserDs()->getUserByName($username, PwUser::FETCH_INFO);
		if ($userInfo['mobile'] != $mobile) {
			$this->showError('USER:findpwd.error.mobile');
		}
		if (($mobileCheck = Wekit::load('mobile.srv.PwMobileService')->checkVerify($mobile, $mobileCode)) instanceof PwError) {
			$this->showError($mobileCheck->getError());
		}
		
		$statu = PwFindPassword::createFindPwdIdentify($username, PwFindPassword::WAY_MOBILE, $mobile);
		$this->showMessage('success','u/findPwd/resetpwd?way=mobile&_statu='.$statu.'&mobile='.$mobile.'&mobileCode='.$mobileCode);
	}

	/**
	 * ֤ʼչʾҳ
	 */
	public function resetpwdAction() {
		list($userinfo, $value, $type, $statu) = $this->checkState();
		$code = $this->getInput('code', 'get');
		$findPasswordBp = new PwFindPassword($userinfo['username']);
		if ($type == PwFindPassword::WAY_EMAIL) {
			if ($findPasswordBp->isOverByMail()) {
				$this->showError('USER:findpwd.over.limit.email');
			}
			if (($result = $findPasswordBp->checkResetEmail($value, $code)) instanceof PwError) {
				$this->showError($result->getError());
			}
		}
		if ($type == PwFindPassword::WAY_MOBILE) {
			if ($findPasswordBp->isOverByMobile()) {
				$this->showError('USER:findpwd.over.limit.mobile');
			}
			list($mobile, $mobileCode) = $this->getInput(array('mobile', 'mobileCode'), 'get');
			if (($mobileCheck = Wekit::load('mobile.srv.PwMobileService')->checkVerify($mobile, $mobileCode)) instanceof PwError) {
				$this->showError($mobileCheck->getError());
			}
		}
		$resource = Wind::getComponent('i18n');
		list($_pwdMsg, $_pwdArgs) = PwUserValidator::buildPwdShowMsg();
		$this->setOutput($resource->getMessage($_pwdMsg, $_pwdArgs), 'pwdReg');
		$this->setOutput($userinfo['username'], 'username');
		$this->setOutput($statu, 'statu');
		$this->setTemplate('findpwd_resetpwd');
	}
	
	/**
	 * 
	 */
	public function doresetpwdAction() {
		if ($this->getInput('step', 'post') == 'end') {
			list($userInfo, $value, $type) = $this->checkState();
			list($password, $repassword) = $this->getInput(array('password', 'repassword'), 'post');
			if ($password != $repassword) $this->showError('USER:user.error.-20');
			$userDm = new PwUserInfoDm($userInfo['uid']);
			$userDm->setUsername($userInfo['username']);
			$userDm->setPassword($password);
			$userDm->setQuestion('', '');
			/* @var $userDs PwUser */
			$userDs = Wekit::load('user.PwUser');
			$result = $userDs->editUser($userDm, PwUser::FETCH_MAIN);
			if ($result instanceof PwError) {
				$this->showError($result->getError());
			} else {
				//һ
				$findPasswordBp = new PwFindPassword($userInfo['username']);
				$findPasswordBp->success($type);
			}
			$this->showMessage('USER:findpwd.success', 'u/login/run?backurl=' . WindUrlHelper::createUrl('bbs/index/run'));
		}
	}
	
	/**
	 * ֻ֤
	 */
	public function sendmobileAction() {
		list($mobile, $username) = $this->getInput(array('mobile', 'username'), 'post');
		if (($result = $this->_checkMobileRight($mobile, $username)) instanceof PwError) {
			$this->showError($result->getError());
		}
		if (($result = Wekit::load('SRV:mobile.srv.PwMobileService')->sendMobileMessage($mobile)) instanceof PwError) {
			$this->showError($result->getError());
		}
		$this->showMessage('success');
	}
	
	/**
	 * ֻ֤
	 */
	public function checkmobileAction() {
		list($mobile, $username) = $this->getInput(array('mobile', 'username'), 'post');
		if (($result = $this->_checkMobileRight($mobile, $username)) instanceof PwError) {
			$this->showError($result->getError());
		}
		$result = Wekit::load('SRV:mobile.srv.PwMobileService')->checkTodayNum($mobile);
		if ($result instanceof PwError) {
			$this->showError($result->getError());
		}
		$this->showMessage();
	}
	
	private function _checkMobileRight($mobile, $username) {
		if (!$this->isMobileOpen) {
			return new PwError('USER:mobile.findPwd.open.error');
		}
		Wind::import('SRV:user.validator.PwUserValidator');
		if (!PwUserValidator::isMobileValid($mobile)) {
			return new PwError('USER:error.mobile');
		}
		$userInfo = $this->_getUserDs()->getUserByName($username, PwUser::FETCH_INFO);
		if ($userInfo['mobile'] != $mobile) {
			return new PwError('USER:findpwd.error.mobile');
		}
		return true;
	}
	
	/**
	 * ַϷ
	 */
	public function checkMailFormatAction() {
		if (!WindValidator::isEmail($this->getInput('email', 'post'))) {
			$this->showError('USER:user.error.-7');
		} else {
			$this->showMessage();
		}
	}
	
	/**
	 * ֻʽǷȷ
	 */
	public function checkPhoneFormatAction() {
		if (!PwUserValidator::isMobileValid($this->getInput('phone', 'post'))) {
			$this->showError('USER:mobile.error.formate');
		} else {
			$this->showMessage();
		}
	}
	
	/**
	 * ǷҪ
	 * @param string $type 
	 */
	private function checkState() {
		$statu = $this->getInput('_statu', 'get');
		!$statu && $statu = $this->getInput('statu', 'post');
		if (!$statu) $this->showError('USER:illegal.request');
		list($username, $way, $value) = PwFindPassword::parserFindPwdIdentify($statu);
		$userInfo = $this->_getUserDs()->getUserByName($username, PwUser::FETCH_INFO | PwUser::FETCH_MAIN);
		if ($userInfo[PwFindPassword::getField($way)] != $value) {
			$this->forwardAction('u/findPwd/run', array(), true);
		}
		return array($userInfo, $value, $way, $statu);
	}
	
	/**
	 * ֤
	 *
	 * @param string $code
	 * @return boolean
	 */
	private function checkCode($code) {
		if (!in_array('resetpwd', Wekit::C('verify', 'showverify'))) return true;
		/*֤*/
		/* @var $verifySrv PwCheckVerifyService */
		$verifySrv = Wekit::load("verify.srv.PwCheckVerifyService");
		if ($verifySrv->checkVerify($code) !== true) {
			$this->showError('USER:verifycode.error');
		}
		return true;
	}
	
	/**
	 * ûDS
	 *
	 * @return PwUser
	 */
	private function _getUserDs() {
		return Wekit::load('user.PwUser');
	}
	
	/* (non-PHPdoc)
	 * @see WindSimpleController::setDefaultTemplateName()
	 */
	protected function setDefaultTemplateName($handlerAdapter) {
		$this->setTemplate(strtolower($handlerAdapter->getController()) . '_' . $handlerAdapter->getAction());
	}
}