<?php
Wind::import('SRV:user.PwUser');
/**
 * 
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUserHelper.php 21282 2012-12-04 03:25:54Z xiaoxia.xuxx $
 * @package products.u.srv
 */
class PwUserHelper {
	
	/**
	 * õ¼
	 * 
	 * @return array
	 */
	public static function getLoginType() {
		return array(1 => 'UID', 2 => '', 3 => 'û', 4 => 'ֻ');
	}
	
	/**
	 * õ¼еĵ¼ʽʾϢ
	 * 
	 * @return string
	 */
	public static function getLoginMessage() {
		$config = Wekit::C('login', 'ways');
		$message = array();
		$ways = self::getLoginType();
		foreach ($config as $id) {
			$message[] = $ways[$id];
		}
		return implode('/', $message);
	}
	
	/** 
	 * óڵʱ
	 * 
	 * @return array  array(array(year), array(month), array(day))
	 */
	public static function getBirthDay() {
		$tyear = date('Y', Pw::getTime());
		$year = range($tyear, $tyear - 100, -1);
		$month = range(1, 12, 1);
		$day = range(1, 31);
		return array($year, $month, $day);
	}
	
	/** 
	 * עҪӵֶӳ
	 *
	 * @return array
	 */
	public static function getRegFieldsMap() {
		$fields = array(
			'location' => array('title' => '־ס', 'segment' => 'area'),
			'hometown' => array('title' => '', 'segment' => 'area'),
			'mobile' => array('title' => 'ֻ', 'segment' => 'input'),
			'qq' => array('title' => 'QQ', 'segment' => 'input'),
			'msn' => array('title' => 'MSN', 'segment' => 'input'),
			'aliww' => array('title' => '', 'segment' => 'input')
		);
		return $fields;
	}
	
	/** 
	 * жϻǿ
	 *
	 * @param string $pwd ǿ
	 * @return int ǿȼ(1,2: һ, 3 ǿ, 4ǳǿ)
	 */
	public static function checkPwdStrong($pwd) {
		$array = array();
		$len = strlen($pwd);
		$i = 0;
		$mode = array('a' => 0, 'A' => 0, 'd' => 0, 'f' => 0);
		while ($i < $len) {
			$ascii = ord($pwd[$i]);
			if ($ascii >= 48 && $ascii <= 57) // 
				$mode['d'] ++;
			elseif ($ascii >= 65 && $ascii <= 90) //дĸ 
				$mode['A'] ++;
			elseif ($ascii >= 97 && $ascii <= 122) //Сд 
				$mode['a'] ++;
			else
				$mode['f'] ++;
			$i ++;
		}
		/*ȫСдĸǴдĸַ*/
		if ($mode['a'] == $len || $mode['A'] == $len || $mode['f'] == $len) {
			return 2;
		}
		/*ȫ*/
		if ($mode['d'] == $len) {
			return 1;
		}
		
		$score = 0;
		/*Сдϵ÷20*/
		if ($mode['a'] > 0 && $mode['A'] > 0) {
			$score += 20;
		}
		/*3ڣ03ֵ÷10,33ϵ÷20*/
		if ($mode['d'] > 0 && $mode['d'] < 3 ) {
			$score += 10;
		} elseif ($mode['d'] >= 3) {
			$score += 20;
		}
		/*һַ÷10֣1ַ÷25*/
		if ($mode['f'] == 1) {
			$score += 10;
		} elseif ($mode['f'] > 1) {
			$score += 25;
		}
		/*ͬʱУĸ 25֣Уĸֺͷ 30֣УСдĸֺͷ 35*/
		if ($mode['a'] > 0 && $mode['A'] > 0 && $mode['d'] > 0 && $mode['f'] > 0) {
			$score += 35;
		} elseif (($mode['a'] > 0 || $mode['A'] > 0) && $mode['d'] > 0 && $mode['f'] > 0) {
			$score += 30;
		} elseif (($mode['a'] > 0 || $mode['A'] > 0) && $mode['d'] > 0) {
			$score += 25;
		}
		if ($len < 3) $score -= 10;
		if ($score >= 60) {
			return 4;
		} elseif ($score >= 40) {
			return 3;
		} elseif ($score >= 20) {
			return 2;
		}
		return 1;
	}
	
	/** 
	 * ðȫ
	 * 
	 * @return array
	 */
	public static function getSafeQuestion() {
		return Wekit::load('SRV:user.srv.PwUserService')->getSafeQuestion();
		/* return array(
			1 => 'Ұְֵĳ', 
			2 => 'ĳ',
			3 => 'ҵСѧУ', 
			4 => 'ҵѧУ', 
			5 => 'ϲ˶', 
			6 => 'ϲĸ', 
			7 => 'ϲĵӰ', 
			8 => 'ϲɫ'); */
	}
}