<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('SRV:poll.srv.PwPollDisplay');
Wind::import('SRV:poll.srv.dataSource.PwFetchPollByOrder');

/**
 * ͶƱģ
 *
 * 1. run Ȩ
 * </code>
 * @author MingXing Sun <mingxing.sun@aliyun-inc.com> 2012-01-12
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: TaController.php 3219 2012-01-12 06:43:45Z mingxing.sun $
 * @package admin
 * @subpackage controller
 */

class TaController extends PwBaseController {
	
	public $page = 1;
	public $perpage = 10;
	
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		if (!$this->loginUser->isExists()) {
			$this->forwardAction('u/login/run', array('backurl' => WindUrlHelper::createUrl('vote/ta/run')));
		}
	}
	
	/**
	 * ҹע˲ͶƱ
	 *
	 */
	public function run(){
		$page = $this->getInput('page');
 		$page = $page < 1 ? 1 : intval($page);
		list($start, $limit) = Pw::page2limit($page, $this->perpage);
		
		$followUids = $this->getFollowUids($this->loginUser->uid);
		
		$total = $this->_getPollVoterDs()->countByUids($followUids);
		$poll = $total ? $this->_getPollVoterDs()->fetchPollByUid($followUids, $limit, $start) : array();

		$pollInfo = $pollid = array();

		if ($total) {
			$pollid = array();
			foreach ($poll as $value) {
				$pollid[] = $value['poll_id'];
			}
			Wind::import('SRV:poll.srv.dataSource.PwFetchPollByPollid');
			$pollDisplay = new PwPollDisplay(new PwFetchPollByPollid($pollid, count($pollid), 0));
			$pollInfo = $this->_buildPoll($pollDisplay->gather());
		}

		$latestPollDisplay = new PwPollDisplay(new PwFetchPollByOrder(10, 0, array('created_time'=>'0')));
		$latestPoll = $latestPollDisplay->gather();
		
		$this->setOutput($total, 'total');
		$this->setOutput($pollInfo, 'pollInfo');
		$this->setOutput($latestPoll, 'latestPoll');
		$this->setOutput($page, 'page');
		$this->setOutput($this->perpage, 'perpage');
		$this->setOutput(
			array(
				'allowview' => $this->loginUser->getPermission('allow_view_vote'),
				'allowvote'=> $this->loginUser->getPermission('allow_participate_vote')
			)
		, 'pollGroup');
		
		if (!$total) {
			$num = 20;
			$uids = $this->_getRecommendService()->getRecommendAttention($this->loginUser->uid,$num);
			$recommend = $this->_getRecommendService()->buildUserInfo($this->loginUser->uid, $uids, $num);
			$this->setOutput($recommend, 'recommend');
		}
		
		// seo
		Wind::import('SRV:seo.bo.PwSeoBo');
		$seoBo = PwSeoBo::getInstance();
		$lang = Wind::getComponent('i18n');
		$seoBo->setCustomSeo($lang->getMessage('SEO:vote.ta.run.title'), '', '');
		Wekit::setV('seo', $seoBo);
	}
	
	/**
	 * ҹע˷ͶƱ
	 *
	 */
	public function createAction(){
		$page = $this->getInput('page');
 		$page = $page < 1 ? 1 : intval($page);
		list($start, $limit) = Pw::page2limit($page, $this->perpage);
		
		$followUids = $this->getFollowUids($this->loginUser->uid);
		
		$total = $this->_getPwPollDs()->countPollByUids($followUids);
		
		$pollInfo = array();
		
		if ($total) {
			Wind::import('SRV:poll.srv.dataSource.PwFetchPollByUids');
			$pollDisplay = new PwPollDisplay(new PwFetchPollByUids($followUids, $limit, $start));
			$pollInfo = $this->_buildPoll($pollDisplay->gather());
		}
		
		$latestPollDisplay = new PwPollDisplay(new PwFetchPollByOrder(10, 0, array('created_time'=>'0')));
		$latestPoll = $latestPollDisplay->gather();
		
		$this->setOutput($total, 'total');
		$this->setOutput($pollInfo, 'pollInfo');
		$this->setOutput($latestPoll, 'latestPoll');
		$this->setOutput($page, 'page');
		$this->setOutput($this->perpage, 'perpage');
		$this->setOutput(
			array(
				'allowview' => $this->loginUser->getPermission('allow_view_vote'),
				'allowvote'=> $this->loginUser->getPermission('allow_participate_vote')
			)
		, 'pollGroup');
		
		if (!$total) {
			$num = 20;
			$uids = $this->_getRecommendService()->getRecommendAttention($this->loginUser->uid,$num);
			$recommend = $this->_getRecommendService()->buildUserInfo($this->loginUser->uid, $uids, $num);
			$this->setOutput($recommend, 'recommend');
		}
	}
	
	/**
	 * ȡҹעûID
	 *
	 * return array
	 */
	public function getFollowUids($uid, $limit = 500){
		$reuslt = array();
		$follow = Wekit::load('attention.PwAttention')->getFollows($uid, $limit);
		foreach($follow as $key => $value){
			$reuslt[] = $value['touid'];
		}
		return $reuslt;
	}
	
	private function _buildPoll($data) {
		$pollid = $myPollid = $reuslt = array();
		foreach ($data as $value) {
			$pollid[] = $value['poll_id'];
		}
		
		$loginUserPollids = $this->_getPollVoterDs()->getPollByUidAndPollid($this->loginUser->uid, $pollid);

		foreach ($data as $value) {
			$value['isvoted'] = in_array($value['poll_id'], $loginUserPollids)  ? true : false;
			$reuslt[] = $value;
		}

		return $reuslt;
	}
	
	/**
	 * ȡͶƱservice
	 *
	 * @return PwPollService
	 */
	protected function _getPwPollService(){
		return Wekit::load('poll.srv.PwPollService');
	}

	/**
	 * ȡͶƱӿ
	 *
	 * @return PwPoll
	 */
	protected function _getPwPollDs(){
		return Wekit::load('poll.PwPoll');
	}
	
	/**
	 * get PwPollVoter
	 *
	 * @return PwPollVoter
	 */
	protected function _getPollVoterDs(){
		return Wekit::load('poll.PwPollVoter');
	}
	
	/**
	 * get PwAttentionRecommendFriendsService
	 *
	 * @return PwAttentionRecommendFriendsService
	 */
	protected function _getRecommendService() {
		return Wekit::load('attention.srv.PwAttentionRecommendFriendsService');
	}
}