<?php
Wind::import('SRC:bootstrap.bootstrap');
Wind::import('ADMIN:service.srv.AdminUserService');

/**
 * @author Jianmin Chen <sky_hold@163.com>
 * @version $Id: adminBoot.php 26577 2013-04-11 08:05:09Z long.shi $
 * @package wekit
 */
abstract class adminBoot extends bootstrap {

	private $_loginUser = null;

	/**
	 * ̨˵·
	 * Ĭϲ˵ַAPP:admin.conf.mainmenu.php
	 *
	 * @var string
	 */
	public $menuPath = 'ADMIN:conf.mainmenu.php';
	
	/**
	 * ̨ʼõַ
	 * Ĭϲ˵ַCONF:founder.php
	 */
	public $founderPath = 'CONF:founder.php';

	/**
	 * ̨homeҳӵַ
	 * ĬϡAPP:admin.controller.HomeController
	 *
	 * @var string
	 */
	public $homeLink = 'home/run';

	/**
	 * ã
	 * ̨ļ
	 * ļλi18n/language/admin/searchFile
	 * ļ԰Уָļ
	 *
	 * @var string
	 */
	public $searchFile = 'search';

	/**
	 * ̨log¼
	 *
	 * @var string
	 */
	public $logFile = 'DATA:log.admin_log.php';

	/**
	 * ݱʶ
	 * ĬΪգΪʱݱжʶݱΪԭʼݱ
	 * ע⣺ͬݿ´׺̨ϵͳʱҪøݷ룬ݳͻ
	 *
	 * @var string
	 */
	public $dbTableMark = '';

	/**
	 * db齨ƣ
	 * ĬΪϵͳĬϵdb齨db,Ҫdb齨ø
	 *
	 * @var string
	 */
	public $dbComponentName = 'db';

	/**
	 * Ӧ
	 *
	 * @var array
	 */
	protected $dependenceServiceDefinitions = array(
		'adminUserService' => array('path' => '')
	);
	
	public function __construct($re) {
		if (!is_file(Wind::getRealPath('DATA:install.lock', true))) {
			Wind::getComponent('response')->sendRedirect("install.php");
		}
		parent::__construct($re);
	}

	public function getConfigService() {
		return Wekit::load('config.PwConfig');
	}

	/**
	 * ȡȫ
	 *
	 * @return array
	 */
	public function getConfig() {
		return Wekit::cache()->get('config');
	}

	/**
	 * ȡǰʱ
	 *
	 * @return int
	 */
	public function getTime() {
		$timestamp = time();
		if ($cvtime = Wekit::C('site', 'time.cv')) $timestamp += $cvtime * 60;
		return $timestamp;
	}
	
	public function getLoginUser() {
		if ($this->_loginUser === null) {
			$this->_loginUser = $this->_getLoginUser();
			$this->_loginUser->ip = Wind::getComponent('request')->getClientIp();
		}
		return $this->_loginUser;
	}
	
	/* (non-PHPdoc)
	 * @see bootstrap::beforeStart()
	 */
	public function beforeStart($front = null) {
		parent::beforeStart($front);
		foreach ($this->dependenceServiceDefinitions as $alias => $definition) {
			if (!$definition) continue;
			Wind::registeComponent($definition, $alias);
		}
	}

	/* (non-PHPdoc)
	 * @see bootstrap::beforeResponse()
	 */
	public function beforeResponse($front = null) {
		//̨ؼ
		$searchword = Wind::getComponent('request')->getGet('searchword');
		if ($searchword) {
			$content = ob_get_contents();
			ob_end_clean();
			$content = preg_replace('/('.preg_quote($searchword, '/').')([^">;]*<)(?!\/script|\/textarea)/si','<span class="red"><u>\\1</u></span>\\2', $content);
			$compress = Wind::getApp()->getConfig('compress');
			if (!$compress || !ob_start('ob_gzhandler')) ob_start();
			echo $content;
		}
	}

	protected function _getLoginUser() {
		Wind::import('ADMIN:service.bo.AdminUserBo');
		$user = Wekit::load('ADMIN:service.srv.AdminUserService')->isLogin();
		return new AdminUserBo($user);
	}
}