<?php
Wind::import('SRC:bootstrap.adminBoot');
Wind::import('WSRV:base.WindidBaseDao');
Wind::import('WSRV:base.WindidUtility');
Wind::import('WSRV:base.WindidError');

/**
 * windidadmin̨Ӧű
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: windidadminBoot.php 25243 2013-03-07 15:29:09Z long.shi $
 * @package wind
 */
class windidadminBoot extends adminBoot {

	private $_loginUser = null;

	/**
	 * ̨˵·
	 * Ĭϲ˵ַAPP:admin.conf.mainmenu.php
	 *
	 * @var string
	 */
	public $menuPath = 'APPS:windidadmin.conf.mainmenu.php';

	/**
	 * ̨homeҳӵַ
	 * ĬϡAPP:admin.controller.HomeController
	 *
	 * @var string
	 */
	public $homeLink = 'windidadmin/home/run';

	/**
	 * ã
	 * ̨ļ
	 * ļλi18n/language/admin/searchFile
	 * ļ԰Уָļ
	 *
	 * @var string
	 */
	public $searchFile = 'search';

	/**
	 * ̨log¼
	 *
	 * @var string
	 */
	public $logFile = 'DATA:log.windid_admin_log.php';

	/**
	 * ݱʶ
	 * ĬΪգΪʱݱжʶݱΪԭʼݱ
	 * ע⣺ͬݿ´׺̨ϵͳʱҪøݷ룬ݳͻ
	 *
	 * @var string
	 */
	public $dbTableMark = '';

	/**
	 * db齨ƣ
	 * ĬΪϵͳĬϵdb齨db,Ҫdb齨ø
	 *
	 * @var string
	 */
	public $dbComponentName = 'windiddb';

	/**
	 * Ӧ
	 *
	 * @var array
	 */
	protected $dependenceServiceDefinitions = array(
		'adminUserService' => array('path' => 'APPS:windidadmin.service.srv.do.AdminUserDependenceService')
	);
	
	public function getCache() {
		return null;
	}
	
	public function getConfigService() {
		return Wekit::load('WSRV:config.WindidConfig');
	}

	/**
	 * ȡȫ
	 *
	 * @return array
	 */
	public function getConfig() {
		return $this->getConfigCacheValue();
	}
	
	public function getTime() {
		$timestamp = time();
		if ($cvtime = Wekit::C('site', 'time.cv')) $timestamp += $cvtime * 60;
		return $timestamp;
	}

	/* (non-PHPdoc)
	 * @see phpwindBoot::init()
	 */
	public function beforeStart($front = null) {
		parent::beforeStart($front);
		if (!Wind::getComponent('router')->getRoute('pw')) {
			Wind::getComponent('router')->addRoute('pw', WindFactory::createInstance(Wind::import('LIB:route.PwRoute'), array('bbs')));
		}
		Wind::getComponent('router')->addRoute('admin', WindFactory::createInstance(Wind::import('LIB:route.PwAdminRoute'), array('default')), true);
		Wekit::setapp('windid', Wekit::app());
	}

	protected function getConfigCacheValue() {
		$vkeys = array('site', 'components', 'verify');
		$array = Wekit::load('WSRV:config.WindidConfig')->fetchConfig($vkeys);
		$config = array();
		foreach ($vkeys as $key => $value) {
			$config[$value] = array();
		}
		foreach ($array as $key => $value) {
			$config[$value['namespace']][$value['name']] = $value['vtype'] != 'string' ? unserialize($value['value']) : $value['value'];
		}
		return $config;
	}
}
?>