<?php

/**
 * ¼Ds
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package wind
 */
class App_Search_Record {
	
	const TYPE_THREAD = 1; // 
	const TYPE_USER = 2; // û
	const TYPE_FORUM = 3; // 
	
	/**
	 * 
	 *
	 * @param PwRecordDm $dm
	 * @return bool 
	 */
	public function addRecord(App_Search_RecordDm $dm) {
		if (($result = $dm->beforeAdd()) instanceof PwError) return $result;
		return $this->_getRecordDao()->replace($dm->getData());
	}
	
	/**
	 * 滻 - ౣ20
	 *
	 * @param PwRecordDm $dm
	 * @return bool 
	 */
	public function replaceRecord(App_Search_RecordDm $dm) {
		$uid = $dm->getField('created_userid');
		$type = $dm->getField('search_type');
		$count = $this->countByUidAndType($uid, $type);
		if ($count >= 5) {
			$this->_getRecordDao()->deleteByTime();
		}
		return $this->addRecord($dm);
	}
	
	/**
	 * ɾһ
	 *
	 * @param int $id
	 * @return bool 
	 */
	public function deleteRecord($id) {
		$id = intval($id);
		if ($id < 1) {
			return false;
		}
		return $this->_getRecordDao()->delete($id);
	}	 
	
	/**
	 * ûɾ
	 *
	 * @param int $uid
	 * @param int $type
	 * @return bool 
	 */
	public function deleteByUidAndType($uid, $type) {
		$uid = intval($uid);
		$type = intval($type);
		if ($uid < 1 || $type < 1) return false;
		return $this->_getRecordDao()->deleteByUidAndType($uid, $type);
	}	
	
	/**
	 * uidȡnum
	 * 
	 * @param int $uid
	 * @param int $num
	 * @return array 
	 */
	public function getByUidAndType($uid, $type){
		$uid = intval($uid);
		$type = intval($type);
		if ($uid < 1 || $type < 1) return array();
		return $this->_getRecordDao()->getByUidAndType($uid, $type);
	}
	
	/**
	 * ûͳƲݸ
	 * 
	 * @param int $uid
	 * @return array 
	 */
	public function countByUidAndType($uid, $type){
		$uid = intval($uid);
		$type = intval($type);
		if ($uid < 1 || $type < 1) return array();
		return $this->_getRecordDao()->countByUidAndType($uid, $type);
	}
	
	/**
	 * ȡһ
	 *
	 * @param int $id
	 * @return array 
	 */
	public function getRecord($id) {
		$id = intval($id);
		if ($id < 1) return array();
		return $this->_getRecordDao()->get($id);
	}
	
	/**
	 * ༭
	 *
	 * @param int $id
	 * @param array $data
	 * @return array 
	 */
	public function updateRecord($id, App_Search_RecordDm $dm) {
		if (($result = $dm->beforeUpdate()) instanceof PwError) return $result;
		return $this->_getRecordDao()->update($id,$dm->getData());
	}	
	
	/**
	 * @return App_Search_RecordDao
	 */
	protected function _getRecordDao() {
		return Wekit::loadDao('EXT:search.service.dao.App_Search_RecordDao');
	}
}