<?php
Wind::import('SRC:library.base.PwBaseDao');

/**
 * ¼
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package wind
 */
class App_Search_RecordDao extends PwBaseDao {
	
	protected $_table = 'app_search_record';
	protected $_dataStruct = array('id', 'created_userid', 'created_time', 'search_type', 'keywords');
	
	/**
	 * ȡһϢ
	 *
	 * @param int $id
	 * @return array
	 */
	public function get($id) {
		return $this->_get($id);
	}
	
	/**
	 * 
	 *
	 * @param array $data
	 * @return bool
	 */
	public function add($data) {
		return $this->_add($data);
	}
	
	/**
	 * 
	 *
	 * @param array $data
	 * @return bool
	 */
	public function replace($data) {
		$sql = $this->_bindSql('REPLACE INTO %s SET %s', $this->getTable(), $this->sqlSingle($data));
		return $this->getConnection()->execute($sql);
	}
	
	/**
	 * ɾ
	 *
	 * @param int $id
	 * @return bool
	 */
	public function delete($id) {
		return $this->_delete($id);
	}
	
	/**
	 * ûɾ
	 *
	 * @param int $uid
	 * @param int $type
	 * @return bool 
	 */
	public function deleteByUidAndType($uid, $type) {
		$sql = $this->_bindTable('DELETE FROM %s WHERE `created_userid`=? AND `search_type`=?');
		$smt = $this->getConnection()->createStatement($sql);
		$result = $smt->update(array($uid, $type));
	}
	
	/**
	 * ʱɾ
	 *
	 * @param int $id
	 * @return bool
	 */
	public function deleteByTime() {
		$sql = $this->_bindTable('DELETE FROM %s ORDER BY `created_time` ASC LIMIT 1');
		$smt = $this->getConnection()->createStatement($sql);
		$result = $smt->update(array());
	}
	
	/**
	 * ɾ
	 *
	 * @param array $ids
	 * @return bool
	 */
	public function batchDelete($ids) {
		return $this->_batchDelete($ids);
	}
	
	/**
	 * ޸
	 *
	 * @param int $id
	 * @param array $data
	 * @return bool
	 */
	public function update($id,$data) {
		return $this->_update($id,$data);
	}
	
	/**
	 * ûͳƲݸ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countByUidAndType($uid, $type) {
		$sql = $this->_bindTable('SELECT COUNT(*) FROM %s WHERE `created_userid`=? AND `search_type`=?');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($uid, $type));
	}
	
	/**
	 * ûȡ
	 *
	 * @param int $uid
	 * @param int $type
	 * @return array
	 */
	public function getByUidAndType($uid, $type) {
		$sql = $this->_bindTable('SELECT * FROM %s WHERE `created_userid`=? AND `search_type`=? ');
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($uid, $type));
	}

	public function alterAddLastSearch() {
		$sql = $this->_bindSql('ALTER TABLE %s ADD `last_search_time` INT(10) UNSIGNED NOT NULL DEFAULT 0', $this->getTable('user_data'));
		return $this->getConnection()->execute($sql);
	}
	
	public function alterDeleteLastSearch() {
		$sql = $this->_bindSql("DELETE FROM %s WHERE `rkey` LIKE '%s';", $this->getTable('user_permission_groups'), 'app_search%');
		$this->getConnection()->execute($sql);
		$sql = $this->_bindSql("ALTER TABLE %s DROP `last_search_time`", $this->getTable('user_data'));
		return $this->getConnection()->execute($sql);
	}
}