<?php
Wind::import('EXT:search.service.srv.action.App_Search_Action');

class App_Search_Mysql extends App_Search_Action{
	

	/**
	 * ͳư
	 * 
	 * @param PwForumSo $so
	 * @return int
	 */
	function countSearchForum(PwForumSo $so){
		return $this->_getForumSearch()->countSearchForum($so);
	}
	
	/**
	 * 
	 * 
	 * @param PwForumSo $so
	 * @param int $limit ѯ
	 * @param int $start ʼѯλ
	 * @return array
	 */
	function searchForum(PwForumSo $so, $limit = 20, $start = 0){
		return $this->_getForumSearch()->searchDesignForum($so, $limit, $start);
	}
	
	/**
	 * ͳ
	 * 
	 * @param PwThreadSo $so
	 * @return int
	 */
	function countSearchThread(PwThreadSo $so){
		return $this->_getThreadSearch()->countSearchThread($so);
	}
	
	/**
	 * 
	 * 
	 * @param PwThreadSo $so
	 * @param int $limit ѯ
	 * @param int $start ʼѯλ
	 * @return array
	 */
	function searchThread(PwThreadSo $so, $limit = 20, $start = 0, $fetchmode = PwThread::FETCH_ALL){
		return $this->_getThreadSearch()->searchThread($so, $limit, $start, $fetchmode);
	}
	
	/**
	 * ͳû
	 * 
	 * @param PwUserSo $so
	 * @return int
	 */
	function countSearchUser(PwUserSo $so){
		return $this->_getUserSearch()->countSearchUser($so);
	}
	
	/**
	 * û
	 * 
	 * @param PwUserSo $so
	 * @param int $limit ѯ
	 * @param int $start ʼѯλ
	 * @return array
	 */
	function searchUser(PwUserSo $so, $limit = 20, $start = 0){
		return $this->_getUserSearch()->searchUserAllData($so, $limit, $start);
	}
	
	/**
	 * PwForum
	 *
	 * @return PwForum
	 */
	protected function _getForumSearch() {
		return Wekit::load('SRV:forum.PwForum');
	}
	
	/**
	 * PwThread
	 *
	 * @return PwThread
	 */
	protected function _getThreadSearch() {
		return Wekit::load('SRV:forum.PwThread');
	}
	
	/**
	 * PwUserSearch
	 *
	 * @return PwUserSearch
	 */
	protected function _getUserSearch() {
		return Wekit::load('SRV:user.PwUserSearch');
	}
}