<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('LIB:process.iPwGleanDoHookProcess');

/**
 * ɾչӿ--ɾԴ
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwDeleteFreshDoTopicDelete.php 21189 2012-11-30 04:00:34Z xiaoxia.xuxx $
 * @package forum
 */

class PwDeleteFreshDoTopicDelete extends iPwGleanDoHookProcess {
	
	public $record = array();
	
	public function gleanData($value) {
		if ($value['type'] == PwFresh::TYPE_THREAD_TOPIC) {
			$this->record[] = $value['src_id'];
		}
	}

	public function run($ids) {
		if ($this->record) {
			Wind::import('SRV:forum.srv.operation.PwDeleteTopic');
			Wind::import('SRV:forum.srv.dataSource.PwFetchTopicByTid');
			$srv = new PwDeleteTopic(new PwFetchTopicByTid($this->record), $this->srv->user);
			$srv->setIsDeleteFresh(false)
				->setIsDeductCredit($this->srv->isDeductCredit)
				->execute();
			
			//Ӳɾ־¼Ϊɾӡ͵־
			Wekit::load('log.srv.PwLogService')->addThreadManageLog($this->srv->user, 'delete', $srv->data, '');
		}
	}
}