<?php
Wind::import('WIND:filter.WindActionFilter');

/**
 * ϵͳĬȫfilter
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwBaseFilter.php 28262 2013-05-07 17:52:20Z jieyin $
 * @package src
 * @subpackage library.filter
 */
abstract class PwBaseFilter extends WindActionFilter {
	
	/**
	 * ʾϢ
	 *
	 * @param string $message ϢϢ
	 * @param string $referer תַ
	 * @param boolean $referer Ƿˢҳ
	 * @see WindSimpleController::showMessage()
	 */
	protected function showMessage($message = '', $referer = '', $refresh = false) {
		$this->errorMessage->addError('success', 'state');
		$this->errorMessage->addError($this->forward->getVars('data'), 'data');
		$this->showError($message, $referer, $refresh);
	}

	/**
	 * ʾ
	 *
	 * @param string $error ϢϢ
	 * @param string $referer תַ
	 * @param boolean $referer Ƿˢҳ
	 */
	protected function showError($error = '', $referer = '', $refresh = false) {
		if ($referer && !WindValidator::isUrl($referer)) {
			$_referer = explode('#', $referer, 2);
			$referer = WindUrlHelper::createUrl($_referer[0], array(), 
				isset($_referer[1]) ? $_referer[1] : '');
		}
		$this->errorMessage->addError($referer, 'referer');
		$this->errorMessage->addError($refresh, 'refresh');
		$this->errorMessage->addError($error);
		//$errorAction && $this->getErrorMessage()->setErrorAction($errorAction);
		$this->errorMessage->sendError();
	}

	protected function forwardAction($action, $args = array(), $isRedirect = false, $immediately = true) {
		$this->forward->forwardAction($action, $args, $isRedirect, $immediately);
	}

	protected function forwardRedirect($url) {
		$this->forward->forwardRedirect($url);
	}

	protected function setTheme($theme, $package) {
		$this->forward->getWindView()->setTheme($theme, $package);
	}
}
?>