<?php
defined('WEKIT_VERSION') || exit('Forbidden');
@set_time_limit('800');
/**
 * ϴ
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwStorageFtp.php 22526 2012-12-25 07:18:36Z yishuo $
 * @package upload
 */

class PwStorageCdn {

	private $_config;
	private $_cdn = null;

	public function __construct() {
		$this->_config = Wekit::C('attachs');
	}
	
	/**
	 * ȡwebַ
	 *
	 * @param string $path Դ洢ַ
	 * @param int $ifthumb Ƿȡͼ
	 * @return string
	 */
	public function get($path, $ifthumb) {
		return $this->_config['dnsurl'] . '/' .  $path;
	}
	
	/**
	 * ȡصַ
	 *
	 * @param string $path
	 * @return string ļʵ洢·
	 */
	public function getDownloadUrl($path) {
		return $this->get($path, 0);
	}
	
	/**
	 * 洢,Զ̴洢ǵɾļ
	 *
	 * @param string $source Դļַ
	 * @param string $filePath 洢λ
	 * @return bool
	 */
	public function save($source, &$filePath) {
		$data = WindFile::read($source);
		$stuff = WindFile::getSuffix($source);
		$result = $this->_getCdn()->write($data, $stuff);
		if ($result){
			Pw::deleteFile($source);
			$filePath = $result;
			return true;
		} else {
			return false;
		}
	}
	
	/**
	 * ȡϴʱ洢ڱصļַ
	 *
	 * @param string $filename ļ
	 * @param string $dir Ŀ¼
	 * @return string
	 */
	public function getAbsolutePath($filename, $dir) {
		return DATA_PATH . 'upload/' . Pw::time2str(WEKIT_TIMESTAMP, 'j') . '/' . str_replace('/', '_', $dir) . $filename;
	}
	
	/**
	 * ɾ
	 *
	 * @param string $path ַ
	 */
	public function delete($path, $ifthumb = 0) {
		$result = $this->_getCdn()->delete($path);
		return true;
	}

	public function _getCdn() {
		if ($this->_cdn == null) {
			Wind::import('SRV:upload.cdn.PwAliCdn');
			$this->_cdn = new PwAliCdn();
			$this->_cdn->set_version(RAW_VERSION);
			$this->_cdn->set_appkey($this->_config['dnsappkey']);
		}
		return $this->_cdn;
	}
}
?>