<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * ϴ/ӿ
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwUploadAction.php 28884 2013-05-29 02:44:27Z jieyin $
 * @package upload
 */

abstract class PwUploadAction {

	public $ftype = array();
	public $attachs = array();
	public $isLocal = false;
	
	/**
	 * ǷʼϴΪ
	 *
	 * @return bool
	 */
	public function check() {
		return true;
	}
	
	/**
	 * ϴ¼ǷΪҵϴ
	 *
	 * @param string $key $_FILESеkey
	 * @return bool
	 */
	public function allowType($key) {
		return true;
	}
	
	/**
	 * ȡϴļ洢
	 *
	 * @param object $file ϴļ<PwUploadFile>
	 * @return string
	 */
	abstract public function getSaveName(PwUploadFile $file);
	
	/**
	 * ȡϴļ洢·
	 *
	 * @param object $file ϴļ<PwUploadFile>
	 * @return string
	 */
	abstract public function getSaveDir(PwUploadFile $file);
	
	/**
	 * Ƿͼ
	 *
	 * @return bool
	 */
	public function allowThumb() {
		return false;
	}
	
	/**
	 * ͼ
	 *
	 * @param string $filename ļ
	 * @param string $dir 洢·
	 * @return array  
	 *	:array(
	 *		array(0.ͼļ, 1.ͼ洢ַ, 2.ƿ, 3.Ƹ, 4.ͼɷʽ(*), 5.ǿ(*)),
	 *		array('abc.jpg', 'thumb/mini', 300, 300, 0, 0) ɶͼʱ
	 *	)
	 * (*4).ͼɷʽ <0.ȱ 1.нȡ 2.ȱ>
	 * (*5).ǿ <0.ļߴСҪʱ 1.>
	 */
	public function getThumbInfo($filename, $dir) {
		return array();
	}
	
	/**
	 * ǷͼƬˮӡ
	 *
	 * @return bool
	 */
	public function allowWaterMark() {
		return false;
	}
	
	/**
	 * ȡˮӡ
	 *
	 * @return array ,ѡ
	 *  :array(
	 *		'type'				=> 1,				<int, 1.ͼƬˮӡ 2.ˮӡ>
	 *		'gif'				=> 1,				<bool, ǷΪgifͼƬˮӡ>
	 *		'limitwidth'		=> 200,				<bool, ƿ>
	 *		'limitheight'		=> 200,				<bool, Ƹ> 
	 *		'position'			=> 9,				<bool, 1-9,Źλ>
	 *		'transparency'		=> 85,				<bool, 0-100, ͸>
	 *		'quality'			=> 85,				<bool, 0-100, ˮӡ>
	 *		'file'				=> a.gif,			<string, ˮӡļ>
	 *		'text'				=> abc,				<string, ˮӡ>
	 *		'fontfamily'		=> cn_witer.ttf,	<string, >
	 *		'fontsize'			=> 12,				<string, ֺ>
	 *		'fontcolor'			=> #aaa				<string, ɫ>
	 *   )
	 */
	public function getWaterMarkInfo() {
		return array();
	}
	
	/**
	 * ϴʧܣص
	 *
	 * @param PwUploadFile $file
	 * @return void
	 */
	public function fileError(PwUploadFile $file) {
		Pw::deleteFile($file->source);
	}
	
	/**
	 * ϴɣҵ߼
	 *
	 * @param array $uploaddb ϴļб
	 * @return mixed
	 */
	abstract public function update($uploaddb);
	
	/**
	 * ϴб
	 *
	 * @return array
	 */
	public function getAttachs() {
		return $this->attachs;
	}
	
	/**
	 * ϴ
	 *
	 * @return int
	 */
	public function getUploadNum() {
		return count($this->attachs);
	}
}
?>