<?php
/**
 * 
 * 
 *
 * @author Zhu Dong <zhudong0808@gmail.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: codetemplates(windframework_docs_zend_8.0).xml 2781 2011-09-22 03:59:17Z zhudong $
 * @package wind
 */
class PwAd {
	
	public function getAllAd() {
		return $this->_getPwAdDao ()->getAllAd ();
	}
	
	public function getAdType() {
		return array (
				'1' => 'ȫվͨ',
				'2' => '̳бҳĶҳ',
				'3' => '̳Ķҳ¥',
				'4' => 'ŻƵ',
				'5' => 'ͨ'
		);
	}
	
	public function addAdPosition(PwAdDm $dm) {
		if (($result = $dm->beforeAdd ()) !== true)
			return false;
		return $this->_getPwAdDao ()->addAdPosition ( $dm->getData () );
	}
	
	public function editAdPosition(PwAdDm $dm) {
		if (($result = $dm->beforeUpdate ()) !== true)
			return false;
		return $this->_getPwAdDao ()->editAdPosition ( $dm->pid, $dm->getData () );
	}
	
	public function getByPid($pid) {
		return $this->_getPwAdDao ()->get ( $pid );
	}
	
	public function getByIdentifier($identifier) {
		return $this->_getPwAdDao ()->getByIdentifier ( $identifier );
	}
	
	public function getModes() {
		return array (
				'bbs' => array (
						'name' => '̳',
						'src' => array (
								'announce.index',
								'bbs.thread',
								'bbs.read',
								'default.index',
								'bbs.forum'
						) 
				),
				'space' => array (
						'name' => 'ռ',
						'src' => array (
								'space.index' 
						) 
				),
				'area' => array (
						'name' => 'Ż',
						'src' => array (
								'area.index' 
						) 
				) 
		);
	}
	
	public function getDefaultPosition() {
		return array (
				'Site.NavBanner' => array (
						'name' => 'ͨ',
						'type_id' => '1',
						'width' => '960',
						'height' => '70' 
				),
				'Site.Footer1' => array (
						'name' => 'ײ1',
						'type_id' => '1',
						'width' => '960',
						'height' => '70'
				),
				'Site.Footer2' => array (
						'name' => 'ײ2',
						'type_id' => '1',
						'width' => '960',
						'height' => '70'
				),
				'Site.FloatLeft' => array (
						'name' => '棨',
						'type_id' => '1',
						'width' => '120',
						'height' => '250'
				),
				'Site.FloatRight' => array (
						'name' => '棨ң',
						'type_id' => '1',
						'width' => '120',
						'height' => '250'
				),
				'Site.PopupNotice' => array (
						'name' => '',
						'type_id' => '1',
						'width' => '200',
						'height' => '200'
				),
				'Thread.Top' => array (
						'name' => '̳бҳ',
						'type_id' => '2',
						'width' => '705',
						'height' => '70' 
				),
				'Thread.Btm' => array (
						'name' => '̳бҳ',
						'type_id' => '2',
						'width' => '705',
						'height' => '70' 
				),
				'Read.Layer.TidUp' => array (
						'name' => '¥[Ϸ]',
						'type_id' => '3',
						'width' => '400',
						'height' => '50' 
				),
				'Read.Layer.TidDown' => array (
						'name' => '¥[·]',
						'type_id' => '3',
						'width' => '400',
						'height' => '50' 
				),
				'Read.Layer.TidRight' => array (
						'name' => '¥[Ҳ]',
						'type_id' => '3',
						'width' => '100',
						'height' => '200'
				),
				'Read.Layer.User' => array (
						'name' => '¥[ûϢ·]',
						'type_id' => '3',
						'width' => '100',
						'height' => '100'
				),
				'Read.Layer.TidAmong' => array (
						'name' => '¥[¥м]',
						'type_id' => '3',
						'width' => '960',
						'height' => '70'
				),
				'Site.Sider.User' => array (
						'name' => 'ҲϢ',
						'type_id' => '1',
						'width' => '230',
						'height' => '230'
				),
				'Site.Sider.Btm' => array (
						'name' => 'Ҳײ',
						'type_id' => '1',
						'width' => '230',
						'height' => '230'
				),
				'Common.Topic.Top' => array (
						'name' => 'ҳݾۺ',
						'type_id' => '5',
						'width' => '700',
						'height' => '60'
				),
				'Common.Topic.Btm' => array (
						'name' => 'ҳݾۺ',
						'type_id' => '5',
						'width' => '700',
						'height' => '60'
				),
				'Common.Attention.Btm' => array (
						'name' => 'ҵĹע',
						'type_id' => '1',
						'width' => '700',
						'height' => '60'
				)
		);
	}
	
	public function getPages() {
		return array (
				'bbs.thread' => 'бҳ',
				'bbs.read' => 'Ķҳ' 
		);
	}
	
	private function _getPwAdDao() {
		return Wekit::loadDao ( 'SRV:advertisement.dao.PwAdDao' );
	}
}

?>