<?php
defined('WEKIT_VERSION') || exit('Forbidden');
/**
 * DS
 *
 * @author MingXing Sun <mingxing.sun@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwAnnounce.php 5023 2012-02-28 15:37:02Z mingxing.sun $
 * @package announce
 */

class PwAnnounce {
	
	/**
	 * һϢ
	 * 
	 * @param array $fields
	 * @return int
	 */
	public function addAnnounce(PwAnnounceDm $dm){
	   if (($result = $dm->beforeAdd()) !== true) return $result;
       return $this->_getPwAnnounceDao()->addAnnounce($dm->getData());
	}
	
	/**
	 * ɾһϢ
	 *
	 * @param int $aid
	 * @return boolean
	 */
	public function deleteAnnounce($aid){
		$aid = (int)$aid;
		return $this->_getPwAnnounceDao()->deleteAnnounce($aid);
	}
	
	/**
	 * ɾϢ
	 *
	 * @param array $aids
	 * @return boolean
	 */
	public function batchDeleteAnnounce($aids){
		if(!$aids || !is_array($aids)) return false;
		return $this->_getPwAnnounceDao()->batchDeleteAnnounce($aids);
	}
	
	/**
	 * һϢ
	 * 
	 * @param object PwAnnounceDm
	 * @return boolean
	 */
	public function updateAnnounce(PwAnnounceDm $dm){
		if (($result = $dm->beforeUpdate()) !== true) return $result;
		return $this->_getPwAnnounceDao()->updateAnnounce($dm->aid, $dm->getData());
	}
	
	/**
	 * ȡϢ
	 *
	 * @param $limit
	 * @param $offset
	 * @return array
	 */
	public function getAnnounceOrderByVieworder($limit, $offset){
		return $this->_getPwAnnounceDao()->getAnnounceOrderByVieworder($limit, $offset);
	}
	
	/**
	 * ͨʱȡϢ
	 * ҵΪȡڷеĹϢ
	 *
	 * @param $time
	 * @param $offset
	 * @param $limit
	 * @return array
	 */
	public function getAnnounceByTimeOrderByVieworder($time, $limit, $offset){
		$time = (int)$time;
		return $this->_getPwAnnounceDao()->getAnnounceByTimeOrderByVieworder($time, $limit, $offset);
	}
	
	/**
	 * ȡ
	 *
	 * @return int
	 */
	public function countAnnounce(){
		return $this->_getPwAnnounceDao()->countAnnounce();
	}
	
	/**
	 * ȡĳһʱڵĹ
	 * ҵΪȡйֵ
	 *
	 * @param int $time
	 * @return int
	 */
	public function countAnnounceByTime($time){
		$time = (int)$time;
		return $this->_getPwAnnounceDao()->countAnnounceByTime($time);
	}
	
	/**
	 * ȡһϢ
	 *
	 * @param int $aid
	 * @return array
	 */
	public function getAnnounce($aid){
		if($aid < 1)return array();
		$aid = (int)$aid;
		return $this->_getPwAnnounceDao()->getAnnounce($aid);
	}
	
	/**
	 * ȡDAO
	 * @return PwAnnounceDao
	 */
	protected function _getPwAnnounceDao() {
		return Wekit::loadDao('announce.dao.PwAnnounceDao');
	}
}