<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * dao
 *
 * @author MingXing Sun <mingxing.sun@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwAnnounceDao.php 5140 2012-02-29 08:21:33Z mingxing.sun $
 * @package announce
 */

class PwAnnounceDao extends PwBaseDao {
	
	protected $_table = 'announce';
	protected $_pk = 'aid';
	protected $_dataStruct = array('aid', 'vieworder', 'created_userid', 'typeid', 'url', 'subject', 'content', 'start_date', 'end_date');
	
	/**
	 * һϢ
	 * 
	 * @param array $fields
	 * @return int
	 */
	public function addAnnounce($fields){
		return $this->_add($fields);
	}
	
	/**
	 * ɾһϢ
	 *
	 * @param int $aid
	 * @return boolean
	 */
	public function deleteAnnounce($aid){
		return $this->_delete($aid);
	}
	
	/**
	 * ɾϢ
	 *
	 * @param array $aids
	 * @return boolean
	 */
	public function batchDeleteAnnounce($aids){
        return $this->_batchDelete($aids);
	}
	
	/**
	 * һϢ
	 * @param int $aid
	 * @param array $fields
	 * @return boolean
	 */
	public function updateAnnounce($aid, $fields){
		return $this->_update($aid, $fields);
	}
	
	/**
	 * ȡϢ
	 *
	 * @param $offset
	 * @param $limit
	 * @return array
	 */
	public function getAnnounceOrderByVieworder($limit, $offset){
		$sql = $this->_bindSql('SELECT * FROM %s ORDER BY vieworder ASC %s' ,$this->getTable(),$this->sqlLimit($limit, $offset));
		$smt = $this->getConnection()->query($sql);
		return $smt->fetchAll('aid');
	}
	
	/**
	 * ͨʱȡϢ
	 * ҵΪȡڷеĹϢ
	 *
	 * @param $time
	 * @param $offset
	 * @param $limit
	 * @return array
	 */
	public function getAnnounceByTimeOrderByVieworder($time, $limit, $offset){
		$sql = $this->_bindSql('SELECT * FROM %s WHERE start_date <= ? AND end_date >= ? ORDER BY vieworder ASC %s' ,$this->getTable(),$this->sqlLimit($limit, $offset));
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->queryAll(array($time, $time), 'aid');
	}
	
	
	/**
	 * ȡ
	 *
	 * @return int
	 */
	public function countAnnounce(){
		$sql = $this->_bindSql ( "SELECT COUNT(*) as count FROM %s ", $this->getTable());
		$smt = $this->getConnection()->query($sql);
		return $smt->fetchColumn();	
	}
	
	/**
	 * ȡĳһʱڵĹ
	 * ҵΪȡйֵ
	 *
	 * @param int $time
	 * @return int
	 */
	public function countAnnounceByTime($time){
		$sql = $this->_bindSql ( "SELECT COUNT(*) as count FROM %s WHERE start_date <= ? AND end_date >= ? ", $this->getTable());
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getValue(array($time, $time));
	}
	
	/**
	 * ȡһϢ
	 * 
	 * @param int $aid
	 * @return array
	 */
	public function getAnnounce($aid){
		return $this->_get($aid);
	}
	
}