<?php
defined('WEKIT_VERSION') || exit('Forbidden');
Wind::import('LIB:base.PwBaseDm');

/**
 * ģ
 *
 * @author MingXing Sun <mingxing.sun@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwAnnounceDm.php 2781 01:42:16Z mingxing.sun $
 * @package wind
 */
class PwAnnounceDm extends PwBaseDm {
	public $aid = 0;
	public $_data = array();

	public function __construct($aid = 0) {
		$this->aid = $aid;
	}

	/**
	 * ˳
	 *
	 * @param int ʾ˳
	 * @return object
	 */
	public function setVieworder($vieworder) {
		$this->_data['vieworder'] = (int) $vieworder;
		return $this;
	}

	/**
	 * ûID
	 * 
	 * @param int $uid
	 * @return object
	 */
	public function setUid($uid) {
		$this->_data['created_userid'] = (int) $uid;
		return $this;
	}

	/**
	 * ùID 0Ϊֹ  1Ϊӹ
	 *
	 * @param int $typeid
	 * @return object
	 */
	public function setTypeid($typeid) {
		$this->_data['typeid'] = (int) $typeid;
		return $this;
	}

	/**
	 * ùӵַ
	 *
	 * @param string $url
	 * @return object
	 */
	public function setUrl($url) {
		$this->_data['url'] = $url;
		return $this;
	}

	/**
	 * ù
	 *
	 * @param string $subject
	 * @return object
	 */
	public function setSubject($subject) {
		$this->_data['subject'] = $subject;
		return $this;
	}

	/**
	 * ù
	 *
	 * @param string $content
	 * @return object
	 */
	public function setContent($content) {
		$this->_data['content'] = $content;
		return $this;
	}

	/**
	 * ù淢ʱ
	 *
	 * @param int $startDate
	 * @return object
	 */
	public function setStartDate($startDate) {
		$time = $startDate ? Pw::str2time($startDate) : Pw::str2time(Pw::time2str(Pw::getTime(), 'Y-m-d'));
		$this->_data['start_date'] = (int)$time;
		return $this;
	}

	/**
	 * ùʱ
	 *
	 * @param int $endDate
	 * @return object
	 */
	public function setEndDate($endDate) {
		$time = $endDate ? Pw::str2time($endDate) : 9999999999;
		$this->_data['end_date'] = (int)$time;
		return $this;
	}

	/**
	 * Ԥ
	 * 
	 * @return boolean
	 */
	public function _beforeUpdate() {
		if ($this->_data['start_date'] && $this->_data['end_date'] && ($this->_data['end_date'] < $this->_data['start_date'])) {
			return new PwError('ANNOUNCE:date.error');
		}
		if (isset($this->_data['subject']) && !$this->_data['subject']) {
			return new PwError('ANNOUNCE:subject.require');
		}
		if (isset($this->_data['typeid'])) {
			if ($this->_data['typeid'] == 0 && isset($this->_data['content']) && !$this->_data['content']) {
				return new PwError('ANNOUNCE:content.require');
			}
			if ($this->_data['typeid'] == 1 && isset($this->_data['url']) && !$this->_data['url']) {
				return new PwError('ANNOUNCE:url.require');
			}
		} else {
			unset($this->_data['content'], $this->_data['url']);
		}
		return true;
	}

	/**
	  * ǰԤ
	  *
	  * @return boolean
	  */
	public function _beforeAdd() {
		if ($this->_data['start_date'] && $this->_data['end_date'] && ($this->_data['end_date'] < $this->_data['start_date'])) {
			return new PwError('ANNOUNCE:date.error');
		}
		if (!isset($this->_data['subject']) || !$this->_data['subject']) {
			return new PwError('ANNOUNCE:subject.require');
		}
		if (!isset($this->_data['typeid'])) {
			return new PwError('ANNOUNCE:typeid,require');
		}
		if ($this->_data['typeid'] == 0 && !$this->getField('content')) {
			return new PwError('ANNOUNCE:content.require');
		}
		if ($this->_data['typeid'] == 1 && !$this->getField('url')) {
			return new PwError('ANNOUNCE:url.require');
		}
		return true;
	}
}
?>