<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * Ӹ
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwThreadAttach.php 24314 2013-01-28 08:09:53Z jieyin $
 * @package attach
 */

class PwThreadAttach {
	
	/**
	 * ȡһϢ
	 *
	 * @param int $aid
	 * @return array
	 */
	public function getAttach($aid) {
		if (empty($aid)) return array();
		return $this->_getDao()->getAttach($aid);
	}
	
	/**
	 * ȡϢ
	 *
	 * @param array $aids
	 * @return array
	 */
	public function fetchAttach($aids) {
		if (empty($aids) || !is_array($aids)) return array();
		return $this->_getDao()->fetchAttach($aids);
	}
	
	/**
	 * ȡ(A)лظ(B)еĸϢ
	 *
	 * @param int $tid (A)
	 * @param array $pids ظ(B)
	 * @return array
	 */
	public function getAttachByTid($tid, $pids) {
		if (!$tid || !$pids) return array();
		return $this->_getDao()->getAttachByTid($tid, (array)$pids);
	}
	
	/**
	 * ȡûʱȡĸ
	 *
	 * @param int $userid
	 * @return array
	 */
	public function getTmpAttachByUserid($userid) {
		return $this->_getDao()->getTmpAttachByUserid($userid);
	}
	
	/**
	 * ͳĳ͵ĸĸ
	 *
	 * @param int $tid id
	 * @param int $pid ظid
	 * @param string $type 
	 * @return int
	 */
	public function countType($tid, $pid, $type) {
		return $this->_getDao()->countType($tid, $pid, $type);
	}
	
	/**
	 * ȡtidµи
	 *
	 * @param array tids
	 * @return array
	 */
	public function fetchAttachByTid($tids) {
		if (!$tids || !is_array($tids)) {
			return array();
		}
		return $this->_getDao()->fetchAttachByTid($tids);
	}

	/**
	 * ָtid,pid,ȡ
	 *
	 * @param array tids
	 * @param array pids
	 * @return array
	 */
	public function fetchAttachByTidAndPid($tids, $pids) {
		if (!$tids || !$pids || !is_array($tids) || !is_array($pids)) {
			return array();
		}
		return $this->_getDao()->fetchAttachByTidAndPid($tids, $pids);
	}
	
	/**
	 * ȡеָ¥ĸϢ
	 *
	 * @param array $tids 
	 * @param int $pid ָ¥
	 * @return array
	 */
	public function fetchAttachByTidsAndPid($tids, $pid = 0) {
		if (empty($tids) || !is_array($tids)) return array();
		$pid = intval($pid);
		return $this->_getDao()->fetchAttachByTidsAndPid($tids, $pid);
	}
	
	/**
	 * һ
	 *
	 * @param PwThreadAttachDm $dm
	 * @return bool|PwError
	 */
	public function addAttach(PwThreadAttachDm $dm) {
		if (($result = $dm->beforeAdd()) !== true) {
			return $result;
		}
		if (($result = $this->_getAttach()->addAttach($dm)) instanceof PwError) {
			return $result;
		}
		$dm->setAid($result);
		$this->_getDao()->addAttach($dm->getData());
		return $result;
	}
	
	/**
	 * ¸Ϣ
	 *
	 * @param PwThreadAttachDm $dm
	 * @return bool
	 */
	public function updateAttach(PwThreadAttachDm $dm) {
		if (($result = $dm->beforeUpdate()) !== true) {
			return $result;
		}
		if (($result = $this->_getAttach()->updateAttach($dm)) instanceof PwError) {
			return $result;
		}
		return $this->_getDao()->updateAttach($dm->aid, $dm->getData(), $dm->getIncreaseData());
	}

	public function updateFid($fid, $tofid) {
		return $this->_getDao()->updateFid($fid, $tofid);
	}
	
	/**
	 * ¸Ϣ
	 *
	 * @param array $aids
	 * @param PwThreadAttachDm $dm
	 * @return bool
	 */
	public function batchUpdateAttach($aids, PwThreadAttachDm $dm) {
		if (!$aids || !is_array($aids)) return false;
		if (($result = $dm->beforeUpdate()) !== true) {
			return $result;
		}
		if (($result = $this->_getAttach()->batchUpdateAttach($aids, $dm)) instanceof PwError) {
			return $result;
		}
		return $this->_getDao()->batchUpdateAttach($aids, $dm->getData(), $dm->getIncreaseData());
	}
	
	/**
	 * ¶ӵ
	 *
	 * @param array $tids
	 * @param int $fid
	 * @return bool
	 */
	public function batchUpdateFidByTid($tids, $fid) {
		if (!$tids || !is_array($tids)) return false;
		return $this->_getDao()->batchUpdateFidByTid($tids, $fid);
	}

	/**
	 * ɾ
	 *
	 * @param int $aid
	 * @return bool
	 */
	public function deleteAttach($aid) {
		$this->_getAttach()->deleteAttach($aid);
		return $this->_getDao()->deleteAttach($aid);
	}

	/**
	 * ɾ
	 *
	 * @param array $aids
	 * @return bool
	 */
	public function batchDeleteAttach($aids) {
		if (!$aids || !is_array($aids)) return false;
		$this->_getAttach()->batchDeleteAttach($aids);
		return $this->_getDao()->batchDeleteAttach($aids);
	}

	protected function _getAttach() {
		return Wekit::load('attach.PwAttach');
	}
	
	/**
	 * 
	 * @return PwThreadAttachDao
	 */
	protected function _getDao() {
		return Wekit::loadDao('attach.dao.PwThreadAttachDao');
	}
}
?>