<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * Ӹ¼ / ds
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package wind
 */
class PwThreadAttachDownload {
	
	/**
	 * ͳƸĳ۶
	 *
	 * @param int $aid id
	 * @return int
	 */
	public function sumCost($aid) {
		if (empty($aid)) return 0;
		return $this->_getDao()->sumCost($aid);
	}

	/**
	 * ȡһ¼
	 *
	 * @param int $id ¼id
	 * @return array
	 */
	public function get($id) {
		if (empty($id)) return array();
		return $this->_getDao()->get($id);
	}

	/**
	 * ȡĳй¼
	 *
	 * @param int $aid id
	 * @return bool
	 */
	public function countByAid($aid) {
		if (empty($aid)) return array();
		return $this->_getDao()->countByAid($aid);
	}
	
	/**
	 * ȡĳй¼
	 *
	 * @param int $aid id
	 * @param int $limit ȡб
	 * @param int $offset ȡбʼƫ
	 * @return bool
	 */
	public function getByAid($aid, $limit = 20, $offset = 0) {
		if (empty($aid)) return array();
		return $this->_getDao()->getByAid($aid, $limit, $offset);
	}
	
	/**
	 * ȡ(A)û(B)Ĺ¼
	 *
	 * @param int $aid (A)
	 * @param int $uid û(B)
	 * @return bool
	 */
	public function getByAidAndUid($aid, $uid) {
		if (empty($aid) || empty($uid)) return array();
		return $this->_getDao()->getByAidAndUid($aid, $uid);
	}
	
	/**
	 * һ¼
	 *
	 * @param PwThreadBuyDm $dm ӹ¼ģ
	 * return mixed
	 */
	public function add(PwThreadAttachBuyDm $dm) {
		if (($result = $dm->beforeAdd()) !== true) {
			return $result;
		}
		return $this->_getDao()->add($dm->getData());
	}

	/**
	 * Enter description here ...
	 *
	 * @return PwThreadAttachDownloadDao
	 */
	protected function _getDao() {
		return Wekit::loadDao('attach.dao.PwThreadAttachDownloadDao');
	}
}