<?php

/**
 * ûעݷ
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwAttention.php 16021 2012-08-17 07:18:15Z jinlong.panjl $
 * @package src.service.user
 */

class PwAttention {
	
	/**
	 * û(A)Ƿѹעû(B)
	 *
	 * @param int $uid ûA
	 * @param int $touid ûB
	 * @return bool
	 */
	public function isFollowed($uid, $touid) {
		if (!$uid || !$touid) return false;
		$result = $this->_getDao()->get($uid, $touid);
		return !empty($result);
	}
	
	/**
	 * ȡûķ˿
	 *
	 * @param int $uid ûid
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function getFans($uid, $limit = 20, $offset = 0) {
		if (!$uid) return array();
		return $this->_getDao()->getFans($uid, $limit, $offset);
	}
	
	/**
	 * ȡû(A)ָidķ˿
	 *
	 * @param int $uid ûA
	 * @param array $touids
	 * @return array
	 */
	public function fetchFans($uid, $touids) {
		if (!$uid || !$touids || !is_array($touids)) return array();
		return $this->_getDao()->fetchFans($uid, $touids);
	}
	
	/**
	 * ҳȡûuidsеķ˿
	 *
	 * @param array $uids
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function fetchFansByUids($uids, $limit = 20, $offset = 0) {
		if (!$uids || !is_array($uids)) return array();
		return $this->_getDao()->fetchFansByUids($uids, $limit, $offset);
	}
	
	/**
	 * ȡûע
	 *
	 * @param int $uid ûid
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function getFollows($uid, $limit = 20, $offset = 0){
		if (!$uid) return array();
		return $this->_getDao()->getFollows($uid, $limit, $offset);
	}
	
	/**
	 * ȡû(A)ָidĹע
	 *
	 * @param int $uid ûA
	 * @param array $touids
	 * @return array
	 */
	public function fetchFollows($uid, $touids) {
		if (!$uid || !$touids || !is_array($touids)) return array();
		return $this->_getDao()->fetchFollows($uid, $touids);
	}

	/**
	 * ͳû(A)עֹעû(B)û
	 *
	 * @param int $uid ûA
	 * @param int $touid ûB
	 * @return int
	 */
	public function countFollowToFollow($uid, $touid) {
		if (!$uid || !$touid) return 0;
		return $this->_getDao()->countFollowToFollow($uid, $touid);
	}

	/**
	 * ȡû(A)עֹעû(B)û
	 *
	 * @param int $uid ûA
	 * @param int $touid ûB
	 * @param int $limit
	 * @return array
	 */
	public function getFollowToFollow($uid, $touid, $limit = 3) {
		if (!$uid || !$touid) return array();
		return $this->_getDao()->getFollowToFollow($uid, $touid, $limit);
	}
	
	/**
	 * û(A)עû(B)
	 * עӿֻǵݲһעݣ漰ҵʹýӿ PwAttentionService.addFollow
	 *
	 * @param int $uid ûA
	 * @param int $touid ûB
	 * @return bool| object PwError()
	 */
	public function addFollow($uid, $touid) {
		if (!$uid || !$touid) return new PwError('USER:attention.add.fail');
		if ($uid == $touid) return new PwError('USER:attention.add.self');
		if ($this->isFollowed($uid, $touid)) return new PwError('USER:attention.add.isFollowed');
		return $this->_getDao()->add(array(
			'uid' => $uid,
			'touid' => $touid,
			'created_time' => Pw::getTime()
		));
	}
	
	/**
	 * û(A)ȡ˶û(B)ע
	 * עӿֻǵݲɾһעݣ漰ҵʹýӿ PwAttentionService.deleteFollow
	 *
	 * @param int $uid ûA
	 * @param int $touid ûB
	 * @return bool| object PwError()
	 */
	public function deleteFollow($uid, $touid) {
		if (!$uid || !$touid) return false;
		if (!$this->isFollowed($uid, $touid)) return new PwError('USER:attention.del.fail');
		return $this->_getDao()->delete($uid, $touid);
	}

	public function getFriendsByUid($uid){
		$uid = intval($uid);
		if ($uid < 1) return false;
		return $this->_getDao()->getFriendsByUid($uid);
	}
	
	public function fetchFriendsByUids($uids){
		if (!$uids || !is_array($uids)) return array();
		return $this->_getDao()->fetchFriendsByUids($uids);
	}
	
	/**
	 * PwAttentionDao
	 * 
	 * @return PwAttentionDao
	 */
	protected function _getDao() {
		return Wekit::loadDao('attention.dao.PwAttentionDao');
	}
}