<?php
defined('WEKIT_VERSION') || exit('Forbidden');

/**
 * »
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwFresh.php 19501 2012-10-15 08:36:20Z jieyin $
 * @package fresh
 */

class PwFresh {
	
	const TYPE_THREAD_TOPIC = 1; //-
	const TYPE_THREAD_REPLY = 2; //-ظ
	const TYPE_WEIBO = 3;
	
	/**
	 * ȡ
	 *
	 * @param int $id id
	 * @return array
	 */
	public function getFresh($id) {
		if (empty($id)) return array();
		return $this->_getDao()->getFresh($id);
	}
	
	/**
	 * ȡ
	 *
	 * @param array $ids id
	 * @return array
	 */
	public function fetchFresh($ids) {
		if (empty($ids) || !is_array($ids)) return array();
		return $this->_getDao()->fetchFresh($ids);

	}
	
	/**
	 * ͳûĿ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countFreshByUid($uid) {
		if (empty($uid)) return 0;
		return $this->_getDao()->countFreshByUid($uid);
	}

	/**
	 * ȡû
	 *
	 * @param int $uid ûid
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function getFreshByUid($uid, $limit = 20, $offset = 0) {
		if (empty($uid)) return array();
		return $this->_getDao()->getFreshByUid($uid, $limit, $offset);
	}
	
	/**
	 * ȡҹע
	 *
	 * @param int $uid ûid
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function getAttentionFresh($uid, $limit = 20, $offset = 0) {
		if (!$fresh = $this->_getRelationDao()->get($uid, $limit, $offset)) {
			return array();
		}
		$fresh_ids = $result = array();
		foreach ($fresh as $value) {
			$fresh_ids[] = $value['fresh_id'];
		}
		$array = $this->_getDao()->fetchFresh($fresh_ids);

		foreach ($fresh_ids as $key => $value) {
			if (isset($array[$value])) $result[$value] = $array[$value];
		}
		return $result;
	}
	
	/**
	 * ͳҹעĿ
	 *
	 * @param int $uid
	 * @return int
	 */
	public function countAttentionFresh($uid) {
		return $this->_getRelationDao()->count($uid);
	}
	
	/**
	 * ͳû(A)עָûбĿ
	 *
	 * @param int $uid û(A)
	 * @param array $uids ָûб
	 * @return int
	 */
	public function countAttentionFreshByUid($uid, $uids) {
		if (empty($uid) || empty($uids) || !is_array($uids)) return 0;
		return $this->_getRelationDao()->countByUid($uid, $uids);
	}

	/**
	 * ȡû(A)עָûб
	 *
	 * @param int $uid û(A)
	 * @param array $uids ָûб
	 * @param int $limit
	 * @param int $offset
	 * @return array
	 */
	public function fetchAttentionFreshByUid($uid, $uids, $limit = 20, $offset = 0) {
		if (empty($uid) || empty($uids) || !is_array($uids)) return array();
		if (!$fresh = $this->_getRelationDao()->fetchAttentionFreshByUid($uid, $uids, $limit, $offset)) {
			return array();
		}
		$fresh_ids = $result = array();
		foreach ($fresh as $value) {
			$fresh_ids[] = $value['fresh_id'];
		}
		$array = $this->_getDao()->fetchFresh($fresh_ids);

		foreach ($fresh_ids as $key => $value) {
			if (isset($array[$value])) $result[$value] = $array[$value];
		}
		return $result;
	}
	
	/**
	 * ȡĳ͵
	 *
	 * @param int $type ԴͣΪ SEND_* еһ
	 * @param int $srcIds ID
	 * @return array
	 */
	public function getFreshByType($type, $srcIds) {
		if (empty($srcIds) || !is_array($srcIds)) return array();
		return $this->_getDao()->getFreshByType($type, $srcIds);
	}
	
	/**
	 * 
	 *
	 * @param int $uid id
	 * @param int $type ԴͣΪ SEND_* еһ
	 * @param int $srcId Դid
	 * @return int
	 */
	public function send($uid, $type, $srcId) {
		if (!$uid || !$srcId) {
			return 0;
		}
		$data = array(
			'type' => $type,
			'src_id' => $srcId,
			'created_userid' => $uid,
			'created_time' => Pw::getTime()
		);
		if (!$freshId = $this->_getDao()->addFresh($data)) {
			return 0;
		}
		$this->_addRelation($uid, $freshId, $type);
		return $freshId;
	}

	/**
	 * ɾ
	 *
	 * @param array $ids ID
	 * @return bool
	 */
	public function batchDelete($ids) {
		if (empty($ids) || !is_array($ids)) return false;
		$this->_getDao()->batchDelete($ids);
		$this->_getRelationDao()->batchDelete($ids);
		return true;
	}

	/**
	 * ɾĳһ
	 *
	 * @param int $type ԴͣΪ SEND_* еһ
	 * @param int $srcIds ID
	 * @return bool
	 */
	public function batchDeleteByType($type, $srcIds) {
		if (!$result = $this->getFreshByType($type, $srcIds)) {
			return false;
		}
		return $this->batchDelete(array_keys($result));
	}
	
	/**
	 * û(A)עУɾû(B)
	 *
	 * @param int $uid û(A)
	 * @param int $fromuid û(B)
	 * @return bool
	 */
	public function deleteAttentionFreshByUid($uid, $fromuid) {
		if (empty($uid) || empty($fromuid)) return false;
		return $this->_getRelationDao()->deleteByUidAndCreatedUid($uid, $fromuid);
	}
	
	/**
	 * ʱһҹע
	 *
	 * @param int $uid ûid
	 * @param int $limit 
	 * @return bool
	 */
	public function deleteAttentionFresh($uid, $limit) {
		return $this->_getRelationDao()->deleteOver($uid, $limit);
	}
	
	/**
	 * ҹעϵ
	 *
	 * @param array $data 
	 * @for example :
	 * $data = array(
	 *   0 => array('uid' => ?, 'fresh_id' => ?, 'type' => ?, 'created_userid' => ?, 'created_time' => ?)
	 *	 1 => array()
	 * )
	 * @return bool
	 */
	public function batchAddRelation($data) {
		if (empty($data) || !is_array($data)) return false;
		return $this->_getRelationDao()->batchAdd($data);
	}

	protected function _addRelation($uid, $freshId, $type) {
		$data = array(
			'uid' => $uid,
			'fresh_id' => $freshId,
			'type' => $type,
			'created_userid' => $uid,
			'created_time' => Pw::getTime()
		);
		$this->_getRelationDao()->addRelation($data); //self
		$this->_getRelationDao()->addRelationByAttention($data); //attention
	}


	protected function _getDao() {
		return Wekit::loadDao('attention.dao.PwFreshDao');
	}

	protected function _getRelationDao() {
		return Wekit::loadDao('attention.dao.PwFreshRelationDao');
	}
}