<?php

Wind::import('SRV:user.dm.PwUserInfoDm');

/**
 * ûע
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwAttentionService.php 22660 2012-12-26 07:45:31Z jinlong.panjl $
 * @package src.service.user.srv
 */
class PwAttentionService {
	
	/**
	 * ȡûеķ(ĬϷ)
	 *
	 * @param int $uid
	 * @return array
	 */
	public function getAllType($uid) {
		$type = array();
		if (!$result = $this->_getTypeDs()->getTypeByUid($uid)) {
			return $type;
		}
		foreach ($result as $key => $value) {
			$type[$key] = $value['name'];
		}
		return $type;
	}
	
	/**
	 * ȡûעûķ
	 *
	 * @param int $uid
	 * @param array $touids
	 * @return array
	 */
	public function getUserType($uid, $touids) {
		$data = array();
		$result = $this->_getTypeDs()->getUserType($uid, $touids);
		foreach ($result as $key => $value) {
			$data[$value['touid']][] = $value['typeid'];
		}
		return $data;
	}

	/**
	 * û(A)עû(B)
	 *
	 * @param int $uid ûA
	 * @param int $touid ûB
	 * @return bool| object PwError()
	 */
	public function addFollow($uid, $touid) {
		if (($result = $this->_getAttention()->addFollow($uid, $touid)) instanceof PwError) {
			return $result;
		}
		$user = $this->_getUser();
		$dm = new PwUserInfoDm($uid);
		$dm->addFollows(1);
		$user->editUser($dm, PwUser::FETCH_DATA);
		$dm = new PwUserInfoDm($touid);
		$dm->addFans(1);
		$user->editUser($dm, PwUser::FETCH_DATA);

		if ($fresh = $this->_getFresh()->getFreshByUid($touid)) {
			$array = array();
			foreach ($fresh as $key => $value) {
				$array[] = array(
					'uid' => $uid,
					'fresh_id' => $value['id'],
					'type' => $value['type'],
					'created_userid' => $value['created_userid'],
					'created_time' => $value['created_time']
				);
			}
			$this->_getFresh()->batchAddRelation($array);
		}

		PwSimpleHook::getInstance('addFollow')->runDo($uid, $touid);
		return true;
	}
	
	/**
	 * û(A)ȡ˶û(B)ע
	 *
	 * @param int $uid ûA
	 * @param int $touid ûB
	 * @return bool| object PwError()
	 */
	public function deleteFollow($uid, $touid) {
		if (($result = $this->_getAttention()->deleteFollow($uid, $touid)) instanceof PwError) {
			return $result;
		}
		$this->_getTypeDs()->deleteUserType($uid, $touid);

		$user = $this->_getUser();
		$dm = new PwUserInfoDm($uid);
		$dm->addFollows(-1);
		$user->editUser($dm, PwUser::FETCH_DATA);

		$dm = new PwUserInfoDm($touid);
		$dm->addFans(-1);
		$user->editUser($dm, PwUser::FETCH_DATA);

		$this->_getFresh()->deleteAttentionFreshByUid($uid, $touid);

		PwSimpleHook::getInstance('deleteFollow')->runDo($uid, $touid);
		return true;
	}
 	
	public function addType($uid, $name) {
		$types = $this->getAllType($uid);
		if (count($types) > 20) {
			return new PwError('USER:attention.type.count.error');
		}
		if (in_array($name, $types)) {
			return new PwError('USER:attention.type.repeat');
		}
		return $this->_getTypeDs()->addType($uid, $name);
	}
	
 	/**
 	 * PwAttention
 	 *
 	 * @return PwAttention
 	 */
	protected function _getAttention() {
		return Wekit::load('attention.PwAttention');
	}

	protected function _getTypeDs() {
		return Wekit::load('attention.PwAttentionType');
	}

	protected function _getFresh() {
		return Wekit::load('attention.PwFresh');
	}
	
	/**
	 *
	 * @return PwAttentionRecommendFriendsService
	 */
	protected function _getRecommendService() {
		return Wekit::load('attention.srv.PwAttentionRecommendFriendsService');
	}
	
 	/**
 	 * PwUser
 	 *
 	 * @return PwUser
 	 */
	protected function _getUser() {
		return Wekit::load('user.PwUser');
	}
}
