<?php

/**
 * ݿⱸݻԭ
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright 2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package wind
 */
class PwBackupDao extends PwBaseDao {
	
	/**
	 * ȡһ
	 * 
	 * @param $table
	 * @return table status string
	 */
	public function getTableStatus($table) {
		$sql = $this->_bindTable("SHOW TABLE STATUS LIKE '%s'", $table);
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array());
	}
	
	/**
	 * ȡ
	 * 
	 * @param $table
	 * @param int $start
	 * @param int $limit 
	 * @return table status string
	 */
	public function getData($table,$limit,$start) {
		$sql = $this->_bindSql('SELECT * FROM `%s` %s ' , $table, $this->sqlLimit($limit,$start));
		$smt = $this->getConnection()->createStatement($sql);
		$result = $smt->queryAll(array(),'',PDO::FETCH_NUM);
		$temp = $array = array();
		foreach ($result as $k => $v) {
			foreach ($v as $kt => $vt) {
				$temp[$kt] = $this->getConnection()->quote($vt);
			}
			$array[$k] = $temp;
		}
		return $array;
	}
	
	/**
	 * ȡֶ
	 * 
	 * @param $table
	 * @return int
	 */
	public function getColumnCount($table) {
		$sql = $this->_bindSql('SELECT * FROM `%s` %s ', $table, $this->sqlLimit(1));
		$smt = $this->getConnection()->query($sql);
		return $smt->columnCount();
	}
	
	/**
	 * ȡcreate table Ϣ
	 * 
	 * @param $table
	 * @return create table string
	 */
	public function getCreateTable($table) {
		$sql = $this->_bindSql('SHOW CREATE TABLE `%s`', $table);
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->getOne(array());
	}
	
	/**
	 * ȡб
	 * 
	 * @return tables
	 */
	public function getTables() {
		$sql = $this->_bindTable('SHOW TABLES');
		$smt = $this->getConnection()->query($sql);
		return $smt->fetchAll();
	}
	
	/**
	 * Ż
	 * 
	 * @param string $tables table1,table2,table3....
	 * @return tables
	 */
	public function optimizeTables($table) {
		$sql = $this->_bindSql('OPTIMIZE TABLE %s', $table);
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->execute(array());
	}
	
	/**
	 * ޸
	 * 
	 * @param string $tables table1,table2,table3....
	 * @return tables
	 */
	public function repairTables($table) {
		$sql = $this->_bindSql('REPAIR TABLE %s EXTENDED', $table);
		$smt = $this->getConnection()->createStatement($sql);
		return $smt->execute(array());
	}
	
	/**
	 * ִSql
	 * 
	 * @return tables
	 */
	public function executeQuery($query) {
		$this->getConnection()->query($query);
		return true;
	}
	
	/**
	 * ȡǰ׺
	 * 
	 * @param $table
	 * @return create table string
	 */
	public function getTablePrefix() {
		return $this->getConnection()->getTablePrefix();
	}
}
?>