<?php
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: PwDesignModelBase.php 25400 2013-03-14 08:35:54Z gao.wanggao $ 
 * 
 * @package 
 */
abstract class PwDesignModelBase {
	protected $_data = array();
	protected $_moduleBo;
	private $_viewSet =array();
	
	/**
	 * ûȡ
	 * @param array $field ܵĲѯ
	 * @param int $order
	 * @param int $limit
	 * @param int $offset
	 * 
	 * @return array
	 */
	abstract protected function getData($param, $order, $limit, $offset);

	/**
	 * ģӶ
	 * @param string $model
	 * 
	 * @return array
	 */
	abstract public function decorateAddProperty($model);
	
	/**
	 * ģ޸Ķ
	 * @param string $model
	 * 
	 * @return array
	 */
	abstract public function decorateEditProperty($moduleBo);
	
	/**
	 * ʱĶ޸
	 * Enter description here ...
	 * @param array $property
	 */
	public function decorateSaveProperty($property, $moduleid) {
		return $property;
	}
	
	final public function buildAutoData($field, $order, $limit, $offset) {
		$this->_data = $this->getData($field, $order, $limit, $offset);
		return $this->_formatData();
	}
	
	final public function buildDataByIds($ids) {
		$this->_data = $this->fetchData($ids);
		return $this->_formatData();
	}
	
	public function setModuleBo(PwDesignModuleBo $moduleBo) {
		$this->_moduleBo = $moduleBo;
		$this->_viewSet = $moduleBo->getView();
	}
	
	/**
	 * ڶ͵չ
	 * @param array $ids
	 */
	protected function fetchData($ids) {
		return array();
	}

	/**
	 * ʽʱ
	 * @param int $time
	 */	
	final protected function _formatTime($time) {
		if (!$time) return '';
		return $this->_viewSet['timefmt'] ? Pw::time2str($time, $this->_viewSet['timefmt']) : Pw::time2str($time,'auto');
	}
	
	/**
	 * ʽ
	 * @param string $string
	 */	
	final protected function _formatTitle($string) {
		if (!$string) return '';
		return $this->_viewSet['titlenum'] > 0 ? Pw::substrs($string,$this->_viewSet['titlenum']) : $string;
	}
	
	/**
	 * ʽ
	 * @param string $time
	 */	
	final protected function _formatDes($string) {
		$string = Pw::stripWindCode($string);
		$string =  preg_replace("/\r\n|\n|\r/", '', $string);
		$string =  str_replace(' ', '', $string);
		return $this->_viewSet['desnum'] > 0 ? Pw::substrs($string,$this->_viewSet['desnum']) : $string;
	}
	
	private function _formatData() {
		$_tmp = $_data = array();
		Wind::import('SRV:design.bo.PwDesignModelBo');
		$bo = new PwDesignModelBo($this->_moduleBo->getModel());
		$signKeys = $bo->getSignKeys();
		$standard = $bo->getStandardSign();
		foreach ($standard AS &$v) {
			$v = $this->_transformSign($v);
		}
		foreach ($this->_data AS $data){
			foreach ($signKeys AS $signKey) {
				list($sign, $name, $key) = $signKey;
				if (!$sign = $this->_transformSign($sign)) continue;
				if (isset($data[$key])) $_data[$sign] = $data[$key];
			}
			$_data['standard_title'] = $_data[$standard['sTitle']];
			$_data['standard_fromid'] = $_data[$standard['sFromId']];
			$_data['standard_fromapp'] = $this->_moduleBo->getModel();
			$_data['standard_style'] = $data['__style'];
			$_data['standard'] = $standard;
			$_tmp[] = $_data;
		}
		return $_tmp;
	}
	
	/**
	 * Եǩнkeyת
	 * Enter description here ...
	 * @param unknown_type $sign
	 */
	private function _transformSign($sign) {
		if(preg_match_all('/\{(\w+)\|(.+)}/U', $sign, $matche)) {// ԶԪǩkey
			foreach ($matche[1] AS $k=>$v) {
    			return str_replace($matche[0][$k], $v, $sign);
    		}
		}
		if(!preg_match('/\{(\w+)}/isU', $sign, $matches)) return false;
		return $matches[1];
	}
}
?>